// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkehub/v1alpha2/membership.proto

package gkehub

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the infrastructure type of a Membership. Infrastructure type is
// used by Hub to control infrastructure-specific behavior, including pricing.
//
// Each GKE distribution (on-GCP, on-Prem, on-X,...) will set this field
// automatically, but Attached Clusters customers should specify a type
// during registration.
type Membership_InfrastructureType int32

const (
	// No type was specified. Some Hub functionality may require a type be
	// specified, and will not support Memberships with this value.
	Membership_INFRASTRUCTURE_TYPE_UNSPECIFIED Membership_InfrastructureType = 0
	// Private infrastructure that is owned or operated by customer. This
	// includes GKE distributions such as GKE-OnPrem and GKE-OnBareMetal.
	Membership_ON_PREM Membership_InfrastructureType = 1
	// Public cloud infrastructure.
	Membership_MULTI_CLOUD Membership_InfrastructureType = 2
)

// Enum value maps for Membership_InfrastructureType.
var (
	Membership_InfrastructureType_name = map[int32]string{
		0: "INFRASTRUCTURE_TYPE_UNSPECIFIED",
		1: "ON_PREM",
		2: "MULTI_CLOUD",
	}
	Membership_InfrastructureType_value = map[string]int32{
		"INFRASTRUCTURE_TYPE_UNSPECIFIED": 0,
		"ON_PREM":                         1,
		"MULTI_CLOUD":                     2,
	}
)

func (x Membership_InfrastructureType) Enum() *Membership_InfrastructureType {
	p := new(Membership_InfrastructureType)
	*p = x
	return p
}

func (x Membership_InfrastructureType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Membership_InfrastructureType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_enumTypes[0].Descriptor()
}

func (Membership_InfrastructureType) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha2_membership_proto_enumTypes[0]
}

func (x Membership_InfrastructureType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Membership_InfrastructureType.Descriptor instead.
func (Membership_InfrastructureType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{0, 0}
}

// Code describes the state of a Membership resource.
type MembershipState_Code int32

const (
	// The code is not set.
	MembershipState_CODE_UNSPECIFIED MembershipState_Code = 0
	// The cluster is being registered.
	MembershipState_CREATING MembershipState_Code = 1
	// The cluster is registered.
	MembershipState_READY MembershipState_Code = 2
	// The cluster is being unregistered.
	MembershipState_DELETING MembershipState_Code = 3
	// The Membership is being updated.
	MembershipState_UPDATING MembershipState_Code = 4
	// The Membership is being updated by the Hub Service.
	MembershipState_SERVICE_UPDATING MembershipState_Code = 5
)

// Enum value maps for MembershipState_Code.
var (
	MembershipState_Code_name = map[int32]string{
		0: "CODE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "DELETING",
		4: "UPDATING",
		5: "SERVICE_UPDATING",
	}
	MembershipState_Code_value = map[string]int32{
		"CODE_UNSPECIFIED": 0,
		"CREATING":         1,
		"READY":            2,
		"DELETING":         3,
		"UPDATING":         4,
		"SERVICE_UPDATING": 5,
	}
)

func (x MembershipState_Code) Enum() *MembershipState_Code {
	p := new(MembershipState_Code)
	*p = x
	return p
}

func (x MembershipState_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MembershipState_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_enumTypes[1].Descriptor()
}

func (MembershipState_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1alpha2_membership_proto_enumTypes[1]
}

func (x MembershipState_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MembershipState_Code.Descriptor instead.
func (MembershipState_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{9, 0}
}

// Membership contains information about a member cluster.
type Membership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full, unique name of this Membership resource in the format
	// `projects/*/locations/*/memberships/{membership_id}`, set during creation.
	//
	// `membership_id` must be a valid RFC 1123 compliant DNS label:
	//
	//   1. At most 63 characters in length
	//   2. It must consist of lower case alphanumeric characters or `-`
	//   3. It must start and end with an alphanumeric character
	//
	// Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
	// with a maximum length of 63 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. GCP labels for this membership.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Description of this membership, limited to 63 characters.
	// Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_\-\.\ ]*`
	//
	// This field is present for legacy purposes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Type of resource represented by this Membership
	//
	// Types that are assignable to Type:
	//	*Membership_Endpoint
	Type isMembership_Type `protobuf_oneof:"type"`
	// Output only. State of the Membership resource.
	State *MembershipState `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	// Output only. When the Membership was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. When the Membership was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. When the Membership was deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Optional. An externally-generated and managed ID for this Membership. This ID may
	// be modified after creation, but this is not recommended. For GKE clusters,
	// external_id is managed by the Hub API and updates will be ignored.
	//
	// The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_\-\.]*`
	//
	// If this Membership represents a Kubernetes cluster, this value should be
	// set to the UID of the `kube-system` namespace object.
	ExternalId string `protobuf:"bytes,9,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Optional. How to identify workloads from this Membership.
	// See the documentation on Workload Identity for more details:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
	Authority *Authority `protobuf:"bytes,10,opt,name=authority,proto3" json:"authority,omitempty"`
	// Output only. For clusters using Connect, the timestamp of the most recent connection
	// established with Google Cloud. This time is updated every several minutes,
	// not continuously. For clusters that do not use GKE Connect, or that have
	// never connected successfully, this field will be unset.
	LastConnectionTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=last_connection_time,json=lastConnectionTime,proto3" json:"last_connection_time,omitempty"`
	// Output only. Google-generated UUID for this resource. This is unique across all
	// Membership resources. If a Membership resource is deleted and another
	// resource with the same name is created, it gets a different unique_id.
	UniqueId string `protobuf:"bytes,12,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// Optional. The infrastructure type this Membership is running on.
	InfrastructureType Membership_InfrastructureType `protobuf:"varint,13,opt,name=infrastructure_type,json=infrastructureType,proto3,enum=google.cloud.gkehub.v1alpha2.Membership_InfrastructureType" json:"infrastructure_type,omitempty"`
}

func (x *Membership) Reset() {
	*x = Membership{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Membership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Membership) ProtoMessage() {}

func (x *Membership) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Membership.ProtoReflect.Descriptor instead.
func (*Membership) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{0}
}

func (x *Membership) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Membership) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Membership) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Membership) GetType() isMembership_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Membership) GetEndpoint() *MembershipEndpoint {
	if x, ok := x.GetType().(*Membership_Endpoint); ok {
		return x.Endpoint
	}
	return nil
}

func (x *Membership) GetState() *MembershipState {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *Membership) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Membership) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Membership) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Membership) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

func (x *Membership) GetAuthority() *Authority {
	if x != nil {
		return x.Authority
	}
	return nil
}

func (x *Membership) GetLastConnectionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastConnectionTime
	}
	return nil
}

func (x *Membership) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *Membership) GetInfrastructureType() Membership_InfrastructureType {
	if x != nil {
		return x.InfrastructureType
	}
	return Membership_INFRASTRUCTURE_TYPE_UNSPECIFIED
}

type isMembership_Type interface {
	isMembership_Type()
}

type Membership_Endpoint struct {
	// Optional. Endpoint information to reach this member.
	Endpoint *MembershipEndpoint `protobuf:"bytes,4,opt,name=endpoint,proto3,oneof"`
}

func (*Membership_Endpoint) isMembership_Type() {}

// MembershipEndpoint contains information needed to contact a Kubernetes API,
// endpoint and any additional Kubernetes metadata.
type MembershipEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cluster information of the registered cluster.
	//
	// Types that are assignable to Type:
	//	*MembershipEndpoint_GkeCluster
	//	*MembershipEndpoint_OnPremCluster
	//	*MembershipEndpoint_MultiCloudCluster
	Type isMembershipEndpoint_Type `protobuf_oneof:"type"`
	// Output only. Useful Kubernetes-specific metadata.
	KubernetesMetadata *KubernetesMetadata `protobuf:"bytes,2,opt,name=kubernetes_metadata,json=kubernetesMetadata,proto3" json:"kubernetes_metadata,omitempty"`
	// Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
	// registered cluster, in the steady state. These resources:
	//
	//   * Ensure that the cluster is exclusively registered to one and only one
	//     Hub Membership.
	//   * Propagate Workload Pool Information available in the Membership
	//     Authority field.
	//   * Ensure proper initial configuration of default Hub Features.
	KubernetesResource *KubernetesResource `protobuf:"bytes,3,opt,name=kubernetes_resource,json=kubernetesResource,proto3" json:"kubernetes_resource,omitempty"`
}

func (x *MembershipEndpoint) Reset() {
	*x = MembershipEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipEndpoint) ProtoMessage() {}

func (x *MembershipEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipEndpoint.ProtoReflect.Descriptor instead.
func (*MembershipEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{1}
}

func (m *MembershipEndpoint) GetType() isMembershipEndpoint_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *MembershipEndpoint) GetGkeCluster() *GkeCluster {
	if x, ok := x.GetType().(*MembershipEndpoint_GkeCluster); ok {
		return x.GkeCluster
	}
	return nil
}

func (x *MembershipEndpoint) GetOnPremCluster() *OnPremCluster {
	if x, ok := x.GetType().(*MembershipEndpoint_OnPremCluster); ok {
		return x.OnPremCluster
	}
	return nil
}

func (x *MembershipEndpoint) GetMultiCloudCluster() *MultiCloudCluster {
	if x, ok := x.GetType().(*MembershipEndpoint_MultiCloudCluster); ok {
		return x.MultiCloudCluster
	}
	return nil
}

func (x *MembershipEndpoint) GetKubernetesMetadata() *KubernetesMetadata {
	if x != nil {
		return x.KubernetesMetadata
	}
	return nil
}

func (x *MembershipEndpoint) GetKubernetesResource() *KubernetesResource {
	if x != nil {
		return x.KubernetesResource
	}
	return nil
}

type isMembershipEndpoint_Type interface {
	isMembershipEndpoint_Type()
}

type MembershipEndpoint_GkeCluster struct {
	// Optional. Specific information for a GKE-on-GCP cluster.
	GkeCluster *GkeCluster `protobuf:"bytes,1,opt,name=gke_cluster,json=gkeCluster,proto3,oneof"`
}

type MembershipEndpoint_OnPremCluster struct {
	// Optional. Specific information for a GKE On-Prem cluster.
	OnPremCluster *OnPremCluster `protobuf:"bytes,4,opt,name=on_prem_cluster,json=onPremCluster,proto3,oneof"`
}

type MembershipEndpoint_MultiCloudCluster struct {
	// Optional. Specific information for a GKE Multi-Cloud cluster.
	MultiCloudCluster *MultiCloudCluster `protobuf:"bytes,5,opt,name=multi_cloud_cluster,json=multiCloudCluster,proto3,oneof"`
}

func (*MembershipEndpoint_GkeCluster) isMembershipEndpoint_Type() {}

func (*MembershipEndpoint_OnPremCluster) isMembershipEndpoint_Type() {}

func (*MembershipEndpoint_MultiCloudCluster) isMembershipEndpoint_Type() {}

// KubernetesResource contains the YAML manifests and configuration for
// Membership Kubernetes resources in the cluster. After CreateMembership or
// UpdateMembership, these resources should be re-applied in the cluster.
type KubernetesResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. The YAML representation of the Membership CR. This field is ignored for GKE
	// clusters where Hub can read the CR directly.
	//
	// Callers should provide the CR that is currently present in the cluster
	// during Create or Update, or leave this field empty if none exists. The CR
	// manifest is used to validate the cluster has not been registered with
	// another Membership.
	MembershipCrManifest string `protobuf:"bytes,1,opt,name=membership_cr_manifest,json=membershipCrManifest,proto3" json:"membership_cr_manifest,omitempty"`
	// Output only. Additional Kubernetes resources that need to be applied to the cluster
	// after Membership creation, and after every update.
	//
	// This field is only populated in the Membership returned from a successful
	// long-running operation from CreateMembership or UpdateMembership. It is not
	// populated during normal GetMembership or ListMemberships requests. To get
	// the resource manifest after the initial registration, the caller should
	// make a UpdateMembership call with an empty field mask.
	MembershipResources []*ResourceManifest `protobuf:"bytes,3,rep,name=membership_resources,json=membershipResources,proto3" json:"membership_resources,omitempty"`
	// Output only. The Kubernetes resources for installing the GKE Connect agent.
	//
	// This field is only populated in the Membership returned from a successful
	// long-running operation from CreateMembership or UpdateMembership. It is not
	// populated during normal GetMembership or ListMemberships requests. To get
	// the resource manifest after the initial registration, the caller should
	// make a UpdateMembership call with an empty field mask.
	ConnectResources []*ResourceManifest `protobuf:"bytes,4,rep,name=connect_resources,json=connectResources,proto3" json:"connect_resources,omitempty"`
	// Optional. Options for Kubernetes resource generation.
	ResourceOptions *ResourceOptions `protobuf:"bytes,5,opt,name=resource_options,json=resourceOptions,proto3" json:"resource_options,omitempty"`
}

func (x *KubernetesResource) Reset() {
	*x = KubernetesResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesResource) ProtoMessage() {}

func (x *KubernetesResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesResource.ProtoReflect.Descriptor instead.
func (*KubernetesResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{2}
}

func (x *KubernetesResource) GetMembershipCrManifest() string {
	if x != nil {
		return x.MembershipCrManifest
	}
	return ""
}

func (x *KubernetesResource) GetMembershipResources() []*ResourceManifest {
	if x != nil {
		return x.MembershipResources
	}
	return nil
}

func (x *KubernetesResource) GetConnectResources() []*ResourceManifest {
	if x != nil {
		return x.ConnectResources
	}
	return nil
}

func (x *KubernetesResource) GetResourceOptions() *ResourceOptions {
	if x != nil {
		return x.ResourceOptions
	}
	return nil
}

// ResourceOptions represent options for Kubernetes resource generation.
type ResourceOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Connect agent version to use for connect_resources. Defaults to the
	// latest GKE Connect version. The version must be a currently supported
	// version, obsolete versions will be rejected.
	ConnectVersion string `protobuf:"bytes,1,opt,name=connect_version,json=connectVersion,proto3" json:"connect_version,omitempty"`
	// Optional. Use `apiextensions/v1beta1` instead of `apiextensions/v1` for
	// CustomResourceDefinition resources.
	// This option should be set for clusters with Kubernetes apiserver versions
	// <1.16.
	V1Beta1Crd bool `protobuf:"varint,2,opt,name=v1beta1_crd,json=v1beta1Crd,proto3" json:"v1beta1_crd,omitempty"`
	// Major version of the Kubernetes cluster. This is only used to determine
	// which version to use for the CustomResourceDefinition resources,
	// `apiextensions/v1beta1` or`apiextensions/v1`.
	K8SVersion string `protobuf:"bytes,3,opt,name=k8s_version,json=k8sVersion,proto3" json:"k8s_version,omitempty"`
}

func (x *ResourceOptions) Reset() {
	*x = ResourceOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions) ProtoMessage() {}

func (x *ResourceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{3}
}

func (x *ResourceOptions) GetConnectVersion() string {
	if x != nil {
		return x.ConnectVersion
	}
	return ""
}

func (x *ResourceOptions) GetV1Beta1Crd() bool {
	if x != nil {
		return x.V1Beta1Crd
	}
	return false
}

func (x *ResourceOptions) GetK8SVersion() string {
	if x != nil {
		return x.K8SVersion
	}
	return ""
}

// GkeCluster contains information specific to GKE clusters.
type GkeCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Self-link of the GCP resource for the GKE cluster. For example:
	//
	//     //container.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster
	//
	// Zonal clusters are also supported.
	ResourceLink string `protobuf:"bytes,1,opt,name=resource_link,json=resourceLink,proto3" json:"resource_link,omitempty"`
	// Output only. If cluster_missing is set then it denotes that the GKE cluster no longer
	// exists in the GKE Control Plane.
	ClusterMissing bool `protobuf:"varint,2,opt,name=cluster_missing,json=clusterMissing,proto3" json:"cluster_missing,omitempty"`
}

func (x *GkeCluster) Reset() {
	*x = GkeCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeCluster) ProtoMessage() {}

func (x *GkeCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeCluster.ProtoReflect.Descriptor instead.
func (*GkeCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{4}
}

func (x *GkeCluster) GetResourceLink() string {
	if x != nil {
		return x.ResourceLink
	}
	return ""
}

func (x *GkeCluster) GetClusterMissing() bool {
	if x != nil {
		return x.ClusterMissing
	}
	return false
}

// OnPremCluster contains information specific to GKE On-Prem clusters.
type OnPremCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Self-link of the GCP resource for the GKE On-Prem cluster. For example:
	//
	//  //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/vmwareClusters/my-cluster
	//  //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/bareMetalClusters/my-cluster
	ResourceLink string `protobuf:"bytes,1,opt,name=resource_link,json=resourceLink,proto3" json:"resource_link,omitempty"`
	// Output only. If cluster_missing is set then it denotes that
	// API(gkeonprem.googleapis.com) resource for this GKE On-Prem cluster no
	// longer exists.
	ClusterMissing bool `protobuf:"varint,2,opt,name=cluster_missing,json=clusterMissing,proto3" json:"cluster_missing,omitempty"`
	// Immutable. Whether the cluster is an admin cluster.
	AdminCluster bool `protobuf:"varint,3,opt,name=admin_cluster,json=adminCluster,proto3" json:"admin_cluster,omitempty"`
}

func (x *OnPremCluster) Reset() {
	*x = OnPremCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnPremCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnPremCluster) ProtoMessage() {}

func (x *OnPremCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnPremCluster.ProtoReflect.Descriptor instead.
func (*OnPremCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{5}
}

func (x *OnPremCluster) GetResourceLink() string {
	if x != nil {
		return x.ResourceLink
	}
	return ""
}

func (x *OnPremCluster) GetClusterMissing() bool {
	if x != nil {
		return x.ClusterMissing
	}
	return false
}

func (x *OnPremCluster) GetAdminCluster() bool {
	if x != nil {
		return x.AdminCluster
	}
	return false
}

// MultiCloudCluster contains information specific to GKE Multi-Cloud clusters.
type MultiCloudCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Self-link of the GCP resource for the GKE Multi-Cloud cluster. For
	// example:
	//
	//  //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/awsClusters/my-cluster
	//  //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/azureClusters/my-cluster
	ResourceLink string `protobuf:"bytes,1,opt,name=resource_link,json=resourceLink,proto3" json:"resource_link,omitempty"`
	// Output only. If cluster_missing is set then it denotes that
	// API(gkemulticloud.googleapis.com) resource for this GKE Multi-Cloud cluster
	// no longer exists.
	ClusterMissing bool `protobuf:"varint,2,opt,name=cluster_missing,json=clusterMissing,proto3" json:"cluster_missing,omitempty"`
}

func (x *MultiCloudCluster) Reset() {
	*x = MultiCloudCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiCloudCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiCloudCluster) ProtoMessage() {}

func (x *MultiCloudCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiCloudCluster.ProtoReflect.Descriptor instead.
func (*MultiCloudCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{6}
}

func (x *MultiCloudCluster) GetResourceLink() string {
	if x != nil {
		return x.ResourceLink
	}
	return ""
}

func (x *MultiCloudCluster) GetClusterMissing() bool {
	if x != nil {
		return x.ClusterMissing
	}
	return false
}

// KubernetesMetadata provides informational metadata for Memberships
// that are created from Kubernetes Endpoints (currently, these are equivalent
// to Kubernetes clusters).
type KubernetesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Kubernetes API server version string as reported by '/version'.
	KubernetesApiServerVersion string `protobuf:"bytes,1,opt,name=kubernetes_api_server_version,json=kubernetesApiServerVersion,proto3" json:"kubernetes_api_server_version,omitempty"`
	// Output only. Node providerID as reported by the first node in the list of nodes on
	// the Kubernetes endpoint. On Kubernetes platforms that support zero-node
	// clusters (like GKE-on-GCP), the node_count will be zero and the
	// node_provider_id will be empty.
	NodeProviderId string `protobuf:"bytes,2,opt,name=node_provider_id,json=nodeProviderId,proto3" json:"node_provider_id,omitempty"`
	// Output only. Node count as reported by Kubernetes nodes resources.
	NodeCount int32 `protobuf:"varint,3,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Output only. vCPU count as reported by Kubernetes nodes resources.
	VcpuCount int32 `protobuf:"varint,4,opt,name=vcpu_count,json=vcpuCount,proto3" json:"vcpu_count,omitempty"`
	// Output only. The total memory capacity as reported by the sum of all Kubernetes nodes
	// resources, defined in MB.
	MemoryMb int32 `protobuf:"varint,5,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// Output only. The time at which these details were last updated. This update_time is
	// different from the Membership-level update_time since EndpointDetails are
	// updated internally for API consumers.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,100,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *KubernetesMetadata) Reset() {
	*x = KubernetesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesMetadata) ProtoMessage() {}

func (x *KubernetesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesMetadata.ProtoReflect.Descriptor instead.
func (*KubernetesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{7}
}

func (x *KubernetesMetadata) GetKubernetesApiServerVersion() string {
	if x != nil {
		return x.KubernetesApiServerVersion
	}
	return ""
}

func (x *KubernetesMetadata) GetNodeProviderId() string {
	if x != nil {
		return x.NodeProviderId
	}
	return ""
}

func (x *KubernetesMetadata) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *KubernetesMetadata) GetVcpuCount() int32 {
	if x != nil {
		return x.VcpuCount
	}
	return 0
}

func (x *KubernetesMetadata) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *KubernetesMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Authority encodes how Google will recognize identities from this Membership.
// See the workload identity documentation for more details:
// https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
type Authority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://` and
	// be a valid URL with length <2000 characters.
	//
	// If set, then Google will allow valid OIDC tokens from this issuer to
	// authenticate within the workload_identity_pool. OIDC discovery will be
	// performed on this URI to validate tokens from the issuer, unless
	// `oidc_jwks` is set.
	//
	// Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
	// modified; it must be cleared (and Workload Identity disabled) before using
	// a new issuer (and re-enabling Workload Identity).
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// Optional. OIDC verification keys for this Membership in JWKS format (RFC 7517).
	//
	// When this field is set, OIDC discovery will NOT be performed on `issuer`,
	// and instead OIDC tokens will be validated using this field.
	OidcJwks []byte `protobuf:"bytes,5,opt,name=oidc_jwks,json=oidcJwks,proto3" json:"oidc_jwks,omitempty"`
	// Output only. An identity provider that reflects the `issuer` in the workload identity
	// pool.
	IdentityProvider string `protobuf:"bytes,3,opt,name=identity_provider,json=identityProvider,proto3" json:"identity_provider,omitempty"`
	// Output only. The name of the workload identity pool in which `issuer` will be
	// recognized.
	//
	// There is a single Workload Identity Pool per Hub that is shared
	// between all Memberships that belong to that Hub. For a Hub hosted in
	// {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
	// although this is subject to change in newer versions of this API.
	WorkloadIdentityPool string `protobuf:"bytes,4,opt,name=workload_identity_pool,json=workloadIdentityPool,proto3" json:"workload_identity_pool,omitempty"`
}

func (x *Authority) Reset() {
	*x = Authority{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Authority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Authority) ProtoMessage() {}

func (x *Authority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Authority.ProtoReflect.Descriptor instead.
func (*Authority) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{8}
}

func (x *Authority) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *Authority) GetOidcJwks() []byte {
	if x != nil {
		return x.OidcJwks
	}
	return nil
}

func (x *Authority) GetIdentityProvider() string {
	if x != nil {
		return x.IdentityProvider
	}
	return ""
}

func (x *Authority) GetWorkloadIdentityPool() string {
	if x != nil {
		return x.WorkloadIdentityPool
	}
	return ""
}

// MembershipState describes the state of a Membership resource.
type MembershipState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The current state of the Membership resource.
	Code MembershipState_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.gkehub.v1alpha2.MembershipState_Code" json:"code,omitempty"`
}

func (x *MembershipState) Reset() {
	*x = MembershipState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipState) ProtoMessage() {}

func (x *MembershipState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipState.ProtoReflect.Descriptor instead.
func (*MembershipState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{9}
}

func (x *MembershipState) GetCode() MembershipState_Code {
	if x != nil {
		return x.Code
	}
	return MembershipState_CODE_UNSPECIFIED
}

// Request message for `GkeHub.ListMemberships` method.
type ListMembershipsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project and location) where the Memberships will be listed.
	// Specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. When requesting a 'page' of resources, `page_size` specifies number of
	// resources to return. If unspecified or set to 0, all resources will
	// be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token returned by previous call to `ListMemberships` which
	// specifies the position in the list from where to continue listing the
	// resources.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists Memberships that match the filter expression, following the syntax
	// outlined in https://google.aip.dev/160.
	//
	// Examples:
	//
	//   - Name is `bar` in project `foo-proj` and location `global`:
	//
	//       name = "projects/foo-proj/locations/global/membership/bar"
	//
	//   - Memberships that have a label called `foo`:
	//
	//       labels.foo:*
	//
	//   - Memberships that have a label called `foo` whose value is `bar`:
	//
	//       labels.foo = bar
	//
	//   - Memberships in the CREATING state:
	//
	//       state = CREATING
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. One or more fields to compare and use to sort the output.
	// See https://google.aip.dev/132#ordering.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListMembershipsRequest) Reset() {
	*x = ListMembershipsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMembershipsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMembershipsRequest) ProtoMessage() {}

func (x *ListMembershipsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMembershipsRequest.ProtoReflect.Descriptor instead.
func (*ListMembershipsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{10}
}

func (x *ListMembershipsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMembershipsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMembershipsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMembershipsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMembershipsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for the `GkeHub.ListMemberships` method.
type ListMembershipsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching Memberships.
	Resources []*Membership `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// A token to request the next page of resources from the
	// `ListMemberships` method. The value of an empty string means that
	// there are no more resources to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of locations that could not be reached while fetching this list.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListMembershipsResponse) Reset() {
	*x = ListMembershipsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMembershipsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMembershipsResponse) ProtoMessage() {}

func (x *ListMembershipsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMembershipsResponse.ProtoReflect.Descriptor instead.
func (*ListMembershipsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{11}
}

func (x *ListMembershipsResponse) GetResources() []*Membership {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ListMembershipsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMembershipsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for `GkeHub.GetMembership` method.
type GetMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Membership resource name in the format
	// `projects/*/locations/*/memberships/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMembershipRequest) Reset() {
	*x = GetMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMembershipRequest) ProtoMessage() {}

func (x *GetMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMembershipRequest.ProtoReflect.Descriptor instead.
func (*GetMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{12}
}

func (x *GetMembershipRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `GkeHub.CreateMembership` method.
type CreateMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent (project and location) where the Memberships will be created.
	// Specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Client chosen ID for the membership. `membership_id` must be a valid RFC
	// 1123 compliant DNS label:
	//
	//   1. At most 63 characters in length
	//   2. It must consist of lower case alphanumeric characters or `-`
	//   3. It must start and end with an alphanumeric character
	//
	// Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
	// with a maximum length of 63 characters.
	MembershipId string `protobuf:"bytes,2,opt,name=membership_id,json=membershipId,proto3" json:"membership_id,omitempty"`
	// Required. The membership to create.
	Resource *Membership `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *CreateMembershipRequest) Reset() {
	*x = CreateMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMembershipRequest) ProtoMessage() {}

func (x *CreateMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMembershipRequest.ProtoReflect.Descriptor instead.
func (*CreateMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{13}
}

func (x *CreateMembershipRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMembershipRequest) GetMembershipId() string {
	if x != nil {
		return x.MembershipId
	}
	return ""
}

func (x *CreateMembershipRequest) GetResource() *Membership {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Request message for `GkeHub.DeleteMembership` method.
type DeleteMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Membership resource name in the format
	// `projects/*/locations/*/memberships/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMembershipRequest) Reset() {
	*x = DeleteMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMembershipRequest) ProtoMessage() {}

func (x *DeleteMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMembershipRequest.ProtoReflect.Descriptor instead.
func (*DeleteMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{14}
}

func (x *DeleteMembershipRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `GkeHub.UpdateMembership` method.
type UpdateMembershipRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Membership resource name in the format
	// `projects/*/locations/*/memberships/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Only fields specified in update_mask are updated.
	// If you specify a field in the update_mask but don't specify its value here
	// that field will be deleted.
	// If you are updating a map field, set the value of a key to null or empty
	// string to delete the key from the map. It's not possible to update a key's
	// value to the empty string.
	// If you specify the update_mask to be a special path "*", fully replaces all
	// user-modifiable fields to match `resource`.
	Resource *Membership `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
}

func (x *UpdateMembershipRequest) Reset() {
	*x = UpdateMembershipRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMembershipRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMembershipRequest) ProtoMessage() {}

func (x *UpdateMembershipRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMembershipRequest.ProtoReflect.Descriptor instead.
func (*UpdateMembershipRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateMembershipRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateMembershipRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMembershipRequest) GetResource() *Membership {
	if x != nil {
		return x.Resource
	}
	return nil
}

// Request message for `GkeHub.GenerateConnectManifest`
// method.
// .
type GenerateConnectManifestRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Membership resource name the Agent will associate with, in the format
	// `projects/*/locations/*/memberships/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Namespace for GKE Connect agent resources. Defaults to `gke-connect`.
	//
	// The Connect Agent is authorized automatically when run in the default
	// namespace. Otherwise, explicit authorization must be granted with an
	// additional IAM binding.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Optional. URI of a proxy if connectivity from the agent to gkeconnect.googleapis.com
	// requires the use of a proxy. Format must be in the form
	// `http(s)://{proxy_address}`, depending on the HTTP/HTTPS protocol
	// supported by the proxy. This will direct the connect agent's outbound
	// traffic through a HTTP(S) proxy.
	Proxy []byte `protobuf:"bytes,3,opt,name=proxy,proto3" json:"proxy,omitempty"`
	// Optional. The Connect agent version to use. Defaults to the most current version.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. If true, generate the resources for upgrade only. Some resources
	// generated only for installation (e.g. secrets) will be excluded.
	IsUpgrade bool `protobuf:"varint,5,opt,name=is_upgrade,json=isUpgrade,proto3" json:"is_upgrade,omitempty"`
	// Optional. The registry to fetch the connect agent image from. Defaults to
	// gcr.io/gkeconnect.
	Registry string `protobuf:"bytes,6,opt,name=registry,proto3" json:"registry,omitempty"`
	// Optional. The image pull secret content for the registry, if not public.
	ImagePullSecretContent []byte `protobuf:"bytes,7,opt,name=image_pull_secret_content,json=imagePullSecretContent,proto3" json:"image_pull_secret_content,omitempty"`
}

func (x *GenerateConnectManifestRequest) Reset() {
	*x = GenerateConnectManifestRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateConnectManifestRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateConnectManifestRequest) ProtoMessage() {}

func (x *GenerateConnectManifestRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateConnectManifestRequest.ProtoReflect.Descriptor instead.
func (*GenerateConnectManifestRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateConnectManifestRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerateConnectManifestRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *GenerateConnectManifestRequest) GetProxy() []byte {
	if x != nil {
		return x.Proxy
	}
	return nil
}

func (x *GenerateConnectManifestRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GenerateConnectManifestRequest) GetIsUpgrade() bool {
	if x != nil {
		return x.IsUpgrade
	}
	return false
}

func (x *GenerateConnectManifestRequest) GetRegistry() string {
	if x != nil {
		return x.Registry
	}
	return ""
}

func (x *GenerateConnectManifestRequest) GetImagePullSecretContent() []byte {
	if x != nil {
		return x.ImagePullSecretContent
	}
	return nil
}

// GenerateConnectManifestResponse contains manifest information for
// installing/upgrading a Connect agent.
type GenerateConnectManifestResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ordered list of Kubernetes resources that need to be applied to the
	// cluster for GKE Connect agent installation/upgrade.
	Manifest []*ConnectAgentResource `protobuf:"bytes,1,rep,name=manifest,proto3" json:"manifest,omitempty"`
}

func (x *GenerateConnectManifestResponse) Reset() {
	*x = GenerateConnectManifestResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateConnectManifestResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateConnectManifestResponse) ProtoMessage() {}

func (x *GenerateConnectManifestResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateConnectManifestResponse.ProtoReflect.Descriptor instead.
func (*GenerateConnectManifestResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{17}
}

func (x *GenerateConnectManifestResponse) GetManifest() []*ConnectAgentResource {
	if x != nil {
		return x.Manifest
	}
	return nil
}

// ConnectAgentResource represents a Kubernetes resource manifest for Connect
// Agent deployment.
type ConnectAgentResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kubernetes type of the resource.
	Type *TypeMeta `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// YAML manifest of the resource.
	Manifest string `protobuf:"bytes,2,opt,name=manifest,proto3" json:"manifest,omitempty"`
}

func (x *ConnectAgentResource) Reset() {
	*x = ConnectAgentResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectAgentResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectAgentResource) ProtoMessage() {}

func (x *ConnectAgentResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectAgentResource.ProtoReflect.Descriptor instead.
func (*ConnectAgentResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{18}
}

func (x *ConnectAgentResource) GetType() *TypeMeta {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ConnectAgentResource) GetManifest() string {
	if x != nil {
		return x.Manifest
	}
	return ""
}

// ResourceManifest represents a single Kubernetes resource to be applied to
// the cluster.
type ResourceManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// YAML manifest of the resource.
	Manifest string `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// Whether the resource provided in the manifest is `cluster_scoped`.
	// If unset, the manifest is assumed to be namespace scoped.
	//
	// This field is used for REST mapping when applying the resource in a
	// cluster.
	ClusterScoped bool `protobuf:"varint,2,opt,name=cluster_scoped,json=clusterScoped,proto3" json:"cluster_scoped,omitempty"`
}

func (x *ResourceManifest) Reset() {
	*x = ResourceManifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceManifest) ProtoMessage() {}

func (x *ResourceManifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceManifest.ProtoReflect.Descriptor instead.
func (*ResourceManifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{19}
}

func (x *ResourceManifest) GetManifest() string {
	if x != nil {
		return x.Manifest
	}
	return ""
}

func (x *ResourceManifest) GetClusterScoped() bool {
	if x != nil {
		return x.ClusterScoped
	}
	return false
}

// TypeMeta is the type information needed for content unmarshalling of
// Kubernetes resources in the manifest.
type TypeMeta struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Kind of the resource (e.g. Deployment).
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// APIVersion of the resource (e.g. v1).
	ApiVersion string `protobuf:"bytes,2,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *TypeMeta) Reset() {
	*x = TypeMeta{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TypeMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TypeMeta) ProtoMessage() {}

func (x *TypeMeta) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TypeMeta.ProtoReflect.Descriptor instead.
func (*TypeMeta) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{20}
}

func (x *TypeMeta) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *TypeMeta) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Request message for the InitializeHub method.
type InitializeHubRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Hub to initialize, in the format
	// `projects/*/locations/*/memberships/*`.
	Project string `protobuf:"bytes,1,opt,name=project,proto3" json:"project,omitempty"`
}

func (x *InitializeHubRequest) Reset() {
	*x = InitializeHubRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitializeHubRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeHubRequest) ProtoMessage() {}

func (x *InitializeHubRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeHubRequest.ProtoReflect.Descriptor instead.
func (*InitializeHubRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{21}
}

func (x *InitializeHubRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

// Response message for the InitializeHub method.
type InitializeHubResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Hub default service identity, in the format:
	//
	//     service-<project-number>@gcp-sa-gkehub.iam.gserviceaccount.com
	//
	// The service account has `roles/gkehub.serviceAgent` in the Hub project.
	ServiceIdentity string `protobuf:"bytes,1,opt,name=service_identity,json=serviceIdentity,proto3" json:"service_identity,omitempty"`
	// The Workload Identity Pool used for Workload Identity-enabled clusters
	// registered with this Hub. Format: `<project-id>.hub.id.goog`
	WorkloadIdentityPool string `protobuf:"bytes,2,opt,name=workload_identity_pool,json=workloadIdentityPool,proto3" json:"workload_identity_pool,omitempty"`
}

func (x *InitializeHubResponse) Reset() {
	*x = InitializeHubResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitializeHubResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializeHubResponse) ProtoMessage() {}

func (x *InitializeHubResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializeHubResponse.ProtoReflect.Descriptor instead.
func (*InitializeHubResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{22}
}

func (x *InitializeHubResponse) GetServiceIdentity() string {
	if x != nil {
		return x.ServiceIdentity
	}
	return ""
}

func (x *InitializeHubResponse) GetWorkloadIdentityPool() string {
	if x != nil {
		return x.WorkloadIdentityPool
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusDetail string `protobuf:"bytes,5,opt,name=status_detail,json=statusDetail,proto3" json:"status_detail,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelRequested bool `protobuf:"varint,6,opt,name=cancel_requested,json=cancelRequested,proto3" json:"cancel_requested,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP(), []int{23}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusDetail() string {
	if x != nil {
		return x.StatusDetail
	}
	return ""
}

func (x *OperationMetadata) GetCancelRequested() bool {
	if x != nil {
		return x.CancelRequested
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

var File_google_cloud_gkehub_v1alpha2_membership_proto protoreflect.FileDescriptor

var file_google_cloud_gkehub_v1alpha2_membership_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x6d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe3, 0x08, 0x0a, 0x0a, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x12, 0x51, 0x0a, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x71, 0x0a, 0x13, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x57, 0x0a, 0x12, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x49, 0x4e,
	0x46, 0x52, 0x41, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x45, 0x4d, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b,
	0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x10, 0x02, 0x3a, 0x67, 0xea,
	0x41, 0x64, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x82,
	0x04, 0x0a, 0x12, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x67, 0x6b, 0x65, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x67, 0x6b, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0f, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x65, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4f, 0x6e, 0x50, 0x72, 0x65, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x6f, 0x6e, 0x50, 0x72, 0x65, 0x6d, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x66, 0x0a, 0x13, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x66, 0x0a, 0x13, 0x6b,
	0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x66, 0x0a, 0x13, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65,
	0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0xf8, 0x02, 0x0a, 0x12, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x16, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x63, 0x72, 0x5f, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52,
	0x14, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x72, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x66, 0x0a, 0x14, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x60, 0x0a,
	0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x5d, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8b,
	0x01, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5f, 0x63, 0x72, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x43, 0x72, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x6b, 0x38, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x6b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x64, 0x0a, 0x0a,
	0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x69, 0x73, 0x73, 0x69,
	0x6e, 0x67, 0x22, 0x91, 0x01, 0x0a, 0x0d, 0x4f, 0x6e, 0x50, 0x72, 0x65, 0x6d, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x2c,
	0x0a, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x6b, 0x0a, 0x11, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x4d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x22, 0xb7, 0x02, 0x0a, 0x12, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x1d, 0x6b, 0x75,
	0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x10, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x76, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x76, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb7, 0x01,
	0x0a, 0x09, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x69,
	0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x6f, 0x69, 0x64, 0x63,
	0x5f, 0x6a, 0x77, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x6f, 0x69, 0x64, 0x63, 0x4a, 0x77, 0x6b, 0x73, 0x12, 0x30, 0x0a, 0x11, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x16,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0xc7, 0x01, 0x0a, 0x0f, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4b, 0x0a, 0x04, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x67, 0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a,
	0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x53,
	0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x22, 0xdd, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xab, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x49, 0x64, 0x12, 0x49, 0x0a,
	0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x57, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xbf, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x49, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0x9b, 0x02, 0x0a, 0x1e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x12, 0x1d, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a,
	0x69, 0x73, 0x5f, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x73, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x12, 0x3e, 0x0a, 0x19, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x75, 0x6c, 0x6c, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x50, 0x75, 0x6c, 0x6c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x22, 0x71, 0x0a, 0x1f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x22, 0x6e, 0x0a, 0x14, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x3a, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x22, 0x55, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69,
	0x66, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x22, 0x3f, 0x0a, 0x08, 0x54,
	0x79, 0x70, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x61,
	0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x35, 0x0a, 0x14,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x22, 0x78, 0x0a, 0x15, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x10,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x34, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61,
	0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0xc7, 0x02,
	0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x2e, 0x0a, 0x10, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x64, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xdb, 0x0c, 0x0a, 0x06, 0x47, 0x6b, 0x65, 0x48,
	0x75, 0x62, 0x12, 0xc6, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb3, 0x01, 0x0a, 0x0d,
	0x47, 0x65, 0x74, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x74,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x22, 0x44, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xf4, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x41, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x3a, 0x08, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x4d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdb, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x71, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f,
	0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf0, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x85, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x32, 0x35, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0xda, 0x41, 0x19, 0x6e, 0x61,
	0x6d, 0x65, 0x2c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xed, 0x01, 0x0a, 0x17, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x4d, 0x61, 0x6e,
	0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0xce, 0x01, 0x0a, 0x0d, 0x49, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x48, 0x75, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2e, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x48, 0x75, 0x62, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x22, 0x49, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x7d, 0x3a, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x48, 0x75, 0x62, 0x3a, 0x01, 0x2a, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xd9, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x42, 0x0f, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0x3b, 0x67, 0x6b, 0x65, 0x68, 0x75,
	0x62, 0xaa, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x32,
	0xca, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x5c, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x32, 0xea,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescOnce sync.Once
	file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescData = file_google_cloud_gkehub_v1alpha2_membership_proto_rawDesc
)

func file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescGZIP() []byte {
	file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescData)
	})
	return file_google_cloud_gkehub_v1alpha2_membership_proto_rawDescData
}

var file_google_cloud_gkehub_v1alpha2_membership_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_cloud_gkehub_v1alpha2_membership_proto_goTypes = []interface{}{
	(Membership_InfrastructureType)(0),      // 0: google.cloud.gkehub.v1alpha2.Membership.InfrastructureType
	(MembershipState_Code)(0),               // 1: google.cloud.gkehub.v1alpha2.MembershipState.Code
	(*Membership)(nil),                      // 2: google.cloud.gkehub.v1alpha2.Membership
	(*MembershipEndpoint)(nil),              // 3: google.cloud.gkehub.v1alpha2.MembershipEndpoint
	(*KubernetesResource)(nil),              // 4: google.cloud.gkehub.v1alpha2.KubernetesResource
	(*ResourceOptions)(nil),                 // 5: google.cloud.gkehub.v1alpha2.ResourceOptions
	(*GkeCluster)(nil),                      // 6: google.cloud.gkehub.v1alpha2.GkeCluster
	(*OnPremCluster)(nil),                   // 7: google.cloud.gkehub.v1alpha2.OnPremCluster
	(*MultiCloudCluster)(nil),               // 8: google.cloud.gkehub.v1alpha2.MultiCloudCluster
	(*KubernetesMetadata)(nil),              // 9: google.cloud.gkehub.v1alpha2.KubernetesMetadata
	(*Authority)(nil),                       // 10: google.cloud.gkehub.v1alpha2.Authority
	(*MembershipState)(nil),                 // 11: google.cloud.gkehub.v1alpha2.MembershipState
	(*ListMembershipsRequest)(nil),          // 12: google.cloud.gkehub.v1alpha2.ListMembershipsRequest
	(*ListMembershipsResponse)(nil),         // 13: google.cloud.gkehub.v1alpha2.ListMembershipsResponse
	(*GetMembershipRequest)(nil),            // 14: google.cloud.gkehub.v1alpha2.GetMembershipRequest
	(*CreateMembershipRequest)(nil),         // 15: google.cloud.gkehub.v1alpha2.CreateMembershipRequest
	(*DeleteMembershipRequest)(nil),         // 16: google.cloud.gkehub.v1alpha2.DeleteMembershipRequest
	(*UpdateMembershipRequest)(nil),         // 17: google.cloud.gkehub.v1alpha2.UpdateMembershipRequest
	(*GenerateConnectManifestRequest)(nil),  // 18: google.cloud.gkehub.v1alpha2.GenerateConnectManifestRequest
	(*GenerateConnectManifestResponse)(nil), // 19: google.cloud.gkehub.v1alpha2.GenerateConnectManifestResponse
	(*ConnectAgentResource)(nil),            // 20: google.cloud.gkehub.v1alpha2.ConnectAgentResource
	(*ResourceManifest)(nil),                // 21: google.cloud.gkehub.v1alpha2.ResourceManifest
	(*TypeMeta)(nil),                        // 22: google.cloud.gkehub.v1alpha2.TypeMeta
	(*InitializeHubRequest)(nil),            // 23: google.cloud.gkehub.v1alpha2.InitializeHubRequest
	(*InitializeHubResponse)(nil),           // 24: google.cloud.gkehub.v1alpha2.InitializeHubResponse
	(*OperationMetadata)(nil),               // 25: google.cloud.gkehub.v1alpha2.OperationMetadata
	nil,                                     // 26: google.cloud.gkehub.v1alpha2.Membership.LabelsEntry
	(*timestamppb.Timestamp)(nil),           // 27: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),           // 28: google.protobuf.FieldMask
	(*longrunning.Operation)(nil),           // 29: google.longrunning.Operation
}
var file_google_cloud_gkehub_v1alpha2_membership_proto_depIdxs = []int32{
	26, // 0: google.cloud.gkehub.v1alpha2.Membership.labels:type_name -> google.cloud.gkehub.v1alpha2.Membership.LabelsEntry
	3,  // 1: google.cloud.gkehub.v1alpha2.Membership.endpoint:type_name -> google.cloud.gkehub.v1alpha2.MembershipEndpoint
	11, // 2: google.cloud.gkehub.v1alpha2.Membership.state:type_name -> google.cloud.gkehub.v1alpha2.MembershipState
	27, // 3: google.cloud.gkehub.v1alpha2.Membership.create_time:type_name -> google.protobuf.Timestamp
	27, // 4: google.cloud.gkehub.v1alpha2.Membership.update_time:type_name -> google.protobuf.Timestamp
	27, // 5: google.cloud.gkehub.v1alpha2.Membership.delete_time:type_name -> google.protobuf.Timestamp
	10, // 6: google.cloud.gkehub.v1alpha2.Membership.authority:type_name -> google.cloud.gkehub.v1alpha2.Authority
	27, // 7: google.cloud.gkehub.v1alpha2.Membership.last_connection_time:type_name -> google.protobuf.Timestamp
	0,  // 8: google.cloud.gkehub.v1alpha2.Membership.infrastructure_type:type_name -> google.cloud.gkehub.v1alpha2.Membership.InfrastructureType
	6,  // 9: google.cloud.gkehub.v1alpha2.MembershipEndpoint.gke_cluster:type_name -> google.cloud.gkehub.v1alpha2.GkeCluster
	7,  // 10: google.cloud.gkehub.v1alpha2.MembershipEndpoint.on_prem_cluster:type_name -> google.cloud.gkehub.v1alpha2.OnPremCluster
	8,  // 11: google.cloud.gkehub.v1alpha2.MembershipEndpoint.multi_cloud_cluster:type_name -> google.cloud.gkehub.v1alpha2.MultiCloudCluster
	9,  // 12: google.cloud.gkehub.v1alpha2.MembershipEndpoint.kubernetes_metadata:type_name -> google.cloud.gkehub.v1alpha2.KubernetesMetadata
	4,  // 13: google.cloud.gkehub.v1alpha2.MembershipEndpoint.kubernetes_resource:type_name -> google.cloud.gkehub.v1alpha2.KubernetesResource
	21, // 14: google.cloud.gkehub.v1alpha2.KubernetesResource.membership_resources:type_name -> google.cloud.gkehub.v1alpha2.ResourceManifest
	21, // 15: google.cloud.gkehub.v1alpha2.KubernetesResource.connect_resources:type_name -> google.cloud.gkehub.v1alpha2.ResourceManifest
	5,  // 16: google.cloud.gkehub.v1alpha2.KubernetesResource.resource_options:type_name -> google.cloud.gkehub.v1alpha2.ResourceOptions
	27, // 17: google.cloud.gkehub.v1alpha2.KubernetesMetadata.update_time:type_name -> google.protobuf.Timestamp
	1,  // 18: google.cloud.gkehub.v1alpha2.MembershipState.code:type_name -> google.cloud.gkehub.v1alpha2.MembershipState.Code
	2,  // 19: google.cloud.gkehub.v1alpha2.ListMembershipsResponse.resources:type_name -> google.cloud.gkehub.v1alpha2.Membership
	2,  // 20: google.cloud.gkehub.v1alpha2.CreateMembershipRequest.resource:type_name -> google.cloud.gkehub.v1alpha2.Membership
	28, // 21: google.cloud.gkehub.v1alpha2.UpdateMembershipRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 22: google.cloud.gkehub.v1alpha2.UpdateMembershipRequest.resource:type_name -> google.cloud.gkehub.v1alpha2.Membership
	20, // 23: google.cloud.gkehub.v1alpha2.GenerateConnectManifestResponse.manifest:type_name -> google.cloud.gkehub.v1alpha2.ConnectAgentResource
	22, // 24: google.cloud.gkehub.v1alpha2.ConnectAgentResource.type:type_name -> google.cloud.gkehub.v1alpha2.TypeMeta
	27, // 25: google.cloud.gkehub.v1alpha2.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	27, // 26: google.cloud.gkehub.v1alpha2.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	12, // 27: google.cloud.gkehub.v1alpha2.GkeHub.ListMemberships:input_type -> google.cloud.gkehub.v1alpha2.ListMembershipsRequest
	14, // 28: google.cloud.gkehub.v1alpha2.GkeHub.GetMembership:input_type -> google.cloud.gkehub.v1alpha2.GetMembershipRequest
	15, // 29: google.cloud.gkehub.v1alpha2.GkeHub.CreateMembership:input_type -> google.cloud.gkehub.v1alpha2.CreateMembershipRequest
	16, // 30: google.cloud.gkehub.v1alpha2.GkeHub.DeleteMembership:input_type -> google.cloud.gkehub.v1alpha2.DeleteMembershipRequest
	17, // 31: google.cloud.gkehub.v1alpha2.GkeHub.UpdateMembership:input_type -> google.cloud.gkehub.v1alpha2.UpdateMembershipRequest
	18, // 32: google.cloud.gkehub.v1alpha2.GkeHub.GenerateConnectManifest:input_type -> google.cloud.gkehub.v1alpha2.GenerateConnectManifestRequest
	23, // 33: google.cloud.gkehub.v1alpha2.GkeHub.InitializeHub:input_type -> google.cloud.gkehub.v1alpha2.InitializeHubRequest
	13, // 34: google.cloud.gkehub.v1alpha2.GkeHub.ListMemberships:output_type -> google.cloud.gkehub.v1alpha2.ListMembershipsResponse
	2,  // 35: google.cloud.gkehub.v1alpha2.GkeHub.GetMembership:output_type -> google.cloud.gkehub.v1alpha2.Membership
	29, // 36: google.cloud.gkehub.v1alpha2.GkeHub.CreateMembership:output_type -> google.longrunning.Operation
	29, // 37: google.cloud.gkehub.v1alpha2.GkeHub.DeleteMembership:output_type -> google.longrunning.Operation
	29, // 38: google.cloud.gkehub.v1alpha2.GkeHub.UpdateMembership:output_type -> google.longrunning.Operation
	19, // 39: google.cloud.gkehub.v1alpha2.GkeHub.GenerateConnectManifest:output_type -> google.cloud.gkehub.v1alpha2.GenerateConnectManifestResponse
	24, // 40: google.cloud.gkehub.v1alpha2.GkeHub.InitializeHub:output_type -> google.cloud.gkehub.v1alpha2.InitializeHubResponse
	34, // [34:41] is the sub-list for method output_type
	27, // [27:34] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_gkehub_v1alpha2_membership_proto_init() }
func file_google_cloud_gkehub_v1alpha2_membership_proto_init() {
	if File_google_cloud_gkehub_v1alpha2_membership_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Membership); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OnPremCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiCloudCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Authority); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMembershipsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMembershipsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMembershipRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateConnectManifestRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateConnectManifestResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectAgentResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceManifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TypeMeta); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitializeHubRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitializeHubResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Membership_Endpoint)(nil),
	}
	file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*MembershipEndpoint_GkeCluster)(nil),
		(*MembershipEndpoint_OnPremCluster)(nil),
		(*MembershipEndpoint_MultiCloudCluster)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkehub_v1alpha2_membership_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_gkehub_v1alpha2_membership_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkehub_v1alpha2_membership_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkehub_v1alpha2_membership_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkehub_v1alpha2_membership_proto_msgTypes,
	}.Build()
	File_google_cloud_gkehub_v1alpha2_membership_proto = out.File
	file_google_cloud_gkehub_v1alpha2_membership_proto_rawDesc = nil
	file_google_cloud_gkehub_v1alpha2_membership_proto_goTypes = nil
	file_google_cloud_gkehub_v1alpha2_membership_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// GkeHubClient is the client API for GkeHub service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GkeHubClient interface {
	// Lists Memberships in a given project and location.
	ListMemberships(ctx context.Context, in *ListMembershipsRequest, opts ...grpc.CallOption) (*ListMembershipsResponse, error)
	// Gets the details of a Membership.
	GetMembership(ctx context.Context, in *GetMembershipRequest, opts ...grpc.CallOption) (*Membership, error)
	// Creates a new Membership.
	//
	// **This is currently only supported for GKE clusters on Google Cloud**.
	// To register other clusters, follow the instructions at
	// https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
	CreateMembership(ctx context.Context, in *CreateMembershipRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Removes a Membership.
	//
	// **This is currently only supported for GKE clusters on Google Cloud**.
	// To unregister other clusters, follow the instructions at
	// https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
	DeleteMembership(ctx context.Context, in *DeleteMembershipRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates an existing Membership.
	UpdateMembership(ctx context.Context, in *UpdateMembershipRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Generates the manifest for deployment of the GKE connect agent.
	//
	// **This method is used internally by Google-provided libraries.**
	// Most clients should not need to call this method directly.
	GenerateConnectManifest(ctx context.Context, in *GenerateConnectManifestRequest, opts ...grpc.CallOption) (*GenerateConnectManifestResponse, error)
	// Initializes the Hub in this project, which includes creating the default
	// Hub Service Account and the Hub Workload Identity Pool. Initialization is
	// optional, and happens automatically when the first Membership is created.
	//
	// InitializeHub should be called when the first Membership cannot be
	// registered without these resources. A common example is granting the Hub
	// Service Account access to another project, which requires the account to
	// exist first.
	InitializeHub(ctx context.Context, in *InitializeHubRequest, opts ...grpc.CallOption) (*InitializeHubResponse, error)
}

type gkeHubClient struct {
	cc grpc.ClientConnInterface
}

func NewGkeHubClient(cc grpc.ClientConnInterface) GkeHubClient {
	return &gkeHubClient{cc}
}

func (c *gkeHubClient) ListMemberships(ctx context.Context, in *ListMembershipsRequest, opts ...grpc.CallOption) (*ListMembershipsResponse, error) {
	out := new(ListMembershipsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/ListMemberships", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gkeHubClient) GetMembership(ctx context.Context, in *GetMembershipRequest, opts ...grpc.CallOption) (*Membership, error) {
	out := new(Membership)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/GetMembership", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gkeHubClient) CreateMembership(ctx context.Context, in *CreateMembershipRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/CreateMembership", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gkeHubClient) DeleteMembership(ctx context.Context, in *DeleteMembershipRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/DeleteMembership", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gkeHubClient) UpdateMembership(ctx context.Context, in *UpdateMembershipRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/UpdateMembership", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gkeHubClient) GenerateConnectManifest(ctx context.Context, in *GenerateConnectManifestRequest, opts ...grpc.CallOption) (*GenerateConnectManifestResponse, error) {
	out := new(GenerateConnectManifestResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/GenerateConnectManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gkeHubClient) InitializeHub(ctx context.Context, in *InitializeHubRequest, opts ...grpc.CallOption) (*InitializeHubResponse, error) {
	out := new(InitializeHubResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.gkehub.v1alpha2.GkeHub/InitializeHub", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GkeHubServer is the server API for GkeHub service.
type GkeHubServer interface {
	// Lists Memberships in a given project and location.
	ListMemberships(context.Context, *ListMembershipsRequest) (*ListMembershipsResponse, error)
	// Gets the details of a Membership.
	GetMembership(context.Context, *GetMembershipRequest) (*Membership, error)
	// Creates a new Membership.
	//
	// **This is currently only supported for GKE clusters on Google Cloud**.
	// To register other clusters, follow the instructions at
	// https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster.
	CreateMembership(context.Context, *CreateMembershipRequest) (*longrunning.Operation, error)
	// Removes a Membership.
	//
	// **This is currently only supported for GKE clusters on Google Cloud**.
	// To unregister other clusters, follow the instructions at
	// https://cloud.google.com/anthos/multicluster-management/connect/unregistering-a-cluster.
	DeleteMembership(context.Context, *DeleteMembershipRequest) (*longrunning.Operation, error)
	// Updates an existing Membership.
	UpdateMembership(context.Context, *UpdateMembershipRequest) (*longrunning.Operation, error)
	// Generates the manifest for deployment of the GKE connect agent.
	//
	// **This method is used internally by Google-provided libraries.**
	// Most clients should not need to call this method directly.
	GenerateConnectManifest(context.Context, *GenerateConnectManifestRequest) (*GenerateConnectManifestResponse, error)
	// Initializes the Hub in this project, which includes creating the default
	// Hub Service Account and the Hub Workload Identity Pool. Initialization is
	// optional, and happens automatically when the first Membership is created.
	//
	// InitializeHub should be called when the first Membership cannot be
	// registered without these resources. A common example is granting the Hub
	// Service Account access to another project, which requires the account to
	// exist first.
	InitializeHub(context.Context, *InitializeHubRequest) (*InitializeHubResponse, error)
}

// UnimplementedGkeHubServer can be embedded to have forward compatible implementations.
type UnimplementedGkeHubServer struct {
}

func (*UnimplementedGkeHubServer) ListMemberships(context.Context, *ListMembershipsRequest) (*ListMembershipsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMemberships not implemented")
}
func (*UnimplementedGkeHubServer) GetMembership(context.Context, *GetMembershipRequest) (*Membership, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMembership not implemented")
}
func (*UnimplementedGkeHubServer) CreateMembership(context.Context, *CreateMembershipRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMembership not implemented")
}
func (*UnimplementedGkeHubServer) DeleteMembership(context.Context, *DeleteMembershipRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMembership not implemented")
}
func (*UnimplementedGkeHubServer) UpdateMembership(context.Context, *UpdateMembershipRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMembership not implemented")
}
func (*UnimplementedGkeHubServer) GenerateConnectManifest(context.Context, *GenerateConnectManifestRequest) (*GenerateConnectManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateConnectManifest not implemented")
}
func (*UnimplementedGkeHubServer) InitializeHub(context.Context, *InitializeHubRequest) (*InitializeHubResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InitializeHub not implemented")
}

func RegisterGkeHubServer(s *grpc.Server, srv GkeHubServer) {
	s.RegisterService(&_GkeHub_serviceDesc, srv)
}

func _GkeHub_ListMemberships_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMembershipsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).ListMemberships(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/ListMemberships",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).ListMemberships(ctx, req.(*ListMembershipsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GkeHub_GetMembership_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMembershipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).GetMembership(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/GetMembership",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).GetMembership(ctx, req.(*GetMembershipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GkeHub_CreateMembership_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMembershipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).CreateMembership(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/CreateMembership",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).CreateMembership(ctx, req.(*CreateMembershipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GkeHub_DeleteMembership_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMembershipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).DeleteMembership(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/DeleteMembership",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).DeleteMembership(ctx, req.(*DeleteMembershipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GkeHub_UpdateMembership_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMembershipRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).UpdateMembership(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/UpdateMembership",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).UpdateMembership(ctx, req.(*UpdateMembershipRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GkeHub_GenerateConnectManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateConnectManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).GenerateConnectManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/GenerateConnectManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).GenerateConnectManifest(ctx, req.(*GenerateConnectManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GkeHub_InitializeHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitializeHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GkeHubServer).InitializeHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.gkehub.v1alpha2.GkeHub/InitializeHub",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GkeHubServer).InitializeHub(ctx, req.(*InitializeHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GkeHub_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkehub.v1alpha2.GkeHub",
	HandlerType: (*GkeHubServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMemberships",
			Handler:    _GkeHub_ListMemberships_Handler,
		},
		{
			MethodName: "GetMembership",
			Handler:    _GkeHub_GetMembership_Handler,
		},
		{
			MethodName: "CreateMembership",
			Handler:    _GkeHub_CreateMembership_Handler,
		},
		{
			MethodName: "DeleteMembership",
			Handler:    _GkeHub_DeleteMembership_Handler,
		},
		{
			MethodName: "UpdateMembership",
			Handler:    _GkeHub_UpdateMembership_Handler,
		},
		{
			MethodName: "GenerateConnectManifest",
			Handler:    _GkeHub_GenerateConnectManifest_Handler,
		},
		{
			MethodName: "InitializeHub",
			Handler:    _GkeHub_InitializeHub_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkehub/v1alpha2/membership.proto",
}
