/* GStreamer GES plugin
 *
 * Copyright (C) 2019 Thibault Saunier <tsaunier@igalia.com>
 *
 * gstges.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef __GES_SRC_H__
#define __GES_SRC_H__

#include <gst/gst.h>
#include <ges/ges.h>

G_BEGIN_DECLS

GType ges_src_get_type (void);

#define GES_SRC_TYPE (ges_src_get_type ())
#define GES_SRC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GES_SRC_TYPE, GESSrc))
#define GES_SRC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GES_SRC_TYPE, GESSrcClass))
#define GES_IS_SRC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GES_SRC_TYPE))
#define GES_IS_SRC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GES_SRC_TYPE))
#define GES_SRC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GES_SRC_TYPE, GESSrcClass))

typedef struct {
  GstBin parent;

  GESTimeline *timeline;
} GESSrc;

typedef struct {
  GstBinClass parent;

} GESSrcClass;

G_END_DECLS
#endif /* __GES_SRC_H__ */
