/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2010 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>

/* -- prototypes for eng_frame.c -- */

void eng_create_frame_all();
void eng_create_frame     (gint32 frame_id);
void pic_get_zone_update  (gint32 frame_id, gint32 pic_id, gint * x1, gint * y1, gint * x2, gint * y2);
void pic_get_zone_old     (gint32 frame_id, gint32 pic_id, gint * x1, gint * y1, gint * x2, gint * y2);
void pic_get_zone_new     (gint32 frame_id, gint32 pic_id, gint * x1, gint * y1, gint * x2, gint * y2);

void eng_update_bufout    (gint32 frame_id, gint32 x1, gint32 y1, gint32 x2, gint32 y2);
void eng_set_bg_bufout    (gint32 frame_id, gint32 x1, gint32 y1, gint32 x2, gint32 y2);

gboolean eng_zone_is_modified(gint32 frame_id, gint32 x1, gint32 y1, gint32 x2, gint32 y2);
gpointer eng_get_zone     (gint32 frame_id, gint32 x1, gint32 y1, gint32 x2, gint32 y2);
gpointer eng_get_next_zone(gint32 frame_id, gint32 * x, gint32 * y, gint32 * width, gint32 * height);

/* -- end of prototypes -- */
