// generated by ./gx_tube_transfer.py
// tube: KT88
// plate current function: pentode
// mu: 8.8
// kx: 1.35
// kg1: 730
// kg2: 4200
// kp: 32
// kvb: 16
// Uin_min: -15
// Uin_max: 15
// Vp: 250
// Rp: 100000

table1dt_imp<2001> tranytable_KT88[2] __rt_data = {
	{ // Ri = 68k
	-15,15,66.6667,2001, {
	91.4720662698,91.4025653335,91.333048564,91.2635159512,91.1939674851,
	91.1244031556,91.0548229526,90.9852268661,90.9156148858,90.8459870017,
	90.7763432036,90.7066834811,90.6370078241,90.5673162224,90.4976086656,
	90.4278851434,90.3581456456,90.2883901616,90.2186186812,90.1488311939,
	90.0790276892,90.0092081568,89.9393725861,89.8695209666,89.7996532878,
	89.7297695391,89.6598697098,89.5899537895,89.5200217674,89.4500736328,
	89.3801093751,89.3101289836,89.2401324474,89.1701197558,89.1000908981,
	89.0300458633,88.9599846406,88.8899072192,88.8198135881,88.7497037363,
	88.679577653,88.6094353271,88.5392767476,88.4691019035,88.3989107837,
	88.328703377,88.2584796725,88.1882396588,88.1179833248,88.0477106594,
	87.9774216512,87.9071162891,87.8367945617,87.7664564576,87.6961019656,
	87.6257310743,87.5553437723,87.4849400481,87.4145198902,87.3440832873,
	87.2736302277,87.2031606999,87.1326746924,87.0621721935,86.9916531916,
	86.921117675,86.8505656322,86.7799970512,86.7094119204,86.6388102281,
	86.5681919624,86.4975571114,86.4269056633,86.3562376063,86.2855529283,
	86.2148516175,86.1441336618,86.0733990492,86.0026477678,85.9318798054,
	85.8610951499,85.7902937892,85.7194757111,85.6486409035,85.577789354,
	85.5069210505,85.4360359807,85.3651341323,85.2942154929,85.2232800501,
	85.1523277915,85.0813587048,85.0103727773,84.9393699967,84.8683503504,
	84.7973138258,84.7262604104,84.6551900914,84.5841028564,84.5129986925,
	84.441877587,84.3707395273,84.2995845004,84.2284124937,84.1572234942,
	84.0860174891,84.0147944654,83.9435544103,83.8722973107,83.8010231537,
	83.7297319261,83.6584236149,83.5870982071,83.5157556894,83.4443960487,
	83.3730192718,83.3016253455,83.2302142564,83.1587859913,83.0873405368,
	83.0158778796,82.9443980062,82.8729009033,82.8013865573,82.7298549547,
	82.658306082,82.5867399256,82.5151564719,82.4435557073,82.3719376181,
	82.3003021905,82.2286494108,82.1569792653,82.08529174,82.0135868213,
	81.9418644951,81.8701247475,81.7983675647,81.7265929325,81.654800837,
	81.5829912642,81.5111641998,81.4393196298,81.36745754,81.2955779162,
	81.2236807441,81.1517660095,81.079833698,81.0078837953,80.9359162871,
	80.8639311588,80.791928396,80.7199079843,80.647869909,80.5758141557,
	80.5037407096,80.4316495563,80.3595406808,80.2874140687,80.215269705,
	80.143107575,80.0709276638,79.9987299566,79.9265144385,79.8542810945,
	79.7820299097,79.7097608689,79.6374739572,79.5651691595,79.4928464605,
	79.4205058451,79.3481472982,79.2757708043,79.2033763484,79.1309639149,
	79.0585334885,78.9860850539,78.9136185955,78.8411340978,78.7686315454,
	78.6961109226,78.6235722139,78.5510154035,78.4784404759,78.4058474151,
	78.3332362056,78.2606068313,78.1879592766,78.1152935255,78.042609562,
	77.9699073702,77.897186934,77.8244482374,77.7516912643,77.6789159985,
	77.6061224239,77.5333105241,77.460480283,77.3876316842,77.3147647114,
	77.2418793481,77.1689755779,77.0960533843,77.0231127509,76.9501536609,
	76.8771760979,76.8041800451,76.7311654859,76.6581324034,76.585080781,
	76.5120106018,76.4389218488,76.3658145053,76.2926885541,76.2195439784,
	76.146380761,76.0731988848,75.9999983328,75.9267790877,75.8535411323,
	75.7802844492,75.7070090213,75.6337148311,75.5604018611,75.4870700941,
	75.4137195123,75.3403500983,75.2669618345,75.1935547033,75.1201286868,
	75.0466837675,74.9732199275,74.899737149,74.8262354141,74.7527147049,
	74.6791750033,74.6056162915,74.5320385513,74.4584417646,74.3848259132,
	74.311190979,74.2375369436,74.1638637888,74.0901714961,74.0164600473,
	73.9427294238,73.8689796072,73.7952105788,73.7214223201,73.6476148124,
	73.573788037,73.4999419753,73.4260766082,73.3521919172,73.2782878831,
	73.2043644871,73.1304217102,73.0564595332,72.9824779372,72.908476903,
	72.8344564112,72.7604164428,72.6863569784,72.6122779985,72.5381794839,
	72.464061415,72.3899237724,72.3157665364,72.2415896874,72.1673932058,
	72.0931770718,72.0189412657,71.9446857676,71.8704105576,71.7961156158,
	71.7218009223,71.6474664568,71.5731121994,71.4987381299,71.4243442281,
	71.3499304737,71.2754968464,71.2010433258,71.1265698915,71.052076523,
	70.9775631998,70.9030299012,70.8284766067,70.7539032955,70.6793099468,
	70.6046965398,70.5300630537,70.4554094675,70.3807357603,70.3060419109,
	70.2313278982,70.1565937012,70.0818392986,70.0070646691,69.9322697913,
	69.857454644,69.7826192055,69.7077634545,69.6328873694,69.5579909284,
	69.48307411,69.4081368924,69.3331792538,69.2582011722,69.1832026259,
	69.1081835928,69.0331440508,68.9580839779,68.8830033518,68.8079021504,
	68.7327803514,68.6576379324,68.5824748709,68.5072911447,68.432086731,
	68.3568616072,68.2816157509,68.2063491391,68.1310617492,68.0557535582,
	67.9804245433,67.9050746815,67.8297039498,67.754312325,67.678899784,
	67.6034663035,67.5280118603,67.452536431,67.3770399922,67.3015225204,
	67.2259839921,67.1504243835,67.0748436711,66.9992418311,66.9236188397,
	66.8479746729,66.7723093069,66.6966227176,66.620914881,66.5451857729,
	66.469435369,66.3936636451,66.3178705769,66.2420561399,66.1662203096,
	66.0903630615,66.0144843709,65.9385842133,65.8626625637,65.7867193973,
	65.7107546894,65.6347684148,65.5587605485,65.4827310655,65.4066799406,
	65.3306071485,65.2545126638,65.1783964612,65.1022585152,65.0260988003,
	64.9499172909,64.8737139613,64.7974887857,64.7212417382,64.6449727931,
	64.5686819244,64.4923691059,64.4160343116,64.3396775152,64.2632986906,
	64.1868978113,64.110474851,64.0340297832,63.9575625812,63.8810732185,
	63.8045616683,63.7280279039,63.6514718984,63.5748936248,63.4982930561,
	63.4216701653,63.345024925,63.2683573082,63.1916672875,63.1149548354,
	63.0382199245,62.9614625273,62.884682616,62.8078801629,62.7310551404,
	62.6542075204,62.5773372751,62.5004443763,62.4235287961,62.3465905061,
	62.2696294782,62.1926456839,62.1156390948,62.0386096824,61.9615574181,
	61.8844822732,61.807384219,61.7302632266,61.6531192671,61.5759523114,
	61.4987623306,61.4215492953,61.3443131763,61.2670539444,61.18977157,
	61.1124660236,61.0351372758,60.9577852966,60.8804100565,60.8030115256,
	60.7255896738,60.6481444713,60.5706758878,60.4931838932,60.4156684572,
	60.3381295494,60.2605671394,60.1829811966,60.1053716904,60.02773859,
	59.9500818648,59.8724014836,59.7946974157,59.7169696299,59.6392180949,
	59.5614427797,59.4836436528,59.4058206828,59.3279738381,59.2501030872,
	59.1722083984,59.0942897398,59.0163470795,58.9383803856,58.860389626,
	58.7823747686,58.704335781,58.6262726309,58.5481852859,58.4700737134,
	58.3919378808,58.3137777554,58.2355933043,58.1573844946,58.0791512934,
	58.0008936675,57.9226115836,57.8443050086,57.765973909,57.6876182513,
	57.609238002,57.5308331273,57.4524035935,57.3739493666,57.2954704128,
	57.216966698,57.1384381878,57.0598848482,56.9813066448,56.9027035429,
	56.8240755082,56.7454225059,56.6667445012,56.5880414594,56.5093133453,
	56.430560124,56.3517817603,56.2729782189,56.1941494645,56.1152954615,
	56.0364161743,55.9575115674,55.8785816049,55.799626251,55.7206454696,
	55.6416392247,55.56260748,55.4835501993,55.4044673462,55.3253588842,
	55.2462247765,55.1670649867,55.0878794777,55.0086682127,54.9294311547,
	54.8501682665,54.7708795108,54.6915648504,54.6122242477,54.5328576652,
	54.4534650652,54.37404641,54.2946016616,54.215130782,54.1356337332,
	54.056110477,53.9765609749,53.8969851887,53.8173830797,53.7377546092,
	53.6580997387,53.578418429,53.4987106414,53.4189763367,53.3392154757,
	53.259428019,53.1796139274,53.0997731611,53.0199056807,52.9400114463,
	52.860090418,52.780142556,52.7001678201,52.62016617,52.5401375655,
	52.4600819662,52.3799993315,52.2998896207,52.2197527931,52.1395888078,
	52.0593976238,51.9791792,51.8989334951,51.8186604679,51.7383600768,
	51.6580322804,51.5776770368,51.4972943044,51.4168840412,51.3364462052,
	51.2559807542,51.175487646,51.0949668382,51.0144182883,50.9338419537,
	50.8532377917,50.7726057595,50.691945814,50.6112579123,50.5305420111,
	50.4497980671,50.369026037,50.2882258771,50.2073975438,50.1265409934,
	50.045656182,49.9647430655,49.8838015999,49.8028317408,49.7218334441,
	49.640806665,49.5597513592,49.4786674819,49.3975549882,49.3164138333,
	49.235243972,49.1540453592,49.0728179496,48.9915616978,48.9102765583,
	48.8289624854,48.7476194334,48.6662473564,48.5848462084,48.5034159433,
	48.4219565148,48.3404678767,48.2589499825,48.1774027856,48.0958262393,
	48.0142202968,47.9325849112,47.8509200355,47.7692256225,47.6875016249,
	47.6057479954,47.5239646865,47.4421516505,47.3603088398,47.2784362065,
	47.1965337027,47.1146012802,47.032638891,46.9506464867,46.8686240189,
	46.7865714392,46.7044886988,46.6223757492,46.5402325413,46.4580590263,
	46.3758551551,46.2936208785,46.2113561472,46.1290609119,46.046735123,
	45.964378731,45.8819916861,45.7995739385,45.7171254382,45.6346461354,
	45.5521359797,45.469594921,45.3870229089,45.304419893,45.2217858227,
	45.1391206474,45.0564243164,44.9736967787,44.8909379835,44.8081478797,
	44.7253264162,44.6424735416,44.5595892048,44.4766733542,44.3937259384,
	44.3107469057,44.2277362044,44.1446937827,44.0616195888,43.9785135707,
	43.8953756763,43.8122058534,43.72900405,43.6457702135,43.5625042917,
	43.4792062321,43.3958759821,43.3125134891,43.2291187003,43.1456915631,
	43.0622320245,42.9787400316,42.8952155314,42.8116584709,42.728068797,
	42.6444464563,42.5607913957,42.4771035618,42.3933829013,42.3096293607,
	42.2258428864,42.1420234251,42.058170923,41.9742853265,41.8903665819,
	41.8064146354,41.7224294333,41.6384109217,41.5543590468,41.4702737546,
	41.3861549912,41.3020027026,41.2178168348,41.1335973339,41.0493441457,
	40.9650572162,40.8807364912,40.7963819168,40.7119934387,40.6275710029,
	40.5431145551,40.4586240414,40.3740994075,40.2895405993,40.2049475627,
	40.1203202436,40.0356585879,39.9509625415,39.8662320505,39.7814670606,
	39.696667518,39.6118333687,39.5269645588,39.4420610343,39.3571227415,
	39.2721496266,39.1871416358,39.1020987155,39.0170208121,38.931907872,
	38.8467598418,38.7615766681,38.6763582976,38.5911046772,38.5058157537,
	38.4204914742,38.3351317856,38.2497366353,38.1643059707,38.078839739,
	37.993337888,37.9078003654,37.8222271191,37.736618097,37.6509732475,
	37.5652925187,37.4795758594,37.393823218,37.3080345436,37.2222097853,
	37.1363488922,37.050451814,36.9645185003,36.878548901,36.7925429664,
	36.7065006468,36.6204218929,36.5343066557,36.4481548863,36.3619665363,
	36.2757415573,36.1894799016,36.1031815213,36.0168463694,35.9304743987,
	35.8440655627,35.7576198151,35.6711371099,35.5846174017,35.4980606453,
	35.4114667959,35.3248358092,35.2381676413,35.1514622488,35.0647195885,
	34.977939618,34.8911222952,34.8042675784,34.7173754266,34.6304457992,
	34.5434786562,34.4564739582,34.3694316662,34.2823517418,34.1952341474,
	34.1080788459,34.0208858008,33.9336549763,33.8463863371,33.759079849,
	33.671735478,33.5843531912,33.4969329563,33.4094747418,33.3219785169,
	33.2344442517,33.1468719171,33.059261485,32.9716129278,32.8839262192,
	32.7962013336,32.7084382463,32.6206369338,32.5327973734,32.4449195434,
	32.3570034233,32.2690489937,32.181056236,32.0930251329,32.0049556685,
	31.9168478277,31.8287015969,31.7405169635,31.6522939164,31.5640324456,
	31.4757325428,31.3873942006,31.2990174134,31.2106021769,31.1221484882,
	31.0336563461,30.9451257508,30.8565567043,30.7679492099,30.6793032729,
	30.5906189002,30.5018961004,30.4131348841,30.3243352634,30.2354972527,
	30.146620868,30.0577061275,29.9687530513,29.8797616618,29.7907319832,
	29.7016640423,29.6125578677,29.5234134906,29.4342309444,29.3450102651,
	29.255751491,29.1664546629,29.0771198243,28.9877470212,28.8983363026,
	28.8088877199,28.7194013277,28.6298771832,28.5403153468,28.450715882,
	28.3610788551,28.2714043361,28.1816923977,28.0919431165,28.0021565723,
	27.9123328483,27.8224720315,27.7325742125,27.6426394858,27.5526679496,
	27.4626597062,27.372614862,27.2825335273,27.192415817,27.1022618501,
	27.0120717502,26.9218456454,26.8315836685,26.7412859571,26.6509526538,
	26.5605839061,26.4701798666,26.3797406933,26.2892665495,26.1987576042,
	26.1082140319,26.0176360128,25.9270237332,25.8363773854,25.7456971681,
	25.6549832861,25.5642359508,25.4734553804,25.3826417998,25.291795441,
	25.2009165432,25.1100053528,25.0190621239,24.9280871182,24.8370806053,
	24.7460428631,24.6549741774,24.5638748429,24.4727451627,24.3815854489,
	24.2903960229,24.1991772153,24.1079293663,24.0166528259,23.9253479544,
	23.8340151221,23.7426547103,23.6512671109,23.5598527269,23.4684119729,
	23.3769452753,23.2854530723,23.1939358146,23.1023939657,23.010828002,
	22.9192384133,22.8276257032,22.7359903895,22.6443330045,22.5526540954,
	22.460954225,22.3692339718,22.2774939308,22.1857347139,22.0939569501,
	22.0021612867,21.9103483894,21.8185189432,21.7266736529,21.6348132437,
	21.5429384625,21.451050078,21.3591488821,21.2672356906,21.1753113442,
	21.0833767096,20.9914326808,20.8994801801,20.8075201595,20.7155536026,
	20.6235815255,20.5316049792,20.439625051,20.3476428672,20.2556595947,
	20.1636764439,20.0716946717,19.979715584,19.8877405394,19.7957709529,
	19.7038083,19.611854121,19.5199100265,19.4279777024,19.3360589164,
	19.2441555248,19.1522694802,19.0604028396,18.9685577741,18.8767365792,
	18.7849416866,18.6931756767,18.6014412933,18.5097414595,18.4180792955,
	18.3264581383,18.2348815636,18.1433534105,18.0518778084,17.9604592076,
	17.8691024121,17.7778126173,17.6865954511,17.5954570189,17.5044039546,
	17.4134434756,17.322583444,17.2318324338,17.1411998045,17.0506957818,
	16.9603315448,16.8701193216,16.7800724923,16.6902056997,16.6005349677,
	16.5110778274,16.4218534499,16.3328827847,16.2441887033,16.1557961448,
	16.0677322617,15.9800265633,15.8927110515,15.805820345,15.719391786,
	15.6334655229,15.548084561,15.463294774,15.3791448665,15.2956862793,
	15.2129730285,15.1310614707,15.0500099884,14.96987859,14.8907284256,
	14.8126212189,14.7356186242,14.659781518,14.5851692437,14.5118388288,
	14.4398441984,14.3692354125,14.3000579538,14.2323520918,14.1661523466,
	14.1014870722,14.0383781705,13.9768409446,13.9168840903,13.8585098195,
	13.8017141036,13.746487021,13.6928131887,13.6406722582,13.5900394542,
	13.5408861368,13.4931803694,13.4468874763,13.4019705781,13.3583910953,
	13.3161092128,13.2750843012,13.2352752927,13.1966410114,13.1591404592,
	13.1227330579,13.0873788533,13.0530386815,13.0196743028,12.9872485066,
	12.9557251903,12.9250694157,12.8952474466,12.86622677,12.8379761038,
	12.8104653929,12.7836657961,12.7575496663,12.7320905237,12.7072630249,
	12.6830429295,12.6594070624,12.6363332765,12.6138004125,12.5917882602,
	12.5702775177,12.5492497529,12.5286873646,12.5085735444,12.48889224,
	12.4696281199,12.4507665387,12.4322935038,12.4141956442,12.3964601794,
	12.3790748912,12.3620280951,12.3453086144,12.3289057548,12.3128092807,
	12.2970093925,12.2814967047,12.2662622259,12.251297339,12.2365937832,
	12.2221436362,12.2079392982,12.1939734756,12.1802391668,12.1667296481,
	12.15343846,12.1403593951,12.1274864861,12.1148139944,12.1023363993,
	12.0900483886,12.0779448479,12.0660208527,12.0542716588,12.0426926947,
	12.031279554,12.0200279874,12.0089338964,11.9979933265,11.9872024606,
	11.9765576136,11.9660552263,11.9556918603,11.9454641929,11.9353690118,
	11.9254032112,11.9155637869,11.9058478323,11.8962525343,11.8867751697,
	11.8774131017,11.8681637759,11.8590247176,11.8499935287,11.8410678842,
	11.8322455298,11.8235242791,11.8149020109,11.806376667,11.7979462496,
	11.789608819,11.7813624917,11.7732054382,11.7651358809,11.7571520927,
	11.7492523945,11.7414351539,11.7336987839,11.7260417403,11.7184625213,
	11.7109596652,11.7035317497,11.69617739,11.6888952378,11.6816839799,
	11.6745423375,11.6674690645,11.6604629465,11.6535228001,11.6466474717,
	11.6398358365,11.6330867975,11.6263992848,11.6197722548,11.6132046891,
	11.6066955938,11.600243999,11.5938489578,11.5875095455,11.5812248593,
	11.5749940173,11.5688161581,11.5626904399,11.5566160403,11.5505921556,
	11.5446179999,11.5386928051,11.5328158201,11.5269863105,11.5212035578,
	11.5154668593,11.5097755275,11.5041288896,11.4985262872,11.492967076,
	11.4874506251,11.481976317,11.476543547,11.4711517229,11.4658002646,
	11.4604886041,11.4552161848,11.4499824613,11.4447868992,11.4396289748,
	11.4345081747,11.4294239957,11.4243759445,11.4193635374,11.4143862999,
	11.4094437668,11.4045354818,11.3996609973,11.3948198741,11.3900116812,
	11.3852359959,11.3804924032,11.3757804958,11.3710998738,11.3664501448,
	11.3618309235,11.3572418314,11.352682497,11.3481525553,11.343651648,
	11.3391794229,11.3347355343,11.3303196421,11.3259314125,11.3215705175,
	11.3172366344,11.3129294464,11.308648642,11.3043939148,11.3001649638,
	11.2959614929,11.2917832111,11.287629832,11.2835010742,11.2793966607,
	11.2753163193,11.2712597818,11.2672267849,11.2632170691,11.2592303792,
	11.2552664641,11.2513250768,11.2474059739,11.2435089161,11.2396336677,
	11.2357799968,11.231947675,11.2281364774,11.2243461825,11.2205765725,
	11.2168274325,11.2130985511,11.20938972,11.2057007341,11.2020313913,
	11.1983814924,11.1947508414,11.191139245,11.1875465127,11.1839724569,
	11.1804168926,11.1768796377,11.1733605125,11.1698593399,11.1663759453,
	11.1629101568,11.1594618047,11.1560307218,11.1526167432,11.1492197062,
	11.1458394505,11.1424758181,11.139128653,11.1357978013,11.1324831114,
	11.1291844336,11.1259016203,11.1226345259,11.1193830067,11.116146921,
	11.1129261288,11.1097204922,11.106529875,11.1033541428,11.1001931629,
	11.0970468044,11.0939149382,11.0907974366,11.0876941738,11.0846050255,
	11.0815298689,11.0784685831,11.0754210483,11.0723871464,11.0693667609,
	11.0663597766,11.0633660798,11.0603855582,11.057418101,11.0544635984,
	11.0515219425,11.0485930262,11.0456767441,11.0427729918,11.0398816664,
	11.037002666,11.03413589,11.0312812392,11.0284386153,11.0256079213,
	11.0227890614,11.0199819408,11.0171864659,11.0144025442,11.0116300842,
	11.0088689955,11.0061191889,11.0033805759,11.0006530693,10.9979365828,
	10.995231031,10.9925363296,10.9898523953,10.9871791455,10.9845164987,
	10.9818643744,10.9792226927,10.9765913749,10.973970343,10.9713595199,
	10.9687588294,10.966168196,10.9635875452,10.9610168032,10.958455897,
	10.9559047544,10.9533633041,10.9508314753,10.9483091981,10.9457964036,
	10.9432930231,10.9407989891,10.9383142346,10.9358386933,10.9333722997,
	10.9309149888,10.9284666965,10.9260273592,10.9235969141,10.9211752989,
	10.918762452,10.9163583124,10.9139628199,10.9115759146,10.9091975376,
	10.9068276301,10.9044661344,10.9021129931,10.8997681494,10.897431547,
	10.8951031304,10.8927828445,10.8904706346,10.8881664469,10.8858702277,
	10.8835819242,10.8813014839,10.8790288549,10.8767639858,10.8745068256,
	10.8722573238,10.8700154307,10.8677810966,10.8655542726,10.8633349101,
	10.8611229611,10.858918378,10.8567211136,10.8545311212,10.8523483545,
	10.8501727677,10.8480043152,10.8458429523,10.8436886341,10.8415413167,
	10.8394009562,10.8372675093,10.835140933,10.8330211848,10.8309082224,
	10.8288020042,10.8267024885,10.8246096345,10.8225234015,10.8204437491,
	10.8183706374,10.8163040268,10.814243878,10.8121901523,10.810142811,
	10.808101816,10.8060671293,10.8040387134,10.8020165312,10.8000005458,
	10.7979907206,10.7959870193,10.7939894061,10.7919978453,10.7900123016,
	10.78803274,10.7860591258,10.7840914245,10.7821296022,10.7801736249,
	10.7782234591,10.7762790716,10.7743404294,10.7724074997,10.7704802502,
	10.7685586487,10.7666426633,10.7647322624,10.7628274146,10.7609280889,
	10.7590342543,10.7571458804,10.7552629368,10.7533853933,10.7515132202,
	10.7496463878,10.7477848668,10.7459286281,10.7440776428,10.7422318821,
	10.7403913178,10.7385559216,10.7367256655,10.7349005218,10.733080463,
	10.7312654617,10.7294554909,10.7276505236,10.7258505333,10.7240554935,
	10.7222653779,10.7204801604,10.7186998153,10.7169243169,10.7151536397,
	10.7133877585,10.7116266483,10.7098702842,10.7081186416,10.7063716959,
	10.7046294229,10.7028917984,10.7011587986,10.6994303997,10.6977065782,
	10.6959873106,10.6942725738,10.6925623448,10.6908566006,10.6891553186,
	10.6874584763,10.6857660513,10.6840780214,10.6823943647,10.6807150592,
	10.6790400833,10.6773694155,10.6757030342,10.6740409184,10.672383047,
	10.670729399,10.6690799537,10.6674346905,10.6657935889,10.6641566286,
	10.6625237894,10.6608950514,10.6592703946,10.6576497992,10.6560332458,
	10.6544207148,10.652812187,10.6512076431,10.649607064,10.648010431,
	10.6464177252,10.6448289279,10.6432440207,10.6416629851,10.6400858029,
	10.6385124561,10.6369429264,10.6353771962,10.6338152476,10.6322570629,
	10.6307026248,10.6291519157,10.6276049185,10.6260616159,10.6245219909,
	10.6229860266,10.6214537063,10.6199250131,10.6183999305,10.6168784421,
	10.6153605315,10.6138461824,10.6123353787,10.6108281044,10.6093243435,
	10.6078240803,10.606327299,10.604833984,10.6033441198,10.601857691,
	10.6003746823,10.5988950785,10.5974188645,10.5959460253,10.594476546,
	10.5930104118,10.591547608,10.5900881199,10.5886319331,10.587179033,
	10.5857294055,10.5842830362,10.582839911,10.5814000159,10.5799633368,
	10.5785298599,10.5770995713,10.5756724575,10.5742485048,10.5728276996,
	10.5714100285,10.5699954782,10.5685840353,10.5671756867,10.5657704192,
	10.56436822,10.5629690759,10.5615729741,10.5601799019,10.5587898465,
	10.5574027953,10.5560187358,10.5546376555,10.553259542,10.5518843829,
	10.5505121661,10.5491428794,10.5477765106,10.5464130478,10.545052479,
	10.5436947924,10.542339976,10.5409880183,10.5396389075,10.5382926321,
	10.5369491805,10.5356085412,10.534270703,10.5329356545,10.5316033844,
	10.5302738816,10.5289471349,10.5276231333,10.5263018658,10.5249833215,
	10.5236674896,10.5223543592,10.5210439197,10.5197361604,10.5184310706,
	10.5171286399,10.5158288577,10.5145317137,10.5132371974,10.5119452987,
	10.5106560072,10.5093693128,10.5080852054,10.5068036749,10.5055247113,
	10.5042483047,10.5029744451,10.5017031228,10.500434328,10.4991680509,
	10.4979042819,10.4966430114,10.4953842299,10.4941279277,10.4928740956,
	10.4916227241,10.4903738038,10.4891273254,10.4878832798,10.4866416578,
	10.4854024501,10.4841656478,10.4829312418,10.4816992231,10.4804695828,
	10.479242312,10.4780174018,10.4767948436,10.4755746285,10.4743567478,
	10.473141193,10.4719279554,10.4707170265,10.4695083978,10.4683020608,
	10.4670980071,10.4658962284,10.4646967163,10.4634994626,10.462304459,
	10.4611116974,10.4599211696,10.4587328676,10.4575467832,10.4563629085,
	10.4551812355,10.4540017563,10.4528244629,10.4516493477,10.4504764027,
	10.4493056202,10.4481369925,10.4469705119,10.4458061707,10.4446439615,
	10.4434838766,10.4423259085,10.4411700498,10.440016293,10.4388646307,
	10.4377150555,10.4365675602,10.4354221374,10.4342787799,10.4331374805,
	10.431998232,10.4308610273,10.4297258594,10.428592721,10.4274616053,
	10.4263325051,10.4252054137,10.424080324,10.4229572292,10.4218361224,
	10.4207169968,10.4195998456,10.4184846622,10.4173714397,10.4162601715,
	10.415150851,10.4140434716,10.4129380266,10.4118345096,10.4107329141,
	10.4096332334,10.4085354613,10.4074395913,10.406345617,10.4052535321,
	10.4041633302,10.4030750051,10.4019885505,10.4009039602,10.399821228,
	10.3987403477,10.3976613133,10.3965841185,10.3955087573,10.3944352237,
	10.3933635117,10.3922936153,10.3912255285,10.3901592453,10.38909476,
	10.3880320667,10.3869711594,10.3859120324,10.3848546798,10.3837990961,
	10.3827452753,10.3816932118,10.3806429,10.3795943341,10.3785475086,
	10.3775024179,10.3764590564,10.3754174186,10.3743774989,10.3733392918,
	10.372302792,10.3712679939,10.3702348921,10.3692034814,10.3681737562,
	10.3671457113,10.3661193413,10.3650946411,10.3640716052,10.3630502285,
	10.3620305058,10.3610124319,10.3599960016,10.3589812097,10.3579680513,
	10.3569565211,10.3559466141,10.3549383252,10.3539316495,10.3529265819,
	10.3519231175,10.3509212512,10.3499209783,10.3489222937,10.3479251926,
	10.3469296702,10.3459357215,10.3449433417,10.3439525261,10.34296327,
	10.3419755684,10.3409894167,10.3400048103,10.3390217443,10.3380402141,
	10.3370602152,10.3360817428,10.3351047923,10.3341293592,10.3331554389,
	10.3321830268,10.3312121185,10.3302427094,10.329274795,10.328308371,
	10.3273434327,10.3263799758,10.3254179959,10.3244574887,10.3234984496,
	10.3225408745,10.3215847589,10.3206300986,10.3196768893,10.3187251266,
	10.3177748064,10.3168259243,10.3158784763,10.314932458,10.3139878654,
	10.3130446942,10.3121029402,10.3111625995,10.3102236678,10.3092861411,
	10.3083500153,10.3074152863,10.3064819501,10.3055500027,10.3046194401,
	10.3036902583,10.3027624533,10.3018360211,10.3009109579,10.2999872597,
	10.2990649226,10.2981439428,10.2972243163,10.2963060392,10.2953891079,
	10.2944735184,10.2935592669,10.2926463497,10.2917347629,10.2908245028,
	10.2899155658,10.2890079479,10.2881016456,10.2871966552,10.2862929729,
	10.2853905951,10.2844895182,10.2835897384,10.2826912523,10.2817940561,
	10.2808981464,10.2800035195,10.2791101718,10.2782180999,10.2773273001,
	10.276437769,10.2755495031,10.2746624989,10.2737767529,10.2728922617,
	10.2720090217,10.2711270297,10.270246282,10.2693667755,10.2684885066,
	10.267611472,10.2667356684,10.2658610923,10.2649877404,10.2641156095,
	10.2632446962,10.2623749972,10.2615065093,10.2606392291,10.2597731535,
	10.2589082791,10.2580446028,10.2571821213,10.2563208314,10.2554607299,
	10.2546018137,10.2537440796,10.2528875244,10.2520321451,10.2511779383,
	10.2503249012,10.2494730304,10.248622323,10.2477727759,10.246924386,
	10.2460771503,10.2452310656,10.2443861291,10.2435423375,10.2426996881,
	10.2418581776,10.2410178033,10.240178562,10.2393404509,10.2385034669,
	10.2376676072,10.2368328688,10.2359992488,10.2351667443,10.2343353523,
	10.2335050701,10.2326758948,10.2318478234,10.2310208532,10.2301949812,
	10.2293702048,10.228546521,10.227723927,10.2269024201,10.2260819974,
	10.2252626562,10.2244443938,10.2236272073,10.2228110941,10.2219960513,
	10.2211820763,10.2203691664,10.2195573189,10.218746531,10.2179368001,
	10.2171281235,10.2163204986,10.2155139227,10.2147083931,10.2139039073,
	10.2131004626,10.2122980563,10.211496686,10.210696349,10.2098970426,
	10.2090987645,10.2083015118,10.2075052823,10.2067100732,10.205915882,
	10.2051227063,10.2043305434,10.2035393909,10.2027492464,10.2019601072,
	10.201171971,10.2003848352,10.1995986974,10.1988135551,10.1980294059,
	10.1972462474,10.196464077,10.1956828925,10.1949026914,10.1941234713,
	10.1933452298,10.1925679646,10.1917916732,10.1910163532,10.1902420024,
	10.1894686184,10.1886961988,10.1879247413,10.1871542435,10.1863847033,
	10.1856161182,10.184848486,10.1840818043,10.1833160709,10.1825512835,
	10.1817874399,10.1810245377,10.1802625748,10.1795015489,10.1787414578,
	10.1779822991,10.1772240708,10.1764667706,10.1757103963,10.1749549457,
	10.1742004166,10.1734468068,10.1726941142,10.1719423366,10.1711914719,
	10.1704415178,10.1696924723,10.1689443332,10.1681970984,10.1674507657,
	10.1667053332,10.1659607985,10.1652171598,10.1644744147,10.1637325614,
	10.1629915977,10.1622515215,10.1615123307,10.1607740234,10.1600365975,
	10.1593000509,10.1585643816,10.1578295875,10.1570956667,10.1563626172,
	10.1556304369,10.1548991238,10.1541686759,10.1534390913,10.152710368,
	10.151982504,10.1512554973,10.150529346,10.1498040481,10.1490796017,
	10.1483560048,10.1476332556,10.1469113521,10.1461902923,10.1454700743,
	10.1447506963,10.1440321564,10.1433144526,10.1425975831,10.1418815459,
	10.1411663393,10.1404519613,10.1397384101,10.1390256838,10.1383137806,
	10.1376026987,10.1368924361,10.136182991,10.1354743617,10.1347665464,
	10.1340595431,10.1333533501,10.1326479656,10.1319433879,10.131239615,
	10.1305366452,10.1298344768,10.129133108,10.128432537,10.127732762,
	10.1270337813,10.1263355932,10.1256381959,10.1249415876,10.1242457667,
	10.1235507314,10.12285648,10.1221630107,10.1214703219,10.1207784119,
	10.1200872789,10.1193969213,10.1187073373,10.1180185254,10.1173304838,
	10.1166432108,10.1159567048,10.1152709642,10.1145859872,10.1139017722,
	10.1132183176,10.1125356217,10.111853683,10.1111724997,10.1104920703,
	10.109812393,10.1091334665,10.1084552889,10.1077778587,10.1071011743,
	10.1064252342,10.1057500366,10.1050755801,10.1044018631,10.103728884,
	10.1030566412,10.1023851332,10.1017143583,10.1010443152,10.1003750021,
	10.0997064176,10.0990385601,10.0983714281,10.09770502,10.0970393344,
	10.0963743697,10.0957101244,10.095046597,10.094383786,10.0937216898,
	10.0930603071,10.0923996362,10.0917396758,10.0910804243,10.0904218802,
	10.0897640421,10.0891069086,10.088450478,10.0877947491,10.0871397203,
	10.0864853902,10.0858317573,10.0851788202,10.0845265774,10.0838750276,
	10.0832241693,10.0825740011,10.0819245215,10.0812757291,10.0806276226,
	10.0799802005,10.0793334614,10.078687404,10.0780420267,10.0773973283,
	10.0767533074,10.0761099625,10.0754672923,10.0748252955,10.0741839705,
	10.0735433162
	}},
	{ // Ri = 250k
	-15,15,66.6667,2001, {
	91.4720662698,91.4025653335,91.333048564,91.2635159512,91.1939674851,
	91.1244031556,91.0548229526,90.9852268661,90.9156148858,90.8459870017,
	90.7763432036,90.7066834811,90.6370078241,90.5673162224,90.4976086656,
	90.4278851434,90.3581456456,90.2883901616,90.2186186812,90.1488311939,
	90.0790276892,90.0092081568,89.9393725861,89.8695209666,89.7996532878,
	89.7297695391,89.6598697098,89.5899537895,89.5200217674,89.4500736328,
	89.3801093751,89.3101289836,89.2401324474,89.1701197558,89.1000908981,
	89.0300458633,88.9599846406,88.8899072192,88.8198135881,88.7497037363,
	88.679577653,88.6094353271,88.5392767476,88.4691019035,88.3989107837,
	88.328703377,88.2584796725,88.1882396588,88.1179833248,88.0477106594,
	87.9774216512,87.9071162891,87.8367945617,87.7664564576,87.6961019656,
	87.6257310743,87.5553437723,87.4849400481,87.4145198902,87.3440832873,
	87.2736302277,87.2031606999,87.1326746924,87.0621721935,86.9916531916,
	86.921117675,86.8505656322,86.7799970512,86.7094119204,86.6388102281,
	86.5681919624,86.4975571114,86.4269056633,86.3562376063,86.2855529283,
	86.2148516175,86.1441336618,86.0733990492,86.0026477678,85.9318798054,
	85.8610951499,85.7902937892,85.7194757111,85.6486409035,85.577789354,
	85.5069210505,85.4360359807,85.3651341323,85.2942154929,85.2232800501,
	85.1523277915,85.0813587048,85.0103727773,84.9393699967,84.8683503504,
	84.7973138258,84.7262604104,84.6551900914,84.5841028564,84.5129986925,
	84.441877587,84.3707395273,84.2995845004,84.2284124937,84.1572234942,
	84.0860174891,84.0147944654,83.9435544103,83.8722973107,83.8010231537,
	83.7297319261,83.6584236149,83.5870982071,83.5157556894,83.4443960487,
	83.3730192718,83.3016253455,83.2302142564,83.1587859913,83.0873405368,
	83.0158778796,82.9443980062,82.8729009033,82.8013865573,82.7298549547,
	82.658306082,82.5867399256,82.5151564719,82.4435557073,82.3719376181,
	82.3003021905,82.2286494108,82.1569792653,82.08529174,82.0135868213,
	81.9418644951,81.8701247475,81.7983675647,81.7265929325,81.654800837,
	81.5829912642,81.5111641998,81.4393196298,81.36745754,81.2955779162,
	81.2236807441,81.1517660095,81.079833698,81.0078837953,80.9359162871,
	80.8639311588,80.791928396,80.7199079843,80.647869909,80.5758141557,
	80.5037407096,80.4316495563,80.3595406808,80.2874140687,80.215269705,
	80.143107575,80.0709276638,79.9987299566,79.9265144385,79.8542810945,
	79.7820299097,79.7097608689,79.6374739572,79.5651691595,79.4928464605,
	79.4205058451,79.3481472982,79.2757708043,79.2033763484,79.1309639149,
	79.0585334885,78.9860850539,78.9136185955,78.8411340978,78.7686315454,
	78.6961109226,78.6235722139,78.5510154035,78.4784404759,78.4058474151,
	78.3332362056,78.2606068313,78.1879592766,78.1152935255,78.042609562,
	77.9699073702,77.897186934,77.8244482374,77.7516912643,77.6789159985,
	77.6061224239,77.5333105241,77.460480283,77.3876316842,77.3147647114,
	77.2418793481,77.1689755779,77.0960533843,77.0231127509,76.9501536609,
	76.8771760979,76.8041800451,76.7311654859,76.6581324034,76.585080781,
	76.5120106018,76.4389218488,76.3658145053,76.2926885541,76.2195439784,
	76.146380761,76.0731988848,75.9999983328,75.9267790877,75.8535411323,
	75.7802844492,75.7070090213,75.6337148311,75.5604018611,75.4870700941,
	75.4137195123,75.3403500983,75.2669618345,75.1935547033,75.1201286868,
	75.0466837675,74.9732199275,74.899737149,74.8262354141,74.7527147049,
	74.6791750033,74.6056162915,74.5320385513,74.4584417646,74.3848259132,
	74.311190979,74.2375369436,74.1638637888,74.0901714961,74.0164600473,
	73.9427294238,73.8689796072,73.7952105788,73.7214223201,73.6476148124,
	73.573788037,73.4999419753,73.4260766082,73.3521919172,73.2782878831,
	73.2043644871,73.1304217102,73.0564595332,72.9824779372,72.908476903,
	72.8344564112,72.7604164428,72.6863569784,72.6122779985,72.5381794839,
	72.464061415,72.3899237724,72.3157665364,72.2415896874,72.1673932058,
	72.0931770718,72.0189412657,71.9446857676,71.8704105576,71.7961156158,
	71.7218009223,71.6474664568,71.5731121994,71.4987381299,71.4243442281,
	71.3499304737,71.2754968464,71.2010433258,71.1265698915,71.052076523,
	70.9775631998,70.9030299012,70.8284766067,70.7539032955,70.6793099468,
	70.6046965398,70.5300630537,70.4554094675,70.3807357603,70.3060419109,
	70.2313278982,70.1565937012,70.0818392986,70.0070646691,69.9322697913,
	69.857454644,69.7826192055,69.7077634545,69.6328873694,69.5579909284,
	69.48307411,69.4081368924,69.3331792538,69.2582011722,69.1832026259,
	69.1081835928,69.0331440508,68.9580839779,68.8830033518,68.8079021504,
	68.7327803514,68.6576379324,68.5824748709,68.5072911447,68.432086731,
	68.3568616072,68.2816157509,68.2063491391,68.1310617492,68.0557535582,
	67.9804245433,67.9050746815,67.8297039498,67.754312325,67.678899784,
	67.6034663035,67.5280118603,67.452536431,67.3770399922,67.3015225204,
	67.2259839921,67.1504243835,67.0748436711,66.9992418311,66.9236188397,
	66.8479746729,66.7723093069,66.6966227176,66.620914881,66.5451857729,
	66.469435369,66.3936636451,66.3178705769,66.2420561399,66.1662203096,
	66.0903630615,66.0144843709,65.9385842133,65.8626625637,65.7867193973,
	65.7107546894,65.6347684148,65.5587605485,65.4827310655,65.4066799406,
	65.3306071485,65.2545126638,65.1783964612,65.1022585152,65.0260988003,
	64.9499172909,64.8737139613,64.7974887857,64.7212417382,64.6449727931,
	64.5686819244,64.4923691059,64.4160343116,64.3396775152,64.2632986906,
	64.1868978113,64.110474851,64.0340297832,63.9575625812,63.8810732185,
	63.8045616683,63.7280279039,63.6514718984,63.5748936248,63.4982930561,
	63.4216701653,63.345024925,63.2683573082,63.1916672875,63.1149548354,
	63.0382199245,62.9614625273,62.884682616,62.8078801629,62.7310551404,
	62.6542075204,62.5773372751,62.5004443763,62.4235287961,62.3465905061,
	62.2696294782,62.1926456839,62.1156390948,62.0386096824,61.9615574181,
	61.8844822732,61.807384219,61.7302632266,61.6531192671,61.5759523114,
	61.4987623306,61.4215492953,61.3443131763,61.2670539444,61.18977157,
	61.1124660236,61.0351372758,60.9577852966,60.8804100565,60.8030115256,
	60.7255896738,60.6481444713,60.5706758878,60.4931838932,60.4156684572,
	60.3381295494,60.2605671394,60.1829811966,60.1053716904,60.02773859,
	59.9500818648,59.8724014836,59.7946974157,59.7169696299,59.6392180949,
	59.5614427797,59.4836436528,59.4058206828,59.3279738381,59.2501030872,
	59.1722083984,59.0942897398,59.0163470795,58.9383803856,58.860389626,
	58.7823747686,58.704335781,58.6262726309,58.5481852859,58.4700737134,
	58.3919378808,58.3137777554,58.2355933043,58.1573844946,58.0791512934,
	58.0008936675,57.9226115836,57.8443050086,57.765973909,57.6876182513,
	57.609238002,57.5308331273,57.4524035935,57.3739493666,57.2954704128,
	57.216966698,57.1384381878,57.0598848482,56.9813066448,56.9027035429,
	56.8240755082,56.7454225059,56.6667445012,56.5880414594,56.5093133453,
	56.430560124,56.3517817603,56.2729782189,56.1941494645,56.1152954615,
	56.0364161743,55.9575115674,55.8785816049,55.799626251,55.7206454696,
	55.6416392247,55.56260748,55.4835501993,55.4044673462,55.3253588842,
	55.2462247765,55.1670649867,55.0878794777,55.0086682127,54.9294311547,
	54.8501682665,54.7708795108,54.6915648504,54.6122242477,54.5328576652,
	54.4534650652,54.37404641,54.2946016616,54.215130782,54.1356337332,
	54.056110477,53.9765609749,53.8969851887,53.8173830797,53.7377546092,
	53.6580997387,53.578418429,53.4987106414,53.4189763367,53.3392154757,
	53.259428019,53.1796139274,53.0997731611,53.0199056807,52.9400114463,
	52.860090418,52.780142556,52.7001678201,52.62016617,52.5401375655,
	52.4600819662,52.3799993315,52.2998896207,52.2197527931,52.1395888078,
	52.0593976238,51.9791792,51.8989334951,51.8186604679,51.7383600768,
	51.6580322804,51.5776770368,51.4972943044,51.4168840412,51.3364462052,
	51.2559807542,51.175487646,51.0949668382,51.0144182883,50.9338419537,
	50.8532377917,50.7726057595,50.691945814,50.6112579123,50.5305420111,
	50.4497980671,50.369026037,50.2882258771,50.2073975438,50.1265409934,
	50.045656182,49.9647430655,49.8838015999,49.8028317408,49.7218334441,
	49.640806665,49.5597513592,49.4786674819,49.3975549882,49.3164138333,
	49.235243972,49.1540453592,49.0728179496,48.9915616978,48.9102765583,
	48.8289624854,48.7476194334,48.6662473564,48.5848462084,48.5034159433,
	48.4219565148,48.3404678767,48.2589499825,48.1774027856,48.0958262393,
	48.0142202968,47.9325849112,47.8509200355,47.7692256225,47.6875016249,
	47.6057479954,47.5239646865,47.4421516505,47.3603088398,47.2784362065,
	47.1965337027,47.1146012802,47.032638891,46.9506464867,46.8686240189,
	46.7865714392,46.7044886988,46.6223757492,46.5402325413,46.4580590263,
	46.3758551551,46.2936208785,46.2113561472,46.1290609119,46.046735123,
	45.964378731,45.8819916861,45.7995739385,45.7171254382,45.6346461354,
	45.5521359797,45.469594921,45.3870229089,45.304419893,45.2217858227,
	45.1391206474,45.0564243164,44.9736967787,44.8909379835,44.8081478797,
	44.7253264162,44.6424735416,44.5595892048,44.4766733542,44.3937259384,
	44.3107469057,44.2277362044,44.1446937827,44.0616195888,43.9785135707,
	43.8953756763,43.8122058534,43.72900405,43.6457702135,43.5625042917,
	43.4792062321,43.3958759821,43.3125134891,43.2291187003,43.1456915631,
	43.0622320245,42.9787400316,42.8952155314,42.8116584709,42.728068797,
	42.6444464563,42.5607913957,42.4771035618,42.3933829013,42.3096293607,
	42.2258428864,42.1420234251,42.058170923,41.9742853265,41.8903665819,
	41.8064146354,41.7224294333,41.6384109217,41.5543590468,41.4702737546,
	41.3861549912,41.3020027026,41.2178168348,41.1335973339,41.0493441457,
	40.9650572162,40.8807364912,40.7963819168,40.7119934387,40.6275710029,
	40.5431145551,40.4586240414,40.3740994075,40.2895405993,40.2049475627,
	40.1203202436,40.0356585879,39.9509625415,39.8662320505,39.7814670606,
	39.696667518,39.6118333687,39.5269645588,39.4420610343,39.3571227415,
	39.2721496266,39.1871416358,39.1020987155,39.0170208121,38.931907872,
	38.8467598418,38.7615766681,38.6763582976,38.5911046772,38.5058157537,
	38.4204914742,38.3351317856,38.2497366353,38.1643059707,38.078839739,
	37.993337888,37.9078003654,37.8222271191,37.736618097,37.6509732475,
	37.5652925187,37.4795758594,37.393823218,37.3080345436,37.2222097853,
	37.1363488922,37.050451814,36.9645185003,36.878548901,36.7925429664,
	36.7065006468,36.6204218929,36.5343066557,36.4481548863,36.3619665363,
	36.2757415573,36.1894799016,36.1031815213,36.0168463694,35.9304743987,
	35.8440655627,35.7576198151,35.6711371099,35.5846174017,35.4980606453,
	35.4114667959,35.3248358092,35.2381676413,35.1514622488,35.0647195885,
	34.977939618,34.8911222952,34.8042675784,34.7173754266,34.6304457992,
	34.5434786562,34.4564739582,34.3694316662,34.2823517418,34.1952341474,
	34.1080788459,34.0208858008,33.9336549763,33.8463863371,33.759079849,
	33.671735478,33.5843531912,33.4969329563,33.4094747418,33.3219785169,
	33.2344442517,33.1468719172,33.059261485,32.9716129278,32.8839262192,
	32.7962013336,32.7084382463,32.6206369338,32.5327973734,32.4449195434,
	32.3570034234,32.2690489937,32.181056236,32.093025133,32.0049556686,
	31.9168478278,31.828701597,31.7405169636,31.6522939165,31.5640324458,
	31.4757325429,31.3873942008,31.2990174136,31.2106021771,31.1221484885,
	31.0336563464,30.9451257512,30.8565567046,30.7679492103,30.6793032734,
	30.5906189007,30.501896101,30.4131348847,30.3243352641,30.2354972535,
	30.1466208689,30.0577061285,29.9687530525,29.8797616631,29.7907319847,
	29.7016640439,29.6125578695,29.5234134926,29.4342309467,29.3450102677,
	29.2557514939,29.1664546662,29.0771198279,28.9877470253,28.8983363072,
	28.8088877251,28.7194013335,28.6298771898,28.5403153542,28.4507158903,
	28.3610788645,28.2714043466,28.1816924095,28.0919431298,28.0021565872,
	27.912332865,27.8224720503,27.7325742336,27.6426395095,27.5526679763,
	27.4626597363,27.3726148957,27.2825335652,27.1924158596,27.102261898,
	27.012071804,26.9218457058,26.8315837364,26.7412860335,26.6509527396,
	26.5605840025,26.4701799749,26.379740815,26.2892666863,26.1987577579,
	26.1082142046,26.0176362069,25.9270239513,25.8363776305,25.7456974435,
	25.6549835955,25.5642362985,25.4734557711,25.3826422389,25.2917959344,
	25.2009170976,25.1100059758,25.0190628239,24.9280879048,24.8370814892,
	24.7460438562,24.6549752934,24.5638760969,24.4727465717,24.3815870322,
	24.2903978019,24.1991792143,24.1079316124,24.0166553497,23.9253507902,
	23.8340183085,23.7426582906,23.6512711336,23.5598572469,23.4684170516,
	23.3769509816,23.2854594838,23.1939430185,23.1024020599,23.0108370963,
	22.9192486313,22.8276371837,22.7360032884,22.6443474969,22.5526703781,
	22.460972519,22.3692545255,22.2775170231,22.185760658,22.0939860982,
	22.0021940342,21.9103851804,21.8185602766,21.7267200891,21.6348654123,
	21.5429970705,21.4511159197,21.3592228495,21.2673187856,21.1754046921,
	21.0834815743,20.9915504817,20.8996125112,20.8076688112,20.7157205851,
	20.6237690966,20.5318156739,20.4398617162,20.347908699,20.2559581819,
	20.1640118159,20.0720713519,19.9801386506,19.8882156928,19.7963045915,
	19.7044076053,19.6125271527,19.5206658289,19.4288264238,19.3370119427,
	19.2452256288,19.1534709884,19.0617518189,18.9700722405,18.8784367302,
	18.7868501607,18.695317843,18.6038455732,18.5124396856,18.4211071093,
	18.3298554325,18.2386929717,18.1476288488,18.0566730746,17.96583664,
	17.8751316156,17.7845712583,17.6941701273,17.6039442072,17.5139110396,
	17.4240898609,17.3345017474,17.2451697639,17.1561191156,17.0673773005,
	16.9789742571,16.8909425067,16.8033172813,16.7161366339,16.6294415238,
	16.543275868,16.4576865514,16.3727233858,16.2884390096,16.2048887185,
	16.1221302193,16.0402233014,15.9592294205,15.8792111953,15.8002318197,
	15.722354398,15.645641216,15.5701529649,15.4959479398,15.4230812378,
	15.3516039832,15.2815626063,15.2129982041,15.1459460041,15.0804349514,
	15.0164874304,14.9541191283,14.8933390375,14.8341495926,14.7765469258,
	14.7205212269,14.666057186,14.613134499,14.5617284143,14.5118103016,
	14.4633482244,14.416307501,14.3706512425,14.3263408574,14.2833365164,
	14.2415975742,14.2010829446,14.1617514303,14.123562008,14.0864740705,
	14.0504476292,14.0154434808,13.9814233405,13.9483499465,13.916187139,
	13.8848999168,13.8544544747,13.8248182253,13.7959598067,13.7678490788,
	13.7404571114,13.7137561638,13.687719659,13.6623221534,13.6375393033,
	13.6133478283,13.5897254735,13.5666509708,13.5441039994,13.5220651467,
	13.5005158687,13.4794384524,13.4588159774,13.4386322802,13.4188719181,
	13.3995201351,13.3805628295,13.3619865217,13.3437783242,13.3259259125,
	13.3084174978,13.2912418002,13.2743880241,13.257845834,13.2416053319,
	13.225657036,13.2099918601,13.1946010942,13.1794763863,13.1646097248,
	13.1499934221,13.135620099,13.1214826698,13.1075743286,13.0938885354,
	13.0804190041,13.0671596902,13.05410478,13.0412486791,13.0285860032,
	13.0161115676,13.0038203789,12.9917076257,12.979768671,12.9679990438,
	12.9563944323,12.9449506767,12.9336637624,12.9225298139,12.911545089,
	12.9007059725,12.8900089714,12.8794507096,12.8690279227,12.8587374541,
	12.8485762496,12.838541354,12.8286299067,12.8188391381,12.8091663657,
	12.7996089909,12.7901644957,12.7808304392,12.7716044552,12.7624842487,
	12.7534675936,12.74455233,12.7357363617,12.7270176537,12.7183942301,
	12.7098641717,12.7014256144,12.6930767465,12.6848158076,12.6766410861,
	12.6685509177,12.660543684,12.6526178105,12.6447717653,12.6370040575,
	12.629313236,12.621697888,12.6141566376,12.6066881448,12.5992911042,
	12.5919642437,12.5847063239,12.5775161363,12.5703925031,12.5633342753,
	12.5563403329,12.5494095829,12.5425409591,12.5357334211,12.5289859534,
	12.5222975649,12.5156672878,12.509094177,12.5025773097,12.4961157844,
	12.4897087203,12.4833552568,12.4770545528,12.4708057864,12.4646081538,
	12.4584608695,12.4523631649,12.4463142888,12.4403135061,12.4343600976,
	12.4284533599,12.4225926043,12.4167771571,12.4110063587,12.4052795632,
	12.3995961385,12.3939554654,12.3883569375,12.3827999609,12.3772839538,
	12.371808346,12.3663725791,12.3609761055,12.3556183888,12.3502989029,
	12.3450171324,12.3397725716,12.3345647248,12.329393106,12.3242572381,
	12.3191566536,12.3140908936,12.3090595078,12.3040620544,12.2990981,
	12.294167219,12.2892689938,12.2844030143,12.279568878,12.2747661897,
	12.2699945613,12.2652536116,12.2605429662,12.2558622574,12.2512111239,
	12.246589211,12.2419961697,12.2374316575,12.2328953377,12.2283868791,
	12.2239059566,12.2194522503,12.2150254459,12.2106252342,12.2062513112,
	12.2019033782,12.1975811412,12.1932843111,12.1890126035,12.1847657387,
	12.1805434416,12.1763454413,12.1721714716,12.1680212702,12.1638945793,
	12.1597911449,12.1557107171,12.1516530499,12.1476179013,12.1436050329,
	12.1396142099,12.1356452012,12.1316977794,12.1277717202,12.1238668031,
	12.1199828106,12.1161195286,12.1122767463,12.1084542558,12.1046518525,
	12.1008693347,12.0971065036,12.0933631635,12.0896391214,12.085934187,
	12.082248173,12.0785808945,12.0749321696,12.0713018185,12.0676896644,
	12.0640955328,12.0605192515,12.056960651,12.0534195639,12.0498958253,
	12.0463892725,12.042899745,12.0394270845,12.035971135,12.0325317423,
	12.0291087546,12.0257020219,12.0223113965,12.0189367323,12.0155778854,
	12.0122347137,12.008907077,12.005594837,12.002297857,11.9990160022,
	11.9957491397,11.992497138,11.9892598676,11.9860372004,11.9828290101,
	11.9796351719,11.9764555626,11.9732900606,11.9701385459,11.9670008996,
	11.9638770049,11.9607667458,11.9576700083,11.9545866794,11.9515166476,
	11.9484598029,11.9454160365,11.9423852409,11.9393673099,11.9363621387,
	11.9333696236,11.9303896623,11.9274221534,11.9244669971,11.9215240946,
	11.9185933481,11.9156746612,11.9127679385,11.9098730857,11.9069900096,
	11.9041186182,11.9012588203,11.898410526,11.8955736463,11.8927480931,
	11.8899337796,11.8871306197,11.8843385284,11.8815574216,11.8787872162,
	11.8760278299,11.8732791815,11.8705411905,11.8678137775,11.8650968637,
	11.8623903714,11.8596942236,11.8570083442,11.854332658,11.8516670904,
	11.8490115678,11.8463660174,11.8437303669,11.841104545,11.8384884812,
	11.8358821056,11.8332853492,11.8306981434,11.8281204208,11.8255521142,
	11.8229931575,11.820443485,11.8179030318,11.8153717338,11.8128495273,
	11.8103363494,11.8078321379,11.8053368309,11.8028503677,11.8003726876,
	11.7979037309,11.7954434385,11.7929917516,11.7905486122,11.788113963,
	11.7856877469,11.7832699077,11.7808603895,11.7784591372,11.7760660961,
	11.773681212,11.7713044313,11.7689357009,11.7665749681,11.7642221809,
	11.7618772877,11.7595402374,11.7572109793,11.7548894634,11.7525756399,
	11.7502694598,11.7479708742,11.7456798349,11.7433962941,11.7411202044,
	11.7388515189,11.7365901911,11.7343361749,11.7320894247,11.7298498953,
	11.7276175418,11.7253923199,11.7231741856,11.7209630953,11.7187590058,
	11.7165618743,11.7143716584,11.7121883159,11.7100118054,11.7078420855,
	11.7056791152,11.703522854,11.7013732618,11.6992302986,11.697093925,
	11.6949641018,11.6928407902,11.6907239518,11.6886135484,11.6865095422,
	11.6844118958,11.682320572,11.680235534,11.6781567453,11.6760841697,
	11.6740177712,11.6719575143,11.6699033638,11.6678552846,11.6658132421,
	11.6637772018,11.6617471296,11.6597229918,11.6577047548,11.6556923854,
	11.6536858505,11.6516851174,11.6496901538,11.6477009274,11.6457174063,
	11.6437395589,11.6417673539,11.63980076,11.6378397465,11.6358842826,
	11.633934338,11.6319898826,11.6300508866,11.6281173201,11.6261891539,
	11.6242663587,11.6223489057,11.620436766,11.6185299113,11.6166283132,
	11.6147319438,11.6128407751,11.6109547797,11.6090739301,11.6071981992,
	11.6053275599,11.6034619857,11.6016014498,11.599745926,11.5978953882,
	11.5960498104,11.594209167,11.5923734322,11.590542581,11.588716588,
	11.5868954283,11.5850790772,11.5832675101,11.5814607025,11.5796586304,
	11.5778612697,11.5760685964,11.574280587,11.572497218,11.570718466,
	11.5689443079,11.5671747208,11.5654096817,11.5636491682,11.5618931577,
	11.5601416279,11.5583945566,11.556651922,11.5549137022,11.5531798755,
	11.5514504204,11.5497253155,11.5480045398,11.5462880721,11.5445758915,
	11.5428679773,11.541164309,11.539464866,11.5377696281,11.5360785751,
	11.534391687,11.532708944,11.5310303262,11.5293558142,11.5276853884,
	11.5260190295,11.5243567183,11.5226984359,11.5210441633,11.5193938816,
	11.5177475723,11.5161052168,11.5144667967,11.5128322937,11.5112016897,
	11.5095749667,11.5079521067,11.5063330921,11.504717905,11.5031065281,
	11.5014989438,11.4998951349,11.4982950842,11.4966987746,11.4951061892,
	11.493517311,11.4919321235,11.49035061,11.4887727539,11.4871985389,
	11.4856279487,11.4840609671,11.482497578,11.4809377655,11.4793815137,
	11.4778288069,11.4762796293,11.4747339655,11.4731918,11.4716531174,
	11.4701179024,11.4685861401,11.4670578152,11.4655329128,11.464011418,
	11.4624933162,11.4609785926,11.4594672326,11.4579592218,11.4564545457,
	11.4549531901,11.4534551408,11.4519603836,11.4504689045,11.4489806895,
	11.4474957249,11.4460139968,11.4445354915,11.4430601955,11.4415880953,
	11.4401191773,11.4386534284,11.4371908351,11.4357313844,11.4342750632,
	11.4328218583,11.431371757,11.4299247462,11.4284808134,11.4270399456,
	11.4256021304,11.4241673552,11.4227356075,11.4213068749,11.4198811451,
	11.4184584058,11.417038645,11.4156218504,11.4142080101,11.4127971121,
	11.4113891445,11.4099840955,11.4085819534,11.4071827066,11.4057863433,
	11.4043928521,11.4030022216,11.4016144402,11.4002294968,11.3988473799,
	11.3974680785,11.3960915814,11.3947178776,11.393346956,11.3919788057,
	11.3906134158,11.3892507755,11.3878908741,11.3865337009,11.3851792453,
	11.3838274967,11.3824784446,11.3811320785,11.3797883881,11.3784473631,
	11.3771089932,11.3757732682,11.3744401779,11.3731097123,11.3717818613,
	11.370456615,11.3691339634,11.3678138967,11.3664964051,11.3651814787,
	11.363869108,11.3625592833,11.361251995,11.3599472335,11.3586449893,
	11.3573452532,11.3560480155,11.3547532672,11.3534609988,11.3521712011,
	11.350883865,11.3495989813,11.348316541,11.3470365351,11.3457589546,
	11.3444837905,11.343211034,11.3419406763,11.3406727085,11.339407122,
	11.338143908,11.336883058,11.3356245633,11.3343684154,11.3331146058,
	11.331863126,11.3306139677,11.3293671224,11.3281225819,11.3268803379,
	11.3256403821,11.3244027064,11.3231673026,11.3219341626,11.3207032784,
	11.3194746419,11.3182482452,11.3170240804,11.3158021395,11.3145824147,
	11.3133648982,11.3121495823,11.3109364591,11.3097255211,11.3085167606,
	11.30731017,11.3061057416,11.3049034681,11.3037033418,11.3025053554,
	11.3013095014,11.3001157725,11.2989241613,11.2977346605,11.2965472629,
	11.2953619612,11.2941787483,11.292997617,11.2918185602,11.2906415708,
	11.2894666417,11.288293766,11.2871229367,11.2859541469,11.2847873896,
	11.2836226579,11.2824599452,11.2812992444,11.280140549,11.2789838521,
	11.2778291471,11.2766764272,11.2755256859,11.2743769166,11.2732301127,
	11.2720852676,11.2709423749,11.2698014281,11.2686624208,11.2675253464,
	11.2663901988,11.2652569715,11.2641256582,11.2629962526,11.2618687485,
	11.2607431397,11.25961942,11.2584975831,11.257377623,11.2562595337,
	11.2551433089,11.2540289426,11.252916429,11.2518057618,11.2506969353,
	11.2495899435,11.2484847804,11.2473814403,11.2462799172,11.2451802053,
	11.2440822989,11.2429861923,11.2418918795,11.240799355,11.2397086132,
	11.2386196482,11.2375324545,11.2364470265,11.2353633587,11.2342814454,
	11.2332012812,11.2321228605,11.2310461779,11.229971228,11.2288980053,
	11.2278265044,11.22675672,11.2256886467,11.2246222791,11.2235576121,
	11.2224946403,11.2214333585,11.2203737614,11.2193158439,11.2182596008,
	11.2172050269,11.2161521171,11.2151008664,11.2140512695,11.2130033215,
	11.2119570173,11.2109123519,11.2098693203,11.2088279176,11.2077881388,
	11.206749979,11.2057134332,11.2046784967,11.2036451645,11.2026134318,
	11.2015832938,11.2005547458,11.1995277828,11.1985024003,11.1974785934,
	11.1964563574,11.1954356877,11.1944165796,11.1933990285,11.1923830297,
	11.1913685786,11.1903556706,11.1893443012,11.1883344659,11.18732616,
	11.1863193792,11.1853141188,11.1843103746,11.1833081419,11.1823074164,
	11.1813081936,11.1803104693,11.179314239,11.1783194983,11.1773262429,
	11.1763344686,11.175344171,11.1743553459,11.1733679889,11.1723820959,
	11.1713976626,11.1704146849,11.1694331585,11.1684530793,11.1674744431,
	11.1664972458,11.1655214833,11.1645471514,11.1635742462,11.1626027635,
	11.1616326993,11.1606640496,11.1596968103,11.1587309775,11.1577665472,
	11.1568035154,11.1558418782,11.1548816316,11.1539227718,11.1529652949,
	11.1520091969,11.151054474,11.1501011223,11.1491491381,11.1481985176,
	11.1472492568,11.146301352,11.1453547996,11.1444095956,11.1434657364,
	11.1425232183,11.1415820375,11.1406421904,11.1397036732,11.1387664824,
	11.1378306143,11.1368960652,11.1359628315,11.1350309096,11.134100296,
	11.1331709871,11.1322429793,11.131316269,11.1303908528,11.1294667271,
	11.1285438884,11.1276223332,11.1267020582,11.1257830597,11.1248653343,
	11.1239488788,11.1230336895,11.1221197631,11.1212070962,11.1202956855,
	11.1193855276,11.118476619,11.1175689566,11.116662537,11.1157573568,
	11.1148534127,11.1139507015,11.11304922,11.1121489648,11.1112499326,
	11.1103521204,11.1094555248,11.1085601426,11.1076659707,11.1067730059,
	11.1058812449,11.1049906847,11.1041013221,11.1032131539,11.102326177,
	11.1014403884,11.1005557849,11.0996723635,11.098790121,11.0979090545,
	11.0970291608,11.0961504369,11.0952728798,11.0943964866,11.093521254,
	11.0926471793,11.0917742594,11.0909024914,11.0900318722,11.0891623989,
	11.0882940687,11.0874268785,11.0865608255,11.0856959068,11.0848321194,
	11.0839694606,11.0831079273,11.0822475169,11.0813882263,11.0805300529,
	11.0796729937,11.0788170459,11.0779622068,11.0771084736,11.0762558434,
	11.0754043135,11.0745538811,11.0737045435,11.0728562979,11.0720091416,
	11.0711630719,11.0703180861,11.0694741814,11.0686313552,11.0677896048,
	11.0669489275,11.0661093207,11.0652707817,11.0644333078,11.0635968965,
	11.062761545,11.0619272509,11.0610940115,11.0602618241,11.0594306862,
	11.0586005953,11.0577715488,11.056943544,11.0561165785,11.0552906498,
	11.0544657552,11.0536418923,11.0528190586,11.0519972515,11.0511764686,
	11.0503567073,11.0495379653,11.0487202401,11.0479035291,11.0470878299,
	11.0462731402,11.0454594574,11.0446467791,11.043835103,11.0430244266,
	11.0422147476,11.0414060634,11.0405983719,11.0397916705,11.038985957,
	11.0381812289,11.037377484,11.0365747198,11.0357729341,11.0349721246,
	11.0341722889,11.0333734247,11.0325755297,11.0317786017,11.0309826383,
	11.0301876373,11.0293935965,11.0286005134,11.027808386,11.027017212,
	11.0262269891,11.0254377152,11.0246493879,11.0238620051,11.0230755646,
	11.0222900642,11.0215055016,11.0207218748,11.0199391816,11.0191574197,
	11.0183765871,11.0175966815,11.0168177009,11.0160396431,11.0152625059,
	11.0144862873,11.0137109852,11.0129365973,11.0121631217,11.0113905563,
	11.0106188989,11.0098481474,11.0090782999,11.0083093543,11.0075413084,
	11.0067741602,11.0060079078,11.005242549,11.0044780819,11.0037145043,
	11.0029518144,11.0021900101,11.0014290893,11.0006690501,10.9999098905,
	10.9991516086,10.9983942023,10.9976376696,10.9968820087,10.9961272176,
	10.9953732942,10.9946202368,10.9938680432,10.9931167117,10.9923662402,
	10.9916166269,10.9908678699,10.9901199672,10.989372917,10.9886267173,
	10.9878813663,10.9871368621,10.9863932028,10.9856503866,10.9849084116,
	10.9841672759,10.9834269778,10.9826875152,10.9819488865,10.9812110898,
	10.9804741232,10.979737985,10.9790026733,10.9782681863,10.9775345223,
	10.9768016794,10.9760696558,10.9753384497,10.9746080595,10.9738784832,
	10.9731497192,10.9724217657,10.9716946209,10.9709682831,10.9702427505,
	10.9695180214,10.968794094,10.9680709667,10.9673486377,10.9666271053,
	10.9659063678,10.9651864235,10.9644672707,10.9637489076,10.9630313326,
	10.9623145441,10.9615985403,10.9608833196,10.9601688802,10.9594552206,
	10.9587423391,10.958030234,10.9573189037,10.9566083465,10.9558985609,
	10.9551895451,10.9544812975,10.9537738166,10.9530671007,10.9523611482,
	10.9516559575,10.950951527,10.9502478551,10.9495449402,10.9488427807,
	10.948141375,10.9474407217,10.946740819,10.9460416654,10.9453432594,
	10.9446455995,10.943948684,10.9432525114,10.9425570801,10.9418623887,
	10.9411684357,10.9404752193,10.9397827383,10.939090991,10.9383999758,
	10.9377096914,10.9370201363,10.9363313088,10.9356432075,10.9349558309,
	10.9342691776,10.933583246,10.9328980347,10.9322135422,10.9315297671,
	10.9308467078,10.9301643629,10.929482731,10.9288018105,10.9281216002,
	10.9274420984,10.9267633038,10.926085215,10.9254078305,10.9247311489,
	10.9240551688,10.9233798887,10.9227053073,10.9220314231,10.9213582347,
	10.9206857408,10.9200139399,10.9193428306,10.9186724117,10.9180026816,
	10.917333639
	}}
};
