/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Literal;
import org.dbdoclet.tag.html.Code;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.dom.NodeImpl;

/**
 * Verarbeitung des HTML-Elements <tt>code</tt>.
 * 
 * <p>
 * <ul>
 * <li>Falls das DocBook-Vaterelement vom Typ <tt>literal</tt> ist, wird nur der
 * Textinhalt eingefügt.</li>
 * <li>Andernfalls wird überprüft, ob sich an dieser Stelle ein Element des Typs
 * <tt>literal</tt> einfügen läßt.</li>
 * </ul>
 * </p>
 * 
 * @author michael
 *
 */
public class CodeEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = getTagFactory();

		Code code = (Code) getHtmlElement();
		NodeImpl parent = getParent();

		if (parent instanceof Literal) {
			parent.appendChild(code.getTextContent());
			return finalizeValues();
		}

		DocBookElement candidate = dbfactory.createLiteral(code
				.getTextContent());

		if (candidate.isValidParent(script.getTransformPosition(), parent)) {

			parent.appendChild(candidate);
			traverse(false);
			return finalizeValues();
		}

		candidate = dbfactory.createProgramlisting();

		if (candidate.isValidParent(script.getTransformPosition(), parent)) {

			setCurrent(candidate);
			parent.appendChild(getCurrent());
			traverse(true);
			return finalizeValues();
		}

		parent.appendChild(code.getTextContent());
		return finalizeValues();
	}
}
