{- This module was generated from data in the Kate syntax
   highlighting file monobasic.xml, version 1.01, by Davide Bettio (davide.bettio@kdemail.net) -}

module Text.Highlighting.Kate.Syntax.Monobasic
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "MonoBasic"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.vb"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("MonoBasic","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("MonoBasic","Normal") -> return ()
      ("MonoBasic","String") -> (popContext) >> pEndLine
      ("MonoBasic","Comment") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "option explicit strict imports inherits as new dim redim private friend public const readonly writeonly default shared shadows protected overloads overrides notoverridable notinheritable mustinherit mustoverride mybase myclass me delegate catch finaly when throw to step then else true false nothing call byval byref optional paramarray return declare withevents event raiseevent addhandler and or not xor andalso orelse goto on error resume"
list_types = Set.fromList $ words $ "boolean char string integer long double object exception date datetime int16 int32 int64 paramarray timespan byte decimal intptr single guid"

regex_'5cb'28Namespace'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Namespace)([\\s]|$)"
regex_End'2eNamespace'2e'2a'24 = compileRegex True "End.Namespace.*$"
regex_'5cb'28Module'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Module)([\\s]|$)"
regex_End'2eModule'2e'2a'24 = compileRegex True "End.Module.*$"
regex_'5cb'28Class'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Class)([\\s]|$)"
regex_End'2eClass'2e'2a'24 = compileRegex True "End.Class.*$"
regex_'5cb'28Interface'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Interface)([\\s]|$)"
regex_End'2eInterface'2e'2a'24 = compileRegex True "End.Interface.*$"
regex_'5cb'28Structure'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Structure)([\\s]|$)"
regex_End'2eStructure'2e'2a'24 = compileRegex True "End.Structure.*$"
regex_'5cb'28Enum'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Enum)([\\s]|$)"
regex_End'2eEnum'2e'2a'24 = compileRegex True "End.Enum.*$"
regex_'5cb'28Property'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Property)([\\s]|$)"
regex_End'2eProperty'2e'2a'24 = compileRegex True "End.Property.*$"
regex_'5cb'28Get'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Get)([\\s]|$)"
regex_End'2eGet'2e'2a'24 = compileRegex True "End.Get.*$"
regex_'5cb'28Set'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Set)([\\s]|$)"
regex_End'2eSet'2e'2a'24 = compileRegex True "End.Set.*$"
regex_'5cb'28Sub'29'28'5b'2e'5cs'5d'7c'24'29 = compileRegex True "\\b(Sub)([.\\s]|$)"
regex_End'2eSub'2e'2a'24 = compileRegex True "End.Sub.*$"
regex_Exit'2eSub'2e'2a'24 = compileRegex True "Exit.Sub.*$"
regex_'5cb'28Function'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Function)([\\s]|$)"
regex_End'2eFunction'2e'2a'24 = compileRegex True "End.Function.*$"
regex_Exit'2eFunction'2e'2a'24 = compileRegex True "Exit.Function.*$"
regex_'5cb'28Try'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Try)([\\s]|$)"
regex_End'2eTry'2e'2a'24 = compileRegex True "End.Try.*$"
regex_'5cb'28If'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(If)([\\s]|$)"
regex_End'2eIf'2e'2a'24 = compileRegex True "End.If.*$"
regex_Select'2eCase'2e'2a'24 = compileRegex True "Select.Case.*$"
regex_End'2eSelect'2e'2a'24 = compileRegex True "End.Select.*$"
regex_'5cb'28For'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(For)([\\s]|$)"
regex_'5cb'28Next'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Next)([\\s]|$)"
regex_'5cb'28Do'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Do)([\\s]|$)"
regex_'5cb'28Loop'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(Loop)([\\s]|$)"
regex_'5cb'28While'29'28'5b'5cs'5d'7c'24'29 = compileRegex True "\\b(While)([\\s]|$)"
regex_End'2eWhile'2e'2a'24 = compileRegex True "End.While.*$"
regex_Exit'2eWhile'2e'2a'24 = compileRegex True "Exit.While.*$"
regex_'23Region'2e'2a'24 = compileRegex True "#Region.*$"
regex_'23End'2eRegion'2e'2a'24 = compileRegex True "#End.Region.*$"
regex_'23If'2e'2a'24 = compileRegex True "#If.*$"
regex_'23End'2eIf'2e'2a'24 = compileRegex True "#End.If.*$"

parseRules ("MonoBasic","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("MonoBasic","String"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CommentTok) >>~ pushContext ("MonoBasic","Comment"))
   <|>
   ((pRegExpr regex_'5cb'28Namespace'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eNamespace'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Module'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eModule'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Class'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eClass'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Interface'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eInterface'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Structure'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eStructure'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Enum'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eEnum'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Property'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eProperty'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Get'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eGet'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Set'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eSet'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Sub'29'28'5b'2e'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eSub'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_Exit'2eSub'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Function'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eFunction'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_Exit'2eFunction'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Try'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eTry'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28If'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eIf'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_Select'2eCase'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eSelect'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28For'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Next'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Do'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28Loop'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'5cb'28While'29'28'5b'5cs'5d'7c'24'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_End'2eWhile'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_Exit'2eWhile'2e'2a'24 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'23Region'2e'2a'24 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'23End'2eRegion'2e'2a'24 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'23If'2e'2a'24 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'23End'2eIf'2e'2a'24 >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("MonoBasic","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("MonoBasic","String") =
  (((pLineContinue >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pHlCStringChar >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("MonoBasic","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("MonoBasic","Comment") =
  (currentContext >>= \x -> guard (x == ("MonoBasic","Comment")) >> pDefault >>= withAttribute CommentTok)


parseRules x = parseRules ("MonoBasic","Normal") <|> fail ("Unknown context" ++ show x)
