/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcFace.h"
#include "ifcpp/IFC4/include/IfcSurfaceTexture.h"
#include "ifcpp/IFC4/include/IfcTextureMap.h"
#include "ifcpp/IFC4/include/IfcTextureVertex.h"

// ENTITY IfcTextureMap 
IfcTextureMap::IfcTextureMap( int id ) { m_entity_id = id; }
IfcTextureMap::~IfcTextureMap() {}
shared_ptr<BuildingObject> IfcTextureMap::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcTextureMap> copy_self( new IfcTextureMap() );
	for( size_t ii=0; ii<m_Maps.size(); ++ii )
	{
		auto item_ii = m_Maps[ii];
		if( item_ii )
		{
			copy_self->m_Maps.emplace_back( dynamic_pointer_cast<IfcSurfaceTexture>(item_ii->getDeepCopy(options) ) );
		}
	}
	for( size_t ii=0; ii<m_Vertices.size(); ++ii )
	{
		auto item_ii = m_Vertices[ii];
		if( item_ii )
		{
			copy_self->m_Vertices.emplace_back( dynamic_pointer_cast<IfcTextureVertex>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_MappedTo ) { copy_self->m_MappedTo = dynamic_pointer_cast<IfcFace>( m_MappedTo->getDeepCopy(options) ); }
	return copy_self;
}
void IfcTextureMap::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCTEXTUREMAP" << "(";
	writeEntityList( stream, m_Maps );
	stream << ",";
	writeEntityList( stream, m_Vertices );
	stream << ",";
	if( m_MappedTo ) { stream << "#" << m_MappedTo->m_entity_id; } else { stream << "$"; }
	stream << ");";
}
void IfcTextureMap::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcTextureMap::toString() const { return L"IfcTextureMap"; }
void IfcTextureMap::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 3 ){ std::stringstream err; err << "Wrong parameter count for entity IfcTextureMap, expecting 3, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	readEntityReferenceList( args[0], m_Maps, map );
	readEntityReferenceList( args[1], m_Vertices, map );
	readEntityReference( args[2], m_MappedTo, map );
}
void IfcTextureMap::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcTextureCoordinate::getAttributes( vec_attributes );
	if( !m_Vertices.empty() )
	{
		shared_ptr<AttributeObjectVector> Vertices_vec_object( new AttributeObjectVector() );
		std::copy( m_Vertices.begin(), m_Vertices.end(), std::back_inserter( Vertices_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "Vertices", Vertices_vec_object ) );
	}
	vec_attributes.emplace_back( std::make_pair( "MappedTo", m_MappedTo ) );
}
void IfcTextureMap::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcTextureCoordinate::getAttributesInverse( vec_attributes_inverse );
}
void IfcTextureMap::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcTextureCoordinate::setInverseCounterparts( ptr_self_entity );
	shared_ptr<IfcTextureMap> ptr_self = dynamic_pointer_cast<IfcTextureMap>( ptr_self_entity );
	if( !ptr_self ) { throw BuildingException( "IfcTextureMap::setInverseCounterparts: type mismatch" ); }
	if( m_MappedTo )
	{
		m_MappedTo->m_HasTextureMaps_inverse.emplace_back( ptr_self );
	}
}
void IfcTextureMap::unlinkFromInverseCounterparts()
{
	IfcTextureCoordinate::unlinkFromInverseCounterparts();
	if( m_MappedTo )
	{
		std::vector<weak_ptr<IfcTextureMap> >& HasTextureMaps_inverse = m_MappedTo->m_HasTextureMaps_inverse;
		for( auto it_HasTextureMaps_inverse = HasTextureMaps_inverse.begin(); it_HasTextureMaps_inverse != HasTextureMaps_inverse.end(); )
		{
			weak_ptr<IfcTextureMap> self_candidate_weak = *it_HasTextureMaps_inverse;
			if( self_candidate_weak.expired() )
			{
				++it_HasTextureMaps_inverse;
				continue;
			}
			shared_ptr<IfcTextureMap> self_candidate( *it_HasTextureMaps_inverse );
			if( self_candidate.get() == this )
			{
				it_HasTextureMaps_inverse= HasTextureMaps_inverse.erase( it_HasTextureMaps_inverse );
			}
			else
			{
				++it_HasTextureMaps_inverse;
			}
		}
	}
}
