/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.util;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import jonelo.sugar.util.GeneralString;

public class Service {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    public static String right(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(l + "");
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, ' ');
        }
        return stringBuffer.toString();
    }

    public static String decformat(long l, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(l);
    }

    public static String hexformat(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static String hexformat(long l, int n, int n2, char c) {
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l));
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        if (n2 > 0) {
            stringBuffer = Service.insertBlanks(stringBuffer, n2, c);
        }
        return stringBuffer.toString();
    }

    public static String format(byte[] byArray) {
        return Service.format(byArray, false);
    }

    private static StringBuffer insertBlanks(StringBuffer stringBuffer, int n, char c) {
        int n2 = stringBuffer.length() / 2;
        if (n2 <= n) {
            return stringBuffer;
        }
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length() + (n2 / n - 1));
        int n3 = n * 2;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (i > 0 && i % n3 == 0) {
                stringBuffer2.append(c);
            }
            stringBuffer2.append(stringBuffer.charAt(i));
        }
        return stringBuffer2;
    }

    public static String format(byte[] byArray, boolean bl, int n, char c) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            stringBuffer.append(HEX[n2 >>> 4]);
            stringBuffer.append(HEX[n2 & 0xF]);
        }
        if (n > 0) {
            stringBuffer = Service.insertBlanks(stringBuffer, n, c);
        }
        return bl ? stringBuffer.toString().toUpperCase() : stringBuffer.toString();
    }

    public static String formatAsBits(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        BigInteger bigInteger = new BigInteger(1, byArray);
        stringBuffer.append(bigInteger.toString(2));
        while (stringBuffer.length() < byArray.length * 8) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static String format(byte[] byArray, boolean bl) {
        return Service.format(byArray, false, 0, ' ');
    }

    public static boolean isSymbolicLink(File file) {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return false;
        }
        try {
            String string = file.getCanonicalPath();
            String string2 = file.getAbsolutePath();
            string2 = GeneralString.replaceString(string2, "/./", "/");
            if (string2.endsWith("/.")) {
                return false;
            }
            return !string2.equals(string);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return true;
        }
    }

    public static void setLongInByteArray(long l, byte[] byArray) throws IndexOutOfBoundsException {
        Service.setLongInByteArray(l, byArray, 0);
    }

    public static void setLongInByteArray(long l, byte[] byArray, int n) throws IndexOutOfBoundsException {
        int n2;
        byte[] byArray2 = new byte[8];
        for (n2 = 0; n2 < 8; ++n2) {
            long l2 = l & 0xFFL;
            byArray2[n2] = (byte)l2;
            l >>= 8;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            byArray[n2 + n] = byArray2[7 - n2];
        }
    }

    public static void setIntInByteArray(int n, byte[] byArray) throws IndexOutOfBoundsException {
        Service.setIntInByteArray(n, byArray, 0);
    }

    public static void setIntInByteArray(int n, byte[] byArray, int n2) throws IndexOutOfBoundsException {
        int n3;
        byte[] byArray2 = new byte[4];
        for (n3 = 0; n3 < 4; ++n3) {
            int n4 = n & 0xFF;
            byArray2[n3] = (byte)n4;
            n >>= 8;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            byArray[n3 + n2] = byArray2[3 - n3];
        }
    }

    public static final String duration(long l) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        l2 = l % 1000L;
        if ((l /= 1000L) > 0L) {
            l3 = l % 60L;
            l /= 60L;
        }
        if (l > 0L) {
            l4 = l % 60L;
            l /= 60L;
        }
        if (l > 0L) {
            l5 = l % 24L;
            l /= 24L;
        }
        l6 = l;
        return l6 + " d, " + l5 + " h, " + l4 + " m, " + l3 + " s, " + l2 + " ms";
    }
}

