from twisted.internet.defer import Deferred, DeferredList


class CountDownLatch(object):
    # NOTE For now, we only support successful callbacks, not errbacks
    def __init__(self, count, deferred_list=()):
        self.count = count
        self.completed = Deferred()
        for d in deferred_list:
            self.add(d)

    def add(self, deferred):
        deferred.addCallback(self.count_down)

    def count_down(self, *ignored):
        if self.count > 0:
            self.count -= 1
        if self.count == 0:
            if not self.completed.called:
                self.completed.callback(None)  # Maybe collect together these results?


def wait_for_results(deferreds, fireOnOneCallback):
    d = DeferredList(deferreds, fireOnOneCallback=fireOnOneCallback, fireOnOneErrback=True, consumeErrors=True)
    d.addCallback(lambda r: [x[1] for x in r])

    def get_errors(f):
        # Avoid spurious errors seen in closing connections; we don't care!
        if not d.called:
            return f.value.subFailure

    d.addErrback(get_errors)
    return d
