package latexDraw.parsers.svg.elements.path;

/**
 * Defines the SVGPath quadratic smooth curveto segment.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/20/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public class SVGPathSegCurvetoQuadraticSmooth extends SVGPathSeg
{
	/** The X-coordinate of the second point of the curve. @since 0.1 */
	protected double x;
	
	/** The Y-coordinate of the second point of the curve. @since 0.1 */
	protected double y;
	
	
	/**
	 * The main constructor.
	 * @param x The X-coordinate of the second point of the curve.
	 * @param y The Y-coordinate of the second point of the curve.
	 * @param isRelative isRelative True: the path segment is relative, false it is absolute.
	 */
	public SVGPathSegCurvetoQuadraticSmooth(double x, double y, boolean isRelative)
	{
		super(isRelative);
		
		this.x = x;
		this.y = y;
	}
	
	
	
	@Override
	public String toString()
	{
		StringBuffer stringBuffer = new StringBuffer();
		
		stringBuffer.append((isRelative() ? "t" : "T"));//$NON-NLS-1$//$NON-NLS-2$
		stringBuffer.append(' ');
		stringBuffer.append(x);
		stringBuffer.append(' ');
		stringBuffer.append(y);
		
		return stringBuffer.toString();
	}
	
	
	
	@Override
	public PathSeg getType()
	{
		return isRelative() ? PathSeg.CURVETO_QUADRATIC_SMOOTH_REL : PathSeg.CURVETO_QUADRATIC_SMOOTH_ABS;
	}



	/**
	 * @return the x.
	 * @since 0.1
	 */
	public double getX()
	{
		return x;
	}



	/**
	 * @return the y.
	 * @since 0.1
	 */
	public double getY()
	{
		return y;
	}
}
