package latexDraw.ui.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.components.CopyPasteMenu;
import latexDraw.util.LaTeXDrawResources;


/** 
 * This frame allows to user to insert several figures from PSTricks code into the current drawing (by using the TeX parser).
 *<br> 
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/31/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class InsertPSTricksCodeFrame extends JFrame implements ActionListener
{
	private static final long serialVersionUID = 1L;

	/** The label of the button "ok" of the frame */
	public static final String LABEL_FRAME_INSERT_OK = "INSERT_CODE_OK";//$NON-NLS-1$
	
	/** The label of the button "Cancel" of the frame */
	public static final String LABEL_FRAME_INSERT_CANCEL = "INSERT_CODE_CANCEL";//$NON-NLS-1$

	/** The main frame of the program */
	private LaTeXDrawFrame mainFrame;
	
	/** This editor allows to put the PSTricks code */
	private JEditorPane editor;

	protected CopyPasteMenu copyMenu;
	
	
	
	/**
	 * The constructor.
	 * @param frame The parent frame.
	 */
	public InsertPSTricksCodeFrame(LaTeXDrawFrame frame) 
	{
		super(LaTeXDrawLang.getString1_6("InsertPSTricksCodeFrame.0")); //$NON-NLS-1$
		try
		{
			mainFrame 	= frame;
			setIconImage(LaTeXDrawResources.insertPSTricksIcon.getImage());
			
	  		JPanel  pButton = new JPanel();
	  		JButton buttonOk = new JButton(AbstractParametersFrame.LABEL_OK), 
	  				buttonCancel = new JButton(AbstractParametersFrame.LABEL_CANCEL);
	  		
	  		editor 		= new JEditorPane();
			copyMenu	= new CopyPasteMenu(editor);

	  		buttonOk.setActionCommand(LABEL_FRAME_INSERT_OK);
	  		buttonCancel.setActionCommand(LABEL_FRAME_INSERT_CANCEL);
			buttonOk.addActionListener(this);
			buttonCancel.addActionListener(this);

	  		// The scroller of the editor
			JScrollPane scrollPane = new JScrollPane(editor);
			scrollPane.setMinimumSize(new Dimension(450, 250));
			scrollPane.setPreferredSize(new Dimension(450, 250));
	 		scrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS); 

			JLabel label = new JLabel(LaTeXDrawLang.getString1_6("LaTeXDrawFrame.16"), SwingConstants.CENTER); //$NON-NLS-1$
			label.setAlignmentX(Component.CENTER_ALIGNMENT); 
			
			editor.setText("");//$NON-NLS-1$
			pButton.add(buttonOk);
			pButton.add(buttonCancel);
			pButton.setPreferredSize(new Dimension(280, 40));
			pButton.setMaximumSize(new Dimension(280, 40));
			getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
			getContentPane().add(label);
			getContentPane().add(scrollPane);
			getContentPane().add(pButton);
			
	 		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);
			editor.addMouseListener(copyMenu);
		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	
	


	public void actionPerformed(ActionEvent e) 
	{
		Object o = e.getSource();
		
		if(o instanceof JButton)
		{
			String label = ((JButton)o).getActionCommand();
			
			if(label == LABEL_FRAME_INSERT_CANCEL)
			{
				super.setVisible(false);
				return ;
			}
			
			if(label == LABEL_FRAME_INSERT_OK)
			{
				mainFrame.insertPSTricksCode(editor.getText());
				super.setVisible(false);

				return;
			}
		}
	}




	@Override
	public void setVisible(boolean e)
	{
		if(e)
			editor.setText("");//$NON-NLS-1$

		super.setVisible(e);
	}
}
