.\" @(#)$RCSfile: Cns_chclass.man,v $ $Revision: 1.1.1.1 $ $Date: 2002/10/16 06:25:40 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 2000-2002 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_CHCLASS 3 "$Date: 2002/10/16 06:25:40 $" CASTOR "Cns Library Functions"
.SH NAME
Cns_chclass \- change class of a CASTOR directory in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "int Cns_chclass (const char *" path ,
.BI "int " classid ,
.BI "char *" class_name )
.SH DESCRIPTION
.B Cns_chclass
changes the class of a CASTOR directory in the name server.
The fileclass can be identified by
.I classid
or by
.IR class_name .
If both are specified, they must point at the same class.
.TP
.I path
specifies the logical pathname relative to the current CASTOR directory or
the full CASTOR pathname.
.LP
The effective user ID of the process must match the owner of the directory or
the caller must have ADMIN privilege in the Cupv database.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EPERM
The effective user ID does not match the owner of the directory and 
the caller does not have ADMIN privilege in the Cupv database.
.TP
.B ENOENT
The named directory does not exist or is a null pathname.
.TP
.B EACCES
Search permission is denied on a component of the
.I path
prefix.
.TP
.B EFAULT
.I path
is a NULL pointer.
.TP
.B ENOTDIR
.I path
is not a directory.
.TP
.B EINVAL
.I classid
and
.I class_name
do not point at same class entry or the length of
.I class_name
exceeds
.B CA_MAXCLASNAMELEN
or the class does not exist.
.TP
.B ENAMETOOLONG
The length of
.I path
exceeds
.B CA_MAXPATHLEN
or the length of a
.I path
component exceeds
.BR CA_MAXNAMELEN .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR Cns_chdir(3) ,
.BR Cupvlist(1)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
