// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -triple x86_64-apple-darwin10 -fopenmp -fopenmp-version=45 -x c++ -emit-llvm %s -o - -femit-all-decls | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -x c++ -triple x86_64-apple-darwin10 -include-pch %t -verify %s -emit-llvm -o - -femit-all-decls | FileCheck %s --check-prefix=CHECK2
// RUN: %clang_cc1 -verify -triple x86_64-apple-darwin10 -fopenmp -x c++ -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -fopenmp -x c++ -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -x c++ -triple x86_64-apple-darwin10 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK3

// RUN: %clang_cc1 -verify -triple x86_64-apple-darwin10 -fopenmp-simd -fopenmp-version=45 -x c++ -emit-llvm %s -o - -femit-all-decls | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fopenmp-version=45 -x c++ -triple x86_64-apple-darwin10 -include-pch %t -verify %s -emit-llvm -o - -femit-all-decls | FileCheck %s --check-prefix=CHECK6
// RUN: %clang_cc1 -verify -triple x86_64-apple-darwin10 -fopenmp-simd -x c++ -emit-llvm %s -o - -femit-all-decls | FileCheck %s --check-prefix=CHECK7
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -include-pch %t -verify %s -emit-llvm -o - -femit-all-decls | FileCheck %s --check-prefix=CHECK8
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

int main(int argc, char **argv) {





#pragma omp parallel master taskloop simd priority(argc) safelen(8)
  for (int i = 0; i < 10; ++i)
    ;



#pragma omp parallel master taskloop simd nogroup grainsize(argc) simdlen(16)
  for (int i = 0; i < 10; ++i)
    ;


  int i;
#pragma omp parallel master taskloop simd if(argc) shared(argc, argv) collapse(2) num_tasks(argc) lastprivate(i) aligned(argv:8)
  for (i = 0; i < argc; ++i)
  for (int j = argc; j < argv[argc][argc]; ++j)
    ;
}

struct S {
  int a;
  S(int c) {

#pragma omp parallel master taskloop simd shared(c) num_tasks(4) final(c)
    for (a = 0; a < c; ++a)
      ;
  }
} s(1);



#endif
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED6:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED8:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK1-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 1, ptr @main.omp_outlined, i64 [[TMP3]])
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR__CASTED2]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED2]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 1, ptr @main.omp_outlined.1, i64 [[TMP6]])
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP7]], 0
// CHECK1-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK1-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK1-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK1-NEXT:    [[FROMBOOL7:%.*]] = zext i1 [[TOBOOL5]] to i8
// CHECK1-NEXT:    store i8 [[FROMBOOL7]], ptr [[DOTCAPTURE_EXPR__CASTED6]], align 1
// CHECK1-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED6]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR__CASTED8]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED8]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK1-NEXT:    [[TOBOOL9:%.*]] = trunc i8 [[TMP13]] to i1
// CHECK1-NEXT:    br i1 [[TOBOOL9]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 5, ptr @main.omp_outlined.4, ptr [[I]], ptr [[ARGC_ADDR]], ptr [[ARGV_ADDR]], i64 [[TMP10]], i64 [[TMP12]])
// CHECK1-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.else:
// CHECK1-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK1-NEXT:    call void @main.omp_outlined.4(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[I]], ptr [[ARGC_ADDR]], ptr [[ARGV_ADDR]], i64 [[TMP10]], i64 [[TMP12]]) #[[ATTR2:[0-9]+]]
// CHECK1-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 1
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK1-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 33, i64 80, i64 1, ptr @.omp_task_entry.)
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP6]], i32 0, i32 4
// CHECK1-NEXT:    store i32 [[TMP4]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 5
// CHECK1-NEXT:    store i64 0, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 6
// CHECK1-NEXT:    store i64 9, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 7
// CHECK1-NEXT:    store i64 1, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 9
// CHECK1-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP11]], i8 0, i64 8, i1 false)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK1-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP5]], i32 1, ptr [[TMP8]], ptr [[TMP9]], i64 [[TMP12]], i32 1, i32 0, i64 0, ptr null)
// CHECK1-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK1-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !14
// CHECK1-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !14
// CHECK1-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP19]] to i32
// CHECK1-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK1:       omp.inner.for.cond.i:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK1-NEXT:    [[CONV1_I:%.*]] = sext i32 [[TMP20]] to i64
// CHECK1-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !14
// CHECK1-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV1_I]], [[TMP21]]
// CHECK1-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// CHECK1:       omp.inner.for.body.i:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK1-NEXT:    store i32 [[TMP22]], ptr [[I_I]], align 4, !noalias !14
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK1-NEXT:    [[ADD2_I:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK1-NEXT:    store i32 [[ADD2_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK1:       .omp_outlined..exit:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined.1
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_0:%.*]], align 1
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK1-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i64 80, i64 1, ptr @.omp_task_entry..3)
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_1:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP6]], i32 0, i32 5
// CHECK1-NEXT:    store i64 0, ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 6
// CHECK1-NEXT:    store i64 9, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 7
// CHECK1-NEXT:    store i64 1, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 9
// CHECK1-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP10]], i8 0, i64 8, i1 false)
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP4]] to i64
// CHECK1-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP5]], i32 1, ptr [[TMP7]], ptr [[TMP8]], i64 [[TMP11]], i32 1, i32 1, i64 [[TMP12]], ptr null)
// CHECK1-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_entry..3
// CHECK1-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META25:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META27:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META29:![0-9]+]])
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !31
// CHECK1-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !31
// CHECK1-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !31
// CHECK1-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP19]] to i32
// CHECK1-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !31
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK1:       omp.inner.for.cond.i:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32:![0-9]+]]
// CHECK1-NEXT:    [[CONV1_I:%.*]] = sext i32 [[TMP20]] to i64
// CHECK1-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK1-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV1_I]], [[TMP21]]
// CHECK1-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__2_EXIT:%.*]]
// CHECK1:       omp.inner.for.body.i:
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK1-NEXT:    store i32 [[TMP22]], ptr [[I_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK1-NEXT:    [[ADD2_I:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK1-NEXT:    store i32 [[ADD2_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP33:![0-9]+]]
// CHECK1:       .omp_outlined..2.exit:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined.4
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[I:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[ARGV:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[I_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_2:%.*]], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[I]], ptr [[I_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], ptr [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[I_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK1-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[TMP2]], ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK1-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP12]], ptr [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK1-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP13]], i64 [[IDXPROM]]
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK1-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP16]] to i64
// CHECK1-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i8, ptr [[TMP15]], i64 [[IDXPROM7]]
// CHECK1-NEXT:    [[TMP17:%.*]] = load i8, ptr [[ARRAYIDX8]], align 1
// CHECK1-NEXT:    [[CONV:%.*]] = sext i8 [[TMP17]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP18]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[CONV10:%.*]] = sext i32 [[DIV]] to i64
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_5]], align 4
// CHECK1-NEXT:    [[SUB11:%.*]] = sub i32 [[TMP19]], [[TMP20]]
// CHECK1-NEXT:    [[SUB12:%.*]] = sub i32 [[SUB11]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add i32 [[SUB12]], 1
// CHECK1-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD]], 1
// CHECK1-NEXT:    [[CONV14:%.*]] = zext i32 [[DIV13]] to i64
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV10]], [[CONV14]]
// CHECK1-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[MUL]], 1
// CHECK1-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_9]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP4]], i32 1, i64 88, i64 24, ptr @.omp_task_entry..6)
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP21]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP22]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP23]], align 8
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP24]], ptr align 8 [[AGG_CAPTURED]], i64 24, i1 false)
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP21]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP26:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK1-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP26]] to i1
// CHECK1-NEXT:    [[TMP27:%.*]] = sext i1 [[TOBOOL]] to i32
// CHECK1-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 5
// CHECK1-NEXT:    store i64 0, ptr [[TMP28]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_9]], align 8
// CHECK1-NEXT:    store i64 [[TMP30]], ptr [[TMP29]], align 8
// CHECK1-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 7
// CHECK1-NEXT:    store i64 1, ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 9
// CHECK1-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP32]], i8 0, i64 8, i1 false)
// CHECK1-NEXT:    [[TMP33:%.*]] = load i64, ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP34:%.*]] = zext i32 [[TMP10]] to i64
// CHECK1-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP4]], ptr [[TMP21]], i32 [[TMP27]], ptr [[TMP28]], ptr [[TMP29]], i64 [[TMP33]], i32 1, i32 2, i64 [[TMP34]], ptr @.omp_task_dup.)
// CHECK1-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK1-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP2]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[TMP4]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_entry..6
// CHECK1-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTLASTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_3_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_6_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[J_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I14_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[J15_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP3]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK1-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META36:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META39:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META41:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META43:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META45:![0-9]+]])
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !47
// CHECK1-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !47
// CHECK1-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTLASTPRIV_PTR_ADDR_I]]) #[[ATTR2]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTLASTPRIV_PTR_ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON_2:%.*]], ptr [[TMP19]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[TMP24]], align 8
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
// CHECK1-NEXT:    store i32 [[TMP26]], ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[TMP27]], align 8
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, ptr [[TMP28]], align 4
// CHECK1-NEXT:    store i32 [[TMP29]], ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[TMP30]], align 8
// CHECK1-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP31]], align 8
// CHECK1-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[TMP33]], align 8
// CHECK1-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// CHECK1-NEXT:    [[IDXPROM_I:%.*]] = sext i32 [[TMP35]] to i64
// CHECK1-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds ptr, ptr [[TMP32]], i64 [[IDXPROM_I]]
// CHECK1-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[ARRAYIDX_I]], align 8
// CHECK1-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[TMP37]], align 8
// CHECK1-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP38]], align 4
// CHECK1-NEXT:    [[IDXPROM4_I:%.*]] = sext i32 [[TMP39]] to i64
// CHECK1-NEXT:    [[ARRAYIDX5_I:%.*]] = getelementptr inbounds i8, ptr [[TMP36]], i64 [[IDXPROM4_I]]
// CHECK1-NEXT:    [[TMP40:%.*]] = load i8, ptr [[ARRAYIDX5_I]], align 1
// CHECK1-NEXT:    [[CONV_I:%.*]] = sext i8 [[TMP40]] to i32
// CHECK1-NEXT:    store i32 [[CONV_I]], ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK1-NEXT:    [[CONV7_I:%.*]] = sext i32 [[TMP41]] to i64
// CHECK1-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[SUB8_I:%.*]] = sub i32 [[TMP42]], [[TMP43]]
// CHECK1-NEXT:    [[SUB9_I:%.*]] = sub i32 [[SUB8_I]], 1
// CHECK1-NEXT:    [[CONV11_I:%.*]] = zext i32 [[SUB8_I]] to i64
// CHECK1-NEXT:    [[MUL_I:%.*]] = mul nsw i64 [[CONV7_I]], [[CONV11_I]]
// CHECK1-NEXT:    [[SUB12_I:%.*]] = sub nsw i64 [[MUL_I]], 1
// CHECK1-NEXT:    store i64 [[SUB12_I]], ptr [[DOTCAPTURE_EXPR_6_I]], align 8, !noalias !47
// CHECK1-NEXT:    store i32 0, ptr [[I_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK1-NEXT:    store i32 [[TMP44]], ptr [[J_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK1-NEXT:    [[CMP_I:%.*]] = icmp slt i32 0, [[TMP45]]
// CHECK1-NEXT:    br i1 [[CMP_I]], label [[LAND_LHS_TRUE_I:%.*]], label [[TASKLOOP_IF_END_I:%.*]]
// CHECK1:       land.lhs.true.i:
// CHECK1-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[CMP13_I:%.*]] = icmp slt i32 [[TMP46]], [[TMP47]]
// CHECK1-NEXT:    br i1 [[CMP13_I]], label [[TASKLOOP_IF_THEN_I:%.*]], label [[TASKLOOP_IF_END_I]]
// CHECK1:       taskloop.if.then.i:
// CHECK1-NEXT:    [[TMP48:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !47
// CHECK1-NEXT:    store i64 [[TMP48]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK1-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[TMP49]], align 8
// CHECK1-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[TMP51]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK1:       omp.inner.for.cond.i:
// CHECK1-NEXT:    [[TMP53:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48:![0-9]+]]
// CHECK1-NEXT:    [[TMP54:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[CMP16_I:%.*]] = icmp ule i64 [[TMP53]], [[TMP54]]
// CHECK1-NEXT:    br i1 [[CMP16_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[OMP_INNER_FOR_END_I:%.*]]
// CHECK1:       omp.inner.for.body.i:
// CHECK1-NEXT:    [[TMP55:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[SUB17_I:%.*]] = sub i32 [[TMP56]], [[TMP57]]
// CHECK1-NEXT:    [[SUB18_I:%.*]] = sub i32 [[SUB17_I]], 1
// CHECK1-NEXT:    [[CONV22_I:%.*]] = zext i32 [[SUB17_I]] to i64
// CHECK1-NEXT:    [[DIV23_I:%.*]] = sdiv i64 [[TMP55]], [[CONV22_I]]
// CHECK1-NEXT:    [[CONV26_I:%.*]] = trunc i64 [[DIV23_I]] to i32
// CHECK1-NEXT:    store i32 [[CONV26_I]], ptr [[I14_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[CONV27_I:%.*]] = sext i32 [[TMP58]] to i64
// CHECK1-NEXT:    [[TMP59:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP60:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP61:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP62:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[SUB28_I:%.*]] = sub i32 [[TMP61]], [[TMP62]]
// CHECK1-NEXT:    [[SUB29_I:%.*]] = sub i32 [[SUB28_I]], 1
// CHECK1-NEXT:    [[CONV33_I:%.*]] = zext i32 [[SUB28_I]] to i64
// CHECK1-NEXT:    [[DIV34_I:%.*]] = sdiv i64 [[TMP60]], [[CONV33_I]]
// CHECK1-NEXT:    [[TMP63:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP64:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[SUB35_I:%.*]] = sub i32 [[TMP63]], [[TMP64]]
// CHECK1-NEXT:    [[SUB36_I:%.*]] = sub i32 [[SUB35_I]], 1
// CHECK1-NEXT:    [[CONV40_I:%.*]] = zext i32 [[SUB35_I]] to i64
// CHECK1-NEXT:    [[MUL41_I:%.*]] = mul nsw i64 [[DIV34_I]], [[CONV40_I]]
// CHECK1-NEXT:    [[SUB42_I:%.*]] = sub nsw i64 [[TMP59]], [[MUL41_I]]
// CHECK1-NEXT:    [[ADD44_I:%.*]] = add nsw i64 [[CONV27_I]], [[SUB42_I]]
// CHECK1-NEXT:    [[CONV45_I:%.*]] = trunc i64 [[ADD44_I]] to i32
// CHECK1-NEXT:    store i32 [[CONV45_I]], ptr [[J15_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[TMP65:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    [[ADD46_I:%.*]] = add nsw i64 [[TMP65]], 1
// CHECK1-NEXT:    store i64 [[ADD46_I]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP49:![0-9]+]]
// CHECK1:       omp.inner.for.end.i:
// CHECK1-NEXT:    br label [[TASKLOOP_IF_END_I]]
// CHECK1:       taskloop.if.end.i:
// CHECK1-NEXT:    [[TMP66:%.*]] = load i32, ptr [[DOTLITER__ADDR_I]], align 4, !noalias !47
// CHECK1-NEXT:    [[TMP67:%.*]] = icmp ne i32 [[TMP66]], 0
// CHECK1-NEXT:    br i1 [[TMP67]], label [[DOTOMP_LASTPRIVATE_THEN_I:%.*]], label [[DOTOMP_OUTLINED__5_EXIT:%.*]]
// CHECK1:       .omp.lastprivate.then.i:
// CHECK1-NEXT:    br label [[DOTOMP_OUTLINED__5_EXIT]]
// CHECK1:       .omp_outlined..5.exit:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_dup.
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], i32 noundef [[TMP2:%.*]]) #[[ATTR4]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTADDR2]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTADDR2]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], ptr [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP3]], i32 0, i32 1
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK1-SAME: () #[[ATTR6]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR8:[0-9]+]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR8]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK1-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK1-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[TMP1:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK1-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP1]] to i1
// CHECK1-NEXT:    [[FROMBOOL3:%.*]] = zext i1 [[TOBOOL2]] to i8
// CHECK1-NEXT:    store i8 [[FROMBOOL3]], ptr [[DOTCAPTURE_EXPR__CASTED]], align 1
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @_ZN1SC2Ei.omp_outlined, ptr [[THIS1]], ptr [[C_ADDR]], i64 [[TMP2]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SC2Ei.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_4:%.*]], align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK1-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP8:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK1-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP8]] to i1
// CHECK1-NEXT:    store ptr [[TMP]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK1-NEXT:    store i32 [[TMP9]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK1-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP10]], 0
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK1-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK1-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = select i1 [[TOBOOL]], i32 2, i32 0
// CHECK1-NEXT:    [[TMP12:%.*]] = or i32 [[TMP11]], 1
// CHECK1-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP3]], i32 [[TMP12]], i64 80, i64 16, ptr @.omp_task_entry..8)
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_5:%.*]], ptr [[TMP13]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP14]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP16]], ptr align 8 [[AGG_CAPTURED]], i64 16, i1 false)
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 5
// CHECK1-NEXT:    store i64 0, ptr [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = sext i32 [[TMP19]] to i64
// CHECK1-NEXT:    store i64 [[CONV]], ptr [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 7
// CHECK1-NEXT:    store i64 1, ptr [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 9
// CHECK1-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP21]], i8 0, i64 8, i1 false)
// CHECK1-NEXT:    [[TMP22:%.*]] = load i64, ptr [[TMP20]], align 8
// CHECK1-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP3]], ptr [[TMP13]], i32 1, ptr [[TMP17]], ptr [[TMP18]], i64 [[TMP22]], i32 1, i32 2, i64 4, ptr null)
// CHECK1-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_task_entry..8
// CHECK1-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP1_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR__I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTCAPTURE_EXPR_2_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP4_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A5_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TMP6_I:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_5:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK1-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK1-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META51:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META54:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META56:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META58:![0-9]+]])
// CHECK1-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META60:![0-9]+]])
// CHECK1-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !62
// CHECK1-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !62
// CHECK1-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[TMP18]], align 8
// CHECK1-NEXT:    store ptr [[TMP_I]], ptr [[TMP1_I]], align 8, !noalias !62
// CHECK1-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_ANON_4:%.*]], ptr [[TMP18]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[TMP20]], align 8
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
// CHECK1-NEXT:    store i32 [[TMP22]], ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !62
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !62
// CHECK1-NEXT:    [[SUB3_I:%.*]] = sub nsw i32 [[TMP23]], 1
// CHECK1-NEXT:    store i32 [[SUB3_I]], ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !62
// CHECK1-NEXT:    store ptr [[A_I]], ptr [[TMP4_I]], align 8, !noalias !62
// CHECK1-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP4_I]], align 8, !noalias !62
// CHECK1-NEXT:    store i32 0, ptr [[TMP24]], align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !62
// CHECK1-NEXT:    [[CMP_I:%.*]] = icmp slt i32 0, [[TMP25]]
// CHECK1-NEXT:    br i1 [[CMP_I]], label [[TASKLOOP_IF_THEN_I:%.*]], label [[DOTOMP_OUTLINED__7_EXIT:%.*]]
// CHECK1:       taskloop.if.then.i:
// CHECK1-NEXT:    store ptr [[A5_I]], ptr [[TMP6_I]], align 8, !noalias !62
// CHECK1-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !62
// CHECK1-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP26]] to i32
// CHECK1-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !62
// CHECK1-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[TMP18]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[TMP27]], align 8
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK1:       omp.inner.for.cond.i:
// CHECK1-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63:![0-9]+]]
// CHECK1-NEXT:    [[CONV7_I:%.*]] = sext i32 [[TMP29]] to i64
// CHECK1-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK1-NEXT:    [[CMP8_I:%.*]] = icmp ule i64 [[CONV7_I]], [[TMP30]]
// CHECK1-NEXT:    br i1 [[CMP8_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[OMP_INNER_FOR_END_I:%.*]]
// CHECK1:       omp.inner.for.body.i:
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK1-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP6_I]], align 8, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK1-NEXT:    store i32 [[TMP31]], ptr [[TMP32]], align 4, !llvm.access.group [[ACC_GRP63]]
// CHECK1-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK1-NEXT:    [[ADD9_I:%.*]] = add nsw i32 [[TMP33]], 1
// CHECK1-NEXT:    store i32 [[ADD9_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP64:![0-9]+]]
// CHECK1:       omp.inner.for.end.i:
// CHECK1-NEXT:    br label [[DOTOMP_OUTLINED__7_EXIT]]
// CHECK1:       .omp_outlined..7.exit:
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK1-SAME: () #[[ATTR6]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__cxx_global_var_init()
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@main
// CHECK2-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__CASTED2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__CASTED6:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__CASTED8:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK2-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK2-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 1, ptr @main.omp_outlined, i64 [[TMP3]])
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR__CASTED2]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED2]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 1, ptr @main.omp_outlined.1, i64 [[TMP6]])
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK2-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP7]], 0
// CHECK2-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK2-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK2-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK2-NEXT:    [[FROMBOOL7:%.*]] = zext i1 [[TOBOOL5]] to i8
// CHECK2-NEXT:    store i8 [[FROMBOOL7]], ptr [[DOTCAPTURE_EXPR__CASTED6]], align 1
// CHECK2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED6]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK2-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR__CASTED8]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED8]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK2-NEXT:    [[TOBOOL9:%.*]] = trunc i8 [[TMP13]] to i1
// CHECK2-NEXT:    br i1 [[TOBOOL9]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 5, ptr @main.omp_outlined.4, ptr [[I]], ptr [[ARGC_ADDR]], ptr [[ARGV_ADDR]], i64 [[TMP10]], i64 [[TMP12]])
// CHECK2-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.else:
// CHECK2-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK2-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK2-NEXT:    call void @main.omp_outlined.4(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[I]], ptr [[ARGC_ADDR]], ptr [[ARGV_ADDR]], i64 [[TMP10]], i64 [[TMP12]]) #[[ATTR2:[0-9]+]]
// CHECK2-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK2-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@main.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 1
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK2-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 33, i64 80, i64 1, ptr @.omp_task_entry.)
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP6]], i32 0, i32 4
// CHECK2-NEXT:    store i32 [[TMP4]], ptr [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 5
// CHECK2-NEXT:    store i64 0, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 6
// CHECK2-NEXT:    store i64 9, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 7
// CHECK2-NEXT:    store i64 1, ptr [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 9
// CHECK2-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP11]], i8 0, i64 8, i1 false)
// CHECK2-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK2-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP5]], i32 1, ptr [[TMP8]], ptr [[TMP9]], i64 [[TMP12]], i32 1, i32 0, i64 0, ptr null)
// CHECK2-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK2-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK2-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !14
// CHECK2-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !14
// CHECK2-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP19]] to i32
// CHECK2-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK2:       omp.inner.for.cond.i:
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK2-NEXT:    [[CONV1_I:%.*]] = sext i32 [[TMP20]] to i64
// CHECK2-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !14
// CHECK2-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV1_I]], [[TMP21]]
// CHECK2-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// CHECK2:       omp.inner.for.body.i:
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK2-NEXT:    store i32 [[TMP22]], ptr [[I_I]], align 4, !noalias !14
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK2-NEXT:    [[ADD2_I:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK2-NEXT:    store i32 [[ADD2_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK2:       .omp_outlined..exit:
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@main.omp_outlined.1
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_0:%.*]], align 1
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK2-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i64 80, i64 1, ptr @.omp_task_entry..3)
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_1:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP6]], i32 0, i32 5
// CHECK2-NEXT:    store i64 0, ptr [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 6
// CHECK2-NEXT:    store i64 9, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 7
// CHECK2-NEXT:    store i64 1, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 9
// CHECK2-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP10]], i8 0, i64 8, i1 false)
// CHECK2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP4]] to i64
// CHECK2-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP5]], i32 1, ptr [[TMP7]], ptr [[TMP8]], i64 [[TMP11]], i32 1, i32 1, i64 [[TMP12]], ptr null)
// CHECK2-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_task_entry..3
// CHECK2-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK2-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META25:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META27:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META29:![0-9]+]])
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !31
// CHECK2-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !31
// CHECK2-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !31
// CHECK2-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP19]] to i32
// CHECK2-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !31
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK2:       omp.inner.for.cond.i:
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32:![0-9]+]]
// CHECK2-NEXT:    [[CONV1_I:%.*]] = sext i32 [[TMP20]] to i64
// CHECK2-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK2-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV1_I]], [[TMP21]]
// CHECK2-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__2_EXIT:%.*]]
// CHECK2:       omp.inner.for.body.i:
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK2-NEXT:    store i32 [[TMP22]], ptr [[I_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK2-NEXT:    [[ADD2_I:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK2-NEXT:    store i32 [[ADD2_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP33:![0-9]+]]
// CHECK2:       .omp_outlined..2.exit:
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@main.omp_outlined.4
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[I:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[ARGV:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[I_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_2:%.*]], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[I]], ptr [[I_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], ptr [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[I_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK2-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 2
// CHECK2-NEXT:    store ptr [[TMP2]], ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK2-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK2-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK2-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK2-NEXT:    store i32 [[TMP12]], ptr [[DOTCAPTURE_EXPR_5]], align 4
// CHECK2-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK2-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP14]] to i64
// CHECK2-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP13]], i64 [[IDXPROM]]
// CHECK2-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK2-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP16]] to i64
// CHECK2-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i8, ptr [[TMP15]], i64 [[IDXPROM7]]
// CHECK2-NEXT:    [[TMP17:%.*]] = load i8, ptr [[ARRAYIDX8]], align 1
// CHECK2-NEXT:    [[CONV:%.*]] = sext i8 [[TMP17]] to i32
// CHECK2-NEXT:    store i32 [[CONV]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP18]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[CONV10:%.*]] = sext i32 [[DIV]] to i64
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK2-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_5]], align 4
// CHECK2-NEXT:    [[SUB11:%.*]] = sub i32 [[TMP19]], [[TMP20]]
// CHECK2-NEXT:    [[SUB12:%.*]] = sub i32 [[SUB11]], 1
// CHECK2-NEXT:    [[ADD:%.*]] = add i32 [[SUB12]], 1
// CHECK2-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD]], 1
// CHECK2-NEXT:    [[CONV14:%.*]] = zext i32 [[DIV13]] to i64
// CHECK2-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV10]], [[CONV14]]
// CHECK2-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[MUL]], 1
// CHECK2-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_9]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP4]], i32 1, i64 88, i64 24, ptr @.omp_task_entry..6)
// CHECK2-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP21]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP22]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP23]], align 8
// CHECK2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP24]], ptr align 8 [[AGG_CAPTURED]], i64 24, i1 false)
// CHECK2-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP21]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP26:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK2-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP26]] to i1
// CHECK2-NEXT:    [[TMP27:%.*]] = sext i1 [[TOBOOL]] to i32
// CHECK2-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 5
// CHECK2-NEXT:    store i64 0, ptr [[TMP28]], align 8
// CHECK2-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 6
// CHECK2-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_9]], align 8
// CHECK2-NEXT:    store i64 [[TMP30]], ptr [[TMP29]], align 8
// CHECK2-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 7
// CHECK2-NEXT:    store i64 1, ptr [[TMP31]], align 8
// CHECK2-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP22]], i32 0, i32 9
// CHECK2-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP32]], i8 0, i64 8, i1 false)
// CHECK2-NEXT:    [[TMP33:%.*]] = load i64, ptr [[TMP31]], align 8
// CHECK2-NEXT:    [[TMP34:%.*]] = zext i32 [[TMP10]] to i64
// CHECK2-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP4]], ptr [[TMP21]], i32 [[TMP27]], ptr [[TMP28]], ptr [[TMP29]], i64 [[TMP33]], i32 1, i32 2, i64 [[TMP34]], ptr @.omp_task_dup.)
// CHECK2-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK2-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP2]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    store ptr [[TMP3]], ptr [[TMP4]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_task_entry..6
// CHECK2-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTLASTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_3_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_6_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[J_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[I14_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[J15_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP3]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK2-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK2-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK2-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK2-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META36:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META39:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META41:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META43:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META45:![0-9]+]])
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !47
// CHECK2-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !47
// CHECK2-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTLASTPRIV_PTR_ADDR_I]]) #[[ATTR2]]
// CHECK2-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTLASTPRIV_PTR_ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON_2:%.*]], ptr [[TMP19]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[TMP24]], align 8
// CHECK2-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
// CHECK2-NEXT:    store i32 [[TMP26]], ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[TMP27]], align 8
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, ptr [[TMP28]], align 4
// CHECK2-NEXT:    store i32 [[TMP29]], ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[TMP30]], align 8
// CHECK2-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP31]], align 8
// CHECK2-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[TMP33]], align 8
// CHECK2-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// CHECK2-NEXT:    [[IDXPROM_I:%.*]] = sext i32 [[TMP35]] to i64
// CHECK2-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds ptr, ptr [[TMP32]], i64 [[IDXPROM_I]]
// CHECK2-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[ARRAYIDX_I]], align 8
// CHECK2-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[TMP37]], align 8
// CHECK2-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP38]], align 4
// CHECK2-NEXT:    [[IDXPROM4_I:%.*]] = sext i32 [[TMP39]] to i64
// CHECK2-NEXT:    [[ARRAYIDX5_I:%.*]] = getelementptr inbounds i8, ptr [[TMP36]], i64 [[IDXPROM4_I]]
// CHECK2-NEXT:    [[TMP40:%.*]] = load i8, ptr [[ARRAYIDX5_I]], align 1
// CHECK2-NEXT:    [[CONV_I:%.*]] = sext i8 [[TMP40]] to i32
// CHECK2-NEXT:    store i32 [[CONV_I]], ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK2-NEXT:    [[CONV7_I:%.*]] = sext i32 [[TMP41]] to i64
// CHECK2-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[SUB8_I:%.*]] = sub i32 [[TMP42]], [[TMP43]]
// CHECK2-NEXT:    [[SUB9_I:%.*]] = sub i32 [[SUB8_I]], 1
// CHECK2-NEXT:    [[CONV11_I:%.*]] = zext i32 [[SUB8_I]] to i64
// CHECK2-NEXT:    [[MUL_I:%.*]] = mul nsw i64 [[CONV7_I]], [[CONV11_I]]
// CHECK2-NEXT:    [[SUB12_I:%.*]] = sub nsw i64 [[MUL_I]], 1
// CHECK2-NEXT:    store i64 [[SUB12_I]], ptr [[DOTCAPTURE_EXPR_6_I]], align 8, !noalias !47
// CHECK2-NEXT:    store i32 0, ptr [[I_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK2-NEXT:    store i32 [[TMP44]], ptr [[J_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK2-NEXT:    [[CMP_I:%.*]] = icmp slt i32 0, [[TMP45]]
// CHECK2-NEXT:    br i1 [[CMP_I]], label [[LAND_LHS_TRUE_I:%.*]], label [[TASKLOOP_IF_END_I:%.*]]
// CHECK2:       land.lhs.true.i:
// CHECK2-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[CMP13_I:%.*]] = icmp slt i32 [[TMP46]], [[TMP47]]
// CHECK2-NEXT:    br i1 [[CMP13_I]], label [[TASKLOOP_IF_THEN_I:%.*]], label [[TASKLOOP_IF_END_I]]
// CHECK2:       taskloop.if.then.i:
// CHECK2-NEXT:    [[TMP48:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !47
// CHECK2-NEXT:    store i64 [[TMP48]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK2-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[TMP49]], align 8
// CHECK2-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[TMP51]], align 8
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK2:       omp.inner.for.cond.i:
// CHECK2-NEXT:    [[TMP53:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48:![0-9]+]]
// CHECK2-NEXT:    [[TMP54:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[CMP16_I:%.*]] = icmp ule i64 [[TMP53]], [[TMP54]]
// CHECK2-NEXT:    br i1 [[CMP16_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[OMP_INNER_FOR_END_I:%.*]]
// CHECK2:       omp.inner.for.body.i:
// CHECK2-NEXT:    [[TMP55:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[SUB17_I:%.*]] = sub i32 [[TMP56]], [[TMP57]]
// CHECK2-NEXT:    [[SUB18_I:%.*]] = sub i32 [[SUB17_I]], 1
// CHECK2-NEXT:    [[CONV22_I:%.*]] = zext i32 [[SUB17_I]] to i64
// CHECK2-NEXT:    [[DIV23_I:%.*]] = sdiv i64 [[TMP55]], [[CONV22_I]]
// CHECK2-NEXT:    [[CONV26_I:%.*]] = trunc i64 [[DIV23_I]] to i32
// CHECK2-NEXT:    store i32 [[CONV26_I]], ptr [[I14_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[CONV27_I:%.*]] = sext i32 [[TMP58]] to i64
// CHECK2-NEXT:    [[TMP59:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP60:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP61:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP62:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[SUB28_I:%.*]] = sub i32 [[TMP61]], [[TMP62]]
// CHECK2-NEXT:    [[SUB29_I:%.*]] = sub i32 [[SUB28_I]], 1
// CHECK2-NEXT:    [[CONV33_I:%.*]] = zext i32 [[SUB28_I]] to i64
// CHECK2-NEXT:    [[DIV34_I:%.*]] = sdiv i64 [[TMP60]], [[CONV33_I]]
// CHECK2-NEXT:    [[TMP63:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP64:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[SUB35_I:%.*]] = sub i32 [[TMP63]], [[TMP64]]
// CHECK2-NEXT:    [[SUB36_I:%.*]] = sub i32 [[SUB35_I]], 1
// CHECK2-NEXT:    [[CONV40_I:%.*]] = zext i32 [[SUB35_I]] to i64
// CHECK2-NEXT:    [[MUL41_I:%.*]] = mul nsw i64 [[DIV34_I]], [[CONV40_I]]
// CHECK2-NEXT:    [[SUB42_I:%.*]] = sub nsw i64 [[TMP59]], [[MUL41_I]]
// CHECK2-NEXT:    [[ADD44_I:%.*]] = add nsw i64 [[CONV27_I]], [[SUB42_I]]
// CHECK2-NEXT:    [[CONV45_I:%.*]] = trunc i64 [[ADD44_I]] to i32
// CHECK2-NEXT:    store i32 [[CONV45_I]], ptr [[J15_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[TMP65:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    [[ADD46_I:%.*]] = add nsw i64 [[TMP65]], 1
// CHECK2-NEXT:    store i64 [[ADD46_I]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP49:![0-9]+]]
// CHECK2:       omp.inner.for.end.i:
// CHECK2-NEXT:    br label [[TASKLOOP_IF_END_I]]
// CHECK2:       taskloop.if.end.i:
// CHECK2-NEXT:    [[TMP66:%.*]] = load i32, ptr [[DOTLITER__ADDR_I]], align 4, !noalias !47
// CHECK2-NEXT:    [[TMP67:%.*]] = icmp ne i32 [[TMP66]], 0
// CHECK2-NEXT:    br i1 [[TMP67]], label [[DOTOMP_LASTPRIVATE_THEN_I:%.*]], label [[DOTOMP_OUTLINED__5_EXIT:%.*]]
// CHECK2:       .omp.lastprivate.then.i:
// CHECK2-NEXT:    br label [[DOTOMP_OUTLINED__5_EXIT]]
// CHECK2:       .omp_outlined..5.exit:
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_task_dup.
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], i32 noundef [[TMP2:%.*]]) #[[ATTR4]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTADDR2]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 8
// CHECK2-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTADDR2]], align 4
// CHECK2-NEXT:    store i32 [[TMP6]], ptr [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP3]], i32 0, i32 1
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK2-SAME: () #[[ATTR6]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR8:[0-9]+]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK2-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR8]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK2-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK2-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK2-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[TMP1:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK2-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP1]] to i1
// CHECK2-NEXT:    [[FROMBOOL3:%.*]] = zext i1 [[TOBOOL2]] to i8
// CHECK2-NEXT:    store i8 [[FROMBOOL3]], ptr [[DOTCAPTURE_EXPR__CASTED]], align 1
// CHECK2-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @_ZN1SC2Ei.omp_outlined, ptr [[THIS1]], ptr [[C_ADDR]], i64 [[TMP2]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN1SC2Ei.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_4:%.*]], align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK2-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[TMP7]], align 8
// CHECK2-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    [[TMP8:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK2-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP8]] to i1
// CHECK2-NEXT:    store ptr [[TMP]], ptr [[_TMP1]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK2-NEXT:    store i32 [[TMP9]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK2-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP10]], 0
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK2-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK2-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = select i1 [[TOBOOL]], i32 2, i32 0
// CHECK2-NEXT:    [[TMP12:%.*]] = or i32 [[TMP11]], 1
// CHECK2-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP3]], i32 [[TMP12]], i64 80, i64 16, ptr @.omp_task_entry..8)
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_5:%.*]], ptr [[TMP13]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP14]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP16]], ptr align 8 [[AGG_CAPTURED]], i64 16, i1 false)
// CHECK2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 5
// CHECK2-NEXT:    store i64 0, ptr [[TMP17]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 6
// CHECK2-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK2-NEXT:    [[CONV:%.*]] = sext i32 [[TMP19]] to i64
// CHECK2-NEXT:    store i64 [[CONV]], ptr [[TMP18]], align 8
// CHECK2-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 7
// CHECK2-NEXT:    store i64 1, ptr [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 9
// CHECK2-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP21]], i8 0, i64 8, i1 false)
// CHECK2-NEXT:    [[TMP22:%.*]] = load i64, ptr [[TMP20]], align 8
// CHECK2-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP3]], ptr [[TMP13]], i32 1, ptr [[TMP17]], ptr [[TMP18]], i64 [[TMP22]], i32 1, i32 2, i64 4, ptr null)
// CHECK2-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp_task_entry..8
// CHECK2-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[TMP_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP1_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR__I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTCAPTURE_EXPR_2_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[A_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP4_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A5_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[TMP6_I:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_5:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK2-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK2-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK2-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META51:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META54:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META56:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META58:![0-9]+]])
// CHECK2-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META60:![0-9]+]])
// CHECK2-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !62
// CHECK2-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !62
// CHECK2-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[TMP18]], align 8
// CHECK2-NEXT:    store ptr [[TMP_I]], ptr [[TMP1_I]], align 8, !noalias !62
// CHECK2-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_ANON_4:%.*]], ptr [[TMP18]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[TMP20]], align 8
// CHECK2-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
// CHECK2-NEXT:    store i32 [[TMP22]], ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !62
// CHECK2-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !62
// CHECK2-NEXT:    [[SUB3_I:%.*]] = sub nsw i32 [[TMP23]], 1
// CHECK2-NEXT:    store i32 [[SUB3_I]], ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !62
// CHECK2-NEXT:    store ptr [[A_I]], ptr [[TMP4_I]], align 8, !noalias !62
// CHECK2-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP4_I]], align 8, !noalias !62
// CHECK2-NEXT:    store i32 0, ptr [[TMP24]], align 4
// CHECK2-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !62
// CHECK2-NEXT:    [[CMP_I:%.*]] = icmp slt i32 0, [[TMP25]]
// CHECK2-NEXT:    br i1 [[CMP_I]], label [[TASKLOOP_IF_THEN_I:%.*]], label [[DOTOMP_OUTLINED__7_EXIT:%.*]]
// CHECK2:       taskloop.if.then.i:
// CHECK2-NEXT:    store ptr [[A5_I]], ptr [[TMP6_I]], align 8, !noalias !62
// CHECK2-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !62
// CHECK2-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP26]] to i32
// CHECK2-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !62
// CHECK2-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[TMP18]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[TMP27]], align 8
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK2:       omp.inner.for.cond.i:
// CHECK2-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63:![0-9]+]]
// CHECK2-NEXT:    [[CONV7_I:%.*]] = sext i32 [[TMP29]] to i64
// CHECK2-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK2-NEXT:    [[CMP8_I:%.*]] = icmp ule i64 [[CONV7_I]], [[TMP30]]
// CHECK2-NEXT:    br i1 [[CMP8_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[OMP_INNER_FOR_END_I:%.*]]
// CHECK2:       omp.inner.for.body.i:
// CHECK2-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK2-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP6_I]], align 8, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK2-NEXT:    store i32 [[TMP31]], ptr [[TMP32]], align 4, !llvm.access.group [[ACC_GRP63]]
// CHECK2-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK2-NEXT:    [[ADD9_I:%.*]] = add nsw i32 [[TMP33]], 1
// CHECK2-NEXT:    store i32 [[ADD9_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !62, !llvm.access.group [[ACC_GRP63]]
// CHECK2-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP64:![0-9]+]]
// CHECK2:       omp.inner.for.end.i:
// CHECK2-NEXT:    br label [[DOTOMP_OUTLINED__7_EXIT]]
// CHECK2:       .omp_outlined..7.exit:
// CHECK2-NEXT:    ret i32 0
//
//
// CHECK2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK2-SAME: () #[[ATTR6]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__cxx_global_var_init()
// CHECK2-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@main
// CHECK3-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED2:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED6:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED8:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTTHREADID_TEMP_:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTBOUND_ZERO_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK3-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK3-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTCAPTURE_EXPR__CASTED]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 1, ptr @main.omp_outlined, i64 [[TMP3]])
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP4]], ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_1]], align 4
// CHECK3-NEXT:    store i32 [[TMP5]], ptr [[DOTCAPTURE_EXPR__CASTED2]], align 4
// CHECK3-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED2]], align 8
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 1, ptr @main.omp_outlined.1, i64 [[TMP6]])
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK3-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP7]], 0
// CHECK3-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK3-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK3-NEXT:    [[TOBOOL5:%.*]] = trunc i8 [[TMP9]] to i1
// CHECK3-NEXT:    [[FROMBOOL7:%.*]] = zext i1 [[TOBOOL5]] to i8
// CHECK3-NEXT:    store i8 [[FROMBOOL7]], ptr [[DOTCAPTURE_EXPR__CASTED6]], align 1
// CHECK3-NEXT:    [[TMP10:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED6]], align 8
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK3-NEXT:    store i32 [[TMP11]], ptr [[DOTCAPTURE_EXPR__CASTED8]], align 4
// CHECK3-NEXT:    [[TMP12:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED8]], align 8
// CHECK3-NEXT:    [[TMP13:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_3]], align 1
// CHECK3-NEXT:    [[TOBOOL9:%.*]] = trunc i8 [[TMP13]] to i1
// CHECK3-NEXT:    br i1 [[TOBOOL9]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 5, ptr @main.omp_outlined.4, ptr [[I]], ptr [[ARGC_ADDR]], ptr [[ARGV_ADDR]], i64 [[TMP10]], i64 [[TMP12]])
// CHECK3-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.else:
// CHECK3-NEXT:    call void @__kmpc_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTTHREADID_TEMP_]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTBOUND_ZERO_ADDR]], align 4
// CHECK3-NEXT:    call void @main.omp_outlined.4(ptr [[DOTTHREADID_TEMP_]], ptr [[DOTBOUND_ZERO_ADDR]], ptr [[I]], ptr [[ARGC_ADDR]], ptr [[ARGV_ADDR]], i64 [[TMP10]], i64 [[TMP12]]) #[[ATTR2:[0-9]+]]
// CHECK3-NEXT:    call void @__kmpc_end_serialized_parallel(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK3-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK3-LABEL: define {{[^@]+}}@main.omp_outlined
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON:%.*]], align 1
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK3-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 33, i64 80, i64 1, ptr @.omp_task_entry.)
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP6]], i32 0, i32 4
// CHECK3-NEXT:    store i32 [[TMP4]], ptr [[TMP7]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 5
// CHECK3-NEXT:    store i64 0, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 6
// CHECK3-NEXT:    store i64 9, ptr [[TMP9]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 7
// CHECK3-NEXT:    store i64 1, ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 9
// CHECK3-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP11]], i8 0, i64 8, i1 false)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK3-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP5]], i32 1, ptr [[TMP8]], ptr [[TMP9]], i64 [[TMP12]], i32 1, i32 0, i64 0, ptr null)
// CHECK3-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_entry.
// CHECK3-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK3-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META3:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META6:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META8:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META10:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META12:![0-9]+]])
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !14
// CHECK3-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !14
// CHECK3-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP19]] to i32
// CHECK3-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK3:       omp.inner.for.cond.i:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK3-NEXT:    [[CONV1_I:%.*]] = sext i32 [[TMP20]] to i64
// CHECK3-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !14
// CHECK3-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV1_I]], [[TMP21]]
// CHECK3-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__EXIT:%.*]]
// CHECK3:       omp.inner.for.body.i:
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK3-NEXT:    store i32 [[TMP22]], ptr [[I_I]], align 4, !noalias !14
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK3-NEXT:    [[ADD2_I:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK3-NEXT:    store i32 [[ADD2_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !14
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK3:       .omp_outlined..exit:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@main.omp_outlined.1
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_0:%.*]], align 1
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK3-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP1]], i32 1, i64 80, i64 1, ptr @.omp_task_entry..3)
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_1:%.*]], ptr [[TMP5]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP6]], i32 0, i32 5
// CHECK3-NEXT:    store i64 0, ptr [[TMP7]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 6
// CHECK3-NEXT:    store i64 9, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 7
// CHECK3-NEXT:    store i64 1, ptr [[TMP9]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP6]], i32 0, i32 9
// CHECK3-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP10]], i8 0, i64 8, i1 false)
// CHECK3-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = zext i32 [[TMP4]] to i64
// CHECK3-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP1]], ptr [[TMP5]], i32 1, ptr [[TMP7]], ptr [[TMP8]], i64 [[TMP11]], i32 1, i32 1, i64 [[TMP12]], ptr null)
// CHECK3-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_entry..3
// CHECK3-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_1:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK3-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META20:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META23:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META25:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META27:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META29:![0-9]+]])
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !31
// CHECK3-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !31
// CHECK3-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    [[TMP19:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !31
// CHECK3-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP19]] to i32
// CHECK3-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !31
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK3:       omp.inner.for.cond.i:
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32:![0-9]+]]
// CHECK3-NEXT:    [[CONV1_I:%.*]] = sext i32 [[TMP20]] to i64
// CHECK3-NEXT:    [[TMP21:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK3-NEXT:    [[CMP_I:%.*]] = icmp ule i64 [[CONV1_I]], [[TMP21]]
// CHECK3-NEXT:    br i1 [[CMP_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[DOTOMP_OUTLINED__2_EXIT:%.*]]
// CHECK3:       omp.inner.for.body.i:
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK3-NEXT:    store i32 [[TMP22]], ptr [[I_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK3-NEXT:    [[ADD2_I:%.*]] = add nsw i32 [[TMP23]], 1
// CHECK3-NEXT:    store i32 [[ADD2_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !31, !llvm.access.group [[ACC_GRP32]]
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP33:![0-9]+]]
// CHECK3:       .omp_outlined..2.exit:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@main.omp_outlined.4
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[I:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[ARGC:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[ARGV:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]], i64 noundef [[DOTCAPTURE_EXPR_1:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[I_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[ARGC_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR2:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_2:%.*]], align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_6:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_9:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[I]], ptr [[I_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[ARGC]], ptr [[ARGC_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK3-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK3-NEXT:    store i64 [[DOTCAPTURE_EXPR_1]], ptr [[DOTCAPTURE_EXPR__ADDR2]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[I_ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[ARGC_ADDR]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK3-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[TMP2]], ptr [[TMP9]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[AGG_CAPTURED]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP11:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK3-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP11]] to i1
// CHECK3-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK3-NEXT:    store i8 [[FROMBOOL]], ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__ADDR2]], align 4
// CHECK3-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP13]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], ptr [[DOTCAPTURE_EXPR_5]], align 4
// CHECK3-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK3-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP16]] to i64
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP15]], i64 [[IDXPROM]]
// CHECK3-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK3-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP18]] to i64
// CHECK3-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i8, ptr [[TMP17]], i64 [[IDXPROM7]]
// CHECK3-NEXT:    [[TMP19:%.*]] = load i8, ptr [[ARRAYIDX8]], align 1
// CHECK3-NEXT:    [[CONV:%.*]] = sext i8 [[TMP19]] to i32
// CHECK3-NEXT:    store i32 [[CONV]], ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP20]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[CONV10:%.*]] = sext i32 [[DIV]] to i64
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_6]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_5]], align 4
// CHECK3-NEXT:    [[SUB11:%.*]] = sub i32 [[TMP21]], [[TMP22]]
// CHECK3-NEXT:    [[SUB12:%.*]] = sub i32 [[SUB11]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add i32 [[SUB12]], 1
// CHECK3-NEXT:    [[DIV13:%.*]] = udiv i32 [[ADD]], 1
// CHECK3-NEXT:    [[CONV14:%.*]] = zext i32 [[DIV13]] to i64
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i64 [[CONV10]], [[CONV14]]
// CHECK3-NEXT:    [[SUB15:%.*]] = sub nsw i64 [[MUL]], 1
// CHECK3-NEXT:    store i64 [[SUB15]], ptr [[DOTCAPTURE_EXPR_9]], align 8
// CHECK3-NEXT:    [[TMP23:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP4]], i32 1, i64 88, i64 32, ptr @.omp_task_entry..6)
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP23]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP24]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[TMP25]], align 8
// CHECK3-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP26]], ptr align 8 [[AGG_CAPTURED]], i64 32, i1 false)
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP23]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP28:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK3-NEXT:    [[TOBOOL16:%.*]] = trunc i8 [[TMP28]] to i1
// CHECK3-NEXT:    [[TMP29:%.*]] = sext i1 [[TOBOOL16]] to i32
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP24]], i32 0, i32 5
// CHECK3-NEXT:    store i64 0, ptr [[TMP30]], align 8
// CHECK3-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP24]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_9]], align 8
// CHECK3-NEXT:    store i64 [[TMP32]], ptr [[TMP31]], align 8
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP24]], i32 0, i32 7
// CHECK3-NEXT:    store i64 1, ptr [[TMP33]], align 8
// CHECK3-NEXT:    [[TMP34:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP24]], i32 0, i32 9
// CHECK3-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP34]], i8 0, i64 8, i1 false)
// CHECK3-NEXT:    [[TMP35:%.*]] = load i64, ptr [[TMP33]], align 8
// CHECK3-NEXT:    [[TMP36:%.*]] = zext i32 [[TMP12]] to i64
// CHECK3-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP4]], ptr [[TMP23]], i32 [[TMP29]], ptr [[TMP30]], ptr [[TMP31]], i64 [[TMP35]], i32 1, i32 2, i64 [[TMP36]], ptr @.omp_task_dup.)
// CHECK3-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_privates_map.
// CHECK3-SAME: (ptr noalias noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR6:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[STRUCT__KMP_PRIVATES_T:%.*]], ptr [[TMP2]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[TMP4]], align 8
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_entry..6
// CHECK3-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTLASTPRIV_PTR_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_3_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_6_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[I_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[J_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[I14_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[J15_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP3]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP9]], align 8
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP11]], align 8
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP13]], align 8
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 8
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK3-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META36:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META39:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META41:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META43:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META45:![0-9]+]])
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !47
// CHECK3-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store ptr [[TMP8]], ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store ptr @.omp_task_privates_map., ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store i64 [[TMP10]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store i64 [[TMP12]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store i64 [[TMP14]], ptr [[DOTST__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store i32 [[TMP16]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !47
// CHECK3-NEXT:    store ptr [[TMP18]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    call void [[TMP20]](ptr [[TMP21]], ptr [[DOTLASTPRIV_PTR_ADDR_I]]) #[[ATTR2]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK3-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[DOTLASTPRIV_PTR_ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_ANON_2:%.*]], ptr [[TMP19]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP25:%.*]] = load ptr, ptr [[TMP24]], align 8
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
// CHECK3-NEXT:    store i32 [[TMP26]], ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[TMP27]], align 8
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, ptr [[TMP28]], align 4
// CHECK3-NEXT:    store i32 [[TMP29]], ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[TMP30]], align 8
// CHECK3-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP31]], align 8
// CHECK3-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[TMP33]], align 8
// CHECK3-NEXT:    [[TMP35:%.*]] = load i32, ptr [[TMP34]], align 4
// CHECK3-NEXT:    [[IDXPROM_I:%.*]] = sext i32 [[TMP35]] to i64
// CHECK3-NEXT:    [[ARRAYIDX_I:%.*]] = getelementptr inbounds ptr, ptr [[TMP32]], i64 [[IDXPROM_I]]
// CHECK3-NEXT:    [[TMP36:%.*]] = load ptr, ptr [[ARRAYIDX_I]], align 8
// CHECK3-NEXT:    [[TMP37:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[TMP37]], align 8
// CHECK3-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP38]], align 4
// CHECK3-NEXT:    [[IDXPROM4_I:%.*]] = sext i32 [[TMP39]] to i64
// CHECK3-NEXT:    [[ARRAYIDX5_I:%.*]] = getelementptr inbounds i8, ptr [[TMP36]], i64 [[IDXPROM4_I]]
// CHECK3-NEXT:    [[TMP40:%.*]] = load i8, ptr [[ARRAYIDX5_I]], align 1
// CHECK3-NEXT:    [[CONV_I:%.*]] = sext i8 [[TMP40]] to i32
// CHECK3-NEXT:    store i32 [[CONV_I]], ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK3-NEXT:    [[CONV7_I:%.*]] = sext i32 [[TMP41]] to i64
// CHECK3-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[SUB8_I:%.*]] = sub i32 [[TMP42]], [[TMP43]]
// CHECK3-NEXT:    [[SUB9_I:%.*]] = sub i32 [[SUB8_I]], 1
// CHECK3-NEXT:    [[CONV11_I:%.*]] = zext i32 [[SUB8_I]] to i64
// CHECK3-NEXT:    [[MUL_I:%.*]] = mul nsw i64 [[CONV7_I]], [[CONV11_I]]
// CHECK3-NEXT:    [[SUB12_I:%.*]] = sub nsw i64 [[MUL_I]], 1
// CHECK3-NEXT:    store i64 [[SUB12_I]], ptr [[DOTCAPTURE_EXPR_6_I]], align 8, !noalias !47
// CHECK3-NEXT:    store i32 0, ptr [[I_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    store i32 [[TMP44]], ptr [[J_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !47
// CHECK3-NEXT:    [[CMP_I:%.*]] = icmp slt i32 0, [[TMP45]]
// CHECK3-NEXT:    br i1 [[CMP_I]], label [[LAND_LHS_TRUE_I:%.*]], label [[TASKLOOP_IF_END_I:%.*]]
// CHECK3:       land.lhs.true.i:
// CHECK3-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[CMP13_I:%.*]] = icmp slt i32 [[TMP46]], [[TMP47]]
// CHECK3-NEXT:    br i1 [[CMP13_I]], label [[TASKLOOP_IF_THEN_I:%.*]], label [[TASKLOOP_IF_END_I]]
// CHECK3:       taskloop.if.then.i:
// CHECK3-NEXT:    [[TMP48:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    store i64 [[TMP48]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP49:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP50:%.*]] = load ptr, ptr [[TMP49]], align 8
// CHECK3-NEXT:    [[TMP51:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[TMP51]], align 8
// CHECK3-NEXT:    [[TMP53:%.*]] = getelementptr inbounds [[STRUCT_ANON_2]], ptr [[TMP19]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP54:%.*]] = load i8, ptr [[TMP53]], align 1
// CHECK3-NEXT:    [[TOBOOL_I:%.*]] = trunc i8 [[TMP54]] to i1
// CHECK3-NEXT:    br i1 [[TOBOOL_I]], label [[OMP_IF_THEN_I:%.*]], label [[OMP_IF_ELSE_I:%.*]]
// CHECK3:       omp_if.then.i:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK3:       omp.inner.for.cond.i:
// CHECK3-NEXT:    [[TMP55:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48:![0-9]+]]
// CHECK3-NEXT:    [[TMP56:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[CMP16_I:%.*]] = icmp ule i64 [[TMP55]], [[TMP56]]
// CHECK3-NEXT:    br i1 [[CMP16_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[OMP_INNER_FOR_END_I:%.*]]
// CHECK3:       omp.inner.for.body.i:
// CHECK3-NEXT:    [[TMP57:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP59:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[SUB17_I:%.*]] = sub i32 [[TMP58]], [[TMP59]]
// CHECK3-NEXT:    [[SUB18_I:%.*]] = sub i32 [[SUB17_I]], 1
// CHECK3-NEXT:    [[CONV22_I:%.*]] = zext i32 [[SUB17_I]] to i64
// CHECK3-NEXT:    [[DIV23_I:%.*]] = sdiv i64 [[TMP57]], [[CONV22_I]]
// CHECK3-NEXT:    [[CONV26_I:%.*]] = trunc i64 [[DIV23_I]] to i32
// CHECK3-NEXT:    store i32 [[CONV26_I]], ptr [[I14_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[CONV27_I:%.*]] = sext i32 [[TMP60]] to i64
// CHECK3-NEXT:    [[TMP61:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP62:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP63:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP64:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[SUB28_I:%.*]] = sub i32 [[TMP63]], [[TMP64]]
// CHECK3-NEXT:    [[SUB29_I:%.*]] = sub i32 [[SUB28_I]], 1
// CHECK3-NEXT:    [[CONV33_I:%.*]] = zext i32 [[SUB28_I]] to i64
// CHECK3-NEXT:    [[DIV34_I:%.*]] = sdiv i64 [[TMP62]], [[CONV33_I]]
// CHECK3-NEXT:    [[TMP65:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP66:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[SUB35_I:%.*]] = sub i32 [[TMP65]], [[TMP66]]
// CHECK3-NEXT:    [[SUB36_I:%.*]] = sub i32 [[SUB35_I]], 1
// CHECK3-NEXT:    [[CONV40_I:%.*]] = zext i32 [[SUB35_I]] to i64
// CHECK3-NEXT:    [[MUL41_I:%.*]] = mul nsw i64 [[DIV34_I]], [[CONV40_I]]
// CHECK3-NEXT:    [[SUB42_I:%.*]] = sub nsw i64 [[TMP61]], [[MUL41_I]]
// CHECK3-NEXT:    [[ADD44_I:%.*]] = add nsw i64 [[CONV27_I]], [[SUB42_I]]
// CHECK3-NEXT:    [[CONV45_I:%.*]] = trunc i64 [[ADD44_I]] to i32
// CHECK3-NEXT:    store i32 [[CONV45_I]], ptr [[J15_I]], align 4, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[TMP67:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    [[ADD46_I:%.*]] = add nsw i64 [[TMP67]], 1
// CHECK3-NEXT:    store i64 [[ADD46_I]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47, !llvm.access.group [[ACC_GRP48]]
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP49:![0-9]+]]
// CHECK3:       omp.inner.for.end.i:
// CHECK3-NEXT:    br label [[OMP_IF_END_I:%.*]]
// CHECK3:       omp_if.else.i:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND47_I:%.*]]
// CHECK3:       omp.inner.for.cond47.i:
// CHECK3-NEXT:    [[TMP68:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP69:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[CMP48_I:%.*]] = icmp ule i64 [[TMP68]], [[TMP69]]
// CHECK3-NEXT:    br i1 [[CMP48_I]], label [[OMP_INNER_FOR_BODY49_I:%.*]], label [[OMP_INNER_FOR_END82_I:%.*]]
// CHECK3:       omp.inner.for.body49.i:
// CHECK3-NEXT:    [[TMP70:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP71:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP72:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[SUB50_I:%.*]] = sub i32 [[TMP71]], [[TMP72]]
// CHECK3-NEXT:    [[SUB51_I:%.*]] = sub i32 [[SUB50_I]], 1
// CHECK3-NEXT:    [[CONV55_I:%.*]] = zext i32 [[SUB50_I]] to i64
// CHECK3-NEXT:    [[DIV56_I:%.*]] = sdiv i64 [[TMP70]], [[CONV55_I]]
// CHECK3-NEXT:    [[CONV59_I:%.*]] = trunc i64 [[DIV56_I]] to i32
// CHECK3-NEXT:    store i32 [[CONV59_I]], ptr [[I14_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP73:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[CONV60_I:%.*]] = sext i32 [[TMP73]] to i64
// CHECK3-NEXT:    [[TMP74:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP75:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[TMP76:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP77:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[SUB61_I:%.*]] = sub i32 [[TMP76]], [[TMP77]]
// CHECK3-NEXT:    [[SUB62_I:%.*]] = sub i32 [[SUB61_I]], 1
// CHECK3-NEXT:    [[CONV66_I:%.*]] = zext i32 [[SUB61_I]] to i64
// CHECK3-NEXT:    [[DIV67_I:%.*]] = sdiv i64 [[TMP75]], [[CONV66_I]]
// CHECK3-NEXT:    [[TMP78:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP79:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[SUB68_I:%.*]] = sub i32 [[TMP78]], [[TMP79]]
// CHECK3-NEXT:    [[SUB69_I:%.*]] = sub i32 [[SUB68_I]], 1
// CHECK3-NEXT:    [[CONV73_I:%.*]] = zext i32 [[SUB68_I]] to i64
// CHECK3-NEXT:    [[MUL74_I:%.*]] = mul nsw i64 [[DIV67_I]], [[CONV73_I]]
// CHECK3-NEXT:    [[SUB75_I:%.*]] = sub nsw i64 [[TMP74]], [[MUL74_I]]
// CHECK3-NEXT:    [[ADD77_I:%.*]] = add nsw i64 [[CONV60_I]], [[SUB75_I]]
// CHECK3-NEXT:    [[CONV78_I:%.*]] = trunc i64 [[ADD77_I]] to i32
// CHECK3-NEXT:    store i32 [[CONV78_I]], ptr [[J15_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP80:%.*]] = load i64, ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    [[ADD81_I:%.*]] = add nsw i64 [[TMP80]], 1
// CHECK3-NEXT:    store i64 [[ADD81_I]], ptr [[DOTOMP_IV_I]], align 8, !noalias !47
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND47_I]], !llvm.loop [[LOOP51:![0-9]+]]
// CHECK3:       omp.inner.for.end82.i:
// CHECK3-NEXT:    br label [[OMP_IF_END_I]]
// CHECK3:       omp_if.end.i:
// CHECK3-NEXT:    br label [[TASKLOOP_IF_END_I]]
// CHECK3:       taskloop.if.end.i:
// CHECK3-NEXT:    [[TMP81:%.*]] = load i32, ptr [[DOTLITER__ADDR_I]], align 4, !noalias !47
// CHECK3-NEXT:    [[TMP82:%.*]] = icmp ne i32 [[TMP81]], 0
// CHECK3-NEXT:    br i1 [[TMP82]], label [[DOTOMP_LASTPRIVATE_THEN_I:%.*]], label [[DOTOMP_OUTLINED__5_EXIT:%.*]]
// CHECK3:       .omp.lastprivate.then.i:
// CHECK3-NEXT:    br label [[DOTOMP_OUTLINED__5_EXIT]]
// CHECK3:       .omp_outlined..5.exit:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_dup.
// CHECK3-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], i32 noundef [[TMP2:%.*]]) #[[ATTR4]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTADDR2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTADDR2]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTADDR2]], align 4
// CHECK3-NEXT:    store i32 [[TMP6]], ptr [[TMP5]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_3]], ptr [[TMP3]], i32 0, i32 1
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK3-SAME: () #[[ATTR6]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR8:[0-9]+]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK3-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR8]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__CASTED:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK3-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK3-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK3-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[TMP1:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK3-NEXT:    [[TOBOOL2:%.*]] = trunc i8 [[TMP1]] to i1
// CHECK3-NEXT:    [[FROMBOOL3:%.*]] = zext i1 [[TOBOOL2]] to i8
// CHECK3-NEXT:    store i8 [[FROMBOOL3]], ptr [[DOTCAPTURE_EXPR__CASTED]], align 1
// CHECK3-NEXT:    [[TMP2:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR__CASTED]], align 8
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 3, ptr @_ZN1SC2Ei.omp_outlined, ptr [[THIS1]], ptr [[C_ADDR]], i64 [[TMP2]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN1SC2Ei.omp_outlined
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]], i64 noundef [[DOTCAPTURE_EXPR_:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__ADDR:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[AGG_CAPTURED:%.*]] = alloca [[STRUCT_ANON_4:%.*]], align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK3-NEXT:    store i64 [[DOTCAPTURE_EXPR_]], ptr [[DOTCAPTURE_EXPR__ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_master(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK3-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK3-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK3:       omp_if.then:
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[AGG_CAPTURED]], i32 0, i32 0
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[AGG_CAPTURED]], i32 0, i32 1
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP7]], align 8
// CHECK3-NEXT:    call void @__kmpc_taskgroup(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK3-NEXT:    [[TMP8:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR__ADDR]], align 1
// CHECK3-NEXT:    [[TOBOOL:%.*]] = trunc i8 [[TMP8]] to i1
// CHECK3-NEXT:    store ptr [[TMP]], ptr [[_TMP1]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP1]], align 4
// CHECK3-NEXT:    store i32 [[TMP9]], ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_2]], align 4
// CHECK3-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP10]], 0
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK3-NEXT:    [[SUB4:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK3-NEXT:    store i32 [[SUB4]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = select i1 [[TOBOOL]], i32 2, i32 0
// CHECK3-NEXT:    [[TMP12:%.*]] = or i32 [[TMP11]], 1
// CHECK3-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_omp_task_alloc(ptr @[[GLOB1]], i32 [[TMP3]], i32 [[TMP12]], i64 80, i64 16, ptr @.omp_task_entry..8)
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_5:%.*]], ptr [[TMP13]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP14]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK3-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 8 [[TMP16]], ptr align 8 [[AGG_CAPTURED]], i64 16, i1 false)
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 5
// CHECK3-NEXT:    store i64 0, ptr [[TMP17]], align 8
// CHECK3-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK3-NEXT:    [[CONV:%.*]] = sext i32 [[TMP19]] to i64
// CHECK3-NEXT:    store i64 [[CONV]], ptr [[TMP18]], align 8
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 7
// CHECK3-NEXT:    store i64 1, ptr [[TMP20]], align 8
// CHECK3-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP14]], i32 0, i32 9
// CHECK3-NEXT:    call void @llvm.memset.p0.i64(ptr align 8 [[TMP21]], i8 0, i64 8, i1 false)
// CHECK3-NEXT:    [[TMP22:%.*]] = load i64, ptr [[TMP20]], align 8
// CHECK3-NEXT:    call void @__kmpc_taskloop(ptr @[[GLOB1]], i32 [[TMP3]], ptr [[TMP13]], i32 1, ptr [[TMP17]], ptr [[TMP18]], i64 [[TMP22]], i32 1, i32 2, i64 4, ptr null)
// CHECK3-NEXT:    call void @__kmpc_end_taskgroup(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK3-NEXT:    call void @__kmpc_end_master(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK3-NEXT:    br label [[OMP_IF_END]]
// CHECK3:       omp_if.end:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_task_entry..8
// CHECK3-SAME: (i32 noundef [[TMP0:%.*]], ptr noalias noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPART_ID__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTPRIVATES__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCOPY_FN__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTTASK_T__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTLB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTUB__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTST__ADDR_I:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[DOTLITER__ADDR_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTREDUCTIONS__ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[__CONTEXT_ADDR_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[TMP_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP1_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR__I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTCAPTURE_EXPR_2_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[A_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP4_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[A5_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP6_I:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTOMP_IV_I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store i32 [[TMP0]], ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T_WITH_PRIVATES_5:%.*]], ptr [[TMP3]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T:%.*]], ptr [[TMP4]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 5
// CHECK3-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 6
// CHECK3-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 7
// CHECK3-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 8
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[STRUCT_KMP_TASK_T]], ptr [[TMP4]], i32 0, i32 9
// CHECK3-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META53:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META56:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META58:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META60:![0-9]+]])
// CHECK3-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata [[META62:![0-9]+]])
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTGLOBAL_TID__ADDR_I]], align 4, !noalias !64
// CHECK3-NEXT:    store ptr [[TMP5]], ptr [[DOTPART_ID__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store ptr null, ptr [[DOTPRIVATES__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store ptr null, ptr [[DOTCOPY_FN__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[DOTTASK_T__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store i64 [[TMP9]], ptr [[DOTLB__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store i64 [[TMP11]], ptr [[DOTUB__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store i64 [[TMP13]], ptr [[DOTST__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store i32 [[TMP15]], ptr [[DOTLITER__ADDR_I]], align 4, !noalias !64
// CHECK3-NEXT:    store ptr [[TMP17]], ptr [[DOTREDUCTIONS__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    store ptr [[TMP7]], ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[__CONTEXT_ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[TMP18]], align 8
// CHECK3-NEXT:    store ptr [[TMP_I]], ptr [[TMP1_I]], align 8, !noalias !64
// CHECK3-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT_ANON_4:%.*]], ptr [[TMP18]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[TMP20]], align 8
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP21]], align 4
// CHECK3-NEXT:    store i32 [[TMP22]], ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !64
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !64
// CHECK3-NEXT:    [[SUB3_I:%.*]] = sub nsw i32 [[TMP23]], 1
// CHECK3-NEXT:    store i32 [[SUB3_I]], ptr [[DOTCAPTURE_EXPR_2_I]], align 4, !noalias !64
// CHECK3-NEXT:    store ptr [[A_I]], ptr [[TMP4_I]], align 8, !noalias !64
// CHECK3-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP4_I]], align 8, !noalias !64
// CHECK3-NEXT:    store i32 0, ptr [[TMP24]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR__I]], align 4, !noalias !64
// CHECK3-NEXT:    [[CMP_I:%.*]] = icmp slt i32 0, [[TMP25]]
// CHECK3-NEXT:    br i1 [[CMP_I]], label [[TASKLOOP_IF_THEN_I:%.*]], label [[DOTOMP_OUTLINED__7_EXIT:%.*]]
// CHECK3:       taskloop.if.then.i:
// CHECK3-NEXT:    store ptr [[A5_I]], ptr [[TMP6_I]], align 8, !noalias !64
// CHECK3-NEXT:    [[TMP26:%.*]] = load i64, ptr [[DOTLB__ADDR_I]], align 8, !noalias !64
// CHECK3-NEXT:    [[CONV_I:%.*]] = trunc i64 [[TMP26]] to i32
// CHECK3-NEXT:    store i32 [[CONV_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !64
// CHECK3-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT_ANON_4]], ptr [[TMP18]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[TMP27]], align 8
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I:%.*]]
// CHECK3:       omp.inner.for.cond.i:
// CHECK3-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !64, !llvm.access.group [[ACC_GRP65:![0-9]+]]
// CHECK3-NEXT:    [[CONV7_I:%.*]] = sext i32 [[TMP29]] to i64
// CHECK3-NEXT:    [[TMP30:%.*]] = load i64, ptr [[DOTUB__ADDR_I]], align 8, !noalias !64, !llvm.access.group [[ACC_GRP65]]
// CHECK3-NEXT:    [[CMP8_I:%.*]] = icmp ule i64 [[CONV7_I]], [[TMP30]]
// CHECK3-NEXT:    br i1 [[CMP8_I]], label [[OMP_INNER_FOR_BODY_I:%.*]], label [[OMP_INNER_FOR_END_I:%.*]]
// CHECK3:       omp.inner.for.body.i:
// CHECK3-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !64, !llvm.access.group [[ACC_GRP65]]
// CHECK3-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[TMP6_I]], align 8, !noalias !64, !llvm.access.group [[ACC_GRP65]]
// CHECK3-NEXT:    store i32 [[TMP31]], ptr [[TMP32]], align 4, !llvm.access.group [[ACC_GRP65]]
// CHECK3-NEXT:    [[TMP33:%.*]] = load i32, ptr [[DOTOMP_IV_I]], align 4, !noalias !64, !llvm.access.group [[ACC_GRP65]]
// CHECK3-NEXT:    [[ADD9_I:%.*]] = add nsw i32 [[TMP33]], 1
// CHECK3-NEXT:    store i32 [[ADD9_I]], ptr [[DOTOMP_IV_I]], align 4, !noalias !64, !llvm.access.group [[ACC_GRP65]]
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND_I]], !llvm.loop [[LOOP66:![0-9]+]]
// CHECK3:       omp.inner.for.end.i:
// CHECK3-NEXT:    br label [[DOTOMP_OUTLINED__7_EXIT]]
// CHECK3:       .omp_outlined..7.exit:
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK3-SAME: () #[[ATTR6]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__cxx_global_var_init()
// CHECK3-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@main
// CHECK5-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I9:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_21:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP23:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP24:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_25:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_26:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_27:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_31:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_LB40:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_UB41:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[I42:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_IV45:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[I46:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[J47:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK5-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP0]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK5-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK5-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK5-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK5-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP2]] to i64
// CHECK5-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK5-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP3]]
// CHECK5-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK5-NEXT:    store i32 [[ADD2]], ptr [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    store i32 10, ptr [[I]], align 4
// CHECK5-NEXT:    [[TMP6:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP6]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK5-NEXT:    store i64 0, ptr [[DOTOMP_LB5]], align 8
// CHECK5-NEXT:    store i64 9, ptr [[DOTOMP_UB6]], align 8
// CHECK5-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTOMP_LB5]], align 8
// CHECK5-NEXT:    [[CONV8:%.*]] = trunc i64 [[TMP7]] to i32
// CHECK5-NEXT:    store i32 [[CONV8]], ptr [[DOTOMP_IV7]], align 4
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK5:       omp.inner.for.cond10:
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5:![0-9]+]]
// CHECK5-NEXT:    [[CONV11:%.*]] = sext i32 [[TMP8]] to i64
// CHECK5-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTOMP_UB6]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK5-NEXT:    [[CMP12:%.*]] = icmp ule i64 [[CONV11]], [[TMP9]]
// CHECK5-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY13:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK5:       omp.inner.for.body13:
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK5-NEXT:    [[MUL14:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK5-NEXT:    [[ADD15:%.*]] = add nsw i32 0, [[MUL14]]
// CHECK5-NEXT:    store i32 [[ADD15]], ptr [[I9]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK5:       omp.body.continue16:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK5:       omp.inner.for.inc17:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK5-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK5-NEXT:    store i32 [[ADD18]], ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK5:       omp.inner.for.end19:
// CHECK5-NEXT:    store i32 10, ptr [[I9]], align 4
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK5-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK5-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_21]], align 1
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP13]], ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP14]], ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK5-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP15]], ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK5-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK5-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP16]], i64 [[IDXPROM]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK5-NEXT:    [[TMP19:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK5-NEXT:    [[IDXPROM28:%.*]] = sext i32 [[TMP19]] to i64
// CHECK5-NEXT:    [[ARRAYIDX29:%.*]] = getelementptr inbounds i8, ptr [[TMP18]], i64 [[IDXPROM28]]
// CHECK5-NEXT:    [[TMP20:%.*]] = load i8, ptr [[ARRAYIDX29]], align 1
// CHECK5-NEXT:    [[CONV30:%.*]] = sext i8 [[TMP20]] to i32
// CHECK5-NEXT:    store i32 [[CONV30]], ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK5-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP21]], 0
// CHECK5-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK5-NEXT:    [[CONV32:%.*]] = sext i32 [[DIV]] to i64
// CHECK5-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK5-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK5-NEXT:    [[SUB33:%.*]] = sub i32 [[TMP22]], [[TMP23]]
// CHECK5-NEXT:    [[SUB34:%.*]] = sub i32 [[SUB33]], 1
// CHECK5-NEXT:    [[ADD35:%.*]] = add i32 [[SUB34]], 1
// CHECK5-NEXT:    [[DIV36:%.*]] = udiv i32 [[ADD35]], 1
// CHECK5-NEXT:    [[CONV37:%.*]] = zext i32 [[DIV36]] to i64
// CHECK5-NEXT:    [[MUL38:%.*]] = mul nsw i64 [[CONV32]], [[CONV37]]
// CHECK5-NEXT:    [[SUB39:%.*]] = sub nsw i64 [[MUL38]], 1
// CHECK5-NEXT:    store i64 [[SUB39]], ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK5-NEXT:    store i64 0, ptr [[DOTOMP_LB40]], align 8
// CHECK5-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK5-NEXT:    store i64 [[TMP24]], ptr [[DOTOMP_UB41]], align 8
// CHECK5-NEXT:    store i32 0, ptr [[I42]], align 4
// CHECK5-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK5-NEXT:    store i32 [[TMP25]], ptr [[J]], align 4
// CHECK5-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK5-NEXT:    [[CMP43:%.*]] = icmp slt i32 0, [[TMP26]]
// CHECK5-NEXT:    br i1 [[CMP43]], label [[LAND_LHS_TRUE:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK5:       land.lhs.true:
// CHECK5-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK5-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK5-NEXT:    [[CMP44:%.*]] = icmp slt i32 [[TMP27]], [[TMP28]]
// CHECK5-NEXT:    br i1 [[CMP44]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END]]
// CHECK5:       simd.if.then:
// CHECK5-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_LB40]], align 8
// CHECK5-NEXT:    store i64 [[TMP29]], ptr [[DOTOMP_IV45]], align 8
// CHECK5-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK5-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[TMP30]], i64 8) ]
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND48:%.*]]
// CHECK5:       omp.inner.for.cond48:
// CHECK5-NEXT:    [[TMP31:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9:![0-9]+]]
// CHECK5-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTOMP_UB41]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[CMP49:%.*]] = icmp ule i64 [[TMP31]], [[TMP32]]
// CHECK5-NEXT:    br i1 [[CMP49]], label [[OMP_INNER_FOR_BODY50:%.*]], label [[OMP_INNER_FOR_END83:%.*]]
// CHECK5:       omp.inner.for.body50:
// CHECK5-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[SUB51:%.*]] = sub i32 [[TMP34]], [[TMP35]]
// CHECK5-NEXT:    [[SUB52:%.*]] = sub i32 [[SUB51]], 1
// CHECK5-NEXT:    [[ADD53:%.*]] = add i32 [[SUB52]], 1
// CHECK5-NEXT:    [[DIV54:%.*]] = udiv i32 [[ADD53]], 1
// CHECK5-NEXT:    [[MUL55:%.*]] = mul i32 1, [[DIV54]]
// CHECK5-NEXT:    [[CONV56:%.*]] = zext i32 [[MUL55]] to i64
// CHECK5-NEXT:    [[DIV57:%.*]] = sdiv i64 [[TMP33]], [[CONV56]]
// CHECK5-NEXT:    [[MUL58:%.*]] = mul nsw i64 [[DIV57]], 1
// CHECK5-NEXT:    [[ADD59:%.*]] = add nsw i64 0, [[MUL58]]
// CHECK5-NEXT:    [[CONV60:%.*]] = trunc i64 [[ADD59]] to i32
// CHECK5-NEXT:    store i32 [[CONV60]], ptr [[I46]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[CONV61:%.*]] = sext i32 [[TMP36]] to i64
// CHECK5-NEXT:    [[TMP37:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP38:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[SUB62:%.*]] = sub i32 [[TMP39]], [[TMP40]]
// CHECK5-NEXT:    [[SUB63:%.*]] = sub i32 [[SUB62]], 1
// CHECK5-NEXT:    [[ADD64:%.*]] = add i32 [[SUB63]], 1
// CHECK5-NEXT:    [[DIV65:%.*]] = udiv i32 [[ADD64]], 1
// CHECK5-NEXT:    [[MUL66:%.*]] = mul i32 1, [[DIV65]]
// CHECK5-NEXT:    [[CONV67:%.*]] = zext i32 [[MUL66]] to i64
// CHECK5-NEXT:    [[DIV68:%.*]] = sdiv i64 [[TMP38]], [[CONV67]]
// CHECK5-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[SUB69:%.*]] = sub i32 [[TMP41]], [[TMP42]]
// CHECK5-NEXT:    [[SUB70:%.*]] = sub i32 [[SUB69]], 1
// CHECK5-NEXT:    [[ADD71:%.*]] = add i32 [[SUB70]], 1
// CHECK5-NEXT:    [[DIV72:%.*]] = udiv i32 [[ADD71]], 1
// CHECK5-NEXT:    [[MUL73:%.*]] = mul i32 1, [[DIV72]]
// CHECK5-NEXT:    [[CONV74:%.*]] = zext i32 [[MUL73]] to i64
// CHECK5-NEXT:    [[MUL75:%.*]] = mul nsw i64 [[DIV68]], [[CONV74]]
// CHECK5-NEXT:    [[SUB76:%.*]] = sub nsw i64 [[TMP37]], [[MUL75]]
// CHECK5-NEXT:    [[MUL77:%.*]] = mul nsw i64 [[SUB76]], 1
// CHECK5-NEXT:    [[ADD78:%.*]] = add nsw i64 [[CONV61]], [[MUL77]]
// CHECK5-NEXT:    [[CONV79:%.*]] = trunc i64 [[ADD78]] to i32
// CHECK5-NEXT:    store i32 [[CONV79]], ptr [[J47]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE80:%.*]]
// CHECK5:       omp.body.continue80:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC81:%.*]]
// CHECK5:       omp.inner.for.inc81:
// CHECK5-NEXT:    [[TMP43:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    [[ADD82:%.*]] = add nsw i64 [[TMP43]], 1
// CHECK5-NEXT:    store i64 [[ADD82]], ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND48]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK5:       omp.inner.for.end83:
// CHECK5-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK5-NEXT:    [[SUB84:%.*]] = sub nsw i32 [[TMP44]], 0
// CHECK5-NEXT:    [[DIV85:%.*]] = sdiv i32 [[SUB84]], 1
// CHECK5-NEXT:    [[MUL86:%.*]] = mul nsw i32 [[DIV85]], 1
// CHECK5-NEXT:    [[ADD87:%.*]] = add nsw i32 0, [[MUL86]]
// CHECK5-NEXT:    store i32 [[ADD87]], ptr [[I20]], align 4
// CHECK5-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK5-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK5-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK5-NEXT:    [[SUB88:%.*]] = sub i32 [[TMP46]], [[TMP47]]
// CHECK5-NEXT:    [[SUB89:%.*]] = sub i32 [[SUB88]], 1
// CHECK5-NEXT:    [[ADD90:%.*]] = add i32 [[SUB89]], 1
// CHECK5-NEXT:    [[DIV91:%.*]] = udiv i32 [[ADD90]], 1
// CHECK5-NEXT:    [[MUL92:%.*]] = mul i32 [[DIV91]], 1
// CHECK5-NEXT:    [[ADD93:%.*]] = add i32 [[TMP45]], [[MUL92]]
// CHECK5-NEXT:    store i32 [[ADD93]], ptr [[J47]], align 4
// CHECK5-NEXT:    br label [[SIMD_IF_END]]
// CHECK5:       simd.if.end:
// CHECK5-NEXT:    [[TMP48:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK5-NEXT:    ret i32 [[TMP48]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK5-SAME: () #[[ATTR2:[0-9]+]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3:[0-9]+]] align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK5-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3]] align 2 {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[_TMP9:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP14:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK5-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK5-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK5-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK5-NEXT:    store ptr [[TMP]], ptr [[_TMP2]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK5-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK5-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK5-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK5-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK5-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK5-NEXT:    store i32 [[SUB5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK5-NEXT:    [[CONV:%.*]] = sext i32 [[TMP3]] to i64
// CHECK5-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_UB]], align 8
// CHECK5-NEXT:    store ptr [[A]], ptr [[_TMP6]], align 8
// CHECK5-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK5-NEXT:    store i32 0, ptr [[TMP4]], align 4
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK5-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK5-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK5:       simd.if.then:
// CHECK5-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK5-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP6]] to i32
// CHECK5-NEXT:    store i32 [[CONV7]], ptr [[DOTOMP_IV]], align 4
// CHECK5-NEXT:    store ptr [[A8]], ptr [[_TMP9]], align 8
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK5:       omp.inner.for.cond:
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12:![0-9]+]]
// CHECK5-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP7]] to i64
// CHECK5-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP12]]
// CHECK5-NEXT:    [[CMP11:%.*]] = icmp ule i64 [[CONV10]], [[TMP8]]
// CHECK5-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK5:       omp.inner.for.body:
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK5-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK5-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP9]], align 8, !llvm.access.group [[ACC_GRP12]]
// CHECK5-NEXT:    store i32 [[ADD]], ptr [[TMP10]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK5-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK5:       omp.body.continue:
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK5:       omp.inner.for.inc:
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK5-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK5-NEXT:    store i32 [[ADD12]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK5-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK5:       omp.inner.for.end:
// CHECK5-NEXT:    [[A13:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    store ptr [[A13]], ptr [[_TMP14]], align 8
// CHECK5-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK5-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK5-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK5-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[DIV16]], 1
// CHECK5-NEXT:    [[ADD18:%.*]] = add nsw i32 0, [[MUL17]]
// CHECK5-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP14]], align 8
// CHECK5-NEXT:    store i32 [[ADD18]], ptr [[TMP13]], align 4
// CHECK5-NEXT:    br label [[SIMD_IF_END]]
// CHECK5:       simd.if.end:
// CHECK5-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK5-SAME: () #[[ATTR2]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @__cxx_global_var_init()
// CHECK5-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@main
// CHECK6-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I9:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_21:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP23:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP24:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_25:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_26:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_27:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_31:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_LB40:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_UB41:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[I42:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_IV45:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[I46:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[J47:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK6-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP0]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK6-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK6-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK6-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK6-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP2]] to i64
// CHECK6-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK6-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP3]]
// CHECK6-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK6-NEXT:    store i32 [[ADD2]], ptr [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    store i32 10, ptr [[I]], align 4
// CHECK6-NEXT:    [[TMP6:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP6]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK6-NEXT:    store i64 0, ptr [[DOTOMP_LB5]], align 8
// CHECK6-NEXT:    store i64 9, ptr [[DOTOMP_UB6]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTOMP_LB5]], align 8
// CHECK6-NEXT:    [[CONV8:%.*]] = trunc i64 [[TMP7]] to i32
// CHECK6-NEXT:    store i32 [[CONV8]], ptr [[DOTOMP_IV7]], align 4
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK6:       omp.inner.for.cond10:
// CHECK6-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5:![0-9]+]]
// CHECK6-NEXT:    [[CONV11:%.*]] = sext i32 [[TMP8]] to i64
// CHECK6-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTOMP_UB6]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK6-NEXT:    [[CMP12:%.*]] = icmp ule i64 [[CONV11]], [[TMP9]]
// CHECK6-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY13:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK6:       omp.inner.for.body13:
// CHECK6-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK6-NEXT:    [[MUL14:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK6-NEXT:    [[ADD15:%.*]] = add nsw i32 0, [[MUL14]]
// CHECK6-NEXT:    store i32 [[ADD15]], ptr [[I9]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK6:       omp.body.continue16:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK6:       omp.inner.for.inc17:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK6-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK6-NEXT:    store i32 [[ADD18]], ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK6:       omp.inner.for.end19:
// CHECK6-NEXT:    store i32 10, ptr [[I9]], align 4
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK6-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK6-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_21]], align 1
// CHECK6-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP13]], ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK6-NEXT:    [[TMP14:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP14]], ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK6-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP15]], ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK6-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK6-NEXT:    [[TMP17:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK6-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP16]], i64 [[IDXPROM]]
// CHECK6-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK6-NEXT:    [[TMP19:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK6-NEXT:    [[IDXPROM28:%.*]] = sext i32 [[TMP19]] to i64
// CHECK6-NEXT:    [[ARRAYIDX29:%.*]] = getelementptr inbounds i8, ptr [[TMP18]], i64 [[IDXPROM28]]
// CHECK6-NEXT:    [[TMP20:%.*]] = load i8, ptr [[ARRAYIDX29]], align 1
// CHECK6-NEXT:    [[CONV30:%.*]] = sext i8 [[TMP20]] to i32
// CHECK6-NEXT:    store i32 [[CONV30]], ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK6-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK6-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP21]], 0
// CHECK6-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK6-NEXT:    [[CONV32:%.*]] = sext i32 [[DIV]] to i64
// CHECK6-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK6-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK6-NEXT:    [[SUB33:%.*]] = sub i32 [[TMP22]], [[TMP23]]
// CHECK6-NEXT:    [[SUB34:%.*]] = sub i32 [[SUB33]], 1
// CHECK6-NEXT:    [[ADD35:%.*]] = add i32 [[SUB34]], 1
// CHECK6-NEXT:    [[DIV36:%.*]] = udiv i32 [[ADD35]], 1
// CHECK6-NEXT:    [[CONV37:%.*]] = zext i32 [[DIV36]] to i64
// CHECK6-NEXT:    [[MUL38:%.*]] = mul nsw i64 [[CONV32]], [[CONV37]]
// CHECK6-NEXT:    [[SUB39:%.*]] = sub nsw i64 [[MUL38]], 1
// CHECK6-NEXT:    store i64 [[SUB39]], ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK6-NEXT:    store i64 0, ptr [[DOTOMP_LB40]], align 8
// CHECK6-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK6-NEXT:    store i64 [[TMP24]], ptr [[DOTOMP_UB41]], align 8
// CHECK6-NEXT:    store i32 0, ptr [[I42]], align 4
// CHECK6-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK6-NEXT:    store i32 [[TMP25]], ptr [[J]], align 4
// CHECK6-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK6-NEXT:    [[CMP43:%.*]] = icmp slt i32 0, [[TMP26]]
// CHECK6-NEXT:    br i1 [[CMP43]], label [[LAND_LHS_TRUE:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK6:       land.lhs.true:
// CHECK6-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK6-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK6-NEXT:    [[CMP44:%.*]] = icmp slt i32 [[TMP27]], [[TMP28]]
// CHECK6-NEXT:    br i1 [[CMP44]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END]]
// CHECK6:       simd.if.then:
// CHECK6-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_LB40]], align 8
// CHECK6-NEXT:    store i64 [[TMP29]], ptr [[DOTOMP_IV45]], align 8
// CHECK6-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK6-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[TMP30]], i64 8) ]
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND48:%.*]]
// CHECK6:       omp.inner.for.cond48:
// CHECK6-NEXT:    [[TMP31:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9:![0-9]+]]
// CHECK6-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTOMP_UB41]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[CMP49:%.*]] = icmp ule i64 [[TMP31]], [[TMP32]]
// CHECK6-NEXT:    br i1 [[CMP49]], label [[OMP_INNER_FOR_BODY50:%.*]], label [[OMP_INNER_FOR_END83:%.*]]
// CHECK6:       omp.inner.for.body50:
// CHECK6-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[SUB51:%.*]] = sub i32 [[TMP34]], [[TMP35]]
// CHECK6-NEXT:    [[SUB52:%.*]] = sub i32 [[SUB51]], 1
// CHECK6-NEXT:    [[ADD53:%.*]] = add i32 [[SUB52]], 1
// CHECK6-NEXT:    [[DIV54:%.*]] = udiv i32 [[ADD53]], 1
// CHECK6-NEXT:    [[MUL55:%.*]] = mul i32 1, [[DIV54]]
// CHECK6-NEXT:    [[CONV56:%.*]] = zext i32 [[MUL55]] to i64
// CHECK6-NEXT:    [[DIV57:%.*]] = sdiv i64 [[TMP33]], [[CONV56]]
// CHECK6-NEXT:    [[MUL58:%.*]] = mul nsw i64 [[DIV57]], 1
// CHECK6-NEXT:    [[ADD59:%.*]] = add nsw i64 0, [[MUL58]]
// CHECK6-NEXT:    [[CONV60:%.*]] = trunc i64 [[ADD59]] to i32
// CHECK6-NEXT:    store i32 [[CONV60]], ptr [[I46]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[CONV61:%.*]] = sext i32 [[TMP36]] to i64
// CHECK6-NEXT:    [[TMP37:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP38:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP39:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[SUB62:%.*]] = sub i32 [[TMP39]], [[TMP40]]
// CHECK6-NEXT:    [[SUB63:%.*]] = sub i32 [[SUB62]], 1
// CHECK6-NEXT:    [[ADD64:%.*]] = add i32 [[SUB63]], 1
// CHECK6-NEXT:    [[DIV65:%.*]] = udiv i32 [[ADD64]], 1
// CHECK6-NEXT:    [[MUL66:%.*]] = mul i32 1, [[DIV65]]
// CHECK6-NEXT:    [[CONV67:%.*]] = zext i32 [[MUL66]] to i64
// CHECK6-NEXT:    [[DIV68:%.*]] = sdiv i64 [[TMP38]], [[CONV67]]
// CHECK6-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[SUB69:%.*]] = sub i32 [[TMP41]], [[TMP42]]
// CHECK6-NEXT:    [[SUB70:%.*]] = sub i32 [[SUB69]], 1
// CHECK6-NEXT:    [[ADD71:%.*]] = add i32 [[SUB70]], 1
// CHECK6-NEXT:    [[DIV72:%.*]] = udiv i32 [[ADD71]], 1
// CHECK6-NEXT:    [[MUL73:%.*]] = mul i32 1, [[DIV72]]
// CHECK6-NEXT:    [[CONV74:%.*]] = zext i32 [[MUL73]] to i64
// CHECK6-NEXT:    [[MUL75:%.*]] = mul nsw i64 [[DIV68]], [[CONV74]]
// CHECK6-NEXT:    [[SUB76:%.*]] = sub nsw i64 [[TMP37]], [[MUL75]]
// CHECK6-NEXT:    [[MUL77:%.*]] = mul nsw i64 [[SUB76]], 1
// CHECK6-NEXT:    [[ADD78:%.*]] = add nsw i64 [[CONV61]], [[MUL77]]
// CHECK6-NEXT:    [[CONV79:%.*]] = trunc i64 [[ADD78]] to i32
// CHECK6-NEXT:    store i32 [[CONV79]], ptr [[J47]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE80:%.*]]
// CHECK6:       omp.body.continue80:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC81:%.*]]
// CHECK6:       omp.inner.for.inc81:
// CHECK6-NEXT:    [[TMP43:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    [[ADD82:%.*]] = add nsw i64 [[TMP43]], 1
// CHECK6-NEXT:    store i64 [[ADD82]], ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND48]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK6:       omp.inner.for.end83:
// CHECK6-NEXT:    [[TMP44:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK6-NEXT:    [[SUB84:%.*]] = sub nsw i32 [[TMP44]], 0
// CHECK6-NEXT:    [[DIV85:%.*]] = sdiv i32 [[SUB84]], 1
// CHECK6-NEXT:    [[MUL86:%.*]] = mul nsw i32 [[DIV85]], 1
// CHECK6-NEXT:    [[ADD87:%.*]] = add nsw i32 0, [[MUL86]]
// CHECK6-NEXT:    store i32 [[ADD87]], ptr [[I20]], align 4
// CHECK6-NEXT:    [[TMP45:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK6-NEXT:    [[TMP46:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK6-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK6-NEXT:    [[SUB88:%.*]] = sub i32 [[TMP46]], [[TMP47]]
// CHECK6-NEXT:    [[SUB89:%.*]] = sub i32 [[SUB88]], 1
// CHECK6-NEXT:    [[ADD90:%.*]] = add i32 [[SUB89]], 1
// CHECK6-NEXT:    [[DIV91:%.*]] = udiv i32 [[ADD90]], 1
// CHECK6-NEXT:    [[MUL92:%.*]] = mul i32 [[DIV91]], 1
// CHECK6-NEXT:    [[ADD93:%.*]] = add i32 [[TMP45]], [[MUL92]]
// CHECK6-NEXT:    store i32 [[ADD93]], ptr [[J47]], align 4
// CHECK6-NEXT:    br label [[SIMD_IF_END]]
// CHECK6:       simd.if.end:
// CHECK6-NEXT:    [[TMP48:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK6-NEXT:    ret i32 [[TMP48]]
//
//
// CHECK6-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK6-SAME: () #[[ATTR2:[0-9]+]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK6-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3:[0-9]+]] align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK6-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK6-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK6-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK6-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3]] align 2 {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK6-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK6-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[_TMP9:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[_TMP14:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK6-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK6-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK6-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK6-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK6-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK6-NEXT:    store ptr [[TMP]], ptr [[_TMP2]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK6-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK6-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK6-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK6-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK6-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK6-NEXT:    store i32 [[SUB5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK6-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK6-NEXT:    [[CONV:%.*]] = sext i32 [[TMP3]] to i64
// CHECK6-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_UB]], align 8
// CHECK6-NEXT:    store ptr [[A]], ptr [[_TMP6]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK6-NEXT:    store i32 0, ptr [[TMP4]], align 4
// CHECK6-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK6-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK6-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK6:       simd.if.then:
// CHECK6-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK6-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP6]] to i32
// CHECK6-NEXT:    store i32 [[CONV7]], ptr [[DOTOMP_IV]], align 4
// CHECK6-NEXT:    store ptr [[A8]], ptr [[_TMP9]], align 8
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK6:       omp.inner.for.cond:
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12:![0-9]+]]
// CHECK6-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP7]] to i64
// CHECK6-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP12]]
// CHECK6-NEXT:    [[CMP11:%.*]] = icmp ule i64 [[CONV10]], [[TMP8]]
// CHECK6-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK6:       omp.inner.for.body:
// CHECK6-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK6-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK6-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK6-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP9]], align 8, !llvm.access.group [[ACC_GRP12]]
// CHECK6-NEXT:    store i32 [[ADD]], ptr [[TMP10]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK6-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK6:       omp.body.continue:
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK6:       omp.inner.for.inc:
// CHECK6-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK6-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK6-NEXT:    store i32 [[ADD12]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP12]]
// CHECK6-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// CHECK6:       omp.inner.for.end:
// CHECK6-NEXT:    [[A13:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK6-NEXT:    store ptr [[A13]], ptr [[_TMP14]], align 8
// CHECK6-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK6-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK6-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK6-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[DIV16]], 1
// CHECK6-NEXT:    [[ADD18:%.*]] = add nsw i32 0, [[MUL17]]
// CHECK6-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP14]], align 8
// CHECK6-NEXT:    store i32 [[ADD18]], ptr [[TMP13]], align 4
// CHECK6-NEXT:    br label [[SIMD_IF_END]]
// CHECK6:       simd.if.end:
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK6-SAME: () #[[ATTR2]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    call void @__cxx_global_var_init()
// CHECK6-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@main
// CHECK7-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I9:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_21:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP23:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP24:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_25:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_26:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_27:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_31:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_LB40:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_UB41:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[I42:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_IV45:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[I46:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[J47:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK7-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP0]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK7-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK7-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// CHECK7-NEXT:    [[TMP1:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK7-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK7-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP2]] to i64
// CHECK7-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK7-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP3]]
// CHECK7-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK7-NEXT:    store i32 [[ADD2]], ptr [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    store i32 10, ptr [[I]], align 4
// CHECK7-NEXT:    [[TMP6:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP6]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    store i64 0, ptr [[DOTOMP_LB5]], align 8
// CHECK7-NEXT:    store i64 9, ptr [[DOTOMP_UB6]], align 8
// CHECK7-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTOMP_LB5]], align 8
// CHECK7-NEXT:    [[CONV8:%.*]] = trunc i64 [[TMP7]] to i32
// CHECK7-NEXT:    store i32 [[CONV8]], ptr [[DOTOMP_IV7]], align 4
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK7:       omp.inner.for.cond10:
// CHECK7-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5:![0-9]+]]
// CHECK7-NEXT:    [[CONV11:%.*]] = sext i32 [[TMP8]] to i64
// CHECK7-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTOMP_UB6]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK7-NEXT:    [[CMP12:%.*]] = icmp ule i64 [[CONV11]], [[TMP9]]
// CHECK7-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY13:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK7:       omp.inner.for.body13:
// CHECK7-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK7-NEXT:    [[MUL14:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK7-NEXT:    [[ADD15:%.*]] = add nsw i32 0, [[MUL14]]
// CHECK7-NEXT:    store i32 [[ADD15]], ptr [[I9]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK7:       omp.body.continue16:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK7:       omp.inner.for.inc17:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK7-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK7-NEXT:    store i32 [[ADD18]], ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK7:       omp.inner.for.end19:
// CHECK7-NEXT:    store i32 10, ptr [[I9]], align 4
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK7-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK7-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_21]], align 1
// CHECK7-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP13]], ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK7-NEXT:    [[TMP14:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP14]], ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK7-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP15]], ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK7-NEXT:    [[TMP17:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK7-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP16]], i64 [[IDXPROM]]
// CHECK7-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK7-NEXT:    [[TMP19:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK7-NEXT:    [[IDXPROM28:%.*]] = sext i32 [[TMP19]] to i64
// CHECK7-NEXT:    [[ARRAYIDX29:%.*]] = getelementptr inbounds i8, ptr [[TMP18]], i64 [[IDXPROM28]]
// CHECK7-NEXT:    [[TMP20:%.*]] = load i8, ptr [[ARRAYIDX29]], align 1
// CHECK7-NEXT:    [[CONV30:%.*]] = sext i8 [[TMP20]] to i32
// CHECK7-NEXT:    store i32 [[CONV30]], ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK7-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP21]], 0
// CHECK7-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK7-NEXT:    [[CONV32:%.*]] = sext i32 [[DIV]] to i64
// CHECK7-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[SUB33:%.*]] = sub i32 [[TMP22]], [[TMP23]]
// CHECK7-NEXT:    [[SUB34:%.*]] = sub i32 [[SUB33]], 1
// CHECK7-NEXT:    [[ADD35:%.*]] = add i32 [[SUB34]], 1
// CHECK7-NEXT:    [[DIV36:%.*]] = udiv i32 [[ADD35]], 1
// CHECK7-NEXT:    [[CONV37:%.*]] = zext i32 [[DIV36]] to i64
// CHECK7-NEXT:    [[MUL38:%.*]] = mul nsw i64 [[CONV32]], [[CONV37]]
// CHECK7-NEXT:    [[SUB39:%.*]] = sub nsw i64 [[MUL38]], 1
// CHECK7-NEXT:    store i64 [[SUB39]], ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK7-NEXT:    store i64 0, ptr [[DOTOMP_LB40]], align 8
// CHECK7-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK7-NEXT:    store i64 [[TMP24]], ptr [[DOTOMP_UB41]], align 8
// CHECK7-NEXT:    store i32 0, ptr [[I42]], align 4
// CHECK7-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    store i32 [[TMP25]], ptr [[J]], align 4
// CHECK7-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK7-NEXT:    [[CMP43:%.*]] = icmp slt i32 0, [[TMP26]]
// CHECK7-NEXT:    br i1 [[CMP43]], label [[LAND_LHS_TRUE:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK7:       land.lhs.true:
// CHECK7-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[CMP44:%.*]] = icmp slt i32 [[TMP27]], [[TMP28]]
// CHECK7-NEXT:    br i1 [[CMP44]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END]]
// CHECK7:       simd.if.then:
// CHECK7-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_LB40]], align 8
// CHECK7-NEXT:    store i64 [[TMP29]], ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK7-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[TMP30]], i64 8) ]
// CHECK7-NEXT:    [[TMP31:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_21]], align 1
// CHECK7-NEXT:    [[TOBOOL48:%.*]] = trunc i8 [[TMP31]] to i1
// CHECK7-NEXT:    br i1 [[TOBOOL48]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK7:       omp_if.then:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND49:%.*]]
// CHECK7:       omp.inner.for.cond49:
// CHECK7-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9:![0-9]+]]
// CHECK7-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_UB41]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[CMP50:%.*]] = icmp ule i64 [[TMP32]], [[TMP33]]
// CHECK7-NEXT:    br i1 [[CMP50]], label [[OMP_INNER_FOR_BODY51:%.*]], label [[OMP_INNER_FOR_END84:%.*]]
// CHECK7:       omp.inner.for.body51:
// CHECK7-NEXT:    [[TMP34:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[SUB52:%.*]] = sub i32 [[TMP35]], [[TMP36]]
// CHECK7-NEXT:    [[SUB53:%.*]] = sub i32 [[SUB52]], 1
// CHECK7-NEXT:    [[ADD54:%.*]] = add i32 [[SUB53]], 1
// CHECK7-NEXT:    [[DIV55:%.*]] = udiv i32 [[ADD54]], 1
// CHECK7-NEXT:    [[MUL56:%.*]] = mul i32 1, [[DIV55]]
// CHECK7-NEXT:    [[CONV57:%.*]] = zext i32 [[MUL56]] to i64
// CHECK7-NEXT:    [[DIV58:%.*]] = sdiv i64 [[TMP34]], [[CONV57]]
// CHECK7-NEXT:    [[MUL59:%.*]] = mul nsw i64 [[DIV58]], 1
// CHECK7-NEXT:    [[ADD60:%.*]] = add nsw i64 0, [[MUL59]]
// CHECK7-NEXT:    [[CONV61:%.*]] = trunc i64 [[ADD60]] to i32
// CHECK7-NEXT:    store i32 [[CONV61]], ptr [[I46]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP37:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[CONV62:%.*]] = sext i32 [[TMP37]] to i64
// CHECK7-NEXT:    [[TMP38:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP39:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[SUB63:%.*]] = sub i32 [[TMP40]], [[TMP41]]
// CHECK7-NEXT:    [[SUB64:%.*]] = sub i32 [[SUB63]], 1
// CHECK7-NEXT:    [[ADD65:%.*]] = add i32 [[SUB64]], 1
// CHECK7-NEXT:    [[DIV66:%.*]] = udiv i32 [[ADD65]], 1
// CHECK7-NEXT:    [[MUL67:%.*]] = mul i32 1, [[DIV66]]
// CHECK7-NEXT:    [[CONV68:%.*]] = zext i32 [[MUL67]] to i64
// CHECK7-NEXT:    [[DIV69:%.*]] = sdiv i64 [[TMP39]], [[CONV68]]
// CHECK7-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[SUB70:%.*]] = sub i32 [[TMP42]], [[TMP43]]
// CHECK7-NEXT:    [[SUB71:%.*]] = sub i32 [[SUB70]], 1
// CHECK7-NEXT:    [[ADD72:%.*]] = add i32 [[SUB71]], 1
// CHECK7-NEXT:    [[DIV73:%.*]] = udiv i32 [[ADD72]], 1
// CHECK7-NEXT:    [[MUL74:%.*]] = mul i32 1, [[DIV73]]
// CHECK7-NEXT:    [[CONV75:%.*]] = zext i32 [[MUL74]] to i64
// CHECK7-NEXT:    [[MUL76:%.*]] = mul nsw i64 [[DIV69]], [[CONV75]]
// CHECK7-NEXT:    [[SUB77:%.*]] = sub nsw i64 [[TMP38]], [[MUL76]]
// CHECK7-NEXT:    [[MUL78:%.*]] = mul nsw i64 [[SUB77]], 1
// CHECK7-NEXT:    [[ADD79:%.*]] = add nsw i64 [[CONV62]], [[MUL78]]
// CHECK7-NEXT:    [[CONV80:%.*]] = trunc i64 [[ADD79]] to i32
// CHECK7-NEXT:    store i32 [[CONV80]], ptr [[J47]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE81:%.*]]
// CHECK7:       omp.body.continue81:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC82:%.*]]
// CHECK7:       omp.inner.for.inc82:
// CHECK7-NEXT:    [[TMP44:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    [[ADD83:%.*]] = add nsw i64 [[TMP44]], 1
// CHECK7-NEXT:    store i64 [[ADD83]], ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND49]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK7:       omp.inner.for.end84:
// CHECK7-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK7:       omp_if.else:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND85:%.*]]
// CHECK7:       omp.inner.for.cond85:
// CHECK7-NEXT:    [[TMP45:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    [[TMP46:%.*]] = load i64, ptr [[DOTOMP_UB41]], align 8
// CHECK7-NEXT:    [[CMP86:%.*]] = icmp ule i64 [[TMP45]], [[TMP46]]
// CHECK7-NEXT:    br i1 [[CMP86]], label [[OMP_INNER_FOR_BODY87:%.*]], label [[OMP_INNER_FOR_END120:%.*]]
// CHECK7:       omp.inner.for.body87:
// CHECK7-NEXT:    [[TMP47:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[SUB88:%.*]] = sub i32 [[TMP48]], [[TMP49]]
// CHECK7-NEXT:    [[SUB89:%.*]] = sub i32 [[SUB88]], 1
// CHECK7-NEXT:    [[ADD90:%.*]] = add i32 [[SUB89]], 1
// CHECK7-NEXT:    [[DIV91:%.*]] = udiv i32 [[ADD90]], 1
// CHECK7-NEXT:    [[MUL92:%.*]] = mul i32 1, [[DIV91]]
// CHECK7-NEXT:    [[CONV93:%.*]] = zext i32 [[MUL92]] to i64
// CHECK7-NEXT:    [[DIV94:%.*]] = sdiv i64 [[TMP47]], [[CONV93]]
// CHECK7-NEXT:    [[MUL95:%.*]] = mul nsw i64 [[DIV94]], 1
// CHECK7-NEXT:    [[ADD96:%.*]] = add nsw i64 0, [[MUL95]]
// CHECK7-NEXT:    [[CONV97:%.*]] = trunc i64 [[ADD96]] to i32
// CHECK7-NEXT:    store i32 [[CONV97]], ptr [[I46]], align 4
// CHECK7-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[CONV98:%.*]] = sext i32 [[TMP50]] to i64
// CHECK7-NEXT:    [[TMP51:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    [[TMP52:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    [[TMP53:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[TMP54:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[SUB99:%.*]] = sub i32 [[TMP53]], [[TMP54]]
// CHECK7-NEXT:    [[SUB100:%.*]] = sub i32 [[SUB99]], 1
// CHECK7-NEXT:    [[ADD101:%.*]] = add i32 [[SUB100]], 1
// CHECK7-NEXT:    [[DIV102:%.*]] = udiv i32 [[ADD101]], 1
// CHECK7-NEXT:    [[MUL103:%.*]] = mul i32 1, [[DIV102]]
// CHECK7-NEXT:    [[CONV104:%.*]] = zext i32 [[MUL103]] to i64
// CHECK7-NEXT:    [[DIV105:%.*]] = sdiv i64 [[TMP52]], [[CONV104]]
// CHECK7-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[SUB106:%.*]] = sub i32 [[TMP55]], [[TMP56]]
// CHECK7-NEXT:    [[SUB107:%.*]] = sub i32 [[SUB106]], 1
// CHECK7-NEXT:    [[ADD108:%.*]] = add i32 [[SUB107]], 1
// CHECK7-NEXT:    [[DIV109:%.*]] = udiv i32 [[ADD108]], 1
// CHECK7-NEXT:    [[MUL110:%.*]] = mul i32 1, [[DIV109]]
// CHECK7-NEXT:    [[CONV111:%.*]] = zext i32 [[MUL110]] to i64
// CHECK7-NEXT:    [[MUL112:%.*]] = mul nsw i64 [[DIV105]], [[CONV111]]
// CHECK7-NEXT:    [[SUB113:%.*]] = sub nsw i64 [[TMP51]], [[MUL112]]
// CHECK7-NEXT:    [[MUL114:%.*]] = mul nsw i64 [[SUB113]], 1
// CHECK7-NEXT:    [[ADD115:%.*]] = add nsw i64 [[CONV98]], [[MUL114]]
// CHECK7-NEXT:    [[CONV116:%.*]] = trunc i64 [[ADD115]] to i32
// CHECK7-NEXT:    store i32 [[CONV116]], ptr [[J47]], align 4
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE117:%.*]]
// CHECK7:       omp.body.continue117:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC118:%.*]]
// CHECK7:       omp.inner.for.inc118:
// CHECK7-NEXT:    [[TMP57:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    [[ADD119:%.*]] = add nsw i64 [[TMP57]], 1
// CHECK7-NEXT:    store i64 [[ADD119]], ptr [[DOTOMP_IV45]], align 8
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND85]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK7:       omp.inner.for.end120:
// CHECK7-NEXT:    br label [[OMP_IF_END]]
// CHECK7:       omp_if.end:
// CHECK7-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK7-NEXT:    [[SUB121:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK7-NEXT:    [[DIV122:%.*]] = sdiv i32 [[SUB121]], 1
// CHECK7-NEXT:    [[MUL123:%.*]] = mul nsw i32 [[DIV122]], 1
// CHECK7-NEXT:    [[ADD124:%.*]] = add nsw i32 0, [[MUL123]]
// CHECK7-NEXT:    store i32 [[ADD124]], ptr [[I20]], align 4
// CHECK7-NEXT:    [[TMP59:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK7-NEXT:    [[TMP61:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK7-NEXT:    [[SUB125:%.*]] = sub i32 [[TMP60]], [[TMP61]]
// CHECK7-NEXT:    [[SUB126:%.*]] = sub i32 [[SUB125]], 1
// CHECK7-NEXT:    [[ADD127:%.*]] = add i32 [[SUB126]], 1
// CHECK7-NEXT:    [[DIV128:%.*]] = udiv i32 [[ADD127]], 1
// CHECK7-NEXT:    [[MUL129:%.*]] = mul i32 [[DIV128]], 1
// CHECK7-NEXT:    [[ADD130:%.*]] = add i32 [[TMP59]], [[MUL129]]
// CHECK7-NEXT:    store i32 [[ADD130]], ptr [[J47]], align 4
// CHECK7-NEXT:    br label [[SIMD_IF_END]]
// CHECK7:       simd.if.end:
// CHECK7-NEXT:    [[TMP62:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK7-NEXT:    ret i32 [[TMP62]]
//
//
// CHECK7-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK7-SAME: () #[[ATTR2:[0-9]+]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK7-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3:[0-9]+]] align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK7-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK7-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK7-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3]] align 2 {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK7-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK7-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK7-NEXT:    [[_TMP9:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    [[_TMP14:%.*]] = alloca ptr, align 8
// CHECK7-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK7-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK7-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK7-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK7-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK7-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK7-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK7-NEXT:    store ptr [[TMP]], ptr [[_TMP2]], align 8
// CHECK7-NEXT:    [[TMP1:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK7-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK7-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK7-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK7-NEXT:    store i32 [[SUB5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK7-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK7-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK7-NEXT:    [[CONV:%.*]] = sext i32 [[TMP3]] to i64
// CHECK7-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_UB]], align 8
// CHECK7-NEXT:    store ptr [[A]], ptr [[_TMP6]], align 8
// CHECK7-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK7-NEXT:    store i32 0, ptr [[TMP4]], align 4
// CHECK7-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK7-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK7:       simd.if.then:
// CHECK7-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK7-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP6]] to i32
// CHECK7-NEXT:    store i32 [[CONV7]], ptr [[DOTOMP_IV]], align 4
// CHECK7-NEXT:    store ptr [[A8]], ptr [[_TMP9]], align 8
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK7:       omp.inner.for.cond:
// CHECK7-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14:![0-9]+]]
// CHECK7-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP7]] to i64
// CHECK7-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP14]]
// CHECK7-NEXT:    [[CMP11:%.*]] = icmp ule i64 [[CONV10]], [[TMP8]]
// CHECK7-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK7:       omp.inner.for.body:
// CHECK7-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK7-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK7-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK7-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP9]], align 8, !llvm.access.group [[ACC_GRP14]]
// CHECK7-NEXT:    store i32 [[ADD]], ptr [[TMP10]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK7-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK7:       omp.body.continue:
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK7:       omp.inner.for.inc:
// CHECK7-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK7-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK7-NEXT:    store i32 [[ADD12]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK7-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK7:       omp.inner.for.end:
// CHECK7-NEXT:    [[A13:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK7-NEXT:    store ptr [[A13]], ptr [[_TMP14]], align 8
// CHECK7-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK7-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK7-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK7-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[DIV16]], 1
// CHECK7-NEXT:    [[ADD18:%.*]] = add nsw i32 0, [[MUL17]]
// CHECK7-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP14]], align 8
// CHECK7-NEXT:    store i32 [[ADD18]], ptr [[TMP13]], align 4
// CHECK7-NEXT:    br label [[SIMD_IF_END]]
// CHECK7:       simd.if.end:
// CHECK7-NEXT:    ret void
//
//
// CHECK7-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK7-SAME: () #[[ATTR2]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK7-NEXT:  entry:
// CHECK7-NEXT:    call void @__cxx_global_var_init()
// CHECK7-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@main
// CHECK8-SAME: (i32 noundef [[ARGC:%.*]], ptr noundef [[ARGV:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[ARGC_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[ARGV_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP4:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB5:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_UB6:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_IV7:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I9:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I20:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_21:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_22:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP23:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP24:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_25:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_26:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_27:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_31:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_LB40:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_UB41:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[I42:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[J:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IV45:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[I46:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[J47:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK8-NEXT:    store i32 [[ARGC]], ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    store ptr [[ARGV]], ptr [[ARGV_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP0]], ptr [[DOTCAPTURE_EXPR_]], align 4
// CHECK8-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK8-NEXT:    store i64 9, ptr [[DOTOMP_UB]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK8-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK8-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[CONV1:%.*]] = sext i32 [[TMP2]] to i64
// CHECK8-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8
// CHECK8-NEXT:    [[CMP:%.*]] = icmp ule i64 [[CONV1]], [[TMP3]]
// CHECK8-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP4]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], ptr [[I]], align 4
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP5]], 1
// CHECK8-NEXT:    store i32 [[ADD2]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP2:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    store i32 10, ptr [[I]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP6]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK8-NEXT:    store i64 0, ptr [[DOTOMP_LB5]], align 8
// CHECK8-NEXT:    store i64 9, ptr [[DOTOMP_UB6]], align 8
// CHECK8-NEXT:    [[TMP7:%.*]] = load i64, ptr [[DOTOMP_LB5]], align 8
// CHECK8-NEXT:    [[CONV8:%.*]] = trunc i64 [[TMP7]] to i32
// CHECK8-NEXT:    store i32 [[CONV8]], ptr [[DOTOMP_IV7]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND10:%.*]]
// CHECK8:       omp.inner.for.cond10:
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5:![0-9]+]]
// CHECK8-NEXT:    [[CONV11:%.*]] = sext i32 [[TMP8]] to i64
// CHECK8-NEXT:    [[TMP9:%.*]] = load i64, ptr [[DOTOMP_UB6]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[CMP12:%.*]] = icmp ule i64 [[CONV11]], [[TMP9]]
// CHECK8-NEXT:    br i1 [[CMP12]], label [[OMP_INNER_FOR_BODY13:%.*]], label [[OMP_INNER_FOR_END19:%.*]]
// CHECK8:       omp.inner.for.body13:
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[MUL14:%.*]] = mul nsw i32 [[TMP10]], 1
// CHECK8-NEXT:    [[ADD15:%.*]] = add nsw i32 0, [[MUL14]]
// CHECK8-NEXT:    store i32 [[ADD15]], ptr [[I9]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE16:%.*]]
// CHECK8:       omp.body.continue16:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC17:%.*]]
// CHECK8:       omp.inner.for.inc17:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[ADD18:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK8-NEXT:    store i32 [[ADD18]], ptr [[DOTOMP_IV7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND10]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK8:       omp.inner.for.end19:
// CHECK8-NEXT:    store i32 10, ptr [[I9]], align 4
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP12]], 0
// CHECK8-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK8-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_21]], align 1
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP13]], ptr [[DOTCAPTURE_EXPR_22]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP14]], ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP15]], ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP17]] to i64
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds ptr, ptr [[TMP16]], i64 [[IDXPROM]]
// CHECK8-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[ARRAYIDX]], align 8
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, ptr [[ARGC_ADDR]], align 4
// CHECK8-NEXT:    [[IDXPROM28:%.*]] = sext i32 [[TMP19]] to i64
// CHECK8-NEXT:    [[ARRAYIDX29:%.*]] = getelementptr inbounds i8, ptr [[TMP18]], i64 [[IDXPROM28]]
// CHECK8-NEXT:    [[TMP20:%.*]] = load i8, ptr [[ARRAYIDX29]], align 1
// CHECK8-NEXT:    [[CONV30:%.*]] = sext i8 [[TMP20]] to i32
// CHECK8-NEXT:    store i32 [[CONV30]], ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK8-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP21]], 0
// CHECK8-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK8-NEXT:    [[CONV32:%.*]] = sext i32 [[DIV]] to i64
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[SUB33:%.*]] = sub i32 [[TMP22]], [[TMP23]]
// CHECK8-NEXT:    [[SUB34:%.*]] = sub i32 [[SUB33]], 1
// CHECK8-NEXT:    [[ADD35:%.*]] = add i32 [[SUB34]], 1
// CHECK8-NEXT:    [[DIV36:%.*]] = udiv i32 [[ADD35]], 1
// CHECK8-NEXT:    [[CONV37:%.*]] = zext i32 [[DIV36]] to i64
// CHECK8-NEXT:    [[MUL38:%.*]] = mul nsw i64 [[CONV32]], [[CONV37]]
// CHECK8-NEXT:    [[SUB39:%.*]] = sub nsw i64 [[MUL38]], 1
// CHECK8-NEXT:    store i64 [[SUB39]], ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK8-NEXT:    store i64 0, ptr [[DOTOMP_LB40]], align 8
// CHECK8-NEXT:    [[TMP24:%.*]] = load i64, ptr [[DOTCAPTURE_EXPR_31]], align 8
// CHECK8-NEXT:    store i64 [[TMP24]], ptr [[DOTOMP_UB41]], align 8
// CHECK8-NEXT:    store i32 0, ptr [[I42]], align 4
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    store i32 [[TMP25]], ptr [[J]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK8-NEXT:    [[CMP43:%.*]] = icmp slt i32 0, [[TMP26]]
// CHECK8-NEXT:    br i1 [[CMP43]], label [[LAND_LHS_TRUE:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK8:       land.lhs.true:
// CHECK8-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[CMP44:%.*]] = icmp slt i32 [[TMP27]], [[TMP28]]
// CHECK8-NEXT:    br i1 [[CMP44]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END]]
// CHECK8:       simd.if.then:
// CHECK8-NEXT:    [[TMP29:%.*]] = load i64, ptr [[DOTOMP_LB40]], align 8
// CHECK8-NEXT:    store i64 [[TMP29]], ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[ARGV_ADDR]], align 8
// CHECK8-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[TMP30]], i64 8) ]
// CHECK8-NEXT:    [[TMP31:%.*]] = load i8, ptr [[DOTCAPTURE_EXPR_21]], align 1
// CHECK8-NEXT:    [[TOBOOL48:%.*]] = trunc i8 [[TMP31]] to i1
// CHECK8-NEXT:    br i1 [[TOBOOL48]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_ELSE:%.*]]
// CHECK8:       omp_if.then:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND49:%.*]]
// CHECK8:       omp.inner.for.cond49:
// CHECK8-NEXT:    [[TMP32:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9:![0-9]+]]
// CHECK8-NEXT:    [[TMP33:%.*]] = load i64, ptr [[DOTOMP_UB41]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[CMP50:%.*]] = icmp ule i64 [[TMP32]], [[TMP33]]
// CHECK8-NEXT:    br i1 [[CMP50]], label [[OMP_INNER_FOR_BODY51:%.*]], label [[OMP_INNER_FOR_END84:%.*]]
// CHECK8:       omp.inner.for.body51:
// CHECK8-NEXT:    [[TMP34:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP35:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[SUB52:%.*]] = sub i32 [[TMP35]], [[TMP36]]
// CHECK8-NEXT:    [[SUB53:%.*]] = sub i32 [[SUB52]], 1
// CHECK8-NEXT:    [[ADD54:%.*]] = add i32 [[SUB53]], 1
// CHECK8-NEXT:    [[DIV55:%.*]] = udiv i32 [[ADD54]], 1
// CHECK8-NEXT:    [[MUL56:%.*]] = mul i32 1, [[DIV55]]
// CHECK8-NEXT:    [[CONV57:%.*]] = zext i32 [[MUL56]] to i64
// CHECK8-NEXT:    [[DIV58:%.*]] = sdiv i64 [[TMP34]], [[CONV57]]
// CHECK8-NEXT:    [[MUL59:%.*]] = mul nsw i64 [[DIV58]], 1
// CHECK8-NEXT:    [[ADD60:%.*]] = add nsw i64 0, [[MUL59]]
// CHECK8-NEXT:    [[CONV61:%.*]] = trunc i64 [[ADD60]] to i32
// CHECK8-NEXT:    store i32 [[CONV61]], ptr [[I46]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP37:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[CONV62:%.*]] = sext i32 [[TMP37]] to i64
// CHECK8-NEXT:    [[TMP38:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP39:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[SUB63:%.*]] = sub i32 [[TMP40]], [[TMP41]]
// CHECK8-NEXT:    [[SUB64:%.*]] = sub i32 [[SUB63]], 1
// CHECK8-NEXT:    [[ADD65:%.*]] = add i32 [[SUB64]], 1
// CHECK8-NEXT:    [[DIV66:%.*]] = udiv i32 [[ADD65]], 1
// CHECK8-NEXT:    [[MUL67:%.*]] = mul i32 1, [[DIV66]]
// CHECK8-NEXT:    [[CONV68:%.*]] = zext i32 [[MUL67]] to i64
// CHECK8-NEXT:    [[DIV69:%.*]] = sdiv i64 [[TMP39]], [[CONV68]]
// CHECK8-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[SUB70:%.*]] = sub i32 [[TMP42]], [[TMP43]]
// CHECK8-NEXT:    [[SUB71:%.*]] = sub i32 [[SUB70]], 1
// CHECK8-NEXT:    [[ADD72:%.*]] = add i32 [[SUB71]], 1
// CHECK8-NEXT:    [[DIV73:%.*]] = udiv i32 [[ADD72]], 1
// CHECK8-NEXT:    [[MUL74:%.*]] = mul i32 1, [[DIV73]]
// CHECK8-NEXT:    [[CONV75:%.*]] = zext i32 [[MUL74]] to i64
// CHECK8-NEXT:    [[MUL76:%.*]] = mul nsw i64 [[DIV69]], [[CONV75]]
// CHECK8-NEXT:    [[SUB77:%.*]] = sub nsw i64 [[TMP38]], [[MUL76]]
// CHECK8-NEXT:    [[MUL78:%.*]] = mul nsw i64 [[SUB77]], 1
// CHECK8-NEXT:    [[ADD79:%.*]] = add nsw i64 [[CONV62]], [[MUL78]]
// CHECK8-NEXT:    [[CONV80:%.*]] = trunc i64 [[ADD79]] to i32
// CHECK8-NEXT:    store i32 [[CONV80]], ptr [[J47]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE81:%.*]]
// CHECK8:       omp.body.continue81:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC82:%.*]]
// CHECK8:       omp.inner.for.inc82:
// CHECK8-NEXT:    [[TMP44:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[ADD83:%.*]] = add nsw i64 [[TMP44]], 1
// CHECK8-NEXT:    store i64 [[ADD83]], ptr [[DOTOMP_IV45]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND49]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK8:       omp.inner.for.end84:
// CHECK8-NEXT:    br label [[OMP_IF_END:%.*]]
// CHECK8:       omp_if.else:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND85:%.*]]
// CHECK8:       omp.inner.for.cond85:
// CHECK8-NEXT:    [[TMP45:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    [[TMP46:%.*]] = load i64, ptr [[DOTOMP_UB41]], align 8
// CHECK8-NEXT:    [[CMP86:%.*]] = icmp ule i64 [[TMP45]], [[TMP46]]
// CHECK8-NEXT:    br i1 [[CMP86]], label [[OMP_INNER_FOR_BODY87:%.*]], label [[OMP_INNER_FOR_END120:%.*]]
// CHECK8:       omp.inner.for.body87:
// CHECK8-NEXT:    [[TMP47:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[SUB88:%.*]] = sub i32 [[TMP48]], [[TMP49]]
// CHECK8-NEXT:    [[SUB89:%.*]] = sub i32 [[SUB88]], 1
// CHECK8-NEXT:    [[ADD90:%.*]] = add i32 [[SUB89]], 1
// CHECK8-NEXT:    [[DIV91:%.*]] = udiv i32 [[ADD90]], 1
// CHECK8-NEXT:    [[MUL92:%.*]] = mul i32 1, [[DIV91]]
// CHECK8-NEXT:    [[CONV93:%.*]] = zext i32 [[MUL92]] to i64
// CHECK8-NEXT:    [[DIV94:%.*]] = sdiv i64 [[TMP47]], [[CONV93]]
// CHECK8-NEXT:    [[MUL95:%.*]] = mul nsw i64 [[DIV94]], 1
// CHECK8-NEXT:    [[ADD96:%.*]] = add nsw i64 0, [[MUL95]]
// CHECK8-NEXT:    [[CONV97:%.*]] = trunc i64 [[ADD96]] to i32
// CHECK8-NEXT:    store i32 [[CONV97]], ptr [[I46]], align 4
// CHECK8-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[CONV98:%.*]] = sext i32 [[TMP50]] to i64
// CHECK8-NEXT:    [[TMP51:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    [[TMP52:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    [[TMP53:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[TMP54:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[SUB99:%.*]] = sub i32 [[TMP53]], [[TMP54]]
// CHECK8-NEXT:    [[SUB100:%.*]] = sub i32 [[SUB99]], 1
// CHECK8-NEXT:    [[ADD101:%.*]] = add i32 [[SUB100]], 1
// CHECK8-NEXT:    [[DIV102:%.*]] = udiv i32 [[ADD101]], 1
// CHECK8-NEXT:    [[MUL103:%.*]] = mul i32 1, [[DIV102]]
// CHECK8-NEXT:    [[CONV104:%.*]] = zext i32 [[MUL103]] to i64
// CHECK8-NEXT:    [[DIV105:%.*]] = sdiv i64 [[TMP52]], [[CONV104]]
// CHECK8-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[TMP56:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[SUB106:%.*]] = sub i32 [[TMP55]], [[TMP56]]
// CHECK8-NEXT:    [[SUB107:%.*]] = sub i32 [[SUB106]], 1
// CHECK8-NEXT:    [[ADD108:%.*]] = add i32 [[SUB107]], 1
// CHECK8-NEXT:    [[DIV109:%.*]] = udiv i32 [[ADD108]], 1
// CHECK8-NEXT:    [[MUL110:%.*]] = mul i32 1, [[DIV109]]
// CHECK8-NEXT:    [[CONV111:%.*]] = zext i32 [[MUL110]] to i64
// CHECK8-NEXT:    [[MUL112:%.*]] = mul nsw i64 [[DIV105]], [[CONV111]]
// CHECK8-NEXT:    [[SUB113:%.*]] = sub nsw i64 [[TMP51]], [[MUL112]]
// CHECK8-NEXT:    [[MUL114:%.*]] = mul nsw i64 [[SUB113]], 1
// CHECK8-NEXT:    [[ADD115:%.*]] = add nsw i64 [[CONV98]], [[MUL114]]
// CHECK8-NEXT:    [[CONV116:%.*]] = trunc i64 [[ADD115]] to i32
// CHECK8-NEXT:    store i32 [[CONV116]], ptr [[J47]], align 4
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE117:%.*]]
// CHECK8:       omp.body.continue117:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC118:%.*]]
// CHECK8:       omp.inner.for.inc118:
// CHECK8-NEXT:    [[TMP57:%.*]] = load i64, ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    [[ADD119:%.*]] = add nsw i64 [[TMP57]], 1
// CHECK8-NEXT:    store i64 [[ADD119]], ptr [[DOTOMP_IV45]], align 8
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND85]], !llvm.loop [[LOOP12:![0-9]+]]
// CHECK8:       omp.inner.for.end120:
// CHECK8-NEXT:    br label [[OMP_IF_END]]
// CHECK8:       omp_if.end:
// CHECK8-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_25]], align 4
// CHECK8-NEXT:    [[SUB121:%.*]] = sub nsw i32 [[TMP58]], 0
// CHECK8-NEXT:    [[DIV122:%.*]] = sdiv i32 [[SUB121]], 1
// CHECK8-NEXT:    [[MUL123:%.*]] = mul nsw i32 [[DIV122]], 1
// CHECK8-NEXT:    [[ADD124:%.*]] = add nsw i32 0, [[MUL123]]
// CHECK8-NEXT:    store i32 [[ADD124]], ptr [[I20]], align 4
// CHECK8-NEXT:    [[TMP59:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_27]], align 4
// CHECK8-NEXT:    [[TMP61:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_26]], align 4
// CHECK8-NEXT:    [[SUB125:%.*]] = sub i32 [[TMP60]], [[TMP61]]
// CHECK8-NEXT:    [[SUB126:%.*]] = sub i32 [[SUB125]], 1
// CHECK8-NEXT:    [[ADD127:%.*]] = add i32 [[SUB126]], 1
// CHECK8-NEXT:    [[DIV128:%.*]] = udiv i32 [[ADD127]], 1
// CHECK8-NEXT:    [[MUL129:%.*]] = mul i32 [[DIV128]], 1
// CHECK8-NEXT:    [[ADD130:%.*]] = add i32 [[TMP59]], [[MUL129]]
// CHECK8-NEXT:    store i32 [[ADD130]], ptr [[J47]], align 4
// CHECK8-NEXT:    br label [[SIMD_IF_END]]
// CHECK8:       simd.if.end:
// CHECK8-NEXT:    [[TMP62:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK8-NEXT:    ret i32 [[TMP62]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK8-SAME: () #[[ATTR2:[0-9]+]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    call void @_ZN1SC1Ei(ptr noundef nonnull align 4 dereferenceable(4) @s, i32 noundef 1)
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SC1Ei
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3:[0-9]+]] align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SC2Ei
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[C:%.*]]) unnamed_addr #[[ATTR3]] align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[C_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_:%.*]] = alloca i8, align 1
// CHECK8-NEXT:    [[TMP:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_3:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTCAPTURE_EXPR_4:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[A:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[A8:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP9:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[_TMP14:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    store i32 [[C]], ptr [[C_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK8-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
// CHECK8-NEXT:    [[FROMBOOL:%.*]] = zext i1 [[TOBOOL]] to i8
// CHECK8-NEXT:    store i8 [[FROMBOOL]], ptr [[DOTCAPTURE_EXPR_]], align 1
// CHECK8-NEXT:    store ptr [[TMP]], ptr [[_TMP2]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, ptr [[C_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP1]], ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK8-NEXT:    [[SUB:%.*]] = sub nsw i32 [[TMP2]], 0
// CHECK8-NEXT:    [[DIV:%.*]] = sdiv i32 [[SUB]], 1
// CHECK8-NEXT:    [[SUB5:%.*]] = sub nsw i32 [[DIV]], 1
// CHECK8-NEXT:    store i32 [[SUB5]], ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK8-NEXT:    store i64 0, ptr [[DOTOMP_LB]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_4]], align 4
// CHECK8-NEXT:    [[CONV:%.*]] = sext i32 [[TMP3]] to i64
// CHECK8-NEXT:    store i64 [[CONV]], ptr [[DOTOMP_UB]], align 8
// CHECK8-NEXT:    store ptr [[A]], ptr [[_TMP6]], align 8
// CHECK8-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK8-NEXT:    store i32 0, ptr [[TMP4]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp slt i32 0, [[TMP5]]
// CHECK8-NEXT:    br i1 [[CMP]], label [[SIMD_IF_THEN:%.*]], label [[SIMD_IF_END:%.*]]
// CHECK8:       simd.if.then:
// CHECK8-NEXT:    [[TMP6:%.*]] = load i64, ptr [[DOTOMP_LB]], align 8
// CHECK8-NEXT:    [[CONV7:%.*]] = trunc i64 [[TMP6]] to i32
// CHECK8-NEXT:    store i32 [[CONV7]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    store ptr [[A8]], ptr [[_TMP9]], align 8
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14:![0-9]+]]
// CHECK8-NEXT:    [[CONV10:%.*]] = sext i32 [[TMP7]] to i64
// CHECK8-NEXT:    [[TMP8:%.*]] = load i64, ptr [[DOTOMP_UB]], align 8, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[CMP11:%.*]] = icmp ule i64 [[CONV10]], [[TMP8]]
// CHECK8-NEXT:    br i1 [[CMP11]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP9]], align 8, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    store i32 [[ADD]], ptr [[TMP10]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[ADD12:%.*]] = add nsw i32 [[TMP11]], 1
// CHECK8-NEXT:    store i32 [[ADD12]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    [[A13:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    store ptr [[A13]], ptr [[_TMP14]], align 8
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTCAPTURE_EXPR_3]], align 4
// CHECK8-NEXT:    [[SUB15:%.*]] = sub nsw i32 [[TMP12]], 0
// CHECK8-NEXT:    [[DIV16:%.*]] = sdiv i32 [[SUB15]], 1
// CHECK8-NEXT:    [[MUL17:%.*]] = mul nsw i32 [[DIV16]], 1
// CHECK8-NEXT:    [[ADD18:%.*]] = add nsw i32 0, [[MUL17]]
// CHECK8-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP14]], align 8
// CHECK8-NEXT:    store i32 [[ADD18]], ptr [[TMP13]], align 4
// CHECK8-NEXT:    br label [[SIMD_IF_END]]
// CHECK8:       simd.if.end:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_parallel_master_taskloop_simd_codegen.cpp
// CHECK8-SAME: () #[[ATTR2]] section "__TEXT,__StaticInit,regular,pure_instructions" {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    call void @__cxx_global_var_init()
// CHECK8-NEXT:    ret void
//
