<?php

/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
/* This is the login object.
 *
 * Author: Nicolas Dufresne
 * Last modification:
 * 		14 Jul 2004 Nicolas Dufresne <nicolas@revolutionlinux.com>
 *		- Creation
 */

require_once 'functions.php';
require_once 'SessionData.php';


class Auth {
	var $uid; // Username
	var $pass; // Password
	var $connection; // Connection object, return true if connected;
	var $role; // Role admin|user|nobody
	var $userData;

	function Auth($uid, $pass) {
		$this->uid = $uid;
		$this->pass = $pass;
	}

	function connect() {
		global $CONFIG;

		// Check if connection already exist
		if ($this->connection)
			return getMessage('ldap_connected');

		// Check for host configuration
		if (!isset ($CONFIG['ldap_host']))
			return getMessage('ldap_no_host');

		// Connect to LDAP
		$this->connection = ldap_connect($CONFIG['ldap_host']);
		if (!$this->connection)
			return getMessage('ldap_cant_connect') . " : " . $this->connecion;

		// Defaulting to LDAP version 3
		if (!isset ($CONFIG['ldap_version']))
			$CONFIG['ldap_version'] = 3;

		// Setting ldap protocol to use
		if (!ldap_set_option($this->connection, LDAP_OPT_PROTOCOL_VERSION, $CONFIG['ldap_version']))
			return getMessage('ldap_version_not_supported');

		return NULL;
	}

	function disconnect() {
		// Check if connection exists
		if (!($this->connection))
			return getMessage('ldap_not_connected');
		// Close the connection
		ldap_close($this->connection);
		// Clean var
		$this->connection = NULL;
		return NULL;
	}

	function authenticate() {
		global $CONFIG;
		global $WARNINGS;

		// Check if basedn is defined
		if (!isset ($CONFIG['ldap_basedn'])) {
			$this->disconnect();
			return getMessage('ldap_no_basedn');
		}

		//Check if ldap_uidAttribute is defined
		if (!isset ($CONFIG['ldap_uidAttribute'])) {
			$CONFIG['ldap_uidAttribute'] = 'uid';
		}
		// Check if ldap_group is defined
		if (!isset ($CONFIG['ldap_group'])) {
			$this->disconnect();
			return getMessage('ldap_no_group');
		}
		//check if password is not empty
		if (!isset ($this->pass) || strlen($this->pass) < 1) {
			$this->disconnect();
			return getMessage('bad_login');
		}

		// Check if user can bind
		if ($error = $this->connect())
			return $error;
		/* FIXME
		 * A bad login is sent when we get protocol error.
		 */
		//

		// Binding to read group and user informations
		if (!@ ldap_bind($this->connection, $CONFIG['ldap_binddn'], $CONFIG['ldap_bindpw'])) {
			$this->disconnect();
			return getMessage('ldap_cant_bind');
		}
		$searchBase = $CONFIG['ldap_basedn'];
		$filter = $CONFIG['ldap_uidAttribute'] . "=" . $this->uid;
		if (isset ($CONFIG['ldap_object_class'])) {
			$filter = "(&(" . $filter . ")(objectclass=" . $CONFIG['ldap_object_class'] . "))";
		}
		$searchResult = @ ldap_search($this->connection, $searchBase, $filter);
		$entries = @ldap_get_entries($this->connection, $searchResult);
		//$entry = @ldap_first_entry($this->connection, $searchResult);
		$dn = $entries[0]["dn"];
		//$entry=$entries[0];
		//$values = @ldap_get_values($this->connection,$entry,$CONFIG['ldap_group']);

		$attribute = strtolower($CONFIG['ldap_group']);
		$groups=array();
		for ($j = 0; $j < $entries[0][$attribute]['count']; $j++) {
			//first index is the group name
			$arrString = preg_replace("/.*=/", "", preg_split('@[,]+@', $entries[0][$attribute][$j]));
			$groups[$j] = strtolower($arrString[0]);
		}


		if (!$entries["count"]) {
			return getMessage('bad_login');
		}

		$this->disconnect;
		$this->connect;
		if (!@ ldap_bind($this->connection, $dn, $this->pass)) {
			$this->disconnect();
			return getMessage('bad_login');
		}
		// Authentificatiion is done
		$this->disconnect();
		$this->userData = new SessionData($this->uid,$groups);
		return NULL;
	}
	function getRole() {
		return $this->role;
	}
	function getUserData() {
		return $this->userData;
	}
	function isValidEntity($entityName,$entityType){
		global $CONFIG;
		$this->connect();
		// Binding to read group and user informations
		if (!@ ldap_bind($this->connection, $CONFIG['ldap_binddn'], $CONFIG['ldap_bindpw'])) {
			$this->disconnect();
			return getMessage('ldap_cant_bind');
		}
		$searchBase = $CONFIG['ldap_basedn'];
		$filter="";
		if($entityType == GROUP_TYPE){
			$filter =  $CONFIG['ldap_uidAttribute']. "=" .$entityName;
			if (isset ($CONFIG['ldap_group_object_class'])) {
				$filter = "(&(" . $filter . ")(objectclass=" . $CONFIG['ldap_group_object_class'] . "))";
			}
		}else if($entityType == USER_TYPE){
			$filter = $CONFIG['ldap_uidAttribute']. "=" .$entityName;
			if (isset ($CONFIG['ldap_object_class'])) {
				$filter = "(&(" . $filter . ")(objectclass=" . $CONFIG['ldap_object_class'] . "))";
			}

		}else{
			return false;
		}
		//if (isset ($CONFIG['ldap_object_class'])) {
		//	$filter = "(&(" . $filter . ")(objectclass=" . $CONFIG['ldap_object_class'] . "))";
		//}
		$searchResult = @ ldap_search($this->connection, $searchBase, $filter);
		$entries = @ldap_get_entries($this->connection, $searchResult);
		$isValid = false;
		if ($entries["count"]) {
			$isValid = true;
		}
		$this->disconnect();
		return $isValid;
	}
}
