# The Lua Language #

`Lua` is a __powerful__, __fast__, __light-weight__, embeddable _scripting language_.
`Lua` combines simple procedural syntax with powerful data description
constructs based on associative arrays and extensible semantics. `Lua` is
dynamically typed, runs by interpreting bytecode for a register-based
virtual machine, and has automatic memory management with incremental
garbage collection, making it ideal for configuration, scripting, and rapid
prototyping. 'Lua' means 'moon' in Portuguese and is pronounced __LOO-ah__. 

Please visit [http:_www.lua.org](http:_www.lua.org) for more
information, or have a look on the [Lua Reference Manual](LuaManual).

## Why choose Lua? ##

### Lua is a proven and robust language ###

 Lua has been used in
[many industrial applications](http://www.lua.org/uses.html) (e.g.,
[Adobe's Photoshop Lightroom](http://since1968.com/article/190/mark-hamburg-interview-adobe-photoshop-lightroom-part-2-of-2)),
with an emphasis on embedded systems and games. Lua
is currently the leading scripting language in games. Lua has a solid
[reference manual](LuaManual) and there are
[several books about it](http://www.lua.org/docs.html#books). Several
[versions](http://www.lua.org/versions.html) of Lua have been released
and used in real applications since its creation in 1993.

### Lua is fast ###

Lua has a deserved reputation for performance. To
claim to be "as fast as Lua" is an aspiration of other scripting
languages. Several benchmarks show Lua as the fastest language in the realm
of interpreted scripting languages. Lua is fast not only in fine-tuned
benchmark programs, but in real life too. A substantial fraction of large
applications have been written in Lua.

### Lua is portable ###

Lua is [distributed](http://www.lua.org/download.html) in a small
package that builds out-of-the-box in all platforms that have an `ANSI/ISO C`
compiler. Lua runs on all flavors of `Unix` and `Windows`, and also on mobile
devices (such as handheld computers and cell phones that use `BREW`, `Symbian`,
`Pocket PC`, etc.) and embedded microprocessors (such as `ARM` and `Rabbit`) for
applications like `Lego MindStorms`.

### Lua is embeddable ###

Lua is a fast language engine with small footprint that you can embed into
your application. Lua has a simple and well documented `API` that allows
strong integration with code written in other languages. It is easy to
extend Lua with libraries written in other languages. It is also easy to
extend programs written in other languages with Lua. Lua has been used to
extend programs written not only in `C` and `C++`, but also in `Java`, `C#`,
`Smalltalk`, `Fortran`, `Ada`, and even in other scripting languages,
such as
`Perl` and `Ruby`.

### Lua is simple and powerful ###

A fundamental concept in the design of Lua is to provide _meta-mechanisms_
for implementing features, instead of providing a host of features directly
in the language. For example, although Lua is not a pure object-oriented
language, it does provide meta-mechanisms for implementing classes and
inheritance. Lua's meta-mechanisms bring an economy of concepts and keep
the language small, while allowing the semantics to be extended in
unconventional ways.

### Lua is free ###

Lua is free software, distributed under a
[liberal license](http://www.lua.org/license.html) (the well-known `MIT`
license). It can be used for both academic and commercial purposes at
absolutely no cost. Just [download](http://www.lua.org/download.html) it and use it.

### Where does Lua come from? ###

Lua is designed and implemented by a team at
[PUC-Rio](http://www.puc-rio.br/), the Pontifical Catholic University of
Rio de Janeiro in Brazil. Lua was born and raised at
[Tecgraf](http://www.tecgraf.puc-rio.br/), the Computer Graphics
Technology Group of PUC-Rio, and is now housed at
[Lablua](http://www.lua.inf.puc-rio.br/). Both Tecgraf and Lablua are
laboratories of the [Department of Computer Science](http://www.inf.puc-rio.br/).

