//
// File: AbstractCodonFrequenciesSubstitutionModel.cpp
// Created by:  Laurent Gueguen
// Created on: jeudi 15 septembre 2011, à 15h 02
//

/*
   Copyright or © or Copr. CNRS, (November 16, 2004)
   This software is a computer program whose purpose is to provide classes
   for phylogenetic data analysis.

   This software is governed by the CeCILL  license under French law and
   abiding by the rules of distribution of free software.  You can  use,
   modify and/ or redistribute the software under the terms of the CeCILL
   license as circulated by CEA, CNRS and INRIA at the following URL
   "http://www.cecill.info".

   As a counterpart to the access to the source code and  rights to copy,
   modify and redistribute granted by the license, users are provided only
   with a limited warranty  and the software's author,  the holder of the
   economic rights,  and the successive licensors  have only  limited
   liability.

   In this respect, the user's attention is drawn to the risks associated
   with loading,  using,  modifying and/or developing or reproducing the
   software by the user in light of its specific status of free software,
   that may mean  that it is complicated to manipulate,  and  that  also
   therefore means  that it is reserved for developers  and  experienced
   professionals having in-depth computer knowledge. Users are therefore
   encouraged to load and test the software's suitability as regards their
   requirements in conditions enabling the security of their systems and/or
   data to be ensured and,  more generally, to use and operate it in the
   same conditions as regards security.

   The fact that you are presently reading this means that you have had
   knowledge of the CeCILL license and that you accept its terms.
 */

#include "AbstractCodonFrequenciesSubstitutionModel.h"

// #include <Bpp/Seq/Alphabet/AlphabetTools.h>

using namespace bpp;

using namespace std;

/******************************************************************************/

AbstractCodonFrequenciesSubstitutionModel::AbstractCodonFrequenciesSubstitutionModel(
  FrequenciesSet* pfreq,
  const std::string& prefix) :
  AbstractParameterAliasable(prefix),
  pfreqset_(pfreq),
  freqName_("")
{
  if (dynamic_cast<CodonFrequenciesSet*>(pfreq) == NULL)
    throw Exception("Bad type for equilibrium frequencies " + pfreq->getName());

  freqName_ = pfreqset_->getNamespace();
  pfreqset_->setNamespace(prefix + freqName_);
  addParameters_(pfreqset_->getParameters());
}

AbstractCodonFrequenciesSubstitutionModel::~AbstractCodonFrequenciesSubstitutionModel()
{
  if (pfreqset_)
    delete pfreqset_;
}

void AbstractCodonFrequenciesSubstitutionModel::fireParameterChanged(const ParameterList& parameters)
{
  pfreqset_->matchParametersValues(parameters);  
}


void AbstractCodonFrequenciesSubstitutionModel::setFreq(map<int, double>& frequencies)
{
  pfreqset_->setFrequenciesFromAlphabetStatesFrequencies(frequencies);
  matchParametersValues(pfreqset_->getParameters());
}

double AbstractCodonFrequenciesSubstitutionModel::getCodonsMulRate(size_t i, size_t j) const
{
  return pfreqset_->getFrequencies()[j];
}

