"""create tables for Pubsub caching

Revision ID: 8974efc51d22
Revises: 602caf848068
Create Date: 2021-07-27 16:38:54.658212

"""
from alembic import op
import sqlalchemy as sa
from libervia.backend.memory.sqla_mapping import JID, Xml


# revision identifiers, used by Alembic.
revision = '8974efc51d22'
down_revision = '602caf848068'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('pubsub_nodes',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('profile_id', sa.Integer(), nullable=True),
    sa.Column('service', JID(), nullable=True),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('subscribed', sa.Boolean(create_constraint=True, name='subscribed_bool'), nullable=False),
    sa.Column('analyser', sa.Text(), nullable=True),
    sa.Column('sync_state', sa.Enum('IN_PROGRESS', 'COMPLETED', 'ERROR', 'NO_SYNC', name='sync_state', create_constraint=True), nullable=True),
    sa.Column('sync_state_updated', sa.Float(), nullable=False),
    sa.Column('type', sa.Text(), nullable=True),
    sa.Column('subtype', sa.Text(), nullable=True),
    sa.Column('extra', sa.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['profile_id'], ['profiles.id'], name=op.f('fk_pubsub_nodes_profile_id_profiles'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_pubsub_nodes')),
    sa.UniqueConstraint('profile_id', 'service', 'name', name=op.f('uq_pubsub_nodes_profile_id'))
    )
    op.create_table('pubsub_items',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('node_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('data', Xml(), nullable=False),
    sa.Column('created', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('updated', sa.DateTime(), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=False),
    sa.Column('parsed', sa.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['node_id'], ['pubsub_nodes.id'], name=op.f('fk_pubsub_items_node_id_pubsub_nodes'), ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_pubsub_items')),
    sa.UniqueConstraint('node_id', 'name', name=op.f('uq_pubsub_items_node_id'))
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('pubsub_items')
    op.drop_table('pubsub_nodes')
    # ### end Alembic commands ###
