with Ada.Command_Line;      use Ada.Command_Line;
with GNATCOLL.SQL.Postgres; use GNATCOLL.SQL;
with GNATCOLL.SQL.Sqlite;

with Task_Cursor;

procedure TC_Main is
   On_Postgres : constant Boolean :=
      Argument_Count > 0 and then Argument (1) = "pg";
   Test_Speed : constant Boolean :=
      Argument_Count > 1 and then Argument (2) = "speed";
begin
   for Use_Cache in Boolean loop
      if On_Postgres then
         Task_Cursor
           (Postgres.Setup ("test", Cache_Support => Use_Cache),
            Test_Speed);
      else
         Task_Cursor
            (Sqlite.Setup
               ("test-task-cursors.sqlite", Cache_Support => Use_Cache),
            Test_Speed);
      end if;
   end loop;
end TC_Main;
