/*
 * @(#)IErrorsUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.mbtf.v1;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the IErrors interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     March 27, 2002
 * @version   $Date: 2003/02/10 22:52:27 $
 */
public class IErrorsUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IErrorsUTestI.class;
    
    public IErrorsUTestI( String name, ImplFactory f )
    {
        super( name, IErrors.class, f );
    }

    
    public IErrors createIErrors()
    {
        return (IErrors)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testHalt1()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.halt( null );
            fail( "Did not throw TestHaltRuntimeException." );
        }
        catch (TestHaltRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testHalt2()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.halt( "" );
            fail( "Did not throw TestHaltRuntimeException." );
        }
        catch (TestHaltRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testHalt3()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.halt( "a" );
            fail( "Did not throw TestHaltRuntimeException." );
        }
        catch (TestHaltRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail1()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( null );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail2()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( "" );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail3()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( "a" );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail4()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( null, null );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail5()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( "", null );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail6()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( "a", null );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail7()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( null, new Throwable() );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail8()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( "", new Throwable() );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void testFail9()
    {
        IErrors e = createIErrors();
        
        try
        {
            e.fail( "a", new Throwable() );
            fail( "Did not throw TestFailRuntimeException." );
        }
        catch (TestFailRuntimeException ex)
        {
        }
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure1()
    {
        IErrors e = createIErrors();
        e.addFailure( null );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure2()
    {
        IErrors e = createIErrors();
        e.addFailure( "" );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure3()
    {
        IErrors e = createIErrors();
        e.addFailure( "a" );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure4()
    {
        IErrors e = createIErrors();
        e.addFailure( null, null );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure5()
    {
        IErrors e = createIErrors();
        e.addFailure( "", null );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure6()
    {
        IErrors e = createIErrors();
        e.addFailure( "a", null );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure7()
    {
        IErrors e = createIErrors();
        e.addFailure( null, new Throwable() );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure8()
    {
        IErrors e = createIErrors();
        e.addFailure( "", new Throwable() );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    public void tstAddFailure9()
    {
        IErrors e = createIErrors();
        e.addFailure( "a", new Throwable() );
        
        assertNotNull(
            "Returned null error list.",
            e.getErrors() );
        assertEquals(
            "Returned incorrect number of errors.",
            1,
            e.getErrors().length );
    }
    
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

