/* gsd-async-operation.c generated by valac 0.34.2, the Vala compiler
 * generated from gsd-async-operation.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <glib/gi18n-lib.h>
#include <unistd.h>
#include <float.h>
#include <math.h>


#define GSD_TYPE_ASYNC_OPERATION (gsd_async_operation_get_type ())
#define GSD_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation))
#define GSD_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))
#define GSD_IS_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ASYNC_OPERATION))
#define GSD_IS_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ASYNC_OPERATION))
#define GSD_ASYNC_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))

typedef struct _GsdAsyncOperation GsdAsyncOperation;
typedef struct _GsdAsyncOperationClass GsdAsyncOperationClass;
typedef struct _GsdAsyncOperationPrivate GsdAsyncOperationPrivate;

#define GSD_ASYNC_OPERATION_TYPE_EXIT_STATUS (gsd_async_operation_exit_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

/**
   * Error domain for the AsyncOperation class.
   */
typedef enum  {
	GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED,
	GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR
} GsdAsyncOperationError;
#define GSD_ASYNC_OPERATION_ERROR gsd_async_operation_error_quark ()
typedef enum  {
	GSD_ASYNC_OPERATION_EXIT_STATUS_SUCCESS,
	GSD_ASYNC_OPERATION_EXIT_STATUS_WARNING,
	GSD_ASYNC_OPERATION_EXIT_STATUS_ERROR
} GsdAsyncOperationExitStatus;

struct _GsdAsyncOperation {
	GObject parent_instance;
	GsdAsyncOperationPrivate * priv;
	guint n_passes;
	guint passes;
	GPid pid;
	gint fd_in;
	gint fd_out;
	gint fd_err;
};

struct _GsdAsyncOperationClass {
	GObjectClass parent_class;
	GList* (*build_args) (GsdAsyncOperation* self, GError** error);
	gchar** (*build_env) (GsdAsyncOperation* self, int* result_length1);
	void (*cleanup) (GsdAsyncOperation* self);
	guint (*get_max_progress) (GsdAsyncOperation* self);
	guint (*get_progress) (GsdAsyncOperation* self);
	gchar* (*get_subprocess_error_msg) (GsdAsyncOperation* self);
	GsdAsyncOperationExitStatus (*classify_exit_status) (GsdAsyncOperation* self, gint exit_status);
};

struct _GsdAsyncOperationPrivate {
	gboolean _busy;
	GRecMutex __lock__busy;
	gchar* _path;
	gchar* _path_default;
};

typedef enum  {
	GSD_FD_ERROR_KILL_ERROR,
	GSD_FD_ERROR_READ_ERROR,
	GSD_FD_ERROR_SELECT_ERROR,
	GSD_FD_ERROR_WAITPID_ERROR
} GsdFDError;
#define GSD_FD_ERROR gsd_fd_error_quark ()

static gpointer gsd_async_operation_parent_class = NULL;

#define WATCH_INTERVAL ((guint) 100)
GQuark gsd_async_operation_error_quark (void);
GType gsd_async_operation_get_type (void) G_GNUC_CONST;
GType gsd_async_operation_exit_status_get_type (void) G_GNUC_CONST;
#define GSD_ASYNC_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationPrivate))
enum  {
	GSD_ASYNC_OPERATION_DUMMY_PROPERTY,
	GSD_ASYNC_OPERATION_PATH,
	GSD_ASYNC_OPERATION_BUSY
};
GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error);
static GList* gsd_async_operation_real_build_args (GsdAsyncOperation* self, GError** error);
static gchar** gsd_async_operation_do_build_args (GsdAsyncOperation* self, int* result_length1, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
const gchar* gsd_async_operation_get_path (GsdAsyncOperation* self);
gchar** gsd_async_operation_build_env (GsdAsyncOperation* self, int* result_length1);
static gchar** gsd_async_operation_real_build_env (GsdAsyncOperation* self, int* result_length1);
void gsd_async_operation_cleanup (GsdAsyncOperation* self);
static void gsd_async_operation_real_cleanup (GsdAsyncOperation* self);
guint gsd_async_operation_get_max_progress (GsdAsyncOperation* self);
static guint gsd_async_operation_real_get_max_progress (GsdAsyncOperation* self);
guint gsd_async_operation_get_progress (GsdAsyncOperation* self);
static guint gsd_async_operation_real_get_progress (GsdAsyncOperation* self);
static void gsd_async_operation_update_progress (GsdAsyncOperation* self);
gchar* gsd_async_operation_get_subprocess_error_msg (GsdAsyncOperation* self);
static gchar* gsd_async_operation_real_get_subprocess_error_msg (GsdAsyncOperation* self);
GQuark gsd_fd_error_quark (void);
gchar* gsd_fd_read_string (gint fd, gssize n_bytes, GError** error);
GsdAsyncOperationExitStatus gsd_async_operation_classify_exit_status (GsdAsyncOperation* self, gint exit_status);
static GsdAsyncOperationExitStatus gsd_async_operation_real_classify_exit_status (GsdAsyncOperation* self, gint exit_status);
static gboolean gsd_async_operation_do_wait_child (GsdAsyncOperation* self);
static gboolean gsd_async_operation_signal_child (GsdAsyncOperation* self, int signum);
gboolean gsd_async_operation_get_busy (GsdAsyncOperation* self);
gboolean gsd_async_operation_cancel (GsdAsyncOperation* self);
gboolean gsd_async_operation_pause (GsdAsyncOperation* self);
gboolean gsd_async_operation_resume (GsdAsyncOperation* self);
static void gsd_async_operation_child_setup (GsdAsyncOperation* self);
gboolean gsd_async_operation_run (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, GError** error);
static void _gsd_async_operation_child_setup_gspawn_child_setup_func (gpointer self);
static gboolean _gsd_async_operation_do_wait_child_gsource_func (gpointer self);
gboolean gsd_async_operation_run_sync (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, gchar** standard_output, GError** error);
GsdAsyncOperation* gsd_async_operation_construct (GType object_type);
void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void gsd_async_operation_finalize (GObject* obj);
static void _vala_gsd_async_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gsd_async_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark gsd_async_operation_error_quark (void) {
	return g_quark_from_static_string ("gsd_async_operation_error-quark");
}


GType gsd_async_operation_exit_status_get_type (void) {
	static volatile gsize gsd_async_operation_exit_status_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_async_operation_exit_status_type_id__volatile)) {
		static const GEnumValue values[] = {{GSD_ASYNC_OPERATION_EXIT_STATUS_SUCCESS, "GSD_ASYNC_OPERATION_EXIT_STATUS_SUCCESS", "success"}, {GSD_ASYNC_OPERATION_EXIT_STATUS_WARNING, "GSD_ASYNC_OPERATION_EXIT_STATUS_WARNING", "warning"}, {GSD_ASYNC_OPERATION_EXIT_STATUS_ERROR, "GSD_ASYNC_OPERATION_EXIT_STATUS_ERROR", "error"}, {0, NULL, NULL}};
		GType gsd_async_operation_exit_status_type_id;
		gsd_async_operation_exit_status_type_id = g_enum_register_static ("GsdAsyncOperationExitStatus", values);
		g_once_init_leave (&gsd_async_operation_exit_status_type_id__volatile, gsd_async_operation_exit_status_type_id);
	}
	return gsd_async_operation_exit_status_type_id__volatile;
}


static GList* gsd_async_operation_real_build_args (GsdAsyncOperation* self, GError** error) {
	g_critical ("Type `%s' does not implement abstract method `gsd_async_operation_build_args'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GList* gsd_async_operation_build_args (GsdAsyncOperation* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->build_args (self, error);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gchar** gsd_async_operation_do_build_args (GsdAsyncOperation* self, int* result_length1, GError** error) {
	gchar** result = NULL;
	GList* args = NULL;
	gchar** array_args = NULL;
	gint array_args_length1 = 0;
	gint _array_args_size_ = 0;
	gsize i = 0UL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gsize _tmp7_ = 0UL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gsize _tmp19_ = 0UL;
	gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gsd_async_operation_build_args (self, &_inner_error_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR) {
			g_propagate_error (error, _inner_error_);
			array_args = (_vala_array_free (array_args, array_args_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free__g_free0_0 (args);
			return NULL;
		} else {
			array_args = (_vala_array_free (array_args, array_args_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free__g_free0_0 (args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	__g_list_free__g_free0_0 (args);
	args = _tmp2_;
	_tmp3_ = args;
	_tmp4_ = g_list_length (_tmp3_);
	_tmp5_ = g_new0 (gchar*, (_tmp4_ + 2) + 1);
	array_args = (_vala_array_free (array_args, array_args_length1, (GDestroyNotify) g_free), NULL);
	array_args = _tmp5_;
	array_args_length1 = _tmp4_ + 2;
	_array_args_size_ = array_args_length1;
	i = (gsize) 0;
	_tmp6_ = array_args;
	_tmp6__length1 = array_args_length1;
	_tmp7_ = i;
	i = _tmp7_ + 1;
	_tmp8_ = gsd_async_operation_get_path (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (_tmp6_[_tmp7_]);
	_tmp6_[_tmp7_] = _tmp10_;
	_tmp11_ = _tmp6_[_tmp7_];
	_tmp12_ = args;
	{
		GList* arg_collection = NULL;
		GList* arg_it = NULL;
		arg_collection = _tmp12_;
		for (arg_it = arg_collection; arg_it != NULL; arg_it = arg_it->next) {
			const gchar* arg = NULL;
			arg = (const gchar*) arg_it->data;
			{
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gsize _tmp14_ = 0UL;
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				_tmp13_ = array_args;
				_tmp13__length1 = array_args_length1;
				_tmp14_ = i;
				i = _tmp14_ + 1;
				_tmp15_ = arg;
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_tmp13_[_tmp14_]);
				_tmp13_[_tmp14_] = _tmp16_;
				_tmp17_ = _tmp13_[_tmp14_];
			}
		}
	}
	_tmp18_ = array_args;
	_tmp18__length1 = array_args_length1;
	_tmp19_ = i;
	_g_free0 (_tmp18_[_tmp19_]);
	_tmp18_[_tmp19_] = NULL;
	_tmp20_ = _tmp18_[_tmp19_];
	_tmp21_ = array_args;
	_tmp21__length1 = array_args_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	__g_list_free__g_free0_0 (_tmp0_);
	__g_list_free__g_free0_0 (args);
	return result;
}


static gchar** gsd_async_operation_real_build_env (GsdAsyncOperation* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


gchar** gsd_async_operation_build_env (GsdAsyncOperation* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->build_env (self, result_length1);
}


static void gsd_async_operation_real_cleanup (GsdAsyncOperation* self) {
}


void gsd_async_operation_cleanup (GsdAsyncOperation* self) {
	g_return_if_fail (self != NULL);
	GSD_ASYNC_OPERATION_GET_CLASS (self)->cleanup (self);
}


static guint gsd_async_operation_real_get_max_progress (GsdAsyncOperation* self) {
	guint result = 0U;
	result = (guint) 0;
	return result;
}


guint gsd_async_operation_get_max_progress (GsdAsyncOperation* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->get_max_progress (self);
}


static guint gsd_async_operation_real_get_progress (GsdAsyncOperation* self) {
	guint result = 0U;
	result = (guint) 0;
	return result;
}


guint gsd_async_operation_get_progress (GsdAsyncOperation* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->get_progress (self);
}


static void gsd_async_operation_update_progress (GsdAsyncOperation* self) {
	guint progress = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = gsd_async_operation_get_progress (self);
	progress = _tmp0_;
	_tmp1_ = progress;
	if (_tmp1_ > ((guint) 0)) {
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp2_ = self->passes;
		_tmp3_ = progress;
		self->passes = _tmp2_ + _tmp3_;
		_tmp4_ = self->passes;
		_tmp5_ = self->n_passes;
		g_signal_emit_by_name (self, "progress", _tmp4_ / (_tmp5_ * 1.0));
	}
}


static gchar* gsd_async_operation_real_get_subprocess_error_msg (GsdAsyncOperation* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp1_ = self->fd_err;
		_tmp2_ = gsd_fd_read_string (_tmp1_, (gssize) -1, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == GSD_FD_ERROR) {
				goto __catch0_gsd_fd_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp3_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_gsd_fd_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("gsd-async-operation.vala:274: Subprocess error output read failed: %s", _tmp5_);
		_tmp6_ = g_strdup ("???");
		result = _tmp6_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


gchar* gsd_async_operation_get_subprocess_error_msg (GsdAsyncOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->get_subprocess_error_msg (self);
}


static GsdAsyncOperationExitStatus gsd_async_operation_real_classify_exit_status (GsdAsyncOperation* self, gint exit_status) {
	GsdAsyncOperationExitStatus result = 0;
	GsdAsyncOperationExitStatus _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp1_ = exit_status;
	if (_tmp1_ == 0) {
		_tmp0_ = GSD_ASYNC_OPERATION_EXIT_STATUS_SUCCESS;
	} else {
		_tmp0_ = GSD_ASYNC_OPERATION_EXIT_STATUS_ERROR;
	}
	result = _tmp0_;
	return result;
}


GsdAsyncOperationExitStatus gsd_async_operation_classify_exit_status (GsdAsyncOperation* self, gint exit_status) {
	g_return_val_if_fail (self != NULL, 0);
	return GSD_ASYNC_OPERATION_GET_CLASS (self)->classify_exit_status (self, exit_status);
}


static gboolean gsd_async_operation_do_wait_child (GsdAsyncOperation* self) {
	gboolean result = FALSE;
	gboolean finished = FALSE;
	gboolean success = FALSE;
	gint exit_status = 0;
	pid_t wait_rv = 0;
	gchar* message = NULL;
	GPid _tmp0_ = 0;
	gint _tmp1_ = 0;
	pid_t _tmp2_ = 0;
	pid_t _tmp3_ = 0;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp42_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	finished = TRUE;
	success = FALSE;
	message = NULL;
	_tmp0_ = self->pid;
	_tmp2_ = waitpid ((pid_t) _tmp0_, &_tmp1_, WNOHANG);
	exit_status = _tmp1_;
	wait_rv = _tmp2_;
	_tmp3_ = wait_rv;
	if (((gint) _tmp3_) < 0) {
		gint _tmp4_ = 0;
		const gchar* _tmp5_ = NULL;
		GPid _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp4_ = errno;
		_tmp5_ = g_strerror (_tmp4_);
		g_critical ("gsd-async-operation.vala:300: waitpid() failed: %s", _tmp5_);
		_tmp6_ = self->pid;
		_tmp7_ = kill ((pid_t) _tmp6_, (gint) SIGTERM);
		if (_tmp7_ < 0) {
			gint _tmp8_ = 0;
			const gchar* _tmp9_ = NULL;
			_tmp8_ = errno;
			_tmp9_ = g_strerror (_tmp8_);
			g_critical ("gsd-async-operation.vala:303: kill() failed: %s", _tmp9_);
		}
	} else {
		pid_t _tmp10_ = 0;
		_tmp10_ = wait_rv;
		if (((gint) _tmp10_) == 0) {
			gsd_async_operation_update_progress (self);
			finished = FALSE;
		} else {
			gint _tmp11_ = 0;
			gboolean _tmp12_ = FALSE;
			_tmp11_ = exit_status;
			_tmp12_ = WIFEXITED (_tmp11_);
			if (!_tmp12_) {
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp13_ = _ ("Subprocess crashed.");
				_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
				_tmp15_ = _tmp14_;
				_tmp16_ = gsd_async_operation_get_subprocess_error_msg (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
				_g_free0 (message);
				message = _tmp18_;
				_g_free0 (_tmp17_);
				_g_free0 (_tmp15_);
			} else {
				gint status_int = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				GsdAsyncOperationExitStatus status = 0;
				gint _tmp21_ = 0;
				GsdAsyncOperationExitStatus _tmp22_ = 0;
				GsdAsyncOperationExitStatus _tmp23_ = 0;
				GsdAsyncOperationExitStatus _tmp32_ = 0;
				_tmp19_ = exit_status;
				_tmp20_ = WEXITSTATUS (_tmp19_);
				status_int = _tmp20_;
				_tmp21_ = status_int;
				_tmp22_ = gsd_async_operation_classify_exit_status (self, _tmp21_);
				status = _tmp22_;
				_tmp23_ = status;
				if (_tmp23_ == GSD_ASYNC_OPERATION_EXIT_STATUS_WARNING) {
					gchar* _tmp24_ = NULL;
					_tmp24_ = gsd_async_operation_get_subprocess_error_msg (self);
					_g_free0 (message);
					message = _tmp24_;
				} else {
					GsdAsyncOperationExitStatus _tmp25_ = 0;
					_tmp25_ = status;
					if (_tmp25_ == GSD_ASYNC_OPERATION_EXIT_STATUS_ERROR) {
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						_tmp26_ = _ ("Subprocess failed.");
						_tmp27_ = g_strconcat (_tmp26_, "\n", NULL);
						_tmp28_ = _tmp27_;
						_tmp29_ = gsd_async_operation_get_subprocess_error_msg (self);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
						_g_free0 (message);
						message = _tmp31_;
						_g_free0 (_tmp30_);
						_g_free0 (_tmp28_);
					}
				}
				_tmp32_ = status;
				success = _tmp32_ != GSD_ASYNC_OPERATION_EXIT_STATUS_ERROR;
			}
		}
	}
	_tmp33_ = finished;
	if (_tmp33_) {
		gboolean _tmp34_ = FALSE;
		const gchar* _tmp35_ = NULL;
		GPid _tmp36_ = 0;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gsd_async_operation_update_progress (self);
		_tmp34_ = success;
		_tmp35_ = message;
		g_signal_emit_by_name (self, "finished", _tmp34_, _tmp35_);
		gsd_async_operation_cleanup (self);
		_tmp36_ = self->pid;
		g_spawn_close_pid (_tmp36_);
		_tmp37_ = self->fd_err;
		close (_tmp37_);
		_tmp38_ = self->fd_out;
		close (_tmp38_);
		_tmp39_ = self->fd_in;
		close (_tmp39_);
		{
			gboolean _tmp40_ = FALSE;
			_tmp40_ = self->priv->_busy;
			g_rec_mutex_lock (&self->priv->__lock__busy);
			{
				self->priv->_busy = FALSE;
			}
			__finally1:
			{
				gboolean _tmp41_ = FALSE;
				_tmp41_ = self->priv->_busy;
				g_rec_mutex_unlock (&self->priv->__lock__busy);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (message);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp42_ = finished;
	result = !_tmp42_;
	_g_free0 (message);
	return result;
}


static gboolean gsd_async_operation_signal_child (GsdAsyncOperation* self, int signum) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint kill_status = 0;
	GPid _tmp2_ = 0;
	int _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gsd_async_operation_get_busy (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_, "this.busy", FALSE);
	_tmp2_ = self->pid;
	_tmp3_ = signum;
	_tmp4_ = killpg ((pid_t) _tmp2_, (gint) _tmp3_);
	kill_status = _tmp4_;
	_tmp5_ = kill_status;
	if (_tmp5_ < 0) {
		gint _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = errno;
		_tmp7_ = g_strerror (_tmp6_);
		g_critical ("gsd-async-operation.vala:352: kill() failed: %s", _tmp7_);
	}
	_tmp8_ = kill_status;
	result = !(_tmp8_ < 0);
	return result;
}


/**
     * Tries to cancel the operation.
     * 
     * @return true if successfully canceled, false otherwise.
     */
gboolean gsd_async_operation_cancel (GsdAsyncOperation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = gsd_async_operation_signal_child (self, SIGTERM);
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = gsd_async_operation_signal_child (self, SIGCONT);
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
     * Tries to pause the operation.
     * 
     * @return true if successfully paused, false otherwise.
     */
gboolean gsd_async_operation_pause (GsdAsyncOperation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gsd_async_operation_signal_child (self, SIGSTOP);
	result = _tmp0_;
	return result;
}


/**
     * Tries to resume the operation.
     * 
     * @return true if successfully resumed, false otherwise.
     */
gboolean gsd_async_operation_resume (GsdAsyncOperation* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gsd_async_operation_signal_child (self, SIGCONT);
	result = _tmp0_;
	return result;
}


static void gsd_async_operation_child_setup (GsdAsyncOperation* self) {
	g_return_if_fail (self != NULL);
	setpgid ((pid_t) 0, (pid_t) 0);
}


/**
     * Launches an operation asynchronously.
     * 
     * @param working_directory the working directory of the child process, or
     *    null to use the parent's one.
     * @param spawn_flags SpawnFlags. You may only use the SEARCH_PATH and
     *    CHILD_INHERITS_STDIN flags, others may conflict.
     * 
     * @return whether asynchronous operation was successfully started.
     */
static void _gsd_async_operation_child_setup_gspawn_child_setup_func (gpointer self) {
	gsd_async_operation_child_setup ((GsdAsyncOperation*) self);
}


static gboolean _gsd_async_operation_do_wait_child_gsource_func (gpointer self) {
	gboolean result;
	result = gsd_async_operation_do_wait_child ((GsdAsyncOperation*) self);
	return result;
}


gboolean gsd_async_operation_run (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, GError** error) {
	gboolean result = FALSE;
	gboolean success = FALSE;
	gboolean busy = FALSE;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	success = FALSE;
	busy = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_busy;
		g_rec_mutex_lock (&self->priv->__lock__busy);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->_busy;
			busy = _tmp1_;
			self->priv->_busy = TRUE;
		}
		__finally2:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->_busy;
			g_rec_mutex_unlock (&self->priv->__lock__busy);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp3_ = busy;
	g_return_val_if_fail (!_tmp3_, FALSE);
	{
		guint _tmp4_ = 0U;
		gchar** _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp5__length1 = 0;
		gint __tmp5__size_ = 0;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gchar** _tmp11_ = NULL;
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		GSpawnFlags _tmp13_ = 0;
		GPid _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		self->fd_err = -1;
		self->fd_out = -1;
		_tmp4_ = gsd_async_operation_get_max_progress (self);
		self->n_passes = _tmp4_;
		self->passes = (guint) 0;
		_tmp7_ = gsd_async_operation_do_build_args (self, &_tmp6_, &_inner_error_);
		_tmp5_ = _tmp7_;
		_tmp5__length1 = _tmp6_;
		__tmp5__size_ = _tmp5__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __finally3;
		}
		_tmp9_ = working_directory;
		_tmp11_ = gsd_async_operation_build_env (self, &_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp10_;
		_tmp13_ = spawn_flags;
		_tmp18_ = g_spawn_async_with_pipes (_tmp9_, _tmp5_, _tmp12_, _tmp13_ | G_SPAWN_DO_NOT_REAP_CHILD, _gsd_async_operation_child_setup_gspawn_child_setup_func, self, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_, &_inner_error_);
		self->pid = _tmp14_;
		self->fd_in = _tmp15_;
		self->fd_out = _tmp16_;
		self->fd_err = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
		_tmp8_ = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
			goto __finally3;
		}
		success = _tmp8_;
		_tmp20_ = success;
		if (_tmp20_) {
			g_timeout_add_full (G_PRIORITY_DEFAULT, WATCH_INTERVAL, _gsd_async_operation_do_wait_child_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	}
	__finally3:
	{
		gboolean _tmp21_ = FALSE;
		_tmp21_ = success;
		if (!_tmp21_) {
			{
				gboolean _tmp22_ = FALSE;
				_tmp22_ = self->priv->_busy;
				g_rec_mutex_lock (&self->priv->__lock__busy);
				{
					self->priv->_busy = FALSE;
				}
				__finally4:
				{
					gboolean _tmp23_ = FALSE;
					_tmp23_ = self->priv->_busy;
					g_rec_mutex_unlock (&self->priv->__lock__busy);
				}
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
						g_propagate_error (error, _inner_error_);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
			}
		}
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	return result;
}


/**
     * Launches an operation synchronously.
     * 
     * @param working_directory the working directory of the child process, or
     *    null to use the parent's one.
     * @param spawn_flags SpawnFlags. You may only use the SEARCH_PATH and
     *    CHILD_INHERITS_STDIN flags, others may conflict.
     * @param standard_output return location for the subprocess' standard
     *    output, or null to ignore it.
     * 
     * @return true if all worked properly, and false if something failed.
     *         An error is thrown if something fails. It can be the subprocess
     *         spawning (SpawnError) or the child that failed
     *         (AsyncOperationError.CHILD_FAILED).
     */
gboolean gsd_async_operation_run_sync (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, gchar** standard_output, GError** error) {
	gchar* _vala_standard_output = NULL;
	gboolean result = FALSE;
	gboolean success = FALSE;
	gboolean busy = FALSE;
	gchar* error_output = NULL;
	gint exit_status = 0;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	success = TRUE;
	busy = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = self->priv->_busy;
		g_rec_mutex_lock (&self->priv->__lock__busy);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = self->priv->_busy;
			busy = _tmp1_;
			self->priv->_busy = TRUE;
		}
		__finally5:
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = self->priv->_busy;
			g_rec_mutex_unlock (&self->priv->__lock__busy);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (error_output);
				return FALSE;
			} else {
				_g_free0 (error_output);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp3_ = busy;
	g_return_val_if_fail (!_tmp3_, FALSE);
	{
		gchar** _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gchar** _tmp6_ = NULL;
		gint _tmp4__length1 = 0;
		gint __tmp4__size_ = 0;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gchar** _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		GSpawnFlags _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		_tmp6_ = gsd_async_operation_do_build_args (self, &_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		_tmp4__length1 = _tmp5_;
		__tmp4__size_ = _tmp4__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __finally6;
		}
		_tmp8_ = working_directory;
		_tmp10_ = gsd_async_operation_build_env (self, &_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp9_;
		_tmp12_ = spawn_flags;
		_tmp16_ = g_spawn_sync (_tmp8_, _tmp4_, _tmp11_, _tmp12_, NULL, NULL, &_tmp13_, &_tmp14_, &_tmp15_, &_inner_error_);
		_g_free0 (_vala_standard_output);
		_vala_standard_output = _tmp13_;
		_g_free0 (error_output);
		error_output = _tmp14_;
		exit_status = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_tmp7_ = _tmp17_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
			goto __finally6;
		}
		success = _tmp7_;
		_tmp18_ = success;
		if (_tmp18_) {
			gchar* message = NULL;
			gint _tmp19_ = 0;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp33_ = FALSE;
			const gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			message = NULL;
			success = FALSE;
			_tmp19_ = exit_status;
			_tmp20_ = WIFEXITED (_tmp19_);
			if (!_tmp20_) {
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				_tmp21_ = _ ("Subprocess crashed.");
				_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
				_tmp23_ = _tmp22_;
				_tmp24_ = error_output;
				_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
				_g_free0 (message);
				message = _tmp25_;
				_g_free0 (_tmp23_);
			} else {
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				_tmp26_ = exit_status;
				_tmp27_ = WEXITSTATUS (_tmp26_);
				if (_tmp27_ != 0) {
					const gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					_tmp28_ = _ ("Subprocess failed.");
					_tmp29_ = g_strconcat (_tmp28_, "\n", NULL);
					_tmp30_ = _tmp29_;
					_tmp31_ = error_output;
					_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
					_g_free0 (message);
					message = _tmp32_;
					_g_free0 (_tmp30_);
				} else {
					success = TRUE;
				}
			}
			_tmp33_ = success;
			_tmp34_ = message;
			g_signal_emit_by_name (self, "finished", _tmp33_, _tmp34_);
			gsd_async_operation_cleanup (self);
			_tmp35_ = message;
			if (_tmp35_ != NULL) {
				const gchar* _tmp36_ = NULL;
				GError* _tmp37_ = NULL;
				_tmp36_ = message;
				_tmp37_ = g_error_new (GSD_ASYNC_OPERATION_ERROR, GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED, "%s", _tmp36_);
				_inner_error_ = _tmp37_;
				_g_free0 (message);
				_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
				goto __finally6;
			}
			_g_free0 (message);
		}
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	}
	__finally6:
	{
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = self->priv->_busy;
			g_rec_mutex_lock (&self->priv->__lock__busy);
			{
				self->priv->_busy = FALSE;
			}
			__finally7:
			{
				gboolean _tmp39_ = FALSE;
				_tmp39_ = self->priv->_busy;
				g_rec_mutex_unlock (&self->priv->__lock__busy);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (error_output);
					return FALSE;
				} else {
					_g_free0 (error_output);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
		}
	}
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (error_output);
			return FALSE;
		} else {
			_g_free0 (error_output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = success;
	_g_free0 (error_output);
	if (standard_output) {
		*standard_output = _vala_standard_output;
	} else {
		_g_free0 (_vala_standard_output);
	}
	return result;
}


GsdAsyncOperation* gsd_async_operation_construct (GType object_type) {
	GsdAsyncOperation * self = NULL;
	self = (GsdAsyncOperation*) g_object_new (object_type, NULL);
	return self;
}


const gchar* gsd_async_operation_get_path (GsdAsyncOperation* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path;
	if (_tmp0_ == NULL) {
		g_critical ("gsd-async-operation.vala:161: Property AsyncOperation::path not set");
	}
	_tmp1_ = self->priv->_path;
	result = _tmp1_;
	return result;
}


void gsd_async_operation_set_path (GsdAsyncOperation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = self->priv->_path_default;
		if (_tmp1_ == NULL) {
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
			_tmp2_ = value;
			_tmp3_ = g_strdup (_tmp2_);
			_g_free0 (self->priv->_path_default);
			self->priv->_path_default = _tmp3_;
		}
		_tmp4_ = value;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp5_;
	} else {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = self->priv->_path_default;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->_path);
		self->priv->_path = _tmp7_;
	}
	g_object_notify ((GObject *) self, "path");
}


gboolean gsd_async_operation_get_busy (GsdAsyncOperation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_busy;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_STRING) (gpointer data1, gboolean arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void gsd_async_operation_class_init (GsdAsyncOperationClass * klass) {
	gsd_async_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GsdAsyncOperationPrivate));
	((GsdAsyncOperationClass *) klass)->build_args = gsd_async_operation_real_build_args;
	((GsdAsyncOperationClass *) klass)->build_env = gsd_async_operation_real_build_env;
	((GsdAsyncOperationClass *) klass)->cleanup = gsd_async_operation_real_cleanup;
	((GsdAsyncOperationClass *) klass)->get_max_progress = gsd_async_operation_real_get_max_progress;
	((GsdAsyncOperationClass *) klass)->get_progress = gsd_async_operation_real_get_progress;
	((GsdAsyncOperationClass *) klass)->get_subprocess_error_msg = gsd_async_operation_real_get_subprocess_error_msg;
	((GsdAsyncOperationClass *) klass)->classify_exit_status = gsd_async_operation_real_classify_exit_status;
	G_OBJECT_CLASS (klass)->get_property = _vala_gsd_async_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gsd_async_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = gsd_async_operation_finalize;
	/**
	     * The path to the command to spawn.
	     * 
	     * Setting it to null resets it to its default value.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_ASYNC_OPERATION_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * Whether the operation object is busy.
	     * 
	     * A busy operation cannot be reused until it gets ready again.
	     * An operation is busy when it is currently doing a job.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_ASYNC_OPERATION_BUSY, g_param_spec_boolean ("busy", "busy", "busy", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	     * This signal is emitted when the operation just terminated.
	     * 
	     * @param success whether the operation succeed.
	     * @param message any error or warning message.
	     */
	g_signal_new ("finished", GSD_TYPE_ASYNC_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_STRING, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_STRING);
	/**
	     * This signal is emitted when the progress status of the operation changes.
	     * 
	     * @param fraction the current progress, from 0.0 to 1.0.
	     */
	g_signal_new ("progress", GSD_TYPE_ASYNC_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__DOUBLE, G_TYPE_NONE, 1, G_TYPE_DOUBLE);
}


static void gsd_async_operation_instance_init (GsdAsyncOperation * self) {
	self->priv = GSD_ASYNC_OPERATION_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock__busy);
	self->priv->_busy = FALSE;
	self->priv->_path = NULL;
	self->priv->_path_default = NULL;
}


static void gsd_async_operation_finalize (GObject* obj) {
	GsdAsyncOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation);
	g_rec_mutex_clear (&self->priv->__lock__busy);
	_g_free0 (self->priv->_path);
	_g_free0 (self->priv->_path_default);
	G_OBJECT_CLASS (gsd_async_operation_parent_class)->finalize (obj);
}


/**
   * An asynchronous process spawner, with support for progression and success
   * report.
   * 
   * This is a base class designed to be subclassed by actual spawners, with
   * as less efforts as possible.
   * 
   * To subclass this class, the only thing you need to implement is the
   * argument builder, that gives the arguments of the spawned command; and you
   * need to set the AsyncOperation::path property to the command to spawn in
   * your constructor too (hence it is not required, it is slightly better to
   * set it since it must be set before calling run() or run_sync() - or getting
   * it).
   * This said, you may want to override get_max_progress() and get_progress()
   * to add actual progress support; and build_env() to provide a specific
   * environment to your command.
   * 
   * =Important note=
   * 
   * As this class uses a timeout function to watch the child, you need a GLib
   * MainLoop for the watching process to work for the asynchronous method.
   * 
   * =Simple usage of an hypothetical FooOperation subclass=
   * 
   * {{{
   * var foo = new FooOperation();
   * 
   * // Connect the finish callback
   * foo.finished.connect ((success, error) => {
   *                         if (success) {
   *                           stdout.printf ("success!\n");
   *                         } else {
   *                           stderr.printf ("failure: %s\n", error);
   *                         }
   *                       });
   * // and the progress callback
   * foo.progress.connect ((progress) => {
   *                         stdout.printf ("\r%.0f%%", progress * 100);
   *                       });
   * foo.run ();
   * 
   * var loop = GLib.MainLoop (null, false);
   * loop.run ();
   * }}}
   */
GType gsd_async_operation_get_type (void) {
	static volatile gsize gsd_async_operation_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_async_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GsdAsyncOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsd_async_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GsdAsyncOperation), 0, (GInstanceInitFunc) gsd_async_operation_instance_init, NULL };
		GType gsd_async_operation_type_id;
		gsd_async_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "GsdAsyncOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gsd_async_operation_type_id__volatile, gsd_async_operation_type_id);
	}
	return gsd_async_operation_type_id__volatile;
}


static void _vala_gsd_async_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GsdAsyncOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation);
	switch (property_id) {
		case GSD_ASYNC_OPERATION_PATH:
		g_value_set_string (value, gsd_async_operation_get_path (self));
		break;
		case GSD_ASYNC_OPERATION_BUSY:
		g_value_set_boolean (value, gsd_async_operation_get_busy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gsd_async_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GsdAsyncOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation);
	switch (property_id) {
		case GSD_ASYNC_OPERATION_PATH:
		gsd_async_operation_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



