package Locales::DB::Language::bg;

use strict;
use warnings;

# Auto generated from CLDR

$Locales::DB::Language::bg::VERSION = '0.09';

$Locales::DB::Language::bg::cldr_version = '2.0';

%Locales::DB::Language::bg::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\ \{1\}"
        },
        'language' => "Language\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ и\ \{1\}",
            'end'    => "\{0\}\ и\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '’',
        'alternate_quotation_start' => '‘',
        'quotation_end'             => '“',
        'quotation_start'           => '„'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
              }
        }
    },
    'posix' => {
        'nostr'  => "не\:н",
        'yesstr' => "да\:д"
    },
);

%Locales::DB::Language::bg::code_to_name = (
    'aa'     => 'афар',
    'ab'     => 'абхазски',
    'ace'    => 'ачински',
    'ach'    => 'аколи',
    'ada'    => 'адангме',
    'ady'    => 'адиге',
    'ae'     => 'авестски',
    'af'     => 'африканс',
    'afa'    => "афро\-азиатски",
    'afh'    => 'африхили',
    'agq'    => 'Aghem',
    'ain'    => 'айну',
    'ak'     => 'акан',
    'akk'    => 'акадски',
    'ale'    => 'алеутски',
    'alg'    => 'алгонквин',
    'alt'    => 'южноалтайски',
    'am'     => 'амхарски',
    'an'     => 'арагонски',
    'ang'    => 'староанглийски',
    'anp'    => 'ангика',
    'apa'    => "езици\ на\ апахите",
    'ar'     => 'арабски',
    'arc'    => 'арамейски',
    'arn'    => 'мапуче',
    'arp'    => 'арапахо',
    'art'    => 'изкуствен',
    'arw'    => 'аравак',
    'as'     => 'асамски',
    'asa'    => 'Asu',
    'ast'    => 'астурски',
    'ath'    => "атабаски\ езици",
    'aus'    => "австралийски\ езици",
    'av'     => 'аварски',
    'awa'    => 'авади',
    'ay'     => 'аймара',
    'az'     => 'азербайджански',
    'ba'     => 'башкирски',
    'bad'    => 'банда',
    'bai'    => 'бамикеле',
    'bal'    => 'балучи',
    'ban'    => 'балинейски',
    'bas'    => 'баса',
    'bat'    => 'балтийски',
    'be'     => 'беларуски',
    'bej'    => 'бея',
    'bem'    => 'бемба',
    'ber'    => 'берберски',
    'bez'    => 'Bena',
    'bg'     => 'български',
    'bh'     => 'бихари',
    'bho'    => 'божпури',
    'bi'     => 'бислама',
    'bik'    => 'биколски',
    'bin'    => 'бини',
    'bla'    => 'сиксика',
    'bm'     => 'бамбара',
    'bn'     => 'бенгалски',
    'bnt'    => 'банту',
    'bo'     => 'тибетски',
    'br'     => 'бретонски',
    'bra'    => 'брадж',
    'brx'    => 'Bodo',
    'bs'     => 'босненски',
    'btk'    => 'батак',
    'bua'    => 'бурятски',
    'bug'    => 'бугински',
    'byn'    => 'биленски',
    'ca'     => 'каталонски',
    'cad'    => 'каддо',
    'cai'    => "централноамерикански\ индиански",
    'car'    => 'карибски',
    'cau'    => 'кавказски',
    'cay'    => 'Cayuga',
    'cch'    => 'атсам',
    'ce'     => 'чеченски',
    'ceb'    => 'себуано',
    'cel'    => 'келтски',
    'cgg'    => 'Chiga',
    'ch'     => 'чаморо',
    'chb'    => 'чибча',
    'chg'    => 'чагатай',
    'chk'    => 'чуук',
    'chm'    => 'марийски',
    'chn'    => "жаргон\ чинуук",
    'cho'    => 'чокто',
    'chp'    => 'чиипувски',
    'chr'    => 'чероки',
    'chy'    => 'чейенски',
    'cmc'    => 'чамски',
    'co'     => 'корсикански',
    'cop'    => 'коптски',
    'cpe'    => "креолски\ или\ пиджин\ от\ английски",
    'cpf'    => "креолски\ и\ пиджин\ от\ френски",
    'cpp'    => "креолски\ или\ пиджин\ от\ португалски",
    'cr'     => 'крии',
    'crh'    => 'кримскотатарски',
    'crp'    => "креолски\ или\ пиджини",
    'cs'     => 'чешки',
    'csb'    => 'кашубски',
    'cu'     => "църковно\ славянски",
    'cus'    => "кушитски\ езици",
    'cv'     => 'чувашки',
    'cy'     => 'уелски',
    'da'     => 'датски',
    'dak'    => 'дакотски',
    'dar'    => 'даргва',
    'dav'    => 'Taita',
    'day'    => 'даякски',
    'de'     => 'немски',
    'de_at'  => "австрийски\ немски",
    'de_ch'  => "швейцарски\ горногермански",
    'del'    => 'делауер',
    'den'    => 'слейви',
    'dgr'    => 'догриб',
    'din'    => 'динка',
    'dje'    => 'Zarma',
    'doi'    => 'догри',
    'dra'    => "дравидски\ езици",
    'dsb'    => 'долносербски',
    'dua'    => 'дуала',
    'dum'    => "средновековен\ холандски",
    'dv'     => 'дивехи',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'диула',
    'dz'     => 'дзонха',
    'ebu'    => 'Embu',
    'ee'     => 'еуе',
    'efi'    => 'ефик',
    'egy'    => 'египетски',
    'eka'    => 'екажук',
    'el'     => 'гръцки',
    'elx'    => 'еламитски',
    'en'     => 'английски',
    'en_au'  => "австралийски\ английски",
    'en_ca'  => "канадски\ английски",
    'en_gb'  => "британски\ английски",
    'en_us'  => "американски\ английски",
    'enm'    => "средновековен\ английски",
    'eo'     => 'есперанто',
    'es'     => 'испански',
    'es_419' => "латиноамерикански\ испански",
    'es_es'  => "иберийски\ испански",
    'et'     => 'естонски',
    'eu'     => 'баски',
    'ewo'    => 'евондо',
    'fa'     => 'персийски',
    'fan'    => 'фанг',
    'fat'    => 'фанти',
    'ff'     => 'фула',
    'fi'     => 'фински',
    'fil'    => 'филипински',
    'fiu'    => 'угрофински',
    'fj'     => 'фиджийски',
    'fo'     => 'фарьорски',
    'fon'    => 'фон',
    'fr'     => 'френски',
    'fr_ca'  => "канадски\ френски",
    'fr_ch'  => "швейцарски\ френски",
    'frm'    => "средновековен\ френски",
    'fro'    => 'старофренски',
    'frr'    => "северен\ фризски",
    'frs'    => "източен\ фризски",
    'fur'    => 'фриулиански',
    'fy'     => 'фризийски',
    'ga'     => 'ирландски',
    'gaa'    => 'га',
    'gay'    => 'гайо',
    'gba'    => 'гбая',
    'gd'     => "шотландски\ галски",
    'gem'    => 'германски',
    'gez'    => 'гииз',
    'gil'    => 'гилбертски',
    'gl'     => 'галисийски',
    'gmh'    => "средновековен\ немски",
    'gn'     => 'гуарани',
    'goh'    => 'старовисоконемски',
    'gon'    => 'гонди',
    'gor'    => 'горонтало',
    'got'    => 'готически',
    'grb'    => 'гребо',
    'grc'    => 'древногръцки',
    'gsw'    => "швейцарски\ немски",
    'gu'     => 'гуджарати',
    'guz'    => 'Gusii',
    'gv'     => 'манкски',
    'gwi'    => 'гвичин',
    'ha'     => 'хауза',
    'hai'    => 'хайда',
    'haw'    => 'хавайски',
    'he'     => 'иврит',
    'hi'     => 'хинди',
    'hil'    => 'хилигайнон',
    'him'    => 'химачали',
    'hit'    => 'хитски',
    'hmn'    => 'хмонг',
    'ho'     => "хири\ моту",
    'hr'     => 'хърватски',
    'hsb'    => 'горносербски',
    'ht'     => 'хаитянски',
    'hu'     => 'унгарски',
    'hup'    => 'хупа',
    'hy'     => 'арменски',
    'hz'     => 'хереро',
    'ia'     => 'интерлингва',
    'iba'    => 'ибан',
    'id'     => 'индонезийски',
    'ie'     => 'оксидентал',
    'ig'     => 'игбо',
    'ii'     => 'сечуански',
    'ijo'    => 'иджо',
    'ik'     => 'инупиак',
    'ilo'    => 'илоко',
    'inc'    => "индийска\ група",
    'ine'    => "индо\-европейски",
    'inh'    => 'ингушетски',
    'io'     => 'идо',
    'ira'    => 'ирански',
    'iro'    => "ироквиански\ езици",
    'is'     => 'исландски',
    'it'     => 'италиански',
    'iu'     => 'инуктитут',
    'ja'     => 'японски',
    'jbo'    => 'лоджбан',
    'jmc'    => 'Machame',
    'jpr'    => "еврейско\-персийски",
    'jrb'    => "еврейско\-арабски",
    'jv'     => 'явански',
    'ka'     => 'грузински',
    'kaa'    => 'каракалпашки',
    'kab'    => 'кабилски',
    'kac'    => 'качински',
    'kaj'    => 'жжи',
    'kam'    => 'камба',
    'kar'    => 'каренски',
    'kaw'    => 'кави',
    'kbd'    => 'кабардиан',
    'kcg'    => 'туап',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'коро',
    'kg'     => 'конгоански',
    'kha'    => 'кхаси',
    'khi'    => "езици\ коисан",
    'kho'    => 'котски',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'кикуйу',
    'kj'     => 'кваняма',
    'kk'     => 'казахски',
    'kl'     => "гренландски\ ескимоски",
    'kln'    => 'Kalenjin',
    'km'     => 'кхмерски',
    'kmb'    => 'кимбунду',
    'kn'     => 'каннада',
    'ko'     => 'корейски',
    'kok'    => 'конкани',
    'kos'    => 'косраен',
    'kpe'    => 'кпеле',
    'kr'     => 'канури',
    'krc'    => "карачай\-балкарски",
    'krl'    => 'карелски',
    'kro'    => 'кру',
    'kru'    => 'курук',
    'ks'     => 'кашмирски',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'кюрдски',
    'kum'    => 'кумикски',
    'kut'    => 'кутенай',
    'kv'     => 'Коми',
    'kw'     => "корнуолски\ келтски",
    'ky'     => 'киргизски',
    'la'     => 'латински',
    'lad'    => 'ладино',
    'lag'    => 'Langi',
    'lah'    => 'лахнда',
    'lam'    => 'ламба',
    'lb'     => 'люксембургски',
    'lez'    => 'лезгински',
    'lg'     => 'ганда',
    'li'     => 'лимбургски',
    'ln'     => 'лингала',
    'lo'     => 'лаоски',
    'lol'    => 'монго',
    'loz'    => 'лози',
    'lt'     => 'литовски',
    'lu'     => "луба\ катанга",
    'lua'    => "луба\-лулуа",
    'lui'    => 'луисеньо',
    'lun'    => 'лунда',
    'luo'    => 'луо',
    'lus'    => 'лушаи',
    'luy'    => 'Luyia',
    'lv'     => 'латвийски',
    'mad'    => 'мадурски',
    'mag'    => 'магахи',
    'mai'    => 'майтхили',
    'mak'    => 'макасар',
    'man'    => 'мандинго',
    'map'    => 'австронезийски',
    'mas'    => 'масайски',
    'mdf'    => 'мокша',
    'mdr'    => 'мандар',
    'men'    => 'менде',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'малгашки',
    'mga'    => "средновековен\ ирландски",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'маршалезе',
    'mi'     => 'маорски',
    'mic'    => 'микмак',
    'min'    => 'минангбау',
    'mis'    => "други\ езици",
    'mk'     => 'македонски',
    'mkh'    => "мон\-кхмерски\ език",
    'ml'     => 'малаялам',
    'mn'     => 'монголски',
    'mnc'    => 'манчжурски',
    'mni'    => 'манипури',
    'mno'    => 'манобо',
    'mo'     => 'молдовски',
    'moh'    => 'мохавк',
    'mos'    => 'моси',
    'mr'     => 'маратхи',
    'ms'     => 'малайски',
    'mt'     => 'малтийски',
    'mua'    => 'Mundang',
    'mul'    => 'многоезични',
    'mun'    => 'мунда',
    'mus'    => 'крик',
    'mwl'    => 'мирандийски',
    'mwr'    => 'марвари',
    'my'     => 'бирмански',
    'myn'    => "майя\ език",
    'myv'    => 'ерзиа',
    'na'     => 'науру',
    'nah'    => 'нахуатл',
    'nai'    => "северноамерикански\ индиански",
    'nap'    => 'неаполитански',
    'naq'    => 'Nama',
    'nb'     => "норвежки\ бокмал",
    'nd'     => "северен\ ндебеле",
    'nds'    => 'долносаксонски',
    'ne'     => 'непалски',
    'new'    => 'неварски',
    'ng'     => 'ндонга',
    'nia'    => 'ниас',
    'nic'    => "нигер\-кордофански",
    'niu'    => 'ниуеан',
    'nl'     => 'холандски',
    'nl_be'  => 'фламандски',
    'nmg'    => 'Kwasio',
    'nn'     => "съвременен\ норвежки",
    'no'     => 'норвежки',
    'nog'    => 'ногаи',
    'non'    => 'старонорвежски',
    'nqo'    => 'н’ко',
    'nr'     => "южен\ ндебеле",
    'nso'    => "северен\ сото",
    'nub'    => "нубийски\ езици",
    'nus'    => 'Nuer',
    'nv'     => 'навахо',
    'nwc'    => "класически\ невари",
    'ny'     => 'чинянджа',
    'nym'    => 'ниамвези',
    'nyn'    => 'нианколе',
    'nyo'    => 'нуоро',
    'nzi'    => 'нзима',
    'oc'     => 'окситански',
    'oj'     => 'оджибва',
    'om'     => 'оромо',
    'or'     => 'ория',
    'os'     => 'осетски',
    'osa'    => 'оседжи',
    'ota'    => "отомански\ турски",
    'oto'    => "старотурски\ езици",
    'pa'     => 'пенджабски',
    'paa'    => 'папуаски',
    'pag'    => 'пангасинан',
    'pal'    => 'пехлевийски',
    'pam'    => 'пампанга',
    'pap'    => 'папиаменту',
    'pau'    => 'палауан',
    'peo'    => 'староперсийски',
    'phi'    => "филипински\ \(други\)",
    'phn'    => 'финикийски',
    'pi'     => 'пали',
    'pl'     => 'полски',
    'pon'    => 'похнпеиан',
    'pra'    => "пракритски\ език",
    'pro'    => 'провансалски',
    'ps'     => 'пущу',
    'pt'     => 'португалски',
    'pt_br'  => "бразилски\ португалски",
    'pt_pt'  => "европейски\ португалски",
    'qu'     => 'кечуа',
    'raj'    => 'раджастански',
    'rap'    => "рапа\ нуи",
    'rar'    => 'рапотонган',
    'rm'     => 'реторомански',
    'rn'     => 'рунди',
    'ro'     => 'румънски',
    'roa'    => 'романски',
    'rof'    => 'Rombo',
    'rom'    => "цигански\ език",
    'ru'     => 'руски',
    'rup'    => 'арумънски',
    'rw'     => 'киняруанда',
    'rwk'    => 'Rwa',
    'sa'     => 'санкскритски',
    'sad'    => 'сандве',
    'sah'    => 'якутски',
    'sai'    => "южноамерикански\ индиански",
    'sal'    => "салишански\ език",
    'sam'    => "самаритански\ арамейски",
    'saq'    => 'Samburu',
    'sas'    => 'сасак',
    'sat'    => 'сантали',
    'sbp'    => 'Sangu',
    'sc'     => 'сардински',
    'scn'    => 'сицилиански',
    'sco'    => 'шотландски',
    'sd'     => 'синдхи',
    'se'     => "северен\ сами",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'селкуп',
    'sem'    => 'семитски',
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'санго',
    'sga'    => 'староирландски',
    'sgn'    => "жестомимичен\ език",
    'sh'     => 'сърбохърватски',
    'shi'    => 'Tachelhit',
    'shn'    => 'шан',
    'si'     => 'синхалски',
    'sid'    => 'сидамо',
    'sio'    => "език\ сиу",
    'sit'    => 'синотибетски',
    'sk'     => 'словашки',
    'sl'     => 'словенски',
    'sla'    => 'славянски',
    'sm'     => 'самоански',
    'sma'    => 'южносаамски',
    'smi'    => "саамски\ езици",
    'smj'    => "луле\-саамски",
    'smn'    => "инари\-саамски",
    'sms'    => "сколт\-саамски",
    'sn'     => 'шона',
    'snk'    => 'сонинке',
    'so'     => 'сомалийски',
    'sog'    => 'согдийски',
    'son'    => 'сонгхай',
    'sq'     => 'албански',
    'sr'     => 'сръбски',
    'srn'    => "сранан\ тонго",
    'srr'    => 'серер',
    'ss'     => 'суази',
    'ssa'    => "нило\-сахарски\ език",
    'ssy'    => 'Saho',
    'st'     => 'сесуто',
    'su'     => 'сундански',
    'suk'    => 'сукума',
    'sus'    => 'сусу',
    'sux'    => 'шумерски',
    'sv'     => 'шведски',
    'sw'     => 'суахили',
    'swb'    => 'коморски',
    'swc'    => "Congo\ Swahili",
    'syc'    => "класически\ сирийски",
    'syr'    => 'сирийски',
    'ta'     => 'тамилски',
    'tai'    => 'тайландски',
    'te'     => 'телугу',
    'tem'    => 'темне',
    'teo'    => 'Teso',
    'ter'    => 'терено',
    'tet'    => 'тетум',
    'tg'     => 'таджикски',
    'th'     => 'таи',
    'ti'     => 'тигриня',
    'tig'    => 'тигре',
    'tiv'    => 'тив',
    'tk'     => 'туркменски',
    'tkl'    => 'токелайски',
    'tl'     => 'тагалог',
    'tlh'    => 'клингон',
    'tli'    => 'тлингит',
    'tmh'    => 'тамашек',
    'tn'     => 'тсвана',
    'to'     => 'тонга',
    'tog'    => "нианса\ тонга",
    'tpi'    => "ток\ писин",
    'tr'     => 'турски',
    'trv'    => 'Taroko',
    'ts'     => 'тсонга',
    'tsi'    => 'цимшиански',
    'tt'     => 'татарски',
    'tum'    => 'тумбука',
    'tup'    => 'тупи',
    'tut'    => 'алтайски',
    'tvl'    => 'тувалуански',
    'tw'     => 'туи',
    'twq'    => 'Tasawaq',
    'ty'     => 'таитянски',
    'tyv'    => 'тувински',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'удмуртски',
    'ug'     => 'уйгурски',
    'uga'    => 'угаритски',
    'uk'     => 'украински',
    'umb'    => 'умбунду',
    'und'    => 'неопределен',
    'ur'     => 'урду',
    'uz'     => 'узбекски',
    'vai'    => 'ваи',
    've'     => 'венда',
    'vi'     => 'виетнамски',
    'vo'     => 'волапюк',
    'vot'    => 'вотик',
    'vun'    => 'Vunjo',
    'wa'     => 'валонски',
    'wae'    => 'Walser',
    'wak'    => "вакашански\ език",
    'wal'    => 'валамо',
    'war'    => 'варай',
    'was'    => 'уашо',
    'wen'    => "лужишки\ език",
    'wo'     => 'волоф',
    'xal'    => 'калмик',
    'xh'     => 'ксоса',
    'xog'    => 'Soga',
    'yao'    => 'яо',
    'yap'    => 'япезе',
    'yav'    => 'Yangben',
    'yi'     => 'идиш',
    'yo'     => 'йоруба',
    'ypk'    => 'юпик',
    'yue'    => 'кантонски',
    'za'     => 'зуанг',
    'zap'    => 'запотек',
    'zbl'    => "блис\ символи",
    'zen'    => 'зенага',
    'zh'     => 'китайски',
    'znd'    => 'занде',
    'zu'     => 'зулуски',
    'zun'    => 'зуни',
    'zxx'    => "без\ лингвистично\ съдържание",
    'zza'    => 'заза',
);

%Locales::DB::Language::bg::name_to_code = (
    'aghem'                                                        => 'agq',
    'asu'                                                          => 'asa',
    'bafia'                                                        => 'ksf',
    'bena'                                                         => 'bez',
    'bodo'                                                         => 'brx',
    'cayuga'                                                       => 'cay',
    'centralmoroccotamazight'                                      => 'tzm',
    'chiga'                                                        => 'cgg',
    'colognian'                                                    => 'ksh',
    'congoswahili'                                                 => 'swc',
    'embu'                                                         => 'ebu',
    'gusii'                                                        => 'guz',
    'jolafonyi'                                                    => 'dyo',
    'kabuverdianu'                                                 => 'kea',
    'kalenjin'                                                     => 'kln',
    'koyraborosenni'                                               => 'ses',
    'koyrachiini'                                                  => 'khq',
    'kwasio'                                                       => 'nmg',
    'langi'                                                        => 'lag',
    'luyia'                                                        => 'luy',
    'machame'                                                      => 'jmc',
    'makhuwameetto'                                                => 'mgh',
    'makonde'                                                      => 'kde',
    'meru'                                                         => 'mer',
    'morisyen'                                                     => 'mfe',
    'mundang'                                                      => 'mua',
    'nama'                                                         => 'naq',
    'nuer'                                                         => 'nus',
    'rombo'                                                        => 'rof',
    'rwa'                                                          => 'rwk',
    'saho'                                                         => 'ssy',
    'samburu'                                                      => 'saq',
    'sangu'                                                        => 'sbp',
    'sena'                                                         => 'seh',
    'seneca'                                                       => 'see',
    'shambala'                                                     => 'ksb',
    'soga'                                                         => 'xog',
    'tachelhit'                                                    => 'shi',
    'taita'                                                        => 'dav',
    'taroko'                                                       => 'trv',
    'tasawaq'                                                      => 'twq',
    'teso'                                                         => 'teo',
    'vunjo'                                                        => 'vun',
    'walser'                                                       => 'wae',
    'yangben'                                                      => 'yav',
    'zarma'                                                        => 'dje',
    'Коми'                                                     => 'kv',
    'абхазски'                                             => 'ab',
    'авади'                                                   => 'awa',
    'аварски'                                               => 'av',
    'авестски'                                             => 'ae',
    'австралийскианглийски'                   => 'en_au',
    'австралийскиезици'                           => 'aus',
    'австрийскинемски'                             => 'de_at',
    'австронезийски'                                 => 'map',
    'адангме'                                               => 'ada',
    'адиге'                                                   => 'ady',
    'азербайджански'                                 => 'az',
    'аймара'                                                 => 'ay',
    'айну'                                                     => 'ain',
    'акадски'                                               => 'akk',
    'акан'                                                     => 'ak',
    'аколи'                                                   => 'ach',
    'албански'                                             => 'sq',
    'алгонквин'                                           => 'alg',
    'алеутски'                                             => 'ale',
    'алтайски'                                             => 'tut',
    'американскианглийски'                     => 'en_us',
    'амхарски'                                             => 'am',
    'ангика'                                                 => 'anp',
    'английски'                                           => 'en',
    'арабски'                                               => 'ar',
    'аравак'                                                 => 'arw',
    'арагонски'                                           => 'an',
    'арамейски'                                           => 'arc',
    'арапахо'                                               => 'arp',
    'арменски'                                             => 'hy',
    'арумънски'                                           => 'rup',
    'асамски'                                               => 'as',
    'астурски'                                             => 'ast',
    'атабаскиезици'                                   => 'ath',
    'атсам'                                                   => 'cch',
    'афар'                                                     => 'aa',
    'африканс'                                             => 'af',
    'африхили'                                             => 'afh',
    'афроазиатски'                                     => 'afa',
    'ачински'                                               => 'ace',
    'балинейски'                                         => 'ban',
    'балтийски'                                           => 'bat',
    'балучи'                                                 => 'bal',
    'бамбара'                                               => 'bm',
    'бамикеле'                                             => 'bai',
    'банда'                                                   => 'bad',
    'банту'                                                   => 'bnt',
    'баса'                                                     => 'bas',
    'баски'                                                   => 'eu',
    'батак'                                                   => 'btk',
    'башкирски'                                           => 'ba',
    'безлингвистичносъдържание'           => 'zxx',
    'беларуски'                                           => 'be',
    'бемба'                                                   => 'bem',
    'бенгалски'                                           => 'bn',
    'берберски'                                           => 'ber',
    'бея'                                                       => 'bej',
    'биколски'                                             => 'bik',
    'биленски'                                             => 'byn',
    'бини'                                                     => 'bin',
    'бирмански'                                           => 'my',
    'бислама'                                               => 'bi',
    'бихари'                                                 => 'bh',
    'блиссимволи'                                       => 'zbl',
    'божпури'                                               => 'bho',
    'босненски'                                           => 'bs',
    'брадж'                                                   => 'bra',
    'бразилскипортугалски'                     => 'pt_br',
    'бретонски'                                           => 'br',
    'британскианглийски'                         => 'en_gb',
    'бугински'                                             => 'bug',
    'бурятски'                                             => 'bua',
    'български'                                           => 'bg',
    'ваи'                                                       => 'vai',
    'вакашанскиезик'                                 => 'wak',
    'валамо'                                                 => 'wal',
    'валонски'                                             => 'wa',
    'варай'                                                   => 'war',
    'венда'                                                   => 've',
    'виетнамски'                                         => 'vi',
    'волапюк'                                               => 'vo',
    'волоф'                                                   => 'wo',
    'вотик'                                                   => 'vot',
    'га'                                                         => 'gaa',
    'гайо'                                                     => 'gay',
    'галисийски'                                         => 'gl',
    'ганда'                                                   => 'lg',
    'гбая'                                                     => 'gba',
    'гвичин'                                                 => 'gwi',
    'германски'                                           => 'gem',
    'гииз'                                                     => 'gez',
    'гилбертски'                                         => 'gil',
    'гонди'                                                   => 'gon',
    'горносербски'                                     => 'hsb',
    'горонтало'                                           => 'gor',
    'готически'                                           => 'got',
    'гребо'                                                   => 'grb',
    'гренландскиескимоски'                     => 'kl',
    'грузински'                                           => 'ka',
    'гръцки'                                                 => 'el',
    'гуарани'                                               => 'gn',
    'гуджарати'                                           => 'gu',
    'дакотски'                                             => 'dak',
    'даргва'                                                 => 'dar',
    'датски'                                                 => 'da',
    'даякски'                                               => 'day',
    'делауер'                                               => 'del',
    'дзонха'                                                 => 'dz',
    'дивехи'                                                 => 'dv',
    'динка'                                                   => 'din',
    'диула'                                                   => 'dyu',
    'догри'                                                   => 'doi',
    'догриб'                                                 => 'dgr',
    'долносаксонски'                                 => 'nds',
    'долносербски'                                     => 'dsb',
    'дравидскиезици'                                 => 'dra',
    'древногръцки'                                     => 'grc',
    'другиезици'                                         => 'mis',
    'дуала'                                                   => 'dua',
    'евондо'                                                 => 'ewo',
    'еврейскоарабски'                               => 'jrb',
    'еврейскоперсийски'                           => 'jpr',
    'европейскипортугалски'                   => 'pt_pt',
    'египетски'                                           => 'egy',
    'езиксиу'                                               => 'sio',
    'езицикоисан'                                       => 'khi',
    'езицинаапахите'                                 => 'apa',
    'екажук'                                                 => 'eka',
    'еламитски'                                           => 'elx',
    'ерзиа'                                                   => 'myv',
    'есперанто'                                           => 'eo',
    'естонски'                                             => 'et',
    'еуе'                                                       => 'ee',
    'ефик'                                                     => 'efi',
    'жаргончинуук'                                     => 'chn',
    'жестомимиченезик'                             => 'sgn',
    'жжи'                                                       => 'kaj',
    'заза'                                                     => 'zza',
    'занде'                                                   => 'znd',
    'запотек'                                               => 'zap',
    'зенага'                                                 => 'zen',
    'зуанг'                                                   => 'za',
    'зулуски'                                               => 'zu',
    'зуни'                                                     => 'zun',
    'ибан'                                                     => 'iba',
    'иберийскииспански'                           => 'es_es',
    'иврит'                                                   => 'he',
    'игбо'                                                     => 'ig',
    'иджо'                                                     => 'ijo',
    'идиш'                                                     => 'yi',
    'идо'                                                       => 'io',
    'изкуствен'                                           => 'art',
    'източенфризски'                                 => 'frs',
    'илоко'                                                   => 'ilo',
    'инарисаамски'                                     => 'smn',
    'ингушетски'                                         => 'inh',
    'индийскагрупа'                                   => 'inc',
    'индоевропейски'                                 => 'ine',
    'индонезийски'                                     => 'id',
    'интерлингва'                                       => 'ia',
    'инуктитут'                                           => 'iu',
    'инупиак'                                               => 'ik',
    'ирански'                                               => 'ira',
    'ирландски'                                           => 'ga',
    'ироквианскиезици'                             => 'iro',
    'исландски'                                           => 'is',
    'испански'                                             => 'es',
    'италиански'                                         => 'it',
    'йоруба'                                                 => 'yo',
    'кабардиан'                                           => 'kbd',
    'кабилски'                                             => 'kab',
    'кави'                                                     => 'kaw',
    'кавказски'                                           => 'cau',
    'каддо'                                                   => 'cad',
    'казахски'                                             => 'kk',
    'калмик'                                                 => 'xal',
    'камба'                                                   => 'kam',
    'канадскианглийски'                           => 'en_ca',
    'канадскифренски'                               => 'fr_ca',
    'каннада'                                               => 'kn',
    'кантонски'                                           => 'yue',
    'канури'                                                 => 'kr',
    'каракалпашки'                                     => 'kaa',
    'карачайбалкарски'                             => 'krc',
    'карелски'                                             => 'krl',
    'каренски'                                             => 'kar',
    'карибски'                                             => 'car',
    'каталонски'                                         => 'ca',
    'качински'                                             => 'kac',
    'кашмирски'                                           => 'ks',
    'кашубски'                                             => 'csb',
    'кваняма'                                               => 'kj',
    'келтски'                                               => 'cel',
    'кечуа'                                                   => 'qu',
    'кикуйу'                                                 => 'ki',
    'кимбунду'                                             => 'kmb',
    'киняруанда'                                         => 'rw',
    'киргизски'                                           => 'ky',
    'китайски'                                             => 'zh',
    'класическиневари'                             => 'nwc',
    'класическисирийски'                         => 'syc',
    'клингон'                                               => 'tlh',
    'коморски'                                             => 'swb',
    'конгоански'                                         => 'kg',
    'конкани'                                               => 'kok',
    'коптски'                                               => 'cop',
    'корейски'                                             => 'ko',
    'корнуолскикелтски'                           => 'kw',
    'коро'                                                     => 'kfo',
    'корсикански'                                       => 'co',
    'косраен'                                               => 'kos',
    'котски'                                                 => 'kho',
    'кпеле'                                                   => 'kpe',
    'креолскиилипиджини'                         => 'crp',
    'креолскиилипиджинотанглийски'     => 'cpe',
    'креолскиилипиджинотпортугалски' => 'cpp',
    'креолскиипиджинотфренски'             => 'cpf',
    'крии'                                                     => 'cr',
    'крик'                                                     => 'mus',
    'кримскотатарски'                               => 'crh',
    'кру'                                                       => 'kro',
    'ксоса'                                                   => 'xh',
    'кумикски'                                             => 'kum',
    'курук'                                                   => 'kru',
    'кутенай'                                               => 'kut',
    'кушитскиезици'                                   => 'cus',
    'кхаси'                                                   => 'kha',
    'кхмерски'                                             => 'km',
    'кюрдски'                                               => 'ku',
    'ладино'                                                 => 'lad',
    'ламба'                                                   => 'lam',
    'лаоски'                                                 => 'lo',
    'латвийски'                                           => 'lv',
    'латиноамериканскииспански'           => 'es_419',
    'латински'                                             => 'la',
    'лахнда'                                                 => 'lah',
    'лезгински'                                           => 'lez',
    'лимбургски'                                         => 'li',
    'лингала'                                               => 'ln',
    'литовски'                                             => 'lt',
    'лоджбан'                                               => 'jbo',
    'лози'                                                     => 'loz',
    'лубакатанга'                                       => 'lu',
    'лубалулуа'                                           => 'lua',
    'лужишкиезик'                                       => 'wen',
    'луисеньо'                                             => 'lui',
    'лулесаамски'                                       => 'smj',
    'лунда'                                                   => 'lun',
    'луо'                                                       => 'luo',
    'лушаи'                                                   => 'lus',
    'люксембургски'                                   => 'lb',
    'магахи'                                                 => 'mag',
    'мадурски'                                             => 'mad',
    'майтхили'                                             => 'mai',
    'майяезик'                                             => 'myn',
    'макасар'                                               => 'mak',
    'македонски'                                         => 'mk',
    'малайски'                                             => 'ms',
    'малаялам'                                             => 'ml',
    'малгашки'                                             => 'mg',
    'малтийски'                                           => 'mt',
    'мандар'                                                 => 'mdr',
    'мандинго'                                             => 'man',
    'манипури'                                             => 'mni',
    'манкски'                                               => 'gv',
    'манобо'                                                 => 'mno',
    'манчжурски'                                         => 'mnc',
    'маорски'                                               => 'mi',
    'мапуче'                                                 => 'arn',
    'маратхи'                                               => 'mr',
    'марвари'                                               => 'mwr',
    'марийски'                                             => 'chm',
    'маршалезе'                                           => 'mh',
    'масайски'                                             => 'mas',
    'менде'                                                   => 'men',
    'микмак'                                                 => 'mic',
    'минангбау'                                           => 'min',
    'мирандийски'                                       => 'mwl',
    'многоезични'                                       => 'mul',
    'мокша'                                                   => 'mdf',
    'молдовски'                                           => 'mo',
    'монго'                                                   => 'lol',
    'монголски'                                           => 'mn',
    'монкхмерскиезик'                               => 'mkh',
    'моси'                                                     => 'mos',
    'мохавк'                                                 => 'moh',
    'мунда'                                                   => 'mun',
    'навахо'                                                 => 'nv',
    'науру'                                                   => 'na',
    'нахуатл'                                               => 'nah',
    'ндонга'                                                 => 'ng',
    'неаполитански'                                   => 'nap',
    'неварски'                                             => 'new',
    'немски'                                                 => 'de',
    'неопределен'                                       => 'und',
    'непалски'                                             => 'ne',
    'нзима'                                                   => 'nzi',
    'ниамвези'                                             => 'nym',
    'нианколе'                                             => 'nyn',
    'ниансатонга'                                       => 'tog',
    'ниас'                                                     => 'nia',
    'нигеркордофански'                             => 'nic',
    'нилосахарскиезик'                             => 'ssa',
    'ниуеан'                                                 => 'niu',
    'ногаи'                                                   => 'nog',
    'норвежки'                                             => 'no',
    'норвежкибокмал'                                 => 'nb',
    'нубийскиезици'                                   => 'nub',
    'нуоро'                                                   => 'nyo',
    'н’ко'                                                    => 'nqo',
    'оджибва'                                               => 'oj',
    'оксидентал'                                         => 'ie',
    'окситански'                                         => 'oc',
    'ория'                                                     => 'or',
    'оромо'                                                   => 'om',
    'оседжи'                                                 => 'osa',
    'осетски'                                               => 'os',
    'отоманскитурски'                               => 'ota',
    'палауан'                                               => 'pau',
    'пали'                                                     => 'pi',
    'пампанга'                                             => 'pam',
    'пангасинан'                                         => 'pag',
    'папиаменту'                                         => 'pap',
    'папуаски'                                             => 'paa',
    'пенджабски'                                         => 'pa',
    'персийски'                                           => 'fa',
    'пехлевийски'                                       => 'pal',
    'полски'                                                 => 'pl',
    'португалски'                                       => 'pt',
    'похнпеиан'                                           => 'pon',
    'пракритскиезик'                                 => 'pra',
    'провансалски'                                     => 'pro',
    'пущу'                                                     => 'ps',
    'раджастански'                                     => 'raj',
    'рапануи'                                               => 'rap',
    'рапотонган'                                         => 'rar',
    'реторомански'                                     => 'rm',
    'романски'                                             => 'roa',
    'румънски'                                             => 'ro',
    'рунди'                                                   => 'rn',
    'руски'                                                   => 'ru',
    'саамскиезици'                                     => 'smi',
    'салишанскиезик'                                 => 'sal',
    'самаританскиарамейски'                   => 'sam',
    'самоански'                                           => 'sm',
    'санго'                                                   => 'sg',
    'сандве'                                                 => 'sad',
    'санкскритски'                                     => 'sa',
    'сантали'                                               => 'sat',
    'сардински'                                           => 'sc',
    'сасак'                                                   => 'sas',
    'себуано'                                               => 'ceb',
    'северенндебеле'                                 => 'nd',
    'северенсами'                                       => 'se',
    'северенсото'                                       => 'nso',
    'северенфризски'                                 => 'frr',
    'северноамериканскииндиански'       => 'nai',
    'селкуп'                                                 => 'sel',
    'семитски'                                             => 'sem',
    'серер'                                                   => 'srr',
    'сесуто'                                                 => 'st',
    'сечуански'                                           => 'ii',
    'сидамо'                                                 => 'sid',
    'сиксика'                                               => 'bla',
    'синдхи'                                                 => 'sd',
    'синотибетски'                                     => 'sit',
    'синхалски'                                           => 'si',
    'сирийски'                                             => 'syr',
    'сицилиански'                                       => 'scn',
    'сколтсаамски'                                     => 'sms',
    'славянски'                                           => 'sla',
    'слейви'                                                 => 'den',
    'словашки'                                             => 'sk',
    'словенски'                                           => 'sl',
    'согдийски'                                           => 'sog',
    'сомалийски'                                         => 'so',
    'сонгхай'                                               => 'son',
    'сонинке'                                               => 'snk',
    'сранантонго'                                       => 'srn',
    'средновековенанглийски'                 => 'enm',
    'средновековенирландски'                 => 'mga',
    'средновековеннемски'                       => 'gmh',
    'средновековенфренски'                     => 'frm',
    'средновековенхоландски'                 => 'dum',
    'сръбски'                                               => 'sr',
    'староанглийски'                                 => 'ang',
    'старовисоконемски'                           => 'goh',
    'староирландски'                                 => 'sga',
    'старонорвежски'                                 => 'non',
    'староперсийски'                                 => 'peo',
    'старотурскиезици'                             => 'oto',
    'старофренски'                                     => 'fro',
    'суази'                                                   => 'ss',
    'суахили'                                               => 'sw',
    'сукума'                                                 => 'suk',
    'сундански'                                           => 'su',
    'сусу'                                                     => 'sus',
    'съвремененнорвежки'                         => 'nn',
    'сърбохърватски'                                 => 'sh',
    'тагалог'                                               => 'tl',
    'таджикски'                                           => 'tg',
    'таи'                                                       => 'th',
    'таитянски'                                           => 'ty',
    'тайландски'                                         => 'tai',
    'тамашек'                                               => 'tmh',
    'тамилски'                                             => 'ta',
    'татарски'                                             => 'tt',
    'телугу'                                                 => 'te',
    'темне'                                                   => 'tem',
    'терено'                                                 => 'ter',
    'тетум'                                                   => 'tet',
    'тибетски'                                             => 'bo',
    'тив'                                                       => 'tiv',
    'тигре'                                                   => 'tig',
    'тигриня'                                               => 'ti',
    'тлингит'                                               => 'tli',
    'токелайски'                                         => 'tkl',
    'токписин'                                             => 'tpi',
    'тонга'                                                   => 'to',
    'тсвана'                                                 => 'tn',
    'тсонга'                                                 => 'ts',
    'туап'                                                     => 'kcg',
    'тувалуански'                                       => 'tvl',
    'тувински'                                             => 'tyv',
    'туи'                                                       => 'tw',
    'тумбука'                                               => 'tum',
    'тупи'                                                     => 'tup',
    'туркменски'                                         => 'tk',
    'турски'                                                 => 'tr',
    'уашо'                                                     => 'was',
    'угаритски'                                           => 'uga',
    'угрофински'                                         => 'fiu',
    'удмуртски'                                           => 'udm',
    'уелски'                                                 => 'cy',
    'узбекски'                                             => 'uz',
    'уйгурски'                                             => 'ug',
    'украински'                                           => 'uk',
    'умбунду'                                               => 'umb',
    'унгарски'                                             => 'hu',
    'урду'                                                     => 'ur',
    'фанг'                                                     => 'fan',
    'фанти'                                                   => 'fat',
    'фарьорски'                                           => 'fo',
    'фиджийски'                                           => 'fj',
    'филипински'                                         => 'fil',
    'филипинскидруги'                               => 'phi',
    'финикийски'                                         => 'phn',
    'фински'                                                 => 'fi',
    'фламандски'                                         => 'nl_be',
    'фон'                                                       => 'fon',
    'френски'                                               => 'fr',
    'фризийски'                                           => 'fy',
    'фриулиански'                                       => 'fur',
    'фула'                                                     => 'ff',
    'хавайски'                                             => 'haw',
    'хаитянски'                                           => 'ht',
    'хайда'                                                   => 'hai',
    'хауза'                                                   => 'ha',
    'хереро'                                                 => 'hz',
    'хилигайнон'                                         => 'hil',
    'химачали'                                             => 'him',
    'хинди'                                                   => 'hi',
    'хиримоту'                                             => 'ho',
    'хитски'                                                 => 'hit',
    'хмонг'                                                   => 'hmn',
    'холандски'                                           => 'nl',
    'хупа'                                                     => 'hup',
    'хърватски'                                           => 'hr',
    'централноамериканскииндиански'   => 'cai',
    'циганскиезик'                                     => 'rom',
    'цимшиански'                                         => 'tsi',
    'църковнославянски'                           => 'cu',
    'чагатай'                                               => 'chg',
    'чаморо'                                                 => 'ch',
    'чамски'                                                 => 'cmc',
    'чейенски'                                             => 'chy',
    'чероки'                                                 => 'chr',
    'чеченски'                                             => 'ce',
    'чешки'                                                   => 'cs',
    'чибча'                                                   => 'chb',
    'чиипувски'                                           => 'chp',
    'чинянджа'                                             => 'ny',
    'чокто'                                                   => 'cho',
    'чувашки'                                               => 'cv',
    'чуук'                                                     => 'chk',
    'шан'                                                       => 'shn',
    'шведски'                                               => 'sv',
    'швейцарскигорногермански'             => 'de_ch',
    'швейцарскинемски'                             => 'gsw',
    'швейцарскифренски'                           => 'fr_ch',
    'шона'                                                     => 'sn',
    'шотландски'                                         => 'sco',
    'шотландскигалски'                             => 'gd',
    'шумерски'                                             => 'sux',
    'юженндебеле'                                       => 'nr',
    'южноалтайски'                                     => 'alt',
    'южноамериканскииндиански'             => 'sai',
    'южносаамски'                                       => 'sma',
    'юпик'                                                     => 'ypk',
    'явански'                                               => 'jv',
    'якутски'                                               => 'sah',
    'яо'                                                         => 'yao',
    'япезе'                                                   => 'yap',
    'японски'                                               => 'ja',
);

1;
