<?php
/**
 * Italian language strings.
 *
 * This file is part of ADOdb, a Database Abstraction Layer library for PHP.
 *
 * @package ADOdb
 * @link https://adodb.org Project's web site and documentation
 * @link https://github.com/ADOdb/ADOdb Source code and issue tracker
 *
 * The ADOdb Library is dual-licensed, released under both the BSD 3-Clause
 * and the GNU Lesser General Public Licence (LGPL) v2.1 or, at your option,
 * any later version. This means you can use it in proprietary products.
 * See the LICENSE.md file distributed with this source code for details.
 * @license BSD-3-Clause
 * @license LGPL-2.1-or-later
 *
 * @copyright 2000-2013 John Lim
 * @copyright 2014 Damien Regad, Mark Newnham and the ADOdb community
 * @author Tiraboschi Massimiliano <timax@maxdev.com>
 */

$ADODB_LANG_ARRAY = array (
            'LANG'                      => 'it',
            DB_ERROR                    => 'errore sconosciuto',
            DB_ERROR_ALREADY_EXISTS     => 'esiste già',
            DB_ERROR_CANNOT_CREATE      => 'non posso creare',
            DB_ERROR_CANNOT_DELETE      => 'non posso cancellare',
            DB_ERROR_CANNOT_DROP        => 'non posso eliminare',
            DB_ERROR_CONSTRAINT         => 'violazione constraint',
            DB_ERROR_DIVZERO            => 'divisione per zero',
            DB_ERROR_INVALID            => 'non valido',
            DB_ERROR_INVALID_DATE       => 'data od ora non valida',
            DB_ERROR_INVALID_NUMBER     => 'numero non valido',
            DB_ERROR_MISMATCH           => 'diversi',
            DB_ERROR_NODBSELECTED       => 'nessun database selezionato',
            DB_ERROR_NOSUCHFIELD        => 'nessun campo trovato',
            DB_ERROR_NOSUCHTABLE        => 'nessuna tabella trovata',
            DB_ERROR_NOT_CAPABLE        => 'DB backend non abilitato',
            DB_ERROR_NOT_FOUND          => 'non trovato',
            DB_ERROR_NOT_LOCKED         => 'non bloccato',
            DB_ERROR_SYNTAX             => 'errore di sintassi',
            DB_ERROR_UNSUPPORTED        => 'non supportato',
            DB_ERROR_VALUE_COUNT_ON_ROW => 'valore inserito troppo grande per una colonna',
            DB_ERROR_INVALID_DSN        => 'DSN non valido',
            DB_ERROR_CONNECT_FAILED     => 'connessione fallita',
            0                           => 'nessun errore', // DB_OK
            DB_ERROR_NEED_MORE_DATA     => 'dati inseriti insufficienti',
            DB_ERROR_EXTENSION_NOT_FOUND=> 'estensione non trovata',
            DB_ERROR_NOSUCHDB           => 'database non trovato',
            DB_ERROR_ACCESS_VIOLATION   => 'permessi insufficienti'
);
