/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDebug>
#include <QObject>
#include <QAction>
#include <QSettings>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMassCore includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassGui
{

struct ActionId
{
  ActionId();
  ActionId(const QString &context,
           const QString &category,
           const QString &unit,
           const QString &label);
  ActionId(const ActionId &other);

  QString context;  // e.g., "ProgramWindow", "DecimalPlacesOptionsDlg"
  QString category; // e.g., "File", "Edit"
  QString unit;     // e.g., "Open", "Copy"
  QString label;    // e.g., "Open mass spectrometry file full in memory"

  void initialize(const QString &context,
                  const QString &category,
                  const QString &unit,
                  const QString &label);
  void initialize(const QString &action_id_text);
  void initialize(const ActionId &other);

  QString toString() const;
  QStringList toStringList() const;
  static ActionId fromString(const QString &text);

  bool isValid() const;

  void operator=(const ActionId &other);
  bool operator<(const ActionId &other) const;
  bool operator==(const ActionId &other) const;
};

class DECLSPEC ActionManager: public QObject
{
  Q_OBJECT
  public:
  explicit ActionManager(QObject *parent_p = nullptr);
  virtual ~ActionManager();

  QAction *installAction(const ActionId &action_id,
                         const QKeySequence &key_sequence = QKeySequence());

  const QMap<ActionId, QAction *> &getActionMap() const;
  QAction *getAction(const ActionId &action_id) const;

  void setShortcut(const ActionId &action_id, const QKeySequence &key_sequence);
  QKeySequence getShortcut(const ActionId &action_id);

  void saveActionData() const;
  void loadActionData();

  bool isInConflict(const QKeySequence &key_sequence,
                    const ActionId &exclude_action_id = {},
                    bool *was_found_p                 = nullptr) const;
  QList<std::pair<ActionId, QAction *>>
  conflictingItems(const QKeySequence &key_sequence,
                   const ActionId &exclude_action_id = {}) const;

  QString toString();

  int actionCount() const;

  protected:
  QMap<ActionId, QAction *> m_actions;
};


} // namespace libXpertMassGui
} // namespace MsXpS
