/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

#include <functional>
#include <unordered_map>

#include <QMap>


/////////////////////// libXpertMassCore includes
#include "MsXpS/libXpertMassCore/jsclassregistrar.h"


/////////////////////// libXpertMassGUI includes


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

namespace MsXpS
{
namespace libXpertMassGui
{

class DECLSPEC JavaScriptQObjectExposureRecord
{

  public:
  JavaScriptQObjectExposureRecord(
    QObject *object_p,
    QObject *object_parent_p          = nullptr,
    const QString &object_name        = QString(),
    const QString &object_alias       = QString(),
    const QString &object_description = QString());
  virtual ~JavaScriptQObjectExposureRecord();

  QObject *getObject();
  QObject *getObjectParent();
  QString getObjectName();
  QString getObjectAlias();
  QString getObjectDescription();

  protected:
  QObject *mp_object;
  QObject *mp_objectParent;
  QString m_objectName;
  QString m_objectAlias;
  QString m_objectDescription;
};

typedef QSharedPointer<JavaScriptQObjectExposureRecord>
  JavaScriptQObjectExposureRecordQSPtr;

} // namespace libXpertMassGui

} // namespace MsXpS
