#include "pdf/pilot.h"
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*                                                                   *
*     G R V  -  P R O T O N  - P A R A M E T R I Z A T I O N S      *
*                                                                   *
*                          1998 UPDATE                              *
*                                                                   *
*                  For a detailed explanation see                   *
*                   M. Glueck, E. Reya, A. Vogt :                   *
*        hep-ph/9806404  =  DO-TH 98/07  =  WUE-ITP-98-019          *
*                  (Eur. Phys. J. C5 (1998) 461)                    *
*                                                                   *
*   This package contains subroutines returning the light-parton    *
*   distributions in NLO (for the MSbar and DIS schemes) and LO;    * 
*   the respective light-parton, charm, and bottom contributions    *
*   to F2(electromagnetic); and the scale dependence of alpha_s.    *
*                                                                   *
*   The parton densities and F2 values are calculated from inter-   *
*   polation grids covering the regions                             *
*         Q^2/GeV^2  between   0.8   and  1.E6 ( 1.E4 for F2 )      *
*            x       between  1.E-9  and   1.                       *
*   Any call outside these regions stops the program execution.     *
*                                                                   *
*   At Q^2 = MZ^2, alpha_s reads  0.114 (0.125) in NLO (LO); the    *
*   heavy quark thresholds, QH^2 = mh^2, in the beta function are   *
*            mc = 1.4 GeV,  mb = 4.5 GeV,  mt = 175 GeV.            *
*   Note that the NLO alpha_s running is different from GRV(94).    * 
*                                                                   *
*    Questions, comments etc to:  avogt@physik.uni-wuerzburg.de     *
*                                                                   *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*
*
*
      SUBROUTINE GRV98_nlm 
     +    (DX,DQ,DUV,DDV,DUSEA,DDSEA,DSTR,DCHM,DBOT,DTOP,DGL)
C      SUBROUTINE GRV98PA (ISET, X, Q2, UV, DV, US, DS, SS, GL)
*********************************************************************
*                                                                   *
*   THE PARTON ROUTINE.                                             *
*                                     __                            *
*   INPUT:   ISET =  1 (LO),  2 (NLO, MS), or  3 (NLO, DIS)         *
*            X  =  Bjorken-x        (between  1.E-9 and 1.)         *
*            Q2 =  scale in GeV**2  (between  0.8 and 1.E6)         *
*                                                                   *
*   OUTPUT:  UV = u - u(bar),  DV = d - d(bar),  US = u(bar),       *
*            DS = d(bar),  SS = s = s(bar),  GL = gluon.            *
*            Always x times the distribution is returned.           *
*                                                                   *
*   COMMON:  The main program or the calling routine has to have    *
*            a common block  COMMON / INTINIP / IINIP , and the     *
*            integer variable  IINIP  has always to be zero when    *
*            GRV98PA is called for the first time or when  ISET     *
*            has been changed.                                      *
*                                                                   *
*   GRIDS:   1. grv98lo.grid, 2. grv98nlm.grid, 3. grv98nld.grid,   *
*            (1+1809 lines with 6 columns, 4 significant figures)   *
*                                                                   *
*******************************************************i*************
*
#include "pdf/impdp.inc"
      PARAMETER (NPART=6, NX=68, NQ=27, NARG=2)
      DIMENSION XUVF(NX,NQ), XDVF(NX,NQ), XDEF(NX,NQ), XUDF(NX,NQ),
     1          XSF(NX,NQ), XGF(NX,NQ), PARTON (NPART,NQ,NX-1), 
     2          QS(NQ), XB(NX), XT(NARG), NA(NARG), ARRF(NX+NQ) 
      CHARACTER*80 LINE
C      COMMON / INTINIP / IINIP
      SAVE XUVF, XDVF, XDEF, XUDF, XSF, XGF, NA, ARRF
       DATA ZEROD/0.D0/
*
* ..BJORKEN-X AND Q**2 VALUES OF THE GRID :
       DATA QS / 0.8E0, 
     1           1.0E0, 1.3E0, 1.8E0, 2.7E0, 4.0E0, 6.4E0,
     2           1.0E1, 1.6E1, 2.5E1, 4.0E1, 6.4E1,
     3           1.0E2, 1.8E2, 3.2E2, 5.7E2,
     4           1.0E3, 1.8E3, 3.2E3, 5.7E3,
     5           1.0E4, 2.2E4, 4.6E4,
     6           1.0E5, 2.2E5, 4.6E5, 
     7           1.E6 /
       DATA XB / 1.0E-9, 1.8E-9, 3.2E-9, 5.7E-9, 
     A           1.0E-8, 1.8E-8, 3.2E-8, 5.7E-8, 
     B           1.0E-7, 1.8E-7, 3.2E-7, 5.7E-7, 
     C           1.0E-6, 1.4E-6, 2.0E-6, 3.0E-6, 4.5E-6, 6.7E-6,
     1           1.0E-5, 1.4E-5, 2.0E-5, 3.0E-5, 4.5E-5, 6.7E-5,
     2           1.0E-4, 1.4E-4, 2.0E-4, 3.0E-4, 4.5E-4, 6.7E-4,
     3           1.0E-3, 1.4E-3, 2.0E-3, 3.0E-3, 4.5E-3, 6.7E-3,
     4           1.0E-2, 1.4E-2, 2.0E-2, 3.0E-2, 4.5E-2, 0.06, 0.08,
     5           0.1, 0.125, 0.15, 0.175, 0.2, 0.225, 0.25, 0.275,
     6           0.3, 0.325, 0.35, 0.375, 0.4,  0.45, 0.5, 0.55,
     7           0.6, 0.65,  0.7,  0.75,  0.8,  0.85, 0.9, 0.95, 1. /
      DATA IINIP/0/
C
        DATA ((PARTON(I,N,1),I=1,6),N=1,8)/
     +   .1015E-03,  .6337E-04,  .3188E-04,  .1351E+01,  .6652E+00,
     +   .2734E+01,
     +   .1058E-03,  .6606E-04,  .3318E-04,  .2301E+01,  .1140E+01,
     +   .4818E+01,
     +   .1105E-03,  .6898E-04,  .3459E-04,  .3767E+01,  .1873E+01,
     +   .8766E+01,
     +   .1158E-03,  .7230E-04,  .3620E-04,  .6116E+01,  .3047E+01,
     +   .1683E+02,
     +   .1220E-03,  .7615E-04,  .3805E-04,  .8497E+01,  .4238E+01,
     +   .4269E+02,
     +   .1276E-03,  .7961E-04,  .3971E-04,  .1139E+02,  .5685E+01,
     +   .8191E+02,
     +   .1337E-03,  .8346E-04,  .4156E-04,  .1614E+02,  .8058E+01,
     +   .1470E+03,
     +   .1392E-03,  .8686E-04,  .4318E-04,  .2199E+02,  .1098E+02,
     +   .2296E+03 /
        DATA ((PARTON(I,N,1),I=1,6),N=9,16)/
     +   .1446E-03,  .9023E-04,  .4479E-04,  .2960E+02,  .1479E+02,
     +   .3406E+03,
     +   .1495E-03,  .9326E-04,  .4624E-04,  .3778E+02,  .1888E+02,
     +   .4734E+03,
     +   .1544E-03,  .9632E-04,  .4770E-04,  .4746E+02,  .2372E+02,
     +   .6454E+03,
     +   .1591E-03,  .9926E-04,  .4909E-04,  .5886E+02,  .2942E+02,
     +   .8493E+03,
     +   .1634E-03,  .1019E-03,  .5036E-04,  .7133E+02,  .3565E+02,
     +   .1074E+04,
     +   .1689E-03,  .1053E-03,  .5197E-04,  .9026E+02,  .4512E+02,
     +   .1417E+04,
     +   .1740E-03,  .1085E-03,  .5348E-04,  .1116E+03,  .5579E+02,
     +   .1807E+04,
     +   .1789E-03,  .1116E-03,  .5493E-04,  .1359E+03,  .6792E+02,
     +   .2255E+04 /
        DATA ((PARTON(I,N,1),I=1,6),N=17,24)/
     +   .1835E-03,  .1145E-03,  .5629E-04,  .1623E+03,  .8112E+02,
     +   .2745E+04,
     +   .1882E-03,  .1174E-03,  .5766E-04,  .1928E+03,  .9641E+02,
     +   .3315E+04,
     +   .1927E-03,  .1201E-03,  .5896E-04,  .2257E+03,  .1129E+03,
     +   .3932E+04,
     +   .1970E-03,  .1228E-03,  .6022E-04,  .2617E+03,  .1308E+03,
     +   .4609E+04,
     +   .2011E-03,  .1254E-03,  .6141E-04,  .2996E+03,  .1498E+03,
     +   .5325E+04,
     +   .2066E-03,  .1288E-03,  .6303E-04,  .3575E+03,  .1787E+03,
     +   .6422E+04,
     +   .2117E-03,  .1319E-03,  .6449E-04,  .4159E+03,  .2079E+03,
     +   .7549E+04,
     +   .2168E-03,  .1352E-03,  .6599E-04,  .4824E+03,  .2412E+03,
     +   .8848E+04 /
        DATA ((PARTON(I,N,1),I=1,6),N=25,27)/
     +   .2220E-03,  .1383E-03,  .6747E-04,  .5561E+03,  .2780E+03,
     +   .1028E+05,
     +   .2266E-03,  .1412E-03,  .6882E-04,  .6305E+03,  .3153E+03,
     +   .1172E+05,
     +   .2314E-03,  .1442E-03,  .7020E-04,  .7148E+03,  .3574E+03,
     +   .1335E+05 /
        DATA ((PARTON(I,N,2),I=1,6),N=1,8)/
     +   .1307E-03,  .8159E-04,  .4103E-04,  .1269E+01,  .6231E+00,
     +   .2856E+01,
     +   .1363E-03,  .8506E-04,  .4270E-04,  .2139E+01,  .1058E+01,
     +   .5039E+01,
     +   .1423E-03,  .8882E-04,  .4451E-04,  .3469E+01,  .1723E+01,
     +   .9094E+01,
     +   .1492E-03,  .9310E-04,  .4657E-04,  .5582E+01,  .2779E+01,
     +   .1718E+02,
     +   .1571E-03,  .9806E-04,  .4894E-04,  .7764E+01,  .3870E+01,
     +   .4122E+02,
     +   .1643E-03,  .1025E-03,  .5107E-04,  .1040E+02,  .5188E+01,
     +   .7697E+02,
     +   .1722E-03,  .1075E-03,  .5343E-04,  .1467E+02,  .7320E+01,
     +   .1357E+03,
     +   .1793E-03,  .1119E-03,  .5552E-04,  .1987E+02,  .9920E+01,
     +   .2093E+03 /
        DATA ((PARTON(I,N,2),I=1,6),N=9,16)/
     +   .1862E-03,  .1162E-03,  .5758E-04,  .2658E+02,  .1328E+02,
     +   .3075E+03,
     +   .1925E-03,  .1201E-03,  .5943E-04,  .3376E+02,  .1687E+02,
     +   .4239E+03,
     +   .1989E-03,  .1240E-03,  .6129E-04,  .4223E+02,  .2110E+02,
     +   .5735E+03,
     +   .2049E-03,  .1278E-03,  .6308E-04,  .5214E+02,  .2606E+02,
     +   .7497E+03,
     +   .2105E-03,  .1313E-03,  .6470E-04,  .6293E+02,  .3145E+02,
     +   .9426E+03,
     +   .2175E-03,  .1356E-03,  .6676E-04,  .7921E+02,  .3959E+02,
     +   .1236E+04,
     +   .2241E-03,  .1397E-03,  .6868E-04,  .9747E+02,  .4872E+02,
     +   .1568E+04,
     +   .2304E-03,  .1437E-03,  .7054E-04,  .1181E+03,  .5905E+02,
     +   .1946E+04 /
        DATA ((PARTON(I,N,2),I=1,6),N=17,24)/
     +   .2364E-03,  .1474E-03,  .7227E-04,  .1405E+03,  .7024E+02,
     +   .2358E+04,
     +   .2425E-03,  .1512E-03,  .7403E-04,  .1663E+03,  .8315E+02,
     +   .2836E+04,
     +   .2482E-03,  .1547E-03,  .7568E-04,  .1940E+03,  .9698E+02,
     +   .3350E+04,
     +   .2538E-03,  .1582E-03,  .7730E-04,  .2241E+03,  .1120E+03,
     +   .3912E+04,
     +   .2590E-03,  .1614E-03,  .7882E-04,  .2558E+03,  .1279E+03,
     +   .4504E+04,
     +   .2662E-03,  .1659E-03,  .8088E-04,  .3040E+03,  .1520E+03,
     +   .5409E+04,
     +   .2727E-03,  .1699E-03,  .8274E-04,  .3524E+03,  .1762E+03,
     +   .6333E+04,
     +   .2793E-03,  .1741E-03,  .8465E-04,  .4075E+03,  .2037E+03,
     +   .7395E+04 /
        DATA ((PARTON(I,N,2),I=1,6),N=25,27)/
     +   .2859E-03,  .1782E-03,  .8654E-04,  .4682E+03,  .2341E+03,
     +   .8561E+04,
     +   .2920E-03,  .1819E-03,  .8825E-04,  .5294E+03,  .2647E+03,
     +   .9731E+04,
     +   .2981E-03,  .1857E-03,  .9002E-04,  .5984E+03,  .2992E+03,
     +   .1105E+05 /
        DATA ((PARTON(I,N,3),I=1,6),N=1,8)/
     +   .1674E-03,  .1045E-03,  .5251E-04,  .1194E+01,  .5840E+00,
     +   .2949E+01,
     +   .1745E-03,  .1089E-03,  .5464E-04,  .1991E+01,  .9822E+00,
     +   .5199E+01,
     +   .1823E-03,  .1138E-03,  .5695E-04,  .3199E+01,  .1586E+01,
     +   .9302E+01,
     +   .1911E-03,  .1192E-03,  .5958E-04,  .5100E+01,  .2536E+01,
     +   .1730E+02,
     +   .2013E-03,  .1256E-03,  .6260E-04,  .7099E+01,  .3536E+01,
     +   .3961E+02,
     +   .2104E-03,  .1313E-03,  .6532E-04,  .9499E+01,  .4736E+01,
     +   .7218E+02,
     +   .2206E-03,  .1377E-03,  .6832E-04,  .1333E+02,  .6651E+01,
     +   .1250E+03,
     +   .2297E-03,  .1433E-03,  .7098E-04,  .1795E+02,  .8962E+01,
     +   .1907E+03 /
        DATA ((PARTON(I,N,3),I=1,6),N=9,16)/
     +   .2386E-03,  .1488E-03,  .7360E-04,  .2387E+02,  .1192E+02,
     +   .2775E+03,
     +   .2466E-03,  .1538E-03,  .7595E-04,  .3018E+02,  .1508E+02,
     +   .3796E+03,
     +   .2548E-03,  .1589E-03,  .7832E-04,  .3759E+02,  .1878E+02,
     +   .5097E+03,
     +   .2625E-03,  .1637E-03,  .8059E-04,  .4621E+02,  .2309E+02,
     +   .6620E+03,
     +   .2697E-03,  .1682E-03,  .8265E-04,  .5555E+02,  .2776E+02,
     +   .8278E+03,
     +   .2787E-03,  .1738E-03,  .8526E-04,  .6956E+02,  .3476E+02,
     +   .1079E+04,
     +   .2871E-03,  .1790E-03,  .8771E-04,  .8519E+02,  .4258E+02,
     +   .1361E+04,
     +   .2953E-03,  .1841E-03,  .9006E-04,  .1028E+03,  .5137E+02,
     +   .1680E+04 /
        DATA ((PARTON(I,N,3),I=1,6),N=17,24)/
     +   .3029E-03,  .1888E-03,  .9226E-04,  .1218E+03,  .6087E+02,
     +   .2027E+04,
     +   .3107E-03,  .1936E-03,  .9449E-04,  .1436E+03,  .7177E+02,
     +   .2427E+04,
     +   .3180E-03,  .1982E-03,  .9659E-04,  .1669E+03,  .8341E+02,
     +   .2856E+04,
     +   .3251E-03,  .2026E-03,  .9863E-04,  .1921E+03,  .9605E+02,
     +   .3323E+04,
     +   .3319E-03,  .2068E-03,  .1006E-03,  .2186E+03,  .1093E+03,
     +   .3814E+04,
     +   .3411E-03,  .2125E-03,  .1032E-03,  .2587E+03,  .1293E+03,
     +   .4559E+04,
     +   .3494E-03,  .2177E-03,  .1055E-03,  .2990E+03,  .1495E+03,
     +   .5318E+04,
     +   .3580E-03,  .2230E-03,  .1079E-03,  .3446E+03,  .1723E+03,
     +   .6186E+04 /
        DATA ((PARTON(I,N,3),I=1,6),N=25,27)/
     +   .3664E-03,  .2282E-03,  .1103E-03,  .3947E+03,  .1973E+03,
     +   .7136E+04,
     +   .3741E-03,  .2330E-03,  .1125E-03,  .4450E+03,  .2225E+03,
     +   .8086E+04,
     +   .3821E-03,  .2379E-03,  .1147E-03,  .5016E+03,  .2508E+03,
     +   .9150E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=1,8)/
     +   .2146E-03,  .1340E-03,  .6726E-04,  .1123E+01,  .5468E+00,
     +   .3019E+01,
     +   .2238E-03,  .1397E-03,  .6997E-04,  .1852E+01,  .9110E+00,
     +   .5308E+01,
     +   .2337E-03,  .1458E-03,  .7292E-04,  .2946E+01,  .1458E+01,
     +   .9412E+01,
     +   .2450E-03,  .1529E-03,  .7627E-04,  .4653E+01,  .2311E+01,
     +   .1725E+02,
     +   .2580E-03,  .1610E-03,  .8012E-04,  .6480E+01,  .3224E+01,
     +   .3788E+02,
     +   .2698E-03,  .1683E-03,  .8357E-04,  .8658E+01,  .4313E+01,
     +   .6744E+02,
     +   .2829E-03,  .1765E-03,  .8740E-04,  .1209E+02,  .6028E+01,
     +   .1149E+03,
     +   .2945E-03,  .1837E-03,  .9078E-04,  .1619E+02,  .8077E+01,
     +   .1733E+03 /
        DATA ((PARTON(I,N,4),I=1,6),N=9,16)/
     +   .3059E-03,  .1908E-03,  .9411E-04,  .2139E+02,  .1068E+02,
     +   .2498E+03,
     +   .3163E-03,  .1972E-03,  .9710E-04,  .2691E+02,  .1344E+02,
     +   .3389E+03,
     +   .3267E-03,  .2037E-03,  .1001E-03,  .3338E+02,  .1667E+02,
     +   .4517E+03,
     +   .3367E-03,  .2099E-03,  .1030E-03,  .4085E+02,  .2041E+02,
     +   .5829E+03,
     +   .3458E-03,  .2156E-03,  .1056E-03,  .4890E+02,  .2443E+02,
     +   .7249E+03,
     +   .3574E-03,  .2228E-03,  .1089E-03,  .6092E+02,  .3044E+02,
     +   .9386E+03,
     +   .3682E-03,  .2295E-03,  .1120E-03,  .7425E+02,  .3711E+02,
     +   .1177E+04,
     +   .3787E-03,  .2360E-03,  .1150E-03,  .8919E+02,  .4458E+02,
     +   .1446E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=17,24)/
     +   .3885E-03,  .2421E-03,  .1178E-03,  .1052E+03,  .5260E+02,
     +   .1737E+04,
     +   .3984E-03,  .2483E-03,  .1206E-03,  .1236E+03,  .6178E+02,
     +   .2071E+04,
     +   .4078E-03,  .2541E-03,  .1233E-03,  .1431E+03,  .7154E+02,
     +   .2427E+04,
     +   .4170E-03,  .2598E-03,  .1259E-03,  .1642E+03,  .8210E+02,
     +   .2814E+04,
     +   .4257E-03,  .2652E-03,  .1283E-03,  .1863E+03,  .9311E+02,
     +   .3218E+04,
     +   .4375E-03,  .2725E-03,  .1316E-03,  .2196E+03,  .1098E+03,
     +   .3830E+04,
     +   .4481E-03,  .2791E-03,  .1346E-03,  .2529E+03,  .1264E+03,
     +   .4450E+04,
     +   .4591E-03,  .2859E-03,  .1377E-03,  .2905E+03,  .1452E+03,
     +   .5157E+04 /
        DATA ((PARTON(I,N,4),I=1,6),N=25,27)/
     +   .4700E-03,  .2926E-03,  .1407E-03,  .3317E+03,  .1658E+03,
     +   .5927E+04,
     +   .4799E-03,  .2987E-03,  .1434E-03,  .3729E+03,  .1864E+03,
     +   .6694E+04,
     +   .4901E-03,  .3050E-03,  .1462E-03,  .4191E+03,  .2095E+03,
     +   .7551E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=1,8)/
     +   .2733E-03,  .1706E-03,  .8556E-04,  .1058E+01,  .5124E+00,
     +   .3067E+01,
     +   .2850E-03,  .1779E-03,  .8900E-04,  .1725E+01,  .8459E+00,
     +   .5370E+01,
     +   .2976E-03,  .1857E-03,  .9273E-04,  .2718E+01,  .1342E+01,
     +   .9435E+01,
     +   .3120E-03,  .1947E-03,  .9697E-04,  .4253E+01,  .2109E+01,
     +   .1706E+02,
     +   .3287E-03,  .2051E-03,  .1018E-03,  .5921E+01,  .2943E+01,
     +   .3610E+02,
     +   .3437E-03,  .2144E-03,  .1062E-03,  .7897E+01,  .3931E+01,
     +   .6294E+02,
     +   .3604E-03,  .2248E-03,  .1110E-03,  .1097E+02,  .5468E+01,
     +   .1055E+03,
     +   .3751E-03,  .2340E-03,  .1153E-03,  .1461E+02,  .7285E+01,
     +   .1574E+03 /
        DATA ((PARTON(I,N,5),I=1,6),N=9,16)/
     +   .3897E-03,  .2430E-03,  .1195E-03,  .1918E+02,  .9573E+01,
     +   .2249E+03,
     +   .4029E-03,  .2512E-03,  .1233E-03,  .2402E+02,  .1199E+02,
     +   .3028E+03,
     +   .4162E-03,  .2595E-03,  .1271E-03,  .2967E+02,  .1481E+02,
     +   .4006E+03,
     +   .4289E-03,  .2674E-03,  .1307E-03,  .3616E+02,  .1806E+02,
     +   .5137E+03,
     +   .4406E-03,  .2746E-03,  .1340E-03,  .4310E+02,  .2153E+02,
     +   .6355E+03,
     +   .4553E-03,  .2837E-03,  .1382E-03,  .5342E+02,  .2669E+02,
     +   .8176E+03,
     +   .4691E-03,  .2923E-03,  .1421E-03,  .6481E+02,  .3239E+02,
     +   .1020E+04,
     +   .4825E-03,  .3006E-03,  .1458E-03,  .7751E+02,  .3873E+02,
     +   .1247E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=17,24)/
     +   .4950E-03,  .3084E-03,  .1493E-03,  .9109E+02,  .4552E+02,
     +   .1491E+04,
     +   .5077E-03,  .3162E-03,  .1529E-03,  .1066E+03,  .5326E+02,
     +   .1769E+04,
     +   .5197E-03,  .3237E-03,  .1562E-03,  .1230E+03,  .6146E+02,
     +   .2066E+04,
     +   .5314E-03,  .3309E-03,  .1595E-03,  .1406E+03,  .7030E+02,
     +   .2386E+04,
     +   .5425E-03,  .3377E-03,  .1625E-03,  .1590E+03,  .7949E+02,
     +   .2720E+04,
     +   .5575E-03,  .3470E-03,  .1667E-03,  .1867E+03,  .9333E+02,
     +   .3223E+04,
     +   .5711E-03,  .3555E-03,  .1704E-03,  .2143E+03,  .1071E+03,
     +   .3731E+04,
     +   .5851E-03,  .3641E-03,  .1743E-03,  .2454E+03,  .1227E+03,
     +   .4306E+04 /
        DATA ((PARTON(I,N,5),I=1,6),N=25,27)/
     +   .5989E-03,  .3727E-03,  .1780E-03,  .2793E+03,  .1396E+03,
     +   .4932E+04,
     +   .6116E-03,  .3805E-03,  .1815E-03,  .3131E+03,  .1565E+03,
     +   .5553E+04,
     +   .6246E-03,  .3885E-03,  .1850E-03,  .3509E+03,  .1754E+03,
     +   .6244E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=1,8)/
     +   .3520E-03,  .2197E-03,  .1100E-03,  .9937E+00,  .4784E+00,
     +   .3097E+01,
     +   .3670E-03,  .2290E-03,  .1144E-03,  .1601E+01,  .7820E+00,
     +   .5393E+01,
     +   .3833E-03,  .2392E-03,  .1192E-03,  .2497E+01,  .1229E+01,
     +   .9382E+01,
     +   .4018E-03,  .2507E-03,  .1246E-03,  .3868E+01,  .1915E+01,
     +   .1673E+02,
     +   .4233E-03,  .2641E-03,  .1308E-03,  .5381E+01,  .2671E+01,
     +   .3419E+02,
     +   .4427E-03,  .2761E-03,  .1364E-03,  .7161E+01,  .3560E+01,
     +   .5836E+02,
     +   .4642E-03,  .2895E-03,  .1425E-03,  .9893E+01,  .4926E+01,
     +   .9630E+02,
     +   .4832E-03,  .3013E-03,  .1480E-03,  .1309E+02,  .6525E+01,
     +   .1420E+03 /
        DATA ((PARTON(I,N,6),I=1,6),N=9,16)/
     +   .5021E-03,  .3130E-03,  .1533E-03,  .1708E+02,  .8521E+01,
     +   .2010E+03,
     +   .5190E-03,  .3235E-03,  .1581E-03,  .2129E+02,  .1062E+02,
     +   .2684E+03,
     +   .5362E-03,  .3342E-03,  .1630E-03,  .2617E+02,  .1306E+02,
     +   .3524E+03,
     +   .5526E-03,  .3444E-03,  .1676E-03,  .3175E+02,  .1585E+02,
     +   .4489E+03,
     +   .5676E-03,  .3537E-03,  .1718E-03,  .3769E+02,  .1882E+02,
     +   .5523E+03,
     +   .5866E-03,  .3654E-03,  .1771E-03,  .4646E+02,  .2321E+02,
     +   .7058E+03,
     +   .6045E-03,  .3765E-03,  .1820E-03,  .5608E+02,  .2802E+02,
     +   .8753E+03,
     +   .6217E-03,  .3871E-03,  .1868E-03,  .6676E+02,  .3336E+02,
     +   .1064E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=17,24)/
     +   .6378E-03,  .3972E-03,  .1912E-03,  .7813E+02,  .3904E+02,
     +   .1267E+04,
     +   .6542E-03,  .4073E-03,  .1957E-03,  .9103E+02,  .4549E+02,
     +   .1497E+04,
     +   .6697E-03,  .4168E-03,  .1999E-03,  .1046E+03,  .5230E+02,
     +   .1740E+04,
     +   .6847E-03,  .4262E-03,  .2040E-03,  .1193E+03,  .5961E+02,
     +   .2002E+04,
     +   .6990E-03,  .4350E-03,  .2079E-03,  .1344E+03,  .6719E+02,
     +   .2274E+04,
     +   .7184E-03,  .4470E-03,  .2132E-03,  .1572E+03,  .7856E+02,
     +   .2682E+04,
     +   .7360E-03,  .4578E-03,  .2179E-03,  .1797E+03,  .8985E+02,
     +   .3092E+04,
     +   .7540E-03,  .4690E-03,  .2227E-03,  .2051E+03,  .1025E+03,
     +   .3555E+04 /
        DATA ((PARTON(I,N,6),I=1,6),N=25,27)/
     +   .7719E-03,  .4800E-03,  .2275E-03,  .2327E+03,  .1163E+03,
     +   .4056E+04,
     +   .7882E-03,  .4900E-03,  .2319E-03,  .2601E+03,  .1300E+03,
     +   .4551E+04,
     +   .8049E-03,  .5004E-03,  .2363E-03,  .2906E+03,  .1453E+03,
     +   .5100E+04 /
        DATA ((PARTON(I,N,7),I=1,6),N=1,8)/
     +   .4509E-03,  .2814E-03,  .1407E-03,  .9350E+00,  .4468E+00,
     +   .3109E+01,
     +   .4701E-03,  .2934E-03,  .1463E-03,  .1489E+01,  .7233E+00,
     +   .5379E+01,
     +   .4910E-03,  .3064E-03,  .1523E-03,  .2296E+01,  .1127E+01,
     +   .9264E+01,
     +   .5148E-03,  .3212E-03,  .1592E-03,  .3522E+01,  .1739E+01,
     +   .1629E+02,
     +   .5424E-03,  .3383E-03,  .1671E-03,  .4893E+01,  .2425E+01,
     +   .3227E+02,
     +   .5672E-03,  .3537E-03,  .1741E-03,  .6495E+01,  .3225E+01,
     +   .5404E+02,
     +   .5948E-03,  .3708E-03,  .1819E-03,  .8923E+01,  .4439E+01,
     +   .8780E+02,
     +   .6192E-03,  .3860E-03,  .1888E-03,  .1173E+02,  .5844E+01,
     +   .1281E+03 /
        DATA ((PARTON(I,N,7),I=1,6),N=9,16)/
     +   .6434E-03,  .4010E-03,  .1955E-03,  .1522E+02,  .7585E+01,
     +   .1795E+03,
     +   .6652E-03,  .4145E-03,  .2016E-03,  .1887E+02,  .9410E+01,
     +   .2379E+03,
     +   .6871E-03,  .4281E-03,  .2077E-03,  .2309E+02,  .1152E+02,
     +   .3101E+03,
     +   .7082E-03,  .4412E-03,  .2135E-03,  .2789E+02,  .1392E+02,
     +   .3924E+03,
     +   .7275E-03,  .4531E-03,  .2188E-03,  .3297E+02,  .1646E+02,
     +   .4800E+03,
     +   .7519E-03,  .4682E-03,  .2255E-03,  .4042E+02,  .2019E+02,
     +   .6095E+03,
     +   .7747E-03,  .4823E-03,  .2317E-03,  .4856E+02,  .2426E+02,
     +   .7515E+03,
     +   .7968E-03,  .4960E-03,  .2377E-03,  .5755E+02,  .2875E+02,
     +   .9091E+03 /
        DATA ((PARTON(I,N,7),I=1,6),N=17,24)/
     +   .8176E-03,  .5088E-03,  .2433E-03,  .6707E+02,  .3351E+02,
     +   .1077E+04,
     +   .8385E-03,  .5218E-03,  .2489E-03,  .7782E+02,  .3889E+02,
     +   .1267E+04,
     +   .8584E-03,  .5340E-03,  .2542E-03,  .8913E+02,  .4454E+02,
     +   .1466E+04,
     +   .8778E-03,  .5460E-03,  .2594E-03,  .1012E+03,  .5059E+02,
     +   .1681E+04,
     +   .8961E-03,  .5573E-03,  .2643E-03,  .1137E+03,  .5684E+02,
     +   .1902E+04,
     +   .9209E-03,  .5726E-03,  .2709E-03,  .1324E+03,  .6618E+02,
     +   .2233E+04,
     +   .9434E-03,  .5865E-03,  .2768E-03,  .1509E+03,  .7543E+02,
     +   .2565E+04,
     +   .9666E-03,  .6008E-03,  .2829E-03,  .1716E+03,  .8578E+02,
     +   .2937E+04 /
        DATA ((PARTON(I,N,7),I=1,6),N=25,27)/
     +   .9895E-03,  .6149E-03,  .2888E-03,  .1940E+03,  .9699E+02,
     +   .3338E+04,
     +   .1010E-02,  .6278E-03,  .2943E-03,  .2162E+03,  .1081E+03,
     +   .3733E+04,
     +   .1032E-02,  .6410E-03,  .2998E-03,  .2409E+03,  .1204E+03,
     +   .4169E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=1,8)/
     +   .5781E-03,  .3607E-03,  .1800E-03,  .8801E+00,  .4168E+00,
     +   .3104E+01,
     +   .6028E-03,  .3761E-03,  .1871E-03,  .1383E+01,  .6682E+00,
     +   .5333E+01,
     +   .6296E-03,  .3928E-03,  .1947E-03,  .2110E+01,  .1031E+01,
     +   .9090E+01,
     +   .6601E-03,  .4118E-03,  .2034E-03,  .3203E+01,  .1577E+01,
     +   .1577E+02,
     +   .6956E-03,  .4337E-03,  .2134E-03,  .4442E+01,  .2197E+01,
     +   .3034E+02,
     +   .7274E-03,  .4535E-03,  .2223E-03,  .5879E+01,  .2914E+01,
     +   .4986E+02,
     +   .7629E-03,  .4755E-03,  .2322E-03,  .8029E+01,  .3989E+01,
     +   .7980E+02,
     +   .7942E-03,  .4949E-03,  .2408E-03,  .1049E+02,  .5221E+01,
     +   .1152E+03 /
        DATA ((PARTON(I,N,8),I=1,6),N=9,16)/
     +   .8252E-03,  .5142E-03,  .2494E-03,  .1352E+02,  .6734E+01,
     +   .1599E+03,
     +   .8532E-03,  .5315E-03,  .2570E-03,  .1668E+02,  .8313E+01,
     +   .2102E+03,
     +   .8814E-03,  .5489E-03,  .2647E-03,  .2032E+02,  .1013E+02,
     +   .2719E+03,
     +   .9085E-03,  .5657E-03,  .2720E-03,  .2443E+02,  .1219E+02,
     +   .3419E+03,
     +   .9333E-03,  .5810E-03,  .2786E-03,  .2875E+02,  .1435E+02,
     +   .4159E+03,
     +   .9646E-03,  .6003E-03,  .2870E-03,  .3507E+02,  .1751E+02,
     +   .5245E+03,
     +   .9940E-03,  .6185E-03,  .2949E-03,  .4192E+02,  .2093E+02,
     +   .6430E+03,
     +   .1022E-02,  .6360E-03,  .3024E-03,  .4945E+02,  .2470E+02,
     +   .7736E+03 /
        DATA ((PARTON(I,N,8),I=1,6),N=17,24)/
     +   .1049E-02,  .6524E-03,  .3094E-03,  .5739E+02,  .2866E+02,
     +   .9119E+03,
     +   .1076E-02,  .6690E-03,  .3165E-03,  .6632E+02,  .3313E+02,
     +   .1068E+04,
     +   .1101E-02,  .6847E-03,  .3231E-03,  .7567E+02,  .3781E+02,
     +   .1231E+04,
     +   .1126E-02,  .7001E-03,  .3296E-03,  .8564E+02,  .4279E+02,
     +   .1406E+04,
     +   .1150E-02,  .7145E-03,  .3357E-03,  .9590E+02,  .4792E+02,
     +   .1585E+04,
     +   .1182E-02,  .7342E-03,  .3439E-03,  .1112E+03,  .5556E+02,
     +   .1852E+04,
     +   .1211E-02,  .7520E-03,  .3514E-03,  .1263E+03,  .6310E+02,
     +   .2118E+04,
     +   .1240E-02,  .7703E-03,  .3589E-03,  .1431E+03,  .7151E+02,
     +   .2416E+04 /
        DATA ((PARTON(I,N,8),I=1,6),N=25,27)/
     +   .1270E-02,  .7884E-03,  .3664E-03,  .1612E+03,  .8058E+02,
     +   .2735E+04,
     +   .1297E-02,  .8049E-03,  .3732E-03,  .1791E+03,  .8954E+02,
     +   .3048E+04,
     +   .1324E-02,  .8219E-03,  .3801E-03,  .1990E+03,  .9945E+02,
     +   .3393E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=1,8)/
     +   .7363E-03,  .4594E-03,  .2286E-03,  .8302E+00,  .3891E+00,
     +   .3085E+01,
     +   .7679E-03,  .4790E-03,  .2375E-03,  .1288E+01,  .6178E+00,
     +   .5260E+01,
     +   .8021E-03,  .5003E-03,  .2472E-03,  .1943E+01,  .9449E+00,
     +   .8874E+01,
     +   .8410E-03,  .5245E-03,  .2581E-03,  .2918E+01,  .1432E+01,
     +   .1520E+02,
     +   .8862E-03,  .5525E-03,  .2706E-03,  .4038E+01,  .1992E+01,
     +   .2847E+02,
     +   .9269E-03,  .5777E-03,  .2818E-03,  .5326E+01,  .2635E+01,
     +   .4597E+02,
     +   .9721E-03,  .6057E-03,  .2941E-03,  .7231E+01,  .3587E+01,
     +   .7251E+02,
     +   .1012E-02,  .6305E-03,  .3050E-03,  .9392E+01,  .4667E+01,
     +   .1035E+03 /
        DATA ((PARTON(I,N,9),I=1,6),N=9,16)/
     +   .1052E-02,  .6550E-03,  .3156E-03,  .1202E+02,  .5983E+01,
     +   .1425E+03,
     +   .1087E-02,  .6770E-03,  .3252E-03,  .1476E+02,  .7350E+01,
     +   .1859E+03,
     +   .1123E-02,  .6993E-03,  .3347E-03,  .1790E+02,  .8919E+01,
     +   .2386E+03,
     +   .1158E-02,  .7206E-03,  .3439E-03,  .2142E+02,  .1068E+02,
     +   .2981E+03,
     +   .1190E-02,  .7401E-03,  .3522E-03,  .2510E+02,  .1252E+02,
     +   .3606E+03,
     +   .1230E-02,  .7648E-03,  .3626E-03,  .3046E+02,  .1520E+02,
     +   .4518E+03,
     +   .1267E-02,  .7879E-03,  .3724E-03,  .3623E+02,  .1809E+02,
     +   .5507E+03,
     +   .1303E-02,  .8102E-03,  .3817E-03,  .4255E+02,  .2124E+02,
     +   .6591E+03 /
        DATA ((PARTON(I,N,9),I=1,6),N=17,24)/
     +   .1337E-02,  .8311E-03,  .3904E-03,  .4918E+02,  .2456E+02,
     +   .7732E+03,
     +   .1372E-02,  .8523E-03,  .3992E-03,  .5660E+02,  .2827E+02,
     +   .9013E+03,
     +   .1404E-02,  .8723E-03,  .4075E-03,  .6434E+02,  .3214E+02,
     +   .1035E+04,
     +   .1436E-02,  .8918E-03,  .4155E-03,  .7257E+02,  .3625E+02,
     +   .1177E+04,
     +   .1466E-02,  .9102E-03,  .4231E-03,  .8101E+02,  .4047E+02,
     +   .1323E+04,
     +   .1507E-02,  .9353E-03,  .4333E-03,  .9352E+02,  .4673E+02,
     +   .1538E+04,
     +   .1544E-02,  .9579E-03,  .4425E-03,  .1058E+03,  .5288E+02,
     +   .1752E+04,
     +   .1581E-02,  .9812E-03,  .4519E-03,  .1195E+03,  .5972E+02,
     +   .1990E+04 /
        DATA ((PARTON(I,N,9),I=1,6),N=25,27)/
     +   .1619E-02,  .1004E-02,  .4611E-03,  .1342E+03,  .6707E+02,
     +   .2245E+04,
     +   .1653E-02,  .1025E-02,  .4695E-03,  .1487E+03,  .7430E+02,
     +   .2493E+04,
     +   .1689E-02,  .1047E-02,  .4780E-03,  .1646E+03,  .8228E+02,
     +   .2766E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=1,8)/
     +   .9484E-03,  .5917E-03,  .2934E-03,  .7818E+00,  .3616E+00,
     +   .3052E+01,
     +   .9891E-03,  .6169E-03,  .3047E-03,  .1196E+01,  .5684E+00,
     +   .5159E+01,
     +   .1033E-02,  .6443E-03,  .3169E-03,  .1782E+01,  .8610E+00,
     +   .8607E+01,
     +   .1084E-02,  .6756E-03,  .3308E-03,  .2646E+01,  .1293E+01,
     +   .1454E+02,
     +   .1142E-02,  .7117E-03,  .3466E-03,  .3650E+01,  .1794E+01,
     +   .2654E+02,
     +   .1194E-02,  .7442E-03,  .3607E-03,  .4795E+01,  .2366E+01,
     +   .4209E+02,
     +   .1253E-02,  .7802E-03,  .3762E-03,  .6467E+01,  .3202E+01,
     +   .6540E+02,
     +   .1304E-02,  .8122E-03,  .3899E-03,  .8345E+01,  .4140E+01,
     +   .9237E+02 /
        DATA ((PARTON(I,N,10),I=1,6),N=9,16)/
     +   .1355E-02,  .8437E-03,  .4033E-03,  .1061E+02,  .5273E+01,
     +   .1259E+03,
     +   .1402E-02,  .8721E-03,  .4153E-03,  .1296E+02,  .6445E+01,
     +   .1629E+03,
     +   .1448E-02,  .9008E-03,  .4273E-03,  .1564E+02,  .7784E+01,
     +   .2075E+03,
     +   .1493E-02,  .9283E-03,  .4388E-03,  .1862E+02,  .9276E+01,
     +   .2574E+03,
     +   .1533E-02,  .9534E-03,  .4492E-03,  .2173E+02,  .1083E+02,
     +   .3096E+03,
     +   .1585E-02,  .9851E-03,  .4623E-03,  .2621E+02,  .1307E+02,
     +   .3853E+03,
     +   .1633E-02,  .1015E-02,  .4745E-03,  .3103E+02,  .1548E+02,
     +   .4668E+03,
     +   .1680E-02,  .1044E-02,  .4862E-03,  .3626E+02,  .1809E+02,
     +   .5555E+03 /
        DATA ((PARTON(I,N,10),I=1,6),N=17,24)/
     +   .1724E-02,  .1071E-02,  .4971E-03,  .4172E+02,  .2083E+02,
     +   .6485E+03,
     +   .1768E-02,  .1098E-02,  .5080E-03,  .4782E+02,  .2387E+02,
     +   .7522E+03,
     +   .1810E-02,  .1124E-02,  .5184E-03,  .5415E+02,  .2704E+02,
     +   .8600E+03,
     +   .1851E-02,  .1149E-02,  .5284E-03,  .6084E+02,  .3039E+02,
     +   .9740E+03,
     +   .1890E-02,  .1172E-02,  .5378E-03,  .6769E+02,  .3381E+02,
     +   .1090E+04,
     +   .1943E-02,  .1205E-02,  .5505E-03,  .7780E+02,  .3886E+02,
     +   .1262E+04,
     +   .1990E-02,  .1234E-02,  .5619E-03,  .8770E+02,  .4381E+02,
     +   .1431E+04,
     +   .2039E-02,  .1264E-02,  .5736E-03,  .9867E+02,  .4930E+02,
     +   .1619E+04 /
        DATA ((PARTON(I,N,10),I=1,6),N=25,27)/
     +   .2088E-02,  .1293E-02,  .5851E-03,  .1104E+03,  .5517E+02,
     +   .1818E+04,
     +   .2132E-02,  .1320E-02,  .5955E-03,  .1219E+03,  .6093E+02,
     +   .2012E+04,
     +   .2177E-02,  .1348E-02,  .6061E-03,  .1346E+03,  .6725E+02,
     +   .2225E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=1,8)/
     +   .1215E-02,  .7579E-03,  .3743E-03,  .7380E+00,  .3362E+00,
     +   .3007E+01,
     +   .1267E-02,  .7903E-03,  .3885E-03,  .1113E+01,  .5231E+00,
     +   .5039E+01,
     +   .1324E-02,  .8255E-03,  .4039E-03,  .1637E+01,  .7850E+00,
     +   .8312E+01,
     +   .1389E-02,  .8655E-03,  .4212E-03,  .2403E+01,  .1167E+01,
     +   .1386E+02,
     +   .1464E-02,  .9118E-03,  .4410E-03,  .3302E+01,  .1616E+01,
     +   .2468E+02,
     +   .1531E-02,  .9535E-03,  .4587E-03,  .4320E+01,  .2125E+01,
     +   .3849E+02,
     +   .1606E-02,  .9997E-03,  .4781E-03,  .5787E+01,  .2858E+01,
     +   .5894E+02,
     +   .1672E-02,  .1041E-02,  .4951E-03,  .7417E+01,  .3672E+01,
     +   .8236E+02 /
        DATA ((PARTON(I,N,11),I=1,6),N=9,16)/
     +   .1738E-02,  .1081E-02,  .5119E-03,  .9368E+01,  .4647E+01,
     +   .1112E+03,
     +   .1797E-02,  .1118E-02,  .5268E-03,  .1138E+02,  .5651E+01,
     +   .1427E+03,
     +   .1857E-02,  .1154E-02,  .5418E-03,  .1366E+02,  .6794E+01,
     +   .1804E+03,
     +   .1914E-02,  .1189E-02,  .5560E-03,  .1619E+02,  .8058E+01,
     +   .2223E+03,
     +   .1966E-02,  .1222E-02,  .5689E-03,  .1881E+02,  .9367E+01,
     +   .2658E+03,
     +   .2033E-02,  .1262E-02,  .5852E-03,  .2257E+02,  .1125E+02,
     +   .3286E+03,
     +   .2095E-02,  .1300E-02,  .6003E-03,  .2658E+02,  .1325E+02,
     +   .3956E+03,
     +   .2155E-02,  .1337E-02,  .6148E-03,  .3091E+02,  .1542E+02,
     +   .4682E+03 /
        DATA ((PARTON(I,N,11),I=1,6),N=17,24)/
     +   .2211E-02,  .1372E-02,  .6283E-03,  .3542E+02,  .1767E+02,
     +   .5439E+03,
     +   .2268E-02,  .1407E-02,  .6418E-03,  .4042E+02,  .2017E+02,
     +   .6279E+03,
     +   .2322E-02,  .1440E-02,  .6546E-03,  .4559E+02,  .2275E+02,
     +   .7147E+03,
     +   .2375E-02,  .1472E-02,  .6670E-03,  .5104E+02,  .2548E+02,
     +   .8061E+03,
     +   .2424E-02,  .1502E-02,  .6786E-03,  .5659E+02,  .2825E+02,
     +   .8990E+03,
     +   .2492E-02,  .1543E-02,  .6943E-03,  .6476E+02,  .3234E+02,
     +   .1035E+04,
     +   .2553E-02,  .1581E-02,  .7083E-03,  .7273E+02,  .3632E+02,
     +   .1169E+04,
     +   .2616E-02,  .1619E-02,  .7227E-03,  .8153E+02,  .4072E+02,
     +   .1317E+04 /
        DATA ((PARTON(I,N,11),I=1,6),N=25,27)/
     +   .2678E-02,  .1657E-02,  .7368E-03,  .9090E+02,  .4541E+02,
     +   .1473E+04,
     +   .2735E-02,  .1691E-02,  .7496E-03,  .1001E+03,  .4999E+02,
     +   .1625E+04,
     +   .2793E-02,  .1727E-02,  .7626E-03,  .1101E+03,  .5501E+02,
     +   .1789E+04 /
        DATA ((PARTON(I,N,12),I=1,6),N=1,8)/
     +   .1558E-02,  .9718E-03,  .4774E-03,  .6976E+00,  .3120E+00,
     +   .2952E+01,
     +   .1625E-02,  .1013E-02,  .4952E-03,  .1036E+01,  .4806E+00,
     +   .4899E+01,
     +   .1698E-02,  .1059E-02,  .5144E-03,  .1504E+01,  .7142E+00,
     +   .7989E+01,
     +   .1781E-02,  .1110E-02,  .5361E-03,  .2181E+01,  .1052E+01,
     +   .1314E+02,
     +   .1878E-02,  .1169E-02,  .5608E-03,  .2983E+01,  .1453E+01,
     +   .2286E+02,
     +   .1964E-02,  .1223E-02,  .5828E-03,  .3883E+01,  .1902E+01,
     +   .3507E+02,
     +   .2061E-02,  .1282E-02,  .6070E-03,  .5165E+01,  .2543E+01,
     +   .5294E+02,
     +   .2146E-02,  .1335E-02,  .6282E-03,  .6575E+01,  .3247E+01,
     +   .7317E+02 /
        DATA ((PARTON(I,N,12),I=1,6),N=9,16)/
     +   .2231E-02,  .1387E-02,  .6490E-03,  .8248E+01,  .4083E+01,
     +   .9782E+02,
     +   .2307E-02,  .1433E-02,  .6675E-03,  .9961E+01,  .4939E+01,
     +   .1246E+03,
     +   .2383E-02,  .1480E-02,  .6860E-03,  .1190E+02,  .5909E+01,
     +   .1563E+03,
     +   .2457E-02,  .1525E-02,  .7036E-03,  .1404E+02,  .6976E+01,
     +   .1912E+03,
     +   .2524E-02,  .1567E-02,  .7196E-03,  .1623E+02,  .8073E+01,
     +   .2273E+03,
     +   .2609E-02,  .1619E-02,  .7396E-03,  .1937E+02,  .9640E+01,
     +   .2790E+03,
     +   .2689E-02,  .1668E-02,  .7583E-03,  .2269E+02,  .1130E+02,
     +   .3339E+03,
     +   .2766E-02,  .1715E-02,  .7761E-03,  .2626E+02,  .1308E+02,
     +   .3930E+03 /
        DATA ((PARTON(I,N,12),I=1,6),N=17,24)/
     +   .2839E-02,  .1759E-02,  .7928E-03,  .2995E+02,  .1493E+02,
     +   .4541E+03,
     +   .2912E-02,  .1804E-02,  .8094E-03,  .3404E+02,  .1697E+02,
     +   .5217E+03,
     +   .2981E-02,  .1846E-02,  .8251E-03,  .3824E+02,  .1907E+02,
     +   .5911E+03,
     +   .3049E-02,  .1887E-02,  .8403E-03,  .4265E+02,  .2128E+02,
     +   .6639E+03,
     +   .3113E-02,  .1926E-02,  .8546E-03,  .4713E+02,  .2352E+02,
     +   .7376E+03,
     +   .3200E-02,  .1979E-02,  .8738E-03,  .5369E+02,  .2680E+02,
     +   .8453E+03,
     +   .3278E-02,  .2027E-02,  .8910E-03,  .6007E+02,  .2999E+02,
     +   .9503E+03,
     +   .3359E-02,  .2076E-02,  .9086E-03,  .6708E+02,  .3349E+02,
     +   .1066E+04 /
        DATA ((PARTON(I,N,12),I=1,6),N=25,27)/
     +   .3439E-02,  .2124E-02,  .9258E-03,  .7452E+02,  .3721E+02,
     +   .1187E+04,
     +   .3512E-02,  .2169E-02,  .9414E-03,  .8176E+02,  .4083E+02,
     +   .1304E+04,
     +   .3587E-02,  .2214E-02,  .9573E-03,  .8967E+02,  .4479E+02,
     +   .1432E+04 /
        DATA ((PARTON(I,N,13),I=1,6),N=1,8)/
     +   .1985E-02,  .1238E-02,  .6041E-03,  .6617E+00,  .2897E+00,
     +   .2888E+01,
     +   .2071E-02,  .1291E-02,  .6263E-03,  .9669E+00,  .4418E+00,
     +   .4747E+01,
     +   .2164E-02,  .1349E-02,  .6501E-03,  .1385E+01,  .6504E+00,
     +   .7654E+01,
     +   .2271E-02,  .1414E-02,  .6769E-03,  .1984E+01,  .9490E+00,
     +   .1242E+02,
     +   .2394E-02,  .1490E-02,  .7074E-03,  .2700E+01,  .1306E+01,
     +   .2115E+02,
     +   .2505E-02,  .1558E-02,  .7345E-03,  .3496E+01,  .1704E+01,
     +   .3193E+02,
     +   .2628E-02,  .1634E-02,  .7643E-03,  .4616E+01,  .2263E+01,
     +   .4753E+02,
     +   .2737E-02,  .1701E-02,  .7903E-03,  .5835E+01,  .2872E+01,
     +   .6501E+02 /
        DATA ((PARTON(I,N,13),I=1,6),N=9,16)/
     +   .2845E-02,  .1767E-02,  .8158E-03,  .7269E+01,  .3589E+01,
     +   .8609E+02,
     +   .2942E-02,  .1826E-02,  .8386E-03,  .8731E+01,  .4319E+01,
     +   .1088E+03,
     +   .3040E-02,  .1886E-02,  .8612E-03,  .1038E+02,  .5143E+01,
     +   .1354E+03,
     +   .3134E-02,  .1944E-02,  .8828E-03,  .1218E+02,  .6043E+01,
     +   .1646E+03,
     +   .3220E-02,  .1996E-02,  .9023E-03,  .1402E+02,  .6963E+01,
     +   .1945E+03,
     +   .3329E-02,  .2063E-02,  .9267E-03,  .1664E+02,  .8270E+01,
     +   .2371E+03,
     +   .3431E-02,  .2125E-02,  .9494E-03,  .1939E+02,  .9646E+01,
     +   .2820E+03,
     +   .3529E-02,  .2185E-02,  .9712E-03,  .2233E+02,  .1112E+02,
     +   .3300E+03 /
        DATA ((PARTON(I,N,13),I=1,6),N=17,24)/
     +   .3622E-02,  .2241E-02,  .9914E-03,  .2537E+02,  .1263E+02,
     +   .3795E+03,
     +   .3715E-02,  .2298E-02,  .1012E-02,  .2870E+02,  .1430E+02,
     +   .4338E+03,
     +   .3804E-02,  .2352E-02,  .1031E-02,  .3212E+02,  .1601E+02,
     +   .4894E+03,
     +   .3890E-02,  .2404E-02,  .1049E-02,  .3569E+02,  .1780E+02,
     +   .5474E+03,
     +   .3972E-02,  .2454E-02,  .1066E-02,  .3931E+02,  .1960E+02,
     +   .6058E+03,
     +   .4082E-02,  .2521E-02,  .1090E-02,  .4458E+02,  .2224E+02,
     +   .6908E+03,
     +   .4183E-02,  .2582E-02,  .1110E-02,  .4968E+02,  .2479E+02,
     +   .7732E+03,
     +   .4286E-02,  .2644E-02,  .1132E-02,  .5527E+02,  .2758E+02,
     +   .8633E+03 /
        DATA ((PARTON(I,N,13),I=1,6),N=25,27)/
     +   .4387E-02,  .2706E-02,  .1152E-02,  .6119E+02,  .3054E+02,
     +   .9577E+03,
     +   .4480E-02,  .2762E-02,  .1171E-02,  .6692E+02,  .3341E+02,
     +   .1049E+04,
     +   .4576E-02,  .2820E-02,  .1190E-02,  .7315E+02,  .3652E+02,
     +   .1147E+04 /
        DATA ((PARTON(I,N,14),I=1,6),N=1,8)/
     +   .2295E-02,  .1431E-02,  .6951E-03,  .6418E+00,  .2769E+00,
     +   .2846E+01,
     +   .2395E-02,  .1492E-02,  .7202E-03,  .9285E+00,  .4197E+00,
     +   .4650E+01,
     +   .2503E-02,  .1559E-02,  .7472E-03,  .1319E+01,  .6144E+00,
     +   .7445E+01,
     +   .2626E-02,  .1635E-02,  .7776E-03,  .1874E+01,  .8913E+00,
     +   .1199E+02,
     +   .2769E-02,  .1723E-02,  .8121E-03,  .2542E+01,  .1224E+01,
     +   .2015E+02,
     +   .2897E-02,  .1801E-02,  .8427E-03,  .3280E+01,  .1593E+01,
     +   .3014E+02,
     +   .3039E-02,  .1889E-02,  .8763E-03,  .4312E+01,  .2108E+01,
     +   .4450E+02,
     +   .3166E-02,  .1966E-02,  .9057E-03,  .5427E+01,  .2665E+01,
     +   .6047E+02 /
        DATA ((PARTON(I,N,14),I=1,6),N=9,16)/
     +   .3291E-02,  .2043E-02,  .9345E-03,  .6733E+01,  .3317E+01,
     +   .7963E+02,
     +   .3403E-02,  .2111E-02,  .9600E-03,  .8060E+01,  .3980E+01,
     +   .1001E+03,
     +   .3517E-02,  .2181E-02,  .9855E-03,  .9552E+01,  .4726E+01,
     +   .1241E+03,
     +   .3626E-02,  .2247E-02,  .1010E-02,  .1117E+02,  .5537E+01,
     +   .1502E+03,
     +   .3725E-02,  .2308E-02,  .1032E-02,  .1283E+02,  .6364E+01,
     +   .1769E+03,
     +   .3851E-02,  .2385E-02,  .1059E-02,  .1517E+02,  .7533E+01,
     +   .2147E+03,
     +   .3969E-02,  .2456E-02,  .1085E-02,  .1762E+02,  .8760E+01,
     +   .2544E+03,
     +   .4083E-02,  .2526E-02,  .1109E-02,  .2024E+02,  .1007E+02,
     +   .2967E+03 /
        DATA ((PARTON(I,N,14),I=1,6),N=17,24)/
     +   .4191E-02,  .2591E-02,  .1132E-02,  .2293E+02,  .1141E+02,
     +   .3401E+03,
     +   .4299E-02,  .2656E-02,  .1154E-02,  .2588E+02,  .1288E+02,
     +   .3877E+03,
     +   .4401E-02,  .2719E-02,  .1176E-02,  .2889E+02,  .1439E+02,
     +   .4362E+03,
     +   .4501E-02,  .2779E-02,  .1196E-02,  .3203E+02,  .1596E+02,
     +   .4866E+03,
     +   .4595E-02,  .2836E-02,  .1215E-02,  .3520E+02,  .1755E+02,
     +   .5373E+03,
     +   .4724E-02,  .2914E-02,  .1241E-02,  .3981E+02,  .1985E+02,
     +   .6108E+03,
     +   .4840E-02,  .2984E-02,  .1265E-02,  .4427E+02,  .2208E+02,
     +   .6819E+03,
     +   .4959E-02,  .3056E-02,  .1288E-02,  .4914E+02,  .2451E+02,
     +   .7593E+03 /
        DATA ((PARTON(I,N,14),I=1,6),N=25,27)/
     +   .5077E-02,  .3127E-02,  .1311E-02,  .5428E+02,  .2708E+02,
     +   .8403E+03,
     +   .5184E-02,  .3192E-02,  .1332E-02,  .5925E+02,  .2957E+02,
     +   .9180E+03,
     +   .5295E-02,  .3258E-02,  .1354E-02,  .6464E+02,  .3226E+02,
     +   .1002E+04 /
        DATA ((PARTON(I,N,15),I=1,6),N=1,8)/
     +   .2677E-02,  .1669E-02,  .8060E-03,  .6219E+00,  .2638E+00,
     +   .2799E+01,
     +   .2793E-02,  .1740E-02,  .8346E-03,  .8901E+00,  .3973E+00,
     +   .4543E+01,
     +   .2920E-02,  .1818E-02,  .8653E-03,  .1253E+01,  .5780E+00,
     +   .7219E+01,
     +   .3064E-02,  .1907E-02,  .8999E-03,  .1765E+01,  .8334E+00,
     +   .1152E+02,
     +   .3230E-02,  .2009E-02,  .9392E-03,  .2384E+01,  .1142E+01,
     +   .1912E+02,
     +   .3380E-02,  .2101E-02,  .9739E-03,  .3065E+01,  .1482E+01,
     +   .2832E+02,
     +   .3547E-02,  .2203E-02,  .1012E-02,  .4008E+01,  .1953E+01,
     +   .4144E+02,
     +   .3695E-02,  .2293E-02,  .1045E-02,  .5022E+01,  .2459E+01,
     +   .5593E+02 /
        DATA ((PARTON(I,N,15),I=1,6),N=9,16)/
     +   .3841E-02,  .2382E-02,  .1078E-02,  .6202E+01,  .3048E+01,
     +   .7321E+02,
     +   .3972E-02,  .2463E-02,  .1107E-02,  .7397E+01,  .3645E+01,
     +   .9157E+02,
     +   .4105E-02,  .2543E-02,  .1136E-02,  .8737E+01,  .4315E+01,
     +   .1129E+03,
     +   .4232E-02,  .2621E-02,  .1163E-02,  .1019E+02,  .5040E+01,
     +   .1361E+03,
     +   .4348E-02,  .2692E-02,  .1188E-02,  .1166E+02,  .5776E+01,
     +   .1597E+03,
     +   .4495E-02,  .2781E-02,  .1218E-02,  .1374E+02,  .6814E+01,
     +   .1929E+03,
     +   .4633E-02,  .2865E-02,  .1247E-02,  .1591E+02,  .7898E+01,
     +   .2277E+03,
     +   .4767E-02,  .2945E-02,  .1275E-02,  .1821E+02,  .9051E+01,
     +   .2646E+03 /
        DATA ((PARTON(I,N,15),I=1,6),N=17,24)/
     +   .4892E-02,  .3021E-02,  .1300E-02,  .2057E+02,  .1023E+02,
     +   .3024E+03,
     +   .5018E-02,  .3098E-02,  .1325E-02,  .2315E+02,  .1152E+02,
     +   .3435E+03,
     +   .5138E-02,  .3170E-02,  .1349E-02,  .2578E+02,  .1283E+02,
     +   .3854E+03,
     +   .5254E-02,  .3241E-02,  .1372E-02,  .2852E+02,  .1420E+02,
     +   .4288E+03,
     +   .5365E-02,  .3307E-02,  .1394E-02,  .3127E+02,  .1558E+02,
     +   .4723E+03,
     +   .5514E-02,  .3397E-02,  .1423E-02,  .3527E+02,  .1758E+02,
     +   .5351E+03,
     +   .5650E-02,  .3479E-02,  .1449E-02,  .3912E+02,  .1950E+02,
     +   .5957E+03,
     +   .5789E-02,  .3563E-02,  .1476E-02,  .4332E+02,  .2160E+02,
     +   .6615E+03 /
        DATA ((PARTON(I,N,15),I=1,6),N=25,27)/
     +   .5926E-02,  .3645E-02,  .1502E-02,  .4773E+02,  .2380E+02,
     +   .7301E+03,
     +   .6052E-02,  .3721E-02,  .1525E-02,  .5199E+02,  .2593E+02,
     +   .7957E+03,
     +   .6181E-02,  .3798E-02,  .1549E-02,  .5660E+02,  .2824E+02,
     +   .8661E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=1,8)/
     +   .3189E-02,  .1987E-02,  .9526E-03,  .6009E+00,  .2494E+00,
     +   .2741E+01,
     +   .3328E-02,  .2073E-02,  .9857E-03,  .8491E+00,  .3728E+00,
     +   .4415E+01,
     +   .3479E-02,  .2165E-02,  .1021E-02,  .1182E+01,  .5387E+00,
     +   .6957E+01,
     +   .3651E-02,  .2271E-02,  .1061E-02,  .1649E+01,  .7713E+00,
     +   .1099E+02,
     +   .3850E-02,  .2393E-02,  .1106E-02,  .2216E+01,  .1054E+01,
     +   .1797E+02,
     +   .4029E-02,  .2502E-02,  .1146E-02,  .2835E+01,  .1363E+01,
     +   .2634E+02,
     +   .4228E-02,  .2624E-02,  .1190E-02,  .3686E+01,  .1787E+01,
     +   .3815E+02,
     +   .4404E-02,  .2731E-02,  .1228E-02,  .4593E+01,  .2240E+01,
     +   .5110E+02 /
        DATA ((PARTON(I,N,16),I=1,6),N=9,16)/
     +   .4579E-02,  .2838E-02,  .1266E-02,  .5643E+01,  .2765E+01,
     +   .6642E+02,
     +   .4736E-02,  .2933E-02,  .1299E-02,  .6702E+01,  .3293E+01,
     +   .8259E+02,
     +   .4894E-02,  .3029E-02,  .1332E-02,  .7885E+01,  .3884E+01,
     +   .1013E+03,
     +   .5046E-02,  .3122E-02,  .1363E-02,  .9160E+01,  .4521E+01,
     +   .1215E+03,
     +   .5185E-02,  .3206E-02,  .1391E-02,  .1045E+02,  .5165E+01,
     +   .1419E+03,
     +   .5360E-02,  .3312E-02,  .1426E-02,  .1226E+02,  .6069E+01,
     +   .1706E+03,
     +   .5525E-02,  .3412E-02,  .1459E-02,  .1414E+02,  .7009E+01,
     +   .2004E+03,
     +   .5684E-02,  .3508E-02,  .1490E-02,  .1613E+02,  .8004E+01,
     +   .2319E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=17,24)/
     +   .5833E-02,  .3598E-02,  .1519E-02,  .1816E+02,  .9018E+01,
     +   .2639E+03,
     +   .5984E-02,  .3689E-02,  .1548E-02,  .2037E+02,  .1012E+02,
     +   .2988E+03,
     +   .6127E-02,  .3775E-02,  .1575E-02,  .2262E+02,  .1125E+02,
     +   .3340E+03,
     +   .6266E-02,  .3859E-02,  .1601E-02,  .2495E+02,  .1241E+02,
     +   .3705E+03,
     +   .6397E-02,  .3938E-02,  .1626E-02,  .2729E+02,  .1358E+02,
     +   .4069E+03,
     +   .6576E-02,  .4045E-02,  .1659E-02,  .3067E+02,  .1527E+02,
     +   .4593E+03,
     +   .6737E-02,  .4142E-02,  .1688E-02,  .3392E+02,  .1690E+02,
     +   .5096E+03,
     +   .6903E-02,  .4241E-02,  .1718E-02,  .3746E+02,  .1866E+02,
     +   .5641E+03 /
        DATA ((PARTON(I,N,16),I=1,6),N=25,27)/
     +   .7067E-02,  .4340E-02,  .1747E-02,  .4116E+02,  .2052E+02,
     +   .6206E+03,
     +   .7216E-02,  .4429E-02,  .1774E-02,  .4472E+02,  .2230E+02,
     +   .6745E+03,
     +   .7370E-02,  .4521E-02,  .1801E-02,  .4857E+02,  .2422E+02,
     +   .7322E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=1,8)/
     +   .3799E-02,  .2366E-02,  .1124E-02,  .5816E+00,  .2355E+00,
     +   .2680E+01,
     +   .3965E-02,  .2468E-02,  .1163E-02,  .8110E+00,  .3495E+00,
     +   .4284E+01,
     +   .4145E-02,  .2579E-02,  .1204E-02,  .1116E+01,  .5014E+00,
     +   .6690E+01,
     +   .4351E-02,  .2705E-02,  .1249E-02,  .1541E+01,  .7130E+00,
     +   .1047E+02,
     +   .4589E-02,  .2850E-02,  .1301E-02,  .2059E+01,  .9711E+00,
     +   .1687E+02,
     +   .4803E-02,  .2981E-02,  .1347E-02,  .2622E+01,  .1251E+01,
     +   .2445E+02,
     +   .5041E-02,  .3126E-02,  .1397E-02,  .3387E+01,  .1633E+01,
     +   .3506E+02,
     +   .5251E-02,  .3254E-02,  .1441E-02,  .4197E+01,  .2038E+01,
     +   .4659E+02 /
        DATA ((PARTON(I,N,17),I=1,6),N=9,16)/
     +   .5459E-02,  .3380E-02,  .1483E-02,  .5129E+01,  .2503E+01,
     +   .6015E+02,
     +   .5647E-02,  .3494E-02,  .1521E-02,  .6065E+01,  .2970E+01,
     +   .7434E+02,
     +   .5836E-02,  .3609E-02,  .1558E-02,  .7106E+01,  .3490E+01,
     +   .9065E+02,
     +   .6017E-02,  .3718E-02,  .1594E-02,  .8223E+01,  .4048E+01,
     +   .1082E+03,
     +   .6183E-02,  .3818E-02,  .1626E-02,  .9348E+01,  .4610E+01,
     +   .1258E+03,
     +   .6393E-02,  .3945E-02,  .1666E-02,  .1092E+02,  .5395E+01,
     +   .1504E+03,
     +   .6589E-02,  .4063E-02,  .1703E-02,  .1255E+02,  .6207E+01,
     +   .1759E+03,
     +   .6779E-02,  .4178E-02,  .1738E-02,  .1426E+02,  .7064E+01,
     +   .2027E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=17,24)/
     +   .6957E-02,  .4285E-02,  .1771E-02,  .1600E+02,  .7934E+01,
     +   .2298E+03,
     +   .7137E-02,  .4393E-02,  .1803E-02,  .1789E+02,  .8879E+01,
     +   .2592E+03,
     +   .7307E-02,  .4495E-02,  .1834E-02,  .1981E+02,  .9836E+01,
     +   .2888E+03,
     +   .7473E-02,  .4595E-02,  .1863E-02,  .2179E+02,  .1083E+02,
     +   .3193E+03,
     +   .7630E-02,  .4689E-02,  .1891E-02,  .2377E+02,  .1181E+02,
     +   .3496E+03,
     +   .7843E-02,  .4816E-02,  .1928E-02,  .2662E+02,  .1324E+02,
     +   .3932E+03,
     +   .8035E-02,  .4931E-02,  .1961E-02,  .2936E+02,  .1461E+02,
     +   .4348E+03,
     +   .8233E-02,  .5049E-02,  .1995E-02,  .3232E+02,  .1609E+02,
     +   .4796E+03 /
        DATA ((PARTON(I,N,17),I=1,6),N=25,27)/
     +   .8428E-02,  .5166E-02,  .2028E-02,  .3542E+02,  .1764E+02,
     +   .5260E+03,
     +   .8606E-02,  .5272E-02,  .2057E-02,  .3839E+02,  .1912E+02,
     +   .5701E+03,
     +   .8789E-02,  .5381E-02,  .2088E-02,  .4159E+02,  .2072E+02,
     +   .6172E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=1,8)/
     +   .4511E-02,  .2809E-02,  .1321E-02,  .5643E+00,  .2223E+00,
     +   .2617E+01,
     +   .4709E-02,  .2931E-02,  .1365E-02,  .7763E+00,  .3276E+00,
     +   .4150E+01,
     +   .4924E-02,  .3062E-02,  .1412E-02,  .1056E+01,  .4668E+00,
     +   .6425E+01,
     +   .5169E-02,  .3212E-02,  .1464E-02,  .1443E+01,  .6592E+00,
     +   .9956E+01,
     +   .5453E-02,  .3385E-02,  .1523E-02,  .1916E+01,  .8948E+00,
     +   .1582E+02,
     +   .5708E-02,  .3540E-02,  .1575E-02,  .2426E+01,  .1149E+01,
     +   .2269E+02,
     +   .5991E-02,  .3712E-02,  .1632E-02,  .3115E+01,  .1493E+01,
     +   .3221E+02,
     +   .6242E-02,  .3864E-02,  .1681E-02,  .3838E+01,  .1853E+01,
     +   .4248E+02 /
        DATA ((PARTON(I,N,18),I=1,6),N=9,16)/
     +   .6490E-02,  .4014E-02,  .1729E-02,  .4665E+01,  .2266E+01,
     +   .5446E+02,
     +   .6713E-02,  .4149E-02,  .1772E-02,  .5491E+01,  .2678E+01,
     +   .6691E+02,
     +   .6938E-02,  .4285E-02,  .1814E-02,  .6408E+01,  .3136E+01,
     +   .8113E+02,
     +   .7154E-02,  .4415E-02,  .1854E-02,  .7387E+01,  .3625E+01,
     +   .9631E+02,
     +   .7351E-02,  .4533E-02,  .1890E-02,  .8368E+01,  .4115E+01,
     +   .1115E+03,
     +   .7600E-02,  .4683E-02,  .1935E-02,  .9731E+01,  .4796E+01,
     +   .1327E+03,
     +   .7834E-02,  .4824E-02,  .1976E-02,  .1114E+02,  .5498E+01,
     +   .1544E+03,
     +   .8060E-02,  .4959E-02,  .2016E-02,  .1261E+02,  .6235E+01,
     +   .1772E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=17,24)/
     +   .8271E-02,  .5086E-02,  .2053E-02,  .1411E+02,  .6981E+01,
     +   .2001E+03,
     +   .8485E-02,  .5214E-02,  .2089E-02,  .1572E+02,  .7789E+01,
     +   .2248E+03,
     +   .8688E-02,  .5335E-02,  .2124E-02,  .1735E+02,  .8603E+01,
     +   .2497E+03,
     +   .8885E-02,  .5453E-02,  .2157E-02,  .1903E+02,  .9443E+01,
     +   .2752E+03,
     +   .9071E-02,  .5564E-02,  .2188E-02,  .2071E+02,  .1028E+02,
     +   .3005E+03,
     +   .9324E-02,  .5715E-02,  .2229E-02,  .2312E+02,  .1149E+02,
     +   .3366E+03,
     +   .9553E-02,  .5851E-02,  .2266E-02,  .2542E+02,  .1264E+02,
     +   .3710E+03,
     +   .9787E-02,  .5991E-02,  .2303E-02,  .2791E+02,  .1388E+02,
     +   .4079E+03 /
        DATA ((PARTON(I,N,18),I=1,6),N=25,27)/
     +   .1002E-01,  .6129E-02,  .2340E-02,  .3050E+02,  .1517E+02,
     +   .4459E+03,
     +   .1023E-01,  .6254E-02,  .2373E-02,  .3297E+02,  .1641E+02,
     +   .4820E+03,
     +   .1045E-01,  .6383E-02,  .2407E-02,  .3563E+02,  .1774E+02,
     +   .5203E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=1,8)/
     +   .5364E-02,  .3339E-02,  .1551E-02,  .5485E+00,  .2096E+00,
     +   .2551E+01,
     +   .5600E-02,  .3483E-02,  .1601E-02,  .7440E+00,  .3065E+00,
     +   .4013E+01,
     +   .5857E-02,  .3640E-02,  .1654E-02,  .1000E+01,  .4338E+00,
     +   .6157E+01,
     +   .6149E-02,  .3818E-02,  .1713E-02,  .1351E+01,  .6083E+00,
     +   .9445E+01,
     +   .6487E-02,  .4024E-02,  .1780E-02,  .1782E+01,  .8228E+00,
     +   .1480E+02,
     +   .6791E-02,  .4208E-02,  .1839E-02,  .2244E+01,  .1053E+01,
     +   .2100E+02,
     +   .7129E-02,  .4412E-02,  .1903E-02,  .2861E+01,  .1361E+01,
     +   .2953E+02,
     +   .7428E-02,  .4593E-02,  .1959E-02,  .3505E+01,  .1682E+01,
     +   .3863E+02 /
        DATA ((PARTON(I,N,19),I=1,6),N=9,16)/
     +   .7724E-02,  .4771E-02,  .2013E-02,  .4236E+01,  .2046E+01,
     +   .4917E+02,
     +   .7990E-02,  .4932E-02,  .2060E-02,  .4964E+01,  .2409E+01,
     +   .6006E+02,
     +   .8258E-02,  .5093E-02,  .2108E-02,  .5768E+01,  .2811E+01,
     +   .7240E+02,
     +   .8515E-02,  .5247E-02,  .2153E-02,  .6622E+01,  .3237E+01,
     +   .8550E+02,
     +   .8750E-02,  .5388E-02,  .2193E-02,  .7474E+01,  .3663E+01,
     +   .9857E+02,
     +   .9047E-02,  .5566E-02,  .2243E-02,  .8653E+01,  .4251E+01,
     +   .1166E+03,
     +   .9325E-02,  .5733E-02,  .2290E-02,  .9864E+01,  .4856E+01,
     +   .1351E+03,
     +   .9594E-02,  .5893E-02,  .2334E-02,  .1113E+02,  .5488E+01,
     +   .1543E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=17,24)/
     +   .9846E-02,  .6044E-02,  .2375E-02,  .1240E+02,  .6125E+01,
     +   .1737E+03,
     +   .1010E-01,  .6196E-02,  .2416E-02,  .1378E+02,  .6811E+01,
     +   .1944E+03,
     +   .1034E-01,  .6339E-02,  .2454E-02,  .1516E+02,  .7502E+01,
     +   .2151E+03,
     +   .1058E-01,  .6479E-02,  .2490E-02,  .1658E+02,  .8212E+01,
     +   .2363E+03,
     +   .1080E-01,  .6610E-02,  .2525E-02,  .1799E+02,  .8918E+01,
     +   .2572E+03,
     +   .1110E-01,  .6789E-02,  .2571E-02,  .2002E+02,  .9929E+01,
     +   .2870E+03,
     +   .1137E-01,  .6950E-02,  .2612E-02,  .2194E+02,  .1089E+02,
     +   .3152E+03,
     +   .1165E-01,  .7115E-02,  .2653E-02,  .2402E+02,  .1193E+02,
     +   .3454E+03 /
        DATA ((PARTON(I,N,19),I=1,6),N=25,27)/
     +   .1193E-01,  .7278E-02,  .2694E-02,  .2617E+02,  .1301E+02,
     +   .3765E+03,
     +   .1218E-01,  .7426E-02,  .2730E-02,  .2823E+02,  .1403E+02,
     +   .4057E+03,
     +   .1243E-01,  .7579E-02,  .2767E-02,  .3043E+02,  .1513E+02,
     +   .4367E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=1,8)/
     +   .6204E-02,  .3860E-02,  .1772E-02,  .5365E+00,  .1992E+00,
     +   .2494E+01,
     +   .6478E-02,  .4027E-02,  .1827E-02,  .7190E+00,  .2896E+00,
     +   .3895E+01,
     +   .6776E-02,  .4209E-02,  .1886E-02,  .9564E+00,  .4074E+00,
     +   .5931E+01,
     +   .7116E-02,  .4416E-02,  .1952E-02,  .1279E+01,  .5680E+00,
     +   .9021E+01,
     +   .7508E-02,  .4653E-02,  .2025E-02,  .1677E+01,  .7658E+00,
     +   .1397E+02,
     +   .7860E-02,  .4866E-02,  .2090E-02,  .2101E+01,  .9767E+00,
     +   .1965E+02,
     +   .8252E-02,  .5103E-02,  .2161E-02,  .2663E+01,  .1257E+01,
     +   .2740E+02,
     +   .8599E-02,  .5311E-02,  .2222E-02,  .3246E+01,  .1547E+01,
     +   .3561E+02 /
        DATA ((PARTON(I,N,20),I=1,6),N=9,16)/
     +   .8942E-02,  .5518E-02,  .2281E-02,  .3903E+01,  .1875E+01,
     +   .4505E+02,
     +   .9250E-02,  .5703E-02,  .2334E-02,  .4556E+01,  .2201E+01,
     +   .5475E+02,
     +   .9561E-02,  .5889E-02,  .2386E-02,  .5274E+01,  .2559E+01,
     +   .6568E+02,
     +   .9859E-02,  .6067E-02,  .2435E-02,  .6034E+01,  .2938E+01,
     +   .7722E+02,
     +   .1013E-01,  .6230E-02,  .2479E-02,  .6790E+01,  .3316E+01,
     +   .8869E+02,
     +   .1047E-01,  .6435E-02,  .2534E-02,  .7831E+01,  .3835E+01,
     +   .1045E+03,
     +   .1080E-01,  .6628E-02,  .2584E-02,  .8896E+01,  .4367E+01,
     +   .1205E+03,
     +   .1111E-01,  .6813E-02,  .2632E-02,  .1000E+02,  .4920E+01,
     +   .1372E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=17,24)/
     +   .1140E-01,  .6986E-02,  .2677E-02,  .1112E+02,  .5477E+01,
     +   .1538E+03,
     +   .1169E-01,  .7161E-02,  .2721E-02,  .1231E+02,  .6074E+01,
     +   .1716E+03,
     +   .1197E-01,  .7327E-02,  .2763E-02,  .1351E+02,  .6674E+01,
     +   .1894E+03,
     +   .1225E-01,  .7487E-02,  .2803E-02,  .1474E+02,  .7289E+01,
     +   .2074E+03,
     +   .1250E-01,  .7639E-02,  .2840E-02,  .1596E+02,  .7898E+01,
     +   .2252E+03,
     +   .1285E-01,  .7845E-02,  .2890E-02,  .1771E+02,  .8769E+01,
     +   .2505E+03,
     +   .1316E-01,  .8031E-02,  .2934E-02,  .1936E+02,  .9595E+01,
     +   .2743E+03,
     +   .1349E-01,  .8221E-02,  .2979E-02,  .2114E+02,  .1048E+02,
     +   .2997E+03 /
        DATA ((PARTON(I,N,20),I=1,6),N=25,27)/
     +   .1380E-01,  .8408E-02,  .3023E-02,  .2298E+02,  .1140E+02,
     +   .3257E+03,
     +   .1409E-01,  .8579E-02,  .3063E-02,  .2473E+02,  .1228E+02,
     +   .3502E+03,
     +   .1439E-01,  .8754E-02,  .3103E-02,  .2660E+02,  .1321E+02,
     +   .3760E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=1,8)/
     +   .7239E-02,  .4502E-02,  .2037E-02,  .5250E+00,  .1885E+00,
     +   .2431E+01,
     +   .7561E-02,  .4698E-02,  .2098E-02,  .6943E+00,  .2723E+00,
     +   .3768E+01,
     +   .7910E-02,  .4910E-02,  .2163E-02,  .9130E+00,  .3807E+00,
     +   .5691E+01,
     +   .8308E-02,  .5151E-02,  .2236E-02,  .1209E+01,  .5275E+00,
     +   .8578E+01,
     +   .8767E-02,  .5429E-02,  .2317E-02,  .1573E+01,  .7087E+00,
     +   .1313E+02,
     +   .9180E-02,  .5677E-02,  .2389E-02,  .1959E+01,  .9006E+00,
     +   .1829E+02,
     +   .9638E-02,  .5953E-02,  .2466E-02,  .2467E+01,  .1154E+01,
     +   .2527E+02,
     +   .1004E-01,  .6196E-02,  .2533E-02,  .2990E+01,  .1414E+01,
     +   .3261E+02 /
        DATA ((PARTON(I,N,21),I=1,6),N=9,16)/
     +   .1044E-01,  .6437E-02,  .2598E-02,  .3576E+01,  .1706E+01,
     +   .4099E+02,
     +   .1081E-01,  .6653E-02,  .2656E-02,  .4156E+01,  .1996E+01,
     +   .4954E+02,
     +   .1117E-01,  .6870E-02,  .2713E-02,  .4793E+01,  .2313E+01,
     +   .5912E+02,
     +   .1152E-01,  .7077E-02,  .2766E-02,  .5462E+01,  .2647E+01,
     +   .6918E+02,
     +   .1184E-01,  .7266E-02,  .2815E-02,  .6126E+01,  .2978E+01,
     +   .7913E+02,
     +   .1224E-01,  .7505E-02,  .2874E-02,  .7036E+01,  .3432E+01,
     +   .9275E+02,
     +   .1261E-01,  .7729E-02,  .2930E-02,  .7962E+01,  .3895E+01,
     +   .1065E+03,
     +   .1298E-01,  .7944E-02,  .2982E-02,  .8923E+01,  .4375E+01,
     +   .1208E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=17,24)/
     +   .1332E-01,  .8146E-02,  .3031E-02,  .9885E+01,  .4855E+01,
     +   .1349E+03,
     +   .1366E-01,  .8350E-02,  .3079E-02,  .1092E+02,  .5370E+01,
     +   .1500E+03,
     +   .1399E-01,  .8542E-02,  .3124E-02,  .1195E+02,  .5884E+01,
     +   .1650E+03,
     +   .1430E-01,  .8729E-02,  .3167E-02,  .1300E+02,  .6410E+01,
     +   .1802E+03,
     +   .1460E-01,  .8905E-02,  .3208E-02,  .1404E+02,  .6930E+01,
     +   .1952E+03,
     +   .1501E-01,  .9144E-02,  .3262E-02,  .1552E+02,  .7670E+01,
     +   .2162E+03,
     +   .1538E-01,  .9359E-02,  .3310E-02,  .1692E+02,  .8371E+01,
     +   .2361E+03,
     +   .1575E-01,  .9579E-02,  .3359E-02,  .1843E+02,  .9122E+01,
     +   .2571E+03 /
        DATA ((PARTON(I,N,21),I=1,6),N=25,27)/
     +   .1612E-01,  .9797E-02,  .3406E-02,  .1998E+02,  .9897E+01,
     +   .2786E+03,
     +   .1646E-01,  .9995E-02,  .3449E-02,  .2145E+02,  .1063E+02,
     +   .2988E+03,
     +   .1681E-01,  .1020E-01,  .3492E-02,  .2302E+02,  .1141E+02,
     +   .3200E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=1,8)/
     +   .8629E-02,  .5364E-02,  .2379E-02,  .5135E+00,  .1768E+00,
     +   .2357E+01,
     +   .9014E-02,  .5597E-02,  .2447E-02,  .6688E+00,  .2535E+00,
     +   .3622E+01,
     +   .9433E-02,  .5850E-02,  .2520E-02,  .8676E+00,  .3519E+00,
     +   .5419E+01,
     +   .9909E-02,  .6138E-02,  .2600E-02,  .1134E+01,  .4841E+00,
     +   .8083E+01,
     +   .1046E-01,  .6469E-02,  .2691E-02,  .1464E+01,  .6477E+00,
     +   .1220E+02,
     +   .1095E-01,  .6765E-02,  .2770E-02,  .1810E+01,  .8197E+00,
     +   .1682E+02,
     +   .1150E-01,  .7094E-02,  .2856E-02,  .2261E+01,  .1044E+01,
     +   .2300E+02,
     +   .1199E-01,  .7384E-02,  .2930E-02,  .2722E+01,  .1274E+01,
     +   .2944E+02 /
        DATA ((PARTON(I,N,22),I=1,6),N=9,16)/
     +   .1247E-01,  .7670E-02,  .3002E-02,  .3236E+01,  .1530E+01,
     +   .3673E+02,
     +   .1290E-01,  .7926E-02,  .3065E-02,  .3741E+01,  .1782E+01,
     +   .4411E+02,
     +   .1333E-01,  .8184E-02,  .3128E-02,  .4294E+01,  .2057E+01,
     +   .5233E+02,
     +   .1375E-01,  .8431E-02,  .3186E-02,  .4872E+01,  .2345E+01,
     +   .6090E+02,
     +   .1413E-01,  .8656E-02,  .3239E-02,  .5442E+01,  .2630E+01,
     +   .6934E+02,
     +   .1461E-01,  .8940E-02,  .3305E-02,  .6220E+01,  .3018E+01,
     +   .8080E+02,
     +   .1506E-01,  .9205E-02,  .3365E-02,  .7009E+01,  .3411E+01,
     +   .9236E+02,
     +   .1549E-01,  .9461E-02,  .3423E-02,  .7822E+01,  .3818E+01,
     +   .1042E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=17,24)/
     +   .1590E-01,  .9700E-02,  .3475E-02,  .8634E+01,  .4223E+01,
     +   .1160E+03,
     +   .1631E-01,  .9941E-02,  .3528E-02,  .9500E+01,  .4655E+01,
     +   .1284E+03,
     +   .1669E-01,  .1017E-01,  .3577E-02,  .1036E+02,  .5086E+01,
     +   .1407E+03,
     +   .1707E-01,  .1039E-01,  .3624E-02,  .1124E+02,  .5524E+01,
     +   .1531E+03,
     +   .1743E-01,  .1060E-01,  .3668E-02,  .1211E+02,  .5956E+01,
     +   .1653E+03,
     +   .1791E-01,  .1088E-01,  .3727E-02,  .1333E+02,  .6570E+01,
     +   .1824E+03,
     +   .1835E-01,  .1114E-01,  .3780E-02,  .1449E+02,  .7149E+01,
     +   .1984E+03,
     +   .1879E-01,  .1140E-01,  .3832E-02,  .1573E+02,  .7766E+01,
     +   .2153E+03 /
        DATA ((PARTON(I,N,22),I=1,6),N=25,27)/
     +   .1924E-01,  .1165E-01,  .3884E-02,  .1700E+02,  .8401E+01,
     +   .2325E+03,
     +   .1964E-01,  .1189E-01,  .3930E-02,  .1820E+02,  .9002E+01,
     +   .2485E+03,
     +   .2005E-01,  .1213E-01,  .3977E-02,  .1948E+02,  .9639E+01,
     +   .2654E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=1,8)/
     +   .1029E-01,  .6391E-02,  .2768E-02,  .5037E+00,  .1655E+00,
     +   .2282E+01,
     +   .1075E-01,  .6670E-02,  .2843E-02,  .6457E+00,  .2355E+00,
     +   .3475E+01,
     +   .1125E-01,  .6972E-02,  .2923E-02,  .8261E+00,  .3247E+00,
     +   .5148E+01,
     +   .1182E-01,  .7316E-02,  .3013E-02,  .1066E+01,  .4434E+00,
     +   .7598E+01,
     +   .1248E-01,  .7710E-02,  .3112E-02,  .1363E+01,  .5906E+00,
     +   .1131E+02,
     +   .1307E-01,  .8063E-02,  .3199E-02,  .1672E+01,  .7442E+00,
     +   .1543E+02,
     +   .1373E-01,  .8454E-02,  .3293E-02,  .2072E+01,  .9431E+00,
     +   .2088E+02,
     +   .1431E-01,  .8799E-02,  .3374E-02,  .2477E+01,  .1145E+01,
     +   .2651E+02 /
        DATA ((PARTON(I,N,23),I=1,6),N=9,16)/
     +   .1488E-01,  .9140E-02,  .3452E-02,  .2925E+01,  .1368E+01,
     +   .3283E+02,
     +   .1540E-01,  .9445E-02,  .3521E-02,  .3364E+01,  .1586E+01,
     +   .3918E+02,
     +   .1592E-01,  .9751E-02,  .3589E-02,  .3842E+01,  .1824E+01,
     +   .4619E+02,
     +   .1641E-01,  .1004E-01,  .3653E-02,  .4339E+01,  .2072E+01,
     +   .5346E+02,
     +   .1687E-01,  .1031E-01,  .3710E-02,  .4827E+01,  .2316E+01,
     +   .6057E+02,
     +   .1744E-01,  .1065E-01,  .3781E-02,  .5490E+01,  .2646E+01,
     +   .7018E+02,
     +   .1798E-01,  .1096E-01,  .3847E-02,  .6158E+01,  .2980E+01,
     +   .7980E+02,
     +   .1849E-01,  .1127E-01,  .3909E-02,  .6845E+01,  .3322E+01,
     +   .8962E+02 /
        DATA ((PARTON(I,N,23),I=1,6),N=17,24)/
     +   .1898E-01,  .1155E-01,  .3966E-02,  .7527E+01,  .3662E+01,
     +   .9930E+02,
     +   .1947E-01,  .1184E-01,  .4023E-02,  .8251E+01,  .4024E+01,
     +   .1095E+03,
     +   .1993E-01,  .1211E-01,  .4076E-02,  .8970E+01,  .4383E+01,
     +   .1195E+03,
     +   .2038E-01,  .1237E-01,  .4127E-02,  .9699E+01,  .4747E+01,
     +   .1296E+03,
     +   .2080E-01,  .1261E-01,  .4175E-02,  .1042E+02,  .5104E+01,
     +   .1395E+03,
     +   .2138E-01,  .1295E-01,  .4238E-02,  .1143E+02,  .5610E+01,
     +   .1532E+03,
     +   .2190E-01,  .1325E-01,  .4294E-02,  .1238E+02,  .6085E+01,
     +   .1661E+03,
     +   .2243E-01,  .1356E-01,  .4351E-02,  .1339E+02,  .6591E+01,
     +   .1796E+03 /
        DATA ((PARTON(I,N,23),I=1,6),N=25,27)/
     +   .2295E-01,  .1386E-01,  .4407E-02,  .1443E+02,  .7109E+01,
     +   .1932E+03,
     +   .2343E-01,  .1414E-01,  .4457E-02,  .1541E+02,  .7597E+01,
     +   .2059E+03,
     +   .2392E-01,  .1442E-01,  .4507E-02,  .1644E+02,  .8113E+01,
     +   .2192E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=1,8)/
     +   .1223E-01,  .7591E-02,  .3198E-02,  .4956E+00,  .1548E+00,
     +   .2206E+01,
     +   .1278E-01,  .7923E-02,  .3280E-02,  .6254E+00,  .2187E+00,
     +   .3329E+01,
     +   .1338E-01,  .8283E-02,  .3368E-02,  .7889E+00,  .2994E+00,
     +   .4885E+01,
     +   .1407E-01,  .8693E-02,  .3464E-02,  .1004E+01,  .4059E+00,
     +   .7134E+01,
     +   .1485E-01,  .9161E-02,  .3572E-02,  .1272E+01,  .5382E+00,
     +   .1048E+02,
     +   .1556E-01,  .9580E-02,  .3666E-02,  .1548E+01,  .6753E+00,
     +   .1415E+02,
     +   .1634E-01,  .1004E-01,  .3768E-02,  .1902E+01,  .8510E+00,
     +   .1895E+02,
     +   .1703E-01,  .1045E-01,  .3855E-02,  .2257E+01,  .1028E+01,
     +   .2386E+02 /
        DATA ((PARTON(I,N,24),I=1,6),N=9,16)/
     +   .1772E-01,  .1086E-01,  .3940E-02,  .2648E+01,  .1222E+01,
     +   .2933E+02,
     +   .1833E-01,  .1122E-01,  .4014E-02,  .3029E+01,  .1412E+01,
     +   .3477E+02,
     +   .1895E-01,  .1158E-01,  .4087E-02,  .3442E+01,  .1617E+01,
     +   .4074E+02,
     +   .1954E-01,  .1193E-01,  .4156E-02,  .3869E+01,  .1830E+01,
     +   .4690E+02,
     +   .2008E-01,  .1225E-01,  .4217E-02,  .4286E+01,  .2038E+01,
     +   .5288E+02,
     +   .2076E-01,  .1264E-01,  .4294E-02,  .4850E+01,  .2319E+01,
     +   .6092E+02,
     +   .2140E-01,  .1302E-01,  .4364E-02,  .5416E+01,  .2601E+01,
     +   .6892E+02,
     +   .2201E-01,  .1337E-01,  .4430E-02,  .5994E+01,  .2889E+01,
     +   .7703E+02 /
        DATA ((PARTON(I,N,24),I=1,6),N=17,24)/
     +   .2259E-01,  .1371E-01,  .4491E-02,  .6566E+01,  .3175E+01,
     +   .8498E+02,
     +   .2317E-01,  .1405E-01,  .4552E-02,  .7171E+01,  .3477E+01,
     +   .9333E+02,
     +   .2372E-01,  .1436E-01,  .4609E-02,  .7769E+01,  .3775E+01,
     +   .1015E+03,
     +   .2425E-01,  .1467E-01,  .4663E-02,  .8374E+01,  .4077E+01,
     +   .1097E+03,
     +   .2475E-01,  .1496E-01,  .4714E-02,  .8966E+01,  .4372E+01,
     +   .1176E+03,
     +   .2544E-01,  .1536E-01,  .4782E-02,  .9800E+01,  .4789E+01,
     +   .1287E+03,
     +   .2605E-01,  .1571E-01,  .4842E-02,  .1058E+02,  .5178E+01,
     +   .1389E+03,
     +   .2668E-01,  .1607E-01,  .4903E-02,  .1141E+02,  .5591E+01,
     +   .1497E+03 /
        DATA ((PARTON(I,N,24),I=1,6),N=25,27)/
     +   .2730E-01,  .1643E-01,  .4962E-02,  .1225E+02,  .6013E+01,
     +   .1605E+03,
     +   .2786E-01,  .1675E-01,  .5015E-02,  .1305E+02,  .6409E+01,
     +   .1705E+03,
     +   .2844E-01,  .1709E-01,  .5069E-02,  .1388E+02,  .6827E+01,
     +   .1809E+03 /
        DATA ((PARTON(I,N,25),I=1,6),N=1,8)/
     +   .1456E-01,  .9028E-02,  .3678E-02,  .4890E+00,  .1443E+00,
     +   .2127E+01,
     +   .1522E-01,  .9425E-02,  .3767E-02,  .6073E+00,  .2025E+00,
     +   .3181E+01,
     +   .1594E-01,  .9854E-02,  .3861E-02,  .7550E+00,  .2752E+00,
     +   .4622E+01,
     +   .1676E-01,  .1034E-01,  .3965E-02,  .9481E+00,  .3705E+00,
     +   .6678E+01,
     +   .1770E-01,  .1090E-01,  .4081E-02,  .1188E+01,  .4890E+00,
     +   .9682E+01,
     +   .1854E-01,  .1140E-01,  .4181E-02,  .1433E+01,  .6106E+00,
     +   .1293E+02,
     +   .1948E-01,  .1195E-01,  .4290E-02,  .1745E+01,  .7653E+00,
     +   .1714E+02,
     +   .2030E-01,  .1244E-01,  .4383E-02,  .2056E+01,  .9196E+00,
     +   .2140E+02 /
        DATA ((PARTON(I,N,25),I=1,6),N=9,16)/
     +   .2112E-01,  .1291E-01,  .4473E-02,  .2395E+01,  .1088E+01,
     +   .2610E+02,
     +   .2185E-01,  .1334E-01,  .4552E-02,  .2724E+01,  .1252E+01,
     +   .3074E+02,
     +   .2259E-01,  .1377E-01,  .4630E-02,  .3078E+01,  .1428E+01,
     +   .3580E+02,
     +   .2330E-01,  .1418E-01,  .4703E-02,  .3443E+01,  .1610E+01,
     +   .4098E+02,
     +   .2394E-01,  .1456E-01,  .4769E-02,  .3798E+01,  .1787E+01,
     +   .4598E+02,
     +   .2475E-01,  .1503E-01,  .4850E-02,  .4275E+01,  .2024E+01,
     +   .5265E+02,
     +   .2551E-01,  .1547E-01,  .4924E-02,  .4751E+01,  .2261E+01,
     +   .5925E+02,
     +   .2624E-01,  .1589E-01,  .4995E-02,  .5235E+01,  .2503E+01,
     +   .6591E+02 /
        DATA ((PARTON(I,N,25),I=1,6),N=17,24)/
     +   .2692E-01,  .1629E-01,  .5060E-02,  .5712E+01,  .2740E+01,
     +   .7239E+02,
     +   .2761E-01,  .1669E-01,  .5124E-02,  .6214E+01,  .2991E+01,
     +   .7916E+02,
     +   .2827E-01,  .1706E-01,  .5184E-02,  .6709E+01,  .3238E+01,
     +   .8576E+02,
     +   .2890E-01,  .1742E-01,  .5242E-02,  .7207E+01,  .3486E+01,
     +   .9233E+02,
     +   .2950E-01,  .1777E-01,  .5296E-02,  .7694E+01,  .3729E+01,
     +   .9868E+02,
     +   .3030E-01,  .1823E-01,  .5367E-02,  .8376E+01,  .4069E+01,
     +   .1075E+03,
     +   .3103E-01,  .1865E-01,  .5431E-02,  .9012E+01,  .4387E+01,
     +   .1156E+03,
     +   .3178E-01,  .1907E-01,  .5495E-02,  .9683E+01,  .4722E+01,
     +   .1241E+03 /
        DATA ((PARTON(I,N,25),I=1,6),N=25,27)/
     +   .3251E-01,  .1949E-01,  .5558E-02,  .1037E+02,  .5063E+01,
     +   .1325E+03,
     +   .3318E-01,  .1987E-01,  .5614E-02,  .1100E+02,  .5381E+01,
     +   .1404E+03,
     +   .3386E-01,  .2026E-01,  .5671E-02,  .1168E+02,  .5717E+01,
     +   .1484E+03 /
        DATA ((PARTON(I,N,26),I=1,6),N=1,8)/
     +   .1686E-01,  .1045E-01,  .4117E-02,  .4846E+00,  .1358E+00,
     +   .2060E+01,
     +   .1763E-01,  .1091E-01,  .4211E-02,  .5938E+00,  .1894E+00,
     +   .3057E+01,
     +   .1847E-01,  .1140E-01,  .4310E-02,  .7291E+00,  .2559E+00,
     +   .4404E+01,
     +   .1942E-01,  .1197E-01,  .4419E-02,  .9048E+00,  .3425E+00,
     +   .6304E+01,
     +   .2051E-01,  .1261E-01,  .4540E-02,  .1123E+01,  .4500E+00,
     +   .9039E+01,
     +   .2150E-01,  .1319E-01,  .4646E-02,  .1344E+01,  .5598E+00,
     +   .1196E+02,
     +   .2258E-01,  .1383E-01,  .4760E-02,  .1624E+01,  .6983E+00,
     +   .1572E+02,
     +   .2354E-01,  .1439E-01,  .4857E-02,  .1900E+01,  .8355E+00,
     +   .1948E+02 /
        DATA ((PARTON(I,N,26),I=1,6),N=9,16)/
     +   .2449E-01,  .1494E-01,  .4951E-02,  .2200E+01,  .9845E+00,
     +   .2361E+02,
     +   .2534E-01,  .1544E-01,  .5034E-02,  .2490E+01,  .1128E+01,
     +   .2766E+02,
     +   .2620E-01,  .1593E-01,  .5115E-02,  .2801E+01,  .1283E+01,
     +   .3203E+02,
     +   .2701E-01,  .1641E-01,  .5192E-02,  .3120E+01,  .1442E+01,
     +   .3649E+02,
     +   .2776E-01,  .1684E-01,  .5260E-02,  .3428E+01,  .1595E+01,
     +   .4077E+02,
     +   .2870E-01,  .1738E-01,  .5345E-02,  .3841E+01,  .1801E+01,
     +   .4645E+02,
     +   .2957E-01,  .1789E-01,  .5422E-02,  .4251E+01,  .2005E+01,
     +   .5204E+02,
     +   .3042E-01,  .1837E-01,  .5496E-02,  .4667E+01,  .2212E+01,
     +   .5764E+02 /
        DATA ((PARTON(I,N,26),I=1,6),N=17,24)/
     +   .3121E-01,  .1883E-01,  .5564E-02,  .5074E+01,  .2415E+01,
     +   .6308E+02,
     +   .3201E-01,  .1928E-01,  .5631E-02,  .5502E+01,  .2629E+01,
     +   .6872E+02,
     +   .3276E-01,  .1971E-01,  .5694E-02,  .5922E+01,  .2838E+01,
     +   .7420E+02,
     +   .3349E-01,  .2013E-01,  .5754E-02,  .6343E+01,  .3048E+01,
     +   .7964E+02,
     +   .3418E-01,  .2052E-01,  .5810E-02,  .6754E+01,  .3253E+01,
     +   .8487E+02,
     +   .3511E-01,  .2105E-01,  .5885E-02,  .7327E+01,  .3539E+01,
     +   .9209E+02,
     +   .3595E-01,  .2153E-01,  .5952E-02,  .7860E+01,  .3805E+01,
     +   .9872E+02,
     +   .3681E-01,  .2202E-01,  .6019E-02,  .8421E+01,  .4084E+01,
     +   .1056E+03 /
        DATA ((PARTON(I,N,26),I=1,6),N=25,27)/
     +   .3765E-01,  .2249E-01,  .6085E-02,  .8989E+01,  .4368E+01,
     +   .1125E+03,
     +   .3842E-01,  .2293E-01,  .6143E-02,  .9519E+01,  .4632E+01,
     +   .1188E+03,
     +   .3920E-01,  .2337E-01,  .6203E-02,  .1007E+02,  .4909E+01,
     +   .1253E+03 /
        DATA ((PARTON(I,N,27),I=1,6),N=1,8)/
     +   .1970E-01,  .1220E-01,  .4613E-02,  .4810E+00,  .1270E+00,
     +   .1988E+01,
     +   .2061E-01,  .1274E-01,  .4711E-02,  .5811E+00,  .1760E+00,
     +   .2925E+01,
     +   .2160E-01,  .1332E-01,  .4814E-02,  .7041E+00,  .2364E+00,
     +   .4176E+01,
     +   .2272E-01,  .1398E-01,  .4928E-02,  .8625E+00,  .3144E+00,
     +   .5919E+01,
     +   .2400E-01,  .1473E-01,  .5054E-02,  .1059E+01,  .4112E+00,
     +   .8386E+01,
     +   .2515E-01,  .1541E-01,  .5164E-02,  .1257E+01,  .5093E+00,
     +   .1099E+02,
     +   .2643E-01,  .1615E-01,  .5282E-02,  .1505E+01,  .6321E+00,
     +   .1431E+02,
     +   .2756E-01,  .1680E-01,  .5384E-02,  .1749E+01,  .7527E+00,
     +   .1760E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=9,16)/
     +   .2867E-01,  .1745E-01,  .5482E-02,  .2011E+01,  .8830E+00,
     +   .2118E+02,
     +   .2966E-01,  .1802E-01,  .5568E-02,  .2264E+01,  .1008E+01,
     +   .2466E+02,
     +   .3066E-01,  .1860E-01,  .5652E-02,  .2533E+01,  .1142E+01,
     +   .2839E+02,
     +   .3162E-01,  .1915E-01,  .5732E-02,  .2808E+01,  .1279E+01,
     +   .3217E+02,
     +   .3249E-01,  .1965E-01,  .5803E-02,  .3073E+01,  .1411E+01,
     +   .3579E+02,
     +   .3358E-01,  .2028E-01,  .5891E-02,  .3426E+01,  .1586E+01,
     +   .4055E+02,
     +   .3461E-01,  .2086E-01,  .5972E-02,  .3774E+01,  .1760E+01,
     +   .4521E+02,
     +   .3559E-01,  .2143E-01,  .6049E-02,  .4126E+01,  .1935E+01,
     +   .4985E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=17,24)/
     +   .3651E-01,  .2195E-01,  .6120E-02,  .4470E+01,  .2106E+01,
     +   .5433E+02,
     +   .3744E-01,  .2248E-01,  .6190E-02,  .4829E+01,  .2285E+01,
     +   .5895E+02,
     +   .3832E-01,  .2298E-01,  .6255E-02,  .5180E+01,  .2460E+01,
     +   .6342E+02,
     +   .3917E-01,  .2346E-01,  .6318E-02,  .5531E+01,  .2635E+01,
     +   .6784E+02,
     +   .3997E-01,  .2391E-01,  .6377E-02,  .5872E+01,  .2805E+01,
     +   .7207E+02,
     +   .4105E-01,  .2452E-01,  .6455E-02,  .6347E+01,  .3042E+01,
     +   .7788E+02,
     +   .4202E-01,  .2507E-01,  .6525E-02,  .6786E+01,  .3261E+01,
     +   .8319E+02,
     +   .4301E-01,  .2563E-01,  .6595E-02,  .7247E+01,  .3491E+01,
     +   .8867E+02 /
        DATA ((PARTON(I,N,27),I=1,6),N=25,27)/
     +   .4399E-01,  .2618E-01,  .6664E-02,  .7712E+01,  .3723E+01,
     +   .9411E+02,
     +   .4488E-01,  .2668E-01,  .6725E-02,  .8144E+01,  .3938E+01,
     +   .9908E+02,
     +   .4579E-01,  .2718E-01,  .6788E-02,  .8596E+01,  .4164E+01,
     +   .1042E+03 /
        DATA ((PARTON(I,N,28),I=1,6),N=1,8)/
     +   .2354E-01,  .1456E-01,  .5204E-02,  .4782E+00,  .1173E+00,
     +   .1905E+01,
     +   .2463E-01,  .1520E-01,  .5305E-02,  .5685E+00,  .1614E+00,
     +   .2775E+01,
     +   .2582E-01,  .1590E-01,  .5412E-02,  .6784E+00,  .2153E+00,
     +   .3920E+01,
     +   .2717E-01,  .1669E-01,  .5529E-02,  .8188E+00,  .2843E+00,
     +   .5493E+01,
     +   .2872E-01,  .1759E-01,  .5660E-02,  .9925E+00,  .3698E+00,
     +   .7678E+01,
     +   .3010E-01,  .1839E-01,  .5774E-02,  .1167E+01,  .4558E+00,
     +   .9954E+01,
     +   .3163E-01,  .1927E-01,  .5896E-02,  .1382E+01,  .5623E+00,
     +   .1281E+02,
     +   .3298E-01,  .2005E-01,  .6002E-02,  .1592E+01,  .6661E+00,
     +   .1563E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=9,16)/
     +   .3431E-01,  .2082E-01,  .6104E-02,  .1816E+01,  .7774E+00,
     +   .1865E+02,
     +   .3550E-01,  .2150E-01,  .6193E-02,  .2031E+01,  .8839E+00,
     +   .2156E+02,
     +   .3669E-01,  .2218E-01,  .6281E-02,  .2259E+01,  .9971E+00,
     +   .2467E+02,
     +   .3783E-01,  .2283E-01,  .6363E-02,  .2490E+01,  .1112E+01,
     +   .2778E+02,
     +   .3887E-01,  .2342E-01,  .6437E-02,  .2711E+01,  .1222E+01,
     +   .3074E+02,
     +   .4018E-01,  .2417E-01,  .6529E-02,  .3005E+01,  .1368E+01,
     +   .3461E+02,
     +   .4140E-01,  .2486E-01,  .6614E-02,  .3293E+01,  .1511E+01,
     +   .3836E+02,
     +   .4257E-01,  .2552E-01,  .6694E-02,  .3582E+01,  .1655E+01,
     +   .4208E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=17,24)/
     +   .4366E-01,  .2614E-01,  .6768E-02,  .3863E+01,  .1795E+01,
     +   .4564E+02,
     +   .4476E-01,  .2676E-01,  .6842E-02,  .4156E+01,  .1941E+01,
     +   .4930E+02,
     +   .4580E-01,  .2734E-01,  .6911E-02,  .4440E+01,  .2083E+01,
     +   .5281E+02,
     +   .4681E-01,  .2791E-01,  .6977E-02,  .4724E+01,  .2224E+01,
     +   .5627E+02,
     +   .4776E-01,  .2844E-01,  .7039E-02,  .4998E+01,  .2361E+01,
     +   .5956E+02,
     +   .4904E-01,  .2916E-01,  .7121E-02,  .5378E+01,  .2550E+01,
     +   .6406E+02,
     +   .5019E-01,  .2980E-01,  .7195E-02,  .5729E+01,  .2725E+01,
     +   .6813E+02,
     +   .5136E-01,  .3045E-01,  .7269E-02,  .6094E+01,  .2907E+01,
     +   .7232E+02 /
        DATA ((PARTON(I,N,28),I=1,6),N=25,27)/
     +   .5251E-01,  .3109E-01,  .7342E-02,  .6462E+01,  .3090E+01,
     +   .7646E+02,
     +   .5356E-01,  .3167E-01,  .7407E-02,  .6802E+01,  .3260E+01,
     +   .8021E+02,
     +   .5463E-01,  .3227E-01,  .7473E-02,  .7157E+01,  .3437E+01,
     +   .8406E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=1,8)/
     +   .2815E-01,  .1738E-01,  .5805E-02,  .4766E+00,  .1080E+00,
     +   .1821E+01,
     +   .2947E-01,  .1816E-01,  .5908E-02,  .5577E+00,  .1475E+00,
     +   .2625E+01,
     +   .3091E-01,  .1899E-01,  .6017E-02,  .6555E+00,  .1953E+00,
     +   .3669E+01,
     +   .3254E-01,  .1994E-01,  .6138E-02,  .7793E+00,  .2561E+00,
     +   .5082E+01,
     +   .3439E-01,  .2101E-01,  .6272E-02,  .9321E+00,  .3312E+00,
     +   .7007E+01,
     +   .3605E-01,  .2196E-01,  .6389E-02,  .1084E+01,  .4061E+00,
     +   .8984E+01,
     +   .3789E-01,  .2302E-01,  .6515E-02,  .1270E+01,  .4981E+00,
     +   .1144E+02,
     +   .3951E-01,  .2394E-01,  .6624E-02,  .1450E+01,  .5869E+00,
     +   .1382E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=9,16)/
     +   .4110E-01,  .2485E-01,  .6729E-02,  .1641E+01,  .6815E+00,
     +   .1636E+02,
     +   .4252E-01,  .2566E-01,  .6822E-02,  .1822E+01,  .7713E+00,
     +   .1878E+02,
     +   .4395E-01,  .2647E-01,  .6913E-02,  .2013E+01,  .8664E+00,
     +   .2134E+02,
     +   .4531E-01,  .2724E-01,  .6999E-02,  .2206E+01,  .9622E+00,
     +   .2388E+02,
     +   .4654E-01,  .2793E-01,  .7077E-02,  .2390E+01,  .1054E+01,
     +   .2628E+02,
     +   .4810E-01,  .2881E-01,  .7173E-02,  .2632E+01,  .1174E+01,
     +   .2940E+02,
     +   .4955E-01,  .2962E-01,  .7262E-02,  .2869E+01,  .1292E+01,
     +   .3240E+02,
     +   .5094E-01,  .3040E-01,  .7347E-02,  .3105E+01,  .1409E+01,
     +   .3534E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=17,24)/
     +   .5224E-01,  .3113E-01,  .7425E-02,  .3333E+01,  .1523E+01,
     +   .3815E+02,
     +   .5355E-01,  .3186E-01,  .7503E-02,  .3570E+01,  .1640E+01,
     +   .4101E+02,
     +   .5478E-01,  .3254E-01,  .7576E-02,  .3799E+01,  .1754E+01,
     +   .4375E+02,
     +   .5597E-01,  .3320E-01,  .7646E-02,  .4026E+01,  .1868E+01,
     +   .4642E+02,
     +   .5709E-01,  .3382E-01,  .7712E-02,  .4244E+01,  .1977E+01,
     +   .4895E+02,
     +   .5860E-01,  .3466E-01,  .7800E-02,  .4546E+01,  .2127E+01,
     +   .5238E+02,
     +   .5995E-01,  .3541E-01,  .7878E-02,  .4823E+01,  .2265E+01,
     +   .5548E+02,
     +   .6133E-01,  .3617E-01,  .7957E-02,  .5111E+01,  .2408E+01,
     +   .5864E+02 /
        DATA ((PARTON(I,N,29),I=1,6),N=25,27)/
     +   .6269E-01,  .3692E-01,  .8035E-02,  .5399E+01,  .2552E+01,
     +   .6174E+02,
     +   .6392E-01,  .3759E-01,  .8105E-02,  .5665E+01,  .2684E+01,
     +   .6454E+02,
     +   .6517E-01,  .3828E-01,  .8176E-02,  .5940E+01,  .2822E+01,
     +   .6739E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=1,8)/
     +   .3360E-01,  .2072E-01,  .6377E-02,  .4760E+00,  .9905E-01,
     +   .1737E+01,
     +   .3519E-01,  .2164E-01,  .6482E-02,  .5486E+00,  .1344E+00,
     +   .2479E+01,
     +   .3692E-01,  .2264E-01,  .6593E-02,  .6353E+00,  .1768E+00,
     +   .3428E+01,
     +   .3888E-01,  .2376E-01,  .6717E-02,  .7442E+00,  .2301E+00,
     +   .4692E+01,
     +   .4111E-01,  .2504E-01,  .6854E-02,  .8782E+00,  .2960E+00,
     +   .6383E+01,
     +   .4310E-01,  .2617E-01,  .6975E-02,  .1010E+01,  .3610E+00,
     +   .8095E+01,
     +   .4529E-01,  .2742E-01,  .7105E-02,  .1170E+01,  .4401E+00,
     +   .1019E+02,
     +   .4723E-01,  .2852E-01,  .7219E-02,  .1324E+01,  .5159E+00,
     +   .1220E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=9,16)/
     +   .4913E-01,  .2959E-01,  .7329E-02,  .1485E+01,  .5959E+00,
     +   .1432E+02,
     +   .5082E-01,  .3054E-01,  .7426E-02,  .1638E+01,  .6715E+00,
     +   .1633E+02,
     +   .5252E-01,  .3149E-01,  .7522E-02,  .1798E+01,  .7510E+00,
     +   .1842E+02,
     +   .5413E-01,  .3240E-01,  .7614E-02,  .1958E+01,  .8307E+00,
     +   .2049E+02,
     +   .5560E-01,  .3322E-01,  .7696E-02,  .2110E+01,  .9062E+00,
     +   .2243E+02,
     +   .5744E-01,  .3424E-01,  .7798E-02,  .2310E+01,  .1005E+01,
     +   .2492E+02,
     +   .5916E-01,  .3520E-01,  .7893E-02,  .2503E+01,  .1101E+01,
     +   .2730E+02,
     +   .6080E-01,  .3611E-01,  .7984E-02,  .2695E+01,  .1197E+01,
     +   .2962E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=17,24)/
     +   .6234E-01,  .3696E-01,  .8068E-02,  .2879E+01,  .1289E+01,
     +   .3182E+02,
     +   .6388E-01,  .3781E-01,  .8152E-02,  .3069E+01,  .1383E+01,
     +   .3404E+02,
     +   .6533E-01,  .3860E-01,  .8231E-02,  .3253E+01,  .1475E+01,
     +   .3615E+02,
     +   .6672E-01,  .3937E-01,  .8306E-02,  .3434E+01,  .1565E+01,
     +   .3820E+02,
     +   .6804E-01,  .4009E-01,  .8378E-02,  .3607E+01,  .1651E+01,
     +   .4013E+02,
     +   .6981E-01,  .4106E-01,  .8473E-02,  .3846E+01,  .1770E+01,
     +   .4274E+02,
     +   .7140E-01,  .4193E-01,  .8559E-02,  .4064E+01,  .1879E+01,
     +   .4507E+02,
     +   .7301E-01,  .4281E-01,  .8645E-02,  .4289E+01,  .1991E+01,
     +   .4743E+02 /
        DATA ((PARTON(I,N,30),I=1,6),N=25,27)/
     +   .7459E-01,  .4367E-01,  .8730E-02,  .4513E+01,  .2103E+01,
     +   .4973E+02,
     +   .7603E-01,  .4445E-01,  .8807E-02,  .4719E+01,  .2205E+01,
     +   .5180E+02,
     +   .7749E-01,  .4524E-01,  .8885E-02,  .4931E+01,  .2311E+01,
     +   .5389E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=1,8)/
     +   .4022E-01,  .2475E-01,  .6900E-02,  .4761E+00,  .9035E-01,
     +   .1652E+01,
     +   .4215E-01,  .2586E-01,  .7008E-02,  .5405E+00,  .1217E+00,
     +   .2332E+01,
     +   .4423E-01,  .2705E-01,  .7122E-02,  .6169E+00,  .1591E+00,
     +   .3190E+01,
     +   .4660E-01,  .2840E-01,  .7251E-02,  .7120E+00,  .2057E+00,
     +   .4314E+01,
     +   .4928E-01,  .2992E-01,  .7395E-02,  .8285E+00,  .2630E+00,
     +   .5789E+01,
     +   .5166E-01,  .3126E-01,  .7522E-02,  .9422E+00,  .3190E+00,
     +   .7260E+01,
     +   .5429E-01,  .3274E-01,  .7661E-02,  .1079E+01,  .3866E+00,
     +   .9037E+01,
     +   .5660E-01,  .3404E-01,  .7782E-02,  .1209E+01,  .4507E+00,
     +   .1072E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=9,16)/
     +   .5887E-01,  .3530E-01,  .7900E-02,  .1344E+01,  .5179E+00,
     +   .1247E+02,
     +   .6089E-01,  .3643E-01,  .8005E-02,  .1471E+01,  .5809E+00,
     +   .1411E+02,
     +   .6291E-01,  .3755E-01,  .8110E-02,  .1604E+01,  .6469E+00,
     +   .1581E+02,
     +   .6483E-01,  .3861E-01,  .8209E-02,  .1736E+01,  .7125E+00,
     +   .1748E+02,
     +   .6657E-01,  .3957E-01,  .8299E-02,  .1861E+01,  .7744E+00,
     +   .1902E+02,
     +   .6875E-01,  .4077E-01,  .8412E-02,  .2023E+01,  .8550E+00,
     +   .2099E+02,
     +   .7078E-01,  .4188E-01,  .8517E-02,  .2179E+01,  .9327E+00,
     +   .2286E+02,
     +   .7272E-01,  .4295E-01,  .8617E-02,  .2333E+01,  .1009E+01,
     +   .2466E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=17,24)/
     +   .7452E-01,  .4393E-01,  .8710E-02,  .2481E+01,  .1083E+01,
     +   .2635E+02,
     +   .7633E-01,  .4492E-01,  .8804E-02,  .2632E+01,  .1158E+01,
     +   .2805E+02,
     +   .7803E-01,  .4584E-01,  .8892E-02,  .2777E+01,  .1231E+01,
     +   .2966E+02,
     +   .7967E-01,  .4673E-01,  .8977E-02,  .2920E+01,  .1302E+01,
     +   .3120E+02,
     +   .8121E-01,  .4757E-01,  .9057E-02,  .3056E+01,  .1369E+01,
     +   .3265E+02,
     +   .8329E-01,  .4869E-01,  .9164E-02,  .3242E+01,  .1462E+01,
     +   .3459E+02,
     +   .8514E-01,  .4968E-01,  .9260E-02,  .3411E+01,  .1547E+01,
     +   .3631E+02,
     +   .8702E-01,  .5070E-01,  .9358E-02,  .3585E+01,  .1633E+01,
     +   .3804E+02 /
        DATA ((PARTON(I,N,31),I=1,6),N=25,27)/
     +   .8885E-01,  .5168E-01,  .9453E-02,  .3757E+01,  .1719E+01,
     +   .3972E+02,
     +   .9052E-01,  .5257E-01,  .9540E-02,  .3915E+01,  .1798E+01,
     +   .4121E+02,
     +   .9221E-01,  .5348E-01,  .9628E-02,  .4076E+01,  .1879E+01,
     +   .4272E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=1,8)/
     +   .4687E-01,  .2879E-01,  .7268E-02,  .4763E+00,  .8326E-01,
     +   .1580E+01,
     +   .4913E-01,  .3008E-01,  .7381E-02,  .5343E+00,  .1115E+00,
     +   .2211E+01,
     +   .5158E-01,  .3146E-01,  .7503E-02,  .6026E+00,  .1450E+00,
     +   .2994E+01,
     +   .5435E-01,  .3303E-01,  .7640E-02,  .6869E+00,  .1863E+00,
     +   .4007E+01,
     +   .5748E-01,  .3478E-01,  .7795E-02,  .7898E+00,  .2370E+00,
     +   .5316E+01,
     +   .6026E-01,  .3634E-01,  .7932E-02,  .8895E+00,  .2862E+00,
     +   .6603E+01,
     +   .6332E-01,  .3804E-01,  .8084E-02,  .1008E+01,  .3450E+00,
     +   .8140E+01,
     +   .6600E-01,  .3953E-01,  .8217E-02,  .1120E+01,  .4004E+00,
     +   .9579E+01 /
        DATA ((PARTON(I,N,32),I=1,6),N=9,16)/
     +   .6863E-01,  .4099E-01,  .8348E-02,  .1236E+01,  .4580E+00,
     +   .1106E+02,
     +   .7097E-01,  .4227E-01,  .8465E-02,  .1345E+01,  .5119E+00,
     +   .1244E+02,
     +   .7330E-01,  .4355E-01,  .8581E-02,  .1457E+01,  .5678E+00,
     +   .1385E+02,
     +   .7551E-01,  .4476E-01,  .8692E-02,  .1569E+01,  .6232E+00,
     +   .1522E+02,
     +   .7751E-01,  .4586E-01,  .8793E-02,  .1673E+01,  .6752E+00,
     +   .1648E+02,
     +   .8002E-01,  .4722E-01,  .8920E-02,  .1808E+01,  .7425E+00,
     +   .1809E+02,
     +   .8235E-01,  .4849E-01,  .9038E-02,  .1938E+01,  .8070E+00,
     +   .1959E+02,
     +   .8457E-01,  .4969E-01,  .9151E-02,  .2065E+01,  .8705E+00,
     +   .2103E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=17,24)/
     +   .8664E-01,  .5081E-01,  .9257E-02,  .2186E+01,  .9308E+00,
     +   .2238E+02,
     +   .8871E-01,  .5192E-01,  .9363E-02,  .2310E+01,  .9925E+00,
     +   .2372E+02,
     +   .9065E-01,  .5296E-01,  .9462E-02,  .2428E+01,  .1051E+01,
     +   .2498E+02,
     +   .9251E-01,  .5397E-01,  .9559E-02,  .2544E+01,  .1109E+01,
     +   .2618E+02,
     +   .9426E-01,  .5490E-01,  .9650E-02,  .2653E+01,  .1164E+01,
     +   .2730E+02,
     +   .9662E-01,  .5616E-01,  .9772E-02,  .2803E+01,  .1239E+01,
     +   .2879E+02,
     +   .9871E-01,  .5728E-01,  .9881E-02,  .2938E+01,  .1306E+01,
     +   .3011E+02,
     +   .1008E+00,  .5840E-01,  .9992E-02,  .3077E+01,  .1375E+01,
     +   .3142E+02 /
        DATA ((PARTON(I,N,32),I=1,6),N=25,27)/
     +   .1029E+00,  .5950E-01,  .1010E-01,  .3213E+01,  .1444E+01,
     +   .3268E+02,
     +   .1048E+00,  .6049E-01,  .1020E-01,  .3337E+01,  .1506E+01,
     +   .3380E+02,
     +   .1067E+00,  .6150E-01,  .1030E-01,  .3465E+01,  .1569E+01,
     +   .3492E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=1,8)/
     +   .5525E-01,  .3386E-01,  .7558E-02,  .4764E+00,  .7594E-01,
     +   .1504E+01,
     +   .5795E-01,  .3538E-01,  .7684E-02,  .5279E+00,  .1012E+00,
     +   .2083E+01,
     +   .6085E-01,  .3700E-01,  .7822E-02,  .5880E+00,  .1307E+00,
     +   .2792E+01,
     +   .6412E-01,  .3883E-01,  .7978E-02,  .6617E+00,  .1670E+00,
     +   .3694E+01,
     +   .6781E-01,  .4088E-01,  .8156E-02,  .7512E+00,  .2112E+00,
     +   .4839E+01,
     +   .7108E-01,  .4269E-01,  .8314E-02,  .8373E+00,  .2538E+00,
     +   .5949E+01,
     +   .7467E-01,  .4467E-01,  .8490E-02,  .9389E+00,  .3043E+00,
     +   .7257E+01,
     +   .7781E-01,  .4639E-01,  .8645E-02,  .1034E+01,  .3514E+00,
     +   .8466E+01 /
        DATA ((PARTON(I,N,33),I=1,6),N=9,16)/
     +   .8088E-01,  .4807E-01,  .8798E-02,  .1132E+01,  .4000E+00,
     +   .9698E+01,
     +   .8361E-01,  .4955E-01,  .8935E-02,  .1222E+01,  .4452E+00,
     +   .1083E+02,
     +   .8631E-01,  .5102E-01,  .9072E-02,  .1316E+01,  .4919E+00,
     +   .1198E+02,
     +   .8888E-01,  .5241E-01,  .9202E-02,  .1408E+01,  .5378E+00,
     +   .1308E+02,
     +   .9120E-01,  .5366E-01,  .9321E-02,  .1494E+01,  .5806E+00,
     +   .1409E+02,
     +   .9410E-01,  .5522E-01,  .9471E-02,  .1604E+01,  .6357E+00,
     +   .1536E+02,
     +   .9678E-01,  .5665E-01,  .9611E-02,  .1709E+01,  .6883E+00,
     +   .1655E+02,
     +   .9934E-01,  .5802E-01,  .9745E-02,  .1812E+01,  .7396E+00,
     +   .1767E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=17,24)/
     +   .1017E+00,  .5929E-01,  .9870E-02,  .1909E+01,  .7882E+00,
     +   .1871E+02,
     +   .1041E+00,  .6054E-01,  .9995E-02,  .2008E+01,  .8376E+00,
     +   .1974E+02,
     +   .1063E+00,  .6172E-01,  .1011E-01,  .2102E+01,  .8846E+00,
     +   .2069E+02,
     +   .1084E+00,  .6285E-01,  .1023E-01,  .2193E+01,  .9304E+00,
     +   .2160E+02,
     +   .1104E+00,  .6390E-01,  .1033E-01,  .2280E+01,  .9737E+00,
     +   .2244E+02,
     +   .1131E+00,  .6531E-01,  .1048E-01,  .2397E+01,  .1032E+01,
     +   .2356E+02,
     +   .1155E+00,  .6656E-01,  .1061E-01,  .2502E+01,  .1085E+01,
     +   .2453E+02,
     +   .1179E+00,  .6782E-01,  .1074E-01,  .2610E+01,  .1139E+01,
     +   .2549E+02 /
        DATA ((PARTON(I,N,33),I=1,6),N=25,27)/
     +   .1202E+00,  .6904E-01,  .1087E-01,  .2715E+01,  .1192E+01,
     +   .2640E+02,
     +   .1223E+00,  .7014E-01,  .1098E-01,  .2811E+01,  .1240E+01,
     +   .2721E+02,
     +   .1245E+00,  .7125E-01,  .1110E-01,  .2908E+01,  .1288E+01,
     +   .2801E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=1,8)/
     +   .6690E-01,  .4087E-01,  .7746E-02,  .4757E+00,  .6790E-01,
     +   .1417E+01,
     +   .7017E-01,  .4269E-01,  .7905E-02,  .5202E+00,  .8986E-01,
     +   .1939E+01,
     +   .7369E-01,  .4463E-01,  .8078E-02,  .5717E+00,  .1154E+00,
     +   .2567E+01,
     +   .7766E-01,  .4682E-01,  .8277E-02,  .6342E+00,  .1464E+00,
     +   .3353E+01,
     +   .8211E-01,  .4926E-01,  .8502E-02,  .7097E+00,  .1840E+00,
     +   .4329E+01,
     +   .8603E-01,  .5140E-01,  .8703E-02,  .7815E+00,  .2198E+00,
     +   .5258E+01,
     +   .9033E-01,  .5373E-01,  .8927E-02,  .8656E+00,  .2618E+00,
     +   .6334E+01,
     +   .9408E-01,  .5575E-01,  .9125E-02,  .9432E+00,  .3006E+00,
     +   .7315E+01 /
        DATA ((PARTON(I,N,34),I=1,6),N=9,16)/
     +   .9773E-01,  .5772E-01,  .9321E-02,  .1023E+01,  .3403E+00,
     +   .8300E+01,
     +   .1010E+00,  .5945E-01,  .9496E-02,  .1096E+01,  .3769E+00,
     +   .9191E+01,
     +   .1042E+00,  .6116E-01,  .9670E-02,  .1171E+01,  .4145E+00,
     +   .1009E+02,
     +   .1072E+00,  .6276E-01,  .9837E-02,  .1244E+01,  .4512E+00,
     +   .1094E+02,
     +   .1099E+00,  .6421E-01,  .9988E-02,  .1311E+01,  .4851E+00,
     +   .1171E+02,
     +   .1133E+00,  .6601E-01,  .1018E-01,  .1398E+01,  .5286E+00,
     +   .1267E+02,
     +   .1164E+00,  .6766E-01,  .1036E-01,  .1480E+01,  .5697E+00,
     +   .1355E+02,
     +   .1194E+00,  .6922E-01,  .1052E-01,  .1559E+01,  .6095E+00,
     +   .1438E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=17,24)/
     +   .1222E+00,  .7067E-01,  .1068E-01,  .1633E+01,  .6470E+00,
     +   .1514E+02,
     +   .1249E+00,  .7210E-01,  .1084E-01,  .1709E+01,  .6849E+00,
     +   .1589E+02,
     +   .1275E+00,  .7343E-01,  .1099E-01,  .1780E+01,  .7207E+00,
     +   .1657E+02,
     +   .1299E+00,  .7471E-01,  .1113E-01,  .1848E+01,  .7554E+00,
     +   .1722E+02,
     +   .1322E+00,  .7589E-01,  .1126E-01,  .1913E+01,  .7880E+00,
     +   .1781E+02,
     +   .1353E+00,  .7748E-01,  .1144E-01,  .2000E+01,  .8320E+00,
     +   .1858E+02,
     +   .1380E+00,  .7888E-01,  .1160E-01,  .2078E+01,  .8713E+00,
     +   .1925E+02,
     +   .1408E+00,  .8028E-01,  .1177E-01,  .2157E+01,  .9110E+00,
     +   .1991E+02 /
        DATA ((PARTON(I,N,34),I=1,6),N=25,27)/
     +   .1434E+00,  .8164E-01,  .1192E-01,  .2234E+01,  .9499E+00,
     +   .2052E+02,
     +   .1458E+00,  .8287E-01,  .1207E-01,  .2303E+01,  .9848E+00,
     +   .2106E+02,
     +   .1482E+00,  .8410E-01,  .1221E-01,  .2373E+01,  .1020E+01,
     +   .2158E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=1,8)/
     +   .8146E-01,  .4957E-01,  .7818E-02,  .4734E+00,  .6016E-01,
     +   .1331E+01,
     +   .8545E-01,  .5175E-01,  .8039E-02,  .5112E+00,  .7913E-01,
     +   .1798E+01,
     +   .8972E-01,  .5408E-01,  .8280E-02,  .5546E+00,  .1010E+00,
     +   .2350E+01,
     +   .9452E-01,  .5668E-01,  .8554E-02,  .6068E+00,  .1273E+00,
     +   .3027E+01,
     +   .9986E-01,  .5956E-01,  .8863E-02,  .6695E+00,  .1589E+00,
     +   .3850E+01,
     +   .1046E+00,  .6209E-01,  .9139E-02,  .7285E+00,  .1887E+00,
     +   .4619E+01,
     +   .1097E+00,  .6482E-01,  .9444E-02,  .7968E+00,  .2232E+00,
     +   .5493E+01,
     +   .1141E+00,  .6718E-01,  .9712E-02,  .8593E+00,  .2548E+00,
     +   .6277E+01 /
        DATA ((PARTON(I,N,35),I=1,6),N=9,16)/
     +   .1185E+00,  .6946E-01,  .9976E-02,  .9226E+00,  .2869E+00,
     +   .7052E+01,
     +   .1223E+00,  .7146E-01,  .1021E-01,  .9804E+00,  .3162E+00,
     +   .7743E+01,
     +   .1260E+00,  .7343E-01,  .1044E-01,  .1039E+01,  .3460E+00,
     +   .8430E+01,
     +   .1295E+00,  .7527E-01,  .1066E-01,  .1096E+01,  .3749E+00,
     +   .9075E+01,
     +   .1327E+00,  .7692E-01,  .1086E-01,  .1148E+01,  .4014E+00,
     +   .9651E+01,
     +   .1367E+00,  .7897E-01,  .1111E-01,  .1215E+01,  .4352E+00,
     +   .1036E+02,
     +   .1403E+00,  .8084E-01,  .1134E-01,  .1277E+01,  .4668E+00,
     +   .1100E+02,
     +   .1437E+00,  .8261E-01,  .1156E-01,  .1337E+01,  .4972E+00,
     +   .1160E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=17,24)/
     +   .1469E+00,  .8423E-01,  .1177E-01,  .1393E+01,  .5257E+00,
     +   .1214E+02,
     +   .1500E+00,  .8583E-01,  .1197E-01,  .1449E+01,  .5542E+00,
     +   .1266E+02,
     +   .1529E+00,  .8732E-01,  .1216E-01,  .1501E+01,  .5810E+00,
     +   .1314E+02,
     +   .1557E+00,  .8874E-01,  .1234E-01,  .1552E+01,  .6068E+00,
     +   .1358E+02,
     +   .1583E+00,  .9006E-01,  .1251E-01,  .1599E+01,  .6309E+00,
     +   .1398E+02,
     +   .1618E+00,  .9180E-01,  .1273E-01,  .1663E+01,  .6632E+00,
     +   .1450E+02,
     +   .1649E+00,  .9334E-01,  .1293E-01,  .1719E+01,  .6918E+00,
     +   .1494E+02,
     +   .1679E+00,  .9488E-01,  .1314E-01,  .1775E+01,  .7206E+00,
     +   .1537E+02 /
        DATA ((PARTON(I,N,35),I=1,6),N=25,27)/
     +   .1709E+00,  .9637E-01,  .1333E-01,  .1830E+01,  .7485E+00,
     +   .1577E+02,
     +   .1736E+00,  .9769E-01,  .1350E-01,  .1878E+01,  .7734E+00,
     +   .1611E+02,
     +   .1763E+00,  .9903E-01,  .1368E-01,  .1927E+01,  .7986E+00,
     +   .1644E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=1,8)/
     +   .9957E-01,  .6031E-01,  .7930E-02,  .4686E+00,  .5290E-01,
     +   .1247E+01,
     +   .1044E+00,  .6290E-01,  .8254E-02,  .5002E+00,  .6917E-01,
     +   .1663E+01,
     +   .1096E+00,  .6566E-01,  .8604E-02,  .5361E+00,  .8771E-01,
     +   .2144E+01,
     +   .1153E+00,  .6872E-01,  .8998E-02,  .5791E+00,  .1098E+00,
     +   .2723E+01,
     +   .1217E+00,  .7210E-01,  .9439E-02,  .6302E+00,  .1362E+00,
     +   .3410E+01,
     +   .1273E+00,  .7503E-01,  .9828E-02,  .6778E+00,  .1608E+00,
     +   .4040E+01,
     +   .1333E+00,  .7819E-01,  .1025E-01,  .7324E+00,  .1889E+00,
     +   .4742E+01,
     +   .1385E+00,  .8091E-01,  .1062E-01,  .7818E+00,  .2145E+00,
     +   .5360E+01 /
        DATA ((PARTON(I,N,36),I=1,6),N=9,16)/
     +   .1436E+00,  .8351E-01,  .1098E-01,  .8313E+00,  .2401E+00,
     +   .5961E+01,
     +   .1480E+00,  .8579E-01,  .1130E-01,  .8762E+00,  .2633E+00,
     +   .6489E+01,
     +   .1523E+00,  .8801E-01,  .1161E-01,  .9214E+00,  .2867E+00,
     +   .7005E+01,
     +   .1564E+00,  .9009E-01,  .1190E-01,  .9649E+00,  .3091E+00,
     +   .7484E+01,
     +   .1600E+00,  .9194E-01,  .1217E-01,  .1005E+01,  .3297E+00,
     +   .7906E+01,
     +   .1646E+00,  .9422E-01,  .1249E-01,  .1054E+01,  .3555E+00,
     +   .8418E+01,
     +   .1687E+00,  .9630E-01,  .1279E-01,  .1101E+01,  .3795E+00,
     +   .8875E+01,
     +   .1726E+00,  .9825E-01,  .1308E-01,  .1145E+01,  .4024E+00,
     +   .9293E+01 /
        DATA ((PARTON(I,N,36),I=1,6),N=17,24)/
     +   .1761E+00,  .1000E+00,  .1333E-01,  .1186E+01,  .4237E+00,
     +   .9666E+01,
     +   .1797E+00,  .1018E+00,  .1359E-01,  .1227E+01,  .4448E+00,
     +   .1002E+02,
     +   .1829E+00,  .1034E+00,  .1383E-01,  .1264E+01,  .4645E+00,
     +   .1034E+02,
     +   .1860E+00,  .1049E+00,  .1405E-01,  .1301E+01,  .4834E+00,
     +   .1064E+02,
     +   .1889E+00,  .1064E+00,  .1426E-01,  .1334E+01,  .5009E+00,
     +   .1090E+02,
     +   .1927E+00,  .1082E+00,  .1454E-01,  .1379E+01,  .5242E+00,
     +   .1123E+02,
     +   .1961E+00,  .1099E+00,  .1478E-01,  .1418E+01,  .5447E+00,
     +   .1151E+02,
     +   .1995E+00,  .1115E+00,  .1503E-01,  .1457E+01,  .5651E+00,
     +   .1178E+02 /
        DATA ((PARTON(I,N,36),I=1,6),N=25,27)/
     +   .2027E+00,  .1131E+00,  .1526E-01,  .1495E+01,  .5847E+00,
     +   .1202E+02,
     +   .2056E+00,  .1145E+00,  .1547E-01,  .1528E+01,  .6022E+00,
     +   .1222E+02,
     +   .2085E+00,  .1159E+00,  .1567E-01,  .1561E+01,  .6196E+00,
     +   .1241E+02 /
        DATA ((PARTON(I,N,37),I=1,6),N=1,8)/
     +   .1230E+00,  .7406E-01,  .8459E-02,  .4599E+00,  .4597E-01,
     +   .1165E+01,
     +   .1288E+00,  .7712E-01,  .8939E-02,  .4856E+00,  .5976E-01,
     +   .1531E+01,
     +   .1350E+00,  .8036E-01,  .9450E-02,  .5146E+00,  .7533E-01,
     +   .1946E+01,
     +   .1419E+00,  .8393E-01,  .1002E-01,  .5489E+00,  .9372E-01,
     +   .2433E+01,
     +   .1494E+00,  .8783E-01,  .1064E-01,  .5894E+00,  .1154E+00,
     +   .2999E+01,
     +   .1560E+00,  .9119E-01,  .1119E-01,  .6268E+00,  .1354E+00,
     +   .3505E+01,
     +   .1630E+00,  .9479E-01,  .1177E-01,  .6691E+00,  .1580E+00,
     +   .4057E+01,
     +   .1691E+00,  .9785E-01,  .1227E-01,  .7069E+00,  .1782E+00,
     +   .4533E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=9,16)/
     +   .1749E+00,  .1008E+00,  .1276E-01,  .7445E+00,  .1983E+00,
     +   .4987E+01,
     +   .1799E+00,  .1033E+00,  .1317E-01,  .7782E+00,  .2163E+00,
     +   .5379E+01,
     +   .1849E+00,  .1058E+00,  .1358E-01,  .8119E+00,  .2343E+00,
     +   .5756E+01,
     +   .1895E+00,  .1081E+00,  .1396E-01,  .8439E+00,  .2514E+00,
     +   .6099E+01,
     +   .1936E+00,  .1101E+00,  .1430E-01,  .8728E+00,  .2669E+00,
     +   .6397E+01,
     +   .1986E+00,  .1126E+00,  .1471E-01,  .9089E+00,  .2862E+00,
     +   .6753E+01,
     +   .2032E+00,  .1148E+00,  .1508E-01,  .9420E+00,  .3040E+00,
     +   .7064E+01,
     +   .2075E+00,  .1169E+00,  .1543E-01,  .9733E+00,  .3208E+00,
     +   .7344E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=17,24)/
     +   .2115E+00,  .1188E+00,  .1575E-01,  .1002E+01,  .3363E+00,
     +   .7589E+01,
     +   .2153E+00,  .1206E+00,  .1606E-01,  .1030E+01,  .3515E+00,
     +   .7819E+01,
     +   .2189E+00,  .1223E+00,  .1634E-01,  .1057E+01,  .3656E+00,
     +   .8021E+01,
     +   .2223E+00,  .1239E+00,  .1661E-01,  .1081E+01,  .3790E+00,
     +   .8204E+01,
     +   .2254E+00,  .1254E+00,  .1685E-01,  .1104E+01,  .3914E+00,
     +   .8364E+01,
     +   .2295E+00,  .1274E+00,  .1717E-01,  .1134E+01,  .4076E+00,
     +   .8563E+01,
     +   .2331E+00,  .1290E+00,  .1745E-01,  .1160E+01,  .4218E+00,
     +   .8725E+01,
     +   .2366E+00,  .1307E+00,  .1773E-01,  .1186E+01,  .4358E+00,
     +   .8875E+01 /
        DATA ((PARTON(I,N,37),I=1,6),N=25,27)/
     +   .2400E+00,  .1323E+00,  .1799E-01,  .1210E+01,  .4491E+00,
     +   .9007E+01,
     +   .2431E+00,  .1337E+00,  .1822E-01,  .1232E+01,  .4608E+00,
     +   .9114E+01,
     +   .2461E+00,  .1351E+00,  .1845E-01,  .1253E+01,  .4724E+00,
     +   .9213E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=1,8)/
     +   .1482E+00,  .8868E-01,  .9743E-02,  .4488E+00,  .4050E-01,
     +   .1099E+01,
     +   .1549E+00,  .9215E-01,  .1039E-01,  .4698E+00,  .5240E-01,
     +   .1425E+01,
     +   .1621E+00,  .9580E-01,  .1107E-01,  .4933E+00,  .6571E-01,
     +   .1787E+01,
     +   .1699E+00,  .9979E-01,  .1181E-01,  .5210E+00,  .8128E-01,
     +   .2203E+01,
     +   .1785E+00,  .1041E+00,  .1262E-01,  .5534E+00,  .9945E-01,
     +   .2676E+01,
     +   .1859E+00,  .1078E+00,  .1331E-01,  .5829E+00,  .1160E+00,
     +   .3090E+01,
     +   .1938E+00,  .1117E+00,  .1404E-01,  .6160E+00,  .1345E+00,
     +   .3533E+01,
     +   .2006E+00,  .1151E+00,  .1466E-01,  .6453E+00,  .1509E+00,
     +   .3907E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=9,16)/
     +   .2070E+00,  .1182E+00,  .1525E-01,  .6741E+00,  .1670E+00,
     +   .4257E+01,
     +   .2126E+00,  .1209E+00,  .1575E-01,  .6997E+00,  .1813E+00,
     +   .4554E+01,
     +   .2180E+00,  .1235E+00,  .1623E-01,  .7251E+00,  .1955E+00,
     +   .4835E+01,
     +   .2230E+00,  .1259E+00,  .1667E-01,  .7489E+00,  .2089E+00,
     +   .5086E+01,
     +   .2274E+00,  .1280E+00,  .1706E-01,  .7703E+00,  .2209E+00,
     +   .5301E+01,
     +   .2328E+00,  .1306E+00,  .1753E-01,  .7967E+00,  .2357E+00,
     +   .5553E+01,
     +   .2377E+00,  .1329E+00,  .1795E-01,  .8207E+00,  .2492E+00,
     +   .5768E+01,
     +   .2423E+00,  .1350E+00,  .1834E-01,  .8431E+00,  .2619E+00,
     +   .5958E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=17,24)/
     +   .2464E+00,  .1369E+00,  .1869E-01,  .8635E+00,  .2734E+00,
     +   .6121E+01,
     +   .2505E+00,  .1388E+00,  .1902E-01,  .8834E+00,  .2847E+00,
     +   .6271E+01,
     +   .2542E+00,  .1405E+00,  .1933E-01,  .9016E+00,  .2951E+00,
     +   .6400E+01,
     +   .2577E+00,  .1421E+00,  .1961E-01,  .9186E+00,  .3048E+00,
     +   .6514E+01,
     +   .2609E+00,  .1436E+00,  .1987E-01,  .9342E+00,  .3137E+00,
     +   .6611E+01,
     +   .2651E+00,  .1454E+00,  .2020E-01,  .9544E+00,  .3254E+00,
     +   .6728E+01,
     +   .2687E+00,  .1471E+00,  .2049E-01,  .9718E+00,  .3354E+00,
     +   .6820E+01,
     +   .2723E+00,  .1487E+00,  .2077E-01,  .9887E+00,  .3453E+00,
     +   .6901E+01 /
        DATA ((PARTON(I,N,38),I=1,6),N=25,27)/
     +   .2757E+00,  .1502E+00,  .2103E-01,  .1005E+01,  .3545E+00,
     +   .6969E+01,
     +   .2787E+00,  .1515E+00,  .2125E-01,  .1018E+01,  .3626E+00,
     +   .7021E+01,
     +   .2817E+00,  .1528E+00,  .2147E-01,  .1032E+01,  .3706E+00,
     +   .7066E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=1,8)/
     +   .1823E+00,  .1082E+00,  .1270E-01,  .4322E+00,  .3510E-01,
     +   .1034E+01,
     +   .1901E+00,  .1121E+00,  .1353E-01,  .4485E+00,  .4517E-01,
     +   .1318E+01,
     +   .1983E+00,  .1161E+00,  .1438E-01,  .4667E+00,  .5633E-01,
     +   .1627E+01,
     +   .2072E+00,  .1205E+00,  .1530E-01,  .4878E+00,  .6922E-01,
     +   .1974E+01,
     +   .2168E+00,  .1252E+00,  .1628E-01,  .5123E+00,  .8408E-01,
     +   .2358E+01,
     +   .2251E+00,  .1292E+00,  .1711E-01,  .5344E+00,  .9744E-01,
     +   .2685E+01,
     +   .2338E+00,  .1333E+00,  .1796E-01,  .5589E+00,  .1122E+00,
     +   .3027E+01,
     +   .2412E+00,  .1368E+00,  .1866E-01,  .5802E+00,  .1250E+00,
     +   .3308E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=9,16)/
     +   .2481E+00,  .1401E+00,  .1932E-01,  .6009E+00,  .1376E+00,
     +   .3565E+01,
     +   .2541E+00,  .1428E+00,  .1987E-01,  .6191E+00,  .1485E+00,
     +   .3778E+01,
     +   .2598E+00,  .1455E+00,  .2039E-01,  .6369E+00,  .1593E+00,
     +   .3975E+01,
     +   .2651E+00,  .1479E+00,  .2086E-01,  .6534E+00,  .1693E+00,
     +   .4148E+01,
     +   .2697E+00,  .1500E+00,  .2127E-01,  .6680E+00,  .1782E+00,
     +   .4292E+01,
     +   .2753E+00,  .1525E+00,  .2175E-01,  .6858E+00,  .1891E+00,
     +   .4456E+01,
     +   .2804E+00,  .1547E+00,  .2217E-01,  .7018E+00,  .1989E+00,
     +   .4593E+01,
     +   .2850E+00,  .1568E+00,  .2255E-01,  .7165E+00,  .2080E+00,
     +   .4710E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=17,24)/
     +   .2892E+00,  .1586E+00,  .2289E-01,  .7297E+00,  .2162E+00,
     +   .4807E+01,
     +   .2932E+00,  .1604E+00,  .2320E-01,  .7423E+00,  .2242E+00,
     +   .4893E+01,
     +   .2969E+00,  .1619E+00,  .2349E-01,  .7538E+00,  .2314E+00,
     +   .4964E+01,
     +   .3003E+00,  .1634E+00,  .2375E-01,  .7643E+00,  .2381E+00,
     +   .5024E+01,
     +   .3035E+00,  .1647E+00,  .2398E-01,  .7738E+00,  .2441E+00,
     +   .5072E+01,
     +   .3075E+00,  .1664E+00,  .2427E-01,  .7859E+00,  .2520E+00,
     +   .5127E+01,
     +   .3110E+00,  .1678E+00,  .2451E-01,  .7961E+00,  .2587E+00,
     +   .5167E+01,
     +   .3144E+00,  .1692E+00,  .2474E-01,  .8059E+00,  .2651E+00,
     +   .5198E+01 /
        DATA ((PARTON(I,N,39),I=1,6),N=25,27)/
     +   .3176E+00,  .1705E+00,  .2495E-01,  .8148E+00,  .2711E+00,
     +   .5219E+01,
     +   .3204E+00,  .1716E+00,  .2512E-01,  .8224E+00,  .2763E+00,
     +   .5232E+01,
     +   .3232E+00,  .1727E+00,  .2529E-01,  .8296E+00,  .2813E+00,
     +   .5239E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=1,8)/
     +   .2338E+00,  .1371E+00,  .1922E-01,  .4061E+00,  .2953E-01,
     +   .9678E+00,
     +   .2426E+00,  .1413E+00,  .2016E-01,  .4175E+00,  .3775E-01,
     +   .1206E+01,
     +   .2518E+00,  .1455E+00,  .2111E-01,  .4301E+00,  .4672E-01,
     +   .1458E+01,
     +   .2616E+00,  .1501E+00,  .2210E-01,  .4446E+00,  .5694E-01,
     +   .1732E+01,
     +   .2722E+00,  .1549E+00,  .2313E-01,  .4611E+00,  .6851E-01,
     +   .2025E+01,
     +   .2811E+00,  .1589E+00,  .2396E-01,  .4757E+00,  .7871E-01,
     +   .2266E+01,
     +   .2903E+00,  .1631E+00,  .2479E-01,  .4916E+00,  .8977E-01,
     +   .2510E+01,
     +   .2980E+00,  .1664E+00,  .2545E-01,  .5052E+00,  .9925E-01,
     +   .2702E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=9,16)/
     +   .3051E+00,  .1695E+00,  .2604E-01,  .5181E+00,  .1083E+00,
     +   .2873E+01,
     +   .3112E+00,  .1721E+00,  .2653E-01,  .5291E+00,  .1161E+00,
     +   .3009E+01,
     +   .3169E+00,  .1745E+00,  .2696E-01,  .5397E+00,  .1237E+00,
     +   .3130E+01,
     +   .3221E+00,  .1767E+00,  .2735E-01,  .5494E+00,  .1306E+00,
     +   .3233E+01,
     +   .3266E+00,  .1785E+00,  .2766E-01,  .5578E+00,  .1367E+00,
     +   .3315E+01,
     +   .3320E+00,  .1807E+00,  .2803E-01,  .5677E+00,  .1440E+00,
     +   .3405E+01,
     +   .3368E+00,  .1826E+00,  .2833E-01,  .5764E+00,  .1505E+00,
     +   .3475E+01,
     +   .3411E+00,  .1843E+00,  .2858E-01,  .5842E+00,  .1564E+00,
     +   .3531E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=17,24)/
     +   .3449E+00,  .1857E+00,  .2880E-01,  .5909E+00,  .1617E+00,
     +   .3574E+01,
     +   .3486E+00,  .1871E+00,  .2899E-01,  .5973E+00,  .1667E+00,
     +   .3608E+01,
     +   .3518E+00,  .1883E+00,  .2915E-01,  .6028E+00,  .1712E+00,
     +   .3634E+01,
     +   .3548E+00,  .1894E+00,  .2929E-01,  .6077E+00,  .1753E+00,
     +   .3652E+01,
     +   .3575E+00,  .1904E+00,  .2940E-01,  .6120E+00,  .1789E+00,
     +   .3664E+01,
     +   .3609E+00,  .1915E+00,  .2953E-01,  .6173E+00,  .1835E+00,
     +   .3673E+01,
     +   .3638E+00,  .1925E+00,  .2962E-01,  .6214E+00,  .1874E+00,
     +   .3674E+01,
     +   .3665E+00,  .1934E+00,  .2970E-01,  .6252E+00,  .1911E+00,
     +   .3668E+01 /
        DATA ((PARTON(I,N,40),I=1,6),N=25,27)/
     +   .3691E+00,  .1942E+00,  .2976E-01,  .6284E+00,  .1944E+00,
     +   .3658E+01,
     +   .3712E+00,  .1948E+00,  .2980E-01,  .6310E+00,  .1972E+00,
     +   .3645E+01,
     +   .3733E+00,  .1954E+00,  .2982E-01,  .6332E+00,  .1999E+00,
     +   .3627E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=1,8)/
     +   .3033E+00,  .1748E+00,  .2990E-01,  .3712E+00,  .2460E-01,
     +   .9154E+00,
     +   .3126E+00,  .1788E+00,  .3066E-01,  .3781E+00,  .3117E-01,
     +   .1109E+01,
     +   .3222E+00,  .1829E+00,  .3139E-01,  .3858E+00,  .3823E-01,
     +   .1306E+01,
     +   .3323E+00,  .1871E+00,  .3211E-01,  .3943E+00,  .4611E-01,
     +   .1513E+01,
     +   .3428E+00,  .1915E+00,  .3280E-01,  .4038E+00,  .5482E-01,
     +   .1724E+01,
     +   .3515E+00,  .1949E+00,  .3332E-01,  .4120E+00,  .6233E-01,
     +   .1890E+01,
     +   .3603E+00,  .1984E+00,  .3378E-01,  .4206E+00,  .7029E-01,
     +   .2050E+01,
     +   .3675E+00,  .2011E+00,  .3411E-01,  .4277E+00,  .7696E-01,
     +   .2171E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=9,16)/
     +   .3740E+00,  .2035E+00,  .3436E-01,  .4341E+00,  .8320E-01,
     +   .2271E+01,
     +   .3793E+00,  .2054E+00,  .3453E-01,  .4394E+00,  .8848E-01,
     +   .2348E+01,
     +   .3843E+00,  .2071E+00,  .3466E-01,  .4443E+00,  .9348E-01,
     +   .2411E+01,
     +   .3887E+00,  .2086E+00,  .3474E-01,  .4486E+00,  .9799E-01,
     +   .2461E+01,
     +   .3924E+00,  .2098E+00,  .3479E-01,  .4521E+00,  .1019E+00,
     +   .2498E+01,
     +   .3967E+00,  .2111E+00,  .3481E-01,  .4560E+00,  .1064E+00,
     +   .2534E+01,
     +   .4004E+00,  .2122E+00,  .3479E-01,  .4591E+00,  .1104E+00,
     +   .2557E+01,
     +   .4036E+00,  .2131E+00,  .3475E-01,  .4617E+00,  .1139E+00,
     +   .2572E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=17,24)/
     +   .4064E+00,  .2138E+00,  .3468E-01,  .4638E+00,  .1169E+00,
     +   .2579E+01,
     +   .4089E+00,  .2144E+00,  .3459E-01,  .4654E+00,  .1198E+00,
     +   .2580E+01,
     +   .4111E+00,  .2148E+00,  .3449E-01,  .4667E+00,  .1223E+00,
     +   .2577E+01,
     +   .4130E+00,  .2152E+00,  .3437E-01,  .4676E+00,  .1245E+00,
     +   .2569E+01,
     +   .4147E+00,  .2155E+00,  .3425E-01,  .4683E+00,  .1264E+00,
     +   .2559E+01,
     +   .4167E+00,  .2157E+00,  .3407E-01,  .4688E+00,  .1288E+00,
     +   .2540E+01,
     +   .4183E+00,  .2159E+00,  .3390E-01,  .4688E+00,  .1307E+00,
     +   .2520E+01,
     +   .4197E+00,  .2159E+00,  .3370E-01,  .4686E+00,  .1325E+00,
     +   .2496E+01 /
        DATA ((PARTON(I,N,41),I=1,6),N=25,27)/
     +   .4209E+00,  .2158E+00,  .3349E-01,  .4680E+00,  .1340E+00,
     +   .2469E+01,
     +   .4218E+00,  .2157E+00,  .3330E-01,  .4673E+00,  .1352E+00,
     +   .2443E+01,
     +   .4226E+00,  .2156E+00,  .3309E-01,  .4662E+00,  .1363E+00,
     +   .2414E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=1,8)/
     +   .3662E+00,  .2076E+00,  .3932E-01,  .3401E+00,  .2145E-01,
     +   .8884E+00,
     +   .3751E+00,  .2110E+00,  .3965E-01,  .3443E+00,  .2696E-01,
     +   .1049E+01,
     +   .3841E+00,  .2144E+00,  .3992E-01,  .3487E+00,  .3279E-01,
     +   .1209E+01,
     +   .3934E+00,  .2178E+00,  .4012E-01,  .3536E+00,  .3919E-01,
     +   .1370E+01,
     +   .4030E+00,  .2211E+00,  .4023E-01,  .3588E+00,  .4611E-01,
     +   .1528E+01,
     +   .4106E+00,  .2236E+00,  .4024E-01,  .3630E+00,  .5196E-01,
     +   .1647E+01,
     +   .4181E+00,  .2259E+00,  .4015E-01,  .3672E+00,  .5802E-01,
     +   .1756E+01,
     +   .4240E+00,  .2276E+00,  .4001E-01,  .3705E+00,  .6301E-01,
     +   .1834E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=9,16)/
     +   .4291E+00,  .2290E+00,  .3981E-01,  .3732E+00,  .6758E-01,
     +   .1894E+01,
     +   .4332E+00,  .2300E+00,  .3959E-01,  .3752E+00,  .7138E-01,
     +   .1937E+01,
     +   .4369E+00,  .2308E+00,  .3933E-01,  .3769E+00,  .7490E-01,
     +   .1968E+01,
     +   .4400E+00,  .2314E+00,  .3906E-01,  .3781E+00,  .7802E-01,
     +   .1990E+01,
     +   .4425E+00,  .2318E+00,  .3879E-01,  .3790E+00,  .8065E-01,
     +   .2003E+01,
     +   .4453E+00,  .2321E+00,  .3843E-01,  .3796E+00,  .8369E-01,
     +   .2011E+01,
     +   .4474E+00,  .2322E+00,  .3807E-01,  .3798E+00,  .8626E-01,
     +   .2012E+01,
     +   .4492E+00,  .2322E+00,  .3770E-01,  .3797E+00,  .8849E-01,
     +   .2006E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=17,24)/
     +   .4506E+00,  .2320E+00,  .3735E-01,  .3793E+00,  .9038E-01,
     +   .1997E+01,
     +   .4518E+00,  .2317E+00,  .3698E-01,  .3787E+00,  .9209E-01,
     +   .1983E+01,
     +   .4526E+00,  .2314E+00,  .3662E-01,  .3778E+00,  .9354E-01,
     +   .1967E+01,
     +   .4533E+00,  .2310E+00,  .3626E-01,  .3768E+00,  .9480E-01,
     +   .1949E+01,
     +   .4537E+00,  .2305E+00,  .3592E-01,  .3757E+00,  .9587E-01,
     +   .1930E+01,
     +   .4541E+00,  .2298E+00,  .3546E-01,  .3739E+00,  .9713E-01,
     +   .1901E+01,
     +   .4542E+00,  .2291E+00,  .3503E-01,  .3720E+00,  .9808E-01,
     +   .1873E+01,
     +   .4541E+00,  .2283E+00,  .3459E-01,  .3699E+00,  .9891E-01,
     +   .1843E+01 /
        DATA ((PARTON(I,N,42),I=1,6),N=25,27)/
     +   .4538E+00,  .2274E+00,  .3416E-01,  .3677E+00,  .9957E-01,
     +   .1811E+01,
     +   .4534E+00,  .2266E+00,  .3376E-01,  .3655E+00,  .1001E+00,
     +   .1782E+01,
     +   .4529E+00,  .2256E+00,  .3335E-01,  .3631E+00,  .1004E+00,
     +   .1751E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=1,8)/
     +   .4412E+00,  .2446E+00,  .4818E-01,  .3031E+00,  .1849E-01,
     +   .8700E+00,
     +   .4487E+00,  .2468E+00,  .4781E-01,  .3047E+00,  .2302E-01,
     +   .9972E+00,
     +   .4560E+00,  .2488E+00,  .4734E-01,  .3063E+00,  .2770E-01,
     +   .1118E+01,
     +   .4633E+00,  .2506E+00,  .4675E-01,  .3079E+00,  .3274E-01,
     +   .1236E+01,
     +   .4703E+00,  .2521E+00,  .4600E-01,  .3094E+00,  .3804E-01,
     +   .1345E+01,
     +   .4756E+00,  .2529E+00,  .4529E-01,  .3103E+00,  .4241E-01,
     +   .1421E+01,
     +   .4805E+00,  .2535E+00,  .4445E-01,  .3109E+00,  .4682E-01,
     +   .1485E+01,
     +   .4840E+00,  .2536E+00,  .4368E-01,  .3109E+00,  .5035E-01,
     +   .1526E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=9,16)/
     +   .4867E+00,  .2534E+00,  .4290E-01,  .3107E+00,  .5351E-01,
     +   .1553E+01,
     +   .4887E+00,  .2530E+00,  .4219E-01,  .3101E+00,  .5607E-01,
     +   .1568E+01,
     +   .4901E+00,  .2524E+00,  .4147E-01,  .3093E+00,  .5838E-01,
     +   .1575E+01,
     +   .4911E+00,  .2517E+00,  .4078E-01,  .3082E+00,  .6037E-01,
     +   .1575E+01,
     +   .4917E+00,  .2509E+00,  .4015E-01,  .3070E+00,  .6201E-01,
     +   .1570E+01,
     +   .4920E+00,  .2498E+00,  .3935E-01,  .3052E+00,  .6384E-01,
     +   .1558E+01,
     +   .4920E+00,  .2486E+00,  .3861E-01,  .3034E+00,  .6533E-01,
     +   .1543E+01,
     +   .4916E+00,  .2473E+00,  .3789E-01,  .3013E+00,  .6657E-01,
     +   .1524E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=17,24)/
     +   .4910E+00,  .2460E+00,  .3723E-01,  .2992E+00,  .6758E-01,
     +   .1504E+01,
     +   .4901E+00,  .2446E+00,  .3657E-01,  .2970E+00,  .6845E-01,
     +   .1481E+01,
     +   .4891E+00,  .2432E+00,  .3595E-01,  .2947E+00,  .6915E-01,
     +   .1458E+01,
     +   .4879E+00,  .2418E+00,  .3536E-01,  .2924E+00,  .6971E-01,
     +   .1434E+01,
     +   .4867E+00,  .2404E+00,  .3480E-01,  .2902E+00,  .7016E-01,
     +   .1410E+01,
     +   .4848E+00,  .2385E+00,  .3406E-01,  .2870E+00,  .7063E-01,
     +   .1377E+01,
     +   .4829E+00,  .2367E+00,  .3340E-01,  .2840E+00,  .7093E-01,
     +   .1347E+01,
     +   .4808E+00,  .2348E+00,  .3274E-01,  .2808E+00,  .7112E-01,
     +   .1315E+01 /
        DATA ((PARTON(I,N,43),I=1,6),N=25,27)/
     +   .4786E+00,  .2330E+00,  .3210E-01,  .2776E+00,  .7122E-01,
     +   .1283E+01,
     +   .4765E+00,  .2312E+00,  .3153E-01,  .2747E+00,  .7123E-01,
     +   .1255E+01,
     +   .4742E+00,  .2294E+00,  .3096E-01,  .2716E+00,  .7116E-01,
     +   .1225E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=1,8)/
     +   .5067E+00,  .2748E+00,  .5254E-01,  .2696E+00,  .1624E-01,
     +   .8597E+00,
     +   .5120E+00,  .2754E+00,  .5151E-01,  .2695E+00,  .2003E-01,
     +   .9596E+00,
     +   .5169E+00,  .2757E+00,  .5037E-01,  .2693E+00,  .2388E-01,
     +   .1051E+01,
     +   .5213E+00,  .2756E+00,  .4906E-01,  .2687E+00,  .2794E-01,
     +   .1135E+01,
     +   .5252E+00,  .2750E+00,  .4758E-01,  .2678E+00,  .3210E-01,
     +   .1208E+01,
     +   .5275E+00,  .2740E+00,  .4626E-01,  .2666E+00,  .3544E-01,
     +   .1254E+01,
     +   .5292E+00,  .2725E+00,  .4482E-01,  .2649E+00,  .3873E-01,
     +   .1288E+01,
     +   .5298E+00,  .2709E+00,  .4356E-01,  .2631E+00,  .4129E-01,
     +   .1304E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=9,16)/
     +   .5297E+00,  .2691E+00,  .4234E-01,  .2610E+00,  .4352E-01,
     +   .1310E+01,
     +   .5292E+00,  .2673E+00,  .4126E-01,  .2590E+00,  .4528E-01,
     +   .1308E+01,
     +   .5282E+00,  .2653E+00,  .4021E-01,  .2567E+00,  .4683E-01,
     +   .1300E+01,
     +   .5269E+00,  .2633E+00,  .3922E-01,  .2544E+00,  .4811E-01,
     +   .1287E+01,
     +   .5254E+00,  .2614E+00,  .3834E-01,  .2521E+00,  .4914E-01,
     +   .1272E+01,
     +   .5232E+00,  .2588E+00,  .3725E-01,  .2491E+00,  .5024E-01,
     +   .1250E+01,
     +   .5207E+00,  .2563E+00,  .3626E-01,  .2461E+00,  .5109E-01,
     +   .1226E+01,
     +   .5181E+00,  .2539E+00,  .3533E-01,  .2431E+00,  .5176E-01,
     +   .1201E+01 /
        DATA ((PARTON(I,N,44),I=1,6),N=17,24)/
     +   .5155E+00,  .2515E+00,  .3448E-01,  .2403E+00,  .5226E-01,
     +   .1176E+01,
     +   .5126E+00,  .2491E+00,  .3365E-01,  .2373E+00,  .5266E-01,
     +   .1150E+01,
     +   .5097E+00,  .2467E+00,  .3288E-01,  .2344E+00,  .5294E-01,
     +   .1124E+01,
     +   .5068E+00,  .2444E+00,  .3215E-01,  .2316E+00,  .5313E-01,
     +   .1099E+01,
     +   .5040E+00,  .2423E+00,  .3148E-01,  .2289E+00,  .5324E-01,
     +   .1074E+01,
     +   .4999E+00,  .2393E+00,  .3059E-01,  .2251E+00,  .5330E-01,
     +   .1041E+01,
     +   .4962E+00,  .2366E+00,  .2982E-01,  .2217E+00,  .5327E-01,
     +   .1012E+01,
     +   .4922E+00,  .2338E+00,  .2905E-01,  .2183E+00,  .5316E-01,
     +   .9812E+00 /
        DATA ((PARTON(I,N,44),I=1,6),N=25,27)/
     +   .4882E+00,  .2310E+00,  .2832E-01,  .2148E+00,  .5298E-01,
     +   .9516E+00,
     +   .4845E+00,  .2285E+00,  .2767E-01,  .2117E+00,  .5277E-01,
     +   .9251E+00,
     +   .4806E+00,  .2259E+00,  .2702E-01,  .2084E+00,  .5250E-01,
     +   .8983E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=1,8)/
     +   .5758E+00,  .3035E+00,  .5271E-01,  .2317E+00,  .1394E-01,
     +   .8489E+00,
     +   .5777E+00,  .3019E+00,  .5105E-01,  .2302E+00,  .1702E-01,
     +   .9202E+00,
     +   .5788E+00,  .2999E+00,  .4930E-01,  .2284E+00,  .2008E-01,
     +   .9817E+00,
     +   .5790E+00,  .2973E+00,  .4738E-01,  .2262E+00,  .2321E-01,
     +   .1033E+01,
     +   .5782E+00,  .2939E+00,  .4527E-01,  .2233E+00,  .2633E-01,
     +   .1072E+01,
     +   .5764E+00,  .2906E+00,  .4346E-01,  .2205E+00,  .2876E-01,
     +   .1091E+01,
     +   .5736E+00,  .2866E+00,  .4154E-01,  .2172E+00,  .3107E-01,
     +   .1098E+01,
     +   .5704E+00,  .2829E+00,  .3992E-01,  .2140E+00,  .3281E-01,
     +   .1094E+01 /
        DATA ((PARTON(I,N,45),I=1,6),N=9,16)/
     +   .5666E+00,  .2791E+00,  .3839E-01,  .2107E+00,  .3426E-01,
     +   .1082E+01,
     +   .5629E+00,  .2756E+00,  .3707E-01,  .2077E+00,  .3537E-01,
     +   .1067E+01,
     +   .5588E+00,  .2720E+00,  .3580E-01,  .2045E+00,  .3629E-01,
     +   .1048E+01,
     +   .5545E+00,  .2685E+00,  .3462E-01,  .2014E+00,  .3703E-01,
     +   .1026E+01,
     +   .5505E+00,  .2652E+00,  .3359E-01,  .1985E+00,  .3758E-01,
     +   .1005E+01,
     +   .5451E+00,  .2611E+00,  .3235E-01,  .1948E+00,  .3812E-01,
     +   .9761E+00,
     +   .5398E+00,  .2572E+00,  .3123E-01,  .1913E+00,  .3850E-01,
     +   .9476E+00,
     +   .5345E+00,  .2535E+00,  .3019E-01,  .1879E+00,  .3875E-01,
     +   .9194E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=17,24)/
     +   .5295E+00,  .2500E+00,  .2926E-01,  .1846E+00,  .3889E-01,
     +   .8925E+00,
     +   .5243E+00,  .2464E+00,  .2835E-01,  .1814E+00,  .3896E-01,
     +   .8653E+00,
     +   .5192E+00,  .2431E+00,  .2753E-01,  .1783E+00,  .3896E-01,
     +   .8395E+00,
     +   .5143E+00,  .2399E+00,  .2676E-01,  .1753E+00,  .3890E-01,
     +   .8147E+00,
     +   .5096E+00,  .2368E+00,  .2605E-01,  .1725E+00,  .3880E-01,
     +   .7915E+00,
     +   .5032E+00,  .2328E+00,  .2513E-01,  .1687E+00,  .3860E-01,
     +   .7605E+00,
     +   .4973E+00,  .2291E+00,  .2434E-01,  .1653E+00,  .3837E-01,
     +   .7332E+00,
     +   .4913E+00,  .2254E+00,  .2355E-01,  .1619E+00,  .3808E-01,
     +   .7060E+00 /
        DATA ((PARTON(I,N,45),I=1,6),N=25,27)/
     +   .4854E+00,  .2218E+00,  .2282E-01,  .1585E+00,  .3776E-01,
     +   .6800E+00,
     +   .4799E+00,  .2186E+00,  .2217E-01,  .1555E+00,  .3743E-01,
     +   .6569E+00,
     +   .4744E+00,  .2153E+00,  .2153E-01,  .1524E+00,  .3707E-01,
     +   .6340E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=1,8)/
     +   .6311E+00,  .3230E+00,  .4880E-01,  .1975E+00,  .1198E-01,
     +   .8349E+00,
     +   .6291E+00,  .3193E+00,  .4680E-01,  .1951E+00,  .1449E-01,
     +   .8824E+00,
     +   .6261E+00,  .3150E+00,  .4473E-01,  .1924E+00,  .1693E-01,
     +   .9195E+00,
     +   .6217E+00,  .3098E+00,  .4250E-01,  .1891E+00,  .1937E-01,
     +   .9460E+00,
     +   .6158E+00,  .3038E+00,  .4011E-01,  .1852E+00,  .2172E-01,
     +   .9590E+00,
     +   .6098E+00,  .2982E+00,  .3810E-01,  .1816E+00,  .2350E-01,
     +   .9582E+00,
     +   .6024E+00,  .2919E+00,  .3601E-01,  .1774E+00,  .2512E-01,
     +   .9466E+00,
     +   .5953E+00,  .2863E+00,  .3428E-01,  .1737E+00,  .2630E-01,
     +   .9292E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=9,16)/
     +   .5879E+00,  .2807E+00,  .3266E-01,  .1699E+00,  .2724E-01,
     +   .9069E+00,
     +   .5811E+00,  .2756E+00,  .3129E-01,  .1664E+00,  .2791E-01,
     +   .8836E+00,
     +   .5739E+00,  .2706E+00,  .2998E-01,  .1629E+00,  .2845E-01,
     +   .8580E+00,
     +   .5669E+00,  .2658E+00,  .2879E-01,  .1596E+00,  .2884E-01,
     +   .8321E+00,
     +   .5604E+00,  .2615E+00,  .2776E-01,  .1565E+00,  .2910E-01,
     +   .8076E+00,
     +   .5521E+00,  .2560E+00,  .2652E-01,  .1527E+00,  .2932E-01,
     +   .7761E+00,
     +   .5442E+00,  .2510E+00,  .2542E-01,  .1491E+00,  .2942E-01,
     +   .7463E+00,
     +   .5366E+00,  .2462E+00,  .2442E-01,  .1456E+00,  .2943E-01,
     +   .7178E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=17,24)/
     +   .5294E+00,  .2418E+00,  .2352E-01,  .1424E+00,  .2939E-01,
     +   .6913E+00,
     +   .5221E+00,  .2374E+00,  .2266E-01,  .1392E+00,  .2928E-01,
     +   .6651E+00,
     +   .5152E+00,  .2333E+00,  .2188E-01,  .1363E+00,  .2914E-01,
     +   .6408E+00,
     +   .5086E+00,  .2293E+00,  .2115E-01,  .1334E+00,  .2896E-01,
     +   .6178E+00,
     +   .5023E+00,  .2257E+00,  .2049E-01,  .1308E+00,  .2876E-01,
     +   .5966E+00,
     +   .4938E+00,  .2208E+00,  .1964E-01,  .1272E+00,  .2846E-01,
     +   .5688E+00,
     +   .4863E+00,  .2165E+00,  .1892E-01,  .1241E+00,  .2814E-01,
     +   .5447E+00,
     +   .4786E+00,  .2122E+00,  .1821E-01,  .1210E+00,  .2780E-01,
     +   .5209E+00 /
        DATA ((PARTON(I,N,46),I=1,6),N=25,27)/
     +   .4711E+00,  .2080E+00,  .1754E-01,  .1179E+00,  .2743E-01,
     +   .4985E+00,
     +   .4643E+00,  .2043E+00,  .1696E-01,  .1152E+00,  .2709E-01,
     +   .4789E+00,
     +   .4574E+00,  .2005E+00,  .1639E-01,  .1125E+00,  .2671E-01,
     +   .4596E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=1,8)/
     +   .6732E+00,  .3343E+00,  .4259E-01,  .1667E+00,  .1025E-01,
     +   .8153E+00,
     +   .6670E+00,  .3284E+00,  .4050E-01,  .1638E+00,  .1229E-01,
     +   .8425E+00,
     +   .6597E+00,  .3219E+00,  .3837E-01,  .1606E+00,  .1424E-01,
     +   .8597E+00,
     +   .6507E+00,  .3145E+00,  .3610E-01,  .1568E+00,  .1613E-01,
     +   .8661E+00,
     +   .6399E+00,  .3060E+00,  .3371E-01,  .1525E+00,  .1791E-01,
     +   .8597E+00,
     +   .6296E+00,  .2984E+00,  .3173E-01,  .1485E+00,  .1920E-01,
     +   .8446E+00,
     +   .6178E+00,  .2901E+00,  .2969E-01,  .1441E+00,  .2034E-01,
     +   .8203E+00,
     +   .6070E+00,  .2828E+00,  .2803E-01,  .1401E+00,  .2112E-01,
     +   .7940E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=9,16)/
     +   .5962E+00,  .2757E+00,  .2649E-01,  .1362E+00,  .2171E-01,
     +   .7650E+00,
     +   .5865E+00,  .2694E+00,  .2520E-01,  .1327E+00,  .2211E-01,
     +   .7373E+00,
     +   .5766E+00,  .2632E+00,  .2399E-01,  .1292E+00,  .2239E-01,
     +   .7086E+00,
     +   .5671E+00,  .2574E+00,  .2289E-01,  .1260E+00,  .2256E-01,
     +   .6807E+00,
     +   .5585E+00,  .2522E+00,  .2195E-01,  .1230E+00,  .2265E-01,
     +   .6552E+00,
     +   .5476E+00,  .2457E+00,  .2082E-01,  .1193E+00,  .2267E-01,
     +   .6234E+00,
     +   .5374E+00,  .2398E+00,  .1984E-01,  .1159E+00,  .2262E-01,
     +   .5942E+00,
     +   .5277E+00,  .2342E+00,  .1894E-01,  .1127E+00,  .2251E-01,
     +   .5669E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=17,24)/
     +   .5187E+00,  .2291E+00,  .1815E-01,  .1097E+00,  .2236E-01,
     +   .5419E+00,
     +   .5097E+00,  .2241E+00,  .1739E-01,  .1068E+00,  .2217E-01,
     +   .5177E+00,
     +   .5013E+00,  .2194E+00,  .1671E-01,  .1041E+00,  .2196E-01,
     +   .4955E+00,
     +   .4932E+00,  .2150E+00,  .1608E-01,  .1015E+00,  .2174E-01,
     +   .4748E+00,
     +   .4857E+00,  .2109E+00,  .1551E-01,  .9915E-01,  .2151E-01,
     +   .4559E+00,
     +   .4756E+00,  .2055E+00,  .1478E-01,  .9600E-01,  .2117E-01,
     +   .4315E+00,
     +   .4666E+00,  .2007E+00,  .1416E-01,  .9325E-01,  .2084E-01,
     +   .4106E+00,
     +   .4577E+00,  .1960E+00,  .1356E-01,  .9052E-01,  .2049E-01,
     +   .3902E+00 /
        DATA ((PARTON(I,N,47),I=1,6),N=25,27)/
     +   .4490E+00,  .1914E+00,  .1300E-01,  .8790E-01,  .2014E-01,
     +   .3712E+00,
     +   .4412E+00,  .1874E+00,  .1252E-01,  .8558E-01,  .1981E-01,
     +   .3548E+00,
     +   .4333E+00,  .1834E+00,  .1204E-01,  .8327E-01,  .1946E-01,
     +   .3387E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=1,8)/
     +   .7027E+00,  .3383E+00,  .3550E-01,  .1391E+00,  .8702E-02,
     +   .7890E+00,
     +   .6924E+00,  .3305E+00,  .3350E-01,  .1360E+00,  .1036E-01,
     +   .7993E+00,
     +   .6809E+00,  .3220E+00,  .3149E-01,  .1327E+00,  .1190E-01,
     +   .8003E+00,
     +   .6674E+00,  .3126E+00,  .2937E-01,  .1288E+00,  .1337E-01,
     +   .7909E+00,
     +   .6518E+00,  .3020E+00,  .2716E-01,  .1244E+00,  .1471E-01,
     +   .7699E+00,
     +   .6376E+00,  .2927E+00,  .2536E-01,  .1204E+00,  .1564E-01,
     +   .7445E+00,
     +   .6217E+00,  .2827E+00,  .2352E-01,  .1160E+00,  .1642E-01,
     +   .7115E+00,
     +   .6076E+00,  .2740E+00,  .2204E-01,  .1122E+00,  .1693E-01,
     +   .6798E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=9,16)/
     +   .5937E+00,  .2657E+00,  .2068E-01,  .1084E+00,  .1728E-01,
     +   .6471E+00,
     +   .5814E+00,  .2584E+00,  .1955E-01,  .1051E+00,  .1749E-01,
     +   .6173E+00,
     +   .5691E+00,  .2513E+00,  .1850E-01,  .1019E+00,  .1761E-01,
     +   .5874E+00,
     +   .5574E+00,  .2447E+00,  .1755E-01,  .9881E-01,  .1765E-01,
     +   .5593E+00,
     +   .5470E+00,  .2389E+00,  .1674E-01,  .9608E-01,  .1763E-01,
     +   .5342E+00,
     +   .5339E+00,  .2317E+00,  .1578E-01,  .9272E-01,  .1754E-01,
     +   .5035E+00,
     +   .5219E+00,  .2251E+00,  .1495E-01,  .8965E-01,  .1741E-01,
     +   .4759E+00,
     +   .5105E+00,  .2190E+00,  .1420E-01,  .8678E-01,  .1724E-01,
     +   .4504E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=17,24)/
     +   .5001E+00,  .2135E+00,  .1354E-01,  .8416E-01,  .1705E-01,
     +   .4277E+00,
     +   .4897E+00,  .2080E+00,  .1291E-01,  .8158E-01,  .1683E-01,
     +   .4057E+00,
     +   .4801E+00,  .2030E+00,  .1235E-01,  .7922E-01,  .1660E-01,
     +   .3860E+00,
     +   .4709E+00,  .1983E+00,  .1183E-01,  .7699E-01,  .1636E-01,
     +   .3677E+00,
     +   .4624E+00,  .1939E+00,  .1137E-01,  .7494E-01,  .1613E-01,
     +   .3513E+00,
     +   .4511E+00,  .1882E+00,  .1078E-01,  .7224E-01,  .1580E-01,
     +   .3302E+00,
     +   .4411E+00,  .1832E+00,  .1028E-01,  .6990E-01,  .1549E-01,
     +   .3123E+00,
     +   .4312E+00,  .1783E+00,  .9801E-02,  .6759E-01,  .1517E-01,
     +   .2951E+00 /
        DATA ((PARTON(I,N,48),I=1,6),N=25,27)/
     +   .4216E+00,  .1736E+00,  .9354E-02,  .6539E-01,  .1485E-01,
     +   .2791E+00,
     +   .4131E+00,  .1694E+00,  .8970E-02,  .6345E-01,  .1455E-01,
     +   .2654E+00,
     +   .4046E+00,  .1652E+00,  .8596E-02,  .6152E-01,  .1424E-01,
     +   .2522E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=1,8)/
     +   .7204E+00,  .3359E+00,  .2847E-01,  .1147E+00,  .7318E-02,
     +   .7563E+00,
     +   .7063E+00,  .3264E+00,  .2669E-01,  .1117E+00,  .8651E-02,
     +   .7526E+00,
     +   .6908E+00,  .3163E+00,  .2491E-01,  .1084E+00,  .9868E-02,
     +   .7405E+00,
     +   .6731E+00,  .3051E+00,  .2305E-01,  .1046E+00,  .1100E-01,
     +   .7190E+00,
     +   .6531E+00,  .2928E+00,  .2113E-01,  .1004E+00,  .1199E-01,
     +   .6873E+00,
     +   .6353E+00,  .2822E+00,  .1958E-01,  .9660E-01,  .1266E-01,
     +   .6548E+00,
     +   .6157E+00,  .2708E+00,  .1801E-01,  .9250E-01,  .1319E-01,
     +   .6164E+00,
     +   .5987E+00,  .2612E+00,  .1676E-01,  .8895E-01,  .1351E-01,
     +   .5816E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=9,16)/
     +   .5822E+00,  .2520E+00,  .1562E-01,  .8553E-01,  .1370E-01,
     +   .5472E+00,
     +   .5677E+00,  .2440E+00,  .1469E-01,  .8255E-01,  .1378E-01,
     +   .5170E+00,
     +   .5534E+00,  .2363E+00,  .1382E-01,  .7963E-01,  .1380E-01,
     +   .4874E+00,
     +   .5400E+00,  .2291E+00,  .1304E-01,  .7691E-01,  .1376E-01,
     +   .4601E+00,
     +   .5280E+00,  .2228E+00,  .1238E-01,  .7449E-01,  .1369E-01,
     +   .4362E+00,
     +   .5132E+00,  .2152E+00,  .1161E-01,  .7154E-01,  .1354E-01,
     +   .4074E+00,
     +   .4997E+00,  .2082E+00,  .1094E-01,  .6887E-01,  .1337E-01,
     +   .3820E+00,
     +   .4871E+00,  .2018E+00,  .1033E-01,  .6638E-01,  .1318E-01,
     +   .3589E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=17,24)/
     +   .4755E+00,  .1960E+00,  .9809E-02,  .6413E-01,  .1297E-01,
     +   .3385E+00,
     +   .4641E+00,  .1904E+00,  .9312E-02,  .6194E-01,  .1275E-01,
     +   .3191E+00,
     +   .4536E+00,  .1852E+00,  .8871E-02,  .5993E-01,  .1253E-01,
     +   .3018E+00,
     +   .4436E+00,  .1803E+00,  .8467E-02,  .5805E-01,  .1231E-01,
     +   .2859E+00,
     +   .4344E+00,  .1759E+00,  .8107E-02,  .5632E-01,  .1209E-01,
     +   .2717E+00,
     +   .4223E+00,  .1700E+00,  .7649E-02,  .5407E-01,  .1179E-01,
     +   .2537E+00,
     +   .4117E+00,  .1650E+00,  .7264E-02,  .5213E-01,  .1151E-01,
     +   .2387E+00,
     +   .4012E+00,  .1600E+00,  .6895E-02,  .5022E-01,  .1123E-01,
     +   .2242E+00 /
        DATA ((PARTON(I,N,49),I=1,6),N=25,27)/
     +   .3911E+00,  .1553E+00,  .6554E-02,  .4841E-01,  .1095E-01,
     +   .2110E+00,
     +   .3821E+00,  .1511E+00,  .6262E-02,  .4683E-01,  .1069E-01,
     +   .1997E+00,
     +   .3732E+00,  .1470E+00,  .5978E-02,  .4527E-01,  .1043E-01,
     +   .1889E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=1,8)/
     +   .7274E+00,  .3281E+00,  .2208E-01,  .9339E-01,  .6087E-02,
     +   .7178E+00,
     +   .7096E+00,  .3172E+00,  .2057E-01,  .9054E-01,  .7150E-02,
     +   .7027E+00,
     +   .6905E+00,  .3058E+00,  .1907E-01,  .8746E-01,  .8103E-02,
     +   .6804E+00,
     +   .6691E+00,  .2933E+00,  .1752E-01,  .8399E-01,  .8966E-02,
     +   .6498E+00,
     +   .6451E+00,  .2797E+00,  .1593E-01,  .8009E-01,  .9701E-02,
     +   .6106E+00,
     +   .6242E+00,  .2680E+00,  .1466E-01,  .7668E-01,  .1017E-01,
     +   .5736E+00,
     +   .6016E+00,  .2557E+00,  .1339E-01,  .7299E-01,  .1052E-01,
     +   .5323E+00,
     +   .5821E+00,  .2453E+00,  .1237E-01,  .6983E-01,  .1070E-01,
     +   .4963E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=9,16)/
     +   .5634E+00,  .2355E+00,  .1146E-01,  .6682E-01,  .1079E-01,
     +   .4619E+00,
     +   .5471E+00,  .2271E+00,  .1072E-01,  .6420E-01,  .1080E-01,
     +   .4322E+00,
     +   .5312E+00,  .2191E+00,  .1003E-01,  .6166E-01,  .1076E-01,
     +   .4038E+00,
     +   .5164E+00,  .2116E+00,  .9421E-02,  .5931E-01,  .1067E-01,
     +   .3781E+00,
     +   .5033E+00,  .2051E+00,  .8906E-02,  .5724E-01,  .1057E-01,
     +   .3559E+00,
     +   .4872E+00,  .1972E+00,  .8304E-02,  .5472E-01,  .1041E-01,
     +   .3296E+00,
     +   .4727E+00,  .1901E+00,  .7785E-02,  .5246E-01,  .1022E-01,
     +   .3067E+00,
     +   .4591E+00,  .1836E+00,  .7324E-02,  .5036E-01,  .1003E-01,
     +   .2861E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=17,24)/
     +   .4467E+00,  .1777E+00,  .6922E-02,  .4848E-01,  .9835E-02,
     +   .2681E+00,
     +   .4346E+00,  .1720E+00,  .6544E-02,  .4665E-01,  .9629E-02,
     +   .2512E+00,
     +   .4236E+00,  .1668E+00,  .6210E-02,  .4499E-01,  .9427E-02,
     +   .2362E+00,
     +   .4131E+00,  .1620E+00,  .5905E-02,  .4344E-01,  .9226E-02,
     +   .2226E+00,
     +   .4035E+00,  .1575E+00,  .5635E-02,  .4202E-01,  .9033E-02,
     +   .2105E+00,
     +   .3909E+00,  .1518E+00,  .5292E-02,  .4019E-01,  .8770E-02,
     +   .1954E+00,
     +   .3799E+00,  .1468E+00,  .5006E-02,  .3861E-01,  .8533E-02,
     +   .1827E+00,
     +   .3691E+00,  .1419E+00,  .4733E-02,  .3707E-01,  .8291E-02,
     +   .1708E+00 /
        DATA ((PARTON(I,N,50),I=1,6),N=25,27)/
     +   .3587E+00,  .1373E+00,  .4481E-02,  .3561E-01,  .8054E-02,
     +   .1599E+00,
     +   .3496E+00,  .1333E+00,  .4267E-02,  .3434E-01,  .7841E-02,
     +   .1507E+00,
     +   .3405E+00,  .1293E+00,  .4060E-02,  .3309E-01,  .7625E-02,
     +   .1419E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=1,8)/
     +   .7245E+00,  .3158E+00,  .1661E-01,  .7507E-01,  .5001E-02,
     +   .6744E+00,
     +   .7036E+00,  .3039E+00,  .1539E-01,  .7248E-01,  .5841E-02,
     +   .6503E+00,
     +   .6813E+00,  .2915E+00,  .1417E-01,  .6971E-01,  .6580E-02,
     +   .6204E+00,
     +   .6565E+00,  .2780E+00,  .1293E-01,  .6660E-01,  .7233E-02,
     +   .5834E+00,
     +   .6293E+00,  .2635E+00,  .1167E-01,  .6315E-01,  .7769E-02,
     +   .5394E+00,
     +   .6057E+00,  .2512E+00,  .1067E-01,  .6015E-01,  .8092E-02,
     +   .5000E+00,
     +   .5806E+00,  .2383E+00,  .9674E-02,  .5694E-01,  .8311E-02,
     +   .4576E+00,
     +   .5591E+00,  .2275E+00,  .8888E-02,  .5422E-01,  .8406E-02,
     +   .4218E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=9,16)/
     +   .5387E+00,  .2174E+00,  .8188E-02,  .5163E-01,  .8425E-02,
     +   .3884E+00,
     +   .5211E+00,  .2088E+00,  .7616E-02,  .4940E-01,  .8392E-02,
     +   .3602E+00,
     +   .5040E+00,  .2005E+00,  .7092E-02,  .4725E-01,  .8319E-02,
     +   .3337E+00,
     +   .4882E+00,  .1930E+00,  .6631E-02,  .4527E-01,  .8219E-02,
     +   .3100E+00,
     +   .4743E+00,  .1864E+00,  .6242E-02,  .4354E-01,  .8105E-02,
     +   .2897E+00,
     +   .4574E+00,  .1785E+00,  .5791E-02,  .4144E-01,  .7939E-02,
     +   .2661E+00,
     +   .4421E+00,  .1715E+00,  .5404E-02,  .3957E-01,  .7765E-02,
     +   .2457E+00,
     +   .4279E+00,  .1650E+00,  .5061E-02,  .3785E-01,  .7586E-02,
     +   .2277E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=17,24)/
     +   .4151E+00,  .1592E+00,  .4764E-02,  .3631E-01,  .7409E-02,
     +   .2120E+00,
     +   .4027E+00,  .1536E+00,  .4486E-02,  .3482E-01,  .7226E-02,
     +   .1975E+00,
     +   .3913E+00,  .1485E+00,  .4242E-02,  .3347E-01,  .7049E-02,
     +   .1847E+00,
     +   .3806E+00,  .1438E+00,  .4020E-02,  .3222E-01,  .6875E-02,
     +   .1732E+00,
     +   .3708E+00,  .1395E+00,  .3823E-02,  .3108E-01,  .6711E-02,
     +   .1630E+00,
     +   .3580E+00,  .1339E+00,  .3576E-02,  .2961E-01,  .6488E-02,
     +   .1504E+00,
     +   .3470E+00,  .1292E+00,  .3369E-02,  .2835E-01,  .6290E-02,
     +   .1399E+00,
     +   .3361E+00,  .1245E+00,  .3173E-02,  .2713E-01,  .6090E-02,
     +   .1301E+00 /
        DATA ((PARTON(I,N,51),I=1,6),N=25,27)/
     +   .3257E+00,  .1201E+00,  .2994E-02,  .2598E-01,  .5895E-02,
     +   .1212E+00,
     +   .3166E+00,  .1162E+00,  .2841E-02,  .2498E-01,  .5721E-02,
     +   .1137E+00,
     +   .3076E+00,  .1125E+00,  .2694E-02,  .2400E-01,  .5546E-02,
     +   .1067E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=1,8)/
     +   .7129E+00,  .2999E+00,  .1215E-01,  .5952E-01,  .4053E-02,
     +   .6272E+00,
     +   .6892E+00,  .2873E+00,  .1119E-01,  .5725E-01,  .4710E-02,
     +   .5964E+00,
     +   .6642E+00,  .2742E+00,  .1025E-01,  .5482E-01,  .5277E-02,
     +   .5611E+00,
     +   .6367E+00,  .2601E+00,  .9289E-02,  .5213E-01,  .5765E-02,
     +   .5199E+00,
     +   .6068E+00,  .2451E+00,  .8323E-02,  .4916E-01,  .6151E-02,
     +   .4733E+00,
     +   .5812E+00,  .2324E+00,  .7560E-02,  .4660E-01,  .6369E-02,
     +   .4332E+00,
     +   .5540E+00,  .2193E+00,  .6810E-02,  .4388E-01,  .6500E-02,
     +   .3912E+00,
     +   .5312E+00,  .2084E+00,  .6221E-02,  .4159E-01,  .6537E-02,
     +   .3567E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=9,16)/
     +   .5095E+00,  .1982E+00,  .5699E-02,  .3942E-01,  .6516E-02,
     +   .3251E+00,
     +   .4910E+00,  .1896E+00,  .5276E-02,  .3757E-01,  .6460E-02,
     +   .2988E+00,
     +   .4731E+00,  .1814E+00,  .4889E-02,  .3579E-01,  .6375E-02,
     +   .2745E+00,
     +   .4567E+00,  .1740E+00,  .4551E-02,  .3417E-01,  .6271E-02,
     +   .2531E+00,
     +   .4423E+00,  .1675E+00,  .4267E-02,  .3275E-01,  .6160E-02,
     +   .2350E+00,
     +   .4249E+00,  .1598E+00,  .3940E-02,  .3104E-01,  .6005E-02,
     +   .2140E+00,
     +   .4092E+00,  .1529E+00,  .3660E-02,  .2953E-01,  .5848E-02,
     +   .1962E+00,
     +   .3948E+00,  .1466E+00,  .3414E-02,  .2814E-01,  .5690E-02,
     +   .1806E+00 /
        DATA ((PARTON(I,N,52),I=1,6),N=17,24)/
     +   .3819E+00,  .1410E+00,  .3201E-02,  .2690E-01,  .5536E-02,
     +   .1672E+00,
     +   .3693E+00,  .1357E+00,  .3003E-02,  .2571E-01,  .5379E-02,
     +   .1548E+00,
     +   .3579E+00,  .1308E+00,  .2830E-02,  .2464E-01,  .5230E-02,
     +   .1440E+00,
     +   .3472E+00,  .1263E+00,  .2673E-02,  .2365E-01,  .5084E-02,
     +   .1344E+00,
     +   .3374E+00,  .1222E+00,  .2534E-02,  .2275E-01,  .4948E-02,
     +   .1259E+00,
     +   .3247E+00,  .1169E+00,  .2360E-02,  .2160E-01,  .4765E-02,
     +   .1155E+00,
     +   .3138E+00,  .1124E+00,  .2216E-02,  .2061E-01,  .4603E-02,
     +   .1069E+00,
     +   .3031E+00,  .1080E+00,  .2079E-02,  .1966E-01,  .4441E-02,
     +   .9892E-01 /
        DATA ((PARTON(I,N,52),I=1,6),N=25,27)/
     +   .2929E+00,  .1039E+00,  .1955E-02,  .1877E-01,  .4284E-02,
     +   .9174E-01,
     +   .2840E+00,  .1003E+00,  .1849E-02,  .1800E-01,  .4145E-02,
     +   .8574E-01,
     +   .2753E+00,  .9681E-01,  .1748E-02,  .1725E-01,  .4007E-02,
     +   .8008E-01 /
        DATA ((PARTON(I,N,53),I=1,6),N=1,8)/
     +   .6936E+00,  .2813E+00,  .8648E-02,  .4652E-01,  .3236E-02,
     +   .5774E+00,
     +   .6676E+00,  .2682E+00,  .7922E-02,  .4458E-01,  .3743E-02,
     +   .5419E+00,
     +   .6404E+00,  .2548E+00,  .7215E-02,  .4252E-01,  .4173E-02,
     +   .5031E+00,
     +   .6108E+00,  .2404E+00,  .6498E-02,  .4024E-01,  .4534E-02,
     +   .4597E+00,
     +   .5788E+00,  .2252E+00,  .5783E-02,  .3776E-01,  .4808E-02,
     +   .4123E+00,
     +   .5517E+00,  .2125E+00,  .5221E-02,  .3562E-01,  .4951E-02,
     +   .3727E+00,
     +   .5232E+00,  .1994E+00,  .4673E-02,  .3337E-01,  .5022E-02,
     +   .3323E+00,
     +   .4994E+00,  .1886E+00,  .4245E-02,  .3149E-01,  .5024E-02,
     +   .2998E+00 /
        DATA ((PARTON(I,N,53),I=1,6),N=9,16)/
     +   .4770E+00,  .1786E+00,  .3868E-02,  .2972E-01,  .4983E-02,
     +   .2705E+00,
     +   .4579E+00,  .1702E+00,  .3564E-02,  .2821E-01,  .4918E-02,
     +   .2466E+00,
     +   .4396E+00,  .1623E+00,  .3288E-02,  .2678E-01,  .4832E-02,
     +   .2246E+00,
     +   .4229E+00,  .1551E+00,  .3048E-02,  .2547E-01,  .4733E-02,
     +   .2055E+00,
     +   .4084E+00,  .1488E+00,  .2847E-02,  .2433E-01,  .4633E-02,
     +   .1896E+00,
     +   .3908E+00,  .1414E+00,  .2616E-02,  .2297E-01,  .4496E-02,
     +   .1714E+00,
     +   .3751E+00,  .1348E+00,  .2420E-02,  .2177E-01,  .4360E-02,
     +   .1560E+00,
     +   .3607E+00,  .1289E+00,  .2248E-02,  .2067E-01,  .4225E-02,
     +   .1426E+00 /
        DATA ((PARTON(I,N,53),I=1,6),N=17,24)/
     +   .3479E+00,  .1236E+00,  .2100E-02,  .1970E-01,  .4096E-02,
     +   .1313E+00,
     +   .3354E+00,  .1185E+00,  .1963E-02,  .1877E-01,  .3966E-02,
     +   .1209E+00,
     +   .3242E+00,  .1139E+00,  .1844E-02,  .1793E-01,  .3843E-02,
     +   .1119E+00,
     +   .3137E+00,  .1097E+00,  .1736E-02,  .1716E-01,  .3724E-02,
     +   .1039E+00,
     +   .3041E+00,  .1059E+00,  .1641E-02,  .1647E-01,  .3613E-02,
     +   .9693E-01,
     +   .2917E+00,  .1010E+00,  .1522E-02,  .1558E-01,  .3466E-02,
     +   .8838E-01,
     +   .2811E+00,  .9683E-01,  .1424E-02,  .1482E-01,  .3337E-02,
     +   .8142E-01,
     +   .2708E+00,  .9278E-01,  .1332E-02,  .1409E-01,  .3209E-02,
     +   .7498E-01 /
        DATA ((PARTON(I,N,53),I=1,6),N=25,27)/
     +   .2610E+00,  .8899E-01,  .1248E-02,  .1341E-01,  .3085E-02,
     +   .6922E-01,
     +   .2524E+00,  .8570E-01,  .1177E-02,  .1283E-01,  .2977E-02,
     +   .6444E-01,
     +   .2440E+00,  .8248E-01,  .1109E-02,  .1226E-01,  .2869E-02,
     +   .5995E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=1,8)/
     +   .6676E+00,  .2606E+00,  .5993E-02,  .3582E-01,  .2540E-02,
     +   .5261E+00,
     +   .6398E+00,  .2474E+00,  .5462E-02,  .3419E-01,  .2926E-02,
     +   .4876E+00,
     +   .6110E+00,  .2340E+00,  .4947E-02,  .3249E-01,  .3249E-02,
     +   .4470E+00,
     +   .5799E+00,  .2197E+00,  .4429E-02,  .3061E-01,  .3513E-02,
     +   .4030E+00,
     +   .5465E+00,  .2046E+00,  .3915E-02,  .2858E-01,  .3704E-02,
     +   .3563E+00,
     +   .5184E+00,  .1921E+00,  .3514E-02,  .2684E-01,  .3795E-02,
     +   .3183E+00,
     +   .4891E+00,  .1793E+00,  .3125E-02,  .2502E-01,  .3828E-02,
     +   .2802E+00,
     +   .4648E+00,  .1688E+00,  .2824E-02,  .2351E-01,  .3810E-02,
     +   .2502E+00 /
        DATA ((PARTON(I,N,54),I=1,6),N=9,16)/
     +   .4421E+00,  .1592E+00,  .2560E-02,  .2209E-01,  .3761E-02,
     +   .2236E+00,
     +   .4229E+00,  .1511E+00,  .2349E-02,  .2090E-01,  .3696E-02,
     +   .2021E+00,
     +   .4045E+00,  .1435E+00,  .2157E-02,  .1976E-01,  .3616E-02,
     +   .1827E+00,
     +   .3879E+00,  .1367E+00,  .1991E-02,  .1873E-01,  .3528E-02,
     +   .1659E+00,
     +   .3734E+00,  .1308E+00,  .1853E-02,  .1784E-01,  .3441E-02,
     +   .1521E+00,
     +   .3560E+00,  .1238E+00,  .1695E-02,  .1677E-01,  .3325E-02,
     +   .1364E+00,
     +   .3406E+00,  .1176E+00,  .1562E-02,  .1584E-01,  .3211E-02,
     +   .1233E+00,
     +   .3265E+00,  .1121E+00,  .1445E-02,  .1499E-01,  .3100E-02,
     +   .1120E+00 /
        DATA ((PARTON(I,N,54),I=1,6),N=17,24)/
     +   .3139E+00,  .1071E+00,  .1345E-02,  .1424E-01,  .2995E-02,
     +   .1025E+00,
     +   .3018E+00,  .1024E+00,  .1253E-02,  .1353E-01,  .2889E-02,
     +   .9385E-01,
     +   .2909E+00,  .9821E-01,  .1173E-02,  .1289E-01,  .2791E-02,
     +   .8644E-01,
     +   .2807E+00,  .9433E-01,  .1101E-02,  .1230E-01,  .2696E-02,
     +   .7989E-01,
     +   .2716E+00,  .9083E-01,  .1037E-02,  .1177E-01,  .2609E-02,
     +   .7423E-01,
     +   .2597E+00,  .8634E-01,  .9587E-03,  .1109E-01,  .2493E-02,
     +   .6731E-01,
     +   .2495E+00,  .8253E-01,  .8939E-03,  .1052E-01,  .2392E-02,
     +   .6172E-01,
     +   .2397E+00,  .7885E-01,  .8331E-03,  .9975E-02,  .2293E-02,
     +   .5657E-01 /
        DATA ((PARTON(I,N,54),I=1,6),N=25,27)/
     +   .2304E+00,  .7542E-01,  .7780E-03,  .9466E-02,  .2198E-02,
     +   .5199E-01,
     +   .2223E+00,  .7245E-01,  .7316E-03,  .9029E-02,  .2114E-02,
     +   .4822E-01,
     +   .2144E+00,  .6956E-01,  .6874E-03,  .8604E-02,  .2032E-02,
     +   .4469E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=1,8)/
     +   .6361E+00,  .2387E+00,  .4043E-02,  .2713E-01,  .1956E-02,
     +   .4743E+00,
     +   .6070E+00,  .2256E+00,  .3667E-02,  .2581E-01,  .2246E-02,
     +   .4345E+00,
     +   .5771E+00,  .2124E+00,  .3304E-02,  .2443E-01,  .2484E-02,
     +   .3935E+00,
     +   .5450E+00,  .1984E+00,  .2940E-02,  .2292E-01,  .2675E-02,
     +   .3501E+00,
     +   .5109E+00,  .1837E+00,  .2582E-02,  .2129E-01,  .2806E-02,
     +   .3053E+00,
     +   .4824E+00,  .1717E+00,  .2305E-02,  .1991E-01,  .2862E-02,
     +   .2695E+00,
     +   .4528E+00,  .1594E+00,  .2037E-02,  .1848E-01,  .2872E-02,
     +   .2345E+00,
     +   .4284E+00,  .1495E+00,  .1831E-02,  .1728E-01,  .2846E-02,
     +   .2072E+00 /
        DATA ((PARTON(I,N,55),I=1,6),N=9,16)/
     +   .4058E+00,  .1403E+00,  .1652E-02,  .1618E-01,  .2796E-02,
     +   .1834E+00,
     +   .3868E+00,  .1327E+00,  .1509E-02,  .1525E-01,  .2737E-02,
     +   .1644E+00,
     +   .3687E+00,  .1256E+00,  .1380E-02,  .1437E-01,  .2667E-02,
     +   .1474E+00,
     +   .3523E+00,  .1192E+00,  .1269E-02,  .1357E-01,  .2593E-02,
     +   .1330E+00,
     +   .3381E+00,  .1137E+00,  .1176E-02,  .1289E-01,  .2520E-02,
     +   .1211E+00,
     +   .3212E+00,  .1072E+00,  .1071E-02,  .1207E-01,  .2424E-02,
     +   .1078E+00,
     +   .3063E+00,  .1015E+00,  .9831E-03,  .1136E-01,  .2332E-02,
     +   .9679E-01,
     +   .2927E+00,  .9639E-01,  .9062E-03,  .1071E-01,  .2243E-02,
     +   .8739E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=17,24)/
     +   .2806E+00,  .9187E-01,  .8407E-03,  .1015E-01,  .2160E-02,
     +   .7953E-01,
     +   .2690E+00,  .8758E-01,  .7803E-03,  .9607E-02,  .2077E-02,
     +   .7241E-01,
     +   .2586E+00,  .8375E-01,  .7279E-03,  .9127E-02,  .1999E-02,
     +   .6637E-01,
     +   .2489E+00,  .8022E-01,  .6811E-03,  .8686E-02,  .1926E-02,
     +   .6105E-01,
     +   .2402E+00,  .7706E-01,  .6402E-03,  .8291E-02,  .1858E-02,
     +   .5650E-01,
     +   .2290E+00,  .7302E-01,  .5894E-03,  .7789E-02,  .1769E-02,
     +   .5095E-01,
     +   .2195E+00,  .6960E-01,  .5477E-03,  .7367E-02,  .1692E-02,
     +   .4650E-01,
     +   .2102E+00,  .6631E-01,  .5087E-03,  .6962E-02,  .1616E-02,
     +   .4243E-01 /
        DATA ((PARTON(I,N,55),I=1,6),N=25,27)/
     +   .2015E+00,  .6324E-01,  .4735E-03,  .6587E-02,  .1545E-02,
     +   .3883E-01,
     +   .1940E+00,  .6061E-01,  .4440E-03,  .6267E-02,  .1482E-02,
     +   .3588E-01,
     +   .1866E+00,  .5804E-01,  .4160E-03,  .5956E-02,  .1420E-02,
     +   .3314E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=1,8)/
     +   .6000E+00,  .2160E+00,  .2655E-02,  .2020E-01,  .1473E-02,
     +   .4231E+00,
     +   .5702E+00,  .2034E+00,  .2396E-02,  .1915E-01,  .1687E-02,
     +   .3831E+00,
     +   .5398E+00,  .1906E+00,  .2148E-02,  .1805E-01,  .1861E-02,
     +   .3429E+00,
     +   .5073E+00,  .1771E+00,  .1900E-02,  .1687E-01,  .1997E-02,
     +   .3013E+00,
     +   .4729E+00,  .1631E+00,  .1658E-02,  .1560E-01,  .2087E-02,
     +   .2592E+00,
     +   .4444E+00,  .1517E+00,  .1472E-02,  .1453E-01,  .2119E-02,
     +   .2262E+00,
     +   .4151E+00,  .1402E+00,  .1294E-02,  .1342E-01,  .2117E-02,
     +   .1944E+00,
     +   .3911E+00,  .1308E+00,  .1157E-02,  .1250E-01,  .2088E-02,
     +   .1701E+00 /
        DATA ((PARTON(I,N,56),I=1,6),N=9,16)/
     +   .3689E+00,  .1223E+00,  .1038E-02,  .1165E-01,  .2043E-02,
     +   .1492E+00,
     +   .3503E+00,  .1152E+00,  .9443E-03,  .1094E-01,  .1992E-02,
     +   .1327E+00,
     +   .3328E+00,  .1086E+00,  .8599E-03,  .1028E-01,  .1934E-02,
     +   .1180E+00,
     +   .3170E+00,  .1028E+00,  .7875E-03,  .9674E-02,  .1873E-02,
     +   .1057E+00,
     +   .3033E+00,  .9772E-01,  .7277E-03,  .9158E-02,  .1815E-02,
     +   .9567E-01,
     +   .2871E+00,  .9179E-01,  .6598E-03,  .8547E-02,  .1739E-02,
     +   .8451E-01,
     +   .2728E+00,  .8663E-01,  .6030E-03,  .8014E-02,  .1667E-02,
     +   .7539E-01,
     +   .2599E+00,  .8199E-01,  .5538E-03,  .7535E-02,  .1597E-02,
     +   .6765E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=17,24)/
     +   .2484E+00,  .7792E-01,  .5120E-03,  .7114E-02,  .1533E-02,
     +   .6122E-01,
     +   .2375E+00,  .7407E-01,  .4736E-03,  .6716E-02,  .1469E-02,
     +   .5545E-01,
     +   .2277E+00,  .7063E-01,  .4404E-03,  .6362E-02,  .1410E-02,
     +   .5057E-01,
     +   .2187E+00,  .6749E-01,  .4109E-03,  .6038E-02,  .1354E-02,
     +   .4632E-01,
     +   .2105E+00,  .6467E-01,  .3851E-03,  .5750E-02,  .1303E-02,
     +   .4269E-01,
     +   .2001E+00,  .6108E-01,  .3532E-03,  .5383E-02,  .1236E-02,
     +   .3829E-01,
     +   .1912E+00,  .5806E-01,  .3272E-03,  .5076E-02,  .1178E-02,
     +   .3479E-01,
     +   .1826E+00,  .5515E-01,  .3029E-03,  .4783E-02,  .1122E-02,
     +   .3161E-01 /
        DATA ((PARTON(I,N,56),I=1,6),N=25,27)/
     +   .1746E+00,  .5246E-01,  .2810E-03,  .4513E-02,  .1069E-02,
     +   .2881E-01,
     +   .1677E+00,  .5015E-01,  .2628E-03,  .4282E-02,  .1023E-02,
     +   .2652E-01,
     +   .1610E+00,  .4791E-01,  .2455E-03,  .4059E-02,  .9771E-03,
     +   .2441E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=1,8)/
     +   .5181E+00,  .1709E+00,  .1051E-02,  .1056E-01,  .7674E-03,
     +   .3254E+00,
     +   .4884E+00,  .1595E+00,  .9396E-03,  .9939E-02,  .8787E-03,
     +   .2883E+00,
     +   .4583E+00,  .1482E+00,  .8337E-03,  .9300E-02,  .9672E-03,
     +   .2522E+00,
     +   .4266E+00,  .1363E+00,  .7294E-03,  .8618E-02,  .1034E-02,
     +   .2163E+00,
     +   .3935E+00,  .1242E+00,  .6286E-03,  .7896E-02,  .1075E-02,
     +   .1812E+00,
     +   .3663E+00,  .1144E+00,  .5519E-03,  .7295E-02,  .1085E-02,
     +   .1546E+00,
     +   .3388E+00,  .1046E+00,  .4793E-03,  .6677E-02,  .1076E-02,
     +   .1298E+00,
     +   .3164E+00,  .9679E-01,  .4244E-03,  .6172E-02,  .1054E-02,
     +   .1114E+00 /
        DATA ((PARTON(I,N,57),I=1,6),N=9,16)/
     +   .2961E+00,  .8973E-01,  .3772E-03,  .5710E-02,  .1023E-02,
     +   .9584E-01,
     +   .2791E+00,  .8392E-01,  .3402E-03,  .5326E-02,  .9911E-03,
     +   .8390E-01,
     +   .2633E+00,  .7855E-01,  .3072E-03,  .4967E-02,  .9557E-03,
     +   .7353E-01,
     +   .2491E+00,  .7379E-01,  .2792E-03,  .4646E-02,  .9195E-03,
     +   .6492E-01,
     +   .2370E+00,  .6975E-01,  .2562E-03,  .4372E-02,  .8854E-03,
     +   .5805E-01,
     +   .2227E+00,  .6503E-01,  .2303E-03,  .4050E-02,  .8418E-03,
     +   .5052E-01,
     +   .2102E+00,  .6095E-01,  .2088E-03,  .3772E-02,  .8010E-03,
     +   .4448E-01,
     +   .1990E+00,  .5732E-01,  .1904E-03,  .3523E-02,  .7623E-03,
     +   .3943E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=17,24)/
     +   .1891E+00,  .5415E-01,  .1748E-03,  .3307E-02,  .7269E-03,
     +   .3530E-01,
     +   .1798E+00,  .5117E-01,  .1606E-03,  .3103E-02,  .6922E-03,
     +   .3164E-01,
     +   .1715E+00,  .4854E-01,  .1484E-03,  .2923E-02,  .6604E-03,
     +   .2859E-01,
     +   .1638E+00,  .4613E-01,  .1376E-03,  .2759E-02,  .6307E-03,
     +   .2595E-01,
     +   .1570E+00,  .4400E-01,  .1283E-03,  .2614E-02,  .6036E-03,
     +   .2373E-01,
     +   .1483E+00,  .4129E-01,  .1168E-03,  .2431E-02,  .5685E-03,
     +   .2107E-01,
     +   .1409E+00,  .3903E-01,  .1075E-03,  .2279E-02,  .5386E-03,
     +   .1898E-01,
     +   .1339E+00,  .3686E-01,  .9888E-04,  .2135E-02,  .5096E-03,
     +   .1709E-01 /
        DATA ((PARTON(I,N,57),I=1,6),N=25,27)/
     +   .1273E+00,  .3487E-01,  .9117E-04,  .2003E-02,  .4825E-03,
     +   .1546E-01,
     +   .1217E+00,  .3318E-01,  .8476E-04,  .1890E-02,  .4591E-03,
     +   .1413E-01,
     +   .1162E+00,  .3154E-01,  .7874E-04,  .1783E-02,  .4362E-03,
     +   .1292E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=1,8)/
     +   .4295E+00,  .1287E+00,  .3677E-03,  .5032E-02,  .3374E-03,
     +   .2384E+00,
     +   .4015E+00,  .1191E+00,  .3255E-03,  .4696E-02,  .3904E-03,
     +   .2067E+00,
     +   .3735E+00,  .1096E+00,  .2859E-03,  .4358E-02,  .4330E-03,
     +   .1770E+00,
     +   .3443E+00,  .9990E-01,  .2474E-03,  .4004E-02,  .4653E-03,
     +   .1481E+00,
     +   .3141E+00,  .9001E-01,  .2105E-03,  .3636E-02,  .4849E-03,
     +   .1209E+00,
     +   .2898E+00,  .8213E-01,  .1828E-03,  .3333E-02,  .4894E-03,
     +   .1010E+00,
     +   .2653E+00,  .7432E-01,  .1569E-03,  .3024E-02,  .4836E-03,
     +   .8280E-01,
     +   .2456E+00,  .6814E-01,  .1375E-03,  .2774E-02,  .4719E-03,
     +   .6964E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=9,16)/
     +   .2279E+00,  .6264E-01,  .1211E-03,  .2547E-02,  .4560E-03,
     +   .5885E-01,
     +   .2133E+00,  .5815E-01,  .1083E-03,  .2360E-02,  .4395E-03,
     +   .5071E-01,
     +   .1998E+00,  .5403E-01,  .9696E-04,  .2186E-02,  .4216E-03,
     +   .4377E-01,
     +   .1877E+00,  .5041E-01,  .8742E-04,  .2032E-02,  .4035E-03,
     +   .3811E-01,
     +   .1775E+00,  .4736E-01,  .7967E-04,  .1901E-02,  .3865E-03,
     +   .3367E-01,
     +   .1656E+00,  .4382E-01,  .7100E-04,  .1748E-02,  .3650E-03,
     +   .2888E-01,
     +   .1553E+00,  .4079E-01,  .6388E-04,  .1617E-02,  .3451E-03,
     +   .2509E-01,
     +   .1461E+00,  .3811E-01,  .5780E-04,  .1501E-02,  .3263E-03,
     +   .2198E-01 /
        DATA ((PARTON(I,N,58),I=1,6),N=17,24)/
     +   .1380E+00,  .3579E-01,  .5271E-04,  .1400E-02,  .3093E-03,
     +   .1947E-01,
     +   .1304E+00,  .3362E-01,  .4810E-04,  .1306E-02,  .2927E-03,
     +   .1727E-01,
     +   .1237E+00,  .3171E-01,  .4418E-04,  .1223E-02,  .2777E-03,
     +   .1546E-01,
     +   .1176E+00,  .2999E-01,  .4072E-04,  .1148E-02,  .2637E-03,
     +   .1392E-01,
     +   .1122E+00,  .2846E-01,  .3774E-04,  .1082E-02,  .2511E-03,
     +   .1263E-01,
     +   .1053E+00,  .2654E-01,  .3411E-04,  .9997E-03,  .2348E-03,
     +   .1110E-01,
     +   .9952E-01,  .2494E-01,  .3119E-04,  .9315E-03,  .2211E-03,
     +   .9915E-02,
     +   .9400E-01,  .2342E-01,  .2850E-04,  .8672E-03,  .2079E-03,
     +   .8857E-02 /
        DATA ((PARTON(I,N,58),I=1,6),N=25,27)/
     +   .8892E-01,  .2203E-01,  .2611E-04,  .8087E-03,  .1956E-03,
     +   .7948E-02,
     +   .8459E-01,  .2086E-01,  .2414E-04,  .7593E-03,  .1851E-03,
     +   .7220E-02,
     +   .8040E-01,  .1973E-01,  .2229E-04,  .7123E-03,  .1749E-03,
     +   .6558E-02 /
        DATA ((PARTON(I,N,59),I=1,6),N=1,8)/
     +   .3406E+00,  .9179E-01,  .1115E-03,  .2118E-02,  .1025E-03,
     +   .1653E+00,
     +   .3157E+00,  .8422E-01,  .9774E-04,  .1954E-02,  .1254E-03,
     +   .1404E+00,
     +   .2911E+00,  .7682E-01,  .8494E-04,  .1796E-02,  .1453E-03,
     +   .1175E+00,
     +   .2656E+00,  .6928E-01,  .7263E-04,  .1634E-02,  .1615E-03,
     +   .9607E-01,
     +   .2397E+00,  .6173E-01,  .6102E-04,  .1470E-02,  .1730E-03,
     +   .7641E-01,
     +   .2190E+00,  .5577E-01,  .5240E-04,  .1337E-02,  .1773E-03,
     +   .6238E-01,
     +   .1984E+00,  .4993E-01,  .4443E-04,  .1203E-02,  .1769E-03,
     +   .4998E-01,
     +   .1821E+00,  .4537E-01,  .3854E-04,  .1095E-02,  .1734E-03,
     +   .4122E-01 /
        DATA ((PARTON(I,N,59),I=1,6),N=9,16)/
     +   .1675E+00,  .4134E-01,  .3358E-04,  .9981E-03,  .1678E-03,
     +   .3419E-01,
     +   .1556E+00,  .3808E-01,  .2976E-04,  .9186E-03,  .1617E-03,
     +   .2899E-01,
     +   .1447E+00,  .3512E-01,  .2642E-04,  .8454E-03,  .1549E-03,
     +   .2464E-01,
     +   .1350E+00,  .3254E-01,  .2363E-04,  .7808E-03,  .1479E-03,
     +   .2116E-01,
     +   .1269E+00,  .3038E-01,  .2138E-04,  .7263E-03,  .1413E-03,
     +   .1847E-01,
     +   .1175E+00,  .2789E-01,  .1888E-04,  .6630E-03,  .1328E-03,
     +   .1561E-01,
     +   .1094E+00,  .2578E-01,  .1685E-04,  .6089E-03,  .1249E-03,
     +   .1339E-01,
     +   .1022E+00,  .2392E-01,  .1513E-04,  .5613E-03,  .1175E-03,
     +   .1159E-01 /
        DATA ((PARTON(I,N,59),I=1,6),N=17,24)/
     +   .9602E-01,  .2233E-01,  .1370E-04,  .5203E-03,  .1108E-03,
     +   .1016E-01,
     +   .9022E-01,  .2085E-01,  .1241E-04,  .4822E-03,  .1043E-03,
     +   .8920E-02,
     +   .8511E-01,  .1955E-01,  .1132E-04,  .4490E-03,  .9845E-04,
     +   .7913E-02,
     +   .8048E-01,  .1839E-01,  .1037E-04,  .4191E-03,  .9301E-04,
     +   .7063E-02,
     +   .7638E-01,  .1737E-01,  .9557E-05,  .3929E-03,  .8811E-04,
     +   .6360E-02,
     +   .7122E-01,  .1608E-01,  .8570E-05,  .3603E-03,  .8184E-04,
     +   .5537E-02,
     +   .6693E-01,  .1503E-01,  .7782E-05,  .3336E-03,  .7658E-04,
     +   .4905E-02,
     +   .6285E-01,  .1403E-01,  .7062E-05,  .3085E-03,  .7156E-04,
     +   .4347E-02 /
        DATA ((PARTON(I,N,59),I=1,6),N=25,27)/
     +   .5913E-01,  .1312E-01,  .6427E-05,  .2859E-03,  .6693E-04,
     +   .3873E-02,
     +   .5596E-01,  .1236E-01,  .5906E-05,  .2669E-03,  .6297E-04,
     +   .3496E-02,
     +   .5292E-01,  .1163E-01,  .5421E-05,  .2489E-03,  .5917E-04,
     +   .3156E-02 /
        DATA ((PARTON(I,N,60),I=1,6),N=1,8)/
     +   .2569E+00,  .6149E-01,  .2847E-04,  .7385E-03,  .0000E+00,
     +   .1075E+00,
     +   .2360E+00,  .5592E-01,  .2468E-04,  .6681E-03,  .3695E-05,
     +   .8933E-01,
     +   .2156E+00,  .5052E-01,  .2120E-04,  .6043E-03,  .1311E-04,
     +   .7315E-01,
     +   .1947E+00,  .4508E-01,  .1790E-04,  .5427E-03,  .2233E-04,
     +   .5834E-01,
     +   .1737E+00,  .3969E-01,  .1482E-04,  .4831E-03,  .3065E-04,
     +   .4518E-01,
     +   .1571E+00,  .3550E-01,  .1257E-04,  .4360E-03,  .3557E-04,
     +   .3606E-01,
     +   .1408E+00,  .3143E-01,  .1051E-04,  .3890E-03,  .3865E-04,
     +   .2820E-01,
     +   .1280E+00,  .2829E-01,  .9013E-05,  .3516E-03,  .3976E-04,
     +   .2279E-01 /
        DATA ((PARTON(I,N,60),I=1,6),N=9,16)/
     +   .1167E+00,  .2554E-01,  .7767E-05,  .3182E-03,  .3976E-04,
     +   .1855E-01,
     +   .1076E+00,  .2334E-01,  .6816E-05,  .2910E-03,  .3918E-04,
     +   .1547E-01,
     +   .9923E-01,  .2136E-01,  .5993E-05,  .2661E-03,  .3816E-04,
     +   .1295E-01,
     +   .9196E-01,  .1964E-01,  .5312E-05,  .2442E-03,  .3683E-04,
     +   .1096E-01,
     +   .8587E-01,  .1822E-01,  .4767E-05,  .2258E-03,  .3541E-04,
     +   .9447E-02,
     +   .7886E-01,  .1659E-01,  .4168E-05,  .2045E-03,  .3344E-04,
     +   .7867E-02,
     +   .7290E-01,  .1522E-01,  .3685E-05,  .1864E-03,  .3152E-04,
     +   .6659E-02,
     +   .6766E-01,  .1403E-01,  .3280E-05,  .1706E-03,  .2964E-04,
     +   .5696E-02 /
        DATA ((PARTON(I,N,60),I=1,6),N=17,24)/
     +   .6315E-01,  .1301E-01,  .2946E-05,  .1570E-03,  .2791E-04,
     +   .4940E-02,
     +   .5896E-01,  .1207E-01,  .2648E-05,  .1445E-03,  .2621E-04,
     +   .4295E-02,
     +   .5530E-01,  .1125E-01,  .2399E-05,  .1336E-03,  .2465E-04,
     +   .3776E-02,
     +   .5200E-01,  .1052E-01,  .2182E-05,  .1239E-03,  .2320E-04,
     +   .3342E-02,
     +   .4910E-01,  .9885E-02,  .1997E-05,  .1155E-03,  .2189E-04,
     +   .2987E-02,
     +   .4547E-01,  .9092E-02,  .1775E-05,  .1050E-03,  .2021E-04,
     +   .2577E-02,
     +   .4247E-01,  .8442E-02,  .1600E-05,  .9649E-04,  .1881E-04,
     +   .2264E-02,
     +   .3965E-01,  .7834E-02,  .1441E-05,  .8858E-04,  .1747E-04,
     +   .1992E-02 /
        DATA ((PARTON(I,N,60),I=1,6),N=25,27)/
     +   .3708E-01,  .7284E-02,  .1301E-05,  .8148E-04,  .1624E-04,
     +   .1762E-02,
     +   .3491E-01,  .6823E-02,  .1188E-05,  .7556E-04,  .1519E-04,
     +   .1581E-02,
     +   .3284E-01,  .6386E-02,  .1083E-05,  .6999E-04,  .1418E-04,
     +   .1419E-02 /
        DATA ((PARTON(I,N,61),I=1,6),N=1,8)/
     +   .1825E+00,  .3820E-01,  .5842E-05,  .1760E-03,  .0000E+00,
     +   .6458E-01,
     +   .1661E+00,  .3441E-01,  .4995E-05,  .1504E-03,  .0000E+00,
     +   .5251E-01,
     +   .1502E+00,  .3077E-01,  .4227E-05,  .1303E-03,  .0000E+00,
     +   .4201E-01,
     +   .1342E+00,  .2715E-01,  .3509E-05,  .1135E-03,  .0000E+00,
     +   .3266E-01,
     +   .1182E+00,  .2361E-01,  .2854E-05,  .9949E-04,  .0000E+00,
     +   .2460E-01,
     +   .1058E+00,  .2088E-01,  .2383E-05,  .8910E-04,  .0000E+00,
     +   .1917E-01,
     +   .9373E-01,  .1828E-01,  .1960E-05,  .7902E-04,  .0000E+00,
     +   .1462E-01,
     +   .8438E-01,  .1628E-01,  .1655E-05,  .7108E-04,  .0000E+00,
     +   .1157E-01 /
        DATA ((PARTON(I,N,61),I=1,6),N=9,16)/
     +   .7620E-01,  .1456E-01,  .1407E-05,  .6397E-04,  .0000E+00,
     +   .9228E-02,
     +   .6964E-01,  .1319E-01,  .1219E-05,  .5825E-04,  .0000E+00,
     +   .7570E-02,
     +   .6372E-01,  .1197E-01,  .1059E-05,  .5303E-04,  .0000E+00,
     +   .6233E-02,
     +   .5859E-01,  .1092E-01,  .9283E-06,  .4840E-04,  .0000E+00,
     +   .5199E-02,
     +   .5434E-01,  .1006E-01,  .8247E-06,  .4449E-04,  .0000E+00,
     +   .4424E-02,
     +   .4948E-01,  .9081E-02,  .7123E-06,  .3995E-04,  .0000E+00,
     +   .3628E-02,
     +   .4538E-01,  .8265E-02,  .6226E-06,  .3609E-04,  .0000E+00,
     +   .3030E-02,
     +   .4181E-01,  .7560E-02,  .5483E-06,  .3272E-04,  .3430E-07,
     +   .2561E-02 /
        DATA ((PARTON(I,N,61),I=1,6),N=17,24)/
     +   .3876E-01,  .6963E-02,  .4877E-06,  .2984E-04,  .1792E-06,
     +   .2197E-02,
     +   .3595E-01,  .6416E-02,  .4342E-06,  .2719E-04,  .2753E-06,
     +   .1891E-02,
     +   .3351E-01,  .5945E-02,  .3897E-06,  .2490E-04,  .3313E-06,
     +   .1648E-02,
     +   .3132E-01,  .5526E-02,  .3515E-06,  .2287E-04,  .3615E-06,
     +   .1447E-02,
     +   .2941E-01,  .5162E-02,  .3193E-06,  .2110E-04,  .3735E-06,
     +   .1284E-02,
     +   .2704E-01,  .4713E-02,  .2809E-06,  .1894E-04,  .3712E-06,
     +   .1097E-02,
     +   .2509E-01,  .4347E-02,  .2508E-06,  .1720E-04,  .3613E-06,
     +   .9568E-03,
     +   .2327E-01,  .4007E-02,  .2238E-06,  .1560E-04,  .3453E-06,
     +   .8354E-03 /
        DATA ((PARTON(I,N,61),I=1,6),N=25,27)/
     +   .2163E-01,  .3703E-02,  .2004E-06,  .1418E-04,  .3228E-06,
     +   .7340E-03,
     +   .2025E-01,  .3448E-02,  .1816E-06,  .1300E-04,  .2988E-06,
     +   .6549E-03,
     +   .1894E-01,  .3209E-02,  .1643E-06,  .1190E-04,  .2724E-06,
     +   .5846E-03 /
        DATA ((PARTON(I,N,62),I=1,6),N=1,8)/
     +   .1204E+00,  .2158E-01,  .8875E-06,  .0000E+00,  .0000E+00,
     +   .3513E-01,
     +   .1084E+00,  .1923E-01,  .7417E-06,  .0000E+00,  .0000E+00,
     +   .2790E-01,
     +   .9699E-01,  .1701E-01,  .6127E-06,  .0000E+00,  .0000E+00,
     +   .2177E-01,
     +   .8559E-01,  .1483E-01,  .4952E-06,  .0000E+00,  .0000E+00,
     +   .1647E-01,
     +   .7441E-01,  .1272E-01,  .3916E-06,  .0000E+00,  .0000E+00,
     +   .1204E-01,
     +   .6580E-01,  .1111E-01,  .3192E-06,  .0000E+00,  .0000E+00,
     +   .9146E-02,
     +   .5757E-01,  .9604E-02,  .2559E-06,  .0000E+00,  .0000E+00,
     +   .6790E-02,
     +   .5127E-01,  .8462E-02,  .2116E-06,  .0000E+00,  .0000E+00,
     +   .5253E-02 /
        DATA ((PARTON(I,N,62),I=1,6),N=9,16)/
     +   .4581E-01,  .7486E-02,  .1762E-06,  .0000E+00,  .0000E+00,
     +   .4104E-02,
     +   .4149E-01,  .6721E-02,  .1501E-06,  .0000E+00,  .0000E+00,
     +   .3306E-02,
     +   .3762E-01,  .6042E-02,  .1284E-06,  .0000E+00,  .0000E+00,
     +   .2676E-02,
     +   .3431E-01,  .5467E-02,  .1109E-06,  .0000E+00,  .0000E+00,
     +   .2198E-02,
     +   .3158E-01,  .4996E-02,  .9729E-07,  .0000E+00,  .0000E+00,
     +   .1846E-02,
     +   .2848E-01,  .4468E-02,  .8277E-07,  .0000E+00,  .0000E+00,
     +   .1490E-02,
     +   .2590E-01,  .4032E-02,  .7141E-07,  .0000E+00,  .0000E+00,
     +   .1227E-02,
     +   .2367E-01,  .3658E-02,  .6215E-07,  .0000E+00,  .0000E+00,
     +   .1025E-02 /
        DATA ((PARTON(I,N,62),I=1,6),N=17,24)/
     +   .2179E-01,  .3344E-02,  .5472E-07,  .0000E+00,  .0000E+00,
     +   .8696E-03,
     +   .2006E-01,  .3059E-02,  .4826E-07,  .0000E+00,  .0000E+00,
     +   .7409E-03,
     +   .1857E-01,  .2815E-02,  .4296E-07,  .0000E+00,  .0000E+00,
     +   .6398E-03,
     +   .1725E-01,  .2599E-02,  .3845E-07,  .0000E+00,  .0000E+00,
     +   .5572E-03,
     +   .1610E-01,  .2413E-02,  .3470E-07,  .0000E+00,  .0000E+00,
     +   .4909E-03,
     +   .1468E-01,  .2185E-02,  .3029E-07,  .0000E+00,  .0000E+00,
     +   .4158E-03,
     +   .1353E-01,  .2001E-02,  .2689E-07,  .0000E+00,  .0000E+00,
     +   .3599E-03,
     +   .1246E-01,  .1831E-02,  .2388E-07,  .0000E+00,  .0000E+00,
     +   .3120E-03 /
        DATA ((PARTON(I,N,62),I=1,6),N=25,27)/
     +   .1150E-01,  .1680E-02,  .2130E-07,  .0000E+00,  .0000E+00,
     +   .2724E-03,
     +   .1070E-01,  .1555E-02,  .1924E-07,  .0000E+00,  .0000E+00,
     +   .2417E-03,
     +   .9944E-02,  .1438E-02,  .1737E-07,  .0000E+00,  .0000E+00,
     +   .2146E-03 /
        DATA ((PARTON(I,N,63),I=1,6),N=1,8)/
     +   .7191E-01,  .1074E-01,  .8674E-07,  .0000E+00,  .0000E+00,
     +   .1673E-01,
     +   .6405E-01,  .9459E-02,  .6974E-07,  .0000E+00,  .0000E+00,
     +   .1294E-01,
     +   .5659E-01,  .8263E-02,  .5551E-07,  .0000E+00,  .0000E+00,
     +   .9829E-02,
     +   .4926E-01,  .7103E-02,  .4332E-07,  .0000E+00,  .0000E+00,
     +   .7216E-02,
     +   .4219E-01,  .6000E-02,  .3340E-07,  .0000E+00,  .0000E+00,
     +   .5104E-02,
     +   .3682E-01,  .5175E-02,  .2689E-07,  .0000E+00,  .0000E+00,
     +   .3770E-02,
     +   .3176E-01,  .4407E-02,  .2150E-07,  .0000E+00,  .0000E+00,
     +   .2718E-02,
     +   .2794E-01,  .3836E-02,  .1790E-07,  .0000E+00,  .0000E+00,
     +   .2052E-02 /
        DATA ((PARTON(I,N,63),I=1,6),N=9,16)/
     +   .2468E-01,  .3353E-02,  .1514E-07,  .0000E+00,  .0000E+00,
     +   .1566E-02,
     +   .2212E-01,  .2979E-02,  .1319E-07,  .0000E+00,  .0000E+00,
     +   .1238E-02,
     +   .1985E-01,  .2651E-02,  .1160E-07,  .0000E+00,  .0000E+00,
     +   .9837E-03,
     +   .1793E-01,  .2376E-02,  .1034E-07,  .0000E+00,  .0000E+00,
     +   .7947E-03,
     +   .1637E-01,  .2153E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6580E-03,
     +   .1461E-01,  .1905E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5224E-03,
     +   .1316E-01,  .1702E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4243E-03,
     +   .1192E-01,  .1530E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3497E-03 /
        DATA ((PARTON(I,N,63),I=1,6),N=17,24)/
     +   .1088E-01,  .1387E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2936E-03,
     +   .9934E-02,  .1258E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2476E-03,
     +   .9127E-02,  .1149E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2120E-03,
     +   .8415E-02,  .1053E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1831E-03,
     +   .7801E-02,  .9711E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1602E-03,
     +   .7050E-02,  .8714E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1345E-03,
     +   .6445E-02,  .7916E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1156E-03,
     +   .5887E-02,  .7187E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .9954E-04 /
        DATA ((PARTON(I,N,63),I=1,6),N=25,27)/
     +   .5392E-02,  .6542E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .8636E-04,
     +   .4982E-02,  .6013E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7623E-04,
     +   .4599E-02,  .5520E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6735E-04 /
        DATA ((PARTON(I,N,64),I=1,6),N=1,8)/
     +   .3737E-01,  .4461E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6589E-02,
     +   .3284E-01,  .3877E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4949E-02,
     +   .2861E-01,  .3338E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3642E-02,
     +   .2451E-01,  .2824E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2584E-02,
     +   .2063E-01,  .2343E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1760E-02,
     +   .1773E-01,  .1990E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1259E-02,
     +   .1504E-01,  .1667E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .8782E-03,
     +   .1304E-01,  .1430E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6449E-03 /
        DATA ((PARTON(I,N,64),I=1,6),N=9,16)/
     +   .1136E-01,  .1233E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4800E-03,
     +   .1006E-01,  .1082E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3713E-03,
     +   .8928E-02,  .9515E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2892E-03,
     +   .7976E-02,  .8432E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2295E-03,
     +   .7208E-02,  .7565E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1872E-03,
     +   .6356E-02,  .6612E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1460E-03,
     +   .5661E-02,  .5842E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1168E-03,
     +   .5074E-02,  .5197E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .9506E-04 /
        DATA ((PARTON(I,N,64),I=1,6),N=17,24)/
     +   .4586E-02,  .4664E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7893E-04,
     +   .4147E-02,  .4190E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6590E-04,
     +   .3776E-02,  .3792E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5591E-04,
     +   .3452E-02,  .3446E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4793E-04,
     +   .3175E-02,  .3152E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4165E-04,
     +   .2839E-02,  .2798E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3468E-04,
     +   .2571E-02,  .2518E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2960E-04,
     +   .2327E-02,  .2264E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2532E-04 /
        DATA ((PARTON(I,N,64),I=1,6),N=25,27)/
     +   .2112E-02,  .2043E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2183E-04,
     +   .1936E-02,  .1862E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1918E-04,
     +   .1772E-02,  .1695E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1686E-04 /
        DATA ((PARTON(I,N,65),I=1,6),N=1,8)/
     +   .1564E-01,  .1399E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1929E-02,
     +   .1352E-01,  .1196E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1398E-02,
     +   .1157E-01,  .1011E-02,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .9903E-03,
     +   .9720E-02,  .8388E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6741E-03,
     +   .8003E-02,  .6810E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4391E-03,
     +   .6750E-02,  .5674E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3025E-03,
     +   .5611E-02,  .4656E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2028E-03,
     +   .4782E-02,  .3924E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1442E-03 /
        DATA ((PARTON(I,N,65),I=1,6),N=9,16)/
     +   .4096E-02,  .3326E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1042E-03,
     +   .3574E-02,  .2876E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7870E-04,
     +   .3125E-02,  .2492E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5993E-04,
     +   .2754E-02,  .2178E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4663E-04,
     +   .2458E-02,  .1930E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3741E-04,
     +   .2135E-02,  .1662E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2865E-04,
     +   .1876E-02,  .1448E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2257E-04,
     +   .1659E-02,  .1271E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1812E-04 /
        DATA ((PARTON(I,N,65),I=1,6),N=17,24)/
     +   .1482E-02,  .1127E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1488E-04,
     +   .1324E-02,  .1001E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1230E-04,
     +   .1193E-02,  .8954E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1034E-04,
     +   .1079E-02,  .8051E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .8798E-05,
     +   .9826E-03,  .7292E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7595E-05,
     +   .8673E-03,  .6389E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6273E-05,
     +   .7765E-03,  .5684E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5318E-05,
     +   .6947E-03,  .5052E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4521E-05 /
        DATA ((PARTON(I,N,65),I=1,6),N=25,27)/
     +   .6234E-03,  .4506E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3880E-05,
     +   .5657E-03,  .4066E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3394E-05,
     +   .5127E-03,  .3665E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2974E-05 /
        DATA ((PARTON(I,N,66),I=1,6),N=1,8)/
     +   .4423E-02,  .2636E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3302E-03,
     +   .3738E-02,  .2203E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2281E-03,
     +   .3124E-02,  .1819E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1537E-03,
     +   .2557E-02,  .1469E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .9915E-04,
     +   .2044E-02,  .1158E-03,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6092E-04,
     +   .1681E-02,  .9404E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3998E-04,
     +   .1359E-02,  .7505E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2551E-04,
     +   .1131E-02,  .6176E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1744E-04 /
        DATA ((PARTON(I,N,66),I=1,6),N=9,16)/
     +   .9469E-03,  .5115E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1217E-04,
     +   .8099E-03,  .4335E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .8927E-05,
     +   .6943E-03,  .3683E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6623E-05,
     +   .6007E-03,  .3160E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5042E-05,
     +   .5275E-03,  .2755E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3973E-05,
     +   .4489E-03,  .2323E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2982E-05,
     +   .3871E-03,  .1987E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2311E-05,
     +   .3364E-03,  .1713E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1828E-05 /
        DATA ((PARTON(I,N,66),I=1,6),N=17,24)/
     +   .2956E-03,  .1495E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1482E-05,
     +   .2600E-03,  .1306E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1210E-05,
     +   .2306E-03,  .1151E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1007E-05,
     +   .2057E-03,  .1020E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .8483E-06,
     +   .1849E-03,  .9117E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7266E-06,
     +   .1603E-03,  .7848E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5960E-06,
     +   .1413E-03,  .6873E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .5040E-06,
     +   .1245E-03,  .6014E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4298E-06 /
        DATA ((PARTON(I,N,66),I=1,6),N=25,27)/
     +   .1100E-03,  .5283E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3724E-06,
     +   .9848E-04,  .4703E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3305E-06,
     +   .8804E-04,  .4180E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2948E-06 /
        DATA ((PARTON(I,N,67),I=1,6),N=1,8)/
     +   .4829E-03,  .1443E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1538E-04,
     +   .3935E-03,  .1163E-04,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .9845E-05,
     +   .3162E-03,  .9231E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6135E-05,
     +   .2478E-03,  .7137E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3638E-05,
     +   .1888E-03,  .5360E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2044E-05,
     +   .1489E-03,  .4173E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1248E-05,
     +   .1151E-03,  .3182E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .7426E-06,
     +   .9215E-04,  .2518E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4817E-06 /
        DATA ((PARTON(I,N,67),I=1,6),N=9,16)/
     +   .7431E-04,  .2008E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3220E-06,
     +   .6151E-04,  .1646E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2286E-06,
     +   .5107E-04,  .1354E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1646E-06,
     +   .4287E-04,  .1127E-05,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1220E-06,
     +   .3665E-04,  .9556E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .9347E-07,
     +   .3017E-04,  .7791E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .6693E-07,
     +   .2523E-04,  .6458E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .4849E-07,
     +   .2130E-04,  .5409E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .3477E-07 /
        DATA ((PARTON(I,N,67),I=1,6),N=17,24)/
     +   .1823E-04,  .4593E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2466E-07,
     +   .1562E-04,  .3905E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1673E-07,
     +   .1352E-04,  .3358E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1118E-07,
     +   .1178E-04,  .2907E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .1036E-04,  .2541E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .8728E-05,  .2124E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .7499E-05,  .1812E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .0000E+00,
     +   .6438E-05,  .1545E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1248E-07 /
        DATA ((PARTON(I,N,67),I=1,6),N=25,27)/
     +   .5551E-05,  .1323E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .1799E-07,
     +   .4860E-05,  .1151E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2342E-07,
     +   .4248E-05,  .1000E-06,  .0000E+00,  .0000E+00,  .0000E+00,
     +   .2854E-07 /
C
       X  = DX
       Q  = DQ
       Q2 = DQ*DQ
*
* ..CHECK OF X AND Q2 VALUES : 
C      IF ( (X.LT.0.99D-9) .OR. (X.GT.1.D0) ) THEN
C         WRITE(6,91) 
C  91     FORMAT (2X,'PARTON INTERPOLATION: X OUT OF RANGE')
C         STOP
C      ENDIF
C      IF ( (Q2.LT.0.799) .OR. (Q2.GT.1.01E6) ) THEN
C         WRITE(6,92) 
C  92     FORMAT (2X,'PARTON INTERPOLATION: Q2 OUT OF RANGE')
C         STOP
C      ENDIF
      IF (IINIP .NE. 0) GOTO 16
*
* ..INITIALIZATION, IF REQUIRED :
*
*    SELECTION AND READING OF THE GRID : 
*    (COMMENT: FIRST NUMBER IN THE FIRST LINE OF THE GRID)
C      IF (ISET .EQ. 1) THEN
C        OPEN (11,FILE='grv98lo.grid',STATUS='old')   ! 7.332E-05
C      ELSE IF (ISET .EQ. 2) THEN
C        OPEN (11,FILE='grv98nlm.grid',STATUS='old')  ! 1.015E-04
C      ELSE IF (ISET .EQ. 3) THEN
C        OPEN (11,FILE='grv98nld.grid',STATUS='old')  ! 1.238E-04
C      ELSE
C        WRITE(6,93)
C  93    FORMAT (2X,'NO OR INVALID PARTON SET CHOICE')
C        STOP
C      END IF
C
      IINIP = 1
C
C      READ(11,89) LINE
C  89  FORMAT(A80)
C      DO 15 M = 1, NX-1 
C      DO 15 N = 1, NQ
C      READ(11,90) PARTON(1,N,M), PARTON(2,N,M), PARTON(3,N,M), 
C     1            PARTON(4,N,M), PARTON(5,N,M), PARTON(6,N,M) 
C  90  FORMAT (6(1PE10.3))
C  15  CONTINUE
C      CLOSE(11)
*
* ...ARRAYS FOR THE INTERPOLATION SUBROUTINE :
      DO 10 IQ = 1, NQ
      DO 20 IX = 1, NX-1
        XB0V = XB(IX)**0.5 
        XB0S = XB(IX)**(-0.2) 
        XB1 = 1.-XB(IX)
        XUVF(IX,IQ) = PARTON(1,IQ,IX) / (XB1**3 * XB0V)
        XDVF(IX,IQ) = PARTON(2,IQ,IX) / (XB1**4 * XB0V)
        XDEF(IX,IQ) = PARTON(3,IQ,IX) / (XB1**7 * XB0V) 
        XUDF(IX,IQ) = PARTON(4,IQ,IX) / (XB1**7 * XB0S)
        XSF(IX,IQ)  = PARTON(5,IQ,IX) / (XB1**7 * XB0S)
        XGF(IX,IQ)  = PARTON(6,IQ,IX) / (XB1**5 * XB0S)
  20  CONTINUE
        XUVF(NX,IQ) = 0.E0
        XDVF(NX,IQ) = 0.E0
        XDEF(NX,IQ) = 0.E0
        XUDF(NX,IQ) = 0.E0
        XSF(NX,IQ)  = 0.E0
        XGF(NX,IQ)  = 0.E0
  10  CONTINUE  
      NA(1) = NX
      NA(2) = NQ
      DO 30 IX = 1, NX
        ARRF(IX) =  LOG(XB(IX))
  30  CONTINUE
      DO 40 IQ = 1, NQ
        ARRF(NX+IQ) =  LOG(QS(IQ))
  40  CONTINUE
*
* ..CONTINUATION, IF INITIALIZATION WAS DONE PREVIOUSLY.
*
  16  CONTINUE
*
* ..INTERPOLATION :
      XT(1) =  LOG(X)
      XT(2) =  LOG(Q2)
      X1 = 1.- X
      XV = X**0.5
      XS = X**(-0.2)
      UV = DBFINT(NARG,XT,NA,ARRF,XUVF) * X1**3 * XV
      DUV = UV
      DV = DBFINT(NARG,XT,NA,ARRF,XDVF) * X1**4 * XV
      DDV = DV
      DE = DBFINT(NARG,XT,NA,ARRF,XDEF) * X1**7 * XV
      UD = DBFINT(NARG,XT,NA,ARRF,XUDF) * X1**7 * XS
      IF (DE. GT. UD) DE = ZEROD
      US = 0.5 * (UD - DE)
      DUSEA = US
      DS = 0.5 * (UD + DE)
      DDSEA = DS
      SS = DBFINT(NARG,XT,NA,ARRF,XSF)  * X1**7 * XS
      DSTR = SS
      DCHM = ZEROD
      DBOT = ZEROD
      DTOP = ZEROD
      GL = DBFINT(NARG,XT,NA,ARRF,XGF)  * X1**5 * XS 
      DGL = GL
*
 60   RETURN
      END
