/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File Editor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef RequestPanelHelp_H
#define RequestPanelHelp_H

#include <string>
using std::string;

#include <Xm/Xm.h>



class Parameter;
class RequestPanel;

#include "RequestPanelItem.h"

class RequestPanelHelp: public RequestPanelItem {
public:

// -- Exceptions
	// None

// -- Constructor

	RequestPanelHelp(RequestPanel&,const Parameter&);

// -- Destructor		 l

	virtual ~RequestPanelHelp(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	virtual void start() = 0;
	virtual bool dialog() = 0;
	
// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	static RequestPanelHelp* build(Widget, RequestPanel&,const Parameter&);

protected:

// -- Contructors


// -- Members

// -- Methods
	//void create(Widget w,char* name);

	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods


private:

// No copy allowed

	RequestPanelHelp(const RequestPanelHelp&);
	RequestPanelHelp& operator=(const RequestPanelHelp&);

// -- Members


// -- Methods

// -- Overridden methods

	// -- From XDesigned 
       
// -- Class members


// -- Class methods
	// None

// -- Friends


};


inline void destroy(RequestPanelHelp**) {}

template<class T>
class XHelp : public RequestPanelHelp, public T {
	virtual bool dialog() { return false; }
	virtual void start()  {};
public:
	XHelp(Widget w, RequestPanel& o, const Parameter& p): 
		RequestPanelHelp(o, p)
	{
		T::create(w);
		XtManageChild(T::xd_rootwidget());
	}
};

class DialogHelp : public RequestPanelHelp {
	virtual bool dialog() { return true; }
public:
	DialogHelp(Widget, RequestPanel& o, const Parameter& p):
		RequestPanelHelp(o, p) {}
};

#endif
