/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQFolderPanel_H
#define MvQFolderPanel_H
 
#include <QList>
#include <QSettings>
#include <QString>
#include <QWidget>

#include "Desktop.h"
#include "MvQActionList.h"

class QMenu;
class QStackedWidget;
class QTabBar;
class QToolButton;
class QVBoxLayout;

class FolderSearchData;

class MvQContextItemSet;
class MvQFolderHistory;
class MvQFolderNavigation;
class MvQFolderWidget;

class Folder;

#include "IconObject.h"

using namespace std;	

class MvQTabWidget : public QWidget
{
    Q_OBJECT
  
public:
    	MvQTabWidget(QWidget *parent=0);
	
	int currentIndex() const;
	int indexOfWidget(QWidget*) const;
	QWidget *widget(int) const;
	QWidget *currentWidget() const;
	void checkTabStatus();	
	void addTab(QWidget *,QPixmap,QString);
	void setTabText(int,QString);
	void setTabIcon(int,QPixmap);
	void setTabToolTip(int index,QString txt);
	void setTabData(int index,QString txt);
	int count() const;
	void clear();	

public slots:	
	void removeTab(int);
	void removeOtherTabs(int);
	void setCurrentIndex(int);
	void slotTabList();
  
private slots:	
	void slotContextMenu(const QPoint&);
	void currentTabChanged(int index);
	void tabMoved(int from,int to);

signals:
    	void currentIndexChanged(int);
	void newTabRequested(bool);
	void iconDropped(int,QDropEvent*);
	
protected:
	virtual MvQContextItemSet* cmSet()=0;
	virtual void tabBarCommand(QString,int)=0;
	virtual QString folderPath(int)=0;
	
	void checkDropTarget(QDropEvent *event);
	void removeDropTarget();
 	void dragEnterEvent(QDragEnterEvent *event);
	void dragMoveEvent(QDragMoveEvent *event);
	void dragLeaveEvent(QDragLeaveEvent *event);
	void dropEvent(QDropEvent *event);
	void paintEvent(QPaintEvent *);
 
private:		
	QTabBar *bar_;
	QStackedWidget *stacked_;
	QToolButton* addTb_;
	QToolButton* tabListTb_;
};	

class MvQFolderPanel : public MvQTabWidget
{
    Q_OBJECT

public:
	MvQFolderPanel(QWidget* parent=0);
	~MvQFolderPanel();
	
	Folder* currentFolder();
	QString currentFolderName();
	QList<Folder*> currentFolders();
	void setHistoryMenu(QMenu*);
	void setViewMode(Desktop::FolderViewMode);
	Desktop::FolderViewMode viewMode();
	bool viewModeGrid();
	void setIconSize(int);
	int  iconSize();
	void forceIconSize(int);
	MvQFolderNavigation* folderNavigation();
	void saveFolderInfo();
	MvQFolderWidget* addWidget(QString);
	void resetWidgets(QStringList);
	void addIconAction(QAction*);
	void addDesktopAction(QAction*);
	bool showIcon(IconObject*,bool addFolder);
	
	void writeSettings(QSettings &);
	void readSettings(QSettings &);

public slots:
	void slotCurrentWidgetChanged(int);
	void slotChFolderBack();	
	void slotChFolderForward();
	void slotChFolderParent();
	void slotChFolderMvHome();
	void slotChFolderWastebasket();
	void slotChFolderFromHistory(QString);
	void slotChFolderFromBookmarks(QString);
	void slotChFolderFromBreadcrumbs(QString);
	void slotIconCommand(QString,IconObjectH);
	void slotPathCommand(QString,QString);
	void slotDesktopCommand(QString,QPoint);
	void slotGridByName(bool);
	void slotGridBySize(bool);
	void slotGridByType(bool);
	void slotReload(bool);
	void slotPathChanged();
	void slotShowLastCreated(bool);
	void slotNewTab(bool);
	void slotNewWindow(bool);
	void slotIconDroppedToTab(int,QDropEvent*);
	void slotShowIconInCurrent(IconObject*);
	void slotFindIcons(FolderSearchData*);
	void slotIconCommandFromMain(QAction* ac);

signals:
	void itemInfoChanged(QString);
	void pathChanged();
	void currentWidgetChanged();
  
protected:
	MvQContextItemSet* cmSet();
	MvQFolderWidget* currentFolderWidget();
	MvQFolderWidget* folderWidget(int);
	QString folderPath(int);
	void tabBarCommand(QString, int);

        QString   mvHomePath_;
	
	MvQFolderHistory* folderHistory_;
	MvQActionList iconActions_;
	MvQActionList desktopActions_;

};

#endif
