/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQGuiItem_H
#define MvQGuiItem_H

#include <QMap>
#include <QObject>
#include <QStringList>

class QCheckBox;
class QComboBox;
class QHBoxLayout;
class QGridLayout;
class QLabel;
class QGridLayout;
class QLineEdit;
class QListWidget;
class QListWidgetItem;
class QRadioButton;
class QSlider;
class QTextEdit;
class QToolButton;
class QVBoxLayout;

class MvRequest;

class MvQGuiItem
{
public:
	virtual ~MvQGuiItem();
	QString name() {return name_;}
	//QString keyName() {return keyName_;}
	//QString id() {return id_;}
	//QString type() {return type_;}
	QString source() {return source_;}
		
	//void setName(QString s) {name_=s;}
	//void setKeyName(QString s) {keyName_=s;}
	//void setId(QString s) {id_=s;}
	//void setType(QString s) {type_=s;}
	//void setSource(QString s) {source_=s;}

	virtual QString currentValue()=0;
	virtual void addValue(QString)=0;

protected:
	MvQGuiItem(MvRequest*,QGridLayout*);
	
	QToolButton* defaultTb_;
	QLabel* nameLabel_;

	QString name_;
	QString source_;
	
	int row_;
	
	enum ColumnPos {DefaultColumn=0,NameColumn=1,ExpandColumn=2,WidgetColumn=3};
};


class MvQComboBoxGuiItem : public MvQGuiItem
{
public:
	MvQComboBoxGuiItem(MvRequest*,QGridLayout*);
	~MvQComboBoxGuiItem();
	QString currentValue();
	void addValue(QString);

private:
	QComboBox* combo_; 
};

class MvQCheckBoxGuiItem : public MvQGuiItem
{
public:
	MvQCheckBoxGuiItem(MvRequest*,QGridLayout*);
	~MvQCheckBoxGuiItem();
	QString currentValue();
	void addValue(QString) {};

private:
	QCheckBox* checkBox_; 
	QMap<QString,Qt::CheckState> values_;
	QString default_;
};


class MvQOnOffGuiItem : public MvQGuiItem
{
public:
	MvQOnOffGuiItem(MvRequest*,QGridLayout*);
	~MvQOnOffGuiItem();
	QString currentValue();
	void addValue(QString) {};

private:
	QMap<QString,QRadioButton*> radio_; 
	QString default_;
	QHBoxLayout *layout_;
};


class MvQListGuiItem : public QObject, public MvQGuiItem
{
	Q_OBJECT
public:
	MvQListGuiItem(MvRequest*,QGridLayout*);
	~MvQListGuiItem();
	QString currentValue();
	void addValue(QString);

public slots:
	void slotSetVisibleList(bool);
	void slotListItemChanged(QListWidgetItem*);

private:
	QLineEdit* lineEdit_; 
	QStringList values_;
	QString default_;
	QListWidget* list_; 
};

class MvQColourGuiItem :  public QObject, public MvQGuiItem
{
	Q_OBJECT

public:
	MvQColourGuiItem(MvRequest*,QGridLayout*);
	~MvQColourGuiItem();
	QString currentValue();
	void addValue(QString) {};

public slots:
	void slotLoadColourDialog(bool);
	
private:
	QComboBox*   combo_; 
	QStringList values_;
	QString default_; 
};


class MvQLineEditGuiItem : public MvQGuiItem
{
public:
	enum InputType {Text,Integer,Float,Point,Line,Area,List};

	MvQLineEditGuiItem(MvRequest*,QGridLayout*,MvQLineEditGuiItem::InputType);
	~MvQLineEditGuiItem();
	QString currentValue();
	void addValue(QString) {};

private:
	QLabel*	   label_;
	QLineEdit* lineEdit_; 
	QStringList values_;
	QString default_; 
	InputType type_;
};

class MvQTextEditGuiItem : public MvQGuiItem
{
public:
	MvQTextEditGuiItem(MvRequest*,QGridLayout*);
	~MvQTextEditGuiItem();
	QString currentValue();
	void addValue(QString) {};

private:
	QLabel*	   label_;
	QTextEdit* textEdit_; 
	QStringList values_;
	QString default_; 
};

class MvQSliderGuiItem : public QObject, public MvQGuiItem
{
	Q_OBJECT

public:
	MvQSliderGuiItem(MvRequest*,QGridLayout*);
	~MvQSliderGuiItem();
	QString currentValue();
	void addValue(QString) {};

public slots:
	void slotSetValueLabel(int);

private:
	QLabel*	   label_;
	QSlider*   slider_;
	QLabel*    valueLabel_; 
	QStringList values_;
	QString default_; 
	QHBoxLayout* layout_;
};

class MvQGuiItemFactory
{
public:	
	MvQGuiItemFactory() {};
	//static MvQGuiItem*  makeItem(QString,QString,QGridLayout*);
	static MvQGuiItem*  makeItem(MvRequest*,QGridLayout*);
};

#endif
