/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQKeyDialog_H
#define MvQKeyDialog_H

#include <QDialog>

#include "MvQConfigDialog.h"
#include "MvQKeyManager.h"

class QComboBox;
class QGridLayout;
class QLabel;
class QLineEdit;
class QListWidget;
class QModelIndex;
class QPushButton;
class QToolButton;
class QTreeView;

class MvQKeyModel;
class MvQTreeView;

class MvKey;
class MvKeyProfile;

class MvQKeyProfileDialog : public QWidget
{
Q_OBJECT

public:
	MvQKeyProfileDialog(QString title,MvQKeyManager*,int,QWidget *parent=0);
	virtual ~MvQKeyProfileDialog() {};

public slots:
	void slotUpdate();
	void slotSelectProfile(int);
	void slotAddProfile();
	void slotRenameProfile();
	void slotDeleteProfile();
	void slotDuplicateProfile();	

signals:
	void dataChanged();
	void currentProfileChanged(int);

protected:
	void init(int);	

	QListWidget*	profList_;
	MvQKeyManager*	manager_;
	QPushButton*    deletePb_;
	QPushButton*    renamePb_;
};

class MvQKeyListPage : public QWidget
{
Q_OBJECT

public:
	MvQKeyListPage(QString title,MvQKeyManager *,QList<MvKeyProfile *>,QWidget *parent=0);
	virtual ~MvQKeyListPage() {};
	void init();
	void setAllKeyList(QList<MvKeyProfile*>);

public slots:
	void slotProfilesChanged();
	void slotChangeCurrentProfile(int);
	void slotSelectProfile(int);
	void slotAddKey();
	void slotDeleteKey();
	void slotMoveUpKey();
	void slotMoveDownKey();
	void slotEditKey();
	void slotEditTree(const QModelIndex&);
	void slotAddKeyToProf();
	void slotSelectAllKeyGroup(int);

protected:
	void resizeKeyTreeColumns();
	
	QTreeView   *keyTree_;	
	MvQKeyModel *keyModel_;	

	MvQKeyManager  *manager_;

	QWidget *allKeyWidget_;
	QList<MvKeyProfile *> allKey_;
	MvQKeyModel *allKeyModel_;
	QTreeView *allKeyTree_;
	QComboBox *allKeyCombo_; 

	QComboBox *profCombo_; 

	QToolButton*	addKeyTb_;
	QToolButton*	deleteKeyTb_;
	QToolButton*	moveUpKeyTb_;
	QToolButton*	moveDownKeyTb_;
	QToolButton*	addKeyToProfTb_;
	QToolButton*	editKeyTb_;
};

class MvQKeyEditDialog : public QDialog
{
Q_OBJECT

public:
	MvQKeyEditDialog(MvKey *,QWidget *parent=0);
	~MvQKeyEditDialog();
	
public slots:
	void accept();
	void reject();

protected:
	MvKey *key_;	
	QLineEdit*	nameLe_;
	QLineEdit*	shortLe_;
	QLineEdit*	descLe_;
	QMap<string,QLineEdit*> metaLe_;
	//QComboBox*  colourCb_;
};


class MvQKeyImportPage : public QWidget
{
Q_OBJECT

public:
	MvQKeyImportPage(QString title,MvQKeyManager*,QWidget *parent=0);
	virtual ~MvQKeyImportPage();

public slots:
	void slotSelectAll();
	void slotUnselectAll();
	void slotImport();

signals:
	void dataChanged();

protected:
	void init();	

	QListWidget*	profList_;
	MvQKeyManager*	manager_;
	MvQKeyManager*	inManager_;
};


class MvQKeyDialog : public MvQConfigDialog
{
Q_OBJECT

public:
	MvQKeyDialog(QString title,MvQKeyManager::KeyType,
                     MvQKeyManager *,int,QList<MvKeyProfile *>,QWidget *parent=0);
	virtual ~MvQKeyDialog();

public slots:
	void accept();
	void reject();

protected:
	void writeSettings();
	void readSettings();

	MvQKeyManager  *manager_;
};


#endif
