/*
  Copyright (C) 2008 André Gaul, Jan Friederich, Steffen Basting, Kai Hertel

        This file is part of mmpong.

        mmpong is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        mmpong is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __RENDERER_H__
#define __RENDERER_H__


#include <SDL.h>
#ifndef GL_GLEXT_VERSION
# include <SDL_opengl.h>
#endif
#include "game.h"

class Renderer {
	private:
		SDL_Surface *surface;
		int win_w, win_h, full_w, full_h;
		bool full;
		bool sexy;
		int video_flags;
		GLfloat field_width;
		GLuint box_list, cylinder_list, ball_list;
		GLuint score_texture, field_texture;
		
		void init_graphics();
		void draw_digit(uint16_t digit, float size);
		void draw_field();
		void draw_paddle(float mean, float size, uint16_t team, uint16_t mode, uint16_t profile);
		void draw_players(uint16_t team, uint16_t number);
		void draw_score(uint16_t team, uint16_t score);
		void draw_variance(float mean, float var, uint16_t team);
		void resize();

	public:
		Renderer(int _win_w, int _win_h, bool _full, bool _sexy, const std::string &respath, const std::string &title="Title");
		~Renderer();

		void set_winsize(int _win_w, int _win_h) {
			win_w = _win_w;
			win_h = _win_h;
			resize();
		};
		void set_full(bool _full) {
			full = _full;
			resize();
		};
		bool get_full() { return full; };
		void render();
		void render(Game &game, float pos);
		int get_width() { return full ? full_w : win_w; };
		int get_height() { return full ? full_h : win_h; };
};


#endif
