//
// ccsdtq_t3.cc
//
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki.toru@gmail.com>
// Maintainer: TS
//
// This file is part of the SC Toolkit.
//
// The SC Toolkit is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// The SC Toolkit is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the SC Toolkit; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The U.S. Government is granted a limited license as per AL 91-7.
//
  
// This is a C++ code generated by SMITH
  
#include <algorithm>
#include <chemistry/qc/ccr12/ccsdtq_t3.h>
#include <chemistry/qc/ccr12/tensor.h>
using namespace sc;
  
  
CCSDTQ_T3::CCSDTQ_T3(CCR12_Info* info):z(info){};
CCSDTQ_T3::~CCSDTQ_T3(){};
  
  
  
void CCSDTQ_T3::compute_amp(Ref<Tensor>& out){ //k_i0_offset,z->f1(),z->in.at(0),z->t1(),z->t2(),z->t3(),z->t4()=>z->v2()
  
in.resize(8);
  
in.at(1)=new Tensor("ccsdtq_t3_1_0",z->mem());
offset_smith_0_1();
smith_0_1_0(); //z->f1()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t3_2_0",z->mem());
offset_smith_1_3();
smith_1_3_0(); //z->f1()=>in.at(2)
smith_2_34(); //z->t1(),z->v2()=>in.at(2)
smith_1_3(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_20(); //z->t1(),z->v2()=>in.at(1)
smith_1_47(); //z->t2(),z->v2()=>in.at(1)
smith_0_1(out); //z->t3(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_1",z->mem());
offset_smith_0_2();
smith_0_2_0(); //z->f1()=>in.at(1)
smith_1_22(); //z->t1(),z->v2()=>in.at(1)
smith_1_49(); //z->t2(),z->v2()=>in.at(1)
smith_0_2(out); //z->t3(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_2",z->mem());
offset_smith_0_4();
in.at(2)=new Tensor("ccsdtq_t3_2_0",z->mem());
offset_smith_1_4();
smith_1_4_0(); //z->f1()=>in.at(2)
smith_2_36(); //z->t1(),z->v2()=>in.at(2)
smith_1_4(); //z->t3(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t3_2_1",z->mem());
offset_smith_1_11();
smith_1_11_0(); //z->v2()=>in.at(2)
smith_2_19(); //z->t1(),z->v2()=>in.at(2)
smith_2_41(); //z->t2(),z->v2()=>in.at(2)
smith_1_11(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t3_2_2",z->mem());
offset_smith_1_18();
in.at(3)=new Tensor("ccsdtq_t3_3_0",z->mem());
offset_smith_2_18();
smith_2_18_0(); //z->v2()=>in.at(3)
smith_3_33(); //z->t1(),z->v2()=>in.at(3)
smith_2_18(); //z->t2(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_38(); //z->t3(),z->v2()=>in.at(2)
smith_1_18(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t3_2_3",z->mem());
offset_smith_1_23();
smith_1_23_0(); //z->v2()=>in.at(2)
smith_2_37(); //z->t1(),z->v2()=>in.at(2)
smith_1_23(); //z->t3(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_25(); //z->t3(),z->v2()=>in.at(1)
smith_1_46(); //z->t4(),z->v2()=>in.at(1)
smith_0_4(out); //z->t1(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_3",z->mem());
offset_smith_0_5();
smith_0_5_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t3_2_0",z->mem());
offset_smith_1_5();
smith_1_5_0(); //z->f1()=>in.at(2)
smith_2_40(); //z->t1(),z->v2()=>in.at(2)
smith_1_5(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t3_2_1",z->mem());
offset_smith_1_9();
smith_1_9_0(); //z->v2()=>in.at(2)
in.at(3)=new Tensor("ccsdtq_t3_3_0",z->mem());
offset_smith_2_16();
smith_2_16_0(); //z->v2()=>in.at(3)
smith_3_32(); //z->t1(),z->v2()=>in.at(3)
smith_2_16(); //z->t1(),in.at(3)=>in.at(2)
delete in.at(3);
smith_2_43(); //z->t2(),z->v2()=>in.at(2)
smith_1_9(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t3_2_2",z->mem());
offset_smith_1_10();
smith_1_10_0(); //z->v2()=>in.at(2)
smith_2_17(); //z->t1(),z->v2()=>in.at(2)
smith_1_10(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
in.at(2)=new Tensor("ccsdtq_t3_2_3",z->mem());
offset_smith_1_27();
smith_1_27_0(); //z->v2()=>in.at(2)
smith_2_42(); //z->t1(),z->v2()=>in.at(2)
smith_1_27(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_29(); //z->t2(),z->v2()=>in.at(1)
smith_1_53(); //z->t3(),z->v2()=>in.at(1)
smith_0_5(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_4",z->mem());
offset_smith_0_6();
smith_0_6_0(); //z->f1()=>in.at(1)
smith_1_44(); //z->t1(),z->v2()=>in.at(1)
smith_0_6(out); //z->t4(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_5",z->mem());
offset_smith_0_8();
smith_0_8_0(); //z->v2()=>in.at(1)
smith_1_12(); //z->t1(),z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t3_2_0",z->mem());
offset_smith_1_26();
smith_1_26_0(); //z->v2()=>in.at(2)
smith_2_39(); //z->t1(),z->v2()=>in.at(2)
smith_1_26(); //z->t2(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_28(); //z->t2(),z->v2()=>in.at(1)
smith_1_51(); //z->t3(),z->v2()=>in.at(1)
smith_0_8(out); //z->t2(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_6",z->mem());
offset_smith_0_13();
smith_0_13_0(); //z->v2()=>in.at(1)
in.at(2)=new Tensor("ccsdtq_t3_2_0",z->mem());
offset_smith_1_21();
smith_1_21_0(); //z->v2()=>in.at(2)
smith_2_35(); //z->t1(),z->v2()=>in.at(2)
smith_1_21(); //z->t1(),in.at(2)=>in.at(1)
delete in.at(2);
smith_1_48(); //z->t2(),z->v2()=>in.at(1)
smith_0_13(out); //z->t3(),in.at(1)=>out
delete in.at(1);
in.at(1)=new Tensor("ccsdtq_t3_1_7",z->mem());
offset_smith_0_14();
smith_0_14_0(); //z->v2()=>in.at(1)
smith_1_24(); //z->t1(),z->v2()=>in.at(1)
smith_1_50(); //z->t2(),z->v2()=>in.at(1)
smith_0_14(out); //z->t3(),in.at(1)=>out
delete in.at(1);
smith_0_15(out); //z->t3(),z->v2()=>out
in.at(1)=new Tensor("ccsdtq_t3_1_8",z->mem());
offset_smith_0_30();
smith_0_30_0(); //z->v2()=>in.at(1)
smith_1_45(); //z->t1(),z->v2()=>in.at(1)
smith_0_30(out); //z->t4(),in.at(1)=>out
delete in.at(1);
smith_0_31(out); //z->t4(),z->v2()=>out
in.at(1)=new Tensor("ccsdtq_t3_1_52",z->mem());
offset_smith_0_52();
smith_1_52(); //z->t3(),z->v2()=>in.at(1)
smith_0_52(out); //z->t2(),in.at(1)=>out
delete in.at(1);
  
}
  
void CCSDTQ_T3::smith_0_1(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_f())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h7b=0L;h7b<z->noab();++h7b) { 
           if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h7b)) { 
            if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h7b))))))==z->irrep_t()) { 
             long p4b_0,p5b_0,p6b_0,h1b_0,h2b_0,h7b_0; 
             z->restricted_6(p4b,p5b,p6b,h1b,h2b,h7b,p4b_0,p5b_0,p6b_0,h1b_0,h2b_0,h7b_0); 
             long h7b_1,h3b_1; 
             z->restricted_2(h7b,h3b,h7b_1,h3b_1); 
             long dim_common=z->get_range(h7b); 
             long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             if (h2b<h7b) { 
              z->t3()->get_block(h7b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h7b),4,3,2,1,0,5,+1.0); 
             } 
             else if (h1b<h7b && h7b<=h2b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h7b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h7b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
             } 
             else if (h7b<=h1b) { 
              z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
             } 
             in[1]->get_block(h3b_1+z->noab()*(h7b_1),k_a1); 
             z->sort_indices2(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h3b),1,0,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,1,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,0,1,-1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,0,2,1,+1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_13(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=0L;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (h1b<h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (h2b<=h1b && h1b<h3b) { 
       tileoffset=(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (h3b<=h1b) { 
       tileoffset=(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h7b=0L;h7b<z->noab();++h7b) { 
           for (long h8b=h7b;h8b<z->noab();++h8b) { 
            if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h7b)+z->get_spin(h8b)) { 
             if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h7b)^z->get_sym(h8b))))))==z->irrep_t()) { 
              long p4b_0,p5b_0,p6b_0,h1b_0,h7b_0,h8b_0; 
              z->restricted_6(p4b,p5b,p6b,h1b,h7b,h8b,p4b_0,p5b_0,p6b_0,h1b_0,h7b_0,h8b_0); 
              long h7b_1,h8b_1,h2b_1,h3b_1; 
              z->restricted_4(h7b,h8b,h2b,h3b,h7b_1,h8b_1,h2b_1,h3b_1); 
              long dim_common=z->get_range(h7b)*z->get_range(h8b); 
              long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h2b)*z->get_range(h3b); 
              long dima1=dim_common*dima1_sort; 
              if (h1b<h7b) { 
               z->t3()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h7b),z->get_range(h8b),3,2,1,0,5,4,+1.0); 
              } 
              else if (h7b<=h1b && h1b<h8b) { 
               z->t3()->get_block(h8b_0+z->noab()*(h1b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h1b),z->get_range(h8b),4,2,1,0,5,3,-1.0); 
              } 
              else if (h8b<=h1b) { 
               z->t3()->get_block(h1b_0+z->noab()*(h8b_0+z->noab()*(h7b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h7b),z->get_range(h8b),z->get_range(h1b),5,2,1,0,4,3,+1.0); 
              } 
              in[1]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
              double factor=1.0; 
              if (h7b==h8b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (h2b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,1,0,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (h3b>=h1b && h1b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,1,2,0,-0.5/0.5); 
           out->add_block(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,1,0,2,+0.5/0.5); 
           out->add_block(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_13_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h8b_0,h2b_0,h3b_0; 
        z->restricted_4(h7b,h8b,h2b,h3b,h7b_0,h8b_0,h2b_0,h3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h3b_0+(z->nab())*(h2b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_13(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
       in[1]->input_offset(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_14(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<p6b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<p6b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h8b=0L;h8b<z->noab();++h8b) { 
           for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
            if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h8b)) { 
             if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h8b))))))==z->irrep_t()) { 
              long p4b_0,p5b_0,p7b_0,h1b_0,h2b_0,h8b_0; 
              z->restricted_6(p4b,p5b,p7b,h1b,h2b,h8b,p4b_0,p5b_0,p7b_0,h1b_0,h2b_0,h8b_0); 
              long h8b_1,p6b_1,h3b_1,p7b_1; 
              z->restricted_4(h8b,p6b,h3b,p7b,h8b_1,p6b_1,h3b_1,p7b_1); 
              long dim_common=z->get_range(h8b)*z->get_range(p7b); 
              long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(p6b)*z->get_range(h3b); 
              long dima1=dim_common*dima1_sort; 
              if (p5b<p7b && h2b<h8b) { 
               z->t3()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),4,3,1,0,2,5,+1.0); 
              } 
              else if (p5b<p7b && h1b<h8b && h8b<=h2b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),5,3,1,0,2,4,-1.0); 
              } 
              else if (p5b<p7b && h8b<=h1b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),5,4,1,0,2,3,+1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h2b<h8b) { 
               z->t3()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),4,3,2,0,1,5,-1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h1b<h8b && h8b<=h2b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),5,3,2,0,1,4,+1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h8b<=h1b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),5,4,2,0,1,3,-1.0); 
              } 
              else if (p7b<=p4b && h2b<h8b) { 
               z->t3()->get_block(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),4,3,2,1,0,5,+1.0); 
              } 
              else if (p7b<=p4b && h1b<h8b && h8b<=h2b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
              } 
              else if (p7b<=p4b && h8b<=h1b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
              } 
              in[1]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h8b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),2,1,3,0,+1.0); 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (p6b>=p5b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,1,3,2,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p5b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,1,3,0,2,-1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p5b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,1,0,3,2,+1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,1,4,3,2,0,-1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,1,4,3,0,2,+1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,1,4,0,3,2,-1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),1,5,4,3,2,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),1,5,4,3,0,2,-1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),1,5,4,0,3,2,+1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_14_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h8b_0,p6b_0,h3b_0,p7b_0; 
        z->restricted_4(h8b,p6b,h3b,p7b,h8b_0,p6b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(h8b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h8b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_14(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[1]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),size); 
       size+=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_15(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p4b<p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<=p4b && p4b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p6b<=p4b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
           for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
            if (z->get_spin(p4b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
             if ((z->get_sym(p4b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
              long p4b_0,p7b_0,p8b_0,h1b_0,h2b_0,h3b_0; 
              z->restricted_6(p4b,p7b,p8b,h1b,h2b,h3b,p4b_0,p7b_0,p8b_0,h1b_0,h2b_0,h3b_0); 
              long p5b_1,p6b_1,p7b_1,p8b_1; 
              z->restricted_4(p5b,p6b,p7b,p8b,p5b_1,p6b_1,p7b_1,p8b_1); 
              long dim_common=z->get_range(p7b)*z->get_range(p8b); 
              long dima0_sort=z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(p5b)*z->get_range(p6b); 
              long dima1=dim_common*dima1_sort; 
              if (p4b<p7b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p7b<=p4b && p4b<p8b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p8b<=p4b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p7b==p8b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (p5b>=p4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,1,0,4,3,2,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p4b && p4b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),1,5,0,4,3,2,-0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),1,0,5,4,3,2,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_1_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h7b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^z->get_sym(h3b))==z->irrep_f()) { 
      long dimc=z->get_range(h7b)*z->get_range(h3b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h7b_0,h3b_0; 
      z->restricted_2(h7b,h3b,h7b_0,h3b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h7b)*z->get_range(h3b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(h3b_0+(z->nab())*(h7b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h3b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h3b),0,1,-1.0); 
      in[1]->add_block(h3b+z->noab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_1(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  if (z->get_spin(h7b)==z->get_spin(h3b)) { 
   if ((z->get_sym(h7b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_f())) { 
    if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h3b)!=4L) { 
     in[1]->input_offset(h3b+z->noab()*(h7b),size); 
     size+=z->get_range(h7b)*z->get_range(h3b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_2(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p6b<=p4b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_f())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
           if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
            if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
             long p4b_0,p5b_0,p7b_0,h1b_0,h2b_0,h3b_0; 
             z->restricted_6(p4b,p5b,p7b,h1b,h2b,h3b,p4b_0,p5b_0,p7b_0,h1b_0,h2b_0,h3b_0); 
             long p6b_1,p7b_1; 
             z->restricted_2(p6b,p7b,p6b_1,p7b_1); 
             long dim_common=z->get_range(p7b); 
             long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p6b); 
             long dima1=dim_common*dima1_sort; 
             if (p5b<p7b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,0,2,+1.0); 
             } 
             else if (p4b<p7b && p7b<=p5b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,0,1,-1.0); 
             } 
             else if (p7b<=p4b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
             } 
             in[1]->get_block(p7b_1-z->noab()+z->nvab()*(p6b_1-z->noab()),k_a1); 
             z->sort_indices2(k_a1,k_a1_sort,z->get_range(p6b),z->get_range(p7b),0,1,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p6b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,0,3,2,1,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,0,4,3,2,1,-1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),0,5,4,3,2,1,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_2_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  long tileoffset; 
  tileoffset=(p7b-z->noab()+z->nvab()*(p6b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)!=4L) { 
    if (z->get_spin(p6b)==z->get_spin(p7b)) { 
     if ((z->get_sym(p6b)^z->get_sym(p7b))==z->irrep_f()) { 
      long dimc=z->get_range(p6b)*z->get_range(p7b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long p6b_0,p7b_0; 
      z->restricted_2(p6b,p7b,p6b_0,p7b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(p6b)*z->get_range(p7b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p7b_0+(z->nab())*(p6b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p7b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(p6b),z->get_range(p7b),0,1,+1.0); 
      in[1]->add_block(p7b-z->noab()+z->nvab()*(p6b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_2(){ 
 
long size=0L; 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  if (z->get_spin(p6b)==z->get_spin(p7b)) { 
   if ((z->get_sym(p6b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)!=4L) { 
     in[1]->input_offset(p7b-z->noab()+z->nvab()*(p6b-z->noab()),size); 
     size+=z->get_range(p6b)*z->get_range(p7b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_30(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h8b=0L;h8b<z->noab();++h8b) { 
           for (long h9b=h8b;h9b<z->noab();++h9b) { 
            for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
             if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h8b)+z->get_spin(h9b)) { 
              if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h8b)^z->get_sym(h9b))))))))==z->irrep_t()) { 
               long p4b_0,p5b_0,p6b_0,p7b_0,h1b_0,h2b_0,h8b_0,h9b_0; 
               z->restricted_8(p4b,p5b,p6b,p7b,h1b,h2b,h8b,h9b,p4b_0,p5b_0,p6b_0,p7b_0,h1b_0,h2b_0,h8b_0,h9b_0); 
               long h8b_1,h9b_1,h3b_1,p7b_1; 
               z->restricted_4(h8b,h9b,h3b,p7b,h8b_1,h9b_1,h3b_1,p7b_1); 
               long dim_common=z->get_range(h8b)*z->get_range(h9b)*z->get_range(p7b); 
               long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h3b); 
               long dima1=dim_common*dima1_sort; 
               if (p6b<p7b && h2b<h8b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h9b),5,4,2,1,0,3,7,6,+1.0); 
               } 
               else if (p6b<p7b && h1b<h8b && h8b<=h2b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h9b),6,4,2,1,0,3,7,5,-1.0); 
               } 
               else if (p6b<p7b && h1b<h8b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h8b),z->get_range(h9b),z->get_range(h2b),7,4,2,1,0,3,6,5,+1.0); 
               } 
               else if (p6b<p7b && h8b<=h1b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),6,5,2,1,0,3,7,4,+1.0); 
               } 
               else if (p6b<p7b && h8b<=h1b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),7,5,2,1,0,3,6,4,-1.0); 
               } 
               else if (p6b<p7b && h9b<=h1b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),7,6,2,1,0,3,5,4,+1.0); 
               } 
               else if (p5b<p7b && p7b<=p6b && h2b<h8b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h9b),5,4,3,1,0,2,7,6,-1.0); 
               } 
               else if (p5b<p7b && p7b<=p6b && h1b<h8b && h8b<=h2b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h9b),6,4,3,1,0,2,7,5,+1.0); 
               } 
               else if (p5b<p7b && p7b<=p6b && h1b<h8b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h9b),z->get_range(h2b),7,4,3,1,0,2,6,5,-1.0); 
               } 
               else if (p5b<p7b && p7b<=p6b && h8b<=h1b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),6,5,3,1,0,2,7,4,-1.0); 
               } 
               else if (p5b<p7b && p7b<=p6b && h8b<=h1b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),7,5,3,1,0,2,6,4,+1.0); 
               } 
               else if (p5b<p7b && p7b<=p6b && h9b<=h1b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),7,6,3,1,0,2,5,4,-1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && h2b<h8b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h9b),5,4,3,2,0,1,7,6,+1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && h1b<h8b && h8b<=h2b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h9b),6,4,3,2,0,1,7,5,-1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && h1b<h8b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h9b),z->get_range(h2b),7,4,3,2,0,1,6,5,+1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && h8b<=h1b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),6,5,3,2,0,1,7,4,+1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && h8b<=h1b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),7,5,3,2,0,1,6,4,-1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && h9b<=h1b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),7,6,3,2,0,1,5,4,+1.0); 
               } 
               else if (p7b<=p4b && h2b<h8b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h9b),5,4,3,2,1,0,7,6,-1.0); 
               } 
               else if (p7b<=p4b && h1b<h8b && h8b<=h2b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h9b),6,4,3,2,1,0,7,5,+1.0); 
               } 
               else if (p7b<=p4b && h1b<h8b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h9b),z->get_range(h2b),7,4,3,2,1,0,6,5,-1.0); 
               } 
               else if (p7b<=p4b && h8b<=h1b && h2b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),6,5,3,2,1,0,7,4,-1.0); 
               } 
               else if (p7b<=p4b && h8b<=h1b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),7,5,3,2,1,0,6,4,+1.0); 
               } 
               else if (p7b<=p4b && h9b<=h1b) { 
                z->t4()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),7,6,3,2,1,0,5,4,-1.0); 
               } 
               in[1]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h8b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),2,3,1,0,+1.0); 
               double factor=1.0; 
               if (h8b==h9b) { 
                factor=factor/2.0; 
               } 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
           } 
          } 
          if (h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,1,0,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,0,1,-0.5/0.5); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,0,2,1,+0.5/0.5); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_30_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h8b_0,h9b_0,h3b_0,p7b_0; 
        z->restricted_4(h8b,h9b,h3b,p7b,h8b_0,h9b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h8b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_30(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[1]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),size); 
       size+=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_31(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p6b<=p4b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h9b=0L;h9b<z->noab();++h9b) { 
           for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
            for (long p8b=p7b;p8b<z->noab()+z->nvab();++p8b) { 
             if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p7b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h9b)) { 
              if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p7b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h9b))))))))==z->irrep_t()) { 
               long p4b_0,p5b_0,p7b_0,p8b_0,h1b_0,h2b_0,h3b_0,h9b_0; 
               z->restricted_8(p4b,p5b,p7b,p8b,h1b,h2b,h3b,h9b,p4b_0,p5b_0,p7b_0,p8b_0,h1b_0,h2b_0,h3b_0,h9b_0); 
               long h9b_1,p6b_1,p7b_1,p8b_1; 
               z->restricted_4(h9b,p6b,p7b,p8b,h9b_1,p6b_1,p7b_1,p8b_1); 
               long dim_common=z->get_range(h9b)*z->get_range(p7b)*z->get_range(p8b); 
               long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(p6b); 
               long dima1=dim_common*dima1_sort; 
               if (p5b<p7b && h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,1,0,3,2,7,+1.0); 
               } 
               else if (p5b<p7b && h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,1,0,3,2,6,-1.0); 
               } 
               else if (p5b<p7b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,1,0,3,2,5,+1.0); 
               } 
               else if (p5b<p7b && h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,1,0,3,2,4,-1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && p5b<p8b && h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,2,0,3,1,7,-1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && p5b<p8b && h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,2,0,3,1,6,+1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && p5b<p8b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,0,3,1,5,-1.0); 
               } 
               else if (p4b<p7b && p7b<=p5b && p5b<p8b && h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,0,3,1,4,+1.0); 
               } 
               else if (p4b<p7b && p8b<=p5b && h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,3,0,2,1,7,+1.0); 
               } 
               else if (p4b<p7b && p8b<=p5b && h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,3,0,2,1,6,-1.0); 
               } 
               else if (p4b<p7b && p8b<=p5b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,0,2,1,5,+1.0); 
               } 
               else if (p4b<p7b && p8b<=p5b && h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p8b),z->get_range(p5b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,0,2,1,4,-1.0); 
               } 
               else if (p7b<=p4b && p5b<p8b && h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,2,1,3,0,7,+1.0); 
               } 
               else if (p7b<=p4b && p5b<p8b && h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,2,1,3,0,6,-1.0); 
               } 
               else if (p7b<=p4b && p5b<p8b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,1,3,0,5,+1.0); 
               } 
               else if (p7b<=p4b && p5b<p8b && h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,1,3,0,4,-1.0); 
               } 
               else if (p7b<=p4b && p4b<p8b && p8b<=p5b && h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,3,1,2,0,7,-1.0); 
               } 
               else if (p7b<=p4b && p4b<p8b && p8b<=p5b && h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,3,1,2,0,6,+1.0); 
               } 
               else if (p7b<=p4b && p4b<p8b && p8b<=p5b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,1,2,0,5,-1.0); 
               } 
               else if (p7b<=p4b && p4b<p8b && p8b<=p5b && h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p8b),z->get_range(p5b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,1,2,0,4,+1.0); 
               } 
               else if (p8b<=p4b && h3b<h9b) { 
                z->t4()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h9b),6,5,4,3,2,1,0,7,+1.0); 
               } 
               else if (p8b<=p4b && h2b<h9b && h9b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),z->get_range(h3b),7,5,4,3,2,1,0,6,-1.0); 
               } 
               else if (p8b<=p4b && h1b<h9b && h9b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,1,0,5,+1.0); 
               } 
               else if (p8b<=p4b && h9b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p8b),z->get_range(p4b),z->get_range(p5b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,1,0,4,-1.0); 
               } 
               z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),1,3,2,0,+1.0); 
               double factor=1.0; 
               if (p7b==p8b) { 
                factor=factor/2.0; 
               } 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
           } 
          } 
          if (p6b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,0,3,2,1,-0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,0,4,3,2,1,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),0,5,4,3,2,1,-0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_4(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p4b<p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<=p4b && p4b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p6b<=p4b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h7b=0L;h7b<z->noab();++h7b) { 
           if (z->get_spin(p4b)==z->get_spin(h7b)) { 
            if ((z->get_sym(p4b)^z->get_sym(h7b))==z->irrep_t()) { 
             long p4b_0,h7b_0; 
             z->restricted_2(p4b,h7b,p4b_0,h7b_0); 
             long h7b_1,p5b_1,p6b_1,h1b_1,h2b_1,h3b_1; 
             z->restricted_6(h7b,p5b,p6b,h1b,h2b,h3b,h7b_1,p5b_1,p6b_1,h1b_1,h2b_1,h3b_1); 
             long dim_common=z->get_range(h7b); 
             long dima0_sort=z->get_range(p4b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             z->t1()->get_block(h7b_0+z->noab()*(p4b_0-z->noab()),k_a0); 
             z->sort_indices2(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(h7b),0,1,+1.0); 
             in[1]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(p5b_1-z->noab()+z->nvab()*(h7b_1))))),k_a1); 
             z->sort_indices6(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p5b>=p4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,1,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p4b && p4b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),4,5,3,2,1,0,-1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),4,3,5,2,1,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_4(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_f())) { 
        if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
         in[1]->input_offset(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),size); 
         size+=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_5(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=0L;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b && h1b<h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<p6b && h2b<=h1b && h1b<h3b) { 
       tileoffset=(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<p6b && h3b<=h1b) { 
       tileoffset=(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b && h1b<h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b && h2b<=h1b && h1b<h3b) { 
       tileoffset=(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b && h3b<=h1b) { 
       tileoffset=(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h1b<h2b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h2b<=h1b && h1b<h3b) { 
       tileoffset=(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h3b<=h1b) { 
       tileoffset=(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_f()))) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h7b=0L;h7b<z->noab();++h7b) { 
           if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h1b)+z->get_spin(h7b)) { 
            if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h1b)^z->get_sym(h7b))))==z->irrep_t()) { 
             long p4b_0,p5b_0,h1b_0,h7b_0; 
             z->restricted_4(p4b,p5b,h1b,h7b,p4b_0,p5b_0,h1b_0,h7b_0); 
             long h7b_1,p6b_1,h2b_1,h3b_1; 
             z->restricted_4(h7b,p6b,h2b,h3b,h7b_1,p6b_1,h2b_1,h3b_1); 
             long dim_common=z->get_range(h7b); 
             long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(h1b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             if (h1b<h7b) { 
              z->t2()->get_block(h7b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h1b),z->get_range(h7b),2,1,0,3,+1.0); 
             } 
             else if (h7b<=h1b) { 
              z->t2()->get_block(h1b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h7b),z->get_range(h1b),3,1,0,2,-1.0); 
             } 
             in[1]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p6b>=p5b && h2b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,2,3,1,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p5b && h3b>=h1b && h1b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,2,1,3,0,-1.0); 
           out->add_block(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p5b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,4,2,1,0,3,+1.0); 
           out->add_block(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b && h2b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,2,4,3,1,0,-1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b && h3b>=h1b && h1b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,2,4,1,3,0,+1.0); 
           out->add_block(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),5,2,4,1,0,3,-1.0); 
           out->add_block(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h2b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),2,5,4,3,1,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h3b>=h1b && h1b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),2,5,4,1,3,0,-1.0); 
           out->add_block(h3b+z->noab()*(h1b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),z->get_range(h1b),z->get_range(p5b),z->get_range(p4b),2,5,4,1,0,3,+1.0); 
           out->add_block(h1b+z->noab()*(h3b+z->noab()*(h2b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_52(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p6b && p6b<=p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p6b<=p4b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h7b=0L;h7b<z->noab();++h7b) { 
           for (long h8b=h7b;h8b<z->noab();++h8b) { 
            if (z->get_spin(p4b)+z->get_spin(p5b)==z->get_spin(h7b)+z->get_spin(h8b)) { 
             if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(h7b)^z->get_sym(h8b))))==z->irrep_t()) { 
              long p4b_0,p5b_0,h7b_0,h8b_0; 
              z->restricted_4(p4b,p5b,h7b,h8b,p4b_0,p5b_0,h7b_0,h8b_0); 
              long h7b_1,h8b_1,p6b_1,h1b_1,h2b_1,h3b_1; 
              z->restricted_6(h7b,h8b,p6b,h1b,h2b,h3b,h7b_1,h8b_1,p6b_1,h1b_1,h2b_1,h3b_1); 
              long dim_common=z->get_range(h7b)*z->get_range(h8b); 
              long dima0_sort=z->get_range(p4b)*z->get_range(p5b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima1=dim_common*dima1_sort; 
              z->t2()->get_block(h8b_0+z->noab()*(h7b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(h7b),z->get_range(h8b),1,0,3,2,+1.0); 
              in[1]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h7b_1))))),k_a1); 
              z->sort_indices6(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
              double factor=1.0; 
              if (h7b==h8b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (p6b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,1,0,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p6b && p6b>=p4b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,3,4,2,1,0,-0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),3,5,4,2,1,0,+0.5/0.5); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_52(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
         in[1]->input_offset(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),size); 
         size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_5_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,p6b_0,h2b_0,h3b_0; 
        z->restricted_4(h7b,p6b,h2b,h3b,h7b_0,p6b_0,h2b_0,h3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h3b_0+(z->nab())*(h2b_0+(z->nab())*(p6b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,-1.0); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_5(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_f())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
       in[1]->input_offset(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_6(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=p4b;p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_f())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h8b=0L;h8b<z->noab();++h8b) { 
           for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
            if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h8b)) { 
             if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p7b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h8b))))))))==z->irrep_t()) { 
              long p4b_0,p5b_0,p6b_0,p7b_0,h1b_0,h2b_0,h3b_0,h8b_0; 
              z->restricted_8(p4b,p5b,p6b,p7b,h1b,h2b,h3b,h8b,p4b_0,p5b_0,p6b_0,p7b_0,h1b_0,h2b_0,h3b_0,h8b_0); 
              long h8b_1,p7b_1; 
              z->restricted_2(h8b,p7b,h8b_1,p7b_1); 
              long dim_common=z->get_range(h8b)*z->get_range(p7b); 
              long dima0_sort=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=1L; 
              long dima1=dim_common*dima1_sort; 
              if (p6b<p7b && h3b<h8b) { 
               z->t4()->get_block(h8b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h8b),6,5,4,2,1,0,3,7,+1.0); 
              } 
              else if (p6b<p7b && h2b<h8b && h8b<=h3b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h3b),7,5,4,2,1,0,3,6,-1.0); 
              } 
              else if (p6b<p7b && h1b<h8b && h8b<=h2b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,1,0,3,5,+1.0); 
              } 
              else if (p6b<p7b && h8b<=h1b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,1,0,3,4,-1.0); 
              } 
              else if (p5b<p7b && p7b<=p6b && h3b<h8b) { 
               z->t4()->get_block(h8b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h8b),6,5,4,3,1,0,2,7,-1.0); 
              } 
              else if (p5b<p7b && p7b<=p6b && h2b<h8b && h8b<=h3b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h3b),7,5,4,3,1,0,2,6,+1.0); 
              } 
              else if (p5b<p7b && p7b<=p6b && h1b<h8b && h8b<=h2b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,1,0,2,5,-1.0); 
              } 
              else if (p5b<p7b && p7b<=p6b && h8b<=h1b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p5b),z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,1,0,2,4,+1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h3b<h8b) { 
               z->t4()->get_block(h8b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h8b),6,5,4,3,2,0,1,7,+1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h2b<h8b && h8b<=h3b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h3b),7,5,4,3,2,0,1,6,-1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h1b<h8b && h8b<=h2b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,0,1,5,+1.0); 
              } 
              else if (p4b<p7b && p7b<=p5b && h8b<=h1b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,0,1,4,-1.0); 
              } 
              else if (p7b<=p4b && h3b<h8b) { 
               z->t4()->get_block(h8b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h8b),6,5,4,3,2,1,0,7,-1.0); 
              } 
              else if (p7b<=p4b && h2b<h8b && h8b<=h3b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h8b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h8b),z->get_range(h3b),7,5,4,3,2,1,0,6,+1.0); 
              } 
              else if (p7b<=p4b && h1b<h8b && h8b<=h2b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h8b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,1,0,5,-1.0); 
              } 
              else if (p7b<=p4b && h8b<=h1b) { 
               z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))))))),k_a0); 
               z->sort_indices8(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,1,0,4,+1.0); 
              } 
              in[1]->get_block(p7b_1-z->noab()+z->nvab()*(h8b_1),k_a1); 
              z->sort_indices2(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p7b),1,0,+1.0); 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),z->get_range(p4b),5,4,3,2,1,0,+1.0); 
          out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_6_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  long tileoffset; 
  tileoffset=(p7b-z->noab()+z->nvab()*(h8b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p7b)!=4L) { 
    if (z->get_spin(h8b)==z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^z->get_sym(p7b))==z->irrep_f()) { 
      long dimc=z->get_range(h8b)*z->get_range(p7b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h8b_0,p7b_0; 
      z->restricted_2(h8b,p7b,h8b_0,p7b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h8b)*z->get_range(p7b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p7b_0+(z->nab())*(h8b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(p7b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h8b),z->get_range(p7b),0,1,+1.0); 
      in[1]->add_block(p7b-z->noab()+z->nvab()*(h8b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_6(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  if (z->get_spin(h8b)==z->get_spin(p7b)) { 
   if ((z->get_sym(h8b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p7b)!=4L) { 
     in[1]->input_offset(p7b-z->noab()+z->nvab()*(h8b),size); 
     size+=z->get_range(h8b)*z->get_range(p7b); 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_8(Ref<Tensor>& out){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p4b=z->noab();p4b<z->noab()+z->nvab();++p4b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p4b<p5b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p5b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p4b<p5b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab())))))); 
      } 
      else if (p5b<=p4b && p4b<p6b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p5b<=p4b && p4b<p6b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p5b<=p4b && p4b<p6b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      else if (p6b<=p4b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))))); 
      } 
      if (out->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(p4b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(p4b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(p4b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
           if (z->get_spin(p4b)+z->get_spin(p7b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
            if ((z->get_sym(p4b)^(z->get_sym(p7b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
             long p4b_0,p7b_0,h1b_0,h2b_0; 
             z->restricted_4(p4b,p7b,h1b,h2b,p4b_0,p7b_0,h1b_0,h2b_0); 
             long p5b_1,p6b_1,h3b_1,p7b_1; 
             z->restricted_4(p5b,p6b,h3b,p7b,p5b_1,p6b_1,h3b_1,p7b_1); 
             long dim_common=z->get_range(p7b); 
             long dima0_sort=z->get_range(p4b)*z->get_range(h1b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             if (p4b<p7b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p7b_0-z->noab()+z->nvab()*(p4b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p4b),z->get_range(p7b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
             } 
             else if (p7b<=p4b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p4b_0-z->noab()+z->nvab()*(p7b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p7b),z->get_range(p4b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
             } 
             in[1]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(p5b_1-z->noab()))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),2,1,0,3,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p5b>=p4b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,2,1,4,3,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p4b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,2,1,4,0,3,-1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p5b>=p4b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),5,2,1,0,4,3,+1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(p4b-z->noab()))))),k_c); 
          } 
          if (p6b>=p4b && p4b>=p5b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,5,1,4,3,0,-1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p6b>=p4b && p4b>=p5b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,5,1,4,0,3,+1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p6b>=p4b && p4b>=p5b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,5,1,0,4,3,-1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p4b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,1,5,4,3,0,+1.0); 
           out->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,1,5,4,0,3,-1.0); 
           out->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
          if (p4b>=p6b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),z->get_range(h2b),z->get_range(h1b),z->get_range(p4b),2,1,5,0,4,3,+1.0); 
           out->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p4b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_0_8_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long p5b_0,p6b_0,h3b_0,p7b_0; 
        z->restricted_4(p5b,p6b,h3b,p7b,p5b_0,p6b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(p5b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_0_8(){ 
 
long size=0L; 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[1]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),size); 
       size+=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[1]->set_filesize(size); 
in[1]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_10(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p8b_0,h2b_0; 
           z->restricted_2(p8b,h2b,p8b_0,h2b_0); 
           long h7b_1,p6b_1,h3b_1,p8b_1; 
           z->restricted_4(h7b,p6b,h3b,p8b,h7b_1,p6b_1,h3b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h2b),1,0,+1.0); 
           in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),2,1,3,0,+1.0); 
         in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),2,1,0,3,-1.0); 
         in[1]->add_block(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_10_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,p6b_0,h3b_0,p8b_0; 
        z->restricted_4(h7b,p6b,h3b,p8b,h7b_0,p6b_0,h3b_0,p8b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p8b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_10(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
       in[2]->input_offset(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_11(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p5b<p6b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p5b<p6b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p6b<=p5b && h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p6b<=p5b && h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p6b<=p5b && h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
           if (z->get_spin(p5b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
            if ((z->get_sym(p5b)^(z->get_sym(p8b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
             long p5b_0,p8b_0,h1b_0,h2b_0; 
             z->restricted_4(p5b,p8b,h1b,h2b,p5b_0,p8b_0,h1b_0,h2b_0); 
             long h7b_1,p6b_1,h3b_1,p8b_1; 
             z->restricted_4(h7b,p6b,h3b,p8b,h7b_1,p6b_1,h3b_1,p8b_1); 
             long dim_common=z->get_range(p8b); 
             long dima0_sort=z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             if (p5b<p8b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
             } 
             else if (p8b<=p5b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
             } 
             in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),2,1,0,3,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p6b>=p5b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),2,5,1,4,3,0,+1.0); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p6b>=p5b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),2,5,1,4,0,3,-1.0); 
           in[1]->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p6b>=p5b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),2,5,1,0,4,3,+1.0); 
           in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p5b>=p6b && h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),2,1,5,4,3,0,-1.0); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p5b>=p6b && h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),2,1,5,4,0,3,+1.0); 
           in[1]->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p5b>=p6b && h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(p6b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),2,1,5,0,4,3,-1.0); 
           in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_11_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,p6b_0,h3b_0,p8b_0; 
        z->restricted_4(h7b,p6b,h3b,p8b,h7b_0,p6b_0,h3b_0,p8b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p8b_0+(z->nab())*(h3b_0+(z->nab())*(p6b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,-1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_11(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
       in[2]->input_offset(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_12(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p8b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p8b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p8b_0,h3b_0; 
           z->restricted_2(p8b,h3b,p8b_0,h3b_0); 
           long p5b_1,p6b_1,p7b_1,p8b_1; 
           z->restricted_4(p5b,p6b,p7b,p8b,p5b_1,p6b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h3b),1,0,+1.0); 
           if (p7b<p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),2,1,0,3,+1.0); 
           } 
           else if (p8b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(p5b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(p7b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(p5b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_18(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p6b<=p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^(z->irrep_t()^z->irrep_v()))) { 
          long dimc=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h8b=0L;h8b<z->noab();++h8b) { 
           if (z->get_spin(p5b)==z->get_spin(h8b)) { 
            if ((z->get_sym(p5b)^z->get_sym(h8b))==z->irrep_t()) { 
             long p5b_0,h8b_0; 
             z->restricted_2(p5b,h8b,p5b_0,h8b_0); 
             long h7b_1,h8b_1,p6b_1,h1b_1,h2b_1,h3b_1; 
             z->restricted_6(h7b,h8b,p6b,h1b,h2b,h3b,h7b_1,h8b_1,p6b_1,h1b_1,h2b_1,h3b_1); 
             long dim_common=z->get_range(h8b); 
             long dima0_sort=z->get_range(p5b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             z->t1()->get_block(h8b_0+z->noab()*(p5b_0-z->noab()),k_a0); 
             z->sort_indices2(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(h8b),0,1,+1.0); 
             if (h7b<h8b) { 
              in[2]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h8b_1+z->noab()*(h7b_1))))),k_a1); 
              z->sort_indices6(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,0,1,+1.0); 
             } 
             else if (h8b<=h7b) { 
              in[2]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h1b_1+z->noab()*(p6b_1-z->noab()+z->nvab()*(h7b_1+z->noab()*(h8b_1))))),k_a1); 
              z->sort_indices6(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h7b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,-1.0); 
             } 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (p6b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(h7b),z->get_range(p5b),4,5,3,2,1,0,+0.5); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p5b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(h7b),z->get_range(p5b),4,3,5,2,1,0,-0.5); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_18(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
        if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
         in[2]->input_offset(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),size); 
         size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_20(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h7b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(h3b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h9b=0L;h9b<z->noab();++h9b) { 
       for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
        if (z->get_spin(p8b)==z->get_spin(h9b)) { 
         if ((z->get_sym(p8b)^z->get_sym(h9b))==z->irrep_t()) { 
          long p8b_0,h9b_0; 
          z->restricted_2(p8b,h9b,p8b_0,h9b_0); 
          long h7b_1,h9b_1,h3b_1,p8b_1; 
          z->restricted_4(h7b,h9b,h3b,p8b,h7b_1,h9b_1,h3b_1,p8b_1); 
          long dim_common=z->get_range(h9b)*z->get_range(p8b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h7b)*z->get_range(h3b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h9b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h9b),0,1,+1.0); 
          if (h7b<h9b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(h3b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),2,0,3,1,+1.0); 
          } 
          else if (h9b<=h7b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(h3b_1+(z->nab())*(h7b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),z->get_range(p8b),2,1,3,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),1,0,-1.0); 
      in[1]->add_block(h3b+z->noab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_21(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p9b_0,h2b_0; 
           z->restricted_2(p9b,h2b,p9b_0,h2b_0); 
           long h7b_1,h8b_1,h3b_1,p9b_1; 
           z->restricted_4(h7b,h8b,h3b,p9b,h7b_1,h8b_1,h3b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h2b),1,0,+1.0); 
           in[2]->get_block(p9b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),2,1,3,0,+1.0); 
         in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),2,1,0,3,-1.0); 
         in[1]->add_block(h2b+z->noab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_21_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h8b_0,h3b_0,p9b_0; 
        z->restricted_4(h7b,h8b,h3b,p9b,h7b_0,h8b_0,h3b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h3b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,-1.0); 
        in[2]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_21(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
       in[2]->input_offset(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_22(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  long tileoffset; 
  tileoffset=(p7b-z->noab()+z->nvab()*(p6b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)!=4L) { 
    if (z->get_spin(p6b)==z->get_spin(p7b)) { 
     if ((z->get_sym(p6b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p6b)*z->get_range(p7b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h9b=0L;h9b<z->noab();++h9b) { 
       for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
        if (z->get_spin(p8b)==z->get_spin(h9b)) { 
         if ((z->get_sym(p8b)^z->get_sym(h9b))==z->irrep_t()) { 
          long p8b_0,h9b_0; 
          z->restricted_2(p8b,h9b,p8b_0,h9b_0); 
          long h9b_1,p6b_1,p7b_1,p8b_1; 
          z->restricted_4(h9b,p6b,p7b,p8b,h9b_1,p6b_1,p7b_1,p8b_1); 
          long dim_common=z->get_range(h9b)*z->get_range(p8b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(p6b)*z->get_range(p7b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h9b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h9b),0,1,+1.0); 
          if (p7b<p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),2,1,3,0,+1.0); 
          } 
          else if (p8b<=p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p8b),z->get_range(p7b),3,1,2,0,-1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),1,0,-1.0); 
      in[1]->add_block(p7b-z->noab()+z->nvab()*(p6b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_23(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h9b=0L;h9b<z->noab();++h9b) { 
           for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
            if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h9b)) { 
             if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h9b))))))==z->irrep_t()) { 
              long p5b_0,p6b_0,p8b_0,h1b_0,h2b_0,h9b_0; 
              z->restricted_6(p5b,p6b,p8b,h1b,h2b,h9b,p5b_0,p6b_0,p8b_0,h1b_0,h2b_0,h9b_0); 
              long h7b_1,h9b_1,h3b_1,p8b_1; 
              z->restricted_4(h7b,h9b,h3b,p8b,h7b_1,h9b_1,h3b_1,p8b_1); 
              long dim_common=z->get_range(h9b)*z->get_range(p8b); 
              long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h7b)*z->get_range(h3b); 
              long dima1=dim_common*dima1_sort; 
              if (p6b<p8b && h2b<h9b) { 
               z->t3()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),4,3,1,0,2,5,+1.0); 
              } 
              else if (p6b<p8b && h1b<h9b && h9b<=h2b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),5,3,1,0,2,4,-1.0); 
              } 
              else if (p6b<p8b && h9b<=h1b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),5,4,1,0,2,3,+1.0); 
              } 
              else if (p5b<p8b && p8b<=p6b && h2b<h9b) { 
               z->t3()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),4,3,2,0,1,5,-1.0); 
              } 
              else if (p5b<p8b && p8b<=p6b && h1b<h9b && h9b<=h2b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),5,3,2,0,1,4,+1.0); 
              } 
              else if (p5b<p8b && p8b<=p6b && h9b<=h1b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),5,4,2,0,1,3,-1.0); 
              } 
              else if (p8b<=p5b && h2b<h9b) { 
               z->t3()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h9b),4,3,2,1,0,5,+1.0); 
              } 
              else if (p8b<=p5b && h1b<h9b && h9b<=h2b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h9b),z->get_range(h2b),5,3,2,1,0,4,-1.0); 
              } 
              else if (p8b<=p5b && h9b<=h1b) { 
               z->t3()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h9b),z->get_range(h1b),z->get_range(h2b),5,4,2,1,0,3,+1.0); 
              } 
              if (h7b<h9b) { 
               in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h7b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),2,0,3,1,+1.0); 
              } 
              else if (h9b<=h7b) { 
               in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h7b_1+z->noab()*(h9b_1))),k_a1); 
               z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),z->get_range(p8b),2,1,3,0,-1.0); 
              } 
              double factor=1.0; 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),1,5,4,3,2,0,+1.0); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),1,5,4,3,0,2,-1.0); 
           in[1]->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),1,5,4,0,3,2,+1.0); 
           in[1]->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_23_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h9b_0,h3b_0,p8b_0; 
        z->restricted_4(h7b,h9b,h3b,p8b,h7b_0,h9b_0,h3b_0,p8b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p8b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,-1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_23(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
       in[2]->input_offset(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_24(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p9b_0,h3b_0; 
           z->restricted_2(p9b,h3b,p9b_0,h3b_0); 
           long h8b_1,p6b_1,p7b_1,p9b_1; 
           z->restricted_4(h8b,p6b,p7b,p9b,h8b_1,p6b_1,p7b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(p6b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h3b),1,0,+1.0); 
           if (p7b<p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(p7b),z->get_range(p9b),2,1,0,3,+1.0); 
           } 
           else if (p9b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(p6b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(p6b),z->get_range(p9b),z->get_range(p7b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(h8b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_25(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (p5b<p6b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      else if (p6b<=p5b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b)))))); 
      } 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
           for (long p9b=p8b;p9b<z->noab()+z->nvab();++p9b) { 
            if (z->get_spin(p5b)+z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
             if ((z->get_sym(p5b)^(z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
              long p5b_0,p8b_0,p9b_0,h1b_0,h2b_0,h3b_0; 
              z->restricted_6(p5b,p8b,p9b,h1b,h2b,h3b,p5b_0,p8b_0,p9b_0,h1b_0,h2b_0,h3b_0); 
              long h7b_1,p6b_1,p8b_1,p9b_1; 
              z->restricted_4(h7b,p6b,p8b,p9b,h7b_1,p6b_1,p8b_1,p9b_1); 
              long dim_common=z->get_range(p8b)*z->get_range(p9b); 
              long dima0_sort=z->get_range(p5b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h7b)*z->get_range(p6b); 
              long dima1=dim_common*dima1_sort; 
              if (p5b<p8b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p8b<=p5b && p5b<p9b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p9b<=p5b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p5b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p8b==p9b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          if (p6b>=p5b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),1,5,0,4,3,2,+0.5/0.5); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
          if (p5b>=p6b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p5b),1,0,5,4,3,2,-0.5/0.5); 
           in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()+z->nvab()*(h7b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_26(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         for (long h9b=h8b;h9b<z->noab();++h9b) { 
          if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h8b)+z->get_spin(h9b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h8b)^z->get_sym(h9b))))==z->irrep_t()) { 
            long p5b_0,p6b_0,h8b_0,h9b_0; 
            z->restricted_4(p5b,p6b,h8b,h9b,p5b_0,p6b_0,h8b_0,h9b_0); 
            long h8b_1,h9b_1,h3b_1,p7b_1; 
            z->restricted_4(h8b,h9b,h3b,p7b,h8b_1,h9b_1,h3b_1,p7b_1); 
            long dim_common=z->get_range(h8b)*z->get_range(h9b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(p6b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h3b)*z->get_range(p7b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h9b_0+z->noab()*(h8b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(h8b),z->get_range(h9b),1,0,3,2,+1.0); 
            in[2]->get_block(p7b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),3,2,1,0,+1.0); 
            double factor=1.0; 
            if (h8b==h9b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),3,2,1,0,+0.5/0.5); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_26_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==z->irrep_v()) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h8b_0,h9b_0,h3b_0,p7b_0; 
        z->restricted_4(h8b,h9b,h3b,p7b,h8b_0,h9b_0,h3b_0,p7b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p7b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h8b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h8b),z->get_range(h9b),z->get_range(h3b),z->get_range(p7b),0,1,2,3,-1.0); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_26(){ 
 
long size=0L; 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
       in[2]->input_offset(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),size); 
       size+=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_27(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h9b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h2b)^z->get_sym(h9b))))==z->irrep_t()) { 
            long p6b_0,p8b_0,h2b_0,h9b_0; 
            z->restricted_4(p6b,p8b,h2b,h9b,p6b_0,p8b_0,h2b_0,h9b_0); 
            long h7b_1,h9b_1,h3b_1,p8b_1; 
            z->restricted_4(h7b,h9b,h3b,p8b,h7b_1,h9b_1,h3b_1,p8b_1); 
            long dim_common=z->get_range(h9b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h2b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(h3b); 
            long dima1=dim_common*dima1_sort; 
            if (p6b<p8b && h2b<h9b) { 
             z->t2()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h2b),z->get_range(h9b),2,0,1,3,+1.0); 
            } 
            else if (p6b<p8b && h9b<=h2b) { 
             z->t2()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h2b),3,0,1,2,-1.0); 
            } 
            else if (p8b<=p6b && h2b<h9b) { 
             z->t2()->get_block(h9b_0+z->noab()*(h2b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h2b),z->get_range(h9b),2,1,0,3,-1.0); 
            } 
            else if (p8b<=p6b && h9b<=h2b) { 
             z->t2()->get_block(h2b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h2b),3,1,0,2,+1.0); 
            } 
            if (h7b<h9b) { 
             in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h9b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),2,0,3,1,+1.0); 
            } 
            else if (h9b<=h7b) { 
             in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h7b_1+z->noab()*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),z->get_range(p8b),2,1,3,0,-1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),1,3,2,0,+1.0); 
         in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h7b),z->get_range(h2b),z->get_range(p6b),1,3,0,2,-1.0); 
         in[1]->add_block(h2b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_27_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h9b_0,h3b_0,p8b_0; 
        z->restricted_4(h7b,h9b,h3b,p8b,h7b_0,h9b_0,h3b_0,p8b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p8b_0+(z->nab())*(h3b_0+(z->nab())*(h9b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h9b),z->get_range(h3b),z->get_range(p8b),0,1,2,3,+1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_27(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
       in[2]->input_offset(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_28(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    if (p5b<p6b) { 
     tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    } 
    else if (p6b<=p5b) { 
     tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab())))); 
    } 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          if (z->get_spin(p5b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h9b)) { 
           if ((z->get_sym(p5b)^(z->get_sym(p8b)^(z->get_sym(h3b)^z->get_sym(h9b))))==z->irrep_t()) { 
            long p5b_0,p8b_0,h3b_0,h9b_0; 
            z->restricted_4(p5b,p8b,h3b,h9b,p5b_0,p8b_0,h3b_0,h9b_0); 
            long h9b_1,p6b_1,p7b_1,p8b_1; 
            z->restricted_4(h9b,p6b,p7b,p8b,h9b_1,p6b_1,p7b_1,p8b_1); 
            long dim_common=z->get_range(h9b)*z->get_range(p8b); 
            long dima0_sort=z->get_range(p5b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(p6b)*z->get_range(p7b); 
            long dima1=dim_common*dima1_sort; 
            if (p5b<p8b && h3b<h9b) { 
             z->t2()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(h3b),z->get_range(h9b),2,0,1,3,+1.0); 
            } 
            else if (p5b<p8b && h9b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),3,0,1,2,-1.0); 
            } 
            else if (p8b<=p5b && h3b<h9b) { 
             z->t2()->get_block(h9b_0+z->noab()*(h3b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(h3b),z->get_range(h9b),2,1,0,3,-1.0); 
            } 
            else if (p8b<=p5b && h9b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h9b_0+z->noab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(h9b),z->get_range(h3b),3,1,0,2,+1.0); 
            } 
            if (p7b<p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p7b),z->get_range(p8b),2,1,3,0,+1.0); 
            } 
            else if (p8b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h9b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(p6b),z->get_range(p8b),z->get_range(p7b),3,1,2,0,-1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        if (p6b>=p5b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p5b),3,1,2,0,+1.0); 
         in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
        } 
        if (p5b>=p6b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),z->get_range(h3b),z->get_range(p5b),1,3,2,0,-1.0); 
         in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p5b-z->noab()+z->nvab()*(p6b-z->noab()))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_29(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         for (long p9b=p8b;p9b<z->noab()+z->nvab();++p9b) { 
          if (z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
           if ((z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
            long p8b_0,p9b_0,h2b_0,h3b_0; 
            z->restricted_4(p8b,p9b,h2b,h3b,p8b_0,p9b_0,h2b_0,h3b_0); 
            long h7b_1,p6b_1,p8b_1,p9b_1; 
            z->restricted_4(h7b,p6b,p8b,p9b,h7b_1,p6b_1,p8b_1,p9b_1); 
            long dim_common=z->get_range(p8b)*z->get_range(p9b); 
            long dima0_sort=z->get_range(h2b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(p6b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p8b==p9b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),1,0,3,2,-0.5/0.5); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_3(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h7b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_f())) { 
      long dimc=z->get_range(h7b)*z->get_range(h3b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
       if (z->get_spin(p8b)==z->get_spin(h3b)) { 
        if ((z->get_sym(p8b)^z->get_sym(h3b))==z->irrep_t()) { 
         long p8b_0,h3b_0; 
         z->restricted_2(p8b,h3b,p8b_0,h3b_0); 
         long h7b_1,p8b_1; 
         z->restricted_2(h7b,p8b,h7b_1,p8b_1); 
         long dim_common=z->get_range(p8b); 
         long dima0_sort=z->get_range(h3b); 
         long dima0=dim_common*dima0_sort; 
         long dima1_sort=z->get_range(h7b); 
         long dima1=dim_common*dima1_sort; 
         z->t1()->get_block(h3b_0+z->noab()*(p8b_0-z->noab()),k_a0); 
         z->sort_indices2(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(h3b),1,0,+1.0); 
         in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h7b_1),k_a1); 
         z->sort_indices2(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
         double factor=1.0; 
         z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),0,1,+1.0); 
      in[1]->add_block(h3b+z->noab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_3_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==z->irrep_f()) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h7b_0,p8b_0; 
      z->restricted_2(h7b,p8b,h7b_0,p8b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h7b)*z->get_range(p8b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p8b_0+(z->nab())*(h7b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p8b),0,1,-1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_3(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  if (z->get_spin(h7b)==z->get_spin(p8b)) { 
   if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
     in[2]->input_offset(p8b-z->noab()+z->nvab()*(h7b),size); 
     size+=z->get_range(h7b)*z->get_range(p8b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_4(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_f())) { 
          long dimc=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
           if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
            if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
             long p5b_0,p6b_0,p8b_0,h1b_0,h2b_0,h3b_0; 
             z->restricted_6(p5b,p6b,p8b,h1b,h2b,h3b,p5b_0,p6b_0,p8b_0,h1b_0,h2b_0,h3b_0); 
             long h7b_1,p8b_1; 
             z->restricted_2(h7b,p8b,h7b_1,p8b_1); 
             long dim_common=z->get_range(p8b); 
             long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h7b); 
             long dima1=dim_common*dima1_sort; 
             if (p6b<p8b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,0,2,+1.0); 
             } 
             else if (p5b<p8b && p8b<=p6b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,0,1,-1.0); 
             } 
             else if (p8b<=p5b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
             } 
             in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h7b_1),k_a1); 
             z->sort_indices2(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),0,5,4,3,2,1,+1.0); 
          in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_44(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  long tileoffset; 
  tileoffset=(p7b-z->noab()+z->nvab()*(h8b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p7b)!=4L) { 
    if (z->get_spin(h8b)==z->get_spin(p7b)) { 
     if ((z->get_sym(h8b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h8b)*z->get_range(p7b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
        if (z->get_spin(p9b)==z->get_spin(h10b)) { 
         if ((z->get_sym(p9b)^z->get_sym(h10b))==z->irrep_t()) { 
          long p9b_0,h10b_0; 
          z->restricted_2(p9b,h10b,p9b_0,h10b_0); 
          long h8b_1,h10b_1,p7b_1,p9b_1; 
          z->restricted_4(h8b,h10b,p7b,p9b,h8b_1,h10b_1,p7b_1,p9b_1); 
          long dim_common=z->get_range(h10b)*z->get_range(p9b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h8b)*z->get_range(p7b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h10b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h10b),0,1,+1.0); 
          if (h8b<h10b && p7b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(h10b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h10b),z->get_range(p7b),z->get_range(p9b),2,0,3,1,+1.0); 
          } 
          else if (h8b<h10b && p9b<=p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h8b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h10b),z->get_range(p9b),z->get_range(p7b),3,0,2,1,-1.0); 
          } 
          else if (h10b<=h8b && p7b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h8b),z->get_range(p7b),z->get_range(p9b),2,1,3,0,-1.0); 
          } 
          else if (h10b<=h8b && p9b<=p7b) { 
           z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h8b),z->get_range(p9b),z->get_range(p7b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p7b),z->get_range(h8b),1,0,+1.0); 
      in[1]->add_block(p7b-z->noab()+z->nvab()*(h8b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_45(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h8b_1,h9b_1,p7b_1,p10b_1; 
           z->restricted_4(h8b,h9b,p7b,p10b,h8b_1,h9b_1,p7b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p7b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p7b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p7b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p10b),z->get_range(p7b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h9b),z->get_range(h8b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_46(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
  for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long h10b=0L;h10b<z->noab();++h10b) { 
           for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
            for (long p9b=p8b;p9b<z->noab()+z->nvab();++p9b) { 
             if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h10b)) { 
              if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h1b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h10b))))))))==z->irrep_t()) { 
               long p5b_0,p6b_0,p8b_0,p9b_0,h1b_0,h2b_0,h3b_0,h10b_0; 
               z->restricted_8(p5b,p6b,p8b,p9b,h1b,h2b,h3b,h10b,p5b_0,p6b_0,p8b_0,p9b_0,h1b_0,h2b_0,h3b_0,h10b_0); 
               long h7b_1,h10b_1,p8b_1,p9b_1; 
               z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
               long dim_common=z->get_range(h10b)*z->get_range(p8b)*z->get_range(p9b); 
               long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
               long dima0=dim_common*dima0_sort; 
               long dima1_sort=z->get_range(h7b); 
               long dima1=dim_common*dima1_sort; 
               if (p6b<p8b && h3b<h10b) { 
                z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,1,0,3,2,7,+1.0); 
               } 
               else if (p6b<p8b && h2b<h10b && h10b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,1,0,3,2,6,-1.0); 
               } 
               else if (p6b<p8b && h1b<h10b && h10b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,1,0,3,2,5,+1.0); 
               } 
               else if (p6b<p8b && h10b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,1,0,3,2,4,-1.0); 
               } 
               else if (p5b<p8b && p8b<=p6b && p6b<p9b && h3b<h10b) { 
                z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,2,0,3,1,7,-1.0); 
               } 
               else if (p5b<p8b && p8b<=p6b && p6b<p9b && h2b<h10b && h10b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,2,0,3,1,6,+1.0); 
               } 
               else if (p5b<p8b && p8b<=p6b && p6b<p9b && h1b<h10b && h10b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,0,3,1,5,-1.0); 
               } 
               else if (p5b<p8b && p8b<=p6b && p6b<p9b && h10b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,0,3,1,4,+1.0); 
               } 
               else if (p5b<p8b && p9b<=p6b && h3b<h10b) { 
                z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,3,0,2,1,7,+1.0); 
               } 
               else if (p5b<p8b && p9b<=p6b && h2b<h10b && h10b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,3,0,2,1,6,-1.0); 
               } 
               else if (p5b<p8b && p9b<=p6b && h1b<h10b && h10b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,0,2,1,5,+1.0); 
               } 
               else if (p5b<p8b && p9b<=p6b && h10b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,0,2,1,4,-1.0); 
               } 
               else if (p8b<=p5b && p6b<p9b && h3b<h10b) { 
                z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,2,1,3,0,7,+1.0); 
               } 
               else if (p8b<=p5b && p6b<p9b && h2b<h10b && h10b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,2,1,3,0,6,-1.0); 
               } 
               else if (p8b<=p5b && p6b<p9b && h1b<h10b && h10b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,2,1,3,0,5,+1.0); 
               } 
               else if (p8b<=p5b && p6b<p9b && h10b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,2,1,3,0,4,-1.0); 
               } 
               else if (p8b<=p5b && p5b<p9b && p9b<=p6b && h3b<h10b) { 
                z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,3,1,2,0,7,-1.0); 
               } 
               else if (p8b<=p5b && p5b<p9b && p9b<=p6b && h2b<h10b && h10b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,3,1,2,0,6,+1.0); 
               } 
               else if (p8b<=p5b && p5b<p9b && p9b<=p6b && h1b<h10b && h10b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,1,2,0,5,-1.0); 
               } 
               else if (p8b<=p5b && p5b<p9b && p9b<=p6b && h10b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,1,2,0,4,+1.0); 
               } 
               else if (p9b<=p5b && h3b<h10b) { 
                z->t4()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),6,5,4,3,2,1,0,7,+1.0); 
               } 
               else if (p9b<=p5b && h2b<h10b && h10b<=h3b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),7,5,4,3,2,1,0,6,-1.0); 
               } 
               else if (p9b<=p5b && h1b<h10b && h10b<=h2b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h1b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),7,6,4,3,2,1,0,5,+1.0); 
               } 
               else if (p9b<=p5b && h10b<=h1b) { 
                z->t4()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))))),k_a0); 
                z->sort_indices8(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p5b),z->get_range(p6b),z->get_range(h10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),7,6,5,3,2,1,0,4,-1.0); 
               } 
               if (h7b<h10b) { 
                z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),0,3,2,1,+1.0); 
               } 
               else if (h10b<=h7b) { 
                z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
                z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),1,3,2,0,-1.0); 
               } 
               double factor=1.0; 
               if (p8b==p9b) { 
                factor=factor/2.0; 
               } 
               z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
              } 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),z->get_range(p5b),0,5,4,3,2,1,-0.5/0.5); 
          in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()+z->nvab()*(h7b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_47(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h3b=0L;h3b<z->noab();++h3b) { 
  long tileoffset; 
  tileoffset=(h3b+z->noab()*(h7b)); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h3b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^z->get_sym(h3b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(h3b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
        for (long p9b=p8b;p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h3b)+z->get_spin(h10b)) { 
          if ((z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h3b)^z->get_sym(h10b))))==z->irrep_t()) { 
           long p8b_0,p9b_0,h3b_0,h10b_0; 
           z->restricted_4(p8b,p9b,h3b,h10b,p8b_0,p9b_0,h3b_0,h10b_0); 
           long h7b_1,h10b_1,p8b_1,p9b_1; 
           z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
           long dim_common=z->get_range(h10b)*z->get_range(p8b)*z->get_range(p9b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b); 
           long dima1=dim_common*dima1_sort; 
           if (h3b<h10b) { 
            z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(h3b),z->get_range(h10b),2,1,0,3,+1.0); 
           } 
           else if (h10b<=h3b) { 
            z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(h10b),z->get_range(h3b),3,1,0,2,-1.0); 
           } 
           if (h7b<h10b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),0,3,2,1,+1.0); 
           } 
           else if (h10b<=h7b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),1,3,2,0,-1.0); 
           } 
           double factor=1.0; 
           if (p8b==p9b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),0,1,-0.5/0.5); 
      in[1]->add_block(h3b+z->noab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_48(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
          if (z->get_spin(p9b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
           if ((z->get_sym(p9b)^(z->get_sym(p10b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
            long p9b_0,p10b_0,h2b_0,h3b_0; 
            z->restricted_4(p9b,p10b,h2b,h3b,p9b_0,p10b_0,h2b_0,h3b_0); 
            long h7b_1,h8b_1,p9b_1,p10b_1; 
            z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
            long dim_common=z->get_range(p9b)*z->get_range(p10b); 
            long dima0_sort=z->get_range(h2b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(h8b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p9b==p10b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),1,0,3,2,+0.5/0.5); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_49(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
 for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
  long tileoffset; 
  tileoffset=(p7b-z->noab()+z->nvab()*(p6b-z->noab())); 
  if (in[1]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(p6b)+z->get_spin(p7b)!=4L) { 
    if (z->get_spin(p6b)==z->get_spin(p7b)) { 
     if ((z->get_sym(p6b)^z->get_sym(p7b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(p6b)*z->get_range(p7b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h9b=0L;h9b<z->noab();++h9b) { 
       for (long h10b=h9b;h10b<z->noab();++h10b) { 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h9b)+z->get_spin(h10b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h9b)^z->get_sym(h10b))))==z->irrep_t()) { 
           long p6b_0,p8b_0,h9b_0,h10b_0; 
           z->restricted_4(p6b,p8b,h9b,h10b,p6b_0,p8b_0,h9b_0,h10b_0); 
           long h9b_1,h10b_1,p7b_1,p8b_1; 
           z->restricted_4(h9b,h10b,p7b,p8b,h9b_1,h10b_1,p7b_1,p8b_1); 
           long dim_common=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b); 
           long dima0_sort=z->get_range(p6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           if (p6b<p8b) { 
            z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h10b),0,1,3,2,+1.0); 
           } 
           else if (p8b<=p6b) { 
            z->t2()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h10b),1,0,3,2,-1.0); 
           } 
           if (p7b<p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p7b),z->get_range(p8b),2,3,1,0,+1.0); 
           } 
           else if (p8b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,-1.0); 
           } 
           double factor=1.0; 
           if (h9b==h10b) { 
            factor=factor/2.0; 
           } 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p7b),z->get_range(p6b),1,0,-0.5/0.5); 
      in[1]->add_block(p7b-z->noab()+z->nvab()*(p6b-z->noab()),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_4_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==z->irrep_f()) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h7b_0,p8b_0; 
      z->restricted_2(h7b,p8b,h7b_0,p8b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h7b)*z->get_range(p8b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p8b_0+(z->nab())*(h7b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p8b),0,1,-1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_4(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  if (z->get_spin(h7b)==z->get_spin(p8b)) { 
   if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
     in[2]->input_offset(p8b-z->noab()+z->nvab()*(h7b),size); 
     size+=z->get_range(h7b)*z->get_range(p8b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_5(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_f())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
         if (z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
          if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
           long p6b_0,p8b_0,h2b_0,h3b_0; 
           z->restricted_4(p6b,p8b,h2b,h3b,p6b_0,p8b_0,h2b_0,h3b_0); 
           long h7b_1,p8b_1; 
           z->restricted_2(h7b,p8b,h7b_1,p8b_1); 
           long dim_common=z->get_range(p8b); 
           long dima0_sort=z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b); 
           long dima1=dim_common*dima1_sort; 
           if (p6b<p8b) { 
            z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
           } 
           else if (p8b<=p6b) { 
            z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
           } 
           in[2]->get_block(p8b_1-z->noab()+z->nvab()*(h7b_1),k_a1); 
           z->sort_indices2(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),0,3,2,1,+1.0); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_50(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
          if (z->get_spin(p6b)+z->get_spin(p9b)==z->get_spin(h3b)+z->get_spin(h10b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(h3b)^z->get_sym(h10b))))==z->irrep_t()) { 
            long p6b_0,p9b_0,h3b_0,h10b_0; 
            z->restricted_4(p6b,p9b,h3b,h10b,p6b_0,p9b_0,h3b_0,h10b_0); 
            long h8b_1,h10b_1,p7b_1,p9b_1; 
            z->restricted_4(h8b,h10b,p7b,p9b,h8b_1,h10b_1,p7b_1,p9b_1); 
            long dim_common=z->get_range(h10b)*z->get_range(p9b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h8b)*z->get_range(p7b); 
            long dima1=dim_common*dima1_sort; 
            if (p6b<p9b && h3b<h10b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h3b),z->get_range(h10b),2,0,1,3,+1.0); 
            } 
            else if (p6b<p9b && h10b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h3b),3,0,1,2,-1.0); 
            } 
            else if (p9b<=p6b && h3b<h10b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h3b),z->get_range(h10b),2,1,0,3,-1.0); 
            } 
            else if (p9b<=p6b && h10b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h3b),3,1,0,2,+1.0); 
            } 
            if (h8b<h10b && p7b<p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(h10b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h10b),z->get_range(p7b),z->get_range(p9b),2,0,3,1,+1.0); 
            } 
            else if (h8b<h10b && p9b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h8b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h10b),z->get_range(p9b),z->get_range(p7b),3,0,2,1,-1.0); 
            } 
            else if (h10b<=h8b && p7b<p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p7b_1+(z->nab())*(h8b_1+(z->nab())*(h10b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h8b),z->get_range(p7b),z->get_range(p9b),2,1,3,0,-1.0); 
            } 
            else if (h10b<=h8b && p9b<=p7b) { 
             z->v2()->get_block(p7b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h10b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h8b),z->get_range(p9b),z->get_range(p7b),3,1,2,0,+1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p6b),1,3,2,0,+1.0); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_51(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long p5b=z->noab();p5b<z->noab()+z->nvab();++p5b) { 
 for (long p6b=p5b;p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab())))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(p5b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h9b=0L;h9b<z->noab();++h9b) { 
         for (long h10b=h9b;h10b<z->noab();++h10b) { 
          for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
           if (z->get_spin(p5b)+z->get_spin(p6b)+z->get_spin(p8b)==z->get_spin(h3b)+z->get_spin(h9b)+z->get_spin(h10b)) { 
            if ((z->get_sym(p5b)^(z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(h3b)^(z->get_sym(h9b)^z->get_sym(h10b))))))==z->irrep_t()) { 
             long p5b_0,p6b_0,p8b_0,h3b_0,h9b_0,h10b_0; 
             z->restricted_6(p5b,p6b,p8b,h3b,h9b,h10b,p5b_0,p6b_0,p8b_0,h3b_0,h9b_0,h10b_0); 
             long h9b_1,h10b_1,p7b_1,p8b_1; 
             z->restricted_4(h9b,h10b,p7b,p8b,h9b_1,h10b_1,p7b_1,p8b_1); 
             long dim_common=z->get_range(h9b)*z->get_range(h10b)*z->get_range(p8b); 
             long dima0_sort=z->get_range(p5b)*z->get_range(p6b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(p7b); 
             long dima1=dim_common*dima1_sort; 
             if (p6b<p8b && h3b<h9b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(h3b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h3b),z->get_range(h9b),z->get_range(h10b),3,1,0,2,5,4,+1.0); 
             } 
             else if (p6b<p8b && h9b<=h3b && h3b<h10b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h3b),z->get_range(h10b),4,1,0,2,5,3,-1.0); 
             } 
             else if (p6b<p8b && h10b<=h3b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h9b_0+z->noab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p6b),z->get_range(p8b),z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),5,1,0,2,4,3,+1.0); 
             } 
             else if (p5b<p8b && p8b<=p6b && h3b<h9b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h3b),z->get_range(h9b),z->get_range(h10b),3,2,0,1,5,4,-1.0); 
             } 
             else if (p5b<p8b && p8b<=p6b && h9b<=h3b && h3b<h10b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h3b),z->get_range(h10b),4,2,0,1,5,3,+1.0); 
             } 
             else if (p5b<p8b && p8b<=p6b && h10b<=h3b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p5b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p5b),z->get_range(p8b),z->get_range(p6b),z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),5,2,0,1,4,3,-1.0); 
             } 
             else if (p8b<=p5b && h3b<h9b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h9b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h3b),z->get_range(h9b),z->get_range(h10b),3,2,1,0,5,4,+1.0); 
             } 
             else if (p8b<=p5b && h9b<=h3b && h3b<h10b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h9b),z->get_range(h3b),z->get_range(h10b),4,2,1,0,5,3,-1.0); 
             } 
             else if (p8b<=p5b && h10b<=h3b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h9b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p5b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p5b),z->get_range(p6b),z->get_range(h9b),z->get_range(h10b),z->get_range(h3b),5,2,1,0,4,3,+1.0); 
             } 
             if (p7b<p8b) { 
              z->v2()->get_block(p8b_1+(z->nab())*(p7b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p7b),z->get_range(p8b),2,3,1,0,+1.0); 
             } 
             else if (p8b<=p7b) { 
              z->v2()->get_block(p7b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h9b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h9b),z->get_range(h10b),z->get_range(p8b),z->get_range(p7b),3,2,1,0,-1.0); 
             } 
             double factor=1.0; 
             if (h9b==h10b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h3b),z->get_range(p6b),z->get_range(p5b),3,2,1,0,+0.5/0.5); 
        in[1]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(p5b-z->noab()))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_52(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b)))))); 
      if (in[1]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
           for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
            if (z->get_spin(p6b)+z->get_spin(p9b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
             if ((z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(p10b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
              long p6b_0,p9b_0,p10b_0,h1b_0,h2b_0,h3b_0; 
              z->restricted_6(p6b,p9b,p10b,h1b,h2b,h3b,p6b_0,p9b_0,p10b_0,h1b_0,h2b_0,h3b_0); 
              long h7b_1,h8b_1,p9b_1,p10b_1; 
              z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
              long dim_common=z->get_range(p9b)*z->get_range(p10b); 
              long dima0_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h7b)*z->get_range(h8b); 
              long dima1=dim_common*dima1_sort; 
              if (p6b<p9b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p9b<=p6b && p6b<p10b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p10b<=p6b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p10b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p9b==p10b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),1,0,5,4,3,2,+0.5/0.5); 
          in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_53(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
          for (long p9b=p8b;p9b<z->noab()+z->nvab();++p9b) { 
           if (z->get_spin(p6b)+z->get_spin(p8b)+z->get_spin(p9b)==z->get_spin(h2b)+z->get_spin(h3b)+z->get_spin(h10b)) { 
            if ((z->get_sym(p6b)^(z->get_sym(p8b)^(z->get_sym(p9b)^(z->get_sym(h2b)^(z->get_sym(h3b)^z->get_sym(h10b))))))==z->irrep_t()) { 
             long p6b_0,p8b_0,p9b_0,h2b_0,h3b_0,h10b_0; 
             z->restricted_6(p6b,p8b,p9b,h2b,h3b,h10b,p6b_0,p8b_0,p9b_0,h2b_0,h3b_0,h10b_0); 
             long h7b_1,h10b_1,p8b_1,p9b_1; 
             z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
             long dim_common=z->get_range(h10b)*z->get_range(p8b)*z->get_range(p9b); 
             long dima0_sort=z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h7b); 
             long dima1=dim_common*dima1_sort; 
             if (p6b<p8b && h3b<h10b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),4,3,0,2,1,5,+1.0); 
             } 
             else if (p6b<p8b && h2b<h10b && h10b<=h3b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),5,3,0,2,1,4,-1.0); 
             } 
             else if (p6b<p8b && h10b<=h2b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),5,4,0,2,1,3,+1.0); 
             } 
             else if (p8b<=p6b && p6b<p9b && h3b<h10b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),4,3,1,2,0,5,-1.0); 
             } 
             else if (p8b<=p6b && p6b<p9b && h2b<h10b && h10b<=h3b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),5,3,1,2,0,4,+1.0); 
             } 
             else if (p8b<=p6b && p6b<p9b && h10b<=h2b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),5,4,1,2,0,3,-1.0); 
             } 
             else if (p9b<=p6b && h3b<h10b) { 
              z->t3()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(h2b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h2b),z->get_range(h3b),z->get_range(h10b),4,3,2,1,0,5,+1.0); 
             } 
             else if (p9b<=p6b && h2b<h10b && h10b<=h3b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(h2b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h2b),z->get_range(h10b),z->get_range(h3b),5,3,2,1,0,4,-1.0); 
             } 
             else if (p9b<=p6b && h10b<=h2b) { 
              z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p8b_0-z->noab()))))),k_a0); 
              z->sort_indices6(k_a0,k_a0_sort,z->get_range(p8b),z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h2b),z->get_range(h3b),5,4,2,1,0,3,+1.0); 
             } 
             if (h7b<h10b) { 
              z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),0,3,2,1,+1.0); 
             } 
             else if (h10b<=h7b) { 
              z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),1,3,2,0,-1.0); 
             } 
             double factor=1.0; 
             if (p8b==p9b) { 
              factor=factor/2.0; 
             } 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(p6b),0,3,2,1,+0.5/0.5); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_5_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==z->irrep_f()) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      std::fill(k_c,k_c+dimc,0.0); 
      long h7b_0,p8b_0; 
      z->restricted_2(h7b,p8b,h7b_0,p8b_0); 
      long dim_common=1L; 
      long dima0_sort=z->get_range(h7b)*z->get_range(p8b); 
      long dima0=dim_common*dima0_sort; 
      z->f1()->get_block(p8b_0+(z->nab())*(h7b_0),k_a0); 
      z->sort_indices2(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
      z->sort_indices2(k_a0_sort,k_c,z->get_range(h7b),z->get_range(p8b),0,1,+1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_5(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  if (z->get_spin(h7b)==z->get_spin(p8b)) { 
   if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
    if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
     in[2]->input_offset(p8b-z->noab()+z->nvab()*(h7b),size); 
     size+=z->get_range(h7b)*z->get_range(p8b); 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_9(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[1]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h8b=0L;h8b<z->noab();++h8b) { 
         if (z->get_spin(p6b)==z->get_spin(h8b)) { 
          if ((z->get_sym(p6b)^z->get_sym(h8b))==z->irrep_t()) { 
           long p6b_0,h8b_0; 
           z->restricted_2(p6b,h8b,p6b_0,h8b_0); 
           long h7b_1,h8b_1,h2b_1,h3b_1; 
           z->restricted_4(h7b,h8b,h2b,h3b,h7b_1,h8b_1,h2b_1,h3b_1); 
           long dim_common=z->get_range(h8b); 
           long dima0_sort=z->get_range(p6b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h2b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h8b_0+z->noab()*(p6b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(h8b),0,1,+1.0); 
           if (h7b<h8b) { 
            in[2]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),3,2,0,1,+1.0); 
           } 
           else if (h8b<=h7b) { 
            in[2]->get_block(h3b_1+z->noab()*(h2b_1+z->noab()*(h7b_1+z->noab()*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h2b),z->get_range(h7b),z->get_range(p6b),2,3,1,0,+1.0); 
        in[1]->add_block(h3b+z->noab()*(h2b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_1_9_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h8b_0,h2b_0,h3b_0; 
        z->restricted_4(h7b,h8b,h2b,h3b,h7b_0,h8b_0,h2b_0,h3b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(h3b_0+(z->nab())*(h2b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h2b),z->get_range(h3b),0,1,2,3,+1.0); 
        in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_1_9(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
       in[2]->input_offset(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[2]->set_filesize(size); 
in[2]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_16(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=0L;h3b<z->noab();++h3b) { 
    long tileoffset; 
    if (h2b<h3b) { 
     tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    } 
    else if (h3b<=h2b) { 
     tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    } 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h2b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h2b))==z->irrep_t()) { 
           long p9b_0,h2b_0; 
           z->restricted_2(p9b,h2b,p9b_0,h2b_0); 
           long h7b_1,h8b_1,h3b_1,p9b_1; 
           z->restricted_4(h7b,h8b,h3b,p9b,h7b_1,h8b_1,h3b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h2b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h2b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h2b),1,0,+1.0); 
           in[3]->get_block(p9b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),2,1,0,3,+1.0); 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        if (h3b>=h2b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),2,1,3,0,+1.0); 
         in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        } 
        if (h2b>=h3b) { 
         z->sort_indices4(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),2,1,0,3,-1.0); 
         in[2]->add_block(h2b+z->noab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_16_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h8b_0,h3b_0,p9b_0; 
        z->restricted_4(h7b,h8b,h3b,p9b,h7b_0,h8b_0,h3b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h3b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,-1.0); 
        in[3]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_2_16(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
       in[3]->input_offset(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_17(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p9b_0,h3b_0; 
           z->restricted_2(p9b,h3b,p9b_0,h3b_0); 
           long h7b_1,p6b_1,p8b_1,p9b_1; 
           z->restricted_4(h7b,p6b,p8b,p9b,h7b_1,p6b_1,p8b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(p8b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h3b),1,0,+1.0); 
           if (p8b<p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),2,1,0,3,+1.0); 
           } 
           else if (p9b<=p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p9b),z->get_range(p8b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,-0.5); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_18(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=0L;h3b<z->noab();++h3b) { 
      long tileoffset; 
      if (h2b<h3b) { 
       tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b)))))); 
      } 
      else if (h1b<h3b && h3b<=h2b) { 
       tileoffset=(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b)))))); 
      } 
      else if (h3b<=h1b) { 
       tileoffset=(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b)))))); 
      } 
      if (in[2]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
           if (z->get_spin(p6b)+z->get_spin(p9b)==z->get_spin(h1b)+z->get_spin(h2b)) { 
            if ((z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(h1b)^z->get_sym(h2b))))==z->irrep_t()) { 
             long p6b_0,p9b_0,h1b_0,h2b_0; 
             z->restricted_4(p6b,p9b,h1b,h2b,p6b_0,p9b_0,h1b_0,h2b_0); 
             long h7b_1,h8b_1,h3b_1,p9b_1; 
             z->restricted_4(h7b,h8b,h3b,p9b,h7b_1,h8b_1,h3b_1,p9b_1); 
             long dim_common=z->get_range(p9b); 
             long dima0_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b); 
             long dima0=dim_common*dima0_sort; 
             long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b); 
             long dima1=dim_common*dima1_sort; 
             if (p6b<p9b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h1b),z->get_range(h2b),3,2,0,1,+1.0); 
             } 
             else if (p9b<=p6b) { 
              z->t2()->get_block(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
              z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),3,2,1,0,-1.0); 
             } 
             in[3]->get_block(p9b_1-z->noab()+z->nvab()*(h3b_1+z->noab()*(h8b_1+z->noab()*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),2,1,0,3,+1.0); 
             double factor=1.0; 
             z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
            } 
           } 
          } 
          if (h3b>=h2b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),2,1,5,4,3,0,+1.0); 
           in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),k_c); 
          } 
          if (h2b>=h3b && h3b>=h1b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),2,1,5,4,0,3,-1.0); 
           in[2]->add_block(h2b+z->noab()*(h3b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),k_c); 
          } 
          if (h1b>=h3b) { 
           z->sort_indices6(k_c_sort,k_c,z->get_range(h3b),z->get_range(h8b),z->get_range(h7b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),2,1,5,0,4,3,+1.0); 
           in[2]->add_block(h2b+z->noab()*(h1b+z->noab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),k_c); 
          } 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_18_0(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==z->irrep_v()) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        std::fill(k_c,k_c+dimc,0.0); 
        long h7b_0,h8b_0,h3b_0,p9b_0; 
        z->restricted_4(h7b,h8b,h3b,p9b,h7b_0,h8b_0,h3b_0,p9b_0); 
        long dim_common=1L; 
        long dima0_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        long dima0=dim_common*dima0_sort; 
        z->v2()->get_block(p9b_0+(z->nab())*(h3b_0+(z->nab())*(h8b_0+(z->nab())*(h7b_0))),k_a0); 
        z->sort_indices4(k_a0,k_a0_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,+1.0); 
        z->sort_indices4(k_a0_sort,k_c,z->get_range(h7b),z->get_range(h8b),z->get_range(h3b),z->get_range(p9b),0,1,2,3,-1.0); 
        in[3]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_c); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::offset_smith_2_18(){ 
 
long size=0L; 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
     if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
      if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
       in[3]->input_offset(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),size); 
       size+=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
      } 
     } 
    } 
   } 
  } 
 } 
} 
in[3]->set_filesize(size); 
in[3]->createfile(); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_19(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         if (z->get_spin(p9b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p9b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p9b_0,h3b_0; 
           z->restricted_2(p9b,h3b,p9b_0,h3b_0); 
           long h7b_1,p6b_1,p8b_1,p9b_1; 
           z->restricted_4(h7b,p6b,p8b,p9b,h7b_1,p6b_1,p8b_1,p9b_1); 
           long dim_common=z->get_range(p9b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(p6b)*z->get_range(p8b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h3b),1,0,+1.0); 
           if (p8b<p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p8b),z->get_range(p9b),2,1,0,3,+1.0); 
           } 
           else if (p9b<=p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(p6b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(p6b),z->get_range(p9b),z->get_range(p8b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(p6b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_34(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
        if (z->get_spin(p9b)==z->get_spin(h10b)) { 
         if ((z->get_sym(p9b)^z->get_sym(h10b))==z->irrep_t()) { 
          long p9b_0,h10b_0; 
          z->restricted_2(p9b,h10b,p9b_0,h10b_0); 
          long h7b_1,h10b_1,p8b_1,p9b_1; 
          z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
          long dim_common=z->get_range(h10b)*z->get_range(p9b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h7b)*z->get_range(p8b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h10b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h10b),0,1,+1.0); 
          if (h7b<h10b && p8b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),2,0,3,1,+1.0); 
          } 
          else if (h7b<h10b && p9b<=p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p9b),z->get_range(p8b),3,0,2,1,-1.0); 
          } 
          else if (h10b<=h7b && p8b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),2,1,3,0,-1.0); 
          } 
          else if (h10b<=h7b && p9b<=p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p9b),z->get_range(p8b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p8b),z->get_range(h7b),1,0,-1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_35(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h8b_1,p9b_1,p10b_1; 
           z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p9b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,+0.5); 
        in[2]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_36(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
        if (z->get_spin(p9b)==z->get_spin(h10b)) { 
         if ((z->get_sym(p9b)^z->get_sym(h10b))==z->irrep_t()) { 
          long p9b_0,h10b_0; 
          z->restricted_2(p9b,h10b,p9b_0,h10b_0); 
          long h7b_1,h10b_1,p8b_1,p9b_1; 
          z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
          long dim_common=z->get_range(h10b)*z->get_range(p9b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h7b)*z->get_range(p8b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h10b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h10b),0,1,+1.0); 
          if (h7b<h10b && p8b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),2,0,3,1,+1.0); 
          } 
          else if (h7b<h10b && p9b<=p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p9b),z->get_range(p8b),3,0,2,1,-1.0); 
          } 
          else if (h10b<=h7b && p8b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),2,1,3,0,-1.0); 
          } 
          else if (h10b<=h7b && p9b<=p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p9b),z->get_range(p8b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p8b),z->get_range(h7b),1,0,-1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_37(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h9b_1,p8b_1,p10b_1; 
           z->restricted_4(h7b,h9b,p8b,p10b,h7b_1,h9b_1,p8b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h9b)*z->get_range(p8b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p8b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(p10b),z->get_range(p8b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_38(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
   for (long h1b=0L;h1b<z->noab();++h1b) { 
    for (long h2b=h1b;h2b<z->noab();++h2b) { 
     for (long h3b=h2b;h3b<z->noab();++h3b) { 
      long tileoffset; 
      tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b)))))); 
      if (in[2]->is_this_local(tileoffset)) { 
       if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)+z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)!=12L) { 
        if (z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(p6b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
         if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(p6b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==(z->irrep_t()^z->irrep_v())) { 
          long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
          std::fill(k_c_sort,k_c_sort+dimc,0.0); 
          for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
           for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
            if (z->get_spin(p6b)+z->get_spin(p9b)+z->get_spin(p10b)==z->get_spin(h1b)+z->get_spin(h2b)+z->get_spin(h3b)) { 
             if ((z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(p10b)^(z->get_sym(h1b)^(z->get_sym(h2b)^z->get_sym(h3b))))))==z->irrep_t()) { 
              long p6b_0,p9b_0,p10b_0,h1b_0,h2b_0,h3b_0; 
              z->restricted_6(p6b,p9b,p10b,h1b,h2b,h3b,p6b_0,p9b_0,p10b_0,h1b_0,h2b_0,h3b_0); 
              long h7b_1,h8b_1,p9b_1,p10b_1; 
              z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
              long dim_common=z->get_range(p9b)*z->get_range(p10b); 
              long dima0_sort=z->get_range(p6b)*z->get_range(h1b)*z->get_range(h2b)*z->get_range(h3b); 
              long dima0=dim_common*dima0_sort; 
              long dima1_sort=z->get_range(h7b)*z->get_range(h8b); 
              long dima1=dim_common*dima1_sort; 
              if (p6b<p9b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,0,2,1,+1.0); 
              } 
              else if (p9b<=p6b && p6b<p10b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(p10b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,1,2,0,-1.0); 
              } 
              else if (p10b<=p6b) { 
               z->t3()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(h1b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))))),k_a0); 
               z->sort_indices6(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p10b),z->get_range(p6b),z->get_range(h1b),z->get_range(h2b),z->get_range(h3b),5,4,3,2,1,0,+1.0); 
              } 
              z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
              z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),1,0,3,2,+1.0); 
              double factor=1.0; 
              if (p9b==p10b) { 
               factor=factor/2.0; 
              } 
              z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
             } 
            } 
           } 
          } 
          z->sort_indices6(k_c_sort,k_c,z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),z->get_range(h1b),z->get_range(p6b),1,0,5,4,3,2,+0.5/0.5); 
          in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h1b+z->noab()*(p6b-z->noab()+z->nvab()*(h8b+z->noab()*(h7b))))),k_c); 
         } 
        } 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_39(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h8b=0L;h8b<z->noab();++h8b) { 
 for (long h9b=h8b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p7b=z->noab();p7b<z->noab()+z->nvab();++p7b) { 
    long tileoffset; 
    tileoffset=(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h8b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p7b)!=8L) { 
      if (z->get_spin(h8b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p7b)) { 
       if ((z->get_sym(h8b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p7b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h8b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p7b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h8b_1,h9b_1,p7b_1,p10b_1; 
           z->restricted_4(h8b,h9b,p7b,p10b,h8b_1,h9b_1,p7b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h8b)*z->get_range(h9b)*z->get_range(p7b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p7b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p7b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p7b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p7b) { 
            z->v2()->get_block(p7b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h8b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h8b),z->get_range(h9b),z->get_range(p10b),z->get_range(p7b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p7b),z->get_range(h9b),z->get_range(h8b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[2]->add_block(p7b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h8b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_40(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
  long tileoffset; 
  tileoffset=(p8b-z->noab()+z->nvab()*(h7b)); 
  if (in[2]->is_this_local(tileoffset)) { 
   if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p8b)!=4L) { 
    if (z->get_spin(h7b)==z->get_spin(p8b)) { 
     if ((z->get_sym(h7b)^z->get_sym(p8b))==(z->irrep_t()^z->irrep_v())) { 
      long dimc=z->get_range(h7b)*z->get_range(p8b); 
      std::fill(k_c_sort,k_c_sort+dimc,0.0); 
      for (long h10b=0L;h10b<z->noab();++h10b) { 
       for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
        if (z->get_spin(p9b)==z->get_spin(h10b)) { 
         if ((z->get_sym(p9b)^z->get_sym(h10b))==z->irrep_t()) { 
          long p9b_0,h10b_0; 
          z->restricted_2(p9b,h10b,p9b_0,h10b_0); 
          long h7b_1,h10b_1,p8b_1,p9b_1; 
          z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
          long dim_common=z->get_range(h10b)*z->get_range(p9b); 
          long dima0_sort=1L; 
          long dima0=dim_common*dima0_sort; 
          long dima1_sort=z->get_range(h7b)*z->get_range(p8b); 
          long dima1=dim_common*dima1_sort; 
          z->t1()->get_block(h10b_0+z->noab()*(p9b_0-z->noab()),k_a0); 
          z->sort_indices2(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(h10b),0,1,+1.0); 
          if (h7b<h10b && p8b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),2,0,3,1,+1.0); 
          } 
          else if (h7b<h10b && p9b<=p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p9b),z->get_range(p8b),3,0,2,1,-1.0); 
          } 
          else if (h10b<=h7b && p8b<p9b) { 
           z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),2,1,3,0,-1.0); 
          } 
          else if (h10b<=h7b && p9b<=p8b) { 
           z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
           z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p9b),z->get_range(p8b),3,1,2,0,+1.0); 
          } 
          double factor=1.0; 
          z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
         } 
        } 
       } 
      } 
      z->sort_indices2(k_c_sort,k_c,z->get_range(p8b),z->get_range(h7b),1,0,+1.0); 
      in[2]->add_block(p8b-z->noab()+z->nvab()*(h7b),k_c); 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_41(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long p6b=z->noab();p6b<z->noab()+z->nvab();++p6b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(p6b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(p6b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(p6b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(p6b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long h10b=0L;h10b<z->noab();++h10b) { 
         for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
          if (z->get_spin(p6b)+z->get_spin(p9b)==z->get_spin(h3b)+z->get_spin(h10b)) { 
           if ((z->get_sym(p6b)^(z->get_sym(p9b)^(z->get_sym(h3b)^z->get_sym(h10b))))==z->irrep_t()) { 
            long p6b_0,p9b_0,h3b_0,h10b_0; 
            z->restricted_4(p6b,p9b,h3b,h10b,p6b_0,p9b_0,h3b_0,h10b_0); 
            long h7b_1,h10b_1,p8b_1,p9b_1; 
            z->restricted_4(h7b,h10b,p8b,p9b,h7b_1,h10b_1,p8b_1,p9b_1); 
            long dim_common=z->get_range(h10b)*z->get_range(p9b); 
            long dima0_sort=z->get_range(p6b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(p8b); 
            long dima1=dim_common*dima1_sort; 
            if (p6b<p9b && h3b<h10b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h3b),z->get_range(h10b),2,0,1,3,+1.0); 
            } 
            else if (p6b<p9b && h10b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p9b_0-z->noab()+z->nvab()*(p6b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p6b),z->get_range(p9b),z->get_range(h10b),z->get_range(h3b),3,0,1,2,-1.0); 
            } 
            else if (p9b<=p6b && h3b<h10b) { 
             z->t2()->get_block(h10b_0+z->noab()*(h3b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h3b),z->get_range(h10b),2,1,0,3,-1.0); 
            } 
            else if (p9b<=p6b && h10b<=h3b) { 
             z->t2()->get_block(h3b_0+z->noab()*(h10b_0+z->noab()*(p6b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
             z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p6b),z->get_range(h10b),z->get_range(h3b),3,1,0,2,+1.0); 
            } 
            if (h7b<h10b && p8b<p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p8b),z->get_range(p9b),2,0,3,1,+1.0); 
            } 
            else if (h7b<h10b && p9b<=p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h10b_1+(z->nab())*(h7b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h10b),z->get_range(p9b),z->get_range(p8b),3,0,2,1,-1.0); 
            } 
            else if (h10b<=h7b && p8b<p9b) { 
             z->v2()->get_block(p9b_1+(z->nab())*(p8b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p8b),z->get_range(p9b),2,1,3,0,-1.0); 
            } 
            else if (h10b<=h7b && p9b<=p8b) { 
             z->v2()->get_block(p8b_1+(z->nab())*(p9b_1+(z->nab())*(h7b_1+(z->nab())*(h10b_1))),k_a1); 
             z->sort_indices4(k_a1,k_a1_sort,z->get_range(h10b),z->get_range(h7b),z->get_range(p9b),z->get_range(p8b),3,1,2,0,+1.0); 
            } 
            double factor=1.0; 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(h7b),z->get_range(h3b),z->get_range(p6b),1,3,2,0,+1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(p6b-z->noab()+z->nvab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_42(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h9b=h7b;h9b<z->noab();++h9b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p8b=z->noab();p8b<z->noab()+z->nvab();++p8b) { 
    long tileoffset; 
    tileoffset=(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h9b)+z->get_spin(h3b)+z->get_spin(p8b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h9b)==z->get_spin(h3b)+z->get_spin(p8b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h9b)^(z->get_sym(h3b)^z->get_sym(p8b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h9b)*z->get_range(h3b)*z->get_range(p8b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h9b_1,p8b_1,p10b_1; 
           z->restricted_4(h7b,h9b,p8b,p10b,h7b_1,h9b_1,p8b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h9b)*z->get_range(p8b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p8b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p8b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(p8b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p8b) { 
            z->v2()->get_block(p8b_1+(z->nab())*(p10b_1+(z->nab())*(h9b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h9b),z->get_range(p10b),z->get_range(p8b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p8b),z->get_range(h9b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,-1.0); 
        in[2]->add_block(p8b-z->noab()+z->nvab()*(h3b+z->noab()*(h9b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_2_43(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h2b=0L;h2b<z->noab();++h2b) { 
   for (long h3b=h2b;h3b<z->noab();++h3b) { 
    long tileoffset; 
    tileoffset=(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[2]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h2b)+z->get_spin(h3b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h2b)^z->get_sym(h3b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h2b)*z->get_range(h3b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
         for (long p10b=p9b;p10b<z->noab()+z->nvab();++p10b) { 
          if (z->get_spin(p9b)+z->get_spin(p10b)==z->get_spin(h2b)+z->get_spin(h3b)) { 
           if ((z->get_sym(p9b)^(z->get_sym(p10b)^(z->get_sym(h2b)^z->get_sym(h3b))))==z->irrep_t()) { 
            long p9b_0,p10b_0,h2b_0,h3b_0; 
            z->restricted_4(p9b,p10b,h2b,h3b,p9b_0,p10b_0,h2b_0,h3b_0); 
            long h7b_1,h8b_1,p9b_1,p10b_1; 
            z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
            long dim_common=z->get_range(p9b)*z->get_range(p10b); 
            long dima0_sort=z->get_range(h2b)*z->get_range(h3b); 
            long dima0=dim_common*dima0_sort; 
            long dima1_sort=z->get_range(h7b)*z->get_range(h8b); 
            long dima1=dim_common*dima1_sort; 
            z->t2()->get_block(h3b_0+z->noab()*(h2b_0+z->noab()*(p10b_0-z->noab()+z->nvab()*(p9b_0-z->noab()))),k_a0); 
            z->sort_indices4(k_a0,k_a0_sort,z->get_range(p9b),z->get_range(p10b),z->get_range(h2b),z->get_range(h3b),3,2,1,0,+1.0); 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),1,0,3,2,+1.0); 
            double factor=1.0; 
            if (p9b==p10b) { 
             factor=factor/2.0; 
            } 
            z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
           } 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),z->get_range(h2b),1,0,3,2,+0.5/0.5); 
        in[2]->add_block(h3b+z->noab()*(h2b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_3_32(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h8b_1,p9b_1,p10b_1; 
           z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p9b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,+0.5); 
        in[3]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
  
void CCSDTQ_T3::smith_3_33(){ 
      
double* k_a0=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a0_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()); 
double* k_a1=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_a1_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
double* k_c_sort=z->mem()->malloc_local_double(z->maxtilesize()*z->maxtilesize()*z->maxtilesize()*z->maxtilesize()); 
for (long h7b=0L;h7b<z->noab();++h7b) { 
 for (long h8b=h7b;h8b<z->noab();++h8b) { 
  for (long h3b=0L;h3b<z->noab();++h3b) { 
   for (long p9b=z->noab();p9b<z->noab()+z->nvab();++p9b) { 
    long tileoffset; 
    tileoffset=(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b)))); 
    if (in[3]->is_this_local(tileoffset)) { 
     if (!z->restricted() || z->get_spin(h7b)+z->get_spin(h8b)+z->get_spin(h3b)+z->get_spin(p9b)!=8L) { 
      if (z->get_spin(h7b)+z->get_spin(h8b)==z->get_spin(h3b)+z->get_spin(p9b)) { 
       if ((z->get_sym(h7b)^(z->get_sym(h8b)^(z->get_sym(h3b)^z->get_sym(p9b))))==(z->irrep_t()^z->irrep_v())) { 
        long dimc=z->get_range(h7b)*z->get_range(h8b)*z->get_range(h3b)*z->get_range(p9b); 
        std::fill(k_c_sort,k_c_sort+dimc,0.0); 
        for (long p10b=z->noab();p10b<z->noab()+z->nvab();++p10b) { 
         if (z->get_spin(p10b)==z->get_spin(h3b)) { 
          if ((z->get_sym(p10b)^z->get_sym(h3b))==z->irrep_t()) { 
           long p10b_0,h3b_0; 
           z->restricted_2(p10b,h3b,p10b_0,h3b_0); 
           long h7b_1,h8b_1,p9b_1,p10b_1; 
           z->restricted_4(h7b,h8b,p9b,p10b,h7b_1,h8b_1,p9b_1,p10b_1); 
           long dim_common=z->get_range(p10b); 
           long dima0_sort=z->get_range(h3b); 
           long dima0=dim_common*dima0_sort; 
           long dima1_sort=z->get_range(h7b)*z->get_range(h8b)*z->get_range(p9b); 
           long dima1=dim_common*dima1_sort; 
           z->t1()->get_block(h3b_0+z->noab()*(p10b_0-z->noab()),k_a0); 
           z->sort_indices2(k_a0,k_a0_sort,z->get_range(p10b),z->get_range(h3b),1,0,+1.0); 
           if (p9b<p10b) { 
            z->v2()->get_block(p10b_1+(z->nab())*(p9b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p9b),z->get_range(p10b),2,1,0,3,+1.0); 
           } 
           else if (p10b<=p9b) { 
            z->v2()->get_block(p9b_1+(z->nab())*(p10b_1+(z->nab())*(h8b_1+(z->nab())*(h7b_1))),k_a1); 
            z->sort_indices4(k_a1,k_a1_sort,z->get_range(h7b),z->get_range(h8b),z->get_range(p10b),z->get_range(p9b),3,1,0,2,-1.0); 
           } 
           double factor=1.0; 
           z->smith_dgemm(dima0_sort,dima1_sort,dim_common,factor,k_a0_sort,dim_common,k_a1_sort,dim_common,1.0,k_c_sort,dima0_sort); 
          } 
         } 
        } 
        z->sort_indices4(k_c_sort,k_c,z->get_range(p9b),z->get_range(h8b),z->get_range(h7b),z->get_range(h3b),2,1,3,0,+1.0); 
        in[3]->add_block(p9b-z->noab()+z->nvab()*(h3b+z->noab()*(h8b+z->noab()*(h7b))),k_c); 
       } 
      } 
     } 
    } 
   } 
  } 
 } 
} 
z->mem()->free_local_double(k_a1_sort); 
z->mem()->free_local_double(k_a1); 
z->mem()->free_local_double(k_a0_sort); 
z->mem()->free_local_double(k_a0); 
z->mem()->free_local_double(k_c_sort); 
z->mem()->free_local_double(k_c); 
z->mem()->sync(); 
} 
