/* Do not edit this file. It is produced from the corresponding .m4 source */
/*
 *	Copyright 1996, University Corporation for Atmospheric Research
 *	See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *
 * 	This file contains some routines derived from code
 *	which is copyrighted by Sun Microsystems, Inc.
 *	The "#ifdef vax" versions of
 *		 ncx_put_float_float()
 *		 ncx_get_float_float()
 *		 ncx_put_double_double()
 *		 ncx_get_double_double()
 *		 ncx_putn_float_float()
 *		 ncx_getn_float_float()
 *		 ncx_putn_double_double()
 *		 ncx_getn_double_double()
 * 	are derived from xdr_float() and xdr_double() routines
 *	in the freely available, copyrighted Sun RPCSRC 3.9
 *	distribution, xdr_float.c.
 * 	Our "value added" is that these are always memory to memory,
 *	they handle IEEE subnormals properly, and their "n" versions
 *	operate speedily on arrays.
 */
/* $Id: ncx.m4 2795 2014-10-27 23:12:51Z wkliao $ */

/*
 * An external data representation interface.
 */

#pragma GCC diagnostic ignored "-Wdeprecated"

#include "ncx.h"
#include "nc3dispatch.h"
#include <string.h>
#include <limits.h>

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_USHORT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#endif
#ifndef SIZEOF_UINT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#endif
#ifndef SIZEOF_ULONG_LONG
#define SIZEOF_ULONG_LONG SIZEOF_UNSIGNED_LONG_LONG
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if _SX /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIGENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressivly.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
		(((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
		(((a) <<  8) & 0x00ff0000) | \
		(((a) >>  8) & 0x0000ff00) | \
		(((a) >> 24) & 0x000000ff) )


static void
swapn2b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while(nn-- != 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}
 */
	while(nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while(nn-- > 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
}

# ifndef vax
void
swap4b(void *dst, const void *src)
{
    unsigned int *op = dst;
    const char *ip = src;
    unsigned int tempIn;
    unsigned int tempOut;

    tempIn = *(unsigned int *)(ip+0);
    tempOut =
    ( tempIn << 24) |
    ((tempIn & 0x0000ff00) << 8) |
    ((tempIn & 0x00ff0000) >> 8) |
    ( tempIn >> 24);

    *(float *)op = *(float *)(&tempOut);
}
# endif /* !vax */

static void
swapn4b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while(nn-- != 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while(nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while(nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
}

# ifndef vax
static void
swap8b(void *dst, const void *src)
{
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#  endif
}
# endif /* !vax */

# ifndef vax
static void
swapn8b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while(nn-- != 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while(nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while(nn-- != 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while(nn-- != 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#  endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */












/*
 * Primitive numeric conversion functions.
 */





/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* x_short -------------------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG_LONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = *cp++ << 8;
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if(*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= *cp;
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (*ip) >> 8;
	*cp = (*ip) & 0xff;
}

static int
ncx_get_short_schar(const void *xp, schar *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (schar) xx;
#if IX_SHORT_MAX > SCHAR_MAX
	if (xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_short_short(const void *xp, short *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (short) xx;
#if IX_SHORT_MAX > SHORT_MAX
	if (xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_short_int(const void *xp, int *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (int) xx;
#if IX_SHORT_MAX > INT_MAX
	if (xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_short_longlong(const void *xp, longlong *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
	get_ix_short(xp, (ix_short *)ip);
	return ENOERR;
#else
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (longlong) xx;
#if IX_SHORT_MAX > LONGLONG_MAX
	if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_short_ushort(const void *xp, ushort *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (ushort) xx;
#if IX_SHORT_MAX > USHORT_MAX
	if (xx > USHORT_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_short_uchar(const void *xp, uchar *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (uchar) xx;
#if IX_SHORT_MAX > UCHAR_MAX
	if (xx > UCHAR_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_short_uint(const void *xp, uint *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (uint) xx;
#if IX_SHORT_MAX > UINT_MAX
	if (xx > UINT_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (ulonglong) xx;
#if IX_SHORT_MAX > ULONGLONG_MAX
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_short_float(const void *xp, float *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (float) xx;

	return ENOERR;
}

static int
ncx_get_short_double(const void *xp, double *ip)
{
	ix_short xx;
	get_ix_short(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}


static int
ncx_put_short_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return ENOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return ENOERR;
}

static int
ncx_put_short_short(void *xp, const short *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
#if IX_SHORT_MAX < SHORT_MAX
	if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_short_int(void *xp, const int *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
#if IX_SHORT_MAX < INT_MAX
	if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_short_longlong(void *xp, const longlong *ip)
{
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
	put_ix_short(xp, (const ix_short *)ip);
	return ENOERR;
#else
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
#if IX_SHORT_MAX < LONGLONG_MAX
	if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_short_ushort(void *xp, const ushort *ip)
{
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
#if IX_SHORT_MAX < USHORT_MAX
	if (*ip > IX_SHORT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_short_uint(void *xp, const uint *ip)
{
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
#if IX_SHORT_MAX < UINT_MAX
	if (*ip > IX_SHORT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_short_ulonglong(void *xp, const ulonglong *ip)
{
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
#if IX_SHORT_MAX < ULONGLONG_MAX
	if (*ip > IX_SHORT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_short_float(void *xp, const float *ip)
{
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
	if(*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_short_double(void *xp, const double *ip)
{
	ix_short xx = (ix_short)*ip;
	put_ix_short(xp, &xx);
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
	return ENOERR;
}


/* x_ushort ------------------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG_LONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = *cp++ << 8;
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if(*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= *cp; 
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (*ip) >> 8;
	*cp = (*ip) & 0xff;
}

static int
ncx_get_ushort_schar(const void *xp, schar *ip)
{
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (schar) xx;
#if IX_USHORT_MAX > SCHAR_MAX
	if (xx > SCHAR_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ushort_short(const void *xp, short *ip)
{
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (short) xx;
#if IX_USHORT_MAX > SHORT_MAX
	if (xx > SHORT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ushort_int(const void *xp, int *ip)
{
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (int) xx;
#if IX_USHORT_MAX > INT_MAX
	if (xx > INT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ushort_longlong(const void *xp, longlong *ip)
{
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (longlong) xx;
#if IX_USHORT_MAX > LONGLONG_MAX
	if (xx > LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ushort_ushort(const void *xp, ushort *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
	get_ix_ushort(xp, (ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (ushort) xx;
#if IX_USHORT_MAX > USHORT_MAX
	if (xx > USHORT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ushort_uchar(const void *xp, uchar *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
	get_ix_ushort(xp, (ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (uchar) xx;
#if IX_USHORT_MAX > UCHAR_MAX
	if (xx > UCHAR_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ushort_uint(const void *xp, uint *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
	get_ix_ushort(xp, (ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (uint) xx;
#if IX_USHORT_MAX > UINT_MAX
	if (xx > UINT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
	get_ix_ushort(xp, (ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (ulonglong) xx;
#if IX_USHORT_MAX > ULONGLONG_MAX
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ushort_float(const void *xp, float *ip)
{
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (float) xx;

	return ENOERR;
}

static int
ncx_get_ushort_double(const void *xp, double *ip)
{
	ix_ushort xx;
	get_ix_ushort(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}


static int
ncx_put_ushort_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
        if (*ip < 0) return NC_ERANGE;

	return ENOERR;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return ENOERR;
}

static int
ncx_put_ushort_short(void *xp, const short *ip)
{
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
#if IX_USHORT_MAX < SHORT_MAX
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ushort_int(void *xp, const int *ip)
{
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
#if IX_USHORT_MAX < INT_MAX
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ushort_longlong(void *xp, const longlong *ip)
{
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
#if IX_USHORT_MAX < LONGLONG_MAX
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ushort_ushort(void *xp, const ushort *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
	put_ix_ushort(xp, (const ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
#if IX_USHORT_MAX < USHORT_MAX
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ushort_uint(void *xp, const uint *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
	put_ix_ushort(xp, (const ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
#if IX_USHORT_MAX < UINT_MAX
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip)
{
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
	put_ix_ushort(xp, (const ix_ushort *)ip);
	return ENOERR;
#else
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
#if IX_USHORT_MAX < ULONGLONG_MAX
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ushort_float(void *xp, const float *ip)
{
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
	if(*ip > (double)X_USHORT_MAX || *ip < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_ushort_double(void *xp, const double *ip)
{
	ix_ushort xx = (ix_ushort)*ip;
	put_ix_ushort(xp, &xx);
	if(*ip > X_USHORT_MAX || *ip < 0) return NC_ERANGE;
	return ENOERR;
}


/* x_int ---------------------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = *cp++ << 24;
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if(*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (*ip) >> 24;
	*cp++ = ((*ip) & 0x00ff0000) >> 16;
	*cp++ = ((*ip) & 0x0000ff00) >>  8;
	*cp   = ((*ip) & 0x000000ff);
}

static int
ncx_get_int_schar(const void *xp, schar *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (schar) xx;
#if IX_INT_MAX > SCHAR_MAX
	if (xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_int_short(const void *xp, short *ip)
{
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
	get_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (short) xx;
#if IX_INT_MAX > SHORT_MAX
	if (xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

       int
ncx_get_int_int(const void *xp, int *ip)
{
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
	get_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (int) xx;
#if IX_INT_MAX > INT_MAX
	if (xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_int_longlong(const void *xp, longlong *ip)
{
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
	get_ix_int(xp, (ix_int *)ip);
	return ENOERR;
#else
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (longlong) xx;
#if IX_INT_MAX > LONGLONG_MAX
	if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_int_ushort(const void *xp, ushort *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (ushort) xx;
#if IX_INT_MAX > USHORT_MAX
	if (xx > USHORT_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_int_uchar(const void *xp, uchar *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (uchar) xx;
#if IX_INT_MAX > UCHAR_MAX
	if (xx > UCHAR_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_int_uint(const void *xp, uint *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (uint) xx;
#if IX_INT_MAX > UINT_MAX
	if (xx > UINT_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (ulonglong) xx;
#if IX_INT_MAX > ULONGLONG_MAX
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_int_float(const void *xp, float *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (float) xx;

	return ENOERR;
}

static int
ncx_get_int_double(const void *xp, double *ip)
{
	ix_int xx;
	get_ix_int(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}


static int
ncx_put_int_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return ENOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return ENOERR;
}

static int
ncx_put_int_short(void *xp, const short *ip)
{
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
	put_ix_int(xp, (const ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
#if IX_INT_MAX < SHORT_MAX
	if (*ip > IX_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

       int
ncx_put_int_int(void *xp, const int *ip)
{
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
	put_ix_int(xp, (const ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
#if IX_INT_MAX < INT_MAX
	if (*ip > IX_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_int_longlong(void *xp, const longlong *ip)
{
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
	put_ix_int(xp, (const ix_int *)ip);
	return ENOERR;
#else
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
#if IX_INT_MAX < LONGLONG_MAX
	if (*ip > IX_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_int_ushort(void *xp, const ushort *ip)
{
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
#if IX_INT_MAX < USHORT_MAX
	if (*ip > IX_INT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_int_uint(void *xp, const uint *ip)
{
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
#if IX_INT_MAX < UINT_MAX
	if (*ip > IX_INT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_int_ulonglong(void *xp, const ulonglong *ip)
{
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
#if IX_INT_MAX < ULONGLONG_MAX
	if (*ip > IX_INT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_int_float(void *xp, const float *ip)
{
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
	if(*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_int_double(void *xp, const double *ip)
{
	ix_int xx = (ix_int)*ip;
	put_ix_int(xp, &xx);
	if(*ip > X_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
	return ENOERR;
}



/* x_uint --------------------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = *cp++ << 24;
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp; 
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (*ip) >> 24;
	*cp++ = ((*ip) & 0x00ff0000) >> 16;
	*cp++ = ((*ip) & 0x0000ff00) >>  8;
	*cp   = ((*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
ncx_get_uint_uint(const void *xp, uint *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
	get_ix_uint(xp, (ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (uint) xx;
#if IX_UINT_MAX > UINT_MAX
	if (xx > UINT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

#endif

static int
ncx_get_uint_schar(const void *xp, schar *ip)
{
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (schar) xx;
#if IX_UINT_MAX > SCHAR_MAX
	if (xx > SCHAR_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_uint_short(const void *xp, short *ip)
{
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (short) xx;
#if IX_UINT_MAX > SHORT_MAX
	if (xx > SHORT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_uint_int(const void *xp, int *ip)
{
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (int) xx;
#if IX_UINT_MAX > INT_MAX
	if (xx > INT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_uint_longlong(const void *xp, longlong *ip)
{
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (longlong) xx;
#if IX_UINT_MAX > LONGLONG_MAX
	if (xx > LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_uint_ushort(const void *xp, ushort *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
	get_ix_uint(xp, (ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (ushort) xx;
#if IX_UINT_MAX > USHORT_MAX
	if (xx > USHORT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_uint_uchar(const void *xp, uchar *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
	get_ix_uint(xp, (ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (uchar) xx;
#if IX_UINT_MAX > UCHAR_MAX
	if (xx > UCHAR_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
	get_ix_uint(xp, (ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (ulonglong) xx;
#if IX_UINT_MAX > ULONGLONG_MAX
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_uint_float(const void *xp, float *ip)
{
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (float) xx;

	return ENOERR;
}

static int
ncx_get_uint_double(const void *xp, double *ip)
{
	ix_uint xx;
	get_ix_uint(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}


static int
ncx_put_uint_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp = (uchar)*ip;

	if (*ip < 0) return NC_ERANGE;

	return ENOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return ENOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
ncx_put_uint_uint(void *xp, const uint *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
	put_ix_uint(xp, (const ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
#if IX_UINT_MAX < UINT_MAX
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

#endif

static int
ncx_put_uint_short(void *xp, const short *ip)
{
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
#if IX_UINT_MAX < SHORT_MAX
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_uint_int(void *xp, const int *ip)
{
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
#if IX_UINT_MAX < INT_MAX
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_uint_longlong(void *xp, const longlong *ip)
{
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
#if IX_UINT_MAX < LONGLONG_MAX
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_uint_ushort(void *xp, const ushort *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
	put_ix_uint(xp, (const ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
#if IX_UINT_MAX < USHORT_MAX
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip)
{
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
	put_ix_uint(xp, (const ix_uint *)ip);
	return ENOERR;
#else
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
#if IX_UINT_MAX < ULONGLONG_MAX
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_uint_float(void *xp, const float *ip)
{
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
	if(*ip > (double)X_UINT_MAX || *ip < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_uint_double(void *xp, const double *ip)
{
	ix_uint xx = (ix_uint)*ip;
	put_ix_uint(xp, &xx);
	if(*ip > X_UINT_MAX || *ip < 0) return NC_ERANGE;
	return ENOERR;
}


/* x_float -------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, sizeof(float));
#else
	swap4b(ip, xp);
#endif
}

static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif vax

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
		const struct ieee_single *const isp =
			 (const struct ieee_single *) xp;
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;

		switch(exp) {
		case 0 :
			/* ieee subnormal */
			if(isp->mant_hi == min.ieee.mant_hi
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
			{
				*vsp = min.s;
			}
			else
			{
				unsigned mantissa = (isp->mant_hi << 16)
					 | isp->mant_lo_hi << 8
					 | isp->mant_lo_lo;
				unsigned tmp = mantissa >> 20;
				if(tmp >= 4) {
					vsp->exp = 2;
				} else if (tmp >= 2) {
					vsp->exp = 1;
				} else {
					*vsp = min.s;
					break;
				} /* else */
				tmp = mantissa - (1 << (20 + vsp->exp ));
				tmp <<= 3 - vsp->exp;
				vsp->mantissa2 = tmp;
				vsp->mantissa1 = (tmp >> 16);
			}
			break;
		case 0xfe :
		case 0xff :
			*vsp = max.s;
			break;
		default :
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
			vsp->mantissa1 = isp->mant_hi;
		}

		vsp->sign = isp->sign;

}


static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
			 (const struct vax_single *)ip;
		struct ieee_single *const isp = (struct ieee_single *) xp;

		switch(vsp->exp){
		case 0 :
			/* all vax float with zero exponent map to zero */
			*isp = min.ieee;
			break;
		case 2 :
		case 1 :
		{
			/* These will map to subnormals */
			unsigned mantissa = (vsp->mantissa1 << 16)
					 | vsp->mantissa2;
			mantissa >>= 3 - vsp->exp;
			mantissa += (1 << (20 + vsp->exp));
			isp->mant_lo_lo = mantissa;
			isp->mant_lo_hi = mantissa >> 8;
			isp->mant_hi = mantissa >> 16;
			isp->exp_lo = 0;
			isp->exp_hi = 0;
		}
			break;
		case 0xff : /* max.s.exp */
			if( vsp->mantissa2 == max.s.mantissa2
				&& vsp->mantissa1 == max.s.mantissa1)
			{
				/* map largest vax float to ieee infinity */
				*isp = max.ieee;
				break;
			} /* else, fall thru */
		default :
		{
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
			isp->exp_hi = exp >> 1;
			isp->exp_lo = exp;
			isp->mant_lo_lo = vsp->mantissa2;
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
			isp->mant_hi = vsp->mantissa1;
		}
		}

		isp->sign = vsp->sign;

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;


static void
get_ix_float(const void *xp, float *ip)
{

	if(word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;

		if(isp->exp == 0)
		{
			/* ieee subnormal */
			*ip = (double)isp->mant;
			if(isp->mant != 0)
			{
				csp->exp -= (ieee_single_bias + 22);
			}
		}
		else
		{
			csp->exp  = isp->exp + cs_ieis_bias + 1;
			csp->mant = isp->mant << (48 - 1 - 23);
			csp->mant |= (1 << (48 - 1));
		}
		csp->sign = isp->sign;


	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;

		if(isp->exp == 0)
		{
			/* ieee subnormal */
			*ip = (double)isp->mant;
			if(isp->mant != 0)
			{
				csp->exp -= (ieee_single_bias + 22);
			}
		}
		else
		{
			csp->exp  = isp->exp + cs_ieis_bias + 1;
			csp->mant = isp->mant << (48 - 1 - 23);
			csp->mant |= (1 << (48 - 1));
		}
		csp->sign = isp->sign;


	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if(word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
	int ieee_exp = csp->exp - cs_ieis_bias -1;

	isp->sign = csp->sign;

	if(ieee_exp >= 0xff)
	{
		/* NC_ERANGE => ieee Inf */
		isp->exp = 0xff;
		isp->mant = 0x0;
	}
	else if(ieee_exp > 0)
	{
		/* normal ieee representation */
		isp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		isp->mant = (((csp->mant << 1) &
				0xffffffffffff) >> (48 - 23));
	}
	else if(ieee_exp > -23)
	{
		/* ieee subnormal, right shift */
		const int rshift = (48 - 23 - ieee_exp);

		isp->mant = csp->mant >> rshift;

#if 0
		if(csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			isp->mant++;
		}
#endif

		isp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		isp->exp = 0;
		isp->mant = 0;
	}

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
	int ieee_exp = csp->exp - cs_ieis_bias -1;

	isp->sign = csp->sign;

	if(ieee_exp >= 0xff)
	{
		/* NC_ERANGE => ieee Inf */
		isp->exp = 0xff;
		isp->mant = 0x0;
	}
	else if(ieee_exp > 0)
	{
		/* normal ieee representation */
		isp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		isp->mant = (((csp->mant << 1) &
				0xffffffffffff) >> (48 - 23));
	}
	else if(ieee_exp > -23)
	{
		/* ieee subnormal, right shift */
		const int rshift = (48 - 23 - ieee_exp);

		isp->mant = csp->mant >> rshift;

#if 0
		if(csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			isp->mant++;
		}
#endif

		isp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		isp->exp = 0;
		isp->mant = 0;
	}

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if(word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if(isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if(isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if(word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if(idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if(idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip)
{
	/* TODO */
	get_ix_float(xp, ip);
	return ENOERR;
}
#endif

#define ix_float float

static int
ncx_get_float_schar(const void *xp, schar *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (schar) xx;
	if(xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_short(const void *xp, short *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (short) xx;
	if(xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_int(const void *xp, int *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (int) xx;
	if(xx > (double)INT_MAX || xx < (double)INT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_double(const void *xp, double *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}

static int
ncx_get_float_longlong(const void *xp, longlong *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (longlong) xx;
	if(xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_uchar(const void *xp, uchar *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (uchar) xx;
	if(xx > (double)UCHAR_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_ushort(const void *xp, ushort *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (ushort) xx;
	if(xx > (double)USHORT_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_uint(const void *xp, uint *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (uint) xx;
	if(xx > (double)UINT_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
{
	ix_float xx;
	get_ix_float(xp, &xx);
	*ip = (ulonglong) xx;
	if(xx > (double)ULONGLONG_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip)
{
	put_ix_float(xp, ip);
#ifdef NO_IEEE_FLOAT
	if(*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}
#endif

static int
ncx_put_float_schar(void *xp, const schar *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_short(void *xp, const short *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_int(void *xp, const int *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_double(void *xp, const double *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);
	if(*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_float_longlong(void *xp, const longlong *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_uchar(void *xp, const uchar *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_ushort(void *xp, const ushort *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_uint(void *xp, const uint *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}

static int
ncx_put_float_ulonglong(void *xp, const ulonglong *ip)
{
	ix_float xx = (ix_float)*ip;
	put_ix_float(xp, &xx);

	return ENOERR;
}



/* x_double ------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, sizeof(double));
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif vax

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
			 (struct vax_double *)ip;
	const struct ieee_double *const idp =
			 (const struct ieee_double *) xp;
	{
		const struct dbl_limits *lim;
		int ii;
		for (ii = 0, lim = dbl_limits;
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
			ii++, lim++)
		{
			if ((idp->mant_lo == lim->ieee.mant_lo)
				&& (idp->mant_4 == lim->ieee.mant_4)
				&& (idp->mant_5 == lim->ieee.mant_5)
				&& (idp->mant_6 == lim->ieee.mant_6)
				&& (idp->exp_lo == lim->ieee.exp_lo)
				&& (idp->exp_hi == lim->ieee.exp_hi)
				)
			{
				*vdp = lim->d;
				goto doneit;
			}
		}
	}
	{
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
	}
	{
		unsigned mant_hi = ((idp->mant_6 << 16)
				 | (idp->mant_5 << 8)
				 | idp->mant_4);
		unsigned mant_lo = SWAP4(idp->mant_lo);
		vdp->mantissa1 = (mant_hi >> 13);
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
				| (mant_lo >> 29);
		vdp->mantissa3 = (mant_lo >> 13);
		vdp->mantissa4 = (mant_lo << 3);
	}
	doneit:
		vdp->sign = idp->sign;

}


static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
			(const struct vax_double *)ip;
	struct ieee_double *const idp =
			 (struct ieee_double *) xp;

	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
		(vdp->exp == dbl_limits[0].d.exp))
	{
		*idp = dbl_limits[0].ieee;
		goto shipit;
	}
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
		(vdp->exp == dbl_limits[1].d.exp))
	{
		*idp = dbl_limits[1].ieee;
		goto shipit;
	}

	{
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;

		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
			(vdp->mantissa3 << 13) |
			((vdp->mantissa4 >> 3) & MASK(13));

		unsigned mant_hi = (vdp->mantissa1 << 13)
				 | (vdp->mantissa2 >> 3);

		if((vdp->mantissa4 & 7) > 4)
		{
			/* round up */
			mant_lo++;
			if(mant_lo == 0)
			{
				mant_hi++;
				if(mant_hi > 0xffffff)
				{
					mant_hi = 0;
					exp++;
				}
			}
		}

		idp->mant_lo = SWAP4(mant_lo);
		idp->mant_6 = mant_hi >> 16;
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
		idp->mant_4 = mant_hi;
		idp->exp_hi = exp >> 4;
		idp->exp_lo = exp;
	}

	shipit:
		idp->sign = vdp->sign;

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if(idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if(idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if(ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if(ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if(ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if(ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if(csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
ncx_get_double_schar(const void *xp, schar *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (schar) xx;
	if(xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_short(const void *xp, short *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (short) xx;
	if(xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_int(const void *xp, int *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (int) xx;
	if(xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_longlong(const void *xp, longlong *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (longlong) xx;
	if(xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_uchar(const void *xp, uchar *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (uchar) xx;
	if(xx > UCHAR_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_ushort(const void *xp, ushort *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (ushort) xx;
	if(xx > USHORT_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_uint(const void *xp, uint *ip)
{
	ix_double xx;
	get_ix_double(xp, &xx);
	*ip = (uint) xx;
	if(xx > UINT_MAX || xx < 0) return NC_ERANGE;
	return ENOERR;
}


int
ncx_get_double_ulonglong(const void *xp, unsigned long long *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (unsigned long long) xx;
	if(xx > ULONG_LONG_MAX || xx < 0)
		return NC_ERANGE;
	return ENOERR;
}

static int
ncx_get_double_float(const void *xp, float *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	if(xx > FLT_MAX)
	{
		*ip = FLT_MAX;
		return NC_ERANGE;
	}
	if(xx < (-FLT_MAX))
	{
		*ip = (-FLT_MAX);
		return NC_ERANGE;
	}
	*ip = (float) xx;
	return ENOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip)
{
	/* TODO */
	get_ix_double(xp, ip);
	return ENOERR;
}
#endif

static int
ncx_put_double_schar(void *xp, const schar *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_uchar(void *xp, const uchar *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_short(void *xp, const short *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_ushort(void *xp, const ushort *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_int(void *xp, const int *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_uint(void *xp, const uint *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_longlong(void *xp, const longlong *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}

static int
ncx_put_double_ulonglong(void *xp, const ulonglong *ip)
{
	ix_double xx = (ix_double)*ip;
	put_ix_double(xp, &xx);

	return ENOERR;
}


static int
ncx_put_double_float(void *xp, const float *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 1	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip)
{
	put_ix_double(xp, ip);
#ifdef NO_IEEE_FLOAT
	if(*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return ENOERR;
}
#endif


/* x_longlong ---------------------------------------------------------------------*/

#if SHORT_MAX == X_LONGLONG_MAX
typedef short ix_longlong;
#define SIZEOF_IX_LONGLONG SIZEOF_SHORT
#define IX_LONGLONG_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_LONGLONG_MAX
typedef longlong ix_longlong;
#define SIZEOF_IX_LONGLONG SIZEOF_LONGLONG
#define IX_LONGLONG_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_LONGLONG_MAX
typedef long ix_longlong;
#define SIZEOF_IX_LONGLONG SIZEOF_LONG
#define IX_LONGLONG_MAX LONG_MAX
#else
#error "ix_longlong implementation"
#endif


static void
get_ix_longlong(const void *xp, ix_longlong *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((long long)(*cp++) << 56);
    *ip |= ((long long)(*cp++) << 48);
    *ip |= ((long long)(*cp++) << 40);
    *ip |= ((long long)(*cp++) << 32);
    *ip |= ((long long)(*cp++) << 24);
    *ip |= ((long long)(*cp++) << 16);
    *ip |= ((long long)(*cp++) <<  8);
    *ip |=  (long long)*cp;
}

static void
put_ix_longlong(void *xp, const ix_longlong *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (*ip) >> 56;
    *cp++ = ((*ip) & 0x00ff000000000000LL) >> 48;
    *cp++ = ((*ip) & 0x0000ff0000000000LL) >> 40;
    *cp++ = ((*ip) & 0x000000ff00000000LL) >> 32;
    *cp++ = ((*ip) & 0x00000000ff000000LL) >> 24;
    *cp++ = ((*ip) & 0x0000000000ff0000LL) >> 16;
    *cp++ = ((*ip) & 0x000000000000ff00LL) >>  8;
    *cp   = ((*ip) & 0x00000000000000ffLL);
}

static int
ncx_get_longlong_schar(const void *xp, schar *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (schar) xx;
#if IX_LONGLONG_MAX > SCHAR_MAX
	if (xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_longlong_short(const void *xp, short *ip)
{
#if SIZEOF_IX_LONGLONG == SIZEOF_SHORT && IX_LONGLONG_MAX == SHORT_MAX
	get_ix_longlong(xp, (ix_longlong *)ip);
	return ENOERR;
#else
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (short) xx;
#if IX_LONGLONG_MAX > SHORT_MAX
	if (xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_longlong_int(const void *xp, int *ip)
{
#if SIZEOF_IX_LONGLONG == SIZEOF_INT && IX_LONGLONG_MAX == INT_MAX
	get_ix_longlong(xp, (ix_longlong *)ip);
	return ENOERR;
#else
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (int) xx;
#if IX_LONGLONG_MAX > INT_MAX
	if (xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_longlong_longlong(const void *xp, longlong *ip)
{
#if SIZEOF_IX_LONGLONG == SIZEOF_LONGLONG && IX_LONGLONG_MAX == LONGLONG_MAX
	get_ix_longlong(xp, (ix_longlong *)ip);
	return ENOERR;
#else
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (longlong) xx;
#if IX_LONGLONG_MAX > LONGLONG_MAX
	if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_longlong_ushort(const void *xp, ushort *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (ushort) xx;
#if IX_LONGLONG_MAX > USHORT_MAX
	if (xx > USHORT_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_longlong_uchar(const void *xp, uchar *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (uchar) xx;
#if IX_LONGLONG_MAX > UCHAR_MAX
	if (xx > UCHAR_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_longlong_uint(const void *xp, uint *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (uint) xx;
#if IX_LONGLONG_MAX > UINT_MAX
	if (xx > UINT_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (ulonglong) xx;
#if IX_LONGLONG_MAX > ULONGLONG_MAX
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
	return ENOERR;
}

static int
ncx_get_longlong_float(const void *xp, float *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (float) xx;

	return ENOERR;
}

static int
ncx_get_longlong_double(const void *xp, double *ip)
{
	ix_longlong xx;
	get_ix_longlong(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}


static int
ncx_put_longlong_schar(void *xp, const schar *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < SCHAR_MAX
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_longlong_short(void *xp, const short *ip)
{
#if SIZEOF_IX_LONGLONG == SIZEOF_SHORT && IX_LONGLONG_MAX == SHORT_MAX
	put_ix_longlong(xp, (const ix_longlong *)ip);
	return ENOERR;
#else
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < SHORT_MAX
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_longlong_int(void *xp, const int *ip)
{
#if SIZEOF_IX_LONGLONG == SIZEOF_INT && IX_LONGLONG_MAX == INT_MAX
	put_ix_longlong(xp, (const ix_longlong *)ip);
	return ENOERR;
#else
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < INT_MAX
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_longlong_longlong(void *xp, const longlong *ip)
{
#if SIZEOF_IX_LONGLONG == SIZEOF_LONGLONG && IX_LONGLONG_MAX == LONGLONG_MAX
	put_ix_longlong(xp, (const ix_longlong *)ip);
	return ENOERR;
#else
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < LONGLONG_MAX
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_longlong_ushort(void *xp, const ushort *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < USHORT_MAX
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_longlong_uchar(void *xp, const uchar *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < UCHAR_MAX
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_longlong_uint(void *xp, const uint *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < UINT_MAX
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
#if IX_LONGLONG_MAX < ULONGLONG_MAX
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_put_longlong_float(void *xp, const float *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
	if(*ip > (double)X_LONGLONG_MAX || *ip < (double)X_LONGLONG_MIN) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_longlong_double(void *xp, const double *ip)
{
	ix_longlong xx = (ix_longlong)*ip;
	put_ix_longlong(xp, &xx);
	if(*ip > X_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
	return ENOERR;
}


/* x_ulonglong --------------------------------------------------------------------*/

#if USHORT_MAX == X_ULONGLONG_MAX
typedef ushort ix_ulonglong;
#define SIZEOF_IX_ULONGLONG SIZEOF_USHORT
#define IX_ULONGLONG_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_ULONGLONG_MAX
typedef ulonglong ix_ulonglong;
#define SIZEOF_IX_ULONGLONG SIZEOF_ULONGLONG
#define IX_ULONGLONG_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_ULONGLONG_MAX
typedef ulong ix_ulonglong;
#define SIZEOF_IX_ULONGLONG SIZEOF_ULONG
#define IX_ULONGLONG_MAX ULONG_MAX
#else
#error "ix_ulonglong implementation"
#endif


static void
get_ix_ulonglong(const void *xp, ix_ulonglong *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((unsigned long long)(*cp++) << 56);
    *ip |= ((unsigned long long)(*cp++) << 48);
    *ip |= ((unsigned long long)(*cp++) << 40);
    *ip |= ((unsigned long long)(*cp++) << 32);
    *ip |= ((unsigned long long)(*cp++) << 24);
    *ip |= ((unsigned long long)(*cp++) << 16);
    *ip |= ((unsigned long long)(*cp++) <<  8);
    *ip |=  (unsigned long long)*cp;
}

static void
put_ix_ulonglong(void *xp, const ix_ulonglong *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (*ip) >> 56;
    *cp++ = ((*ip) & 0x00ff000000000000ULL) >> 48;
    *cp++ = ((*ip) & 0x0000ff0000000000ULL) >> 40;
    *cp++ = ((*ip) & 0x000000ff00000000ULL) >> 32;
    *cp++ = ((*ip) & 0x00000000ff000000ULL) >> 24;
    *cp++ = ((*ip) & 0x0000000000ff0000ULL) >> 16;
    *cp++ = ((*ip) & 0x000000000000ff00ULL) >>  8;
    *cp   = ((*ip) & 0x00000000000000ffULL);
}

static int
ncx_get_ulonglong_schar(const void *xp, schar *ip)
{
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (schar) xx;
#if IX_ULONGLONG_MAX > SCHAR_MAX
	if (xx > SCHAR_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ulonglong_short(const void *xp, short *ip)
{
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (short) xx;
#if IX_ULONGLONG_MAX > SHORT_MAX
	if (xx > SHORT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ulonglong_int(const void *xp, int *ip)
{
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (int) xx;
#if IX_ULONGLONG_MAX > INT_MAX
	if (xx > INT_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
{
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (longlong) xx;
#if IX_ULONGLONG_MAX > LONGLONG_MAX
	if (xx > LONGLONG_MAX) return NC_ERANGE;
#endif

	return ENOERR;
}

static int
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_USHORT && IX_ULONGLONG_MAX == USHORT_MAX
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (ushort) xx;
#if IX_ULONGLONG_MAX > USHORT_MAX
	if (xx > USHORT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_UCHAR && IX_ULONGLONG_MAX == UCHAR_MAX
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (uchar) xx;
#if IX_ULONGLONG_MAX > UCHAR_MAX
	if (xx > UCHAR_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ulonglong_uint(const void *xp, uint *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_UINT && IX_ULONGLONG_MAX == UINT_MAX
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (uint) xx;
#if IX_ULONGLONG_MAX > UINT_MAX
	if (xx > UINT_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_ULONGLONG && IX_ULONGLONG_MAX == ULONGLONG_MAX
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (ulonglong) xx;
#if IX_ULONGLONG_MAX > ULONGLONG_MAX
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_get_ulonglong_float(const void *xp, float *ip)
{
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (float) xx;

	return ENOERR;
}

static int
ncx_get_ulonglong_double(const void *xp, double *ip)
{
	ix_ulonglong xx;
	get_ix_ulonglong(xp, &xx);
	*ip = (double) xx;

	return ENOERR;
}


static int
ncx_put_ulonglong_schar(void *xp, const schar *ip)
{
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < SCHAR_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ulonglong_short(void *xp, const short *ip)
{
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < SHORT_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ulonglong_int(void *xp, const int *ip)
{
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < INT_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ulonglong_longlong(void *xp, const longlong *ip)
{
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < LONGLONG_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
	return ENOERR;
}

static int
ncx_put_ulonglong_uchar(void *xp, const uchar *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_UCHAR && IX_ULONGLONG_MAX == UCHAR_MAX
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < UCHAR_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ulonglong_ushort(void *xp, const ushort *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_USHORT && IX_ULONGLONG_MAX == USHORT_MAX
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < USHORT_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ulonglong_uint(void *xp, const uint *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_UINT && IX_ULONGLONG_MAX == UINT_MAX
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < UINT_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip)
{
#if SIZEOF_IX_ULONGLONG == SIZEOF_ULONGLONG && IX_ULONGLONG_MAX == ULONGLONG_MAX
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
	return ENOERR;
#else
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
#if IX_ULONGLONG_MAX < ULONGLONG_MAX
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#endif

#endif
	return ENOERR;
}

static int
ncx_put_ulonglong_float(void *xp, const float *ip)
{
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
	if(*ip > (double)X_ULONGLONG_MAX || *ip < 0) return NC_ERANGE;
	return ENOERR;
}

static int
ncx_put_ulonglong_double(void *xp, const double *ip)
{
	ix_ulonglong xx = (ix_ulonglong)*ip;
	put_ix_ulonglong(xp, &xx);
	if(*ip > X_ULONGLONG_MAX || *ip < 0) return NC_ERANGE;
	return ENOERR;
}


/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return ENOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp = (unsigned)(*cp++ << 24);
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return ENOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
		/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000ULL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000ULL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000ULL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000ULL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000ULL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00ULL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffULL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return ENOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return ENOERR;
}

/*----< ncx_get_int32() >--------------------------------------------------*/
int
ncx_get_int32(const void **xpp,
              int         *ip)
{
    const uchar *cp = (const uchar *) *xpp;

    /* cannot call swap4b(), as lp is 8-byte */
    *ip  = (*cp++ << 24);
    *ip |= (*cp++ << 16);
    *ip |= (*cp++ <<  8);
    *ip |=  *cp;

    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_int64() >-------------------------------------------------*/
int
ncx_get_int64(const void **xpp,
              long long   *llp)
{
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(llp, *xpp) */
    *llp  = ((long long)(*cp++) << 56);
    *llp |= ((long long)(*cp++) << 48);
    *llp |= ((long long)(*cp++) << 40);
    *llp |= ((long long)(*cp++) << 32);
    *llp |= ((long long)(*cp++) << 24);
    *llp |= ((long long)(*cp++) << 16);
    *llp |= ((long long)(*cp++) <<  8);
    *llp |=  (long long)*cp;

    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_int32() >-----------------------------------------------------*/
/* copy the contents of lp (a signed 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_int32(void      **xpp,
              const int   ip)
{
#ifdef WORDS_BIGENDIAN
    int *ptr = (int*) (*xpp); /* typecast to 4-byte integer */
    *ptr = ip;
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    /* cannot call swap4b(), as lp is 8-byte */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_int64() >-----------------------------------------------------*/
/* copy the contents of lp (a signed 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_int64(void             **xpp,
              const long long    ip)
{
#ifdef WORDS_BIGENDIAN
    long long *ptr = (long long*) (*xpp); /* typecast to 8-byte integer */
    *ptr = ip;
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar)((ip & 0xff00000000000000ULL) >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( ip & 0x00000000000000ffULL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */



/* schar ---------------------------------------------------------------------*/

int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);
	return ENOERR;

}
int
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);
	return ENOERR;

}
int
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{
		if (*xp < 0) status = NC_ERANGE;
		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{
		if (*xp < 0) status = NC_ERANGE;
		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
	int status = ENOERR;
	schar *xp = (schar *)(*xpp);

	while(nelems-- != 0)
	{
		if (*xp < 0) status = NC_ERANGE;
		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}


int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);

	return ENOERR;

}
int
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);

	return ENOERR;

}
int
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if (*xp < 0) status = NC_ERANGE;
		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if (*xp < 0) status = NC_ERANGE;
		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if (*xp < 0) status = NC_ERANGE;
		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}


int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	return ENOERR;

}
int
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	return ENOERR;

}
int
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
	int status = ENOERR;
	schar *xp = (schar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}


int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	if(rndup)
	{
		(void) memcpy(*xpp, nada, rndup);
		*xpp = (void *)((char *)(*xpp) + rndup);
	}

	return ENOERR;

}
int
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	if(rndup)
	{
		(void) memcpy(*xpp, nada, rndup);
		*xpp = (void *)((char *)(*xpp) + rndup);
	}

	return ENOERR;

}
int
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	schar *xp = (schar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_SCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (schar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}



/* uchar ---------------------------------------------------------------------*/
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);
	return ENOERR;

}
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);
	return ENOERR;

}
int
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}

int
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *)(*xpp);

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (const void *)xp;
	return status;
}


int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);

	return ENOERR;

}
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);

	return ENOERR;

}
int
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}

int
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{

		*tp++ = *xp++;
	}

	*xpp = (void *)(xp + rndup);
	return status;
}


int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	return ENOERR;

}
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	return ENOERR;

}
int
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
	int status = ENOERR;
	uchar *xp = (uchar *) *xpp;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}

	*xpp = (void *)xp;
	return status;
}


int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	if(rndup)
	{
		(void) memcpy(*xpp, nada, rndup);
		*xpp = (void *)((char *)(*xpp) + rndup);
	}

	return ENOERR;

}
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	if(rndup)
	{
		(void) memcpy(*xpp, nada, rndup);
		*xpp = (void *)((char *)(*xpp) + rndup);
	}

	return ENOERR;

}
int
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX || *tp < 0)
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
	int status = ENOERR;
	size_t rndup = nelems % X_ALIGN;
	uchar *xp = (uchar *) *xpp;

	if(rndup)
		rndup = X_ALIGN - rndup;

	while(nelems-- != 0)
	{
		if(*tp > X_UCHAR_MAX )
			status = NC_ERANGE;
		*xp++ = (uchar) *tp++;
	}


	if(rndup)
	{
		(void) memcpy(xp, nada, rndup);
		xp += rndup;
	}

	*xpp = (void *)xp;
	return status;
}


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(short));
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return ENOERR;
}
#else
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

#endif
int
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (short *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


int
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		const int lstatus = ncx_get_short_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_SHORT;
	*xpp = (void *)xp;
	return status;
}


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return ENOERR;
}
#else
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

#endif
int
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  short tmp[LOOPCNT];        /* in case input is misaligned */
  short *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_SHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (short *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_SHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
      xp = (short *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}


int
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
	{
		int lstatus = ncx_put_short_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
		xp += X_SIZEOF_SHORT;
	}

	*xpp = (void *)xp;
	return status;
}



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(unsigned short));
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return ENOERR;
}
#else
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

#endif
int
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ushort *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


int
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
	const size_t rndup = nelems % 2;

	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
		xp += X_SIZEOF_USHORT;
	*xpp = (void *)xp;
	return status;
}


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return ENOERR;
}
#else
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

#endif
int
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
  ushort *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_USHORT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ushort *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_USHORT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
      xp = (ushort *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}


int
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}

int
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp)
{
	const size_t rndup = nelems % 2;

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
	{
		int lstatus = ncx_put_ushort_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	if(rndup != 0)
	{
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
		xp += X_SIZEOF_USHORT;
	}

	*xpp = (void *)xp;
	return status;
}



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(int));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return ENOERR;
}
#else
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

#endif
int
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (int *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return ENOERR;
}
#else
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

#endif
int
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  double d;               /* special case for ncx_putn_int_float */
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* for some reason int to float, for putn, requires a special case */
      d = tp[i];
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_INT == SIZEOF_INT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  int tmp[LOOPCNT];        /* in case input is misaligned */
  int *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_INT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (int *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_INT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
      xp = (int *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
	{
		int lstatus = ncx_put_int_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(uint));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return ENOERR;
}
#else
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

#endif
int
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (uint *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return ENOERR;
}
#else
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

#endif
int
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  uint tmp[LOOPCNT];        /* in case input is misaligned */
  uint *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_UINT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (uint *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_UINT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
      xp = (uint *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
	{
		int lstatus = ncx_put_uint_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(float));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return ENOERR;
}
#elif vax
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while(ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
		const struct ieee_single *const isp =
			 (const struct ieee_single *) (*xpp);
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;

		switch(exp) {
		case 0 :
			/* ieee subnormal */
			if(isp->mant_hi == min.ieee.mant_hi
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
			{
				*vsp = min.s;
			}
			else
			{
				unsigned mantissa = (isp->mant_hi << 16)
					 | isp->mant_lo_hi << 8
					 | isp->mant_lo_lo;
				unsigned tmp = mantissa >> 20;
				if(tmp >= 4) {
					vsp->exp = 2;
				} else if (tmp >= 2) {
					vsp->exp = 1;
				} else {
					*vsp = min.s;
					break;
				} /* else */
				tmp = mantissa - (1 << (20 + vsp->exp ));
				tmp <<= 3 - vsp->exp;
				vsp->mantissa2 = tmp;
				vsp->mantissa1 = (tmp >> 16);
			}
			break;
		case 0xfe :
		case 0xff :
			*vsp = max.s;
			break;
		default :
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
			vsp->mantissa1 = isp->mant_hi;
		}

		vsp->sign = isp->sign;


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return ENOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (float *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return ENOERR;
}
#elif vax
int
ncx_putn_float_float(void **xpp, size_t nfloats, const float *ip)
{
	const float *const end = ip + nfloats;

	while(ip < end)
	{
		const struct vax_single *const vsp =
			 (const struct vax_single *)ip;
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);

		switch(vsp->exp){
		case 0 :
			/* all vax float with zero exponent map to zero */
			*isp = min.ieee;
			break;
		case 2 :
		case 1 :
		{
			/* These will map to subnormals */
			unsigned mantissa = (vsp->mantissa1 << 16)
					 | vsp->mantissa2;
			mantissa >>= 3 - vsp->exp;
			mantissa += (1 << (20 + vsp->exp));
			isp->mant_lo_lo = mantissa;
			isp->mant_lo_hi = mantissa >> 8;
			isp->mant_hi = mantissa >> 16;
			isp->exp_lo = 0;
			isp->exp_hi = 0;
		}
			break;
		case 0xff : /* max.s.exp */
			if( vsp->mantissa2 == max.s.mantissa2
				&& vsp->mantissa1 == max.s.mantissa1)
			{
				/* map largest vax float to ieee infinity */
				*isp = max.ieee;
				break;
			} /* else, fall thru */
		default :
		{
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
			isp->exp_hi = exp >> 1;
			isp->exp_lo = exp;
			isp->mant_lo_lo = vsp->mantissa2;
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
			isp->mant_hi = vsp->mantissa1;
		}
		}

		isp->sign = vsp->sign;


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return ENOERR;
}
#else
int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp)
{
	char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  float tmp[LOOPCNT];        /* in case input is misaligned */
  float *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_FLOAT;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (float *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_FLOAT_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
      xp = (float *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(double));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return ENOERR;
}
#elif vax
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while(ip < end)
	{
	struct vax_double *const vdp =
			 (struct vax_double *)ip;
	const struct ieee_double *const idp =
			 (const struct ieee_double *) (*xpp);
	{
		const struct dbl_limits *lim;
		int ii;
		for (ii = 0, lim = dbl_limits;
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
			ii++, lim++)
		{
			if ((idp->mant_lo == lim->ieee.mant_lo)
				&& (idp->mant_4 == lim->ieee.mant_4)
				&& (idp->mant_5 == lim->ieee.mant_5)
				&& (idp->mant_6 == lim->ieee.mant_6)
				&& (idp->exp_lo == lim->ieee.exp_lo)
				&& (idp->exp_hi == lim->ieee.exp_hi)
				)
			{
				*vdp = lim->d;
				goto doneit;
			}
		}
	}
	{
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
	}
	{
		unsigned mant_hi = ((idp->mant_6 << 16)
				 | (idp->mant_5 << 8)
				 | idp->mant_4);
		unsigned mant_lo = SWAP4(idp->mant_lo);
		vdp->mantissa1 = (mant_hi >> 13);
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
				| (mant_lo >> 29);
		vdp->mantissa3 = (mant_lo >> 13);
		vdp->mantissa4 = (mant_lo << 3);
	}
	doneit:
		vdp->sign = idp->sign;

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return ENOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (double *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return ENOERR;
}
#elif vax
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip)
{
	const double *const end = ip + ndoubles;

	while(ip < end)
	{
	const struct vax_double *const vdp =
			(const struct vax_double *)ip;
	struct ieee_double *const idp =
			 (struct ieee_double *) (*xpp);

	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
		(vdp->exp == dbl_limits[0].d.exp))
	{
		*idp = dbl_limits[0].ieee;
		goto shipit;
	}
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
		(vdp->exp == dbl_limits[1].d.exp))
	{
		*idp = dbl_limits[1].ieee;
		goto shipit;
	}

	{
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;

		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
			(vdp->mantissa3 << 13) |
			((vdp->mantissa4 >> 3) & MASK(13));

		unsigned mant_hi = (vdp->mantissa1 << 13)
				 | (vdp->mantissa2 >> 3);

		if((vdp->mantissa4 & 7) > 4)
		{
			/* round up */
			mant_lo++;
			if(mant_lo == 0)
			{
				mant_hi++;
				if(mant_hi > 0xffffff)
				{
					mant_hi = 0;
					exp++;
				}
			}
		}

		idp->mant_lo = SWAP4(mant_lo);
		idp->mant_6 = mant_hi >> 16;
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
		idp->mant_4 = mant_hi;
		idp->exp_hi = exp >> 4;
		idp->exp_lo = exp;
	}

	shipit:
		idp->sign = vdp->sign;

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return ENOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp)
{
	char *xp = *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  double tmp[LOOPCNT];        /* in case input is misaligned */
  double *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_DOUBLE;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (double *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_DOUBLE_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
      xp = (double *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}



/* longlong -----------------------------------------------------------------------*/

#if X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(long long));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_LONGLONG);
	return ENOERR;
}
#else
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

#endif
int
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
    }
   /* update xpp and tp */
    if (realign) xp = (longlong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


#if X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_LONGLONG);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_LONGLONG);
	return ENOERR;
}
#else
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

#endif
int
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
  longlong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_LONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (longlong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_LONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
      xp = (longlong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
	{
		int lstatus = ncx_put_longlong_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}


/* ulonglong ----------------------------------------------------------------------*/

#if X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(unsigned long long));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_ULONGLONG);
	return ENOERR;
}
#else
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > ULONGLONG_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

#endif
int
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SCHAR_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > SHORT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > INT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > FLOAT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > DOUBLE_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > LONGLONG_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UCHAR_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > USHORT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}

int
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of input data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update xpp to point at next unconverted input, and tp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
      nrange += xp[i] > UINT_MAX ;
    }
   /* update xpp and tp */
    if (realign) xp = (ulonglong *) *xpp;
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */
	const char *xp = (const char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
#  endif
}


#if X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_ULONGLONG);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_ULONGLONG);
	return ENOERR;
}
#else
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

#endif
int
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_schar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_short(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_int(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_float(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_double(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_longlong(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_uchar(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_ushort(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}

int
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp)
{
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG

 /* basic algorithm is:
  *   - ensure sane alignment of output data
  *   - copy (conversion happens automatically) input data
  *     to output
  *   - update tp to point at next unconverted input, and xpp to point
  *     at next location for converted output
  */
  long i, j, ni;
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
  ulonglong *xp;
  int nrange = 0;         /* number of range errors */
  int realign = 0;        /* "do we need to fix input data alignment?" */
  long cxp = (long) *((char**)xpp);

  realign = (cxp & 7) % SIZEOF_ULONGLONG;
  /* sjl: manually stripmine so we can limit amount of
   * vector work space reserved to LOOPCNT elements. Also
   * makes vectorisation easy */
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
    ni=Min(nelems-j,LOOPCNT);
    if (realign) {
      xp = tmp;
    } else {
      xp = (ulonglong *) *xpp;
    }
   /* copy the next block */
#pragma cdir loopcnt=LOOPCNT
#pragma cdir shortloop
    for (i=0; i<ni; i++) {
      /* the normal case: */
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
     /* test for range errors (not always needed but do it anyway) */
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
      nrange += tp[i] > X_ULONGLONG_MAX ;
    }
   /* copy workspace back if necessary */
    if (realign) {
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
      xp = (ulonglong *) *xpp;
    }
   /* update xpp and tp */
    xp += ni;
    tp += ni;
    *xpp = (void*)xp;
  }
  return nrange == 0 ? ENOERR : NC_ERANGE;

#else   /* not SX */

	char *xp = (char *) *xpp;
	int status = ENOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
	{
		int lstatus = ncx_put_ulonglong_uint(xp, tp);
		if(lstatus != ENOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
#endif
}



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);
	return ENOERR;

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);

	return ENOERR;

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	return ENOERR;

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	if(rndup)
	{
		(void) memcpy(*xpp, nada, rndup);
		*xpp = (void *)((char *)(*xpp) + rndup);
	}

	return ENOERR;

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);
	return ENOERR;

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(tp, *xpp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);

	return ENOERR;

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	return ENOERR;

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;

	if(rndup)
		rndup = X_ALIGN - rndup;

	(void) memcpy(*xpp, tp, nelems);
	*xpp = (void *)((char *)(*xpp) + nelems);

	if(rndup)
	{
		(void) memcpy(*xpp, nada, rndup);
		*xpp = (void *)((char *)(*xpp) + rndup);
	}

	return ENOERR;

}
