<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/icecast/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/icecast/metadata.yaml"
sidebar_label: "Icecast"
learn_status: "Published"
learn_rel_path: "Data Collection/Media Services"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Icecast


<img src="https://netdata.cloud/img/icecast.svg" width="150"/>


Plugin: python.d.plugin
Module: icecast

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Icecast listener counts.

It connects to an icecast URL and uses the `status-json.xsl` endpoint to retrieve statistics.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

Without configuration, the collector attempts to connect to http://localhost:8443/status-json.xsl

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Icecast instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| icecast.listeners | a dimension for each active source | listeners |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Icecast minimum version

Needs at least icecast version >= 2.4.0


### Configuration

#### File

The configuration file name for this integration is `python.d/icecast.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/icecast.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | False |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | False |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | False |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | False |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | False |
| url | The URL (and port) to the icecast server. Needs to also include `/status-json.xsl` | http://localhost:8443/status-json.xsl | False |
| user | Username to use to connect to `url` if it's password protected. |  | False |
| pass | Password to use to connect to `url` if it's password protected. |  | False |

</details>

#### Examples

##### Remote Icecast server

Configure a remote icecast server

```yaml
remote:
 url: 'http://1.2.3.4:8443/status-json.xsl'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `icecast` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin icecast debug trace
  ```


