#ifndef _EXPECT_NETWORK_H
#define _EXPECT_NETWORK_H

/* expect_network.h
 
   Definitions for the expect_network command

   Copyright (C) 2007, 2008, 2009, 2010 Eloy Paris

   This is part of Network Expect

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

enum {
    NEXP_TEMPORARY =  1,    /* expect */
    NEXP_PERMANENT	    /* expect_after, expect_before, expect_bg */
};

enum{
    NEXP_CMD_BEFORE,
    NEXP_CMD_AFTER,
    NEXP_CMD_BG,
    NEXP_CMD_FG
};

enum pattern_types {
    PAT_EOF,
    PAT_TIMEOUT,
    PAT_DEFAULT,
    PAT_FULLBUFFER,
    PAT_EXPR
};

/* To access the Tcl "timeout" variable */
#define TIMEOUT_VARNAME  "timeout"

/*
 * One ecase struct is reserved for each case in the expect command. Note
 * that eof/timeout don't use any of theirs, but the algorithm is simpler
 * this way.
 */
struct ecase {	/* case for expect command */
    struct nexp_listener *listener;

    Tcl_Obj *pat;	/* original pattern spec */
    Tcl_Obj *body;	/* ptr to body to be executed upon match */
    enum pattern_types use; /* PAT_XXX */
    int transfer;	/* if false, leave matched chars in input stream */
    int indices;	/* if true, write indices */
    int iread;		/* if true, reread indirects */
    int timestamp;	/* if true, write timestamps */
};

/* This describes an expect command */
struct nexp_cmd_descriptor {
    int cmdtype;			/* fg, bg, before, after */
    int duration;			/* permanent or temporary */
    int timeout_specified_by_flag;	/* if -timeout flag used */
    double timeout;			/* timeout period if flag used */

    /* struct nexp_cases_descriptor ecd; */
    int ncases;			/* Number of expect cases */
    struct ecase **cases;	/* Array of pointers to ecases */
};

extern void nexp_init_expect_cmds(Tcl_Interp *);

#endif /* _EXPECT_NETWORK_H */
