---
id: fast-element
title: fast-element 
hide_title: false
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->



## Classes

|  Class | Description |
|  --- | --- |
|  [AttachedBehaviorHTMLDirective](./fast-element.attachedbehaviorhtmldirective.md) | A directive that attaches special behavior to an element via a custom attribute. |
|  [AttributeDefinition](./fast-element.attributedefinition.md) | An implementation of [Accessor](./fast-element.accessor.md) that supports reactivity, change callbacks, attribute reflection, and type conversion for custom elements. |
|  [BindingBehavior](./fast-element.bindingbehavior.md) | A behavior that updates content and attributes based on a configured BindingDirective. |
|  [ChildrenBehavior](./fast-element.childrenbehavior.md) | The runtime behavior for child node observation. |
|  [Controller](./fast-element.controller.md) | Controls the lifecycle and rendering of a <code>FASTElement</code>. |
|  [CSSDirective](./fast-element.cssdirective.md) | Directive for use in [css()](./fast-element.css.md)<!-- -->. |
|  [ElementStyles](./fast-element.elementstyles.md) | Represents styles that can be applied to a custom element. |
|  [ExecutionContext](./fast-element.executioncontext.md) | Provides additional contextual information available to behaviors and expressions. |
|  [FASTElementDefinition](./fast-element.fastelementdefinition.md) | Defines metadata for a FASTElement. |
|  [HTMLBindingDirective](./fast-element.htmlbindingdirective.md) | A directive that configures data binding to element content and attributes. |
|  [HTMLDirective](./fast-element.htmldirective.md) | Instructs the template engine to apply behavior to a node. |
|  [HTMLView](./fast-element.htmlview.md) | The standard View implementation, which also implements ElementView and SyntheticView. |
|  [PropertyChangeNotifier](./fast-element.propertychangenotifier.md) | An implementation of Notifier that allows subscribers to be notified of individual property changes on an object. |
|  [RefBehavior](./fast-element.refbehavior.md) | The runtime behavior for template references. |
|  [RepeatBehavior](./fast-element.repeatbehavior.md) | A behavior that renders a template for each item in an array. |
|  [RepeatDirective](./fast-element.repeatdirective.md) | A directive that configures list rendering. |
|  [SlottedBehavior](./fast-element.slottedbehavior.md) | The runtime behavior for slotted node observation. |
|  [SubscriberSet](./fast-element.subscriberset.md) | An implementation of [Notifier](./fast-element.notifier.md) that efficiently keeps track of subscribers interested in a specific change notification on an observable source. |
|  [TargetedHTMLDirective](./fast-element.targetedhtmldirective.md) | A [HTMLDirective](./fast-element.htmldirective.md) that targets a named attribute or property on a node. |
|  [ViewTemplate](./fast-element.viewtemplate.md) | A template capable of creating HTMLView instances or rendering directly to DOM. |

## Functions

|  Function | Description |
|  --- | --- |
|  [attr(config)](./fast-element.attr.md) | Decorator: Specifies an HTML attribute. |
|  [attr(target, prop)](./fast-element.attr_1.md) | Decorator: Specifies an HTML attribute. |
|  [children(propertyOrOptions)](./fast-element.children.md) | A directive that observes the <code>childNodes</code> of an element and updates a property whenever they change. |
|  [compileTemplate(template, directives)](./fast-element.compiletemplate.md) | Compiles a template and associated directives into a raw compilation result which include a cloneable DocumentFragment and factories capable of attaching runtime behavior to nodes within the fragment. |
|  [css(strings, values)](./fast-element.css.md) | Transforms a template literal string into styles. |
|  [cssPartial(strings, values)](./fast-element.csspartial.md) | Transforms a template literal string into partial CSS. |
|  [customElement(nameOrDef)](./fast-element.customelement.md) | Decorator: Defines a platform custom element based on <code>FASTElement</code>. |
|  [elements(selector)](./fast-element.elements.md) | Creates a function that can be used to filter a Node array, selecting only elements. |
|  [enableArrayObservation()](./fast-element.enablearrayobservation.md) | Enables the array observation mechanism. |
|  [html(strings, values)](./fast-element.html.md) | Transforms a template literal string into a renderable ViewTemplate. |
|  [observable(target, nameOrAccessor)](./fast-element.observable.md) | Decorator: Defines an observable property on the target. |
|  [ref(propertyName)](./fast-element.ref.md) | A directive that observes the updates a property with a reference to the element. |
|  [repeat(itemsBinding, templateOrTemplateBinding, options)](./fast-element.repeat.md) | A directive that enables list rendering. |
|  [slotted(propertyOrOptions)](./fast-element.slotted.md) | A directive that observes the <code>assignedNodes()</code> of a slot and updates a property whenever they change. |
|  [volatile(target, name, descriptor)](./fast-element.volatile.md) | Decorator: Marks a property getter as having volatile observable dependencies. |
|  [when(binding, templateOrTemplateBinding)](./fast-element.when.md) | A directive that enables basic conditional rendering in a template. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [Accessor](./fast-element.accessor.md) | Represents a getter/setter property accessor on an object. |
|  [Behavior](./fast-element.behavior.md) | Represents and object that can contribute behavior to a view or element's bind/unbind operations. |
|  [BindingObserver](./fast-element.bindingobserver.md) | Enables evaluation of and subscription to a binding. |
|  [CaptureType](./fast-element.capturetype.md) | A marker interface used to capture types when interpolating Directive helpers into templates. |
|  [ChildListBehaviorOptions](./fast-element.childlistbehavioroptions.md) | The options used to configure child list observation. |
|  [CompilationResult](./fast-element.compilationresult.md) | <b><i>(BETA)</i></b> The result of compiling a template and its directives. |
|  [ElementView](./fast-element.elementview.md) | A View representing DOM nodes specifically for rendering the view of a custom element. |
|  [ElementViewTemplate](./fast-element.elementviewtemplate.md) | A template capable of creating views specifically for rendering custom elements. |
|  [FASTElement](./fast-element.fastelement.md) | Represents a custom element based on the FASTElement infrastructure. |
|  [NodeBehaviorFactory](./fast-element.nodebehaviorfactory.md) | A factory that can create a [Behavior](./fast-element.behavior.md) associated with a particular location within a DOM fragment. |
|  [NodeBehaviorOptions](./fast-element.nodebehavioroptions.md) | Options for configuring node observation behavior. |
|  [Notifier](./fast-element.notifier.md) | Provides change notification for a source object. |
|  [ObservationRecord](./fast-element.observationrecord.md) | A record of observable property access. |
|  [PartialFASTElementDefinition](./fast-element.partialfastelementdefinition.md) | Represents metadata configuration for a custom element. |
|  [RepeatOptions](./fast-element.repeatoptions.md) | Options for configuring repeat behavior. |
|  [SlottedBehaviorOptions](./fast-element.slottedbehavioroptions.md) | The options used to configure slotted node observation. |
|  [Splice](./fast-element.splice.md) | Represents a set of splice-based changes against an Array. |
|  [StyleTarget](./fast-element.styletarget.md) | A node that can be targeted by styles. |
|  [Subscriber](./fast-element.subscriber.md) | Implemented by objects that are interested in change notifications. |
|  [SubtreeBehaviorOptions](./fast-element.subtreebehavioroptions.md) | The options used to configure subtree observation. |
|  [SyntheticView](./fast-element.syntheticview.md) | A view representing a range of DOM nodes which can be added/removed ad hoc. |
|  [SyntheticViewTemplate](./fast-element.syntheticviewtemplate.md) | A template capable of rendering views not specifically connected to custom elements. |
|  [ValueConverter](./fast-element.valueconverter.md) | Represents objects that can convert values to and from view or model representations. |
|  [View](./fast-element.view.md) | Represents a collection of DOM nodes which can be bound to a data source. |

## Variables

|  Variable | Description |
|  --- | --- |
|  [$global](./fast-element._global.md) | A reference to globalThis, with support for browsers that don't yet support the spec. |
|  [booleanConverter](./fast-element.booleanconverter.md) | A [ValueConverter](./fast-element.valueconverter.md) that converts to and from <code>boolean</code> values. |
|  [defaultExecutionContext](./fast-element.defaultexecutioncontext.md) | The default execution context used in binding expressions. |
|  [DOM](./fast-element.dom.md) | Common DOM APIs. |
|  [FASTElement](./fast-element.fastelement.md) | A minimal base class for FASTElements that also provides static helpers for working with FASTElements. |
|  [nullableNumberConverter](./fast-element.nullablenumberconverter.md) | A [ValueConverter](./fast-element.valueconverter.md) that converts to and from <code>number</code> values. |
|  [Observable](./fast-element.observable.md) | Common Observable APIs. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AttachedBehaviorType](./fast-element.attachedbehaviortype.md) | Describes the shape of a behavior constructor that can be created by an [AttachedBehaviorHTMLDirective](./fast-element.attachedbehaviorhtmldirective.md)<!-- -->. |
|  [AttributeConfiguration](./fast-element.attributeconfiguration.md) | Metadata used to configure a custom attribute's behavior. |
|  [AttributeMode](./fast-element.attributemode.md) | The mode that specifies the runtime behavior of the attribute. |
|  [Binding](./fast-element.binding.md) | The signature of an arrow function capable of being evaluated as part of a template binding update. |
|  [Callable](./fast-element.callable.md) | Represents a callable type such as a function or an object with a "call" method. |
|  [ChildrenBehaviorOptions](./fast-element.childrenbehavioroptions.md) | The options used to configure child/subtree node observation. |
|  [ComposableStyles](./fast-element.composablestyles.md) | Represents styles that can be composed into the ShadowDOM of a custom element. |
|  [Constructable](./fast-element.constructable.md) | Allows for the creation of Constructable mixin classes. |
|  [DecoratorAttributeConfiguration](./fast-element.decoratorattributeconfiguration.md) | Metadata used to configure a custom attribute's behavior through a decorator. |
|  [ElementsFilter](./fast-element.elementsfilter.md) | Elements filter function type. |
|  [ElementStyleFactory](./fast-element.elementstylefactory.md) | Creates an ElementStyles instance for an array of ComposableStyles. |
|  [Global](./fast-element.global.md) | The platform global type. |
|  [TemplateValue](./fast-element.templatevalue.md) | Represents the types of values that can be interpolated into a template. |
|  [TrustedTypes](./fast-element.trustedtypes.md) | Enables working with trusted types. |
|  [TrustedTypesPolicy](./fast-element.trustedtypespolicy.md) | A policy for use with the standard trustedTypes platform API. |
