# {%= name %} {%= badge("fury") %} {%= badge("travis") %}

> {%= description %}

Visit the MSDN reference for [Common Data Types 2.2.57 UNC](https://msdn.microsoft.com/en-us/library/gg465305.aspx) for more information about UNC paths.

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
// unc-path-regex returns a function
var regex = require('{%= name %}')();
```

**true**

Returns true for windows UNC paths:

```js
regex.test('\\/foo/bar');
regex.test('\\\\foo/bar');
regex.test('\\\\foo\\admin$');
regex.test('\\\\foo\\admin$\\system32');
regex.test('\\\\foo\\temp');
regex.test('\\\\/foo/bar');
regex.test('\\\\\\/foo/bar');
```

**false**

Returns false for non-UNC paths:

```js
regex.test('/foo/bar');
regex.test('/');
regex.test('/foo');
regex.test('/foo/');
regex.test('c:');
regex.test('c:.');
regex.test('c:./');
regex.test('c:./file');
regex.test('c:/');
regex.test('c:/file');
```

## Related projects
{%= related(verb.related.list, {remove: name}) %}  

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
