/*
 * Copyright (c) 2006, 2007 INRIA
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation;
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Author: Mathieu Lacage <mathieu.lacage@sophia.inria.fr>
 */
#include "constant-velocity-mobility-model.h"

#include "ns3/simulator.h"

namespace ns3
{

NS_OBJECT_ENSURE_REGISTERED(ConstantVelocityMobilityModel);

TypeId
ConstantVelocityMobilityModel::GetTypeId()
{
    static TypeId tid = TypeId("ns3::ConstantVelocityMobilityModel")
                            .SetParent<MobilityModel>()
                            .SetGroupName("Mobility")
                            .AddConstructor<ConstantVelocityMobilityModel>();
    return tid;
}

ConstantVelocityMobilityModel::ConstantVelocityMobilityModel()
{
}

ConstantVelocityMobilityModel::~ConstantVelocityMobilityModel()
{
}

void
ConstantVelocityMobilityModel::SetVelocity(const Vector& speed)
{
    m_helper.Update();
    m_helper.SetVelocity(speed);
    m_helper.Unpause();
    NotifyCourseChange();
}

Vector
ConstantVelocityMobilityModel::DoGetPosition() const
{
    m_helper.Update();
    return m_helper.GetCurrentPosition();
}

void
ConstantVelocityMobilityModel::DoSetPosition(const Vector& position)
{
    m_helper.SetPosition(position);
    NotifyCourseChange();
}

Vector
ConstantVelocityMobilityModel::DoGetVelocity() const
{
    return m_helper.GetVelocity();
}

} // namespace ns3
