/* NVTV NV TV-I2C access header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: tv_nv.h,v 1.11 2003/10/10 16:16:57 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Routines to control the TV and the I2C bus on a NVidia
 * card, as well as other CRT/TV mode related register programming.
 * 
 */

#ifndef _TV_NV_H
#define _TV_NV_H

#include "tv_chip.h"
#include "nv_type.h"

CARD8 readCrtNv (NVPtr pNv, int head, int reg);
void writeCrtNv (NVPtr pNv, int head, int reg, CARD8 val);
void orCrtNv (NVPtr pNv, int head, int reg, CARD8 val);
void andCrtNv (NVPtr pNv, int head, int reg, CARD8 val);

CARD8 NVReadGr(NVPtr pNv, CARD8 index);
CARD8 NVReadSeq(NVPtr pNv, CARD8 index);
CARD8 NVReadAttr(NVPtr pNv, int head, CARD8 index);
CARD8 NVReadMiscOut(NVPtr pNv);

Bool XBoxBusInit (NVPtr pNv);
Bool NVTvBusInit (NVPtr pNv);

void NVUpdateTvState (NVPtr pNv);

I2CChainPtr NVFindTvDevice (NVPtr pNv, TVChip chip);
void NVSetTvDevice (NVPtr pNv, I2CChainPtr chain, Bool init);

void NVDestroyDevices (NVPtr pNv);
void NVDestroyBusses (NVPtr pNv);

void NVProbeTvDevices (NVPtr pNv);

int NVSetTvHead (NVPtr pNv, int head);
void NVSetVideoHead (NVPtr pNv, int head);

void NVSetCrtRegs (NVPtr pNv, int head, TVNvRegs *r);
void NVGetCrtRegs (NVPtr pNv, int head, TVNvRegs *r);

void NVSetCrtLayout (NVPtr pNv, int head, int addr, int ofs);
void NVGetCrtLayout (NVPtr pNv, int head, int *paddr, int *pofs);

int NVGetDevFlags (NVPtr pNv, int head);

long NVGetClock (NVPtr pNv, int head);
long NVSetClock (NVPtr pNv, int head, long clock);
long NVModifyClock (NVPtr pNv, int head, long clock);

void NVGetAllRegs (NVPtr pNv, int head, TVRegs *r);
void NVSetAllRegs (NVPtr pNv, int head, TVRegs *r);

void NVGetEncRegsPort (NVPtr pNv, TVEncoderRegs *r, int *port);
void NVGetPort (NVPtr pNv, int *port);

void NVSetVideoPointOut (NVPtr pNv, int x, int y);
void NVGetVideoPointOut (NVPtr pNv, int *x, int *y);

void NVSetCursorPos (NVPtr pNv, int head, int x, int y);
void NVGetCursorPos (NVPtr pNv, int head, int *x, int *y);

Bool NVVertIntrEnabled (NVPtr pNv, int head);

void NVCopyHead (NVPtr pNv, int fromHead, int toHead);

void NVCopyCursor (NVPtr pNv, int fromHead, int toHead);

void NVSetTestImage (NVPtr pNv, TVEncoderRegs *r);
void NVSetTvMode (NVPtr pNv, TVRegs *r);
void XBoxSetTvMode (NVPtr pNv, TVRegs *r);

long NVGetTvStatus (NVPtr pNv, int index);
TVConnect NVGetTvConnect (NVPtr pNv);

#endif /* _TV_NV_H */
