/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.pool;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.db.adapter.DB;
import org.apache.turbine.util.db.adapter.DBFactory;
import org.apache.turbine.util.db.pool.ConnectionWaitTimeoutException;
import org.apache.turbine.util.db.pool.DBConnection;

public class ConnectionPool {
    private Stack pool = new Stack();
    private String driver = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private int totalConnections = 0;
    private int maxConnections = 10;
    private long expiryTime = 3600000L;
    private long maxConnectionAttempts = 50L;
    private long connectionAttemptsCounter = 0L;
    private long dbCheckFrequency = 5000L;
    private DB db = null;
    private long connectionWaitTimeout = 10000L;
    private ConnectionPoolDataSource cpds = null;

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        try {
            return (PooledConnection)((Object)this.getConnection());
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        try {
            return (PooledConnection)((Object)this.getConnection(this.driver, this.url, user, password));
        }
        catch (Exception e) {
            throw new SQLException(e.toString());
        }
    }

    public final synchronized DBConnection getConnection() throws Exception {
        DBConnection dbconn = null;
        dbconn = this.pool.empty() && this.totalConnections < this.maxConnections ? this.getNewConnection() : this.getInternalPooledConnection();
        dbconn.link(this);
        return dbconn;
    }

    public final synchronized DBConnection getConnection(String driver, String url, String username, String password) throws Exception {
        if (this.driver == null && this.url == null && this.username == null && this.password == null) {
            this.driver = driver;
            this.url = url;
            this.username = username;
            this.password = password;
        }
        return this.getConnection();
    }

    public DB getDB() throws Exception {
        if (this.db == null) {
            this.db = DBFactory.create(this.driver);
            this.db.init(this.url, this.username, this.password);
        }
        return this.db;
    }

    public PrintWriter getLogWriter() throws SQLException {
        if (this.cpds != null) {
            return this.cpds.getLogWriter();
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.cpds != null) {
            this.cpds.setLogWriter(out);
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.connectionWaitTimeout = new Integer(seconds).longValue() * 1000L;
    }

    public int getLoginTimeout() throws SQLException {
        return new Long(this.connectionWaitTimeout).intValue() / 1000;
    }

    protected DBConnection getNewConnection() throws Exception {
        if (this.cpds != null) {
            PooledConnection pc = this.cpds.getPooledConnection(this.username, this.password);
            DBConnection dbc = new DBConnection(pc, this.url, null, null);
            ++this.totalConnections;
            return dbc;
        }
        DBConnection dbc = new DBConnection(this.getDB().getConnection(), this.url);
        ++this.totalConnections;
        return dbc;
    }

    private DBConnection popConnection() throws Exception {
        while (!this.pool.empty()) {
            DBConnection con = (DBConnection)this.pool.pop();
            if (this.isValid(con)) {
                this.connectionAttemptsCounter = 0L;
                return con;
            }
            con.close();
            --this.totalConnections;
            this.connectionAttemptsCounter = 0L;
            if (!this.pool.empty()) continue;
            return this.getNewConnection();
        }
        throw new Exception("Assertaion failure: Attempted to pop connection from empty pool!");
    }

    private synchronized DBConnection getInternalPooledConnection() throws ConnectionWaitTimeoutException, Exception {
        DBConnection dbconn = null;
        if (this.pool.empty()) {
            ++this.connectionAttemptsCounter;
            try {
                this.wait(this.connectionWaitTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.pool.empty()) {
                throw new ConnectionWaitTimeoutException(this.url);
            }
            dbconn = this.popConnection();
        } else {
            dbconn = this.popConnection();
        }
        return dbconn;
    }

    private boolean isExpired(DBConnection connection) throws Exception {
        return System.currentTimeMillis() - connection.getTimestamp() > this.expiryTime;
    }

    private boolean isValid(DBConnection connection) throws Exception {
        try {
            connection.getConnection();
            return !this.isExpired(connection);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public synchronized void releaseConnection(DBConnection dbconn) throws Exception {
        dbconn.unlink(this);
        if (this.isValid(dbconn)) {
            this.pool.push(dbconn);
            this.notify();
        } else {
            try {
                try {
                    dbconn.close();
                }
                catch (Exception ignored) {
                    Object var3_3 = null;
                    this.decrementConnections();
                }
                Object var3_2 = null;
                this.decrementConnections();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.decrementConnections();
                throw throwable;
            }
        }
    }

    public void shutdown() {
        if (this.pool != null) {
            while (!this.pool.isEmpty()) {
                Object var2_1;
                try {
                    try {
                        ((DBConnection)this.pool.pop()).close();
                    }
                    catch (SQLException sQLException) {
                        var2_1 = null;
                        --this.totalConnections;
                        continue;
                    }
                    var2_1 = null;
                    --this.totalConnections;
                }
                catch (Throwable throwable) {
                    var2_1 = null;
                    --this.totalConnections;
                    throw throwable;
                }
            }
        }
    }

    public int getTotalCount() {
        return this.totalConnections;
    }

    public int getNbrAvailable() {
        return this.pool.size();
    }

    public int getNbrCheckedOut() {
        return this.totalConnections - this.pool.size();
    }

    public void decrementConnections() {
        --this.totalConnections;
        this.notify();
    }

    public ConnectionPool() {
        this(null, null, null, null);
    }

    public ConnectionPool(int maxCons, long expiryTime) {
        this(null, null, null, null, maxCons, expiryTime);
    }

    public ConnectionPool(String driver, String url, String username, String password) {
        this.maxConnections = TurbineResources.getInt("database.maxConnections", 10);
        this.expiryTime = TurbineResources.getLong("database.expiryTime", 3600000L);
        this.maxConnectionAttempts = TurbineResources.getLong("database.maxConnectionAttempts", 50L);
        this.connectionWaitTimeout = TurbineResources.getLong("database.connectionWaitTimeout", 10000L);
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        try {
            this.cpds = this.getDB().getConnectionPoolDataSource();
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }

    public ConnectionPool(String driver, String url, String username, String password, int maxCons, long expiryTime) {
        this.driver = driver;
        this.url = url;
        this.username = username;
        this.password = password;
        this.maxConnections = maxCons;
        this.expiryTime = expiryTime;
        this.maxConnectionAttempts = TurbineResources.getLong("database.maxConnectionAttempts", 50L);
        this.connectionWaitTimeout = TurbineResources.getLong("database.connectionWaitTimeout", 10000L);
        try {
            this.cpds = this.getDB().getConnectionPoolDataSource();
        }
        catch (Exception ignore) {
            // empty catch block
        }
    }
}

