/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2011 NoMachine (http://www.nomachine.com)          */
/* Copyright (c) 2008-2014 Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>  */
/* Copyright (c) 2011-2016 Mike Gabriel <mike.gabriel@das-netzwerkteam.de>*/
/* Copyright (c) 2014-2016 Mihai Moldovan <ionic@ionic.de>                */
/* Copyright (c) 2014-2016 Ulrich Sibiller <uli42@gmx.de>                 */
/* Copyright (c) 2015-2016 Qindel Group (http://www.qindel.com)           */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of the aforementioned persons and companies.             */
/*                                                                        */
/* Redistribution and use of the present software is allowed according    */
/* to terms specified in the file LICENSE which comes in the source       */
/* distribution.                                                          */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/* NOTE: This software has received contributions from various other      */
/* contributors, only the core maintainers and supporters are listed as   */
/* copyright holders. Please contact us, if you feel you should be listed */
/* as copyright holder, as well.                                          */
/*                                                                        */
/**************************************************************************/

#ifndef __Rootless_H__
#define __Rootless_H__

#include "window.h"

/*
 * The real X server's root window if we
 * are in rootless mode.
 */

extern WindowPtr nxagentRootlessWindow;

/*
 * We want to import all properties changed by external clients to
 * reflect properties of our internal windows but we must ignore
 * all the property notify events generated by our own requests.
 * For this purpose we implement a FIFO to record every change pro-
 * perty request that we dispatch. In this way, when processing a
 * property notify, we can distinguish between the notifications
 * generated by our requests from those generated by other clients
 * connected to the real X server.
 */

typedef struct
{
  Window window;
  Atom property;
} PropertyRequestRec;

extern PropertyRequestRec nxagentPropertyRequests[256];

Window nxagentRootlessWindowParent(WindowPtr pWin);

void nxagentRootlessAddTopLevelWindow(WindowPtr pWin, Window w);
void nxagentRootlessDelTopLevelWindow(WindowPtr pWin);

WindowPtr nxagentRootlessTopLevelWindow(Window w);

#ifndef _XSERVER64
void nxagentRootlessRestack(Window *toplevel, unsigned int ntoplevel);
#else
void nxagentRootlessRestack(unsigned long *toplevel, unsigned int ntoplevel);
#endif


int nxagentExportAllProperty(WindowPtr pWin);

int nxagentExportProperty(WindowPtr pWin, Atom property, Atom type, int format,
                              int mode, unsigned long nUnits, void * value);

#define MAX_RETRIEVED_PROPERTY_SIZE 256 * 1024

void nxagentImportProperty(Window window, Atom property, Atom type, int format,
                               unsigned long nitems, unsigned long bytes_after, unsigned char *buffer);

/*
 * Push last ChangeProperty to the list.
 */

void nxagentAddPropertyToList(Atom property, WindowPtr pWin);

/*
 * Check if a PropertyNotify match the top
 * of the list.
 */

Bool nxagentNotifyMatchChangeProperty(void *X);

void nxagentConfigureRootlessWindow(WindowPtr pWin, int x, int y, int w, int h, int bw,
                                        WindowPtr pSib, int stack_mode, Mask mask);

void nxagentCirculateRootlessWindows(int direction);

void nxagentFreePropertyList(void);

#endif /* __Rootless_H__ */
