// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom_Conic_HeaderFile
#define _Geom_Conic_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_Geom_Conic_HeaderFile
#include <Handle_Geom_Conic.hxx>
#endif

#ifndef _gp_Ax2_HeaderFile
#include <gp_Ax2.hxx>
#endif
#ifndef _Geom_Curve_HeaderFile
#include <Geom_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_ConstructionError;
class Standard_RangeError;
class Standard_DomainError;
class gp_Ax1;
class gp_Pnt;
class gp_Ax2;


//! The abstract class Conic describes the common <br>
//! behavior of conic curves in 3D space and, in <br>
//! particular, their general characteristics. The Geom <br>
//! package provides four concrete classes of conics: <br>
//! Geom_Circle, Geom_Ellipse, Geom_Hyperbola and Geom_Parabola. <br>
//! A conic is positioned in space with a right-handed <br>
//! coordinate system (gp_Ax2 object), where: <br>
//! - the origin is the center of the conic (or the apex in <br>
//!   the case of a parabola), <br>
//! - the origin, "X Direction" and "Y Direction" define the <br>
//!   plane of the conic. <br>
//! This coordinate system is the local coordinate <br>
//! system of the conic. <br>
//! The "main Direction" of this coordinate system is the <br>
//! vector normal to the plane of the conic. The axis, of <br>
//! which the origin and unit vector are respectively the <br>
//! origin and "main Direction" of the local coordinate <br>
//! system, is termed the "Axis" or "main Axis" of the conic. <br>
//! The "main Direction" of the local coordinate system <br>
//! gives an explicit orientation to the conic, determining <br>
//! the direction in which the parameter increases along <br>
//! the conic. The "X Axis" of the local coordinate system <br>
//! also defines the origin of the parameter of the conic. <br>
class Geom_Conic : public Geom_Curve {

public:

  //! Changes the orientation of the conic's plane. The normal <br>
//!  axis to the plane is A1. The XAxis and the YAxis are recomputed. <br>
//!  raised if the A1 is parallel to the XAxis of the conic. <br>
  Standard_EXPORT     void SetAxis(const gp_Ax1& A1) ;
  //! changes the location point of the conic. <br>
  Standard_EXPORT     void SetLocation(const gp_Pnt& P) ;
  //! changes the local coordinate system of the conic. <br>
  Standard_EXPORT     void SetPosition(const gp_Ax2& A2) ;
  //! Returns the "main Axis" of this conic. This axis is <br>
//! normal to the plane of the conic. <br>
  Standard_EXPORT     gp_Ax1 Axis() const;
  
//!  Returns the eccentricity value of the conic e. <br>
//!  e = 0 for a circle <br>
//!  0 < e < 1 for an ellipse  (e = 0 if MajorRadius = MinorRadius) <br>
//!  e > 1 for a hyperbola <br>
//!  e = 1 for a parabola <br>
//!  Exceptions <br>
//! Standard_DomainError in the case of a hyperbola if <br>
//! its major radius is null. <br>
  Standard_EXPORT   virtual  Standard_Real Eccentricity() const = 0;
  
//!  Returns the location point of the conic. <br>
//!  For the circle, the ellipse and the hyperbola it is the center of <br>
//!  the conic. For the parabola it is the Apex of the parabola. <br>
  Standard_EXPORT     gp_Pnt Location() const;
  
//!  Returns the local coordinates system of the conic. <br>
//!  The main direction of the Axis2Placement is normal to the <br>
//!  plane of the conic. The X direction of the Axis2placement <br>
//!  is in the plane of the conic and corresponds to the origin <br>
//!  for the conic's parametric value u. <br>
  Standard_EXPORT    const gp_Ax2& Position() const;
  
//! Returns the XAxis of the conic. <br>
//! This axis defines the origin of parametrization of the conic. <br>
//! This axis is perpendicular to the Axis of the conic. <br>
//! This axis and the Yaxis define the plane of the conic. <br>
  Standard_EXPORT     gp_Ax1 XAxis() const;
  
//!  Returns the YAxis of the conic. <br>
//!  The YAxis is perpendicular to the Xaxis. <br>
//!  This axis and the Xaxis define the plane of the conic. <br>
  Standard_EXPORT     gp_Ax1 YAxis() const;
  
//!  Reverses the direction of parameterization of <me>. <br>
//!  The local coordinate system of the conic is modified. <br>
  Standard_EXPORT     void Reverse() ;
  //! Returns the  parameter on the  reversed  curve for <br>
//!          the point of parameter U on <me>. <br>
//! <br>
  Standard_EXPORT   virtual  Standard_Real ReversedParameter(const Standard_Real U) const = 0;
  //! The continuity of the conic is Cn. <br>
  Standard_EXPORT     GeomAbs_Shape Continuity() const;
  //! Returns True. <br>//! Raised if N < 0. <br>
  Standard_EXPORT     Standard_Boolean IsCN(const Standard_Integer N) const;




  DEFINE_STANDARD_RTTI(Geom_Conic)

protected:


gp_Ax2 pos;


private: 




};





// other Inline functions and methods (like "C++: function call" methods)


#endif
