// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectCombine_HeaderFile
#define _IFSelect_SelectCombine_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_IFSelect_SelectCombine_HeaderFile
#include <Handle_IFSelect_SelectCombine.hxx>
#endif

#ifndef _IFSelect_TSeqOfSelection_HeaderFile
#include <IFSelect_TSeqOfSelection.hxx>
#endif
#ifndef _IFSelect_Selection_HeaderFile
#include <IFSelect_Selection.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_IFSelect_Selection_HeaderFile
#include <Handle_IFSelect_Selection.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class IFSelect_Selection;
class IFSelect_SelectionIterator;


//! A SelectCombine type Selection defines algebraic operations <br>
//!           between results of several Selections <br>
//!           It is a deferred class : sub-classes will have to define <br>
//!           precise what operator is to be applied <br>
class IFSelect_SelectCombine : public IFSelect_Selection {

public:

  //! Returns the count of Input Selections <br>
  Standard_EXPORT     Standard_Integer NbInputs() const;
  //! Returns an Input Selection, given its rank in the list <br>
  Standard_EXPORT     Handle_IFSelect_Selection Input(const Standard_Integer num) const;
  //! Returns the rank of an input Selection, 0 if not in the list. <br>
//!           Most generally, its value is meaningless, except for testing <br>
//!           the presence of an input Selection : <br>
//!           - == 0  if <sel> is not an input for <me> <br>
//!           - >  0  if <sel> is an input for <me> <br>
  Standard_EXPORT     Standard_Integer InputRank(const Handle(IFSelect_Selection)& sel) const;
  //! Adds a Selection to the filling list <br>
//!           By default, adds it to the end of the list <br>
//!           A Positive rank less then NbInputs gives an insertion rank <br>
//!           (InsertBefore : the new <atnum>th item of the list is <sel>) <br>
  Standard_EXPORT     void Add(const Handle(IFSelect_Selection)& sel,const Standard_Integer atnum = 0) ;
  //! Removes an input Selection. <br>
//!           Returns True if Done, False, if <sel> is not an input for <me> <br>
  Standard_EXPORT     Standard_Boolean Remove(const Handle(IFSelect_Selection)& sel) ;
  //! Removes an input Selection, given its rank in the list <br>
//!           Returns True if Done, False if <num> is out of range <br>
  Standard_EXPORT     Standard_Boolean Remove(const Standard_Integer num) ;
  //! Puts in an Iterator the Selections from which "me" depends <br>
//!           That is to say, the list of Input Selections <br>
  Standard_EXPORT     void FillIterator(IFSelect_SelectionIterator& iter) const;




  DEFINE_STANDARD_RTTI(IFSelect_SelectCombine)

protected:

  //! Defines an empty SelectCombine <br>
  Standard_EXPORT   IFSelect_SelectCombine();
  //! Returns always True, because RootResult gives a Unique list <br>
  Standard_EXPORT   virtual  Standard_Boolean HasUniqueResult() const;



private: 


IFSelect_TSeqOfSelection thelist;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
