// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _XCAFDoc_ColorTool_HeaderFile
#define _XCAFDoc_ColorTool_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_XCAFDoc_ColorTool_HeaderFile
#include <Handle_XCAFDoc_ColorTool.hxx>
#endif

#ifndef _Handle_XCAFDoc_ShapeTool_HeaderFile
#include <Handle_XCAFDoc_ShapeTool.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _XCAFDoc_ColorType_HeaderFile
#include <XCAFDoc_ColorType.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
class XCAFDoc_ShapeTool;
class TDF_Label;
class Standard_GUID;
class Quantity_Color;
class TDF_LabelSequence;
class TopoDS_Shape;
class TDF_Attribute;
class TDF_RelocationTable;


//! Provides tools to store and retrieve attributes (colors) <br>
//!          of TopoDS_Shape in and from TDocStd_Document <br>
//!          A Document is intended to hold different <br>
//!          attributes of ONE shape and it's sub-shapes <br>
class XCAFDoc_ColorTool : public TDF_Attribute {

public:

  
  Standard_EXPORT   XCAFDoc_ColorTool();
  //! Creates (if not exist) ColorTool. <br>
  Standard_EXPORT   static  Handle_XCAFDoc_ColorTool Set(const TDF_Label& L) ;
  
  Standard_EXPORT   static const Standard_GUID& GetID() ;
  //! returns the label under which colors are stored <br>
  Standard_EXPORT     TDF_Label BaseLabel() const;
  //! Returns internal XCAFDoc_ShapeTool tool <br>
  Standard_EXPORT    const Handle_XCAFDoc_ShapeTool& ShapeTool() ;
  //! Returns True if label belongs to a colortable and <br>
//!          is a color definition <br>
  Standard_EXPORT     Standard_Boolean IsColor(const TDF_Label& lab) const;
  //! Returns color defined by label lab <br>
//!          Returns False if the label is not in colortable <br>
//!          or does not define a color <br>
  Standard_EXPORT     Standard_Boolean GetColor(const TDF_Label& lab,Quantity_Color& col) const;
  //! Finds a color definition in a colortable and returns <br>
//!          its label if found <br>
//!          Returns False if color is not found in colortable <br>
  Standard_EXPORT     Standard_Boolean FindColor(const Quantity_Color& col,TDF_Label& lab) const;
  //! Finds a color definition in a colortable and returns <br>
//!          its label if found (or Null label else) <br>
  Standard_EXPORT     TDF_Label FindColor(const Quantity_Color& col) const;
  //! Adds a color definition to a colortable and returns <br>
//!          its label (returns existing label if the same color <br>
//!          is already defined) <br>
  Standard_EXPORT     TDF_Label AddColor(const Quantity_Color& col) const;
  //! Removes color from the colortable <br>
  Standard_EXPORT     void RemoveColor(const TDF_Label& lab) const;
  //! Returns a sequence of colors currently stored <br>
//!          in the colortable <br>
  Standard_EXPORT     void GetColors(TDF_LabelSequence& Labels) const;
  //! Sets a link with GUID defined by <type> (see <br>
//!          XCAFDoc::ColorRefGUID()) from label <L> to color <br>
//!          defined by <colorL>. Color of shape is defined following way <br>
//!          in dependance with type of color. <br>
//!          If type of color is XCAFDoc_ColorGen - then this color <br>
//!          defines default color for surfaces and curves. <br>
//!          If for shape color with types XCAFDoc_ColorSurf or XCAFDoc_ColorCurv is specified <br>
//!          then such color overrides generic color. <br>
  Standard_EXPORT     void SetColor(const TDF_Label& L,const TDF_Label& colorL,const XCAFDoc_ColorType type) const;
  //! Sets a link with GUID defined by <type> (see <br>
//!          XCAFDoc::ColorRefGUID()) from label <L> to color <Color> <br>
//!          in the colortable <br>
//!          Adds a color as necessary <br>
  Standard_EXPORT     void SetColor(const TDF_Label& L,const Quantity_Color& Color,const XCAFDoc_ColorType type) const;
  //! Removes a link with GUID defined by <type> (see <br>
//!          XCAFDoc::ColorRefGUID()) from label <L> to color <br>
  Standard_EXPORT     void UnSetColor(const TDF_Label& L,const XCAFDoc_ColorType type) const;
  //! Returns True if label <L> has a color assignment <br>
//!          of the type <type> <br>
  Standard_EXPORT     Standard_Boolean IsSet(const TDF_Label& L,const XCAFDoc_ColorType type) const;
  //! Returns label with color assigned to <L> as <type> <br>
//!          Returns False if no such color is assigned <br>
  Standard_EXPORT   static  Standard_Boolean GetColor(const TDF_Label& L,const XCAFDoc_ColorType type,TDF_Label& colorL) ;
  //! Returns color assigned to <L> as <type> <br>
//!          Returns False if no such color is assigned <br>
  Standard_EXPORT     Standard_Boolean GetColor(const TDF_Label& L,const XCAFDoc_ColorType type,Quantity_Color& color) ;
  //! Sets a link with GUID defined by <type> (see <br>
//!          XCAFDoc::ColorRefGUID()) from label <L> to color <br>
//!          defined by <colorL> <br>
//!          Returns False if cannot find a label for shape S <br>
  Standard_EXPORT     Standard_Boolean SetColor(const TopoDS_Shape& S,const TDF_Label& colorL,const XCAFDoc_ColorType type) ;
  //! Sets a link with GUID defined by <type> (see <br>
//!          XCAFDoc::ColorRefGUID()) from label <L> to color <Color> <br>
//!          in the colortable <br>
//!          Adds a color as necessary <br>
//!          Returns False if cannot find a label for shape S <br>
  Standard_EXPORT     Standard_Boolean SetColor(const TopoDS_Shape& S,const Quantity_Color& Color,const XCAFDoc_ColorType type) ;
  //! Removes a link with GUID defined by <type> (see <br>
//!          XCAFDoc::ColorRefGUID()) from label <L> to color <br>
//!          Returns True if such link existed <br>
  Standard_EXPORT     Standard_Boolean UnSetColor(const TopoDS_Shape& S,const XCAFDoc_ColorType type) ;
  //! Returns True if label <L> has a color assignment <br>
//!          of the type <type> <br>
  Standard_EXPORT     Standard_Boolean IsSet(const TopoDS_Shape& S,const XCAFDoc_ColorType type) ;
  //! Returns label with color assigned to <L> as <type> <br>
//!          Returns False if no such color is assigned <br>
  Standard_EXPORT     Standard_Boolean GetColor(const TopoDS_Shape& S,const XCAFDoc_ColorType type,TDF_Label& colorL) ;
  //! Returns color assigned to <L> as <type> <br>
//!          Returns False if no such color is assigned <br>
  Standard_EXPORT     Standard_Boolean GetColor(const TopoDS_Shape& S,const XCAFDoc_ColorType type,Quantity_Color& color) ;
  //! Return TRUE if object on this label is visible, FALSE if invisible. <br>
  Standard_EXPORT     Standard_Boolean IsVisible(const TDF_Label& L) const;
  //! Set the visibility of object on label. Do nothing if there no any object. <br>
//!          Set UAttribute with corresponding GUID. <br>
  Standard_EXPORT     void SetVisibility(const TDF_Label& shapeLabel,const Standard_Boolean isvisible = Standard_True) ;
  //! Sets the color of component that styled with SHUO structure <br>
//!          Returns FALSE if no sush component found <br>
//!          NOTE: create SHUO structeure if it is necessary and if <isCreateSHUO> <br>
  Standard_EXPORT     Standard_Boolean SetInstanceColor(const TopoDS_Shape& theShape,const XCAFDoc_ColorType type,const Quantity_Color& color,const Standard_Boolean isCreateSHUO = Standard_True) ;
  //! Gets the color of component that styled with SHUO structure <br>
//!          Returns FALSE if no sush component or color type <br>
  Standard_EXPORT     Standard_Boolean GetInstanceColor(const TopoDS_Shape& theShape,const XCAFDoc_ColorType type,Quantity_Color& color) ;
  //! Gets the visibility status of component that styled with SHUO structure <br>
//!          Returns FALSE if no sush component <br>
  Standard_EXPORT     Standard_Boolean IsInstanceVisible(const TopoDS_Shape& theShape) ;
  //! Reverses order in chains of TreeNodes (from Last to First) under <br>
//!          each Color Label since we became to use function ::Prepend() <br>
//!          instead of ::Append() in method SetColor() for acceleration <br>
  Standard_EXPORT     Standard_Boolean ReverseChainsOfTreeNodes() ;
  
  Standard_EXPORT    const Standard_GUID& ID() const;
  
  Standard_EXPORT     void Restore(const Handle(TDF_Attribute)& with) ;
  
  Standard_EXPORT     Handle_TDF_Attribute NewEmpty() const;
  
  Standard_EXPORT     void Paste(const Handle(TDF_Attribute)& into,const Handle(TDF_RelocationTable)& RT) const;




  DEFINE_STANDARD_RTTI(XCAFDoc_ColorTool)

protected:




private: 


Handle_XCAFDoc_ShapeTool myShapeTool;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
