/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#include "continuousgesturearea.h"

#include "gestureevent.h"

ContinuousGestureArea::ContinuousGestureArea(QDeclarativeItem* parent,
                                             Primitive primitive)
  : GestureArea(parent, primitive),
    active_(false) {
}

bool ContinuousGestureArea::IsGestureEventHandled(GestureEvent* event) {
  bool handled = GestureArea::IsGestureEventHandled(event);

  emit gestureStart(event);
  active_ = true;
  emit activeChanged();
  return (handled || receivers(SIGNAL(activeChanged())) > 0 ||
          receivers(SIGNAL(gestureStart(GestureEvent*))) > 0 ||
          receivers(SIGNAL(gestureUpdate(GestureEvent*))) > 0 ||
          receivers(SIGNAL(gestureEnd(GestureEvent*))) > 0) &&
         event->accepted();
}

void ContinuousGestureArea::HandleGestureUpdateEvent(bool end,
                                                     GestureEvent* event) {
  GestureArea::HandleGestureUpdateEvent(end, event);

  if (end) {
    active_ = false;
    emit activeChanged();
    emit gestureEnd(event);
  } else {
    emit gestureUpdate(event);
  }
}
