#!/bin/sh

# container-tools - Manage systemd-nspawn containers
#
# Description: example for automated Debian base system container image creation
# Requires:    debootstrap plzip xz-utils
# Usage:       sudo ./container-images.sh

set -e

ARCHITECTURES="amd64 i386"
DISTRIBUTIONS="stretch sid"
MIRROR="https://deb.debian.org/debian"
INCLUDE="dbus"

COMPRESSIONS="gz lz xz"

VERSION="$(date +%Y%m%d)"

for DISTRIBUTION in ${DISTRIBUTIONS}
do
	for ARCHITECTURE in ${ARCHITECTURES}
	do
		SYSTEM="debian-${DISTRIBUTION}-${VERSION}_${ARCHITECTURE}"

		debootstrap --arch=${ARCHITECTURE} --include=${INCLUDE} ${DISTRIBUTION} ${SYSTEM} ${MIRROR}
		chroot "${SYSTEM}" apt-get clean

		rm -f "${SYSTEM}/etc/apt/apt.conf.d/01autoremove-kernels"
		rm -f "${SYSTEM}/etc/hostname"
		echo "" > "${SYSTEM}/etc/machine-id"
		rm -f "${SYSTEM}/etc/resolv.conf"
		rm -f "${SYSTEM}/var/lib/systemd/catalog/database"

		for COMPRESSION in ${COMPRESSIONS}
		do
			case "${COMPRESSION}" in
				gz)
					TAR_OPTIONS="--gzip"
					;;

				lz)
					TAR_OPTIONS="--lzip"
					;;

				xz)
					TAR_OPTIONS="--xz"
					;;
			esac

			echo "Creating ${SYSTEM}.system.tar.${COMPRESSION}"
			tar ${TAR_OPTIONS} -cf "${SYSTEM}.system.tar.${COMPRESSION}" "${SYSTEM}"

			echo "Creating ${SYSTEM}.system.tar.${COMPRESSION}.sha512"
			sha512sum "${SYSTEM}.system.tar.${COMPRESSION}" > "${SYSTEM}.system.tar.${COMPRESSION}.sha512"

			echo "Creating ${SYSTEM}.system.tar.${COMPRESSION} symlink"
			ln -sf "${SYSTEM}.system.tar.${COMPRESSION}" "$(echo ${SYSTEM}.system.tar.${COMPRESSION} | sed -e "s|${VERSION}|current|")"

			echo "Creating ${SYSTEM}.system.tar.${COMPRESSION}.sha512 copy"
			sed -e "s|${VERSION}|current|" "${SYSTEM}.system.tar.${COMPRESSION}.sha512" > "$(echo ${SYSTEM}.system.tar.${COMPRESSION}.sha512 | sed -e "s|${VERSION}|current|")"
		done

		rm -rf "${SYSTEM}"
	done
done
