/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_OperatingSystemStatisticsAccess.h"

int OS_OpenDRIM_OperatingSystemStatistics_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(OS_OpenDRIM_OperatingSystem_load(broker, errorMessage));
	CF_assert(OS_OpenDRIM_OperatingSystemLoadAverages_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(OS_OpenDRIM_OperatingSystem_unload(errorMessage));
	CF_assert(OS_OpenDRIM_OperatingSystemLoadAverages_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_isAssociated(const Instance& Element, const Instance& Stats, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystemStatistics>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateElements(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateElements(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		OS_OpenDRIM_OperatingSystemStatistics_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Element_classnames[0], Stats_classnames[0],
			Element_role.c_str(), Stats_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_referenceElementToStats(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystemStatistics& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Element_objectpath;
	instance.getElement(Element_objectpath);
	Instance Element_instance;
	CF_assert(OS_OpenDRIM_OperatingSystemStatistics_getElement(broker, ctx, Element_objectpath, Element_instance, NULL, errorMessage));
	
	Objectpath Stats_objectpath;
	instance.getStats(Stats_objectpath);
	Instance Stats_instance;
	CF_assert(OS_OpenDRIM_OperatingSystemStatistics_getStats(broker, ctx, Stats_objectpath, Stats_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(OS_OpenDRIM_OperatingSystemStatistics_isAssociated(Element_instance, Stats_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemStatistics& newInstance, const OpenDRIM_OperatingSystemStatistics& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemStatistics_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemStatistics& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemStatistics_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemStatistics& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemStatistics_associatorElementToStats(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const char** properties, vector<Instance>& Stats_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Stats_instances;
	if (discriminant=="a")
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateStatss(broker, ctx, Stats_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateStatss(broker, ctx, Stats_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateStatss(broker, ctx, Stats_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Stats_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_isAssociated(Element_instance, Stats_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Stats_associatedInstances.push_back(Stats_instances[i]);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_associatorStatsToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Stats_instance, const char** properties, vector<Instance>& Element_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Element_instances;
	if (discriminant=="a")
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateElements(broker, ctx, Element_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateElements(broker, ctx, Element_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(OS_OpenDRIM_OperatingSystemStatistics_enumerateElements(broker, ctx, Element_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Element_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(OS_OpenDRIM_OperatingSystemStatistics_isAssociated(Element_instances[i], Stats_instance, isAssociated, errorMessage));
		if (isAssociated)
			Element_associatedInstances.push_back(Element_instances[i]);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_referenceElementToStats(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Element_instance, const vector<Instance>& Stats_instances, vector<OpenDRIM_OperatingSystemStatistics>& OpenDRIM_OperatingSystemStatistics_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Stats_instances.size(); i++) {
		OpenDRIM_OperatingSystemStatistics instance;
		instance.setElement(((Instance) Element_instance).getObjectpath());
		instance.setStats(((Instance) Stats_instances[i]).getObjectpath());
		
		OpenDRIM_OperatingSystemStatistics_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_referenceStatsToElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Stats_instance, const vector<Instance>& Element_instances, vector<OpenDRIM_OperatingSystemStatistics>& OpenDRIM_OperatingSystemStatistics_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Element_instances.size(); i++) {
		OpenDRIM_OperatingSystemStatistics instance;
		instance.setElement(((Instance) Element_instances[i]).getObjectpath());
		instance.setStats(((Instance) Stats_instance).getObjectpath());
		
		OpenDRIM_OperatingSystemStatistics_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemStatistics_populate(OpenDRIM_OperatingSystemStatistics& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

