"computeTestChiSquaredUserDefined" <-
function(numericalSample, x_i, p_i, testLevel = 0.95, estimatedParameters) {

  # Putting numericaSample in the correct form. 
  xCount <- NULL
  
  for (i in min(numericalSample) : max(numericalSample)) {

    testPresent <- sum(numericalSample == i)

    if (testPresent > 0) {

      if(!any(x_i[[1]] == i)) { 
        stop('Values outside the range!')
      }

      xCount <- c(xCount, testPresent)  
    }  
  }

  # This uses the chisq.test function from the R "stats" package.
  testChiSquared <- chisq.test(xCount, p = p_i[[1]])    
  
  testResult <- ifelse(testChiSquared$p.value > 1 - testLevel, 1, 0)
  return(list(test = "ChiSquaredUserDefined",
              testResult = testResult,
              threshold = 1 - testLevel,
              pValue = testChiSquared$p.value))
}

