///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/** 
 * \file MainMenu.h 
 * \brief Contains the definition of the Core::MainMenu class. 
 */

#include <core/Core.h>

namespace Core {

/**
 * \brief The menu bar of the MainFrame window.
 * 
 * The main menu can be accessed trough the MainFrame::mainMenu() method.
 * 
 * \author Alexander Stukowski
 */
class CORE_DLLEXPORT MainMenu : public QMenuBar
{
	Q_OBJECT
	
public:

	/// Returns the File menu of the main window.
	QMenu* fileMenu() { return _fileMenu; }
	
	/// Returns the Edit menu of the main window.
	QMenu* editMenu() { return _editMenu; }
	
	/// Returns the Render menu of the main window.	
	QMenu* renderMenu() { return _renderMenu; }
	
	/// Returns the Options menu of the main window.
	QMenu* optionsMenu() { return _optionsMenu; }
	
	/// Returns the Help menu of the main window.
	QMenu* helpMenu() { return _helpMenu; }

private:

	/// Constructor that builds the main menu.
	MainMenu(QWidget* parentWindow);

	QMenu* _fileMenu;
	QMenu* _editMenu;
	QMenu* _renderMenu;
	QMenu* _optionsMenu;
	QMenu* _helpMenu;
	
	friend class MainFrame;
};


};
