from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


AttenuatorsTable = _Mock()

ConcentrationsWidget = _Mock()

ConfigDict = _Mock()

Elements = _Mock()

EnergyTable = _Mock()

FitParamHeaders = _Mock()

FitParamSections = _Mock()

Icons = _Mock()

PyMcaDirs = _Mock()

ScanWindow = _Mock()

StripBackgroundWidget = _Mock()

XRFMCPyMca = _Mock()

copy = _Mock()

numpy = _Mock()

openDialog = _Mock()

openWidget = _Mock()

os = _Mock()

qt = _Mock()

sys = _Mock()

DEBUG = 0

QTVERSION = '4.8.6'

QWT = _Mock()

SCANWINDOW = _Mock()

XRFMC_FLAG = _Mock()

class FitParamDialog(_Mock):
  pass
  Accepted = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rejected = 0

class FitParamForm(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class FitParamWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class FitPeakSelect(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class SectionFileDialog(_Mock):
  pass
  Accept = 3
  AcceptOpen = 0
  AcceptSave = 1
  Accepted = 1
  AnyFile = 0
  Detail = 0
  Directory = 2
  DirectoryOnly = 4
  DontConfirmOverwrite = 4
  DontResolveSymlinks = 2
  DontUseCustomDirectoryIcons = 128
  DontUseNativeDialog = 16
  DontUseSheet = 8
  DrawChildren = 2
  DrawWindowBackground = 1
  ExistingFile = 1
  ExistingFiles = 3
  FileName = 1
  FileType = 2
  HideNameFilterDetails = 64
  IgnoreMask = 4
  List = 1
  LookIn = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  ReadOnly = 32
  Reject = 4
  Rejected = 0
  ShowDirsOnly = 1

class SectionFileWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

