from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


PlotBackend = _Mock()

QtCore = _Mock()

QtGui = _Mock()

_utils = _Mock()

cbook = _Mock()

cm = _Mock()

main = _Mock()

matplotlib = _Mock()

nanmax = _Mock()

nanmin = _Mock()

numpy = _Mock()

numpyvstack = _Mock()

patches = _Mock()

sys = _Mock()

time = _Mock()

types = _Mock()

BLITTING = _Mock()

DEBUG = 0

QT = _Mock()

TK = _Mock()

class AxesImage(_Mock):
  pass
  aname = u'Artist'
  k = u'spline16'
  zorder = 0

class Cursor(_Mock):
  pass
  _active = True
  drawon = True
  eventson = True

class Figure(_Mock):
  pass
  aname = u'Artist'
  zorder = 0

class FigureCanvas(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  supports_blit = True

class FontProperties(_Mock):
  pass


class Line2D(_Mock):
  pass
  aname = u'Artist'
  zorder = 2

class LinearSegmentedColormap(_Mock):
  pass


class LogNorm(_Mock):
  pass


class MatplotlibBackend(_Mock):
  pass


class MatplotlibGraph(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  supports_blit = True

class ModestImage(_Mock):
  pass
  aname = u'Artist'
  k = u'spline16'
  zorder = 0

class NonUniformImage(_Mock):
  pass
  aname = u'Artist'
  k = u'spline16'
  zorder = 0

class Normalize(_Mock):
  pass


class PathCollection(_Mock):
  pass
  _factor = 1.0
  aname = u'Artist'
  zorder = 0

class Polygon(_Mock):
  pass
  aname = u'Artist'
  zorder = 1

class Rectangle(_Mock):
  pass
  aname = u'Artist'
  zorder = 1

class Text(_Mock):
  pass
  aname = u'Artist'
  zorder = 3

